/*
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
PROFIL3.C (PROFILE procedures)


AUTHOR(s): Craig Muller 1992

Decription:

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*/
#include <windows.h>

#pragma hdrstop

#include <stdio.h>
#include <string.h>
#include "iwf.h"

// Defines.
#define  MODULENAME "Render"
#define  CLASSNAME  MODULENAME"Popup"

//=======================================
// Exported procedures.
//=======================================
long far PASCAL _export WP_Render(HWND hWnd,WORD wMsg,WORD wParam,LONG lParam);
BOOL FAR PASCAL _export DP_Render(HWND hDlg,WORD wMsg,WORD wParam,LONG lParam);

//-------------------------------------
// Private procedures.
//-------------------------------------
void CreateThermoPalEntry(PALETTEENTRY *peThermo);
static void render(HDC hDC,IMAGE *image);

// Flags

// Private variables.
static int resolutions[]={1,2,5,10};
static int polyres =3;
static int usecolor=TRUE;
static int usegrid =TRUE;

static HPALETTE hPalColor;             // Handle to color scale palette

static HWND hWndRender=NULL;           // Render user window handle.

static HINSTANCE hInst;                  // Application instance handle.

/*
---------------------------------------------------------------------
fb_setpalette()
~~~~~~~~~~~~~~~~

DESCRIPTION:
---------------------------------------------------------------------
*/
void fb_SetPaletteEntries(IMAGE *image,int iStart,int cEntries,PALETTEENTRY *pe)
	{
	int i;

	for (i=0; i<cEntries; i++)
		{
		image->LUT[iStart+i].peRed   = pe[i].peRed;
		image->LUT[iStart+i].peGreen = pe[i].peGreen;
		image->LUT[iStart+i].peBlue  = pe[i].peBlue;
		image->LUT[iStart+i].peFlags = pe[i].peFlags;
		}
	}

/*
--------------------------------------------------------------------------
Render()
~~~~~~~~

PROFILER STARTUP PROCESSING PROCEDURE.
This is called when the user selects this option from the main menu.
This procedure check to see if the popup window exists. If so it simply
passes focus to the window and returns since there is nothing more to do.
If it does not exist then it proceeds to create the popup window and menu
and displays it on the screen. The popup window acts like a sub-program
within the main program and receives messages from the main program.
--------------------------------------------------------------------------
*/
void Render(HWND hWndParent)
   {
   char   msg[80];
   WNDCLASS  wc;

   // If an instance exists then set focus to that instance and return.
   if (IsWindow(hWndRender))
      {
      ShowWindow(hWndRender,SW_SHOW);
      SetFocus(hWndRender);
      return;
      }

   hInst = GetWindowWord(hWndParent,GWW_HINSTANCE);

   // Register a new window class for the popup window.
   if (!GetClassInfo(hInst,CLASSNAME,&wc))
      {
      memset(&wc,0,sizeof(WNDCLASS));            // Zero init structure.

      wc.lpszClassName = CLASSNAME;              // Name for CreateWindow.
      wc.style         = CS_SAVEBITS;            // Extra style parameters.
      wc.lpfnWndProc   = (WNDPROC)WP_Render;     // Func to get msgs
      wc.hInstance     = hInst;                  // App that owns the class
      wc.hIcon         = LoadIcon(hInst,MODULENAME);
      wc.lpszMenuName  = MODULENAME;
      wc.hbrBackground = GetStockObject(LTGRAY_BRUSH);

      if (!RegisterClass(&wc))                   // Initialize new window class.
         {
         char sz[80];

         sprintf(sz,"RegisterClass() failure! -> %s",CLASSNAME);
         MessageBeep(MB_ICONEXCLAMATION);
         MessageBox(NULL,sz,NULL,MB_OK | MB_ICONEXCLAMATION);
         return;                                 // Exit on failure
         }
      }

   // Window class is registered, now create an window from the class.
   hWndRender = CreateWindow(CLASSNAME,MODULENAME,
                             WS_POPUPWINDOW | WS_CAPTION | WS_MINIMIZEBOX,
                            200,100,770,400,hWndParent,NULL,hInst,NULL);
   if (hWndRender)
      {
      ShowWindow(hWndRender,SW_SHOW);
      SetFocus(hWndRender);
      }
   else
      {
      sprintf(msg,"CreateWindow() failure! -> %s",CLASSNAME);
      MessageBeep(MB_ICONEXCLAMATION);
		MessageBox(NULL,msg,NULL,MB_OK | MB_ICONEXCLAMATION);
      }
   }



/*
---------------------------------------------------------------------
long far PASCAL _export WP_Render(HWND hWnd,WORD wMsg,WORD wParam,LONG lParam);

Description:

Local Window Procedure for processing image analysis. This is
registered in the header module.h.

This procedure handles a subset of the Windows message loop for
processing input messages.
---------------------------------------------------------------------
*/
long far PASCAL _export WP_Render(HWND hWnd,WORD wMsg,WORD wParam,LONG lParam)
   {
   IMAGE *image;

   if (IsWindow(hWndSrc))
      image = (IMAGE *)GetWindowWord(hWndSrc,2);       // Get attached data set.
   else
      image = NULL;

   switch (wMsg)
      {
      case WM_CREATE:
      hWndMod = hWnd;                            // Make this module active.
      break;

      case WM_PAINT:
      {
      PAINTSTRUCT ps;

      BeginPaint(hWnd,&ps);
      EndPaint(hWnd,&ps);
      }
      break;

      case WM_COMMAND:
      if (!image)
         {
         MessageBox(NULL,"No image is selected.","Render Tool",MB_OK);
         break;
         }

      switch (wParam)
	      {
         case 110:
         {
         RECT rc;
         HDC hDC;

         hDC = GetDC(hWnd);
         SelectPalette(hDC,hPalMain,FALSE);       // Select palette into DC
         RealizePalette(hDC);                    // Map to system palette.

		   GetClientRect(hWnd,&rc);
		   FillRect(hDC,&rc,GetStockObject(LTGRAY_BRUSH));
         render(hDC,image);                      // Render the 3D profile.

         ReleaseDC(hWnd,hDC);
         }
         break;

	      case 120:
         CallDialogBox(hWnd,DP_Render,MODULENAME);
         break;
         }
      break;

      case WM_SETFOCUS:                          // FOCUS HAS BEEN SET.
      if (FlashWindow(hWnd,TRUE))
         FlashWindow(hWnd,TRUE);                 // Make this module active.
      hWndMod = hWnd;                            // Make this module active.
      BringWindowToTop(hWnd);                    // Bring this module to top.
      InvalidateRect(hWnd,NULL,FALSE);           // Invalidate this image.
      UpdateWindow(hWnd);                        // Update this image.
      break;

      case WM_KILLFOCUS:                         // FOCUS HAS BEEN KILLED.
      break;

      case WM_DESTROY:                           // DESTROY WINDOW.
      DeleteObject(hPalColor);                   // Delete color scale palette.
      break;

      default:                                   // Pass on if unprocessed.
      return(DefWindowProc(hWnd, wMsg, wParam, lParam));
      }

   lParam=lParam;

   return(NULL);
   }


void Project(int x,int y,int z,POINT *pt)
   {
   pt->x = 240 + x - y/2;
   pt->y = y/2 - z/2;
   }

/*
------------------------------------------------------------------------------
FUNCTION: void Render(HWND hWnd)

PURPOSE :
Transfers the contents to the display device for display.

COMMENTS:
------------------------------------------------------------------------------
*/
void render(HDC hDC,IMAGE *image)
   {
   int         size,x,y,xoff,yoff;
   BYTE        r,g,b,z,z0,z1,z2,z3;
   POINT       pt[4];
   HBRUSH      hBrush,hOldBrush;
   HPEN        hPen,hOldPen;

   ShowCursor(FALSE);

   size=resolutions[polyres];
   xoff = 3;
   yoff = 375-240;
   SelectObject(hDC,GetStockObject(BLACK_PEN));

   Project(  0,  0,  0,&pt[0]);  MoveTo(hDC,xoff+pt[0].x,yoff+pt[0].y);
   Project(511,  0,  0,&pt[0]);  LineTo(hDC,xoff+pt[0].x,yoff+pt[0].y);
   Project(511,479,  0,&pt[0]);  LineTo(hDC,xoff+pt[0].x,yoff+pt[0].y);
   Project(  0,479,  0,&pt[0]);  LineTo(hDC,xoff+pt[0].x,yoff+pt[0].y);
   Project(  0,  0,  0,&pt[0]);  LineTo(hDC,xoff+pt[0].x,yoff+pt[0].y);

   for (y=image->vres-1-size; y>=0; y-=size)
      for (x=0; x<image->hres-1-size; x+=size)
         {
         GetImagePixel(image,x     ,image->vres-1-y   ,&z0);
         GetImagePixel(image,x+size,image->vres-1-y   ,&z1);
         GetImagePixel(image,x+size,image->vres-1-(y+size),&z2);
			GetImagePixel(image,x     ,image->vres-1-(y+size),&z3);

         z = (int)(z0+z1+z2+z3)/4;
         r = image->LUT[z].peRed;
         g = image->LUT[z].peGreen;
         b = image->LUT[z].peBlue;

         z0 = (int)(image->LUT[z0].peRed+image->LUT[z0].peGreen+image->LUT[z0].peBlue)/3;
         z1 = (int)(image->LUT[z1].peRed+image->LUT[z1].peGreen+image->LUT[z1].peBlue)/3;
         z2 = (int)(image->LUT[z2].peRed+image->LUT[z2].peGreen+image->LUT[z2].peBlue)/3;
         z3 = (int)(image->LUT[z3].peRed+image->LUT[z3].peGreen+image->LUT[z3].peBlue)/3;

         z0/=2; z1/=2; z2/=2; z3/=2;

         //hPen   = CreatePen(PS_SOLID,1,PALETTEINDEX(usecolor*64 + z/(4+usegrid*2)));
         //hBrush = CreateSolidBrush(PALETTEINDEX(usecolor*64 + z/4));
         hPen   = CreatePen(PS_SOLID,1,PALETTERGB(r/2,g/2,b/2));
         hBrush = CreateSolidBrush(PALETTERGB(r,g,b));
         hOldPen   = SelectObject(hDC,hPen);
         hOldBrush = SelectObject(hDC,hBrush);

         pt[0].x = x+y/2       ; pt[0].y = 380-z0-y/2;
         pt[1].x = x+y/2+size  ; pt[1].y = 380-z1-y/2;
         pt[2].x = x+y/2+2*size; pt[2].y = 380-z2-(y/2+size);
         pt[3].x = x+y/2+size  ; pt[3].y = 380-z3-(y/2+size);

         Polygon(hDC,pt,4);

         SelectObject(hDC,hOldBrush);
         SelectObject(hDC,hOldPen  );
         DeleteObject(hBrush);
         DeleteObject(hPen  );
         }

   SelectObject(hDC,GetStockObject(BLACK_PEN));

   Project(  0,  0,255,&pt[0]);  MoveTo(hDC,xoff+pt[0].x,yoff+pt[0].y);
   Project(511,  0,255,&pt[0]);  LineTo(hDC,xoff+pt[0].x,yoff+pt[0].y);
   Project(511,479,255,&pt[0]);  LineTo(hDC,xoff+pt[0].x,yoff+pt[0].y);
   Project(  0,479,255,&pt[0]);  LineTo(hDC,xoff+pt[0].x,yoff+pt[0].y);
   Project(  0,  0,255,&pt[0]);  LineTo(hDC,xoff+pt[0].x,yoff+pt[0].y);

   ShowCursor(TRUE);
   }



/*
========================================
Dialog Box Procedures.
========================================
*/

#define IDD_RBPOLY1     101
#define IDD_RBPOLY2     102
#define IDD_RBPOLY5     103
#define IDD_RBPOLY10    104
#define IDD_RBGRAY      106
#define IDD_RBCOLOR     107
#define IDD_CBGRID      109


/*
==========================================================================
BOOL FAR PASCAL _export DP_Render(HWND hDlg,unsigned msg,WORD wParam,LONG lParam)

PURPOSE:
Dialog Box Procedure for selecting various options in
the 3D viewing procedure.
==========================================================================
*/
BOOL FAR PASCAL _export DP_Render(HWND hDlg,WORD wMsg,WORD wParam,LONG lParam)
   {
   static int PolySize;
   static int PalType;

   switch (wMsg)
      {
      case WM_PAINT:
      {
      PAINTSTRUCT ps;
      RECT rc;
      HBRUSH hBrush;

      BeginPaint(hDlg,&ps);

      GetClientRect(hDlg,&rc);
      hBrush = GetStockObject(LTGRAY_BRUSH);
      FillRect(ps.hdc,&rc,hBrush);

      EndPaint(hDlg,&ps);
      }
      break;

      case WM_INITDIALOG:                        /* message: initialize    */
      PolySize = IDD_RBPOLY1 + polyres;
      PalType  = IDD_RBGRAY + usecolor;
      CheckRadioButton(hDlg,IDD_RBPOLY1,IDD_RBPOLY10,PolySize);
      CheckRadioButton(hDlg,IDD_RBGRAY,IDD_RBCOLOR,PalType);
      CheckDlgButton(hDlg,IDD_CBGRID,usegrid);
      SetFocus(GetDlgItem(hDlg,PalType));
      return (FALSE);                /* Indicates focus is set to a control */

      case WM_COMMAND:
      switch (wParam)
         {
         case IDOK:
         usegrid = IsDlgButtonChecked(hDlg,IDD_CBGRID);
         EndDialog(hDlg, TRUE);
         return (TRUE);

         case IDCANCEL:
         usegrid = IsDlgButtonChecked(hDlg,IDD_CBGRID);
         EndDialog(hDlg, NULL);
         return (FALSE);

         case IDD_RBPOLY1:
         case IDD_RBPOLY2:
         case IDD_RBPOLY5:
         case IDD_RBPOLY10:
         PolySize = wParam;
         polyres = wParam - IDD_RBPOLY1;
         CheckRadioButton(hDlg,IDD_RBPOLY1,IDD_RBPOLY10,PolySize);
         return (TRUE);

         case IDD_RBGRAY:
         case IDD_RBCOLOR:
         PalType = wParam;
         usecolor = wParam - IDD_RBGRAY;
         CheckRadioButton(hDlg,IDD_RBGRAY,IDD_RBCOLOR,PalType);
         return (TRUE);
         }
      break;
      }

   lParam=lParam;

   return FALSE;
   }


/*
-------------------------------------------------------------------------------
      Create a Color Scale palette and returns a handle to the
      newly created palette. The color intensity ramps for this
      palette are shown by the graphs below.
                        _____
                       /
                      /
                     /
       Red  ________/
            0  16  32  48  64
                    ____
                   /    \
                  /      \
                 /        \
       Green____/          \
            0  16  32  48  64
                ____
               /    \
              /      \
             /        \
       Blue /          \_____
            0  16  32  48  64
-------------------------------------------------------------------------------
*/

