// Copyright Maurizio Maccani - 1994
#include <windows.h>
#include <windowsx.h>
#include <stdlib.h>
#include "test.h"

#include "interLib.h" // This include is needed to use the library

// language definitions
#define ITALIAN  	 0X0500L
#define ENGLISH  	 0X0400L
#define DANISH  	 0X0100L
#define FINNISH  	 0X0200L
#define FRENCH  	 0X0300L
#define ICELAND  	 0X0600L
#define NORWEGIAN  	 0X0700L
#define DUTCH 		 0X0800L
#define PORTUGUESE   0X0900L
#define SPANISH      0X0A00L
#define SWEDISH      0X0B00L
#define GERMAN       0X0C00L

BOOL FAR PASCAL __export ShowDetailsDialogProc( HWND hDlg, UINT uMsg,
                                 WPARAM wParam, LPARAM lParam );
long FAR PASCAL _export TestProc (HWND hwnd, UINT message, UINT wParam,
                              LONG lParam);
BOOL CALLBACK _export FindChildWindowsProc(HWND hwnd, LPARAM k);
HINSTANCE hInst;                               
BOOL FAR PASCAL __export TestDialogProc( HWND hDlg, UINT uMsg,
                                 WPARAM wParam, LPARAM lParam );
            
BOOL FAR PASCAL __export TestDialog1Proc( HWND hDlg, UINT uMsg,
                                 WPARAM wParam, LPARAM lParam );
            
int PASCAL WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
            LPSTR lpszCmdParam, int nCmdShow)
      {                                    
      MSG         msg ;
      WNDCLASS    wndclass ;
      hInst=hInstance;
      wndclass.style         = CS_HREDRAW | CS_VREDRAW | CS_BYTEALIGNWINDOW | CS_BYTEALIGNCLIENT | CS_GLOBALCLASS | CS_DBLCLKS;
      wndclass.cbClsExtra    = 0 ;
      wndclass.cbWndExtra    = 18 ;
      wndclass.hInstance     = hInstance ;
      wndclass.hIcon         = LoadIcon (hInstance,"icon");
      wndclass.hCursor       = LoadCursor(NULL,IDC_ARROW);
      wndclass.hbrBackground = (HBRUSH) GetStockObject(WHITE_BRUSH);
      wndclass.lpszMenuName  = "menu" ;
      wndclass.lpfnWndProc   = TestProc;
      wndclass.lpszClassName = "test" ;
      RegisterClass (&wndclass) ;
      /**********************************************/
      /* Remember to load the DLL                   */
      /**********************************************/
      
      HINSTANCE intLib = LoadLibrary("interlib.dll");
      HWND hwndHello = CreateWindow ("test",     // window class name
            "Test International Library",           // window caption
            WS_OVERLAPPEDWINDOW,     // window style
            100,100,350,320,
            NULL,                    // parent window handle
            NULL,               // window menu handle
            (HINSTANCE) hInstance,               // program instance handle
            NULL) ;                  // creation parameters
                      ShowWindow (hwndHello, SW_SHOW) ;
                      UpdateWindow (hwndHello) ;
     while (GetMessage (&msg, NULL, 0, 0))
         {
         TranslateMessage (&msg) ;
         DispatchMessage (&msg) ;
         }       
     FreeLibrary(intLib);
     return msg.wParam ;  
     }
#define OK 100                          
void DestroySubwindow(HWND);
long FAR PASCAL _export TestProc (HWND hwnd, UINT message, UINT wParam,
                              LONG lParam)
     {            
     static int mode;
     static HWND PosCurrency,PosZeroCurrency,NegCurrency,NegZeroCurrency;
     static HWND PosNumber,PosZeroNumber;
         static HWND NumberS,ZeroNumberS,NegNumber;
      static HWND date,currency,Number,timeV,timeV1,timeV2,dateA;
      switch(message)
         {                                                   
                  case WM_CREATE:
                     mode=0;
                         return 0;
          case WM_DESTROY:
             PostQuitMessage(0);
             return 0;   
          case WM_COMMAND:
             {
             switch (wParam)
                {       
             case EXIT:
                 PostQuitMessage(0);   
                 return 0;
             case CHANGE_TIMEZONE:
                SetEnvTime((LPCSTR) "PST8PDT");
                return 0;
             case CURRENCY:
                {
                 DestroySubwindow(hwnd);
                     PosCurrency = CreateWindow("Currency","545,3",WS_BORDER | WS_CHILD | WS_VISIBLE | ES_AUTOHSCROLL         ,120,20,100,25,hwnd,1,hInst,NULL);                
                     PosZeroCurrency = CreateWindow("Currency","",WS_BORDER | WS_CHILD | WS_VISIBLE | ES_AUTOHSCROLL          ,120,50,100,25,hwnd,1,hInst,NULL);                
                     NegCurrency = CreateWindow("Currency","-545,3",WS_BORDER | WS_CHILD | WS_VISIBLE | ES_AUTOHSCROLL        ,120,80,100,25,hwnd,1,hInst,NULL);                
                     NegZeroCurrency = CreateWindow("Currency","-",WS_BORDER | WS_CHILD | WS_VISIBLE | ES_AUTOHSCROLL         ,120,110,100,25,hwnd,1,hInst,NULL);                
        
                     HWND PosCurrencyS = CreateWindow("Static","Pos. Currency",WS_CHILD | WS_VISIBLE                                                       ,10,20, 100,25,hwnd,1,hInst,NULL);                
                     HWND PosZeroCurrencyS = CreateWindow("Static","Pos.0 Currency",WS_CHILD | WS_VISIBLE                                                  ,10,50, 100,25,hwnd,1,hInst,NULL);                
                     HWND NegCurrencyS = CreateWindow("Static","Neg. Currency",WS_CHILD | WS_VISIBLE                                                       ,10,80, 100,25,hwnd,1,hInst,NULL);                
                     HWND NegZeroCurrencyS = CreateWindow("Static","Neg.0 Currency",WS_CHILD | WS_VISIBLE                                                  ,10,110, 100,25,hwnd,1,hInst,NULL);                
                     UpdateWindow(hwnd);
                     mode=1;
                 return 0;
                }   
             case DATE:
                {
                 DestroySubwindow(hwnd);
                 date = CreateWindow("Date","",WS_BORDER | WS_CHILD | WS_VISIBLE                       ,120,20,100,25,hwnd,1,hInst,NULL);                
                 dateA = CreateWindow("Date","",DS_AUTODATE | WS_BORDER | WS_CHILD | WS_VISIBLE         ,120,50,100,25,hwnd,1,hInst,NULL);                
                 HWND dateB = CreateWindow("Date","",WS_BORDER | WS_CHILD | WS_VISIBLE         ,120,80,100,25,hwnd,1,hInst,NULL);                
                 HWND dateS = CreateWindow("Static","Date", WS_CHILD | WS_VISIBLE                          ,10,20, 100,25,hwnd,1,hInst,NULL);                
                 HWND dateVSS = CreateWindow("Static","AutoDate", WS_CHILD | WS_VISIBLE                            ,10,50, 100,25,hwnd,1,hInst,NULL);                
                 HWND dateBSS = CreateWindow("Static","Zero Date", WS_CHILD | WS_VISIBLE                            ,10,80, 100,25,hwnd,1,hInst,NULL);                
                 _timezone=0;
                 _daylight=0;
                 time_t t;
                 time(&t);
                 SetDateTime_t(date,t);
                 UpdateWindow(hwnd);
                 mode=3;
                 return 0;
                }   
             case DETAILS_DIALOG:
                {
                    DLGPROC showDetailsDialogProc;
                showDetailsDialogProc = (DLGPROC) MakeProcInstance((FARPROC) ShowDetailsDialogProc,hInst);
                        int ShowDetails = DialogBox(hInst,"ShowDetails",hwnd,showDetailsDialogProc);
                        FreeProcInstance(showDetailsDialogProc);
                return 0;
                }   
             case CALL_DIALOG:
                {
                    DLGPROC testDialogProc;
                testDialogProc = (DLGPROC) MakeProcInstance((FARPROC) TestDialogProc,hInst);
                        int Test = DialogBox(hInst,"DialogTest",hwnd,testDialogProc);
                        FreeProcInstance(testDialogProc);
                return 0;
                }   
             case CALL_DIALOG1:
                {
                    DLGPROC testDialogProc;
                testDialogProc = (DLGPROC) MakeProcInstance((FARPROC) TestDialog1Proc,hInst);
                        int Test = DialogBox(hInst,"DialogTest1",hwnd,testDialogProc);
                        FreeProcInstance(testDialogProc);
                return 0;
                }   
             case TIME:
                {
                 DestroySubwindow(hwnd);
                 timeV = CreateWindow("Time","",WS_BORDER | WS_CHILD | WS_VISIBLE                      ,120,20,130,25,hwnd,1,hInst,NULL);                
                 timeV1 = CreateWindow("Time","",TS_SECONDS | WS_BORDER | WS_CHILD | WS_VISIBLE           ,120,50,130,25,hwnd,1,hInst,NULL);                
                 timeV2 = CreateWindow("Time","", TS_AUTOTIME | TS_SECONDS | WS_BORDER | WS_CHILD | WS_VISIBLE,120,80,130,25,hwnd,1,hInst,NULL);                
                 HWND timeV3 = CreateWindow("Time","", TS_CLOCK | TS_SECONDS | WS_CHILD | WS_VISIBLE | ES_READONLY,120,110,130,25,hwnd,1,hInst,NULL);  
                 HWND timeV4 = CreateWindow("Time","", TS_CLOCK | WS_CHILD | WS_VISIBLE | ES_READONLY,120,140,130,25,hwnd,1,hInst,NULL);                
                 HWND timeVS = CreateWindow("Static","Time", WS_CHILD | WS_VISIBLE                                 ,10,20,100,25,hwnd,1,hInst,NULL);                
                 HWND timeV1S = CreateWindow("Static","Time Seconds",WS_CHILD | WS_VISIBLE                     ,10,50, 100,30,hwnd,1,hInst,NULL);                
                 HWND timeV2S = CreateWindow("Static","AutoTime",WS_CHILD | WS_VISIBLE             ,10,80, 100,30,hwnd,1,hInst,NULL);                
                 HWND timeV3S = CreateWindow("Static","Clock",WS_CHILD | WS_VISIBLE                    ,10,110, 100,30,hwnd,1,hInst,NULL);                
                 HWND timeV4S = CreateWindow("Static","Clock",WS_CHILD | WS_VISIBLE                    ,10,140, 100,30,hwnd,1,hInst,NULL);                
                 UpdateWindow(hwnd);
                 mode=4;
                 return 0;
                }   
             case INTEGER:
                {
                 DestroySubwindow(hwnd);
                     PosNumber = CreateWindow("Number","333,88",WS_BORDER | WS_CHILD | WS_VISIBLE                           ,120,20,100,25,hwnd,1,hInst,NULL);                
                     PosZeroNumber = CreateWindow("Number","",WS_BORDER | WS_CHILD | WS_VISIBLE                             ,120,50,100,25,hwnd,1,hInst,NULL);                
                     NegNumber = CreateWindow("Number","-333,88",WS_BORDER | WS_CHILD | WS_VISIBLE                           ,120,80,100,25,hwnd,1,hInst,NULL);                
                     NumberS = CreateWindow("Static","Number", WS_CHILD | WS_VISIBLE                                                                               ,10,20, 100,25,hwnd,1,hInst,NULL);                
                     ZeroNumberS = CreateWindow("Static","Zero Number", WS_CHILD | WS_VISIBLE                                                              ,10,50, 100,25,hwnd,1,hInst,NULL);                
                     HWND NegNumberS = CreateWindow("Static","Neg Number", WS_CHILD | WS_VISIBLE                                                   ,10,80, 100,25,hwnd,1,hInst,NULL);                
                     mode=2;
                 return 0;
                }   
             case  CURRENCY_HELP:    
                WinHelp(hwnd,"interlib.hlp",HELP_CONTEXT,0X0035);
                break;
             case  NUMBER_HELP:
                WinHelp(hwnd,"interlib.hlp",HELP_CONTEXT,0X0036);
                break;
             case  TIME_HELP:
                WinHelp(hwnd,"interlib.hlp",HELP_CONTEXT,0X0038);
                break;
             case  DATE_HELP:
                WinHelp(hwnd,"interlib.hlp",HELP_CONTEXT,0X0037);
                break;
             case  INTRODUCTION_HELP:
                WinHelp(hwnd,"interlib.hlp",HELP_CONTEXT,0X0040);
                break;
             case  ABOUT_HELP:
                {
                MessageBox(NULL,"Internationalization Library \012 Copyright Maurizio Maccani 1994","About",MB_OK);
                return 0;
                }
             case PRINT:
                {
                // Build a message Box witth the various details
                if (mode ==0) return 0;
                                char buff[40];
                LPSTR message = (LPSTR) GlobalAllocPtr(GMEM_ZEROINIT,512);
                                if(mode==3)
                                {
                tm _far tmIn;           
                GetDateTm(date,&tmIn);
                                time_t  t = GetDateTime_t(date);
                                GetDateString(date,buff);
                                lstrcat(message,"Short Date: ");
                                lstrcat(message,buff);
                                lstrcat(message,"\012\012");
                                
                                GetLongDate(tmIn,buff);
                                lstrcat(message,"long Date: ");
                                lstrcat(message,buff);
                                lstrcat(message,"\012\012");
                                GetDayName(t,  buff);
                                lstrcat(message,"Day Name: ");
                                lstrcat(message,buff);
                                lstrcat(message,"\012\012");
                                GetMonthName(t, buff);
                                lstrcat(message,"Month Name: ");
                                lstrcat(message,buff);
                                lstrcat(message,"\012\012");
                                }
                                if(mode==1)
                                {
                        		long PosDollar = GetDollar(PosCurrency);
                                int PosCentimes = GetCentimes(PosCurrency);

                                ltoa(PosDollar,buff,10);
                                lstrcat(message,"Pos Curr. Dollar Amount: ");
                                lstrcat(message,buff);
                                lstrcat(message,"\012\012");
                                
                                itoa(PosCentimes,buff,10);
                                lstrcat(message,"Pos.Curr. Centimes Amount: ");
                                lstrcat(message,buff);
                                lstrcat(message,"\012\012");
                                
                                long PosZeroDollar = GetDollar(PosZeroCurrency);
                                int PosZeroCentimes = GetCentimes(PosZeroCurrency);

                                ltoa(PosZeroDollar,buff,10);
                                lstrcat(message,"Pos. 0 Curr. Dollar Amount: ");
                                lstrcat(message,buff);
                                lstrcat(message,"\012\012");
                                
                                itoa(PosZeroCentimes,buff,10);
                                lstrcat(message,"Pos.0 Curr. Centimes: ");
                                lstrcat(message,buff);
                                lstrcat(message,"\012\012");
                                
                                long NegDollar = GetDollar(NegCurrency);
                                int NegCentimes = GetCentimes(NegCurrency);

                                ltoa(NegDollar,buff,10);
                                lstrcat(message,"Neg Curr. Dollar Amount: ");
                                lstrcat(message,buff);
                                lstrcat(message,"\012\012");
                                
                                itoa(NegCentimes,buff,10);
                                lstrcat(message,"Neg. Curr. Centimes: ");
                                lstrcat(message,buff);
                                lstrcat(message,"\012\012");
                                
                                long NegZeroDollar = GetDollar(NegZeroCurrency);
                                int NegZeroCentimes = GetCentimes(NegZeroCurrency);

                                ltoa(NegZeroDollar,buff,10);
                                lstrcat(message,"Neg.0 Curr. Dollar Amount: ");
                                lstrcat(message,buff);
                                lstrcat(message,"\012\012");
                                
                                itoa(NegZeroCentimes,buff,10);
                                lstrcat(message,"Neg.0 Curr. Centimes: ");
                                lstrcat(message,buff);
                                lstrcat(message,"\012\012");
                                }
                                if(mode==2)
                                {
                    		    long PosNumberV = GetInteger(PosNumber);
                                long PosFraction = GetFraction(PosNumber);

                                ltoa(PosNumberV,buff,10);
                                lstrcat(message,"Pos Number: ");
                                lstrcat(message,buff);
                                lstrcat(message,"\012\012");
                                
                                ltoa(PosFraction,buff,10);
                                lstrcat(message,"Pos.  Fraction: ");
                                lstrcat(message,buff);
                                lstrcat(message,"\012\012");
                                
                                long PosZeroNumberV = GetInteger(PosZeroNumber);
                                long PosZeroFraction = GetFraction(PosZeroNumber);

                                ltoa(PosZeroNumberV,buff,10);
                                lstrcat(message,"Pos. 0 Number: ");
                                lstrcat(message,buff);
                                lstrcat(message,"\012\012");
                                
                                ltoa(PosZeroFraction,buff,10);
                                lstrcat(message,"Pos.0 Fraction: ");
                                lstrcat(message,buff);
                                lstrcat(message,"\012\012");
                                
                                long NegNumberV = GetInteger(NegNumber);
                                long NegFraction = GetFraction(NegNumber);

                                ltoa(NegNumberV,buff,10);
                                lstrcat(message,"Negative Number: ");
                                lstrcat(message,buff);
                                lstrcat(message,"\012\012");
                                
                                ltoa(NegFraction,buff,10);
                                lstrcat(message,"Negative Fraction: ");
                                lstrcat(message,buff);
                                lstrcat(message,"\012\012");
                                
                                }
                                if(mode==4)
                                 {
                                int hours =GetHours(timeV);
                                int minutes =GetMinutes(timeV);
                                int seconds =GetSeconds(timeV);
                                itoa(hours,buff,10);
                                lstrcat(message,"Base Hours: ");
                                lstrcat(message,buff);
                                lstrcat(message,"\012\012");
                                
                                itoa(minutes,buff,10);
                                lstrcat(message,"Base Minutes: ");
                                lstrcat(message,buff);
                                lstrcat(message,"\012\012");

                                hours =GetHours(timeV1);
                                minutes =GetMinutes(timeV1);
                                seconds =GetSeconds(timeV1);
                                itoa(hours,buff,10);
                                lstrcat(message,"Base with Seconds Hours: ");
                                lstrcat(message,buff);
                                lstrcat(message,"\012\012");
                                
                                itoa(minutes,buff,10);
                                lstrcat(message,"Base with Seconds Minutes: ");
                                lstrcat(message,buff);
                                lstrcat(message,"\012\012");

                                itoa(seconds,buff,10);
                                lstrcat(message,"Base with Seconds Seconds: ");
                                lstrcat(message,buff);
                                lstrcat(message,"\012\012");
                                }
                                MessageBox(hwnd,message,"You inserted",MB_OK);
                                GlobalFreePtr(message);
                                return 0;
                          }
            }      
         }
      }   
     return DefWindowProc (hwnd, message, wParam, lParam) ;
     }        
             
void   DestroySubwindow(HWND hwnd)
{
 FARPROC findChildWindowsProc  = MakeProcInstance((FARPROC) FindChildWindowsProc,(HINSTANCE) GetWindowWord(hwnd,GWW_HINSTANCE));
 EnumChildWindows(hwnd,(WNDENUMPROC)findChildWindowsProc,(LPARAM) NULL);
 return;
 }
BOOL CALLBACK _export FindChildWindowsProc(HWND hwnd, LPARAM list)
{
  DestroyWindow(hwnd);    
  return TRUE;
}    
BOOL FAR PASCAL __export TestDialogProc( HWND hDlg, UINT uMsg,
                                 WPARAM wParam, LPARAM lParam )
{
   switch (uMsg)
   {
   case WM_CLOSE:
         EndDialog(hDlg,0);
         return TRUE;
   case WM_COMMAND:
           switch(wParam)
             {
             case ID_OK:
                EndDialog(hDlg,0);
                return TRUE;
             default:
                break;   
             }             
   break;  
   }
      return ( FALSE ) ;

} // end of TestDialogProc()

BOOL FAR PASCAL __export TestDialog1Proc( HWND hDlg, UINT uMsg,
                                 WPARAM wParam, LPARAM lParam )
{
   switch (uMsg)
   {
   case WM_INITDIALOG:
         {
         SetDollar(GetDlgItem(hDlg,1),10);
         SetCentimes(GetDlgItem(hDlg,1),5);
         SetSign(GetDlgItem(hDlg,1),FALSE); // Set the sign as positive
         SetInteger(GetDlgItem(hDlg,2),99);
         SetFraction(GetDlgItem(hDlg,2),34);
         SetSign(GetDlgItem(hDlg,2),TRUE);  // Set the sign as negative
         SetDateString(GetDlgItem(hDlg,3),"03 3 94");
         SetHours(GetDlgItem(hDlg,4),10);
         SetMinutes(GetDlgItem(hDlg,4),20);
         SetHours(GetDlgItem(hDlg,5),11);
         SetMinutes(GetDlgItem(hDlg,5),22);
         SetSeconds(GetDlgItem(hDlg,5),33);
         return TRUE;
         }
   case WM_CLOSE:
         EndDialog(hDlg,0);
         return TRUE;
   case WM_COMMAND:
           switch(wParam)
             {
             case ID_OK:
                EndDialog(hDlg,0);
                return TRUE;
             default:
                break;   
             }             
   break;  
   }
      return ( FALSE ) ;

} // end of TestDialog1Proc()

BOOL FAR PASCAL __export ShowDetailsDialogProc( HWND hDlg, UINT uMsg,
                                 WPARAM wParam, LPARAM lParam )
{
   switch (uMsg)
   {         
   case WM_INITDIALOG:
         {
         struct intData *in = GetIntStructure();
         SetDlgItemText(hDlg,3,in->loMonths[0]);
         SetDlgItemText(hDlg,4,in->loMonths[1]);
         SetDlgItemText(hDlg,5,in->loMonths[2]);
         SetDlgItemText(hDlg,6,in->loMonths[3]);
         SetDlgItemText(hDlg,7,in->loMonths[4]);
         SetDlgItemText(hDlg,8,in->loMonths[5]);
         SetDlgItemText(hDlg,9,in->loMonths[6]);
         SetDlgItemText(hDlg,10,in->loMonths[7]);
         SetDlgItemText(hDlg,11,in->loMonths[8]);
         SetDlgItemText(hDlg,12,in->loMonths[9]);
         SetDlgItemText(hDlg,13,in->loMonths[10]);
         SetDlgItemText(hDlg,14,in->loMonths[11]);
         SetDlgItemText(hDlg,15,in->loDays[0]);
         SetDlgItemText(hDlg,16,in->loDays[1]);
         SetDlgItemText(hDlg,17,in->loDays[2]);
         SetDlgItemText(hDlg,18,in->loDays[3]);
         SetDlgItemText(hDlg,19,in->loDays[4]);
         SetDlgItemText(hDlg,20,in->loDays[5]);
         SetDlgItemText(hDlg,21,in->loDays[6]);
         if(!in->shortMonth) SetDlgItemText(hDlg,29,"N");
         if(!in->shortDay) SetDlgItemText(hDlg,30,"N");
         if(!in->shortYear) SetDlgItemText(hDlg,31,"N");
         switch(in->dateFormat)
            {
            case 0:
            SetDlgItemText(hDlg,74,"MDY");
            break;
            case 1:
            SetDlgItemText(hDlg,74,"DMY");
            break;
            case 2:
            SetDlgItemText(hDlg,74,"YMD");
            break;
            }                                    
         SetDlgItemText(hDlg,44,in->longDateFirstSeparator);
         SetDlgItemText(hDlg,45,in->longDateSecondSeparator);
         SetDlgItemText(hDlg,46,in->longDateThirdSeparator);
         char _far shDateS[2];
         shDateS[0]= in->dateSeparator;shDateS[1]=0;
         SetDlgItemText(hDlg,75,shDateS);
         switch(in->longDateMonthFormat)
            {
            case 1:
            SetDlgItemText(hDlg,38,"3");
            break;
            case 2:
            SetDlgItemText(hDlg,38,"03");
            break;
            case 3:
            SetDlgItemText(hDlg,38,in->shMonths[2]);
            break;
            case 4:
            SetDlgItemText(hDlg,38,in->loMonths[2]);
            break;
            }
         switch(in->longDateWeekDayFormat)
            {
            case 3:
            SetDlgItemText(hDlg,40,in->shDays[2]);
            break;
            case 4:
            SetDlgItemText(hDlg,40,in->loDays[2]);
            break;
            }
         switch(in->longDateDayFormat)
            {
            case 1:
            SetDlgItemText(hDlg,37,"3");
            break;
            case 2:
            SetDlgItemText(hDlg,37,"03");
            break;
            }
         switch(in->longDateYearFormat)
            {
            case 2:
            SetDlgItemText(hDlg,39,"94");
            break;
            case 4:
            SetDlgItemText(hDlg,39,"1994");
            break;
            }
         SetDlgItemText(hDlg,53,in->sTime);
         SetDlgItemText(hDlg,55,in->am);
         SetDlgItemText(hDlg,57,in->pm);
         switch(in->iTime)
            {
            case 0:
            SetDlgItemText(hDlg,54,"0-12");
            break;
            case 1:
            SetDlgItemText(hDlg,54,"0-24");
            break;
            }
         switch(in->iTLZero)
            {
            case 0:
            SetDlgItemText(hDlg,56,"03:02 am");
            break;
            case 1:
            SetDlgItemText(hDlg,56,"3:2 pm");
            break;
            }                     
         SetDlgItemText(hDlg,64,in->SZCurrency);
         switch(in->iNegCurr)
           {
           case 0:
           SetDlgItemText(hDlg,66,"($12,2)");
           break;
           case 1:
           SetDlgItemText(hDlg,66,"-$12,22");
           break;
           case 2:
           SetDlgItemText(hDlg,66,"$-12,22");
           break;
           case 3:
           SetDlgItemText(hDlg,66,"$12,22-");
           break;
           case 4:
           SetDlgItemText(hDlg,66,"(12,22$)");
           break;
           case 5:
           SetDlgItemText(hDlg,66,"-12,22$");
           break;
           case 6:
           SetDlgItemText(hDlg,66,"12,22-$");
           break;
           case 7:
           SetDlgItemText(hDlg,66,"12,22$-");
           break;
           case 8:
           SetDlgItemText(hDlg,66,"-12,22 $");
           break;
           case 9:
           SetDlgItemText(hDlg,66,"-$ 12,22");
           break;
           case 10:
           SetDlgItemText(hDlg,66,"12,22 $-");
           break;
           }
         switch(in->iCurrency)
           {
           case 0:
           SetDlgItemText(hDlg,67,"$12,22");
           break;
           case 1:
           SetDlgItemText(hDlg,67,"12,22$");
           break;
           case 2:
           SetDlgItemText(hDlg,67,"$ 12,22");
           break;
           case 3:
           SetDlgItemText(hDlg,67,"12,22 $");
           break;
           }
         SetDlgItemInt(hDlg,65,in->iCurrDigits,FALSE);
         SetDlgItemText(hDlg,68,in->iThousand);
         SetDlgItemText(hDlg,69,in->iDecimal);
         switch(in->language)
            {
            case DANISH:
              SetDlgItemText(hDlg,70,"Danish");
              break;
            case FINNISH:
              SetDlgItemText(hDlg,70,"Finnish");
              break;
            case FRENCH:
              SetDlgItemText(hDlg,70,"French");
              break;
            case ENGLISH:
              SetDlgItemText(hDlg,70,"English");
              break;
            case ICELAND:
              SetDlgItemText(hDlg,70,"Iceland");
              break;
            case ITALIAN:
              SetDlgItemText(hDlg,70,"Italian");
              break;
            case NORWEGIAN:
              SetDlgItemText(hDlg,70,"NORWEGIAN");
              break;
            case DUTCH:
              SetDlgItemText(hDlg,70,"Dutch");
              break;
            case PORTUGUESE:
              SetDlgItemText(hDlg,70,"Portuguese");
              break;
            case SWEDISH:
              SetDlgItemText(hDlg,70,"Swedish");
              break;
            case SPANISH:
              SetDlgItemText(hDlg,70,"Spanish");
              break;
            case GERMAN:
              SetDlgItemText(hDlg,70,"German");
              break;
              }
         return TRUE;
         }
   case WM_CLOSE:
         EndDialog(hDlg,0);
         return TRUE;
   
   case WM_COMMAND:
           switch(wParam)
             {
             case 100:
                EndDialog(hDlg,0);
                return TRUE;
                
             default:
                break;   
             }             
   break;  
   }
      return ( FALSE ) ;

} // end of TestDialogProc()
