#    Copyright (C) 1995 Aladdin Enterprises.  All rights reserved.
# 
# This file is part of Aladdin Ghostscript.
# 
# Aladdin Ghostscript is distributed with NO WARRANTY OF ANY KIND.  No author
# or distributor accepts any responsibility for the consequences of using it,
# or for whether it serves any particular purpose or works at all, unless he
# or she says so in writing.  Refer to the Aladdin Ghostscript Free Public
# License (the "License") for full details.
# 
# Every copy of Aladdin Ghostscript must include a copy of the License,
# normally in a plain ASCII text file named PUBLIC.  The License grants you
# the right to copy, modify and redistribute Aladdin Ghostscript, but only
# under certain conditions described in the License.  Among other things, the
# License requires that the copyright notice and this notice be preserved on
# all copies.

# tctail.mak
# Last part of MS-DOS makefile common to Turbo C and Turbo/Borland C++,
# MS-DOS and MS Windows.

# Define the name of this makefile.
TCTAIL_MAK=tctail.mak

# Include the generic makefiles, except for int.mak.
!include "gs.mak"
!include "lib.mak"
!include "jpeg.mak"
!include "devs.mak"

# -------------------------- Auxiliary programs --------------------------- #

CCAUX=$(COMPDIR)\$(COMPAUX) -m$(MM) -I$(INCDIR) -L$(LIBDIR) -O

$(ECHOGS_XE): echogs.c
	$(CCAUX) echogs.c

# If we are running in a Windows environment with a different compiler
# for the DOS utilities, we have to invoke genarch by hand:
!if $(WINCOMP)
$(GENARCH_XE): genarch.c
	$(COMPDIR)\$(COMP) -I$(INCDIR) -L$(LIBDIR) -O genarch.c
	echo Run "win genarch arch.h" then continue make
!else
$(GENARCH_XE): genarch.c
	$(CCAUX) genarch.c
!endif

$(GENCONF_XE): genconf.c
	$(CCAUX) genconf.c

$(GENINIT_XE): geninit.c $(stdio__h) $(string__h)
	$(CCAUX) geninit.c

# No special gconfig_.h is needed.
gconfig_.h: $(TCTAIL_MAK) $(ECHOGS_XE)
	echogs -w gconfig_.h /* This file deliberately left blank. */

gconfigv.h: $(TCTAIL_MAK) $(MAKEFILE) $(ECHOGS_XE)
	$(EXP)echogs -w gconfigv.h -x 23 define USE_ASM -x 2028 -q $(USE_ASM)-0 -x 29
	$(EXP)echogs -a gconfigv.h -x 23 define USE_FPU -x 2028 -q $(FPU_TYPE)-0 -x 29
	$(EXP)echogs -a gconfigv.h -x 23 define EXTEND_NAMES 0$(EXTEND_NAMES)
