#    Copyright (C) 1995 Aladdin Enterprises.  All rights reserved.
# 
# This file is part of Aladdin Ghostscript.
# 
# Aladdin Ghostscript is distributed with NO WARRANTY OF ANY KIND.  No author
# or distributor accepts any responsibility for the consequences of using it,
# or for whether it serves any particular purpose or works at all, unless he
# or she says so in writing.  Refer to the Aladdin Ghostscript Free Public
# License (the "License") for full details.
# 
# Every copy of Aladdin Ghostscript must include a copy of the License,
# normally in a plain ASCII text file named PUBLIC.  The License grants you
# the right to copy, modify and redistribute Aladdin Ghostscript, but only
# under certain conditions described in the License.  Among other things, the
# License requires that the copyright notice and this notice be preserved on
# all copies.

# makefile for MS-DOS / Borland C++ (3.1 or later) library testing.

libdefault: gslib.exe

GS_DOCDIR=c:/gs
GS_LIB_DEFAULT=.;c:/gs\;c:/gs/fonts
GS_INIT=gs_init.ps

DEBUG=1
TDEBUG=1
NOPRIVATE=1

GS=gslib
JSRCDIR=jpeg-6
JVERSION=6
CONFIG=
CFLAGS=

USE_ASM=1
ASM=tasm

COMP=bcc
COMPAUX=$(COMP)
COMPDIR=c:\bc\bin
BGIDIR=c:\bc\bgi
# BGIDIRSTR must be the same as BGIDIR with / substituted for \.
BGIDIRSTR=c:/bc/bgi
INCDIR=c:\bc\include
LIBDIR=c:\bc\lib

OVERLAY=1

CPU_TYPE=486
FPU_TYPE=0

.swap

PLATFORM=bclib_
MAKEFILE=bclib.mak

AK=ccf.tr
F286=

CO=-Obe -Z
COD=-O
COINT=-Obet
CAOPT=-a
WINCOMP=0

!include "tccommon.mak"

!if $(NOPRIVATE)
CP=-DNOPRIVATE
!else
CP=
!endif

!if $(DEBUG) | $(TDEBUG)
CS=-N
!else
CS=
!endif

!if $(DEBUG)
CD=-DDEBUG
!else
CD=
!endif

!if $(TDEBUG)
CT=-v
LCT=/v
!else
CT=-y
LCT=/m /l
!endif

GENOPT=$(CP) $(CS) $(CD) $(CT)

!if $(OVERLAY)
CY=-Y
CYO=-Yo -zAOVLY
LO=/oOVLY
LIBOVL=$(LIBDIR)\overlay
OVLH=overlay.h
!else
CY=
CYO=
LO=
LIBOVL=
OVLH=
!endif

CCFLAGS0=$(GENOPT) $(PLATOPT) $(FPFLAGS) $(CFLAGS) $(XCFLAGS)
CCFLAGS=$(CCFLAGS0) -m$(MM)
CC=$(COMPDIR)\$(COMP) -m$(MM) -zEGS_FAR_DATA @ccf.tr
CCC=$(CC) $(CYO) $(CO) -c
CCD=$(CC) $(CYO) $(COD) -c
CCCF=$(COMPDIR)\$(COMP) -mh @ccf.tr $(CYO) -O -c
CCINT=$(CC) $(CYO) $(COINT) -c
CCLEAF=$(CCC)

.c.obj:
	$(CCC) { $<}

FEATURE_DEVS=libcore.dev patcore.dev
COMPILE_INITS=0
DEVICE_DEVS=vga.dev

!include "tctail.mak"

ccf.tr: $(MAKEFILE) makefile
!if $(CPU_TYPE) < 286
	echo -a -d -r -G -X -I$(INCDIR) $(CCFLAGS0) >ccf.tr
!else
!  if $(CPU_TYPE) > 286
	echo -3 -a -d -r -G -X -I$(INCDIR) $(CCFLAGS0) >ccf.tr
!  else
	echo -2 -a -d -r -G -X -I$(INCDIR) $(CCFLAGS0) >ccf.tr
!  endif
!endif

ccf1.tr: $(MAKEFILE) makefile
	echo -I$(INCDIR) $(CCFLAGS) >ccf1.tr

bclib__=gp_itbc.$(OBJ) gp_msdos.$(OBJ) gp_nofb.$(OBJ) gp_dosfs.$(OBJ) gp_dosfe.$(OBJ)
bclib_.dev: $(bclib__)
	$(SETMOD) bclib_ $(bclib__)

gp_itbc.$(OBJ): gp_itbc.c $(string__h) $(gx_h) $(gp_h) \
 $(OVLH) $(MAKEFILE) makefile ccf1.tr
	$(CC) @ccf1.tr -1- $(CY) -DCPU_TYPE=$(CPU_TYPE) -c gp_itbc.c

BEGINFILES=ccf*.tr
CCBEGIN=$(CCC) *.c

LIBCTR=libc$(MM).tr

$(LIBCTR): $(MAKEFILE) makefile $(ECHOGS_XE)
	echogs -w $(LIBCTR) $(LIBOVL) $(LIBDIR)\$(FPLIB)+
	echogs -a $(LIBCTR) $(LIBDIR)\math$(MM) $(LIBDIR)\c$(MM)

objl.tr: obj.tr gslib.obj gconfig.obj $(INTASM)
	echogs -w objl.tr gslib.obj gconfig.obj $(INTASM)+
	copy objl.tr+obj.tr

$(GS).exe: $(LIB_ALL) $(LIBCTR) objl.tr lib.tr
	$(COMPDIR)\tlink $(LCT) $(LO) $(LIBDIR)\c0$(MM) @objl.tr ,$(GS),$(GS),@lib.tr @$(LIBCTR)
