//FAKESHOW - the FakeMode .TGA viewer           (c) 1993,94 by Yaka/Xography
//3840 Colors simultanously on screen (with register compatible VGA cards)!

//This program is not perfect, I just wrote it in a hurry as an example how
//FakeMode may be used. Feel free to add your own ideas!
//(Read FAKEMODE.DOC for more information about FakeMode)

#include <conio.h>
#include <io.h>
#include <fcntl.h>
#include "fakemode.h"

unsigned char buf[48];
unsigned char viewcolor[16][16][16];


void putdithpixel(unsigned int x, unsigned int y, unsigned char red, unsigned char green, unsigned char blue) {
// This routine dithers the colors and puts the pixel on the screen.
// The dithering is not as good as the one in the routine below, but it
// causes less flicker.
// Check out the commented routine below to see how dithering can interfere
// with FakeMode's pageflipping.
  unsigned char r,g,b;

  r=red >> 4;
  if (((red & 8)>0) && ((((x+y) % 2)^((x/4)%2)^((y/8)%2))==0) && (r<15)) r++;
  g=green >> 4;
  if (((green & 8)>0) && ((((x+y) % 2)^((x/4)%2)^((y/8)%2))!=0) && (g<15)) g++;
  b=blue >> 4;
  if (((blue & 8)>0) && ((((x+y) % 2)^((x/4)%2)^((y/8)%2))!=0) && (b<15)) b++;

  F_putsmallpixel(x,y,r,g,b);
}

/*void putdithpixel(unsigned int x, unsigned int y, unsigned char red, unsigned char green, unsigned char blue) {
// This routine dithers the colors. This dithering method tends to flicker
// because it's a 50/50 chessboard dithering that interferes with the page
// flipping. Perhaps you figure out a better way to do the dithering
// (or leave it away) :)
  unsigned char r,g,b;

  r=red >> 4;
  if (((red & 8)>0) && (((x+y) % 2)==0) && (r<15)) r++;
  g=green >> 4;
  if (((green & 8)>0) && (((x+y) % 2)!=0) && (g<15)) g++;
  b=blue >> 4;
  if (((blue & 8)>0) && (((x+y) % 2)!=0) && (b<15)) b++;

  F_putsmallpixel(x,y,r,g,b);
}*/

int loadimage(char *name) {
// Tries to load the .TGA picture with the name 'name' to the screen.
// Halves the width if > 320
// Doubles the height if <= 200

  int handle,i,j,k;
  unsigned int x,y,v;
  unsigned char ar,ag,ab;
  int width,height,yload;

  for (i=0; i<16; i++) {                //initialize color counter
    for (j=0; j<16; j++) {
      for (k=0; k<16; k++) {
	viewcolor[i][j][k]=0;
      }
    }
  }
  if ((handle = open(name, O_RDONLY | O_BINARY))== -1) {return(1);}
  read(handle,buf,18);
  height=buf[15];                       //Calculate width/height from header
  height*=256;
  height+=buf[14];
  width=buf[13];
  width*=256;
  width+=buf[12];
  if (width>320) {                      //The following part paints half width
    width-=640;
    width*=3;
    if (height<400) {yload=height;} else {yload=400;}
    for (y=0; y<yload; y++) {
      for (x=0; x<320; x+=8) {
	read(handle,buf,48);
	for (i=0; i<8; i++) {
	  v=buf[i*6+2]; v+=buf[i*6+5]; ar=v>>1;
	  v=buf[i*6+1]; v+=buf[i*6+4]; ag=v>>1;
	  v=buf[i*6]; v+=buf[i*6+3]; ab=v>>1;
	  if (height<=200) {
	    putdithpixel(x+i,y*2,ar,ag,ab);
	    putdithpixel(x+i,y*2+1,ar,ag,ab);
	  } else putdithpixel(x+i,y,ar,ag,ab);
	  viewcolor[ar>>4][ag>>4][ab>>4]=1;
	}
      }
      if (width!=0) lseek(handle,width,SEEK_CUR);
    }
  } else {                              //This part is for full width
    width-=320;
    width*=3;
    if (height<400) {yload=height;} else {yload=400;}
    for (y=0; y<yload; y++) {
      for (x=0; x<320; x+=16) {
	read(handle,buf,48);
	for (i=0; i<16; i++) {
	  ar=(buf[i*3+2]);
	  ag=(buf[i*3+1]);
	  ab=(buf[i*3]);
	  if (yload>200) {
	    putdithpixel(x+i,y,ar,ag,ab);
	  } else {
	    putdithpixel(x+i,y*2,ar,ag,ab);     //
	    putdithpixel(x+i,y*2+1,ar,ag,ab);   //
	    //F_putbigpixel(x+i,y,ar>>4,ag>>4,ab>>4);
			//Use this alternatively to check F_putbigpixel
	  }
	  viewcolor[ar>>4][ag>>4][ab>>4]=1;
	}
      }
      if (width!=0) lseek(handle,width,SEEK_CUR);
    }
  }
  close(handle);
  return(0);
}

int main(int argc, char *argv[]) {
  int i,j,k,colzahl;

  if (argc!=2) {
    cprintf("\r\nFAKESHOW.EXE                                          (c) 1994 by Yaka/Xography\r\n");
    cprintf("\r\n\n");
    cprintf("Usage: FAKESHOW <unpacked Targafile.TGA>\r\n\n");
  } else {
    if (!F_isvga()) {cprintf("Sorry, but you need a VGA card to run this program.\r\n");}
     else {
      F_initgraph();                    //Initialize FakeMode.
      F_setlumi(0);                     //Darken Screen.
      i=loadimage(argv[1]);             //Load Image.
      if (i==0) {                       //If Image was loaded correctly:
	F_fadein();                     //Fade in Picture
	getch();                        //Wait for keypress
	F_fadeout();                    //Fade out picture
	F_closegraph();                 //Close FakeMode.
	colzahl=0;
	for (i=0; i<16; i++) {          //Count colors displayed
	  for (j=0; j<16; j++) {
	    for (k=0; k<16; k++) {
	      if (viewcolor[i][j][k]==1) colzahl++;
	    }
	  }
	}
	cprintf("You have been looking at %i different colors!\r\n\n",colzahl);
      } else {
	F_closegraph();
	cprintf("Could not open %s.\r\n\n",argv[1]);
      }
    }
  }
  while(kbhit()) getch();               //Empty keyboard buffer
  return(0);
}
