unit TBOBJ;

interface
uses  WObjects, WinProcs, WinTypes, Strings, Toolbox;

{---------------------------------------------------------------------------------------------}
{ SPREADSHEET CONTROL                                                                         }
{---------------------------------------------------------------------------------------------}

type
  PSpreadsheet = ^TSpreadsheet;
  TSpreadsheet = object(TControl)
    constructor Init(aParent: PWindowsObject; AnID: Integer; aTitle: PChar; X,Y,W,H: Integer);
    function    GetClassName: PChar; virtual;
    function    BuildDependencies: Boolean; virtual;
    function    ClearCell(Col, Row: TSS_Coord)                    	   : Boolean;
    function    ClearRange(Col, Row, Col2, Row2: TSS_Coord)        : Boolean;
    function    ClipIn(Col, Row, Col2, Row2: TSS_Coord;
                   lpBuffer: PChar; BufLen: Longint)               : Boolean;
    function    ClipOut(Col, Row, Col2, Row2: TSS_Coord)           : THandle;
    function    ColWidthToLogUnits(ColWidth: Double)               : Integer;
    function    DelCol(Col: TSS_Coord)                             : Boolean;
    function    DelRow(Row: TSS_Coord)                             : Boolean;
    function    DeSelectBlock                                      : Boolean;
    function    GetActiveCell(var Col, Row: TSS_Coord)             : Boolean;
    function    GetBool(nIndex: Integer)                           : Boolean;
    function    GetBottomRightCell                                 : Longint;
    function    GetCellType(Col, Row: TSS_Coord;
                   var CellType: TSS_CellType)                     : Boolean;
    function    GetColor(Col, Row: TSS_Coord;
                   var Background, Foreground: TColorRef)	   : Boolean;
    function    GetColWidth(Col: TSS_Coord)                        : Double ;
{   function    GetCurrSelBlockPos(var CurrCol, CurrRow: TSS_Coord): Boolean; }
    function    GetData(Col, Row: TSS_Coord; Data: PChar)          : Integer;
    function    GetDataLen(Col, Row: TSS_Coord)                    : Integer;
    function    GetEditMode                                        : Boolean;
    function    GetFont(Col, Row: TSS_Coord)                       : THandle;
    function    GetFormula(Col, Row: TSS_Coord; Formula: PChar)    : Integer;
    function    GetFormulaLen(Col, Row: TSS_Coord)                 : Integer;
{   function    GetLock(Col, Row: TSS_Coord)                       : Boolean; }
    function    GetMaxCols                                         : TSS_Coord;
    function    GetMaxRows					   : TSS_Coord;
    function    GetRowHeight(Row: TSS_Coord)			   : Double;
    function    GetSel(var SelStart, SelEnd: Integer)              : Boolean;
    function    GetSelectBlock(var UL, LR: TSS_CellCoord)          : Boolean;
    function    GetSelText                                         : THandle;
    procedure   GetShadowColor(var ShColor, ShText,
                                   ShDark, ShLight: TColorRef)     ; virtual;
    function    GetTopLeftCell                                     : Longint;
    function    GetVisible(Col, Row: TSS_Coord; Visible: Integer)  : Boolean;
    function    HighlightRow                                       : Boolean; { Eigene Funktion }
    function    InsCol(Col: TSS_Coord)                             : Boolean;
    function    InsRow(Row: TSS_Coord)                             : Boolean;
    function    LoadFromBuffer(hBuffer: THandle; BufLen: Longint)  : Boolean;
    function    LoadFromFile(FileName: PChar)                      : Boolean;
    function    LogUnitsToColWidth(Units: Integer)                 : Double ;
    function    ReCalc                                             : Boolean;
    function    ReplaceSel(lpText: PChar)                          : Boolean;
    function    RowHeightToLogUnits(Row: TSS_Coord;
                   RowHeight: Double)				   : Integer;
    function    SaveToBuffer(var BufferLen: Longint;
                   DataOnly: Boolean)                              : THandle;
    function    SaveToFile(var FileName: PChar; DataOnly: Boolean) : Boolean;
    function    SetActiveCell(Col, Row: TSS_Coord)                 : Boolean;
    function    SetBool(Index: Integer; NewVal: Boolean)           : Boolean;
    function    SetCellType(Col, Row: TSS_Coord;
                   var CellType: TSS_CellType) 		           : Boolean;
    function    SetCellTypeRange(Col, Row, Col2, Row2: TSS_Coord;
                   var CellType: TSS_CellType)  		   : Boolean;
    function    SetColor(Col, Row: TSS_Coord;
                   Foreground, Background: TColorRef)        	   : Boolean;
    function    SetColorRange(Col, Row, Col2, Row2: TSS_Coord;
                   Background, Foreground: TColorRef)              : Boolean;
    function    SetColWidth(Col: TSS_Coord; Height: Integer)       : Boolean;
    function    SetData(Col, Row: TSS_Coord; Data: PChar)          : Boolean;
    function    SetDataRange(Col, Row, Col2, Row2: TSS_Coord;
                   Data: PChar) 			   	   : Boolean;
    function    SetEditMode(EditModeOn: Boolean)                   : Boolean;
    function    SetFont(Col, Row: TSS_Coord; Font: THandle;
                   DeleteFont: Boolean) 			   : Boolean;
    function    SetFontRange(Col, Row, Col2, Row2: TSS_Coord;
                   Font: THandle; DeleteFont: Boolean)   	   : Boolean;
    function    SetFormula(Col, Row: TSS_Coord; Formula: PChar;
                   BuildDep: Boolean)                              : Boolean;
    function    SetFormulaRange(Col, Row, Col2, Row2: TSS_Coord;
                   Formula: PChar; BuildDep: Boolean)       	   : Boolean;
    function    SetLock(Col, Row: TSS_Coord; Lock: Boolean)        : Boolean;
    function    SetLockRange(Col, Row, Col2, Row2: TSS_Coord;
                   Lock: Boolean)    		                   : Boolean;
    procedure   SetMaxCols(MaxCols: Integer);
    procedure   SetMaxRows(MAxRows: Integer);
    function    SetRowHeight(Row: TSS_Coord; Height: Double)	   : Boolean;
    function    SetSel(SelStart, SelEnd: Integer)		   : Boolean;
    function    SetSelectBlock(var CellUL, CellLR: TSS_CellCoord)  : Boolean;
    procedure   SetShadowColor(ShColor, ShTxt, ShDark,
                   ShLight: TColorRef);
    function    SetTypeDate(var CellType: TSS_CellType;
                   Style: Longint;
                   var Format: TDateFormat;
                   var Min, Max: TDate)      		           : PSS_CellType;

    function    SetTypeEdit(var CellType: TSS_CellType;
                   Style: Longint;
                   Len, ChrSet: Integer;
                   ChrCase: Byte)				   : PSS_CellType;
    function    SetTypeFloat(var CellType: TSS_CellType;
                   Style: Longint;
                   Left, Right: Integer;
                   Min, Max: Double)     	                   : PSS_CellType;
    function    SetTypeInteger(var CellType: TSS_CellType;
                   Min, Max: Longint)     	                   : PSS_CellType;
    function    SetTypePic(var CellType: TSS_CellType;
                   Style: Longint; Mask: PChar)                    : PSS_CellType;
    function    SetTypePicture(var CellType: TSS_CellType;
                   Style: Longint; PictName: PChar)                : PSS_CellType;
    function    SetTypeStaticText(var CellType: TSS_CellType;
                   Style: Integer)				   : PSS_CellType;
    function    SetTypeTime(var CellType: TSS_CellType;
                   Style: Longint;
                   var Format: TTimeFormat;
                   var Min, Max: TTime)          	           : PSS_CellType;
    function    ShowActiveCell(Position: Integer)		   : Boolean;
    function    ShowCell(Col, Row: TSS_Coord; Position: Integer)   : Boolean;
    function    ValidateFormula(Formula: PChar)                    : Boolean;
  end;


{----------------------------------------------------------------------------------------------------------}
{ FLOAT CONTROL CLASS                                                                                      }
{----------------------------------------------------------------------------------------------------------}

  PFloatEdit = ^TFloatEdit;
  TFloatEdit = object(TStatic)
    constructor Init(aParent: PWindowsObject; AnID: Integer; ATitle: PChar; X,Y,W,H: Integer);
    function    GetClassName                                       : PChar  ; virtual;
    function    GetFormat(var Fmt: TFloatFormat)                   : Boolean;
    function    GetRange(var Min, Max: Double)                     : Boolean;
    function    GetValue(var LongValue: Double)                    : Boolean;
    function    SetFormat(var Fmt: TFloatFormat)                   : Boolean;
    function    SetMask(Mask: PChar)                               : Boolean;
    function    SetRange(Min, Max: Longint)                        : Boolean;
    function    SetStyle(Style: Longint)                           : Boolean;
    function    SetValue(LongValue: Longint)                       : Boolean;
  end;


{----------------------------------------------------------------------------------------------------------}
{ INTEGER CONTROL CLASS                                                                                    }
{----------------------------------------------------------------------------------------------------------}
{ Control Styles
  IS_SPIN        Add a spin Button to the right side
  IS_SPINWRAP    Wrap from the maximum to the minimum and visa versa }

  PIntEdit = ^TIntEdit;
  TIntEdit = object(TEdit)
    constructor Init(aParent: PWindowsObject; AnID: Integer; ATitle: PChar; X,Y,W,H: Integer);
    function    GetClassName                                       : PChar  ; virtual;
    function    GetValue(var LongValue: Longint)                   : Boolean;
    function    SetMask(Mask: PChar)                               : Boolean;
    function    SetRange(Min, Max: Longint)                        : Boolean;
    function    SetSpin(Spin, SpinWrap: Boolean; SpinInc: Longint) : Boolean;
    function    SetValue(LongValue: Longint)                       : Boolean;
  end;


{----------------------------------------------------------------------------------------------------------}
{ PIC CONTROL CLASS                                                                                        }
{----------------------------------------------------------------------------------------------------------}

  PPicEdit = ^TPicEdit;
  TPicEdit = object(TEdit)
    constructor Init(aParent: PWindowsObject; AnID: Integer; ATitle: PChar; X,Y,W,H: Integer);
    function    GetClassName                                    : PChar; virtual;
    function    GetMask(Mask: PChar)                            : Boolean;
    function    SetCallBack                                     : Boolean;
    function    SetMask(Mask: PChar)                            : Boolean;
  end;


{----------------------------------------------------------------------------------------------------------}
{ IMPRINT CONTROL CLASS                                                                                    }
{----------------------------------------------------------------------------------------------------------}

  PImprint = ^TImprint;
  TImprint = object(TStatic)
    constructor Init(aParent: PWindowsObject; AnID: Integer; ATitle: PChar; X,Y,W,H: Integer);
    function    GetClassName                              	: PChar; virtual;
    procedure   GetColor(var ImprintColor: TImprintColor);
    function    GetFrameSize                              	: Word   ; virtual;
    function    GetLineCnt                                	: Longint; virtual; { Low, High Word }
    function    GetLineSize                               	: Word;
    function    GetShadowSize                             	: Word;
    procedure   SetColor(var ImprintColor: TImprintColor);
    procedure   SetFrameSize(Size: Word);
    procedure   SetLineCnt(Horiz, Vert: Word);
    procedure   SetLineSize(Size: Word);
    procedure   SetShadowSize(Size: Word);
  end;


{----------------------------------------------------------------------------------------------------------}
{ SUPERBUTTON CONTROL CLASS                                                                                }
{----------------------------------------------------------------------------------------------------------}

  PSuperButton = ^TSuperButton;
  TSuperButton = object(TButton)
    constructor Init(aParent: PWindowsObject; AnID: Integer; ATitle: PChar; X,Y,W,H: Integer);
    function    GetClassName                                    : PChar  ; virtual;
    procedure   GetColor       (var Color: TSuperBtnColor);
    procedure   SetColor       (var Color: TSuperBtnColor);
    function    SetPict        (PicType: Word; Resource: PChar) : Boolean;
    function    SetPictBtnDown (PicType: Word; Resource: PChar) : Boolean;
    function    SetPictDisabled(PicType: Word; Resource: PChar)	: Boolean;
    procedure   SetStyle(Style: Word);
  end;


{----------------------------------------------------------------------------------------------------------}
{ DATE CONTROL CLASS                                                                                       }
{----------------------------------------------------------------------------------------------------------}

  PDateEdit = ^TDateEdit;
  TDateEdit = object(TEdit)
    constructor Init(aParent: PWindowsObject; AnID: Integer; ATitle: PChar; X,Y,W,H: Integer);
    function    GetClassName                                       : PChar; virtual;
    function    GetFormat(var DateFmt: TDateFormat)                : Boolean;
    function    SetFormat(var DateFmt: TDateFormat)                : Boolean;
    function    SetRange(var MinDate, MaxDate: TDate)              : Boolean;
  end;


{----------------------------------------------------------------------------------------------------------}
implementation
{----------------------------------------------------------------------------------------------------------}


{----------------------------------------------------------------------------------------------------------}
{ SPREADSHEET CONTROL IMPLEMENTATION                                                                       }
{----------------------------------------------------------------------------------------------------------}

constructor TSpreadsheet.Init(aParent: PWindowsObject; AnID: Integer; aTitle: PChar; X,Y,W,H: Integer);
begin
  TControl.Init(aParent, anID, aTitle, X,Y,W,H);
  Attr.Style := (Attr.Style and not ss_Left) or ws_Border or ws_TabStop;
end;

function TSpreadsheet.GetClassName: PChar;
begin
  GetClassName := 'tbSpreadsheet';
end;

function TSpreadsheet.BuildDependencies;
begin
  BuildDependencies := SSBuildDependencies(HWindow)
end;


function TSpreadsheet.ClearCell;
begin
  ClearCell := SSClear(HWindow, Col, Row)
end;

function TSpreadsheet.ClearRange;
begin
  ClearRange := SSClearRange(HWindow, Col, Row, Col2, Row2)
end;


function TSpreadsheet.ClipIn;
begin
  ClipIn := SSClipIn(HWindow, Col, Row, Col2, Row2, lpBuffer, BufLen)
end;

function TSpreadsheet.ClipOut;
begin
  ClipOut := SSClipOut(HWindow, Col, Row, Col2, Row2)
end;

function TSpreadsheet.ColWidthToLogUnits;
begin
 ColWidthToLogUnits := SSColWidthToLogUnits(HWindow, ColWidth)
end;

procedure TSpreadsheet.SetMaxRows;
begin
  SSSetMaxRows(HWindow, MaxRows);
end;

procedure TSpreadsheet.SetMaxCols;
begin
  SSSetMaxCols(HWindow, MaxCols);
end;

function TSpreadsheet.DelCol;
begin
  DelCol := SSDelCol(HWindow, Col)
end;

function TSpreadsheet.DelRow;
begin
  DelRow := SSDelRow(HWindow, Row)
end;

function TSpreadsheet.DeSelectBlock;
begin
  DeSelectBlock := SSDeselectBlock(HWindow)
end;

function TSpreadsheet.GetActiveCell;
begin
  GetActiveCell := SSGetActiveCell(HWindow, Col, Row)
end;

function TSpreadsheet.GetBool;
begin
  GetBool := SSGetBool(HWindow, nIndex)
end;

function TSpreadsheet.GetBottomRightCell;
begin
  GetBottomRightCell := SSGetBottomRightCell(HWindow)
end;

function TSpreadsheet.GetCellType;
begin
  GetCellType := SSGetCellType(HWindow, Col, Row, CellType)
end;

function TSpreadsheet.GetColor;
begin
  GetColor := SSGetColor(HWindow, Col, Row, Background, Foreground)
end;

function TSpreadsheet.GetColWidth;
begin
  GetColWidth := SSGetColWidth(HWindow, Col)
end;

{
function TSpreadsheet.GetCurrSelBlockPos;
begin
  GetCurrSelBlockPos := SSGetCurrSelBlockPos(HWindow, CurrCol, CurrRow)
end;
}

function TSpreadsheet.GetData;
begin
  GetData := SSGetData(HWindow, Col, Row, Data)
end;

function TSpreadsheet.GetDataLen;
begin
  GetDataLen := SSGetDataLen(HWindow, Col, Row)
end;

function TSpreadsheet.GetEditMode;
begin
  GetEditMode := SSGetEditMode(HWindow)
end;

function TSpreadsheet.GetFont;
begin
  GetFont := SSGetFont(HWindow, Col, Row)
end;

function TSpreadsheet.GetFormula;
begin
  GetFormula := SSGetFormula(HWindow, Col, Row, Formula)
end;

function TSpreadsheet.GetFormulaLen;
begin
  GetFormulaLen := SSGetFormulaLen(HWindow, Col, Row)
end;

{
function TSpreadsheet.GetLock;
begin
  GetLock := SSGetLock(HWindow, Col, Row)
end;
}

function TSpreadsheet.GetMaxCols;
begin
  GetMaxCols := SSGetMaxCols(HWindow)
end;

function TSpreadsheet.GetMaxRows;
begin
  GetMaxRows := SSGetMaxRows(HWindow)
end;

function TSpreadsheet.GetRowHeight;
begin
  GetRowHeight := SSGetRowHeight(HWindow, Row)
end;

function TSpreadsheet.GetSel;
begin
  GetSel := SSGetSel(HWindow, SelStart, SelEnd)
end;

function TSpreadsheet.GetSelectBlock;
begin
  GetSelectBlock := SSGetSelectBlock(HWindow, UL, LR)
end;

function TSpreadsheet.GetSelText;
begin
  GetSelText := SSGetSelText(HWindow)
end;

procedure TSpreadsheet.GetShadowColor;
begin
  SSGetShadowColor(HWindow, ShColor, ShText, ShDark, ShLight)
end;

function TSpreadsheet.GetTopLeftCell;
begin
  GetTopLeftCell := SSGetTopLeftCell(HWindow)
end;

function TSpreadsheet.GetVisible;
begin
  GetVisible := SSGetVisible(HWindow, Col, Row, Visible)
end;

{ Eigene Funktion }
function TSpreadsheet.HighlightRow;
var
  Row, Col: TSS_Coord;
  UL, LR  : TSS_CellCoord;
begin
  GetActiveCell(Col, Row);
  UL.Row := Row; UL.Col := 1;
  LR.Row := Row; LR.Col := GetMaxCols;
  HighlightRow := SetSelectBlock(UL, LR);
end;

function TSpreadsheet.InsCol;
begin
  InsCol := SSInsCol(HWindow, Col)
end;

function TSpreadsheet.InsRow;
begin
  InsRow := SSInsRow(HWindow, Row)
end;

function TSpreadsheet.LoadFromBuffer;
begin
  LoadFromBuffer := SSLoadFromBuffer(HWindow, hBuffer, BufLen)
end;

function TSpreadsheet.LoadFromFile;
begin
  LoadFromFile := SSLoadFromFile(HWindow, FileName)
end;

function TSpreadsheet.LogUnitsToColWidth;
begin
  LogUnitsToColWidth := SSLogUnitsToColWidth(HWindow, Units)
end;

function TSpreadsheet.ReCalc;
begin
  ReCalc := SSReCalc(HWindow)
end;

function TSpreadsheet.ReplaceSel;
begin
  ReplaceSel := SSReplaceSel(HWindow, lpText)
end;

function TSpreadsheet.RowHeightToLogUnits;
begin
  RowHeightToLogUnits := SSRowHeightToLogUnits(HWindow, Row, RowHeight)
end;

function TSpreadsheet.SaveToBuffer;
begin
  SaveToBuffer := SSSaveToBuffer(HWindow, BufferLen, DataOnly)
end;

function TSpreadsheet.SaveToFile;
begin
  SaveToFile := SSSaveToFile(HWindow, FileName, DataOnly)
end;

function TSpreadsheet.SetActiveCell;
begin
  SetActiveCell := SSSetActiveCell(HWindow, Col, Row)
end;

function TSpreadsheet.SetBool;
begin
  SetBool := SSSetBool(HWindow, Index, NewVal)
end;

function TSpreadsheet.SetCellType;
begin
  SetCellType := SSSetCellType(HWindow, Col, Row, CellType)
end;

function TSpreadsheet.SetCellTypeRange;
begin
  SetCellTypeRange := SSSetCellTypeRange(HWindow, Col, Row, Col2, Row2, CellType)
end;

function TSpreadsheet.SetColor;
begin
  SetColor := SSSetColor(HWindow, Col, Row, Background, Foreground)
end;

function TSpreadsheet.SetColorRange;
begin
  SetColorRange := SSSetColorRange(HWindow, Col, Row, Col2, Row2, Background, Foreground)
end;

function TSpreadsheet.SetColWidth;
begin
  SetColWidth := SSSetColWidth(HWindow, Col, Height)
end;

function TSpreadsheet.SetData;
begin
  SetData := SSSetData(HWindow, Col, Row, Data)
end;

function TSpreadsheet.SetDataRange;
begin
  SetDataRange := SSSetDataRange(HWindow, Col, Row, Col2, Row2, Data)
end;

function TSpreadsheet.SetEditMode;
begin
  SetEditMode := SSSetEditMode(HWindow, EditModeOn)
end;

function TSpreadsheet.SetFont;
begin
  SetFont := SSSetFont(HWindow, Col, Row, Font, DeleteFont)
end;

function TSpreadsheet.SetFontRange;
begin
  SetFontRange := SSSetFontRange(HWindow, Col, Row, Col2, Row2, Font, DeleteFont)
end;

function TSpreadsheet.SetFormula;
begin
  SetFormula := SSSetFormula(HWindow, Col, Row, Formula, BuildDep)
end;

function TSpreadsheet.SetFormulaRange;
begin
  SetFormulaRange := SSSetFormulaRange(HWindow, Col, Row, Col2, Row2, Formula, BuildDep)
end;

function TSpreadsheet.SetLock;
begin
  SetLock := SSSetLock(HWIndow, Col, Row, Lock)
end;

function TSpreadsheet.SetRowHeight(Row: TSS_Coord; Height: Double): Boolean;
begin
  SetRowHeight := SSSetRowHeight(HWindow, Row, Height)
end;

function TSpreadsheet.SetSel;
begin
  SetSel := SSSetSel(HWIndow, SelStart, SelEnd)
end;

function TSpreadSheet.SetSelectBlock(var CellUL, CellLR: TSS_CellCoord): Boolean;
begin
  SetSelectBlock := SSSetSelectBlock(HWindow, CellUL, CellLR)
end;

function TSpreadsheet.SetLockRange;
begin
  SetLockRange := SSSetLockRange(HWindow, Col, Row, Col2, Row2, Lock)
end;

procedure TSpreadsheet.SetShadowColor(ShColor, ShTxt, ShDark, ShLight: TColorRef);
begin
  SSSetShadowColor(HWindow, ShColor, ShTxt, ShDark, ShLight)
end;

function TSpreadsheet.SetTypeDate; { (var CellType: TSS_CellType; Style: Longint; var Format: TDateFormat;
                      var Min, Max: TDate) : PSS_CellType; }
begin
  SetTypeDate := SSSetTypeDate(HWindow, CellType, Style, Format, Min, Max)
end;


function TSpreadsheet.SetTypeEdit(var CellType: TSS_CellType; Style: Longint; Len, ChrSet: Integer;
                      ChrCase: Byte) : PSS_CellType;
begin
  SetTypeEdit := SSSetTypeEdit(HWindow, CellType, Style, Len, ChrSet, ChrCase)
end;


function TSpreadsheet.SetTypeFloat(var CellType: TSS_CellType; Style: Longint; Left, Right: Integer;
                      Min, Max: Double) : PSS_CellType;
begin
  SetTypeFloat := SSSetTypeFloat(HWindow, CellType, Style, Left, Right, Min, Max)
end;

function TSpreadsheet.SetTypeInteger(var CellType: TSS_CellType; Min, Max: Longint) : PSS_CellType;
begin
  SetTypeInteger := SSSetTypeInteger(HWindow, CellType, Min, Max)
end;

function TSpreadsheet.SetTypePic(var CellType: TSS_CellType; Style: Longint; Mask: PChar) : PSS_CellType;
begin
  SetTypePic := SSSetTypePic(HWindow, CellType, Style, Mask)
end;

function TSpreadsheet.SetTypePicture(var CellType: TSS_CellType; Style: Longint; PictName: PChar) : PSS_CellType;
begin
  SetTypePicture := SSSetTypePicture(HWindow, CellType, Style, PictName)
end;

function TSpreadsheet.SetTypeStaticText(var CellType: TSS_CellType; Style: Integer) : PSS_CellType;
begin
  SetTypeStaticText := SSSetTypeStaticText(HWindow, CellType, Style)
end;

function TSpreadsheet.SetTypeTime(var CellType: TSS_CellType; Style: Longint; var Format: TTimeFormat;
                      var Min, Max: TTime) : PSS_CellType;
begin
  SetTypeTime := SSSetTypeTime(HWindow, CellType, Style, Format, Min, Max)
end;

function TSpreadsheet.ShowActiveCell(Position: Integer)	: Boolean;
begin
  ShowActiveCell := SSShowActiveCell(HWindow, Position)
end;

function TSpreadsheet.ShowCell(Col, Row: TSS_Coord; Position: Integer) : Boolean;
begin
  ShowCell := SSShowCell(HWindow, Col, Row, Position)
end;

function TSpreadsheet.ValidateFormula(Formula: PChar) : Boolean;
begin
  ValidateFormula := SSValidateFormula(HWindow, Formula)
end;

{---------------------------------------------------------------------------------------------------- }
{ FLOAT CONTROL IMPLEMENTATION 	           							      }
{---------------------------------------------------------------------------------------------------- }

constructor TFloatEdit.Init(aParent: PWindowsObject; AnID: Integer; ATitle: PChar; X,Y,W,H: Integer);
begin
  TStatic.Init(aParent, anID, aTitle, X,Y,W,H, 12);
  Attr.Style := (Attr.Style and not ss_Left) or ws_Border or ws_TabStop;
end;

function TFloatEdit.GetClassName : PChar;
begin
  GetClassName := 'tbFloat'
end;

function TFloatEdit.GetFormat(var Fmt: TFloatFormat) : Boolean;
begin
  GetFormat := FloatGetFormat(HWindow, Fmt)
end;

function TFloatEdit.GetRange(var Min, Max: Double) : Boolean;
begin
  GetRange := FloatGetRange(HWindow, Min, Max)
end;

function TFloatEdit.GetValue(var LongValue: Double) : Boolean;
begin
  GetValue := FloatGetValue(HWindow, LongValue)
end;

function TFloatEdit.SetFormat(var Fmt: TFloatFormat) : Boolean;
begin
  SetFormat := FloatSetFormat(HWindow, Fmt)
end;

function TFloatEdit.SetMask(Mask: PChar) : Boolean;
begin
  SetMask := FloatSetMask(HWindow, Mask)
end;

function TFloatEdit.SetRange(Min, Max: Longint) : Boolean;
begin
  SetRange := FloatSetRange(HWindow, Min, Max)
end;

function TFloatEdit.SetStyle(Style: Longint) : Boolean;
begin
{
  SetStyle := FloatSetStyle(HWindow, Style)
}
end;

function TFloatEdit.SetValue(LongValue: Longint) : Boolean;
begin
  SetValue := FloatSetValue(HWindow, LongValue)
end;


{---------------------------------------------------------------------------------------------------- }
{ INTEGER CONTROL IMPLEMENTATION 								      }
{---------------------------------------------------------------------------------------------------- }

constructor TIntEdit.Init(aParent: PWindowsObject; AnID: Integer; ATitle: PChar; X,Y,W,H: Integer);
begin
  TStatic.Init(aParent, anID, aTitle, X,Y,W,H, 10);
  Attr.Style := (Attr.Style and not ss_Left) or ws_Border or ws_TabStop;
end;

function TIntEdit.GetClassName: PChar;
begin
  GetClassName := 'tbInteger';
end;

function TIntEdit.GetValue(var LongValue: Longint) : Boolean;
begin
  GetValue := IntGetValue(HWindow, LongValue)
end;

function TIntEdit.SetMask(Mask: PChar) : Boolean;
begin
  SetMask := IntSetMask(HWindow, Mask)
end;

function TIntEdit.SetRange(Min, Max: Longint) : Boolean;
begin
  SetRange := IntSetRange(HWindow, Min, Max)
end;

function TIntEdit.SetSpin(Spin, SpinWrap: Boolean; SpinInc: Longint) : Boolean;
begin
  SetSpin := IntSetSpin(HWindow, Spin, SpinWrap, SpinInc)
end;

function TIntEdit.SetValue(LongValue: Longint) : Boolean;
begin
  SetValue := IntSetValue(HWindow, LongValue)
end;


{---------------------------------------------------------------------------------------------------- }
{ PIC CONTROL IMPLEMENTATION 								              }
{---------------------------------------------------------------------------------------------------- }

constructor TPicEdit.Init(aParent: PWindowsObject; AnID: Integer; ATitle: PChar; X,Y,W,H: Integer);
begin
  TStatic.Init(aParent, anID, aTitle, X,Y,W,H, StrLen(ATitle));
  Attr.Style := (Attr.Style and not ss_Left) or ws_Border or ws_TabStop;
end;

function TPicEdit.GetClassName : PChar;
begin
  GetClassName := 'tbPic';
end;

function TPicEdit.GetMask(Mask: PChar) : Boolean;
begin
  SendMessage(HWindow, EPM_GETMASK, 0, Longint(Mask));
  GetMask := True;
end;

function TPicEdit.SetCallBack : Boolean;
begin
  SetCallBack := False
end;

function TPicEdit.SetMask(Mask: PChar) : Boolean;
begin
  SendMessage(HWindow, EPM_SETMASK, 0, Longint(Mask));
  SetMask := True;
end;


{----------------------------------------------------------------------------------------------------------}
{ IMPRINT CONTROL IMPLEMENTATION                                                                           }
{----------------------------------------------------------------------------------------------------------}

constructor TImprint.Init(aParent: PWindowsObject; AnID: Integer; ATitle: PChar; X,Y,W,H: Integer);
begin
  TStatic.Init(aParent, anID, aTitle, X,Y,W,H, StrLen(ATitle));
  Attr.Style := (Attr.Style and not ss_Left) or ws_Border or ws_TabStop;
end;

function TImprint.GetClassName : PChar;
begin
  GetClassName := 'tbImprint';
end;

procedure TImprint.GetColor(var ImprintColor: TImprintColor);
begin
  SendMessage(HWindow, IM_GETCOLOR, 0, Longint(@ImprintColor));
end;

function TImprint.GetFrameSize : Word;
begin
  GetFrameSize := SendMessage(HWindow, IM_GETFRAMESIZE, 0, 0);
end;

function TImprint.GetLineCnt : Longint;
begin
  GetLineCnt := SendMessage(HWindow, IM_GETLINECNT, 0, 0);
end;

function TImprint.GetLineSize : Word;
begin
  GetLineSize := SendMessage(HWindow, IM_GETLINESIZE, 0, 0);
end;

function TImprint.GetShadowSize : Word;
begin
  GetShadowSize := SendMessage(HWindow, IM_GETSHADOWSIZE, 0, 0);
end;

procedure TImprint.SetColor(var ImprintColor: TImprintColor);
begin
  SendMessage(HWindow, IM_SETCOLOR, 0, Longint(@ImprintColor));
end;

procedure TImprint.SetFrameSize(Size: Word);
begin
  SendMessage(HWindow, IM_SETFRAMESIZE, Size, 0);
end;

procedure TImprint.SetLineCnt(Horiz, Vert: Word);
begin
  SendMessage(HWindow, IM_SETLINECNT, MakeLong(Horiz, Vert), 0);
end;

procedure TImprint.SetLineSize(Size: Word);
begin
end;

procedure TImprint.SetShadowSize(Size: Word);
begin
end;


{----------------------------------------------------------------------------------------------------------}
{ SUPERBUTTON CONTROL CLASS                                                                                }
{----------------------------------------------------------------------------------------------------------}

constructor TSuperButton.Init(aParent: PWindowsObject; AnID: Integer; ATitle: PChar; X,Y,W,H: Integer);
begin
  TButton.Init(aParent, anID, aTitle, X,Y,W,H, False);
end;

function TSuperButton.GetClassName : PChar;
begin
  GetClassName := 'tbSuperBtn';
end;

procedure TSuperButton.GetColor(var Color: TSuperBtnColor);
begin
  SendMessage(HWindow, SBM_GETCOLOR, 0, Longint(@Color));
end;

procedure TSuperButton.SetColor(var Color: TSuperBtnColor);
begin
  SendMessage(HWindow, SBM_SETCOLOR, 0, Longint(@Color));
end;

function TSuperButton.SetPict(PicType: Word; Resource: PChar) : Boolean;
begin
  SetPict := Boolean(SendMessage(HWindow, SBM_SETPICT, PicType, LongInt(Resource)));
end;

function TSuperButton.SetPictBtnDown(PicType: Word; Resource: PChar) : Boolean;
begin
  SetPictBtnDown := Boolean(SendMessage(HWindow, SBM_SETPICT_BTNDOWN, PicType, Longint(Resource)));
end;

function TSuperButton.SetPictDisabled(PicType: Word; Resource: PChar) : Boolean;
begin
  SetPictDisabled := Boolean(SendMessage(HWindow, SBM_SETPICT_DISABLED, PicType, Longint(Resource)));
end;

procedure TSuperButton.SetStyle(Style: Word);
begin
  SendMessage(HWindow, SBM_SETSTYLE, Style, 0);
end;




{---------------------------------------------------------------------------------------------------- }
{ DATE CONTROL IMPLEMENTATION 	           							      }
{---------------------------------------------------------------------------------------------------- }

constructor TDateEdit.Init(aParent: PWindowsObject; AnID: Integer; ATitle: PChar; X,Y,W,H: Integer);
begin
  TEdit.Init(aParent, anID, aTitle, X,Y,W,H,10, false);
  Attr.Style := (Attr.Style and not ss_left) or ws_Border or ws_TabStop
end;

function TDateEdit.GetClassName: PChar;
begin
  GetClassName := 'tbDate'
end;

function TDateEdit.GetFormat(var DateFmt: TDateFormat) : Boolean;
begin
  GetFormat := DateGetFormat(HWindow, DateFmt)
end;

function TDateEdit.SetFormat(var DateFmt: TDateFormat) : Boolean;
begin
  SetFormat := DateSetFormat(HWindow, DateFmt)
end;

function TDateEdit.SetRange(var MinDate, MaxDate: TDate) : Boolean;
begin
  SetRange := DateSetRange(HWindow, MinDate, MaxDate)  {Fehler!!!???}
end;

begin
end.

