TITLE "Special circumstance alternative QWK/REP mail run"
;----------------------------------------------------------------------
; QWKMAIL.RS -- Alternative to standard "G"et Mail and "S"end Replies
;......................................................................
;
; Author:  Dan Parsons
; Version: 1.0
; Revised: 4/24/92
;
; Notes:
;
;    * Should work fine for both Wildcat and PCBoard
;      MAKE SURE CORRECT PROMPT SET IS LOADED!
;
;    * DOES NOT check for insufficient time for transfer
;
; Why use this script?
;
;    * You are running a "His and Hers" install of Robocomm and want to
;      be able to do two mail runs to separate directories and need to
;      work around Robocomm's requirement of unique BBS IDs.
;
;    * You are a sysop and need to log in to do a net mail run using a
;      different BBS ID name and don't want to create a separate
;      Robocomm installation to do it.
;
;    * You want to drop carrier immediately after sending replies.
;
;    * You want to keep a separate log file of your mail run.
;
;----------------------------------------------------------------------
;
; BBS Macros used in this script:
;
;   40      Mail Door (TomCat) Command Prompt
;   41      Start Mail Download
;   42      Start Mail Upload
;   43      Packet Transfer Confirmation.
;   44      No Mail to Download
;
;----------------------------------------------------------------------
PARAMETER 1 "Alternate BBS/QWK ID     (8 chars max)"
PARAMETER 2 "Alternate QWK dir (include ending '\')"
PARAMETER 3 "Alternate REP dir (include ending '\')"
PARAMETER 4 "Hang up after sending REP        (Y/N)"
PARAMETER 5 "Mail run log file           (optional)"
ENDPARAMS

    ; Verify that the 3 necessary parameters were entered.
    IF EMPTY "%P1%" GOTO PARAM_ERROR
    IF EMPTY "%P2%" GOTO PARAM_ERROR
    IF EMPTY "%P3%" GOTO PARAM_ERROR

    ; Set up capture file
    ; Change "overwrite" below to "append" if desired.
    IF NOT EMPTY "%P5%" CAPTURE "%P5%" OVERWRITE

    ; Default to ten minutes to scan for mail.
    ; Edit this if desired.
    TIMEOUT 600

    ; Get to mail door
    VENUE MAIL

    ; Request the packet
    SEND "D|"

    WHEN "%BBS43%" SEND "Y|"
    WHEN "%BBS44%" GOTO SENDREP
    WAITFOR "%BBS41%" FAILURE GOTO SLOW_BBS

    ; Keep 3 old QWK packets by default.
    ; Edit this if desired.
    IF EXIST "%P2%%P1%.QWK" RENUMBER "%P2%%P1%.QWK" 3

    ; Download the QWK packet.
    MESSAGE "Downloading %P2%%P1%.QWK"
    DOWNLOAD "%P2%%P1%.QWK" USING "%BBS22%"

    GOSUB GET_TO_COMMAND

GOTO SENDREP
 
:SENDREP
    IF NOT EXIST "%P3%%P1%.REP" GOTO NOREP
    SEND "U|"
    WAITFOR "%BBS42%" FAILURE GOTO I_AM_LOST
    MESSAGE "Uploading %P3%%P1%.REP"
    UPLOAD "%P3%%P1%.REP" USING "%BBS21%"
    ; Will keep up to 3 old rep packets.  Edit if desired.
    RENUMBER "%P3%%P1%.REP" 3
GOTO ENDRUN

:NOREP
    MESSAGE "No %P3%%P1%.REP to send"
GOTO ENDRUN

:ENDRUN
    IF YES "%P5%" GOTO DROP_CARRIER
    GOSUB GET_TO_COMMAND
    CLOSE
EXIT 0

:DROP_CARRIER
    MESSAGE "Dropping carrier per request"
    HANGUP
    CLOSE
EXIT 0

:GET_TO_COMMAND
    SEND "|"
    CLEAR
    WHEN "%BBS32%" SEND "|"
    WHEN "%BBS24%" SEND "|"
    WAITFOR "%BBS40%" FAILURE GOTO I_AM_LOST
RETURN
 
:SLOW_BBS
    MESSAGE "^UERROR:^U Timeout during mail run."
    HANGUP
    CLOSE
EXIT 1

:I_AM_LOST
    MESSAGE "^UERROR:^U Sorry - I am lost."
    HANGUP
    CLOSE
EXIT 1

:PARAM_ERROR
    MESSAGE "^UERROR:^U Parameters 1, 2 and 3 are required!"
    CLOSE
EXIT 1

;eof
