;-----------------------------------------------------------------------
; MEGAMAIL.RS -- Send/Get MegaMail using internal Zmodem
;.......................................................................
; Author:   Dan Parsons
; Version:  1.0
; Date:     04/27/92
;
; Notes:    This script expects to find a .UL file in the configured
;           REP dir with the name <BBSID>.UL.  For example, on Group
;           One BBS, the script would look for GROUPONE.UL in the
;           configured REP file directory.
;
;           Incoming .DL files will be re-numbered appropriately, and
;           placed in your configured QWK (incoming mail) directory.
;
;-----------------------------------------------------------------------
TITLE "MegaMail Mail Run (Internal Zmodem)"
PARAMETER 1 "MegaMail door to open"
ENDPARAMS

    ; May need to be increased for slow boards or lots of mail
    TIMEOUT 240

    ; Make sure we have a .UL file
    IF NOT EXIST "%REPDIR%%ID%.UL" GOTO NO_UL_FILE

    VENUE MAIN
    SEND "OPEN %P1%|"

    ; Send the outgoing mail
    WAITFOR "*"
    MESSAGE "Sending %REPDIR%%ID%.UL reply packet"
    UPLOAD "%REPDIR%%ID%.UL" USING "ZMODEM"
    RENUMBER "%REPDIR%%ID%.UL"

    ; Get the incoming mail
    MESSAGE "Receiving %QWKDIR%%ID%.DL message packet"
    IF EXIST "%QWKDIR%%ID%.DL" RENUMBER "%QWKDIR%%ID%.DL"
    WAITFOR "*"
    DOWNLOAD "%QWKDIR%%ID%.DL" USING "ZMODEM"

    ; Wait until we get back to the main board to return
    VENUE MAIN

EXIT 0

:NO_UL_FILE
    MESSAGE "No .UL file found.  I'm looking for: %REPDIR%%ID%.UL"
EXIT 1

