program Scanfile;

var str : string;
    l : word;
    ip, op : text;

procedure erasef(fstr : string);
var f : file;
begin
 assign(f,fstr);
 {$I+} reset(f); {$I-}
 if IOerror = 0 then
  begin
   close(f);
   erase(f);
  end;
end;

function upper(s : string) : string;
var loop : word;
begin
 for loop := 1 to length(s) do
  s[loop] := upcase(s[loop]);
 upper := s;
end;

function ltrim(s : string) : string;
begin
 while pos(' ',s) = 1 do
  s := copy(s,2,255);
 ltrim := s;
end;

function str2num(s : string) : longint;
var code : integer;
    num : longint;
begin
 if length(s) = 0 then
  str2num := 0
 else
  begin
   val(s,num,code);
   if code <> 0 then
    str2num := 0
   else
    str2num := num;
  end
end;

procedure openinput(ifil : string);
begin
 assign(ip,ifil); reset(ip);
end;

procedure openoutput(ofil : string);
begin
 if ofil = '' then
  assign(op,'')
 else
  assign(op,ofil);
  rewrite(op);
end;

procedure closefiles;
begin
 close(ip);
 close(op);
end;

procedure scanfilenumber(ipfil,opfil : string;
                         startln, endln : word );
var open : boolean;
begin
 open := false;
 erasef(opfil);
 openinput(ipfil);
 for l := 1 to startln do
  if not eof(ip) then readln(ip,str);

 for l := startln to endln do
  if not eof(ip) then
   begin
    readln(ip,str);
    if not open then
     begin
      openoutput(opfil);
      open := true
     end;
    writeln(op,str);
   end;
 if open then closefiles;
end;

procedure scanfilenum2string(ipfil,opfil : string;
                             startln : word;
                             endstr : string);
var open : boolean;
begin
 open := false;
 erasef(opfil);
 openinput(ipfil);
 for l := 1 to startln - 1 do
  if not eof(ip) then readln(ip,str);

 while (not eof(ip)) and (upper(str) <> endstr) do
  begin
   readln(ip,str);
   if not open then
    begin
     openoutput(opfil);
     open := true
    end;
   writeln(op,str)
  end;
 if open then closefiles;
end;

procedure scanfilestring(ipfil,opfil,startstr, endstr : string);

var open, found : boolean;

begin
 open := false;
 found := false;
 erasef(opfil);
 openinput(ipfil);
 while (upper(str) <> startstr) and (not eof(ip)) do
   readln(ip,str);

 while (upper(str) <> endstr) and (not eof(ip)) do
  begin
   found := true;
   if not open then
    begin
     openoutput(opfil);
     open := true
    end;
   writeln(op,str);
   readln(ip,str);
  end;
 if found then writeln(op,str);
 if open then closefiles;

end;

procedure scanvarfile(ipfil,opfil : string);
var open : boolean;
begin
 openinput(ipfil);
 erasef(opfil);
 open := false;
 while not eof(ip) do
  begin
   readln(ip,str);
   while pos('{',str) > 0 do
    begin
     if not open then
      begin
       openoutput(opfil);
       open := true
      end;
     writeln(op,copy(str,pos('{',str) + 1,pos('}',str) - pos('{',str) - 1));
     str := copy(str,pos('}',str) + 1,255);
    end;
  end;
 if open then closefiles;
end;

procedure scanfilebyte(ipfile:string;stbyte,endbyte:longint);
var f : file of char;
    ch : char;
begin
 assign(f,ipfile); reset(f);
 if (filesize(f) > stbyte) and (filesize(f) >= endbyte) then
  begin
   seek(f,stbyte);
   while filepos(f) < endbyte do
     begin
      read(f,ch);
      write(ch);
     end;
   writeln;
  end;
 close(f);
end;

procedure scanfileidx(ipfil:string; filenum : byte);
var txt : text;
    num2 : longint;

begin
 if filenum = 0 then filenum := 10;
 num2 := 0;
 assign(txt,ipfil);  reset(txt);
 while not eof(txt) do
  begin
   readln(txt,str);
   l := pos('.',str);
   if (l < filenum) and (l > 0) then
    writeln('{',num2,'}',str);
   num2 := num2 + length(str) + 2;
  end;
end;

begin
 str := upper(paramstr(1));
 if str = 'N' then
  scanfilenumber(paramstr(2),paramstr(5),str2num(paramstr(3)),str2num(paramstr(4)))
 else if str = 'S' then
  scanfilenum2string(paramstr(2),paramstr(5),str2num(paramstr(3)),upper(paramstr(4)))
 else if str = 'R' then
  scanfilestring(paramstr(2),paramstr(5),upper(paramstr(3)),upper(paramstr(4)))
 else if str = 'V' then
  scanvarfile(paramstr(2),paramstr(3))
 else if str = 'BYTE' then
  scanfilebyte(paramstr(2),str2num(paramstr(3)),str2num(paramstr(4)))
 else if str = 'IDX' then
  scanfileidx(paramstr(2)){,str2num(paramstr(3)))}
 else
  writeln('MG-UTIL v1.6 - Text file utility for Moo Goo Gai Pan Macros for {Commo}');
end.