#ifndef CELL_H
#define CELL_H

//      Each instance of this class represents a room in a maze.

class cell
  {
    private:
      char wall_present;
//      Bits representing whether or not a wall is present in a room.
//
//      For square rooms,
//           0x01 represents the north wall,
//           0x02 represents the west wall,
//           0x04 represents the south wall, and
//           0x08 represents the east wall.
//      For hexagonal rooms,
//           0x01 represents the north wall,
//           0x02 represents the northwest wall,
//           0x04 represents the southwest wall, 
//           0x08 represents the south wall.
//           0x10 represents the southeast wall, and
//           0x20 represents the northeast wall.

      int  order_to_check_walls;
//      For square rooms, there are 24 (=4!) orders in which the walls may be
// checked.
//      For hexagonal rooms, there are 720 (=6!) orders in which the walls may
// be checked.

      char wall_to_check;
//      Number of wall (within the current order) to be checked next.

      char mark_on_floor;
//      'M' if room has not been excavated,
//      'S' if room is part of solution (or proposed solution), or
//      ' ' if room has been excavated.

      char direction_to_exit;
//      Opposite of direction by which room was first entered.
//      For square rooms,
//           0x01 represents north,
//           0x02 represents west,
//           0x04 represents south, and
//           0x08 represents east.
//      For hexagonal rooms,
//           0x01 represents north,
//           0x02 represents northwest,
//           0x04 represents southwest, 
//           0x08 represents south.
//           0x10 represents southeast, and
//           0x20 represents northeast.

    public:
      cell(void)
        {
          wall_to_check='\0';
          mark_on_floor='M';
          wall_present=(char) 0x3f;
        }
//      Rooms are initially filled with mud (i.e., not excavated) and all
// walls are present.

      char mark(void) {return mark_on_floor;}
//      'M' for not excavated, ' ' for excavated, 'S' for part of solution.

      void knock_down_wall(char wall_num);
//      Changes the bit for the appropriate wall to zero.
//      For square rooms,
//           0 represents the north wall,
//           1 represents the west wall,
//           2 represents the south wall, and
//           3 represents the east wall.
//      For hexagonal rooms,
//           0 represents the north wall,
//           1 represents the northwest wall,
//           2 represents the southwest wall, 
//           3 represents the south wall.
//           4 represents the southeast wall, and
//           5 represents the northeast wall.

      void mark_floor(char mark) {mark_on_floor=mark;}
//      Mark made by excavator ('M' for not excavated or ' ' for excavated)
// or solver ('S' for part of proposed solution).

      char next_wall_num(void) {return wall_to_check++;}
      void reinitialize(void)
        {
          wall_to_check='\0';
          mark_on_floor='M';
          wall_present=(char) 0x3f;
        }
//     Walls are erected and room is filled with mud.

      int  order_to_check(void) {return order_to_check_walls;}

      void set_order(int order) {order_to_check_walls=order;}

      void zero_wall_to_check(void) {wall_to_check='\0';}

      void set_way_out(char way_out) {direction_to_exit=way_out;}

      int  wall_up(char wall_num);
//     Returns whether or not a wall is present.
//      For square rooms,
//           0 represents the north wall,
//           1 represents the west wall,
//           2 represents the south wall, and
//           3 represents the east wall.
//      For hexagonal rooms,
//           0 represents the north wall,
//           1 represents the northwest wall,
//           2 represents the southwest wall, 
//           3 represents the south wall.
//           4 represents the southeast wall, and
//           5 represents the northeast wall.

      char way_back(void) {return direction_to_exit;}
  };

#endif
