/*

Title:	P5BUG
Date:	14 December 1994
Author: William Luitje - luitje@m-net.arbornet.org
Descr:	This program performs a simple test for the Pentium floating point
	bug using the parameters found by Tim Coe.  If you modify this
	program, don't forget to specify hardware floating point when you
	re-compile it.	I compiled the code I released using Microsoft C
	version 7.0 with the following switches:

	/Od /FPi87 /Gs

Rights: The author releases this program, both source and executable, into
	the public domain.  You are responsible for your use of this program
	and the decisions you make with the information it provides.

*/

main()
{
    double test, error, x=4195835.0, y=3145727.0;
    unsigned char far *EQUIPMENT = (unsigned char far *)0x00400010;

    printf("Pentium FPU bug checker, Version 1.0 by luitje@m-net.arbornet.org\n\n");

    if((*EQUIPMENT & 2) == 0) {
	printf("No FPU detected.\n");
	exit(1); }

    printf("This program will test the Floating Point Unit (FPU) of your Pentium\n");
    printf("processor for an error which causes a loss of precision in some\n");
    printf("particular floating point calculations.  The Pentium was produced\n");
    printf("for almost two years before the problem was noticed so it's not a\n");
    printf("common occurence but some calculations can be off by quite a bit.\n");
    printf("According to Intel, the bug is present for all Pentiums built before\n");
    printf("about October 1994 but is not known to occur in any other Intel FPU.\n\n");
    printf("This program computes the following function:\n\n");
    printf("error = 1.0 - (%.1f/%.1f)*%.1f\n\n",x,y,y);
    printf("Mathematically, error is 0 but the Pentium computes 256!\n\n");

    test = x/y;
    test = test * y;
    error = x - test;
    printf("Error is %1.20le\n\n",error);

    if(error > (double) 0.00000000001 || error < (double) -0.00000000001)
	printf("Your Pentium is \"flawed\".\n");
    else
	printf("Your FPU passes this test.\n");
}
