From eliz@is.elta.co.ilTue Dec  5 18:19:52 1995
Date: Tue, 5 Dec 1995 19:17:33 +0200 (IST)
From: Eli Zaretskii <eliz@is.elta.co.il>
To: Kevin Gallagher <kgallagh@spdmail.spd.dsccc.com>,
    Marc Fleischeuers <marc@mpi.nl>, Morten Welinder <terra@diku.dk>,
    Richard Stallman <rms@gnu.ai.mit.edu>
Subject: `call-process' with stderr redirection under DOS

The patch below makes `call-process' (and `call-process-region') support 
stderr redirection under DOS, like on other platforms.  The original code 
didn't support it because (as I understood from Morten) it goes back to 
the days when Emacs had this behavior under Unix also.

A couple of minor problems (like failure to assign values to variables 
which record process exit status) are also corrected here.

*** src/msdos.c~1	Tue Dec  5 18:17:12 1995
--- src/msdos.c	Tue Dec  5 18:37:52 1995
***************
*** 2198,2209 ****
  
  
  /* Run command as specified by ARGV in directory DIR.
!    The command is run with input from TEMPIN and output to file TEMPOUT.  */
  int
! run_msdos_command (argv, dir, tempin, tempout)
       unsigned char **argv;
       Lisp_Object dir;
!      int tempin, tempout;
  {
    char *saveargv1, *saveargv2, **envv;
    char oldwd[MAXPATHLEN + 1]; /* Fixed size is safe on MSDOS.  */
--- 2198,2210 ----
  
  
  /* Run command as specified by ARGV in directory DIR.
!    The command is run with input from TEMPIN, output to
!    file TEMPOUT and stderr to TEMPERR.  */
  int
! run_msdos_command (argv, dir, tempin, tempout, temperr)
       unsigned char **argv;
       Lisp_Object dir;
!      int tempin, tempout, temperr;
  {
    char *saveargv1, *saveargv2, **envv;
    char oldwd[MAXPATHLEN + 1]; /* Fixed size is safe on MSDOS.  */
***************
*** 2274,2280 ****
    
    dup2 (tempin, 0);
    dup2 (tempout, 1);
!   dup2 (tempout, 2);
  
    result = spawnve (P_WAIT, argv[0], argv, envv);
    
--- 2275,2281 ----
    
    dup2 (tempin, 0);
    dup2 (tempout, 1);
!   dup2 (temperr, 2);
  
    result = spawnve (P_WAIT, argv[0], argv, envv);
    
*** src/callproc.c~0	Fri Oct  6 19:20:04 1995
--- src/callproc.c	Tue Dec  5 18:37:52 1995
***************
*** 324,335 ****
    }
  
  #ifdef MSDOS /* MW, July 1993 */
-   /* These vars record information from process termination.
-      Clear them now before process can possibly terminate,
-      to avoid timing error if process terminates soon.  */
-   synch_process_death = 0;
-   synch_process_retcode = 0;
- 
    if ((outf = egetenv ("TMP")) || (outf = egetenv ("TEMP")))
      strcpy (tempfile = alloca (strlen (outf) + 20), outf);
    else
--- 324,329 ----
***************
*** 349,354 ****
--- 343,349 ----
        close (filefd);
        report_file_error ("Opening process output file", Fcons (tempfile, Qnil));
      }
+   fd[1] = outfilefd;
  #endif
  
    if (INTEGERP (buffer))
***************
*** 388,408 ****
      synch_process_death = 0;
      synch_process_retcode = 0;
  
- #ifdef MSDOS /* MW, July 1993 */
-     /* ??? Someone who knows MSDOG needs to check whether this properly
-        closes all descriptors that it opens.  */
-     pid = run_msdos_command (new_argv, current_dir, filefd, outfilefd);
-     close (outfilefd);
-     fd1 = -1; /* No harm in closing that one!  */
-     fd[0] = open (tempfile, NILP (Vbinary_process_output) ? O_TEXT : O_BINARY);
-     if (fd[0] < 0)
-       {
- 	unlink (tempfile);
- 	close (filefd);
- 	report_file_error ("Cannot re-open temporary file", Qnil);
-       }
- #else /* not MSDOS */
- 
      if (NILP (error_file))
        fd_error = open (NULL_DEVICE, O_WRONLY);
      else if (STRINGP (error_file))
--- 383,388 ----
***************
*** 424,430 ****
--- 404,438 ----
  	  close (fd1);
  	report_file_error ("Cannot open", error_file);
        }
+ #ifdef MSDOS /* MW, July 1993 */
+     /* ??? Someone who knows MSDOG needs to check whether this properly
+        closes all descriptors that it opens.
+ 
+        Note that run_msdos_command() actually returns the child process
+        exit status, not its PID, so we assign it to `synch_process_retcode'
+        below.  */
+     pid = run_msdos_command (new_argv, current_dir,
+ 			     filefd, outfilefd, fd_error);
+ 
+     /* Record that the synchronous process exited and note its
+        termination status.  */
+     synch_process_alive = 0;
+     synch_process_retcode = pid;
+     if (synch_process_retcode < 0)  /* means it couldn't be exec'ed */
+       synch_process_death = strerror(errno);
  
+     close (outfilefd);
+     if (fd_error != outfilefd)
+       close (fd_error);
+     fd1 = -1; /* No harm in closing that one!  */
+     fd[0] = open (tempfile, NILP (Vbinary_process_output) ? O_TEXT : O_BINARY);
+     if (fd[0] < 0)
+       {
+ 	unlink (tempfile);
+ 	close (filefd);
+ 	report_file_error ("Cannot re-open temporary file", Qnil);
+       }
+ #else /* not MSDOS */
  #ifdef WINDOWSNT
      pid = child_setup (filefd, fd1, fd_error, new_argv, 0, current_dir);
  #else  /* not WINDOWSNT */
***************
*** 441,448 ****
  #endif /* USG */
  	child_setup (filefd, fd1, fd_error, new_argv, 0, current_dir);
        }
- #endif /* not MSDOS */
  #endif /* not WINDOWSNT */
  
      environ = save_environ;
  
--- 449,456 ----
  #endif /* USG */
  	child_setup (filefd, fd1, fd_error, new_argv, 0, current_dir);
        }
  #endif /* not WINDOWSNT */
+ #endif /* not MSDOS */
  
      environ = save_environ;
  
