From eliz@is.elta.co.ilThu Dec 21 17:35:33 1995
Date: Thu, 21 Dec 1995 17:27:57 +0200 (IST)
From: Eli Zaretskii <eliz@is.elta.co.il>
To: Kevin Gallagher <kgallagh@spdmail.spd.dsccc.com>,
    Marc Fleischeuers <marc@mpi.nl>, Mickey Ferguson <mickeyf@stac.com>,
    Morten Welinder <terra@diku.dk>, Richard Stallman <rms@gnu.ai.mit.edu>,
    Karl Heuer <kwzh@gnu.ai.mit.edu>
Subject: Dired patches under DOS

The following patches allow `dired' to be called with a wildcard under
DOS, and also make `recover-session' work with `ls-lisp' (you need to
install the patch for startup.el I've sent earlier today to make 
`recover-session' work under DOS). 

Thu Dec 21 16:55:36 1995  Eli Zaretskii  <eliz@is.elta.co.il>

	* fileio.c (Ffile_readable_p) [MSDOS]: Use access() rather than
	open() (MS-DOS doesn't allow to open() a directory).  This makes
	`recover-session' work under MS-DOS, and also allows `dired' by
	wildcard.

*** src/fileio.c~0	Thu Dec 21 11:45:38 1995
--- src/fileio.c	Thu Dec 21 12:00:14 1995
***************
*** 2460,2470 ****
--- 2460,2478 ----
    if (!NILP (handler))
      return call2 (handler, Qfile_readable_p, abspath);
  
+ #ifdef MSDOS
+   /* Under MS-DOS, open() isn't right, because it doesn't work for
+      directories (MS-DOS won't let you open() a directory).  */
+   if (access (XSTRING (abspath)->data, 0) == 0)
+     return Qt;
+   return Qnil;
+ #else /* not MSDOS */
    desc = open (XSTRING (abspath)->data, O_RDONLY);
    if (desc < 0)
      return Qnil;
    close (desc);
    return Qt;
+ #endif /* not MSDOS */
  }
  
  /* Having this before file-symlink-p mysteriously caused it to be forgotten

Thu Dec 21 16:55:36 1995  Eli Zaretskii  <eliz@is.elta.co.il>

	* files.el (recover-session): If `ls-lisp' is loaded, use a
	different wildcard, suitable for `insert-directory' defined by
	that package.

*** lisp/files.e~1	Thu Dec 21 15:02:34 1995
--- lisp/files.el	Thu Dec 21 15:44:24 1995
***************
*** 2193,2199 ****
  To choose one, move point to the proper line and then type C-c C-c.
  Then you'll be asked about a number of files to recover."
    (interactive)
!   (dired (concat auto-save-list-file-prefix "*"))
    (goto-char (point-min))
    (or (looking-at "Move to the session you want to recover,")
        (let ((inhibit-read-only t))
--- 2193,2199 ----
  To choose one, move point to the proper line and then type C-c C-c.
  Then you'll be asked about a number of files to recover."
    (interactive)
!   (dired (concat auto-save-list-file-prefix (if (featurep 'ls-lisp) ".*" "*")))
    (goto-char (point-min))
    (or (looking-at "Move to the session you want to recover,")
        (let ((inhibit-read-only t))
