From eliz@is.elta.co.ilTue Dec 12 17:31:02 1995
Date: Tue, 12 Dec 1995 18:02:21 +0200 (IST)
From: Eli Zaretskii <eliz@is.elta.co.il>
To: Kevin Gallagher <kgallagh@spdmail.spd.dsccc.com>,
    Marc Fleischeuers <marc@mpi.nl>, Mickey Ferguson <mickeyf@stac.com>,
    Morten Welinder <terra@diku.dk>, Richard Stallman <rms@gnu.ai.mit.edu>
Subject: Patch for compile.el under DOS

The following patch makes `M-x compile' and its sisters look and work
under DOS (or any other OS without async processes) more like what you'd
see under Unix.  In particular, `compilation-finish-function' is called (I
use it to higlight the error messages with hilit19).  If anybody works
with a smart shell which returns the exit status of its children, please
check to see that the exit status is correctly printed in the modeline. 

Tue Dec 12 17:21:11 1995  Eli Zaretskii  <eliz@is.elta.co.il>

	* compile.el (compile-internal): On systems with no asynchronous
	processes: do relevant parts of compilation-sentinel after the
	process exits; make modeline during and after compilation be
	similar to what compilation-sentinel displays.

*** lisp/compile.e~0	Tue Nov 14 03:48:02 1995
--- lisp/compile.el	Tue Dec 12 17:19:46 1995
***************
*** 436,445 ****
  		    (cons proc compilation-in-progress)))
  	  ;; No asynchronous processes available
  	  (message (format "Executing `%s'..." command))
  	  (sit-for 0) ;; Force redisplay
  	  (let ((status (call-process shell-file-name nil outbuf nil "-c"
! 				      command))))
! 	  (message (format "Executing `%s'...done" command)))))
      ;; Make it so the next C-x ` will use this buffer.
      (setq compilation-last-buffer outbuf)))
  
--- 436,469 ----
  		    (cons proc compilation-in-progress)))
  	  ;; No asynchronous processes available
  	  (message (format "Executing `%s'..." command))
+ 	  ;; Fake modeline display as if `start-process' were run.
+ 	  (setq mode-line-process ":run")
  	  (sit-for 0) ;; Force redisplay
  	  (let ((status (call-process shell-file-name nil outbuf nil "-c"
! 				      command))
! 		finish-msg)
! 	    ;; Fake modeline after exit.
! 	    (setq mode-line-process
! 		  (cond ((numberp status) (format ":exit[%d]" status))
! 			((stringp status) (format ":exit[-1: %s]" status))
! 			(t ":exit[???]")))
! 	    ;; Call `compilation-finish-function' as `compilation-sentinel'
! 	    ;; would, and finish up the compilation buffer with the same
! 	    ;; message we would get from `start-process'.
! 	    (setq finish-msg
! 		  (if (numberp status)
! 		      (if (zerop status)
! 			  "finished\n"
! 			(format "exited abnormally with code %d\n" status))
! 		    "exited abnormally with code -1\n"))
! 	    (goto-char (point-max))
! 	    (insert "\nCompilation " finish-msg)
! 	    (forward-char -1)
! 	    (insert " at " (substring (current-time-string) 0 19)) ; no year
! 	    (forward-char 1)
! 	    (if compilation-finish-function
! 		(funcall compilation-finish-function outbuf finish-msg)))
! 	(message (format "Executing `%s'...done" command)))))
      ;; Make it so the next C-x ` will use this buffer.
      (setq compilation-last-buffer outbuf)))
  
