/**
 ** VESAINFO.C ---- test program to print VESA BIOS information
 **
 ** Copyright (C) 1991 DJ Delorie, 24 Kirsten Ave, Rochester NH 03867-2954
 ** Copyright (C) 1992 Csaba Biegl, 820 Stirrup Dr, Nashville, TN 37221
 ** Copyright (C) 1993 Grzegorz Mazur, gbm@ii.pw.edu.pl
 ** Modified by Jih-Shin Ho to support VESA 2.0
 **
 ** This file is distributed under the terms listed in the document
 ** "copying.dj", available from DJ Delorie at the address above.
 ** A copy of "copying.dj" should accompany this file; if not, a copy
 ** should be available from where this file was obtained.  This file
 ** may not be distributed without a verbatim copy of "copying.dj".
 **
 ** This file is distributed WITHOUT ANY WARRANTY; without even the implied
 ** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 **/

#include <stdlib.h>
#include <stdio.h>
#include <dos.h>

#include "pieces/vesainfo.c"

void printinfo(VgaInfoBlock *vgainfo)
{
	char  far *sp = vgainfo->OEMStringPtr;
	short far *mp = vgainfo->VideoModePtr;

	printf("VESASignature:\t\"%c%c%c%c\"\n",
	    vgainfo->VESASignature[0],
	    vgainfo->VESASignature[1],
	    vgainfo->VESASignature[2],
	    vgainfo->VESASignature[3]
	);
	printf("VESAVersion:\t%d.%d\n",
	    VESA_VERSION_MAJOR(VESAversion),
	    VESA_VERSION_MINOR(VESAversion)
	);
	printf("OEMStringPtr:\t\"");
	while(*sp != '\0') putchar(*sp++);
	printf("\"\nCapabilities:\t%ld\n",vgainfo->Capabilities);
	printf("VideoModePtr:\t%Fp\n",mp);
	printf("Video Modes:\t");
	while(*mp != (-1)) printf("0x%x ",*mp++);
	printf("\n");
	if(VESAversion >= VESA_VERSION(1,2)) {
	    printf("Memory Size:\t%d*64KBytes\n",vgainfo->MemorySize);
	}
	printf("\n");

}

/*
  The preprocessor of TC 2.0 is strange
*/
#define DEFBIT(bit) { bit, #bit }

typedef struct {
    int  bit;
    char *name;
} bitdef;

bitdef modeattrbits[] = {
    DEFBIT(MODE_SUPPORTED),
    DEFBIT(MODE_EXTINFO),
    DEFBIT(MODE_SUPBIOS),
    DEFBIT(MODE_ISCOLOR),
    DEFBIT(MODE_ISGRAPHICS),
    DEFBIT(MODE_NO_WINDOW),
    DEFBIT(MODE_LINEAR_FRAME),    
    { 0 }
};

bitdef winattrbits[] = {
    DEFBIT(WIN_SUPPORTED),
    DEFBIT(WIN_READABLE),
    DEFBIT(WIN_WRITABLE),
    { 0 }
};

bitdef memorymodels[] = {
    DEFBIT(MODEL_TEXT),
    DEFBIT(MODEL_CGA),
    DEFBIT(MODEL_HERC),
    DEFBIT(MODEL_4PLANE),
    DEFBIT(MODEL_PACKED),
    DEFBIT(MODEL_256_NC),
    DEFBIT(MODEL_DIRECT),
    { 0 }
};
                 
void printbits(int value,bitdef *def)
{
	int prev = 0;

	while(def->bit != 0) {
 	    if(value & def->bit) {
		if(prev) printf(" | ");
		printf(def->name);
		prev = 1;
	    }
	    def++;
	}
	if(!prev) printf("0");
	printf("\n");
}

char *getmodelname(int model)
{
	static char temp[50];

	if(model < 0) return(sprintf(temp,"Invalid model [%d]",model),temp);
	if(model <= MODEL_DIRECT) return(memorymodels[model].name);
	if(model <= 15) return(sprintf(temp,"VESA model [0x%02x]",model),temp);
	return(sprintf(temp,"OEM model [%0x2x]",model),temp);
}

void printmodeinfo(int mode,ModeInfoBlock *modeinfo)
{
	printf("Mode 0x%x is supported\n",mode);
	printf("  ModeAttributes:   ");
	printbits(modeinfo->ModeAttributes,modeattrbits);
	printf("  WinAAttributes:   ");
	printbits(modeinfo->WinAAttributes,winattrbits);
	printf("  WinBAttributes:   ");
	printbits(modeinfo->WinBAttributes,winattrbits);
	printf("  WinGranularity:   %d\n",modeinfo->WinGranularity);
	printf("  WinSize:          %d\n",modeinfo->WinSize);
	printf("  WinASegment:      0x%04x\n",modeinfo->WinASegment);
	printf("  WinBSegment:      0x%04x\n",modeinfo->WinBSegment);
	printf("  WinFuncPtr:       \%Fp\n",modeinfo->WinFuncPtr);
	printf("  BytesPerScanLine: %d\n",modeinfo->BytesPerScanLine);
	if(!(modeinfo->ModeAttributes & MODE_EXTINFO)) return;
	printf("  XResolution:      %d\n",modeinfo->XResolution);
	printf("  YResolution:      %d\n",modeinfo->YResolution);
	printf("  XCharSize:        %d\n",modeinfo->XCharSize);
	printf("  YCharSize:        %d\n",modeinfo->YCharSize);
	printf("  NumberOfPlanes:   %d\n",modeinfo->NumberOfPlanes);
 	printf("  BitsPerPixel:     %d\n",modeinfo->BitsPerPixel);
	printf("  NumberOfBanks:    %d\n",modeinfo->NumberOfBanks);
	printf("  MemoryModel:      %d (%s)\n",modeinfo->MemoryModel,getmodelname(modeinfo->MemoryModel));
	printf("  BankSize:         %d\n",modeinfo->BankSize);
	printf("  NumImagePages     %d\n",modeinfo->NumImagePages);
	if(VESAversion < VESA_VERSION(1,2)) return;
	printf("  RedMaskSize:      %d\n",modeinfo->RedMaskSize);
	printf("  RedMaskPos:       %d\n",modeinfo->RedMaskPos);
	printf("  GreenMaskSize:    %d\n",modeinfo->GreenMaskSize);
	printf("  GreenMaskPos:     %d\n",modeinfo->GreenMaskPos);
	printf("  BlueMaskSize:     %d\n",modeinfo->BlueMaskSize);
	printf("  BlueMaskPos:      %d\n",modeinfo->BlueMaskPos);
	printf("  ReservedMaskSize: %d\n",modeinfo->ReservedMaskSize);
	printf("  ReservedMaskPos:  %d\n",modeinfo->ReservedMaskPos);
	printf("  DirectScreenMode: %d\n",modeinfo->DirectScreenMode);
	if(VESAversion < VESA_VERSION(2,0)) return;        
        if (modeinfo->ModeAttributes & MODE_LINEAR_FRAME)
          printf("  PhysBasePtr:      %08lx\n",modeinfo->PhysBasePtr);

}

void main(void)
{
	VgaInfoBlock  *vb;
	ModeInfoBlock *mb;
	if((vb = VESAgetInfo()) != NULL) {
	    static short modes[1000];
	    short far *modeptr = vb->VideoModePtr;
	    short *mdp = modes;
	    int mode;
	    printinfo(vb);
	    while((*mdp++ = *modeptr++) != (-1)) ;
	    mdp = modes;
	    while((mode = *mdp++) != (-1)) {
		if((mb = VESAgetModeInfo(mode)) != NULL) printmodeinfo(mode,mb);
		else printf("Mode 0x%x IS NOT SUPPORTED!\n",mode);
	    }
	}
	else printf("VESA BIOS extensions not found\n");
	exit(0);
}

