/* mime64 */
/* MIME base64 encoder/decoder by Karl Hahn  hahn@lds.loral.com  3-Aug-94 */
/* modified 30-Sep-94 by Karl Hahn hahn@lds.loral.com: handle multiple
   content */
/* modified 12-Jan-95 by Karl Hahn hahn@lds.loral.com: handle file names
   that are encased in quotes */
/* modified 18-Jan-95 by Karl Hahn hahn@lds.loral.com: prevent complete
   failure if filename in name field matches name of input file */
/* modified 19-Jan-95 by Karl Hahn hahn@lds.loral.com: prevent early exit
   if last decoded character falls on a multiple of 3 -- would cause error
   message and failure to rename output file if rename was necessary */
/* modified 19-Jan-95 by Karl Hahn hahn@lds.loral.com: prevent complete
   failure if a line of text preceding the MIME64 stuff contains no
   non-base64 characters */
/* modified 19-Jan-95 by Karl Hahn hahn@lds.loral.com: fixed command
   line parser to prevent missing a name field preceded by another
   name field */
/* modified 19-Jan-95 by Karl Hahn hahn@lds.loral.com: prevent error
   message at the end of decoding each section.  Terminates output
   file now on a blank line as well as the conditions that did so
   previously */
/* modified 01-Dec-95 by Karl Hahn hahn@lds.loral.com: ignore trailing
   blanks.  Add commented code to support folks that do not have strcmpi.
   Also restructured code to make it easier to follow.  Added -r option.
   Added more comments too.  Also allowed for name to be on the line that
   follows the Content-type line.  Changed blank-test to include tabs.
   Improved reporting of errors. */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#if 1    /* changing this to a zero makes everything case sensitive */
#define TOUPPER( c ) (((c) >= 'a') && ((c) <= 'z') ) ? ((c) - ' ') : (c)
#else
#define TOUPPER( c ) (c)
#endif


#if 0   /* if you want case insensitivity in file names
         * and your system does not have strcmpi in its library,
         * uncomment the following by changing the above 0 to 1
         */

int strcmpi( char *str1, char *str2 )  /* does same as strcmp but w/o */
{                                      /* case sensitivity */
   int result;
   unsigned char blivit1, blivit2;

   while (1)
   {
      blivit1 = *str1++;               /* fetch one chr from each string */
      blivit2 = *str2++;

      blivit1 = TOUPPER( blivit1 );    /* convert to upper case */
      blivit2 = TOUPPER( blivit2 );

      if      ( blivit1 > blivit2 )    /* if str1 > str2, then positive */
      {
         return 1;
      }
      else if ( blivit2 > blivit1 )    /* if str2 > str1, then negative */
      {
         return -1;
      }
      else if ( blivit1 == '\0' )      /* if same and terminated here */
      {
         return 0;                     /* then they are equal */
      }
   }
}

#endif

#if 0   /* if you want case sensitivity in your file names
         * uncomment the following by changing the above 0 to 1
         */

#define strcmpi strcmp

#endif

#define ISBLANK(x)  (((x) == ' ') || ((x) == '\t'))

char alphabet[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz"
                  "0123456789+/";

enum TOKENTYPE { NONE, BLANKS, PUNCT, TAG, NAME, CONTENT };

struct TOKEN {
                char *text;
                int  length;
                int  index;
                enum TOKENTYPE type;
             };

int compare_token( struct TOKEN *token, char *text )
{                                      /* for "Content" line analysis */
                                       /* tells if 2 tokes are the same */
   int index=0;
   int count;
   int result;
   char blivit1, blivit2;

   count = token->length;

   if ( count > 0 )
   {
      result = 1;
   }
   else
   {
      result = 0;
   }

   while ( (count > 0) && ( result != 0 ) )
   {
      blivit1 = token->text[index++];

      blivit1 = TOUPPER( blivit1 );

      blivit2 = *text++;

      blivit2 = TOUPPER( blivit2 );

      if ( blivit1 != blivit2 )
      {
         result = 0;
      }

      count--;
   }

   blivit2 = *text++;

   if ( (ISBLANK(blivit2) || ispunct(blivit2) ) )
   {
   }
   else
   {
      result = 0;
   }

   return result;
}

int ispunct( char blivit )             /* for "Content" line analysis */
{                                      /* tells if chr is a punctuation */
   if ( ( blivit >= 'a' ) && (blivit <= 'z' ) )
   {
      blivit -= ' ';
   }

   if ( ( ( blivit < '0' ) ||
          ( ( blivit > '9' ) && (blivit < 'A') ) ||
          ( blivit > 'Z' ) ) &&
        /* note that you may add any further filename symbols you like
         * to the following list
         */
        ( blivit != '-') && (blivit != '/') && (blivit != '.') &&
        ( blivit != '~') && (blivit != '_') && (blivit != '\\') )
   {
      return 1;
   }
   else
   {
      return 0;
   }
}

void fixname( char *name )          /* replaces punct at name end with blank */
{
   while ( *name != '\0' )
   {

     if (ispunct( *name ) )
     {
        *name = '\0';
     }

     name++;
   }
}

void acquire_token( char *line, enum TOKENTYPE type, struct TOKEN *token )
{                                      /* acquires a token from a line */
                                       /* for "Content" line analysis */
                                       /* contains state machine for token */
                                       /* analysis */
   int doneflag=0, startflag=1;
   int index;
   enum TOKENTYPE nextstate=NONE;
   char blivit;

   if (token->type == NONE)
   {
      token->index = 0;
      token->length = 0;
   }

   index = token->index + token->length;

   token->text = 0;

   while ( doneflag == 0 )
   {
      blivit = line[index];
      if ( (blivit >= 'a') && (blivit <= 'z') )
      {
         blivit -= ' ';
      }

      switch (token->type)
      {
         case NONE:
         if ( ISBLANK(blivit) )
         {
            index++;
            token->index++;
         }
         else
         {
            token->type = TAG;
            nextstate = TAG;
         }
         break;

         case BLANKS:
         if      ( ISBLANK(blivit) )
         {
            index++;
         }
         else if ( ispunct( blivit ) )
         {
            token->type = PUNCT;
            token->index = index;
         }
         else
         {
            token->type = nextstate;
            token->index = index;
         }
         break;

         case PUNCT:
         if      ( blivit <  ' ')
         {
            doneflag = 1;
            token->type = NONE;
            token->index = index;
            token->text = line + index;
            token->length = 0;
         }
         else if ( ISBLANK(blivit) )
         {
            token->type = BLANKS;
            token->index = index;
            if      ( line[ token->index ] == ';' )
            {
               nextstate = NAME;
            }
            else if ( line[ token->index ] == '=' )
            {
               nextstate = CONTENT;
            }

         }
         else if ( ispunct( blivit ) )
         {
            index++;
         }
         else
         {
            if      ( line[ token->index ] == ';' )
            {
               nextstate = NAME;
            }
            else if ( line[ token->index ] == '=' )
            {
               nextstate = CONTENT;
            }

            token->type = nextstate;
            token->index = index;
         }
         break;

         case TAG:
         if ( ispunct( blivit ) )
         {
            token->length = index - token->index;
            token->text = line + token->index;
            nextstate = NAME;

            if ( ( ( type == TAG ) || ( type == NONE ) ) && !startflag)
            {
               doneflag = 1;
            }
            else if ( ISBLANK(blivit) )
            {
               token->type = BLANKS;
               token->index = index;
            }
            else
            {
               token->type = PUNCT;
               token->index = index;
            }
         }
         else
         {
            index++;
         }
         break;

         case NAME:
         if ( ispunct( blivit ) )
         {
            token->length = index - token->index;
            token->text = line + token->index;

            if ( blivit != ';' )
            {
               nextstate = CONTENT;
            }
            else
            {
               nextstate = NAME;
            }

            if ( ( ( type == NAME ) || ( type == NONE ) ) && !startflag )
            {
               doneflag = 1;
            }
            else if ( ISBLANK(blivit) )
            {
               token->type = BLANKS;
               token->index = index;
            }
            else
            {
               token->type = PUNCT;
               token->index = index;
            }
         }
         else
         {
            index++;
         }
         break;

         case CONTENT:
         if ( ispunct( blivit ) )
         {
            token->length = index - token->index;
            token->text = line + token->index;
            nextstate = NAME;

            if ( ( ( type == CONTENT ) || ( type == NONE ) ) && !startflag )
            {
               doneflag = 1;
            }
            else if ( ISBLANK(blivit) )
            {
               token->type = BLANKS;
               token->index = index;
            }
            else
            {
               token->type = PUNCT;
               token->index = index;
            }
         }
         else
         {
            index++;
         }
         break;
      }
      startflag = 0;
   }
}

void fputch( char blivit, FILE *f )    /* output chr to file */
{                                      /* you may modify to suit your needs */
/*   if (blivit == '\n') fputc( '\r', f );*/
   fputc( blivit, f );
}

int classify_args( int narg,
                   char *rawargs[], char *fileargs[], char *optargs[] )
{                                      /* classifies command line args as to */
                                       /* file type or option type */
   int index, jndex, kndex;
   char *argptr;

   for ( index = 0, jndex = 0, kndex = 0; index < narg; index++ )
   {
      argptr = rawargs[index];
      if (*argptr == '-')
      {
         argptr++;
         optargs[kndex++] = argptr;
      }
      else
      {
         fileargs[jndex++] = argptr;
      }
   }

   return kndex;
}

int cvt_ascii( unsigned char alpha )   /* cnvrts base64 ascii to integer code */
{
   if      ( (alpha >= 'A') && (alpha <= 'Z') ) return (int)(alpha - 'A');
   else if ( (alpha >= 'a') && (alpha <= 'z') )
        return 26 + (int)(alpha - 'a');
   else if ( (alpha >= '0') && (alpha <= '9' ) )
        return 52 + (int)(alpha - '0');
   else if ( alpha == '+' ) return 62;
   else if ( alpha == '/' ) return 63;
   else if ( alpha == '=' ) return -2;
   else                     return -1;
}


int new_decode_state( char *buf, int decode_state )
{                                      /* decide if line is all base64 */
   int index;

   for ( index = 0;
         (buf[index] != '\n') && (buf[index] != '\0') &&
         (decode_state >= 0);
         index++ )
   {
      if ( ( (buf[index] >= 'A') && (buf[index] <= 'Z') ) ||
           ( (buf[index] >= 'a') && (buf[index] <= 'z') ) ||
           ( (buf[index] >= '0') && (buf[index] <= '9') ) ||
           (buf[index] == '+') ||
           (buf[index] == '/') ||
           (buf[index] == '=') )
      {
         decode_state = 1;             /* if chr is from base64 alphabet, ok */
      }
      else if ( buf[index] != ' ' )
      {
         decode_state = -2;            /* if not and not a blank, not ok */
      }
      else
      {
         while ( ISBLANK(buf[index] ) )
         {                             /* ignore trailing blanks */
            index++;
         }

         if ( (buf[index] == '\n') || (buf[index] == '\0') )
         {
            decode_state = 1;          /* if eol follows blanks, ok */
         }
         else
         {
            decode_state = -2;         /* anything else, not ok */
         }
      }
   }

   return decode_state;
}


/************ actual base64 decode & encode modules start here ***********/

struct BASE64_PARAMS {
                        unsigned long int accum;
                        int               shift;
                        int               save_shift;
                     };

int base64_decode( char *buf, int quit, struct BASE64_PARAMS *d, FILE *fout )
{
   int index;
   unsigned long int value;
   unsigned char blivit;

   index = 0;

   while ( ISBLANK(buf[index] ) )
   {
      index++;                         /* skip leading blanks */
   }

   for ( index = 0; 
         (buf[index] != '\n') && 
         (buf[index] != '\0') &&
         (buf[index] != ' ' );
         index++)
   {
      value = cvt_ascii( buf[index] ); /* find chr in base64 alphabet */

      if ( value < 64 )                /* if legal */
      {
         d->accum <<= 6;               /* assemble binary accum */
         d->shift += 6;
         d->accum |= value;
         if ( d->shift >= 8 )
         {
            d->shift -= 8;
            value = d->accum >> d->shift;
            blivit = (unsigned char)value & 0xFFl;
            fputc( blivit, fout );
         }
      }
      else                             /* else if out of base64 range */
      {
         quit = 1;                     /* then finished */
         break;
      }
   }

   return quit;
}


int base64_encode( int quit, struct BASE64_PARAMS *e_p,
                   FILE *fin, FILE *fout )
{
   int index;
   unsigned long int value;
   unsigned char blivit;
   unsigned char buf[132];

   index = 0;
   while ( ( !feof( fin ) ) || (e_p->shift != 0) )
   {
      if ( ( !feof( fin ) ) && ( quit == 0 ) )
      {
         blivit = fgetc( fin );

         if ( feof( fin ) )
         {
            quit = 1;
            e_p->save_shift = e_p->shift;
            blivit = 0;
         }
      }
      else
      {
         quit = 1;
         e_p->save_shift = e_p->shift;
         blivit = 0;
      }

      if ( (quit == 0) || (e_p->shift != 0) )
      {
         value = (unsigned long)blivit;
         e_p->accum <<= 8;
         e_p->shift += 8;
         e_p->accum |= value;
      } /* ENDIF */

      while ( e_p->shift >= 6 )
      {
         e_p->shift -= 6;
         value = (e_p->accum >> e_p->shift) & 0x3Fl;
         blivit = alphabet[value];

         buf[index++] = blivit;
         if ( index >= 60 )
         {
            buf[index] = '\0';
            fprintf( fout, "%s\n", buf );
            index = 0;
         }

         if ( quit != 0 )
         {
            e_p->shift = 0;
         }
      }
   }

   if      ( e_p->save_shift == 2 )
   {
      buf[index++] = '=';
      if ( index >= 60 )
      {
         buf[index] = '\0';
         fprintf( fout, "%s\n", buf );
         index = 0;
      }

      buf[index++] = '=';
      if ( index >= 60 )
      {
         buf[index] = '\0';
         fprintf( fout, "%s\n", buf );
         index = 0;
      }
   }
   else if ( e_p->save_shift == 4 )
   {
      buf[index++] = '=';
      if ( index >= 60 )
      {
         buf[index] = '\0';
         fprintf( fout, "%s\n", buf );
         index = 0;
      }
   }

   if ( index != 0 )
   {
      buf[index] = '\0';
      fprintf( fout, "%s\n", buf );
   }

   return quit;
}

/************ actual base64 decode & encode modules end here ***********/


/***********************************************************************/
/************                begin main program              ***********/
/***********************************************************************/


char *fileargs[64], *optargs[64];


int main( int nargs, char *cargs[] )
{
   int n_options, n_files, index, jndex;
   enum { ENCODE, DECODE } whattodo = DECODE;
   int help_flag = 0, replace_flag = 0, perm_replace_flag = 0, quit = 0;
   int cycle_flag = 0;
   int replace_option = 0;
   FILE *fin, *fout, *dummy;
   unsigned char blivit;
   char buf[80], dumname[80], another_dumname[80];
   char *cptr, *altptr;
   int decode_state;
   struct TOKEN token;
   int firsttime = 1;
   int skipflag = 0;
   int printmsg = 1;
   struct BASE64_PARAMS d_p, e_p;
   enum { REGULAR, CONTENT_LINE } prev_line_state;

   dumname[0] = '\0';

   /* read command line arguments */
   n_options = classify_args( nargs, cargs, fileargs, optargs );

   n_files = nargs - n_options;

   if ( n_files < 2 ) help_flag = 1;

   for ( index = 0; index < n_options; index++ )
   {
      if ( ( optargs[index][0] == 'e' ) ||
           ( optargs[index][0] == 'E' ) ) whattodo = ENCODE;
      if ( optargs[index][0] == '?' ) help_flag = 1;
      if ( ( optargs[index][0] == 'r' ) ||
           ( optargs[index][0] == 'R' ) ) replace_option = 1;
   }

   if ( help_flag )
   {
      printf( "mime64 infile [outfile] [-option] [-option] etc.\n\n"
              "convert between binary and MIME BASE64 format\n\n"
              "        -e       MIME base64 encode (default is decode)\n"
              "        -?       display help message\n\n"
              "        -r       allow output to replace input\n"
              "                 (-r is default if encoding)\n"
              "if no outfile given and if doing encode or -r present,\n"
              "then output file replaces infile\n" );
   }

   if ( n_files < 2 ) exit(0);

   /* end of command line argument handling */



   /* open input and output files */

   if ( whattodo == DECODE )
   {
      fin = fopen( fileargs[1], "r" );
   }
   else
   {
      fin = fopen( fileargs[1], "rb" );
      replace_option = 1;
   }

   if ( fin == 0 )
   {
      printf( "%s file not found\n", fileargs[1] );
      exit(-1);
   }

   if ( n_files > 2 )
   {
      if ( whattodo == DECODE )
      {
         sprintf( dumname, "%s", fileargs[2] );
      }
      else
      {
         fout = fopen( fileargs[2], "w" );
      }

      if ( fout == 0 )
      {
         printf( "Couldn't open %s for output\n", fileargs[2] );
      }
   }
   else
   {
      if ( whattodo == DECODE )
      {
         sprintf( dumname, "%s", fileargs[1] );
      }
      else
      {
         fout = fopen( "$$$$$$$$.$$$", "w" );
      }

      if ( replace_option )
      {
         replace_flag = 1;
      }
   }

   /* end of file openning */



/* begin processing input file */
do {          /* this loop is for multiple output files when decoding */

   prev_line_state = REGULAR;

   quit = 0;
   printmsg = 1;


   /* begin processing for DECODE */

   if ( whattodo == DECODE )
   {
      d_p.shift = 0;
      d_p.accum = 0;
      decode_state = 0;

      while ( ( !feof( fin ) ) && (quit == 0) )
      {
         fgets( buf, 80, fin );        /* read a line out of the input file */

         if ( feof( fin ) )            /* if end of file, something is wrong */
         {
            if ( ( dumname[0] != '\0' ) && ( d_p.shift != 0 ) )
            {
               printf( "Unexpected end of file encountered in %s\n"
                       "last few bytes may have been lost\n", dumname );
               quit = 1;
               decode_state = 1;
               continue;
            }
            else if ( cycle_flag == 0 )
            {
               quit = 1;
               decode_state = 1;
               continue;
            }
         }
         else /* if not end of file but detect that decode is out of phase */
         {
            cycle_flag = 1;

            if ( (decode_state == 1) &&
                 ( (buf[0] == '\n') || (buf[0] < '+') ) )
            {
               quit = 1;

               if ( d_p.shift != 0 )
               {
                  printf( "Unexpected end of section in %s\n"
                          "last few bytes may have been lost\n", dumname );
               }

               continue;
            }
         }

         /* end of testing for incorrect ending of file */



         /* begin line handling */


         if ( decode_state == 0 )
         {
                                        /* check for base64 line */
            decode_state = new_decode_state( buf, decode_state );



            /* begin "content" line handling */

            if ( decode_state <= 0 )    /* if not a base64 line */
            {

               decode_state = 0;
               token.type = NONE;

               acquire_token( buf, TAG, &token );

               if ( compare_token( &token, "Content-transfer-encoding" ) )
               {
                  prev_line_state = REGULAR;
               }

                                        /* line begin with "Content-Type"? */
               if      ( ( compare_token( &token, "Content-Type") ) ||
                         ( prev_line_state == CONTENT_LINE ) )
               {
                  do                    /* if yes, then search for file name */
                  {
                     if ( prev_line_state == REGULAR )
                     {
                        acquire_token( buf, NAME, &token );
                     }

                     if ( compare_token( &token, "name" ) )
                     {
                        prev_line_state = REGULAR;

                        acquire_token( buf, CONTENT, &token );

                        if ( ( replace_flag ) || ( replace_option == 0 ) ||
                             ( firsttime == 0 ) )
                        {
                           sscanf( token.text, "%s", dumname );
                           fixname( dumname );

                           if ( strcmpi( dumname, fileargs[1] ) != 0 )
                           {
                              replace_flag = 0;
                           }
                           else
                           {
                              if ( perm_replace_flag )
                              {
                                 printf(
                                 "More than one output file named %s\n",
                                 dumname );

                                 exit(-1);
                              }
                           }
                        }
                     }

                     if ( prev_line_state == CONTENT_LINE )
                     {
                        acquire_token( buf, NAME, &token );
                     }
                  } while ( token.type != NONE );

                  prev_line_state = CONTENT_LINE;
               }
               else if ( compare_token( &token, "Content-transfer-encoding" ) )
               {                       /* looking for encoding type now */
                  prev_line_state = REGULAR;
                  skipflag = 1;

                  do                   /* want to find "base64" */
                  {
                     acquire_token( buf, NAME, &token );
                     if ( compare_token( &token, "base64" ) )
                     {
                        skipflag = 0;
                     }
                  } while ( token.type != NONE );
               }
               continue;
            }
            else if ( skipflag != 0 )
            {
               continue;
            }
         }

         /* end of "Content" line handling */


         /* now, alert user as to what's going on here */

         if ( printmsg )
         {
            if ( skipflag )
            {
               printf( "Section %s not MIME base64\n", dumname );
            }
            else
            {
               if ( dumname[0] != '\0' )
               {
                  printf( "Creating %s\n", dumname );
               }

               if ( strcmpi( dumname, fileargs[1] ) == 0 )
               {
                  if ( replace_option )
                  {
                     replace_flag = 1;
                  }
                  else
                  {
                     printf( "No output file given or output same as input.\n"
                             "Use -r option on decode if you want to allow\n"
                             "output file to replace input file.\n" );
                     skipflag = 1;
                  }
               }

               if ( skipflag )
               {
                  continue;
               }

               if ( replace_flag )
               {
                  fout = fopen( "$$$$$$$$.$$$", "wb" );
               }
               else
               {
                  fout = fopen( dumname, "wb" );
               }

               if ( fout == 0 )
               {
                  printf( "Couldn't open %s for output\n", dumname );
               }
            }

            printmsg = 0;
         }

         /* end of reporting to user */


         /* checking now to see if it's time to bail */

         if ( fout == 0 )
         {
            printf( "No filename given for subsequent section\n" );
            exit(-1);
         }

         if ( feof(fin) )
         {
            quit = 1;
         }

         if ( quit != 0 )
         {
            buf[0] = '\0';
         }

         /* end of checking for time to bail */

         prev_line_state = REGULAR;
         printmsg = 0;

         /* this is a call to the actual base64 decoding */

         quit = base64_decode( buf, quit, &d_p, fout );
      }
   }
   /* end of decode section */

   /* begin encode section */
   else
   {
      fprintf ( fout,
       "Content-Type: text/plain; charset=US-ASCII; name=%s\n"
       "Content-transfer-encoding: base64\n\n", fileargs[1] );

      e_p.shift = 0;
      e_p.accum = 0;

      quit = base64_encode( quit, &e_p, fin, fout );
   }

   fclose( fout );

   if ( dumname[0] != '\0' )
   {
      sprintf( another_dumname, "%s", dumname );
   }
   else if ( n_files < 3 )
   {
      sprintf( another_dumname, "%s", fileargs[1] );
   }
   else
   {
      sprintf( another_dumname, "%s", fileargs[2] );
   }

   if ( replace_flag )
   {
      perm_replace_flag = 1;

      if ( ( whattodo == DECODE ) && ( decode_state <= 0 ) )
      {
         remove( "$$$$$$$$.$$$" );

         printf( "No MIME base64 lines found in %s\n", another_dumname );
      }
   }
   else
   {
      if ( ( whattodo == DECODE ) && ( decode_state <= 0 ) )
      {
         remove( fileargs[2] );

         if ( dumname[0] != '\0' )
         {
            printf( "No MIME base64 lines found in %s\n", another_dumname );
         }
      }
   }

   fout = 0;
   firsttime = 0;
   dumname[0] = '\0';
   cycle_flag = 0;

} while ( !feof( fin ) );  /* end loop for multiple output files in decode */


if ( perm_replace_flag )
{
   remove( fileargs[1] );
   rename( "$$$$$$$$.$$$", fileargs[1] );
}

fclose( fin );
}
