program Flash;

{$N-,E-,Q+,S+,R-,I-,O-,F+,P+,T-,X-,V-,B+,A+,G+,D-,L-,Y-}
{$M 1024,0,3761}
{$L Bgi256}

(* Compiled in Borland Turbo Pascal 7.0 for DOS. Bgi256.Obj is a non-Borland
   aftermarket add-on file. It is "registered", meaning the Bgi256.Obj file
   itself isn't needed to run Squirmy Dots. *)

uses crt,drivers,graph;

var
Gd, Gm, Error, TimeValue, Red, Green, Blue : integer;
Adjuster : char;

label Top, Start;

(* Gm := 0 is 320x200x256, 1 is 640x400x256, 2 is 640x480x256,
         3 is 800x600x256, 4 is 1024x768x256, 5 is 1280x1024x256 *)

procedure Bgi256proc; external;

procedure InitBGI256;
begin
Gd := installuserdriver('Bgi256',nil);
Error := registerbgidriver(@Bgi256proc);
Gm := 0;  (* Run in 320x200x256 mode *)
initgraph(Gd,Gm,'');
Error := graphresult;
if Error <> 0 then
begin
closegraph;
writeln('                                                         ');
writeln(' Sorry, your display and/or video card is incompatible   ');
writeln(' with this strobe light program. Oh, well; No harm done. ');
writeln('                                                         ');
halt(1);
end;
end;

procedure Click;
begin
sound(1000);
delay(20);
nosound;
end;

procedure Exit_Program;
begin
closegraph;
textcolor(7);
textbackground(0);
clrscr;
gotoxy(1,12);
textcolor(1);
write(' If you like "Flash", please send a small amount (address in the .Doc).....');
textcolor(129);
writeln('.');
gotoxy(1,24);
donesyserror;
halt;
end;

begin
initsyserror;   (* Turns off ctrl-break, in drivers unit. *)

Red:=0;
repeat
textcolor(Red);
textbackground(Red);
clrscr;
Red := Red + 1;
delay(200);
until Red = 8;

textcolor(7);
textbackground(0);
Top:
clrscr;
gotoxy(1,3);
write(' "Flash');
textcolor(135);
write('!');
textcolor(7);
writeln('" 6.0 Copyright (C) 1996.');
writeln(' Multi-color, multi-speed strobe light;');
writeln;
writeln(' What speed strobe light? 4 times per second thru 20 initially. While it''s');
writeln(' flashing you make it Fast or Slow it down by hitting the F key or the S key.');
writeln(' (Fast or Slow, f or s.) Please read the Flash.Doc file for help or details.');
writeln(' (However, it''s easy to use and it keeps you inside this range.) To change');
writeln(' colors, you have the R, G, and B keys (for Red, Green, and Blue). A capital');
writeln(' R, G, or B increases the given color, while a lowercase r, g, or b decreases');
writeln(' the given color. Also, a capital I (for intensity) increases the brightness');
writeln(' of a given screen color, while a lowercase i will decrease the insensity, or');
writeln(' brightness of the present screen color. Finally, if you hit the N key, whether');
writeln(' upper or lower case, the color returns to medium gray and the speed returns to');
writeln(' 9 flashes per second. These 3 keys, F (faster), S (slower), and N (for New),');
writeln(' are case-insensitive. R, G, B, and I are where case matters. Any key other');
writeln(' than these will exit Flash and return to DOS (or Windows). Using 6 bits each');
writeln(' for red, green, and blue, I created, in effect, an 18-bit palette. This makes');
writeln(' you able to display up to 262,144 colors with Flash, one at a time (if you had');
writeln(' the time, that is). Enjoy!');
writeln;
write(' Enter a whole number from 4 thru 20  >  ');
reset(input);
if not eoln(input) then
readln(TimeValue)
else goto Top;

if ioresult = 106 then goto Top;

if (TimeValue < 4) or (TimeValue > 20) then goto Top;

case TimeValue of (* Here TimeValue gets RE-assigned; (Conserve on variables.) *)
 4 : TimeValue := 125; (* (1000/4)/2, 125 exactly. *)
 5 : TimeValue := 100;
 6 : TimeValue :=  83; (* (1000/6)/2, rounded to 83, etc. *)
 7 : TimeValue :=  71;
 8 : TimeValue :=  63;
 9 : TimeValue :=  56;
10 : TimeValue :=  50;
11 : TimeValue :=  45;
12 : TimeValue :=  42;
13 : TimeValue :=  38;
14 : TimeValue :=  36;
15 : TimeValue :=  33;
16 : TimeValue :=  31;
17 : TimeValue :=  29;
18 : TimeValue :=  28;
19 : TimeValue :=  26;
20 : TimeValue :=  25;
end;

InitBgi256;

Red := 31;
Green := 31;
Blue := 31;

Start:
repeat
setrgbpalette(0, Red, Green, Blue);
delay(TimeValue);
setrgbpalette(0,0,0,0);
delay(TimeValue);
until keypressed;

Adjuster := readkey;

if (Adjuster = 'N') or (Adjuster = 'n') then
begin
Red := 31;
Green := 31;
Blue := 31;
TimeValue := 56;
goto Start;
end;

case Adjuster of
'r' : Red := Red - 1;
'R' : Red := Red + 1;
'g' : Green := Green - 1;
'G' : Green := Green + 1;
'b' : Blue := Blue - 1;
'B' : Blue := Blue + 1;
'i' : begin Red:=Red-1; Green:=Green-1; Blue:=Blue-1; end;
'I' : begin Red:=Red+1; Green:=Green+1; Blue:=Blue+1; end;
'f', 'F' : TimeValue := TimeValue - 1;
's', 'S' : TimeValue := TimeValue + 1;
else Exit_Program;
end;

if (Red < 0) or (Red > 63) then Click;
if Red < 0 then Red := 0;
if Red > 63 then Red := 63;
if (Green < 0) or (Green > 63) then Click;
if Green < 0 then Green := 0;
if Green > 63 then Green := 63;
if (Blue < 0) or (Blue > 63) then Click;
if Blue < 0 then Blue := 0;
if Blue > 63 then Blue := 63;
if TimeValue < 25 then begin Click; TimeValue := 25; end;
if TimeValue > 125 then begin Click; TimeValue := 125; end;

goto Start;

end.