seg_a           segment byte public
assume  cs:seg_a

                jumps
                org     100h
ProgrammStart:
                DB 'WAVCAP Plugin',1Ah
                DW offset MY_identification

                DW offset Check_for_correct_format
                DW offset Find_first
                DW offset Find_next
                DW offset Get_info
                DW offset Get_RAW
                include wcplg.inc

Check_for_correct_format:
                lds dx,CurFile
                mov di,offset IWAD
                mov cx,4
                xor ax,ax
                call Check_header
                retf

IWAD            DB 'IWAD'
xptr            DD ?
FilesLeft       DD ?
dummy           DW ?
dummy2          DW ?

Find_first:
                lds dx,CurFile
                call Fopen
                jc IO_Error

                push cs
                pop ds
                mov dx,offset xptr
                mov cx,8             ;Read IWAD to xptr , and files to FilesLeft
                call Fread
                jc IO_Error

                mov dx,offset xptr
                mov cx,4
                call Fread
                jc IO_Error

                mov cx,word ptr cs:[xptr+2]
                mov dx,word ptr cs:[xptr]
                mov al,SEEK_SET
                call Fseek
                jc IO_Error
Find_next:
                cmp word ptr cs:[FilesLeft],0
                jne ThereAreFiles
                cmp word ptr cs:[FilesLeft+2],0
                jne ThereAreFiles

                call Fclose
                mov ax,NoMoreFiles
                retf

ThereAreFiles:
                lds si,Buffer
                mov dx,si
                add dx,ToPosition
                Read 4

                mov dx,si
                add dx,ToFileSize
                Read 4

                mov dx,si
                Read 8
                mov byte ptr ds:[si+8],0
                mov byte ptr ds:[si+ToAttr],Attr_RR

                les di,Buffer
                add di,ToPosition
                push cs
                pop ds
                mov si,offset dummy
                mov cx,4
                call FGetbytes
                jc IO_Error

                cmp word ptr cs:[dummy],3
                jne BlaBlaBla

                cmp word ptr cs:[dummy2],11025
                jne BlaBlaBla
                lds si,Buffer
                mov word ptr ds:[si+ToFileType],TYPE_sounds
                mov byte ptr ds:[si+ToAttr],Attr_Read

BlaBlaBla:
                sub word ptr cs:[FilesLeft],1
                sbb word ptr cs:[FilesLeft+2],0
                xor ax,ax
                retf

;****************************************************************
;*                  GET INFO                                    *
;****************************************************************
Get_info:
                les di,CurFile
                cmp word ptr es:[di+ToFileType],TYPE_sounds
                jne CantRetrive

                lds dx,FromFile
                call Fopen
                jc IO_Error

                mov cx,word ptr es:[di+ToPosition+2]
                mov dx,word ptr es:[di+ToPosition]
                mov al,SEEK_SET
                call Fseek
                jc IO_Error

                push cs
                pop ds
                mov dx,offset RAW_info
                mov si,dx
                mov cx,8
                call Fread
                jc IO_Error

                les di,SoundInfo
                mov ax,word ptr ds:[si+2]
                mov word ptr es:[di+ToFreq],ax
                mov ax,word ptr ds:[si+4]
                mov word ptr es:[di+ToRAWLength],ax
                xor ax,ax
                retf

CantRetrive:
                mov ax,CantRetriveInfo
                retf

RAW_info        DB 8 dup (0)
Get_RAW:
                mov cx,cs:[ReadLength]
                cmp cx,0
                je CloseAndByeBye

                lds dx,Buffer
                call Fread
                jc IO_Error

                cmp ax,cx
                jne IO_Error
                xor ax,ax
                retf
CloseAndByeBye:
                call Fclose
                jc IO_Error
                xor ax,ax
                retf
MY_identification:
                DB '*.WAD',0
                DW PLGID_sounds or PLGID_unknown
                DB 'Game: Doom - compatible',0

                seg_a ends
                end     ProgrammStart
