ideal
p386
model small

segment code32 public 'code' use32
assume cs:code32,ds:code32,fs:code32,gs:code32,ss:code32
include "dos32.inc"

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Structures                               ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

struc tinit_settings
  config_marker        db "unislite config file - don't edit me - 2",26
  card_type            db 0    ;? ; 0 = SB; 1 = SBPRO; 2 = GUS ; 3 = AWE32
  PORT_no              dw 220h ;?
  IRQ_no               db 07h  ;?
  DMA_no               db 01h  ;?
ends

struc tDMA_info
  dma_base             dw ?
  page                 db ?
  offs                 dw ?
  dma_page_Reg         dw ?
ends

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Data                                     ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

sample_name            db "snd\charms.snd",0
file_handle_779        dw ?
file_buffer            = 500000

init_settings          tinit_settings <>

DAC_mix_buffer_size    dw ?
DAC_mix_buffer_size_AD dw ?
DAC_sampling_rate      dw ?
DMA_info               tDMA_info <>
DMA_page_table         db 87h,83h,81h,82h

SB_BASE                dw 0
SB_RESET               dw 6h
SB_READ_DATA           dw 0ah
SB_WRITE_DATA          dw 0ch
SB_DATA_AVAIL          dw 0eh

SB_set_size            dd ?

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                     ;
; DAC Code                                                            ;
;                                                                     ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                     ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc SB_detect
  mov    ax,[word init_settings.PORT_no]
  add    [word SB_BASE],ax
  add    [word SB_RESET],ax
  add    [word SB_READ_DATA],ax
  add    [word SB_WRITE_DATA],ax
  add    [word SB_DATA_AVAIL],ax
  mov    al,1
  mov    dx,[word SB_RESET]
  out    dx,al
  in     al,dx
  in     al,dx
  in     al,dx
  in     al,dx
  xor    al,al
  mov    dx,[word SB_RESET]
  out    dx,al
  mov    cl,64h
@@DataWait:
  mov    dx,[word SB_BASE]
  mov    dx,[word SB_DATA_AVAIL]
  in     al,dx
  test   al,80h
  jnz    @@YesData
  dec    cl
  jnz    @@DataWait
  jmp    @@exit
@@YesData:
  mov    dx,[word SB_READ_DATA]
  in     al,dx
  cmp    al,0AAh
  je     @@YepSB
  dec    cl
  jnz    @@DataWait
  jmp    @@exit
@@YepSB:
  clc
  ret
@@exit:
  stc
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                      ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc SB_write_dac
  push   eax
  mov    dx,[word SB_WRITE_DATA]
@@Wait_Ready:
  in     al,dx
  and    al,80h
  jnz    @@Wait_Ready
  pop    eax
  out    dx,al
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;  al = addr  ah = data      SBPRO mixxer                              ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc SB_write_mixer
  mov    dx,[word SB_BASE]
  add    dx,4
  push   edx
  out    dx,al
  pop    edx
  inc    dx
  mov    al,ah
  out    dx,al
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                      ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc DAC_resolve_dma_addr
  mov    eax,offset file_buffer
  add    eax,[dword CODE32_addr]
  mov    [word dma_info.offs],ax
  shr    eax,16
  mov    [byte dma_info.page],al
  movzx  ebx,[byte init_settings.DMA_no]
  mov    al,[byte ebx+DMA_page_table]
  xor    ah,ah
  mov    [word dma_info.dma_page_reg],ax
  movzx  ebx,[byte init_settings.DMA_no]
  shl    bl,1
  mov    [word dma_info.dma_base],bx
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                      ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc SB_set_size_slow
  mov    al,14h                                   ; DMA_8_BIT_DAC
  call   SB_write_dac
  mov    ax,[word DAC_mix_buffer_size_AD]
  call   SB_write_dac
  mov    al,ah
  call   SB_write_dac
  ret
endp

proc SB_set_size_fast
  mov    al,48h                                   ; DMA_8_BIT_DAC (FAST)
  call   SB_write_dac
  mov    ax,[word DAC_mix_buffer_size_AD]
  call   SB_write_dac
  mov    al,ah
  call   SB_write_dac
  mov    al,91h
  call   SB_write_dac
  ret
endp

proc SB_send_block_to_DMA
  mov    al,4
  add    al,[byte init_settings.DMA_no]
  out    0Ah,al                                   ; mask reg bit
  xor    al,al
  out    0Ch,al                                   ; clr byte ptr
  mov    al,48h                                   ; set DMA to "send data"
  add    al,[byte init_settings.DMA_no]
  out    0Bh,al                                   ;set mode reg
  mov    dx,[word dma_info.dma_base]
  mov    ax,[word dma_info.offs]
  out    dx,al                                    ; set base address low
  mov    al,ah
  out    dx,al                                    ; set base address high
  inc    dx                                       ; point to length
  mov    ax,[word DAC_mix_buffer_size_AD]
  out    dx,al                                    ; set length low
  mov    al,ah
  out    dx,al                                    ; set length high
  mov    al,[byte DMA_info.page]
  mov    dx,[word DMA_info.dma_page_reg]
  out    dx,al                                    ; set DMA page reg
  mov    al,[byte init_settings.DMA_no]
  out    0Ah,al                                   ; unmask (activate) dma channel
  call   [dword SB_set_size]
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc SB_init
  call   DAC_resolve_dma_addr
;  call   DAC_clear_sam_buffer
;  mov    bl,[byte init_settings.IRQ_no]
;  call   getirqvector
;  mov    [dword DAC_old_irq_ofs],edx
;  mov    [word DAC_old_irq_sel],cx
  cmp    [byte init_settings.card_type],1
  je     @@set_for_SBPRO
;  mov    [byte DAC_shift_value],1
  mov    [word DAC_sampling_rate],22000
  mov    [word DAC_mix_buffer_size],32000      ; 220
  mov    [word DAC_mix_buffer_size_AD],32000-1 ; 220-1
  lea    eax,[SB_set_size_slow]
  mov    [dword SB_set_size],eax
;  mov    bl,[byte init_settings.IRQ_no]
;  lea    edx,[SB_virtualmixxer]
;  mov    cx,cs
;  call   setirqvector
  xor    edx,edx                                       ;set sampling rate
  mov    eax,0F4240h
  movzx  ecx,[word DAC_sampling_rate]
  div    ecx
  neg    al
  push   eax
  jmp    @@done_set
@@set_for_SBPRO:
;  mov    [byte DAC_shift_value],2
  mov    ax,130eh                                      ;set for stereo
  call   SB_write_mixer
  mov    ax,0ff22h                                     ;set master volume
  call   SB_write_mixer
  mov    ax,0ff04h                                     ;set VOL volume
  call   SB_write_mixer
  mov    ax,0ff2eh                                     ;set line volume
  call   SB_write_mixer
  mov    [word DAC_sampling_rate],44000
  mov    [word DAC_mix_buffer_size],220
  mov    [word DAC_mix_buffer_size_AD],440-1
  lea    eax,[SB_set_size_fast]
  mov    [dword SB_set_size],eax
;  mov    bl,[byte init_settings.IRQ_no]
;  lea    edx,[SBPRO_virtualmixxer]
;  mov    cx,cs
;  call   setirqvector
  xor    edx,edx                                       ;set sampling rate (hi speed)
  mov    eax,0f424000h
  movzx  ecx,[word DAC_sampling_rate]
  div    ecx
  mov    bx,0ffffh
  sub    bx,ax
  mov    bl,bh
  push   ebx
  mov    [word DAC_sampling_rate],22000
@@done_set:
  mov    al,40h                                        ;TIME_CONSTANT
  call   SB_write_dac
  pop    eax
  call   SB_write_dac
  mov    al,0D1h                                       ;SPEAKER_ON
  call   SB_write_dac
  cli
  in     al,21h
  mov    bl,1
  mov    cl,[byte init_settings.IRQ_no]
  shl    bl,cl
  not    bl
  and    al,bl
  out    21h,al
  call   SB_send_block_to_DMA
  sti
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc SB_deinit
  cli
  cmp    [byte init_settings.card_type],1
  jne    @@dont_reset
  mov    ax,110eh                                      ;set for mono
  call   SB_write_mixer
  call   SB_detect
@@dont_reset:
  mov    al,0D0h                                       ;HALT_DMA
  call   SB_write_dac
  mov    bl,1
  mov    cl,[byte init_settings.IRQ_no]
  shl    bl,cl
  in     al,21h
  or     al,bl
  out    21h,al
;  mov    bl,[byte init_settings.IRQ_no]
;  mov    edx,[dword DAC_old_irq_ofs]
;  mov    cx,[word DAC_old_irq_sel]
;  call   setirqvector
  sti
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
start32:
  call   debug
  cld
  call   SB_detect
  or     al,al
  jc     @@card_not_found

  mov    ax,3d00h
  lea    edx,[sample_name]                          ; open
  int    21h
  jc     @@card_not_found
  mov    [word file_handle_779],ax
  mov    bx,ax

  mov    ah,3fh
  mov    edx,offset file_buffer
  mov    ecx,32000
  int    21h

  mov    bx,[word file_handle_779]
  mov    ah,3eh                                   ; close
  int    21h

  call   SB_init

  mov    ax,10h
  dosint 16h

  call   SB_deinit
@@card_not_found:
  mov    ax,4c00h
  int    21h

ends

end
