program MsgEdit;
{$G+,A+,S-}

uses
 Dos;

var
 F, G: text;
 FN: PathStr;
 S, T: string;
 D: DirStr;
 N: NameStr;
 E: ExtStr;
 TC: string [2];
 TOr: byte;
 CP: string [6];
 I: byte;
 Found: boolean;

const
 SC: string [2] = 'EN';
 SO: byte = 0;
 All: boolean = false;
 XCodes: array [#128..#255] of string [2] =
  ('', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
   '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
   '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
   '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
   '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
   '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '',
   '', '', '', '', '', '', '', '', '', '', '', '', '', '');

function UpStr (S: string): string; assembler;
asm
 push ds
 cld
 lds si, S
 les di, @Result
 lodsb
 stosb
 xor ah, ah
 xchg ax, cx
 jcxz @3
@1:
 lodsb
 cmp al, 'a'
 jb @2
 cmp al, 'z'
 ja @2
 sub al, 20h
@2:
 stosb
 loop @1
@3:
 pop ds
end;

procedure Help;
begin
 FSplit (ParamStr (0), D, N, E);
 WriteLn (#13#10'MsgEdit - language editing module for X1');
 WriteLn ('Copyright (C) 1996 Tomas Hajny, XHajT03@mbox.vol.cz on Internet');
 WriteLn ('GNU General Public License version 2 or higher should be applied to this program');
 WriteLn ('Syntax: ', UpStr (N), ' <filename> aa [bb [xxx [/A]]');
 WriteLn (' aa - code for target language (2 letters)');
 WriteLn (' bb - code of source language (2 letters; default is ''EN'' for English)');
 WriteLn (' xxx - codepage number (3 - 6 digits); file CPxxx.DEF with predefined');
 WriteLn ('       structure located in current directory will be used for translation');
 WriteLn ('       of characters from upper half of the ASCII table to pseudocodes');
 WriteLn (' /A - everything written to the file will appear on the screen as well');
 WriteLn ('Options are case insensitive');
 Halt;
end;

type
 PLongint = ^longint;

procedure Finish;
begin
 while not (Eof (F)) and (IOResult = 0) do
 begin
  ReadLn (F, S);
  WriteLn (G, S);
  if All then WriteLn (S);
 end;
end;

function Trim (S: string): string;
var
 I: byte;
begin
 while (S [0] > #0) and (S [byte (S [0])] <= ' ') do Dec (S [0]);
 I := 1;
 while (I <= byte (S [0])) and (S [I] <= ' ') do Inc (I);
 Trim := Copy (S, I, byte (S [0]) - Pred (I));
end;

function Inside (var S: string): string;
var
 I, J: byte;
begin
 I := Pos ('"', S);
 J := Pos ('"', Copy (S, Succ (I), byte (S [0]) - I));
 Inside := Copy (S, Succ (I), Pred (J));
end;

function Skip: boolean;
begin
 Skip := true;
 while not (Eof (F)) and (Copy (S, 1, 10) <> 'char *MSG_')
                                     and (UpStr (Copy (S, 1, 5)) <> '#ELSE') do
 begin
  ReadLn (F, S);
  WriteLn (G, S);
  if All then WriteLn (S);
 end;
 if Copy (S, 11, 4) = 'HELP' then
 begin
  Finish;
  Skip := false;
 end;
end;

procedure Next;
var
 I: byte;
begin
 Found := false;
 if not (Eof (F)) then
 begin
  for I := 1 to SO do
  begin
   ReadLn (F, S);
   while (UpStr (Copy (S, 1, 6)) = '#IFDEF') or
               (Pos (Copy (Trim (S), 1, 1), '"{') = 0) or (Pos ('"', S) = 0) do
   begin
    WriteLn (G, S);
    if All then WriteLn (S);
    ReadLn (F, S);
   end;
   WriteLn (G, S);
   if All then WriteLn (S);
  end;
  T := Inside (S);
  for I := SO to TOr do
  begin
   ReadLn (F, S);
   while (UpStr (Copy (S, 1, 6)) = '#IFDEF') or
          ((Pos (Copy (Trim (S), 1, 1), '"{') = 0) or (Pos ('"', S) = 0)) and
                                        (UpStr (Copy (S, 1, 6)) <> '#ENDIF') do
   begin
    WriteLn (G, S);
    if All then WriteLn (S);
    ReadLn (F, S);
   end;
   if I = Pred (TOr) then if UpStr (Copy (S, 1, 6)) <> '#ENDIF' then
                                              Found := true else Inc (I) else ;
   if (I < TOr) or Found then
   begin
    WriteLn (G, S);
    if All then WriteLn (S);
   end;
  end;
 end;
end;

begin
 if ParamCount < 1 then
 begin
  WriteLn (#13#10'Filename missing!!');
  Help;
 end;
 PLongint (@S [0])^ := 0;
 FN := ParamStr (1);
 if (Pos (FN [1], '/-') > 0) and (Pos (FN [2], 'hH?') > 0) then Help;
 FSplit (FN, D, N, E);
 if (UpStr (E) = '.BAK') or (UpStr (E) = '.$$$') then
 begin
  WriteLn ('Sorry - the input file must have extension other than ''.$$$'' or ''.BAK''.');
  Halt;
 end;
 S := ParamStr (2);
 if S [0] <> #2 then
 begin
  WriteLn (#13#10'Incorrect or missing target language code (two letters expected!!');
  Help;
 end;
 TC := UpStr (S);
 if ParamCount > 2 then
 begin
  S := ParamStr (3);
  if S [0] <> #2 then
  begin
   WriteLn (#13#10'Incorrect source language code (two letters expected)!!');
   Help;
  end;
  SC := UpStr (S);
  if ParamCount > 3 then
  begin
   if ParamCount > 4 then All := true;
   S := ParamStr (4);
   if (S [0] < #3) or (S [0] > #6) then
   begin
    WriteLn (#13#10'Incorrect codepage number (3 - 6 digits expected)!!');
    Help;
   end;
   CP := S;
{$I-}
   Assign (F, 'CP' + CP + '.DEF');
   Reset (F);
   if IOResult <> 0 then
   begin
    WriteLn (#13#10'Cannot read from codepage definition file');
    Help;
   end;
   while not (Eof (F)) and (IOResult = 0) do
   begin
    ReadLn (F, S);
    if (S [0] > #0) and (S [1] <> '#') and (S [1] <> ';') then
    begin
     if (S [2] <> '=') or (S [1] < #128) or (S [0] > #4) then
     begin
      WriteLn (#13#10'Incorrect structure of codepage definition file!!');
      WriteLn ('Lines have to be in form ''x=yy'', where ''x'' is a character from upper half');
      WriteLn ('of ASCII (i.e. >= #128) and ''yy'' is a pseudocode definition (max. 2 chars).');
      Halt;
     end;
     if XCodes [S [1]][0] > #0 then WriteLn (#13#10'Warning - ', S [1],
            ' already defined - ''', Copy (S, 3, 2), ''' ignored.') else
                                              XCodes [S [1]] := Copy (S, 3, 2);
    end;
   end;
   Close (F);
  end;
 end;
 Assign (F, FN);
 Reset (F);
 if IOResult <> 0 then
 begin
  WriteLn (#13#10'Cannot open input file!!');
  Help;
 end;
 Assign (G, D + N + '.$$$');
 Rewrite (G);
 if IOResult <> 0 then
 begin
  WriteLn (#13#10'Cannot create temporary file!!');
  Help;
 end;
 S [0] := #0;
 if Skip then
 begin
  TOr := 1;
  T [0] := #0;
  if not (Eof (F)) then ReadLn (F, S);
  while not (Eof (F)) and
                       (Pos ('/*' + TC + ':', UpStr (S)) = 0) and
                                        (UpStr (Copy (S, 1, 6)) <> '#ENDIF') do
  begin
   if (UpStr (Copy (S, 1, 6)) <> '#IFDEF') and
                                   (Pos ('/*' + SC + ':', UpStr (S)) <> 0) then
   begin
    T := Inside (S);
    SO := TOr;
   end;
   WriteLn (G, S);
   if All then WriteLn (S);
   ReadLn (F, S);
   if (UpStr (Copy (S, 1, 6)) = '#ENDIF') or (Pos ('"', S) <> 0) and
                       (Pos (Copy (Trim (S), 1, 1), '{"') <> 0) then Inc (TOr);
  end;
  if UpStr (Copy (S, 1, 6)) <> '#ENDIF' then
  begin
   Found := not (Eof (F));
   WriteLn (G, S);
   if All then WriteLn (S);
  end else Found := false;
  if T [0] = #0 then
  begin
   WriteLn (#13#10'Source language text not found!!');
   Halt;
  end;
  while Found and Skip do Next;
  while not (Eof (F)) do
  begin
   if All then WriteLn;
   WriteLn (T, ' = (leave empty to exit)');
   ReadLn (T);
   T := Trim (T);
   if T [0] = #0 then
   begin
    WriteLn (G, S);
    if All then WriteLn (S);
    Finish;
   end else
   begin
    WriteLn;
    Write (G, '  "');
    for I := 1 to byte (T [0]) do
           if (T [I] < #128) or (XCodes [T [I]] [0] = #0) then
                    Write (G, T [I]) else Write (G, '$(', XCodes [T [I]], ')');
    WriteLn (G, '",   /*', TC, ':*/'#13#10, S);
    if All then
    begin
     Write ('  "');
     for I := 1 to byte (T [0]) do
               if (T [I] < #128) or (XCodes [T [I]] [0] = #0) then
                          Write (T [I]) else Write ('$(', XCodes [T [I]], ')');
     WriteLn ('",   /*', TC, ':*/'#13#10, S);
    end;
   end;
   Found := true;
   while Found and Skip do Next;
  end;
 end;
 Write (G, #26);
 Close (G);
 Assign (G, D + N + '.BAK');
{$I-}
 Erase (G);
 if IOResult = 0 then ;
{I+}
 Close (F);
 Rename (F, N + '.BAK');
 Assign (F, D + N + '.$$$');
 Rename (F, N + E);
 if T [0] <> #0 then WriteLn ('Done.');
end.
