/*
SYSTEM SNIFFER - HARDWARE.CPP
Copyright (C) Tero Ripattila 1996-1998
*/

#include "machine.cpp"
#include "lmouse.cpp"

SnifferHWare::SnifferHWare(void)
{
}

SnifferHWare::~SnifferHWare(void)
{
}

void SnifferHWare::GetHardwareInfo(void)
{
	row = 3;

	SGui->PutCaptionAndMsg(HARDWARE);

	textbackground(BG_BG);

	SMachine->GetMachineInfo();
/*
	SHWare->GetProcessorInfo();
*/
	SHWare->GetMouseInfo();
	SHWare->GetSysFlags();
}

/* --- REM ---
void SnifferHWare::GetProcessorInfo(void)
{
	extern byte cpu_type,fpu_type,id_flag;
	static const byte *CPUMessage[5] = { "8086","i286","i386","i486","Pentium" };
	static const byte *FPUMessage[4] = { "Not present","Present","80287","80387" };

	cpu_type = fpu_type = id_flag = 0;

	enum CPU_TYPE {
	  id_msg = 0,  fp_8087,  fp_80287,    fp_80387,  c8086,
	  c286,        c386,     c486,        c486nfp,   Intel486_msg,
	  Pentium_msg, modelmsg, steppingmsg, familymsg, period,
	  dataCR,      intel_id, fpu_msg,     mce_msg,   cmp_msg,
	  not_intel };

	GetCPUId();
	GetFPUId();

	gotoxy(SCR_BEG,row++);
	 textcolor(BG_TXT),    cprintf(" CPU............: ");
	 textcolor(ANSWER_TXT);
	 if( CPUMessage[cpu_type] )
	  cprintf( "%s \n",CPUMessage[cpu_type] );
	 else
	  cprintf( "Unknown [%02Xh]",cpu_type );

	gotoxy(SCR_BEG,row++);
	 textcolor(BG_TXT),    cprintf(" FPU............: ");
	 textcolor(ANSWER_TXT);
	 if( FPUMessage[fpu_type] )
	  cprintf( "%s",FPUMessage[fpu_type] );
	 else
	  cprintf( "Unknown [%02Xh]",fpu_type );
}
--- REM --- */

void SnifferHWare::GetMouseInfo(void)
{
	static const byte *MouseButtons[4] = { "Other than 2","Unknown","Two","Three" };
	static const byte *MouseLanguages[9] = { "English","French","Dutch","German",
					 "Swedish","Finnish","Spanish","Portugese","Italian" };
	static const byte *MouseTypes[6] = { "Unknown","Bus","Serial","InPort","PS/2","HP" };
/*
const byte *MouseCTypes[4] = { "Software","Hardware","Graphics","Graphics" };
const byte *MouseIRates[4] = { "None","30Hz","50Hz","100Hz","200Hz" };
const byte *MsPointerSt[3] = { "Normal","Reverse","Transparent" };
const byte *MsPointerSi[3] = { "Small","Medium","Large" };
*/
	byte *LTVersion = "";
	byte MsType = 0,MsIRQ = 0,MsPointer = 0,MsPointSz = 0,MsPointSC = 0;
	word MsIFSeg = 0,MsIFOff = 0,MsLang = 0,MsHSen = 0,MsVSen = 0,MsDSSen = 0,
	     MsBut = 0,MsBPoint = 0,EGASup = 0,EGASeg = 0,EGAOff = 0,MSysSt = 0,MSysSeg = 0,
	     MSysOff = 0,LogSt = 0,LogBX = 0,LogCX = 0,LogHnd = 0,MsSt = 0,MsDType = 0,
	     MsAFile = 0,SSBuf = 0,MsDPage = 0;
	version = 0;

// ------------------------------------------ // Mouse Systems
	asm	mov ax,0x0070
	asm	mov bx,0xABCD
	asm	int 0x33
	asm	mov MSysSt,ax                 // Otetaan selville onko MSystems -hiiri asennettu
	asm	mov MSysSeg,bx                // Otetaan talteen seg. tunnistemerkkijonoa varten
	asm	mov MSysOff,cx                // Otetaan talteen siir.tunnistemerkkijonoa varten
// ------------------------------------------ // Locitech
	asm	mov ax,0x266C
	asm	mov bx,0x0000
	asm	mov cx,0x0000
	asm	int 0x33
	asm	mov LogSt,bx                  // Otetaan selville onko Logitech -hiiri asennettu
	asm	mov ax,0x1F6C
	asm	mov bx,0x0000
	asm	mov cx,0x0000
	asm	int 0x33
	asm	mov LogBX,bx                  // Otetaan selville hiiren ballistiikka
	asm	mov LogCX,cx                  // Otetaan selville hiiren ballistiikka
	asm	mov ax,0x216C
	asm	mov bx,0x0000
	asm	int 0x33
	asm	mov LogHnd,bx                 // Otetaan selville kden asetukset hiirelle
// ------------------------------------------ // Microsoft
	asm	mov ax,0x0000
	asm	int 0x33
	asm	mov MsBut,bx                  // Otetaan nappien mr selville
	asm	mov MsSt,ax                   // Otetaan selville onko MS -hiiri asennettu
	asm	mov ax,0x0024
	asm	int 0x33
	asm	mov version,bx                // Otetaan hiiriajurin versionumero talteen
	asm	mov MsType,ch                 // Otetaan hiiriajurin tyyppi selville
	asm	mov MsIRQ,cl                  // Otetaan hiiriajurin kyttm IRQ selville
	asm	mov ax,0x0025
	asm	int 0x33
	asm	mov MsDType,ax                // Otetaan talteen hiiriajurin tarkemmat tiedot
	asm	mov ax,0x002C
	asm	int 0x33
	asm	mov MsAFile,bx                // Otetaan hiiren kokoonpanotiedotojen lkm talteen
	asm	mov ax,0x0034
	asm	int 0x33
	asm	mov MsIFSeg,es                // Otetaan talteen seg. alustustiedoston nime varten
	asm	mov MsIFOff,dx                // Otetaan talteen siir.alustustiedoston nime varten
	asm	mov ax,0x0023
	asm	int 0x33
	asm	mov MsLang,bx                 // Otetaan hiiriajurin kieli selville
	asm	mov ax,0x1B
	asm	int 0x33
	asm	mov MsHSen,bx                 // Otetaan hiiren vaakaherkkyys selville
	asm	mov MsVSen,cx                 // Otetaan hiiren pystyherkkyys selville
	asm	mov MsDSSen,dx		      // Otetaan hiiren 2xklikkausnopeus selville
	asm	mov ax,0x0030
	asm	mov cx,0x0000
	asm	int 0x33
	asm	mov MsBPoint,ax               // Otetaan selville onko hiiress tuki BallPoint:lle
	asm	mov ax,0x0035
	asm	mov bx,0xFFFF
	asm	int 0x33
	asm	mov MsPointer,bh              // Otetaan hiiren osoittimen tyyli selville
	asm	mov MsPointSz,bl              // Otetaan hiiren osoittimen koko selville
	asm	mov MsPointSC,cl              // Otetaan selville onko kokoa mahdollista muuttaa
	asm	mov ax,0x0015
	asm	int 0x33
	asm	mov SSBuf,bx                  // Otetaan talteen puskurin koko tallennus -tilassa
	asm	mov ax,0x001E
	asm	int 0x33
	asm	mov MsDPage,bx                // Otetaan hiiren kyttm nyttsivu selville
	asm	mov ax,0x00FA
	asm	mov bx,0x0000
	asm	int 0x10
	asm	mov EGASup,bx                 // Otetaan selville tukeeko hiiri EGA-rekistereit
	asm	mov EGASeg,es
	asm	mov EGAOff,bx

	gotoxy(SCR_BEG,row++);
	 textcolor(BG_TXT),cprintf(" Mousedriver....: ");
	 textcolor(ANSWER_TXT);
	 if( (long)MSysSt == 0xABCD &&
	     (long)peek(MSysSeg,MSysOff) == 0xABCD &&
	     (long)peek(MSysSeg,MSysOff + 8) == 0xABCD ) {
	  version = peek(peek(MSysSeg,MSysOff + 4),peek(MSysSeg,MSysOff + 2));
	  cprintf("Mouse Systems V%u.%02u \n",HiWord( version ),
		  LoWord( version) );
	  }
	 else if( SHWare->ChkLTMouse() ) {
	  strcpy( LTVersion,SHWare->GetLTMouseVer() );
	  cprintf( "Logitech %s",LTVersion );

	  if( LTVersion[1] >= 4) {
	   gotoxy(SCR_BEG + 18,row++);
	    textcolor(BG_TXT),cprintf("Ballistics: ");
	    textcolor(ANSWER_TXT);
	    if(!LogBX)
	     cprintf("Off");
	    else if(LogCX == 0x01)
	     cprintf("Low");
	    else if(LogCX == 0x02)
	     cprintf("High");
	    else
	     cprintf("Unknown \n");
	   }
	   textcolor(BG_TXT),cprintf(", Hand: ");
	   textcolor(ANSWER_TXT);
	    if(!LogHnd)
	     cprintf("Right \n");
	    else
	     cprintf("Left \n");
	   }
	 else if(MsSt == 0xFFFF) {
	  cprintf("Microsoft V");
	  ShowBCD(version);
	  gotoxy(SCR_BEG,row++);
	   textcolor(BG_TXT),    cprintf(" Mouse..........: Type: ");
	   textcolor(ANSWER_TXT);
	   if( MouseTypes[MsType] )
	    cprintf( "%s",MouseTypes[MsType] );
	   else
	    cprintf( "Unknown \n" );
	   if( MsType != 0x04 && MsIRQ )
       cprintf(", IRQ%02u",MsIRQ);
	  gotoxy(SCR_BEG + 18,row++);
	   textcolor(BG_TXT),    cprintf("Language: ");
	   textcolor(ANSWER_TXT);
	   if( MouseLanguages[MsLang] )
	    cprintf( "%s \n",MouseLanguages[MsLang] );
	   else
	    cprintf( "Unknown \n" );
	  gotoxy(SCR_BEG + 18,row++);
	   textcolor(BG_TXT),    cprintf("Buttons: ");
	   textcolor(ANSWER_TXT);
	   if( MouseButtons[MsBut] )
	    cprintf( "%s \n",MouseButtons[MsBut] );
	   else
	    cprintf( "Unknown \n" );
	  gotoxy(SCR_BEG + 18,row++);
	   textcolor(BG_TXT),    cprintf("Horisontal speed: ");
	   textcolor(ANSWER_TXT),cprintf("%u \n",MsHSen);
	  gotoxy(SCR_BEG + 18,row++);
	   textcolor(BG_TXT),    cprintf("Vertical speed: ");
	   textcolor(ANSWER_TXT),cprintf("%u \n",MsVSen);
	  gotoxy(SCR_BEG + 18,row++);
	   textcolor(BG_TXT),    cprintf("Double speed threshold: ");
	   textcolor(ANSWER_TXT),cprintf("%u",MsDSSen);
/*
gotoxy(SCR_BEG + 18,row++);
 textcolor(BG_TXT),    cprintf(", BallPoint: ");
 textcolor(ANSWER_TXT);
 if(MsBPoint != 0xFFFF) cprintf("Yes");
 else cprintf("No");
gotoxy(SCR_BEG + 18,row++);
 if((version >>8) >= 7) {
   textcolor(BG_TXT),    cprintf("Driver type: ");
   textcolor(ANSWER_TXT);
   if(MsDType &0x8000) cprintf("Device");
    else cprintf("TSR");
   textcolor(BG_TXT),    cprintf(", Cursor type: ");
   textcolor(ANSWER_TXT),cprintf("%s",MouseCTypes[(MsDType &0x3000)>>12]);
  gotoxy(SCR_BEG + 18,row++);
   textcolor(BG_TXT),    cprintf("Number of MDDs: ");
   textcolor(ANSWER_TXT),cprintf("%u",MsDType &0x00FF);
  gotoxy(SCR_BEG + 18,row++);
   textcolor(BG_BG),     cprintf(", Interrupt rate: ");
   textcolor(ANSWER_TXT),cprintf("%s",MouseIRates[(MsDType &0x0F00)>>8]);
  gotoxy(SCR_BEG + 18,row++);
   textcolor(BG_TXT),    cprintf(", Number of acceleration profiles : "):
   textcolor(ANSWER_TXT),cprintf("%u",MsAFile);
  gotoxy(SCR_BEG + 18,row++);
   textcolor(BG_TXT),    cprintf(", Size of savestate -buffer: ");
   textcolor(ANSWER_TXT),cprintf("%uB",SSBuf);
  gotoxy(SCR_BEG + 18,row++);
   textcolor(BG_TXT),    cprintf(", Current display page: ");
   textcolor(ANSWER_TXT),cprintf("%u",MsDPage);
  if((version >>8) == 8 && (version &0x00FF) >= 10 || (version>>8) > 8) {
   textcolor(BG_TXT),    cprintf(", Pointer style: ");
   textcolor(ANSWER_TXT),cprintf("%s (%s)",MsPointerSt[MsPointer],MsPointerSi[MsPointSz]);
   textcolor(BG_TXT),    cprintf(", Size change: ");
   textcolor(ANSWER_TXT);
   if(MsPointSC == 1) cprintf("Yes");
   else cprintf("No");
   }
	    }
*/
	  gotoxy(SCR_BEG + 18,row++);
	   textcolor(BG_TXT),    cprintf("EGA register support: ");
	   textcolor(ANSWER_TXT);
	   if(EGASup) {
	    major = UnBCD(peek(EGASeg,EGAOff));
	    minor = UnBCD(peek(EGASeg,EGAOff+1));
	    cprintf("V%u.%02u",major,minor);
	    }
	   else
	    cprintf("No");
	  gotoxy(SCR_BEG + 18,row++);
	   if( HiWord( version ) >= 8) {
	    textcolor(BG_TXT),    cprintf("INI-file path: ");
	    textcolor(ANSWER_TXT);

	    while( peekb( MsIFSeg,MsIFOff ) != '\0' )
	     cprintf( "%c", peekb( MsIFSeg,MsIFOff++ ) );
	    }
	   }
	   else
	    cprintf("Mouse or mousedriver not installed \n");
}

void SnifferHWare::GetSysFlags( void )
{
	byte CFState = 0,VFState = 0;

	asm	mov ah,0x54
	asm	int 0x21
	asm	mov VFState,al                // Ota Verify -lipun tila selville
	gotoxy(SCR_BEG,row++);
	 textcolor(BG_TXT),      cprintf(" Verify flag....: ");
	 textcolor(ANSWER_TXT);
	 if( VFState == 0x01 )
	  cprintf( "On \n" );
	 else if( !VFState )
	  cprintf( "Off \n" );
	 else
	  cprintf( "Unknown \n" );

	asm	mov ah,0x33
	asm	mov al,0x00
	asm	int 0x21
	asm	mov CFState,dl                // Otetaan CB -lipun asento selvilleREAK lipun asento
	gotoxy(SCR_BEG,row++);
	 textcolor(BG_TXT),      cprintf(" Break flag.....: ");
	 textcolor(ANSWER_TXT);
	 if( CFState == 0x01 )
	  cprintf( "On \n" );
	 else if( !CFState )
	  cprintf( "Off \n" );
	 else
	  cprintf( "Unknown \n" );
}