/*
SYSTEM SNIFFER - MACHINE.CPP
Copyright (C) Tero Ripattila 1996-1998
*/

typedef struct {
 word NumByt;                                 // Seuraavana olevien tavujen lkm
 byte Model;                                  // Tietokoneen malli
 byte SubModel;                               // Tietokoneen alamalli
 byte BIOSRev;                                // BIOS:in pivitysnumero
 byte FeatByte1;
 byte FeatByte2;
 byte FeatByte3;
 byte FeatByte4;
 byte FeatByte5;
 byte AwardCNote;                             // AWARD BIOS:in (C)-merkint
 byte Null;
 word PhoenixVersion;                         // Phoenix BIOS:in versionumero
 byte PhoenixString[4];                       // Phoenix BIOS:in merkki "PTL"=Phoenix Technologies Ltd
 byte QuadramString[17];                      // Quadram Quad386:n merkki "Quadram Quad386XT"
 } CONFIGINFO;

SnifferMachine::SnifferMachine(void)
{
}

SnifferMachine::~SnifferMachine(void)
{
}

void SnifferMachine::GetROMDate( char Date[8] )
{
	int TempW = 0xFFF5;

	for( int i = 0; i < 8; i++ )
		Date[i] = (char)peekb( 0xF000,TempW++ );

	Date[8] = '\0';
}

void SnifferMachine::GetBIOSDate( char Date[8] )
{
	int TempW = 0x0005;

	for( int i = 0; i < 8; i++ )
		Date[i] = (char)peekb( 0xFFFF,TempW++ );

	Date[8] = '\0';
}

void SnifferMachine::GetMachineInfo(void)
{
	CONFIGINFO *ConfigInfo;
	char BIOSDate[8] = "",
	     ROMDate[8] = "";

	SMachine->GetBIOSDate( BIOSDate );
	SMachine->GetROMDate( ROMDate );

	gotoxy(SCR_BEG,row++);
	 textcolor(BG_TXT),    cprintf(" ROM............: Date: ");
	 textcolor(ANSWER_TXT);
	 if( *ROMDate )
	  cprintf( "%s",ROMDate );
	 else
	  cprintf( "Unknown" );
	gotoxy(SCR_BEG,row++);
	 textcolor(BG_TXT),    cprintf(" BIOS...........: Date: ");
	 textcolor(ANSWER_TXT);
	 if( *BIOSDate )
	  cprintf( "%s",BIOSDate );
	 else
	  cprintf( "Unknown" );

	inregs.h.ah = 0xC0;
	segregs.es  = FP_SEG(&ConfigInfo);
	inregs.x.bx = FP_OFF(&ConfigInfo);
	int86x(0x15,&inregs,&outregs,&segregs);

	if(!memcmp(ConfigInfo->PhoenixString,"PTL",3))
	 cprintf( ", Phoenix BIOS V%u.%02u", HiWord( ConfigInfo->PhoenixVersion ),
		  LoWord( ConfigInfo->PhoenixVersion ) );
	gotoxy(SCR_BEG,row++);
	 textcolor(BG_TXT),cprintf(" Bus............: ");
	 textcolor(ANSWER_TXT);
	 if(ConfigInfo->FeatByte1 & 0x01)
	  cprintf("MCA and ISA");
	 else if(ConfigInfo->FeatByte1 & 0x02)
	  cprintf("MCA");
	 else
	  cprintf("ISA");
	gotoxy(SCR_BEG,row++);
	 textcolor(BG_TXT),cprintf(" SCSI support...: ");
	 textcolor(ANSWER_TXT);
	 if(ConfigInfo->FeatByte3 &0x08)
	  cprintf("Yes");
	 else
	  cprintf("No");
	gotoxy(SCR_BEG,row++);
	 textcolor(BG_TXT),cprintf(" Machine........: ");
	 textcolor(ANSWER_TXT);

	 if(SMachine->ChkDELL())
	  SMachine->AnalyseDELL();
	 if(SMachine->ChkHP())
	  SMachine->AnalyseHP();
	 if(SMachine->ChkCompaq())
	  SMachine->AnalyseCompaq();
	 if(SMachine->ChkTandy())
	  SMachine->AnalyseTandy();
	 if(SMachine->ChkAST())
	  SMachine->AnalyseAST();
	 if(SMachine->ChkToshiba())
	  SMachine->AnalyseToshiba();

	 if(!outregs.x.cflag && !outregs.h.al) {
	  switch(ConfigInfo->Model) {
	   case 0xFF:
	    if(!ConfigInfo->SubModel) cprintf("Tandy 1000SL \n");
	    else if(ConfigInfo->SubModel==0x01) cprintf("Tandy 1000TL \n");
	    else if(ConfigInfo->SubModel==0x46) cprintf("Olivetti M15 \n");
	    else if(!memcmp(ROMDate,"04/24/81",8)) cprintf("PC (original) \n");
	    else if(!memcmp(ROMDate,"10/19/81",8)) cprintf("PC (some bugfixes) \n");
	    else if(!memcmp(ROMDate,"10/27/82",8)) cprintf("PC (HD, 640KB, EGA support) \n");
	    break;
	   case 0xFE:
	    if(ConfigInfo->SubModel==0x43) cprintf("Olivetti M240 \n");
	    else if(ConfigInfo->SubModel==0xA6) cprintf("Quadram Quad386 \n");
	    else if(!memcmp(ROMDate,"08/16/82",8)) cprintf("PC XT \n");
	    else if(!memcmp(ROMDate,"11/08/82",8)) cprintf("PC XT and portable \n");
	    break;
	   case 0xFD: if(!memcmp(ROMDate,"06/01/83",8)) cprintf("PCjr \n"); break;
	   case 0xFC:
	    if(!memcmp(ROMDate,"01/10/84",8)) cprintf("AT models 068,099 \n");
	    else if(!memcmp(ROMDate,"02/25/93",8)) cprintf("Linux DOSEMU \n");
	    switch(ConfigInfo->SubModel) {
	     case 0x00:
	      if(!ConfigInfo->BIOSRev) cprintf("PC3270/AT \n");
	      else if(ConfigInfo->BIOSRev==0x01 && !memcmp(ROMDate,"06/10/85",8)) cprintf("AT model 239 \n");
	      else if(ConfigInfo->BIOSRev>0x01) cprintf("7531/2 industrial AT \n");
	      break;
	     case 0x01:
	      if(!ConfigInfo->BIOSRev) cprintf("Compaq DESKPRO, SystemPro, ProSignia \n");
	      else if(!ConfigInfo->BIOSRev && !memcmp(ROMDate,"11/15/85",8)) cprintf("AT models 319,339 \n");
	      else if(!ConfigInfo->BIOSRev && !memcmp(ROMDate,"09/17/87",8)) cprintf("Tandy 3000 \n");
	      else if(!ConfigInfo->BIOSRev && !memcmp(ROMDate,"03/08/93",8)) cprintf("Compaq DESKPRO/i \n");
	      else if(!ConfigInfo->BIOSRev && !memcmp(ROMDate,"07/20/93",8)) cprintf("Zenith Z-Lite 425L \n");
	      else if(!ConfigInfo->BIOSRev && !memcmp(ROMDate,"04/09/90",8)) cprintf("AMI BIOS \n");
	      else if(ConfigInfo->BIOSRev==0x20 && !memcmp(ROMDate,"06/10/92",8)) cprintf("AST \n");
	      else if(ConfigInfo->BIOSRev==0x30) cprintf("Tandy 3000NL \n");
	      break;
	     case 0x02:
	      if(!ConfigInfo->BIOSRev) cprintf("Compaq LTE Lite \n");
	      else if(!ConfigInfo->BIOSRev && !memcmp(ROMDate,"04/21/86",8)) cprintf("PC XT-286 \n");
	      else if(!ConfigInfo->BIOSRev && !memcmp(ROMDate,"08/05/93",8)) cprintf("Compaq Contura 486/486c/486cx \n");
	      else if(!ConfigInfo->BIOSRev && !memcmp(ROMDate,"08/11/88",8)) cprintf("SoftWindows 1.0.1 (Power Macintosh) \n");
	      break;
	     case 0x04:
	      if(ConfigInfo->BIOSRev==0x02) cprintf("PS/2 Model 50 \n");
	      else if(ConfigInfo->BIOSRev==0x04) cprintf("PS/2 Model 50Z \n");
	      else if(!ConfigInfo->BIOSRev && !memcmp(ROMDate,"02/13/87",8)) cprintf("PS/2 Model 50 \n");
	      else if(ConfigInfo->BIOSRev==0x01 && !memcmp(ROMDate,"05/09/87",8)) cprintf("PS/2 Model 50 \n");
	      else if(ConfigInfo->BIOSRev==0x02 && !memcmp(ROMDate,"01/28/88",8)) cprintf("PS/2 Model 50Z \n");
	      else if(ConfigInfo->BIOSRev==0x03 && !memcmp(ROMDate,"04/18/88",8)) cprintf("PS/2 Model 50Z \n");
	      break;
	     case 0x05: if(!ConfigInfo->BIOSRev && !memcmp(ROMDate,"02/13/87",8)) cprintf("PS/2 Model 60 \n"); break;
	     case 0x06:
	      if(!ConfigInfo->BIOSRev) cprintf("IBM 7552-140 'Gearbox' \n");
	      else if(ConfigInfo->BIOSRev==0x01) cprintf("IBM 7552-540 'Gearbox' \n");
	      break;
	     case 0x08: if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model 25 \n"); break;
	     case 0x09:
	      if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model 25 \n");
	      else if(!ConfigInfo->BIOSRev && !memcmp(ROMDate,"08/25/88",8)) cprintf("PS/2 Model 30 \n");
	      else if(ConfigInfo->BIOSRev==0x02 && !memcmp(ROMDate,"06/28/89",8)) cprintf("PS/2 Model 30 \n");
	      else if(ConfigInfo->BIOSRev==0x02 && !memcmp(ROMDate,"06/28/89",8)) cprintf("PS/2 Model 25 \n");
	      break;
	     case 0x0B:
	      if(!ConfigInfo->BIOSRev && !memcmp(ROMDate,"12/01/89",8)) cprintf("PS/1 \n");
	      else if(!ConfigInfo->BIOSRev && !memcmp(ROMDate,"02/16/90",8)) cprintf("PS/1 Model 2011 \n");
	      break;
	     case 0x20: if(!ConfigInfo->BIOSRev && !memcmp(ROMDate,"02/18/93",8)) cprintf("Compaq ProLinea \n"); break;
	     case 0x30: cprintf("Epson \n");           break;
	     case 0x31: cprintf("Epson \n");           break;
	     case 0x33: cprintf("Epson \n");           break;
	     case 0x42: cprintf("Olivetti M280 \n");   break;
	     case 0x45: cprintf("Olivetti M380 \n");   break;
	     case 0x48: cprintf("Olivetti M290 \n");   break;
	     case 0x4F: cprintf("Olivetti M250 \n");   break;
	     case 0x50: cprintf("Olivetti M380 \n");   break;
	     case 0x51: cprintf("Olivetti PCS286 \n"); break;
	     case 0x52: cprintf("Olivetti M300 \n");   break;
	     case 0x81:
	      if(!ConfigInfo->BIOSRev && !memcmp(ROMDate,"01/15/88",8)) cprintf("Phoenix 386 \n");
	      else if(ConfigInfo->BIOSRev==0x01) cprintf("'OEM machine' \n");
	      break;
	     case 0x82: if(ConfigInfo->BIOSRev==0x01) cprintf("OEM machine \n"); break;
	     case 0x94: if(!ConfigInfo->BIOSRev) cprintf("Zenith 386 \n");  break;
	     } break;
	   case 0xFB:
	    switch(ConfigInfo->SubModel) {
	     case 0x00:
	      if(ConfigInfo->BIOSRev==0x01 && !memcmp(ROMDate,"01/10/86",8)) cprintf("PC XT-089 \n");
	      else if(ConfigInfo->BIOSRev==0x01 && !memcmp(ROMDate,"05/13/94",8)) cprintf("HP 200LX \n");
	      else if(ConfigInfo->BIOSRev==0x02 && !memcmp(ROMDate,"05/09/86",8)) cprintf("PC XT \n");
	      else if(ConfigInfo->BIOSRev==0x04 && !memcmp(ROMDate,"08/19/93",8)) cprintf("HP 100LX \n");
	      break;
	     case 0x4C: cprintf("Olivetti M200 \n"); break;
	     } break;
	   case 0xFA:
	    switch(ConfigInfo->SubModel) {
	     case 0x00:
	      if(!ConfigInfo->BIOSRev && !memcmp(ROMDate,"09/02/86",8)) cprintf("PS/2 Model 30 \n");
	      else if(ConfigInfo->BIOSRev==0x01 && !memcmp(ROMDate,"12/12/86",8)) cprintf("PS/2 Model 30 \n");
	      else if(ConfigInfo->BIOSRev==0x02 && !memcmp(ROMDate,"02/05/87",8)) cprintf("PS/2 Model 30 \n");
	      break;
	     case 0x01: if(!ConfigInfo->BIOSRev && !memcmp(ROMDate,"06/26/87",8)) cprintf("PS/2 Model 25/25L \n"); break;
	     case 0x30: if(!ConfigInfo->BIOSRev) cprintf("IBM Restaurant Terminal \n");                              break;
	     case 0x4E: cprintf("Olivetti M111 \n");                                                                     break;
	     case 0xFE: if(!ConfigInfo->BIOSRev) cprintf("IBM PCradio 9075 \n");                                     break;
	     } break;
	   case 0xF9:
	    switch(ConfigInfo->SubModel) {
	     case 0x00: if(!ConfigInfo->BIOSRev && !memcmp(ROMDate,"09/13/85",8)) cprintf("PC Convertible \n"); break;
	     case 0xFF: if(!ConfigInfo->BIOSRev) cprintf("PC Convertible \n");                                    break;
	    } break;
	   case 0xF8:
	    switch(ConfigInfo->SubModel) {
	     case 0x00:
	      if(!ConfigInfo->BIOSRev && !memcmp(ROMDate,"03/30/87",8)) cprintf("PS/2 Model 80 \n");
	      else if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model 75 \n");
	      break;
	     case 0x01: if(!ConfigInfo->BIOSRev && !memcmp(ROMDate,"10/07/87",8)) cprintf("PS/2 Model 80 \n"); break;
	     case 0x02: if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model 55-5571 \n");                               break;
	     case 0x04:
	      if(!ConfigInfo->BIOSRev && !memcmp(ROMDate,"01/29/88",8)) cprintf("PS/2 Model 70 \n");
	      else if(ConfigInfo->BIOSRev==0x02 && !memcmp(ROMDate,"04/11/88",8)) cprintf("PS/2 Model 70 \n");
	      else if(ConfigInfo->BIOSRev==0x03 && !memcmp(ROMDate,"03/17/89",8)) cprintf("PS/2 Model 70 \n");
	      break;
	     case 0x05: if(!ConfigInfo->BIOSRev) cprintf("IBM PC 7568 \n");        break;
	     case 0x06: if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model 55-5571 \n"); break;
	     case 0x07:
	      if(!ConfigInfo->BIOSRev) cprintf("IBM PC 7561/2 \n");
	      else if(ConfigInfo->BIOSRev==0x01) cprintf("PS/2 Model 55-5551 \n");
	      else if(ConfigInfo->BIOSRev==0x02) cprintf("IBM PC 7561/2 \n");
	      else if(ConfigInfo->BIOSRev==0x03) cprintf("PS/2 Model 55-5551 \n");
	      break;
	     case 0x09:
	      if(!ConfigInfo->BIOSRev && !memcmp(ROMDate,"01/29/88",8)) cprintf("PS/2 Model 70 \n");
	      else if(ConfigInfo->BIOSRev==0x02 && !memcmp(ROMDate,"04/11/88",8)) cprintf("PS/2 Model 70 \n");
	      else if(ConfigInfo->BIOSRev==0x03 && !memcmp(ROMDate,"03/17/89",8)) cprintf("PS/2 Model 70 \n");
	      else if(ConfigInfo->BIOSRev==0x04 && !memcmp(ROMDate,"12/15/89",8)) cprintf("PS/2 Model 70 \n");
	      break;
	     case 0x0B:
	      if(!ConfigInfo->BIOSRev && !memcmp(ROMDate,"01/18/89",8)) cprintf("PS/2 Model P70 \n");
	      else if(ConfigInfo->BIOSRev==0x02 && !memcmp(ROMDate,"12/16/89",8)) cprintf("PS/2 Model P70 \n");
	      break;
	     case 0x0C: if(!ConfigInfo->BIOSRev && !memcmp(ROMDate,"11/02/88",8)) cprintf("PS/2 Model 55SX \n"); break;
	     case 0x0D:
	      if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model 70 \n");
	      else if(!memcmp(ROMDate,"12/01/89",8)) cprintf("PS/2 Model 70 \n");
	      else if(!ConfigInfo->BIOSRev && !memcmp(ROMDate,"06/08/88",8)) cprintf("PS/2 Model 70 \n");
	      else if(ConfigInfo->BIOSRev==0x01 && !memcmp(ROMDate,"02/20/89",8)) cprintf("PS/2 Model 70 \n");
	      break;
	     case 0x0E: if(!ConfigInfo->BIOSRev) cprintf("PS/1 486SX \n");         break;
	     case 0x0F: if(!ConfigInfo->BIOSRev) cprintf("PS/1 486DX \n");         break;
	     case 0x10: if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model 55-5551 \n"); break;
	     case 0x11: if(!ConfigInfo->BIOSRev && !memcmp(ROMDate,"10/01/90",8)) cprintf("PS/2 Model 90 XP \n");          break;
	     case 0x12: if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model 95 XP \n");   break;
	     case 0x13: if(!ConfigInfo->BIOSRev && !memcmp(ROMDate,"10/01/90",8)) cprintf("PS/2 Model 90 XP \n");          break;
	     case 0x14: if(!ConfigInfo->BIOSRev && !memcmp(ROMDate,"10/01/90",8)) cprintf("PS/2 Model 90-AK/95 XP \n");    break;
	     case 0x15: if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model 90 XP \n");   break;
	     case 0x16: if(!ConfigInfo->BIOSRev && !memcmp(ROMDate,"10/01/90",8)) cprintf("PS/2 Model 90-AKD/95XP486 \n"); break;
	     case 0x17: if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model 90 XP \n");   break;
	     case 0x19:
	      if(ConfigInfo->BIOSRev==0x05) cprintf("PS/2 Model 35/35LS or 40 (20 MHz 386SX) \n");
	      else if(ConfigInfo->BIOSRev==0x05 && !memcmp(ROMDate,"03/15/91",8)) cprintf("PS/2 Model 35 SX/40 SX \n");
	      else if(ConfigInfo->BIOSRev==0x06 && !memcmp(ROMDate,"04/04/91",8)) cprintf("PS/2 Model 35 SX/40 SX \n");
	      break;
	     case 0x1A: if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model 95 XP \n"); break;
	     case 0x1B:
	      if(!ConfigInfo->BIOSRev && !memcmp(ROMDate,"09/29/89",8)) cprintf("PS/2 Model 70 486 \n");
	      else if(!ConfigInfo->BIOSRev && !memcmp(ROMDate,"10/02/89",8)) cprintf("PS/2 Model 70-486 \n");
	      break;
	     case 0x1C: if(!ConfigInfo->BIOSRev && !memcmp(ROMDate,"02/08/90",8)) cprintf("PS/2 Model 65-121/65 SX \n"); break;
	     case 0x1E: if(!ConfigInfo->BIOSRev && !memcmp(ROMDate,"02/08/90",8)) cprintf("PS/2 Model 55LS \n");         break;
	     case 0x23:
	      if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model L40 SX \n");
	      else if(ConfigInfo->BIOSRev==0x01) cprintf("PS/2 Model L40 SX \n");
	      else if(ConfigInfo->BIOSRev==0x02 && !memcmp(ROMDate,"02/27/91",8)) cprintf("PS/2 Model L40 SX \n");
	      break;
	     case 0x25:
	      if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model 57 SLC \n");
	      else if(ConfigInfo->BIOSRev==0x06) cprintf("PS/2 Model M57 \n");
	      break;
	     case 0x26:
	      if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model 57 SX \n");
	      else if(ConfigInfo->BIOSRev==0x01) cprintf("PS/2 Model 57 \n");
	      else if(ConfigInfo->BIOSRev==0x02 && !memcmp(ROMDate,"07/03/91",8)) cprintf("PS/2 Model 57 SX \n");
	      break;
	     case 0x28: if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model 95 XP \n");        break;
	     case 0x29: if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model 90 XP \n");        break;
	     case 0x2A: if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model 95 XP \n");        break;
	     case 0x2B: if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model 90 / 90XP486 \n"); break;
	     case 0x2C:
	      if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model 95 XP \n");
	      else if(ConfigInfo->BIOSRev==0x01) cprintf("PS/2 Model 95 \n");
	      break;
	     case 0x2D: if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model 90 XP \n"); break;
	     case 0x2E:
	      if(ConfigInfo->BIOSRev==0x00) cprintf("PS/2 Model 95 XP or	PS/2 Model 95 XP486 \n");
	      else if(ConfigInfo->BIOSRev==0x01) cprintf("PS/2 Model 95 \n");
	      break;
	     case 0x2F: if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model 90 XP \n");             break;
	     case 0x30: if(!ConfigInfo->BIOSRev) cprintf("PS/1 Model 2121 \n");              break;
	     case 0x33: if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model 30-386 \n");            break;
	     case 0x34: if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model 25-386 \n");            break;
	     case 0x36: if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model 95 XP \n");             break;
	     case 0x37: if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model 90 XP \n");             break;
	     case 0x38: if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model 57 \n");                break;
	     case 0x39: if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model 95 XP \n");             break;
	     case 0x3F: if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model 90 XP \n");             break;
	     case 0x40: if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model 95 XP \n");             break;
	     case 0x41: if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model 77 \n");                break;
	     case 0x45: if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model 90 XP (Pentium) \n");   break;
	     case 0x46: if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model 95 XP (Pentium) \n");   break;
	     case 0x47: if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model 90/95 E (Pentium) \n"); break;
	     case 0x48: if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model 85 \n");                break;
	     case 0x49: if(!ConfigInfo->BIOSRev) cprintf("PS/ValuePoint 325T \n");           break;
	     case 0x4A: if(!ConfigInfo->BIOSRev) cprintf("PS/ValuePoint 425SX \n");          break;
	     case 0x4B: if(!ConfigInfo->BIOSRev) cprintf("PS/ValuePoint 433DX \n");          break;
	     case 0x4E: if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model 295 \n");               break;
	     case 0x50:
	      if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model P70 (8573) \n");
	      else if(ConfigInfo->BIOSRev==0x01 && !memcmp(ROMDate,"12/16/89",8)) cprintf("PS/2 Model P70 (8570-031) \n");
	      break;
	     case 0x52: if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model P75 \n");     break;
	     case 0x56: if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model CL57 SX \n"); break;
	     case 0x57: if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model 90 XP \n");   break;
	     case 0x58: if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model 95 XP \n");   break;
	     case 0x59: if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model 90 XP \n");   break;
	     case 0x5A: if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model 95 XP \n");   break;
	     case 0x5B: if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model 90 XP \n");   break;
	     case 0x5C: if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model 95 XP \n");   break;
	     case 0x5D: if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model N51 SLC \n"); break;
	     case 0x5E: if(!ConfigInfo->BIOSRev) cprintf("IBM ThinkPad 700 \n");   break;
	     case 0x61: cprintf("Olivetti P500 \n");                                   break;
	     case 0x62: cprintf("Olivetti P800 \n");                                   break;
	     case 0x80:
	      if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model 80 \n");
	      else if(ConfigInfo->BIOSRev==0x01 && !memcmp(ROMDate,"11/21/89",8)) cprintf("PS/2 Model 80-A21 (25 Mhz 386) \n");
	      break;
	     case 0x81: if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model 55-5502 \n");               break;
	     case 0x87: if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model N33SX \n");                 break;
	     case 0x88: if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model 55-5530T \n");              break;
	     case 0x97: if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model 55 Note N23SX \n");         break;
	     case 0x99: if(!ConfigInfo->BIOSRev) cprintf("PS/2 Model N51 SX \n");                break;
	     case 0xF2: if(ConfigInfo->BIOSRev==0x30) cprintf("Reply Model 32 \n");                   break;
	     case 0xF6: if(ConfigInfo->BIOSRev==0x30) cprintf("Memorex Telex \n");                    break;
	     case 0xFD: if(!ConfigInfo->BIOSRev) cprintf("IBM Processor Complex (with VPD) \n"); break;
	     default:   cprintf("PS/2 Model 90 or PS/2 Model 95 \n");                                break;
	     } break;
	   case	0xE4: cprintf("Triumph Adler PC/XT \n");            break;
	   case 0xE1: if(!ConfigInfo->SubModel && !ConfigInfo->BIOSRev) cprintf("PS/2 Model 55-5530 Laptop \n");
	    break;
	   case 0xD9: cprintf("Peacock XT \n");                     break;
	   case 0x9A: cprintf("Compaq XT/Compaq Plus \n");          break;
	   case 0x30: cprintf("Sperry PC \n");                      break;
	   case 0x2D: cprintf("Compaq PC/Compaq Deskpro \n");       break;
           default:   cprintf("Unknown [%02Xh %02Xh] \n",ConfigInfo->Model,
			      ConfigInfo->SubModel);                break;
	   }
	  } else textcolor(ANSWER_TXT),cprintf("Error [Function not supported] \n");
	}

bool SnifferMachine::ChkDELL(void)
{
	char DELLString[4] = "";
	word i = 0;

	for(i = 0xE076; i <= 0xE079; i++)
	 DELLString[i] = peekb(0xF000,i);

//	DELLString[4] = '\0';

	return( memcmp(DELLString,"DELL",4) ? FALSE : TRUE );
}

void SnifferMachine::AnalyseDELL(void)
{
	byte ModelByte = 0;
	ModelByte = peekb(0xF000,0xE845);

	 switch(ModelByte) {
	  case 0x02: cprintf("Dell 200");              break;
	  case 0x03: cprintf("Dell 300");              break;
	  case 0x05: cprintf("Dell 220");              break;
	  case 0x06: cprintf("Dell 310");              break;
	  case 0x07: cprintf("Dell 325");              break;
	  case 0x09: cprintf("Dell 310A");             break;
	  case 0x0A: cprintf("Dell 316");              break;
	  case 0x0B: cprintf("Dell 220E");             break;
	  case 0x0C: cprintf("Dell 210");              break;
	  case 0x0D: cprintf("Dell 316SX");            break;
	  case 0x0E: cprintf("Dell 316LT");            break;
	  case 0x0F: cprintf("Dell 320LX");            break;
	  case 0x11: cprintf("Dell 425E");             break;
	  default:   cprintf("Unknown model of Dell"); break;
	  }
}

bool SnifferMachine::ChkHP(void)
{
	byte HPString[2] = "";
	word i = 0;

	for(i = 0x00F8; i <= 0x00F9; i++)
	 HPString[i] = peekb(0xF000,i);

//	HPString[2] = '\0';

	return( memcmp(HPString,"HP",2) ? FALSE : TRUE );
}

void SnifferMachine::AnalyseHP(void)
{
	 cprintf("Hewlett Packard");
}

bool SnifferMachine::ChkCompaq(void)
{
	byte CompaqString[6] = "";
	word i = 0;

	for(i = 0xFFEA; i <= 0xFFF0; i++)
	 CompaqString[i] = peekb(0xF000,i);

//	CompaqString[6] = '\0';

	return( memcmp(CompaqString,"COMPAQ",6) ? FALSE : TRUE );
}

void SnifferMachine::AnalyseCompaq(void)
{
	cprintf("Compaq");
}

bool SnifferMachine::ChkTandy(void)
{
	byte Tandy1000B1 = 0,Tandy1000B2 = 0;

	Tandy1000B1 = peekb(0xF000,0xC000);
	Tandy1000B2 = peekb(0xFFFF,0x000E);

	if(Tandy1000B1==0x21 && Tandy1000B2==0xFF)
	 return( TRUE );
	else
	 return( FALSE );
}

void SnifferMachine::AnalyseTandy(void)
{
	cprintf("Tandy");
}

bool SnifferMachine::ChkAST(void)
{
	byte ASTString[22] = "";
	word i = 0;

	for(i = 0xE710; i <= 0xE726; i++)
	 ASTString[i] = peekb(0xF000,i);

//	ASTString[22] = '\0';

	return( memcmp(ASTString,"COPYRIGHT AST RESEARCH",22) ? FALSE : TRUE );
}

void SnifferMachine::AnalyseAST(void)
{
	cprintf("AST");
}

bool SnifferMachine::ChkToshiba(void)
{
	byte ToshibaInfo[0x20]="";
	word i = 0;

	for(i = 0xE010; i <= 0xE018; i++)
	 ToshibaInfo[i]=peekb(0xF000,i);

	if(ToshibaInfo[0x10] == 'T' && ToshibaInfo[0x11] == 'O' &&
	   ToshibaInfo[0x12] == 'S' && ToshibaInfo[0x13] == 'H' &&
	   ToshibaInfo[0x14] == 'I' && ToshibaInfo[0x15] == 'B' &&
	   ToshibaInfo[0x16] == 'A' && ToshibaInfo[0x17] == ' ')
	 return( TRUE );
	else
	 return( FALSE );
}

void SnifferMachine::AnalyseToshiba(void)
{
	cprintf("Toshiba");
}
