UNIT DisplayKeyboardAndCursor;
(* ----------------------------------------------------------------------
   Part of 4DESC - A Simple 4DOS File Description Editor

       David Frey,         & Tom Bowden
       Urdorferstrasse 30    1575 Canberra Drive
       8952 Schlieren ZH     Stone Mountain, GA 30088-3629
       Switzerland           USA

       Code created using Turbo Pascal 7.0, (c) Borland International 1992

   DISCLAIMER: This unit is freeware: you are allowed to use, copy
               and change it free of charge, but you may not sell or hire
               this part of 4DESC. The copyright remains in our hands.

               If you make any (considerable) changes to the source code,
               please let us know. (send a copy or a listing).
               We would like to see what you have done.

               We, David Frey and Tom Bowden, the authors, provide absolutely
               no warranty of any kind. The user of this software takes the
               entire risk of damages, failures, data losses or other
               incidents.

   This unit manages displaying messages, switching cursor modes etc.

   ----------------------------------------------------------------------- *)

INTERFACE USES Crt, Dos, Dmouse;

CONST Header1 = '4DESC 1.75 - (c) 1992, 1995 Copyright by David Frey & Tom Bowden ';
      Header2 = 'Portions of code (c) 1993 Robert Juhasz and (c) 1990 Borland Inc.';
(* Cursor *)

VAR OrigCursor : WORD;
    OverCursor : WORD; (* Cursor shape when overwriting *)
    InsCursor  : WORD; (*   "      "    "   inserting   *)

(* Color constants for color screens: *)

CONST co_StatusFg = Blue;
      co_StatusBg = Cyan;
      co_DirFg    = LightCyan;
      co_SelectFg = Blue;
      co_SelectBg = Cyan;
      co_HighFg   = LightRed;
      co_NormFg   = LightGray;
      co_NormBg   = Blue;
      co_WarnFg   = Yellow;
      co_WarnBg   = Cyan;

      (* ...and for monochrome displays: *)

      mo_StatusFg = Black;
      mo_StatusBg = LightGray;
      mo_DirFg    = White;
      mo_SelectFg = Black;
      mo_SelectBg = LightGray;
      mo_HighFg   = LightGray;
      mo_NormFg   = LightGray;
      mo_NormBg   = Black;
      mo_WarnFg   = Black;
      mo_WarnBg   = White;

VAR   ScreenSize : BYTE;
      ScreenWidth: BYTE;
      MaxLines   : BYTE;
      Monochrome : BOOLEAN;

VAR   StatusFg   : BYTE;
      StatusBg   : BYTE;
      DirFg      : BYTE;
      SelectFg   : BYTE;
      SelectBg   : BYTE;
      HighFg     : BYTE;
      NormFg     : BYTE;
      NormBg     : BYTE;
      WarnFg     : BYTE;
      WarnBg     : BYTE;
      _4DOSVer   : STRING[11];

      ListCmd    : PathStr;
      EditCmd    : PathStr;

(* Min/Max *)
FUNCTION Min(a,b : INTEGER): INTEGER;
FUNCTION Max(a,b : INTEGER): INTEGER;

(* Cursor *)
PROCEDURE SetCursorShape(Cursor: WORD);
FUNCTION  GetCursorShape: WORD;
PROCEDURE ResetCursor(Overwrite: BOOLEAN);

(* Screen *)
PROCEDURE Get4DOSVer;
PROCEDURE ChooseColors(Monochrome: BOOLEAN);

PROCEDURE ReportError(msg: STRING; FullClipBoard, Changed: BOOLEAN);
PROCEDURE DrawMainScreen(Index,NrOfFiles: WORD; Col,CurDescLen: BYTE);
PROCEDURE DrawStatusLine(Redraw,FullClipboard, Changed, ReverseFlag: BOOLEAN);
PROCEDURE ShowHelpPage;

(* Keyboard *)

FUNCTION GetKey: WORD;

PROCEDURE EvaluateINIFileSettings;

IMPLEMENTATION USES HandleINIFile, StringDateHandling;

VAR s   : STRING;
    line: STRING[132];

(*------------------------------------------------------------- Min/Max *)
FUNCTION Min(a,b : INTEGER): INTEGER;

BEGIN
 IF a < b THEN Min := a
          ELSE Min := b;
END;

FUNCTION Max(a,b : INTEGER): INTEGER;

BEGIN
 IF a > b THEN Max := a
          ELSE Max := b;
END;


(* -------------------------------------------------------- Cursor *)

PROCEDURE SetCursorShape(Cursor: WORD); ASSEMBLER;

ASM
 mov ah,01h
 mov cx,Cursor
 Int 10h
END;

FUNCTION  GetCursorShape: WORD; ASSEMBLER;

ASM
 mov ah,03h
 mov bh,0
 Int 10h
 mov ax,cx
END;

PROCEDURE ResetCursor(Overwrite: BOOLEAN);

VAR Cursor : WORD;

BEGIN
 IF Overwrite THEN Cursor := OverCursor
              ELSE Cursor := InsCursor;
 SetCursorShape(Cursor);
END; (* ResetCursor *)


(* -------------------------------------------------------- Screen *)
PROCEDURE Get4DOSVer;

VAR Regs    : Registers;
    _4dvmaj : STRING[1];
    _4dvmin : STRING[2];

 PROCEDURE DisplayVer;
  BEGIN
   Str(Regs.bl:1,_4dvmaj);
   Str(Regs.bh:2,_4dvmin);
   IF _4dvmin[1] = ' ' THEN _4dvmin[1] := '0';
   _4DOSVer := ' 4DOS ' + _4dvmaj + '.' + _4dvmin + ' ';
  END;

BEGIN
 Regs.ax := $D44D;
 Regs.bx := $0;
 Intr($2F,Regs);
 IF Regs.ax = $44DD THEN    (* 4DOS is active *)
  DisplayVer
 ELSE
  BEGIN
   Regs.ax := $E44D;
   Regs.bx := $0;
   Intr($2F,Regs);
   IF Regs.ax = $44EE THEN    (* NDOS is active *)
    BEGIN
     DisplayVer;
     _4DOSVer[2] := 'N';
    END
   ELSE
    _4DOSVer := '';
  END
END;  (* Get4DOSVer *)

Procedure CheckKeyOrMouse;

Var Key : Word;

Begin
  Key := $0000;
  Repeat
    If KeyPressed Then Key := GetKey
    Else
      If MouseLoaded Then
         Begin
           ButtonReleased(Left);
           If ReleaseCount > 0 Then Key := $FF;
           ButtonReleased(Right);
           If ReleaseCount > 0 Then Key := $FF;
         End;
  Until Key <> $0000;
End;  (* CheckKeyOrMouse *)

PROCEDURE ReportError(msg: STRING; FullClipBoard, Changed: BOOLEAN);

VAR ch : WORD;

BEGIN
 TextColor(WarnFg); TextBackGround(WarnBg);
 GotoXY(1,MaxLines);
 IF Length(msg) < ScreenWidth-1 THEN Write(Chars(' ',(ScreenWidth-Length(msg)) div 2));
 Write(msg); ClrEol;
 CheckKeyOrMouse;
 DrawStatusLine(TRUE,FullClipBoard,Changed,FALSE);
END; (* ReportError *)

PROCEDURE DrawStatusLine(Redraw,FullClipboard, Changed, ReverseFlag: BOOLEAN);

VAR OldTextAttr: BYTE;

BEGIN
 OldTextAttr := TextAttr; (* Save the old text attribute *)

 TextBackGround(NormBg);
 IF Redraw THEN
  BEGIN
   TextColor(NormFg);
   GotoXY(1,MaxLines); ClrEol;
   GotoXY(1,MaxLines); Write(line);
   GotoXY(3,MaxLines); Write(_4DOSVer);
  END;

 GotoXY(76,MaxLines);
 IF FullClipBoard THEN BEGIN TextColor(HighFg); Write('Buf'); END
                  ELSE BEGIN TextColor(NormFg); Write(''); END;

 GotoXY(70,MaxLines);
 IF Changed THEN BEGIN TextColor(HighFg); Write('Edit'); END
            ELSE BEGIN TextColor(NormFg); Write(''); END;

 GotoXY(68,MaxLines);
 IF ReverseFlag THEN BEGIN TextColor(HighFg); Write('R'); END
                ELSE BEGIN TextColor(NormFg); Write(''); END;

 TextAttr := OldTextAttr; (* and the original text attribute *)
END; (* DrawStatusLine *)

PROCEDURE DrawMainScreen(Index,NrOfFiles: WORD; Col,CurDescLen: BYTE);

BEGIN
 TextColor(NormFg); TextBackGround(NormBg);
 ClrScr;
 TextColor(StatusFg); TextBackGround(StatusBg);
 GotoXY(1,1);
 Write('ESC exits  F1 Help  F2 Saves         Line ',Index:5,' of ',NrOfFiles:5,
       ', Col ',Col:3,' Length ',CurDescLen:3,' '); ClrEol;
 DrawStatusLine(TRUE,FALSE,FALSE,FALSE);
END; (* DrawMainScreen *)

PROCEDURE ShowHelpPage;

VAR ch, cursor : WORD;

BEGIN
 TextBackGround(NormBg);
 ClrScr;
 TextColor(DirFg);
 GotoXY((ScreenWidth-10) DIV 2, 1); Write('4DESC Help');
 TextColor(NormFg);
 GotoXY((ScreenWidth-52) DIV 2, 2); Write('USAGE:  4DESC [/help] [/mono] [/dontask] [d:][\path]');

 GotoXY( 3, 4); Write(Chr(24),Chr(25),Chr(27),Chr(26),', PgUp, PgDn, Home, End: Moves bar & cursor');
 GotoXY( 3, 5); Write('Ctrl-PgUp/Ctrl-PgDn:         Moves to first/last line');
 GotoXY( 3, 6); Write('Ctrl-Left/Ctrl-Right:        Moves to previous/next word');
 GotoXY( 3, 7); Write('Ctrl-Home/Ctrl-End:          Deletes from cursor to start/end of line');
 GotoXY( 3, 8); Write('Backspace/DEL:               Deletes character before/under cursor');
 GotoXY( 3,10); Write('INS:                         Toggles from insert mode to overwrite mode');
 GotoXY( 3,11); Write('Alt-D:                       Deletes current description');
 GotoXY( 3,12); Write('Alt-C:                       Copy current description to buffer');
 GotoXY( 3,13); Write('Alt-M or Alt-T:              Move current description to buffer');
 GotoXY( 3,14); Write('Alt-P:                       Paste buffer to current description');
 GotoXY( 3,15); Write('Alt-S or Shift-F10:          Shell to (4)DOS');
 GotoXY( 3,16); Write('Alt-X (Alt-Q), ESC:          Exit (quit) program (Alt-X stays in current dir)');
 GotoXY( 3,17); Write('F3 or Alt-V, (Alt-E):        View (edit) highlighted file');
 GotoXY( 3,18); Write('F4 (F5) or ENTER on dir/..:  Change to highlighted/parent directory');
 GotoXY( 3,19); Write('F6 or Alt-L:                 Change drive');
 GotoXY( 3,21); Write('Ctrl-N/Ctrl-E/Ctrl-S/Ctrl-D: sort current directory (Name/Ext/Size/Date)');
 GotoXY( 3,22); Write('Ctrl-R Ctrl-N/E/S/D:         reverse sort directory (Name/Ext/Size/Date)');

 GotoXY((ScreenWidth-Length(Header1)) div 2 ,24); Write(Header1);
 GotoXY((ScreenWidth-Length(Header2)) div 2 ,25); Write(Header2);
(* GotoXY((ScreenWidth-24) div 2,25); Write('Press any key to return.'); *)

 Cursor := $2000; SetCursorShape(Cursor);   (* Hide cursor. *)
 CheckKeyOrMouse;
END; (* ShowHelp *)


(* -------------------------------------------------------- Keyboard *)

FUNCTION GetKey: WORD;

VAR chlo, chhi : CHAR;

BEGIN
 chlo := ReadKey;
 IF chlo = #0 THEN chhi := ReadKey
              ELSE chhi := #0;


 (* Special cases to fit TP kbXXX constants: *)
 IF (chlo = #$1B) THEN  BEGIN chhi := #$01; END  (* ESC   *)
 ELSE
 IF (chlo = #$0D) THEN  BEGIN chhi := #$1C; END  (* Enter *)
 ELSE
 IF (chlo = #$08) THEN  BEGIN chhi := #$0E; END; (* Backspace *)

 GetKey := WORD(chhi) SHL 8 + BYTE(chlo);
END;


PROCEDURE ChooseColors(Monochrome: BOOLEAN);

BEGIN
 IF Monochrome THEN
  BEGIN
   DirFg    := ReadSettingsColor('monodisplay','dirfg'   ,mo_DirFg);
   StatusFg := ReadSettingsColor('monodisplay','statusfg',mo_StatusFg);
   StatusBg := ReadSettingsColor('monodisplay','statusbg',mo_StatusBg);
   SelectFg := ReadSettingsColor('monodisplay','selectfg',mo_SelectFg);
   SelectBg := ReadSettingsColor('monodisplay','selectbg',mo_SelectBg);
   HighFg   := ReadSettingsColor('monodisplay','highfg'  ,mo_HighFg);
   NormFg   := ReadSettingsColor('monodisplay','normfg'  ,mo_NormFg);
   NormBg   := ReadSettingsColor('monodisplay','normbg'  ,mo_NormBg);
   WarnFg   := ReadSettingsColor('monodisplay','warnfg'  ,mo_WarnFg);
   WarnBg   := ReadSettingsColor('monodisplay','warnbg'  ,mo_WarnBg);
  END
 ELSE
  BEGIN
   DirFg    := ReadSettingsColor('colordisplay','dirfg'   ,co_DirFg);
   StatusFg := ReadSettingsColor('colordisplay','statusfg',co_StatusFg);
   StatusBg := ReadSettingsColor('colordisplay','statusbg',co_StatusBg);
   SelectFg := ReadSettingsColor('colordisplay','selectfg',co_SelectFg);
   SelectBg := ReadSettingsColor('colordisplay','selectbg',co_SelectBg);
   HighFg   := ReadSettingsColor('colordisplay','highfg'  ,co_HighFg);
   NormFg   := ReadSettingsColor('colordisplay','normfg'  ,co_NormFg);
   NormBg   := ReadSettingsColor('colordisplay','normbg'  ,co_NormBg);
   WarnFg   := ReadSettingsColor('colordisplay','warnfg'  ,co_WarnFg);
   WarnBg   := ReadSettingsColor('colordisplay','warnbg'  ,co_WarnBg);
  END
END;

PROCEDURE EvaluateINIFileSettings;

VAR c: WORD;

BEGIN
 ListCmd := ReadSettingsString('generaldisplay','viewer','list');
 EditCmd := ReadSettingsString('generaldisplay','editor','edit');

 c := ReadSettingsInt('','cursorover',100);
 IF c = 100 THEN c := ReadSettingsInt('primary','cursorover',100);
 OverCursor := ($07-Round(c/100 * 7)) SHL 8 + $07;

 c := ReadSettingsInt('','cursorins' , 10);
 IF c = 10 THEN c := ReadSettingsInt('primary','cursorins' , 10);

 InsCursor  := ($07-Round(c/100 * 7)) SHL 8 + $07;
END;

BEGIN
 Get4DOSVer;
 OrigCursor := GetCursorShape;
 MaxLines   := Hi(WindMax)+1;
 ScreenSize := MaxLines-4;
 ScreenWidth:= Lo(WindMax)+1;
 Monochrome := (LastMode = Mono);
 line       := Chars('',ScreenWidth-1);
END.
