DESTDIR = ../html/$(DOCNAME)
LATEX2HTMLDIR = /home/pekangas/latex2html-96.1
LATEX2HTML = $(LATEX2HTMLDIR)/latex2html
LATEX2HTMLOPTS = -init_file ../common/latex2html-init -dir $(DESTDIR)
LATEX = latex
M4 = m4
M4OPTS = -I../common
RM = rm
RMDIR = rmdir

export TEXINPUTS := ../common:$(LATEX2HTMLDIR)/texinputs:$(TEXINPUTS)

.PRECIOUS:	%.aux %.toc %.tex

%-html :	%.tex %.toc
		$(LATEX2HTML) $(LATEX2HTMLOPTS) $*
		echo done > $@

%.dvi :		%.aux %.toc
		$(LATEX) $*

%.aux %.toc :	%.tex
		$(LATEX) $*
		$(RM) $*.dvi

%.tex :		%.m4 $(DOCINCLUDES) ../common/midasdoc.sty
		$(M4) $(M4OPTS) $*.m4 > $@

clean :
		-$(RM) $(DESTDIR)/* $(DESTDIR)/.* 
		-$(RM) *.log *.toc *.aux *.dvi *~ *.bak *-html *.tex core
		-$(RMDIR) $(DESTDIR)




