/*____________________________________________________________________________
	
	FreeAmp - The Free MP3 Player

	Portions Copyright (C) 1998 GoodNoise

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
	
	$Id: testitem.cpp,v 1.1 1999/03/03 09:06:21 elrod Exp $
____________________________________________________________________________*/

/* system headers */
#include <stdlib.h>
#include <assert.h>

/* project headers */
#include "config.h"
#include "testitem.h"
#include "renderer.h"

TestItem::
TestItem():
ListItem()
{
    SetHeight(10);
    SetWidth(20);

    m_r = rand() % 255;
    m_g = rand() % 255; 
    m_b = rand() % 255;
}

TestItem::
~TestItem()
{

}

void
TestItem::
DrawItem(DIB* canvas, RECT* bounds)
{
    int32 r,g,b;

    if(IsSelected())
    {
        r = 255;
        g = 0;
        b = 0;
    }
    else
    {
        r = m_r;
        g = m_g;
        b = m_b;
    }

    Renderer::Fill( canvas,
                    bounds->left, 
                    bounds->top,     
                    bounds->right - bounds->left,      
                    bounds->bottom - bounds->top, 
                    r,    
                    g,
                    b);
}