#include "cthugha.h"
#include "interface.h"
#include "keys.h"
#include "sound.h"
#include "display.h"
#include "disp-sys.h"
#include "options.h"
#include "AutoChanger.h"
#include "SoundProcess.h"
#include "SoundAnalyze.h"
#include "CthughaBuffer.h"
#include "imath.h"
#include "CthughaDisplay.h"

#include <unistd.h>

InterfaceMain interfaceMain(0);

//
// main interface (no text)
//
InterfaceMain::InterfaceMain(int p) : Interface(NULL, 0, p), silenceMsg(NULL) {
}

int InterfaceMain::do_key(int key) {
    switch(key) {
    case 'q': case 'Q': case CK_ESC: 
	set( interfaceCredits);
	return 0;

    case 'r':		
	PaletteEntry::Random();	
	CthughaBuffer::current->palette.setValue(PaletteEntry::lastRandomPos);
	return 0;
    case 'R':		
	PaletteEntry::addRandom();
	CthughaBuffer::current->palette.setValue(PaletteEntry::lastRandomPos);
	return 0;

    case 'd':		screen.change(+1,0);					return 0;
    case 'D':		screen.change(-1,0);					return 0;

    case 'z':		zoom.change(+1);					return 0;
    case 'Z':		zoom.change(-1);					return 0;

    case '<':		CthughaBuffer::nCurrent.change(+1);			return 0;
    case '>':		CthughaBuffer::nCurrent.change(+1);			return 0;

    case 'f':		CthughaBuffer::current->flame.change(+1,0);		return 0;
    case 'F':		CthughaBuffer::current->flame.change(-1,0);		return 0;
    case 'g': case 'G':	CthughaBuffer::current->flameGeneral.changeRandom();	return 0;

    case 'w':		CthughaBuffer::current->wave.change(+1,0);		return 0;
    case 'W':		CthughaBuffer::current->waveScale.change(+1,0);		return 0;
    case 'j':		CthughaBuffer::current->object.change(+1,0);		return 0;
    case 'J':		CthughaBuffer::current->object.change(-1,0);		return 0;

    case 't':		CthughaBuffer::current->translate.change(+1,0);		return 0;
    case 'T':		CthughaBuffer::current->translate.change(-1,0);		return 0;

    case 'm':		CthughaBuffer::current->soundProcess.change(+1,0);	return 0;
    case 'M':		CthughaBuffer::current->soundProcess.change(-1,0);	return 0;

    case '=':		CthughaBuffer::current->border.change(+1,0);		return 0;
	
    case 's': case 'S':	CthughaBuffer::current->flashlight.change(+1, 0);	return 0;

    case 'p':		CthughaBuffer::current->palette.change(+1,0);		return 0;
    case 'P':		CthughaBuffer::current->palette.change(-1,0);		return 0;
    case 'b':		CthughaBuffer::current->table.change(+1,0);		return 0;
    case 'B':		CthughaBuffer::current->table.change(-1,0);		return 0;
	
    case 'x': 		CthughaBuffer::current->pcx.change(+1,0); return 0;
    case 'X': 		CthughaBuffer::current->pcx.change(-1,0); return 0;
	
    case 'l': case 'L': lock.change(+1);					return 0;

    case 'a': case 'A':	write_ini();						return 0;
	
    case 'n': case 'N':			/* when net-sound: send request to server */
	soundDevice->change();
	return 0;
	
    case CK_PRINT: case '#':		/* real print screen */
	save_display();
	return 0;
	
    case CK_BACK:			/* change back */
	CoreOption::restore();
	return 0;

    case 'h': case 'H':			// save to hot key
	save = 1 - save;
	return 0;

    case CK_SHIFT(0):    case CK_SHIFT(1):
    case CK_SHIFT(2):    case CK_SHIFT(3):
    case CK_SHIFT(4):    case CK_SHIFT(5):
    case CK_SHIFT(6):    case CK_SHIFT(7):
    case CK_SHIFT(8):    case CK_SHIFT(9):	// store hot 
	CoreOption::save(key - CK_SHIFT(0));
	return 0;

    case '0':    case '1':    case '2':    case '3':
    case '4':    case '5':    case '6':    case '7':
    case '8':    case '9':
	if(save) {
	    CoreOption::save(key - '0');
	    save = 0;
	} else {
	    CoreOption::restore(key - '0');
	}
	return 0;

    case ' ':
	CoreOption::changeAll();
	return 0;
    case CK_ENTER:
	CoreOption::changeOne();
	return 0;

    default:
	return Interface::do_key(key);
    }
}

void InterfaceMain::display() {

    Interface::display();

    if( save) {
	displayDevice->print("save to hotkey (press 0..9)", text_size.y - (showStatus ? 2 : 1), 
			     'l', TEXT_COLOR_NORMAL);
    }

    if( soundAnalyze.noisy ) {
	silenceMsg = NULL;
    } else if(silenceMsg != NULL)
	displayDevice->print(silenceMsg, silenceLine, 'c', TEXT_COLOR_NORMAL);
}

void InterfaceMain::msg(char * msg) {
    silenceMsg = msg;
    silenceLine = rand() % (text_size.y - 5);
}



