/* ProSite HTML Editor
 * wizards.c - much magic is contained within
 *
 * Copyright (C) 1998 Olivier Sessink and Chris Mazuc
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <stdio.h>
#include <gtk/gtk.h>
#include <string.h>
#include "widgets.h"
#include "wizards.h"
#include "init.h"
#include "bluefish.h"
#include "html.h"

extern GList *targetlist;
extern GList *colorlist;
extern GList *fontlist;

/* external functions I want to use */
extern void create_buttons (void);
extern void flush_queue (void);
extern void destroy_dialog (void);
extern void add_to_statusbar (gchar *);
extern void insert_text (gchar *, gchar *);
extern void create_dialog (int, int, gchar *);
extern gchar *converttohex (gchar *);

/* local stuff */
void set_type_sensitive1 (GtkWidget *, gpointer);
void set_type_sensitive2 (GtkWidget *, gpointer);
void set_type_sensitive3 (GtkWidget *, gpointer);
void set_type_sensitive4 (GtkWidget *, gpointer);
void dtd_select_ok (GtkWidget *, gpointer);
void get_title (void);
void get_title_ok (GtkWidget *, gpointer);
void get_body (void);
void get_body_ok (GtkWidget *, gpointer);
void table_wizard_ok (GtkWidget *, gpointer);
void frame_wizard_ok (GtkWidget *, gpointer);

gchar *stuff;
gint used_mem, rows, columns, frames, i, z;

/* Quickstart Wizard */

void
quickstart (GtkWidget * widget, gpointer data)
{
  create_dialog (450, 209,
		 "Quick Start - Document Type Definition Selection");
  dialogtable = gtk_table_new (1, 10, 0);
  gtk_container_border_width (GTK_CONTAINER (vbox), 0);
  gtk_box_pack_start (GTK_BOX (vbox), dialogtable, FALSE, FALSE, 0);
  gtk_widget_show (dialogtable);

  frame1 = gtk_aspect_frame_new ("HTML Version", 0.5, 0.5, 2, 0);
  gtk_widget_set_usize (frame1, 70, 130);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), frame1, 0, 5, 0, 1);
  gtk_container_border_width (GTK_CONTAINER (frame1), 0);
  gtk_widget_show (frame1);

  box = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame1), box);
  gtk_container_border_width (GTK_CONTAINER (box), 0);
  gtk_widget_show (box);

  radio1 = gtk_radio_button_new_with_label (NULL, "2.0");
  radio2 = gtk_radio_button_new_with_label (gtk_radio_button_group
					    (GTK_RADIO_BUTTON (radio1)),
					    "3.0");
  radio3 = gtk_radio_button_new_with_label (gtk_radio_button_group
					    (GTK_RADIO_BUTTON (radio1)),
					    "3.2");
  radio4 = gtk_radio_button_new_with_label (gtk_radio_button_group
					    (GTK_RADIO_BUTTON (radio1)),
					    "4.0");
  gtk_signal_connect (GTK_OBJECT (radio1), "clicked", GTK_SIGNAL_FUNC
		      (set_type_sensitive1), NULL);
  gtk_signal_connect (GTK_OBJECT (radio2), "clicked", GTK_SIGNAL_FUNC
		      (set_type_sensitive2), NULL);
  gtk_signal_connect (GTK_OBJECT (radio3), "clicked", GTK_SIGNAL_FUNC
		      (set_type_sensitive3), NULL);
  gtk_signal_connect (GTK_OBJECT (radio4), "clicked", GTK_SIGNAL_FUNC
		      (set_type_sensitive4), NULL);
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (radio1), TRUE);
  gtk_widget_set_usize (radio1, 10, 18);
  gtk_widget_set_usize (radio2, 10, 18);
  gtk_widget_set_usize (radio3, 10, 18);
  gtk_widget_set_usize (radio4, 10, 18);
  gtk_box_pack_start (GTK_BOX (box), radio1, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (box), radio2, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (box), radio3, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (box), radio4, FALSE, FALSE, 0);
  gtk_widget_show (radio1);
  gtk_widget_show (radio2);
  gtk_widget_show (radio3);
  gtk_widget_show (radio4);

  frame2 = gtk_aspect_frame_new ("Type", 0.5, 0.5, 2, 0);
  gtk_widget_set_usize (frame2, 70, 130);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), frame2, 5, 10, 0, 1);
  gtk_container_border_width (GTK_CONTAINER (frame2), 0);
  gtk_widget_show (frame2);

  box = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame2), box);
  gtk_container_border_width (GTK_CONTAINER (box), 0);
  gtk_widget_show (box);

  radio5 = gtk_radio_button_new_with_label (NULL, "Basic");
  radio6 = gtk_radio_button_new_with_label (gtk_radio_button_group
					    (GTK_RADIO_BUTTON (radio5)),
					    "Strict");
  radio7 = gtk_radio_button_new_with_label (gtk_radio_button_group
					    (GTK_RADIO_BUTTON (radio5)),
					    "Final");
  radio8 = gtk_radio_button_new_with_label (gtk_radio_button_group
					    (GTK_RADIO_BUTTON (radio5)),
					    "Transitional");
  radio9 = gtk_radio_button_new_with_label (gtk_radio_button_group
					    (GTK_RADIO_BUTTON (radio5)),
					    "Draft");
  gtk_widget_set_usize (radio5, 10, 18);
  gtk_widget_set_usize (radio6, 10, 18);
  gtk_widget_set_usize (radio7, 10, 18);
  gtk_widget_set_usize (radio8, 10, 18);
  gtk_widget_set_usize (radio9, 10, 18);
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (radio1), TRUE);
  gtk_widget_set_sensitive (radio7, 0);
  gtk_widget_set_sensitive (radio8, 0);
  gtk_widget_set_sensitive (radio9, 0);
  gtk_box_pack_start (GTK_BOX (box), radio5, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (box), radio6, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (box), radio7, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (box), radio8, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (box), radio9, FALSE, FALSE, 0);
  gtk_widget_show (radio5);
  gtk_widget_show (radio6);
  gtk_widget_show (radio7);
  gtk_widget_show (radio8);
  gtk_widget_show (radio9);

  /* this rates very high on the cheesy scale */
  /* then again, if I don't do it this way the frames look funky */
  dialogtable = gtk_table_new (1, 10, 0);
  gtk_box_pack_start (GTK_BOX (vbox), dialogtable, FALSE, FALSE, 0);
  gtk_widget_show (dialogtable);
  label = gtk_label_new ("Don't use a DTD");
  checkbox1 = gtk_check_button_new ();
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 2, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), checkbox1, 2, 3, 0, 1);
  gtk_widget_show (label);
  gtk_widget_show (checkbox1);
  /* filler */
  label = gtk_label_new ("");
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 3, 10, 0, 1);
  gtk_widget_show (label);

  create_buttons ();
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked", GTK_SIGNAL_FUNC
		      (dtd_select_ok), NULL);
}

void
set_type_sensitive1 (GtkWidget * widget, gpointer data)
{
  gtk_widget_set_sensitive (radio6, 1);
  gtk_widget_set_sensitive (radio7, 0);
  gtk_widget_set_sensitive (radio8, 0);
  gtk_widget_set_sensitive (radio9, 0);

  if (GTK_TOGGLE_BUTTON (radio7)->active)
    {
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (radio5), TRUE);
    }
  if (GTK_TOGGLE_BUTTON (radio8)->active)
    {
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (radio5), TRUE);
    }
  if (GTK_TOGGLE_BUTTON (radio9)->active)
    {
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (radio5), TRUE);
    }
}

void
set_type_sensitive2 (GtkWidget * widget, gpointer data)
{
  gtk_widget_set_sensitive (radio6, 1);
  gtk_widget_set_sensitive (radio7, 0);
  gtk_widget_set_sensitive (radio8, 0);
  gtk_widget_set_sensitive (radio9, 0);

  if (GTK_TOGGLE_BUTTON (radio7)->active)
    {
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (radio5), TRUE);
    }
  if (GTK_TOGGLE_BUTTON (radio8)->active)
    {
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (radio5), TRUE);
    }
  if (GTK_TOGGLE_BUTTON (radio9)->active)
    {
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (radio5), TRUE);
    }
}

void
set_type_sensitive3 (GtkWidget * widget, gpointer data)
{
  gtk_widget_set_sensitive (radio6, 0);
  gtk_widget_set_sensitive (radio7, 1);
  gtk_widget_set_sensitive (radio8, 0);
  gtk_widget_set_sensitive (radio9, 1);

  if (GTK_TOGGLE_BUTTON (radio6)->active)
    {
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (radio5), TRUE);
    }
  if (GTK_TOGGLE_BUTTON (radio8)->active)
    {
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (radio5), TRUE);
    }
}

void
set_type_sensitive4 (GtkWidget * widget, gpointer data)
{
  gtk_widget_set_sensitive (radio6, 0);
  gtk_widget_set_sensitive (radio7, 0);
  gtk_widget_set_sensitive (radio8, 1);
  gtk_widget_set_sensitive (radio9, 0);

  if (GTK_TOGGLE_BUTTON (radio6)->active)
    {
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (radio5), TRUE);
    }
  if (GTK_TOGGLE_BUTTON (radio7)->active)
    {
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (radio5), TRUE);
    }
  if (GTK_TOGGLE_BUTTON (radio9)->active)
    {
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (radio5), TRUE);
    }
}

void
dtd_select_ok (GtkWidget * widget, gpointer data)
{
  stuff = g_malloc0 (4096);	/* 4k */
#ifdef DEBUG
  g_print ("dtd_select_ok, started\n");
#endif
  if (!GTK_TOGGLE_BUTTON (checkbox1)->active)
    {
      if (GTK_TOGGLE_BUTTON (radio1)->active)
	{
	  if (GTK_TOGGLE_BUTTON (radio5)->active)
	    {
	      strcpy (stuff,
		      "<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML Level 2//EN//2.0\">\n");
	    }
	  else if (GTK_TOGGLE_BUTTON (radio6)->active)
	    {
	      strcpy (stuff,
		      "<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML Strict Level 2//EN\">\n");
	    }
	}
      else if (GTK_TOGGLE_BUTTON (radio2)->active)
	{
	  if (GTK_TOGGLE_BUTTON (radio5)->active)
	    {
	      strcpy (stuff,
		      "<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML Level 3//EN//3.0\">\n");
	    }
	  else if (GTK_TOGGLE_BUTTON (radio6)->active)
	    {
	      strcpy (stuff,
		      "<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML Strict Level 3//EN\">\n");
	    }
	}
      else if (GTK_TOGGLE_BUTTON (radio3)->active)
	{
	  if (GTK_TOGGLE_BUTTON (radio5)->active)
	    {
	      strcpy (stuff,
		      "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">\n");
	    }
	  else if (GTK_TOGGLE_BUTTON (radio7)->active)
	    {
	      strcpy (stuff,
		      "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\">\n");
	    }
	  else if (GTK_TOGGLE_BUTTON (radio9)->active)
	    {
	      strcpy (stuff,
		      "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Draft//EN\">\n");
	    }
	}
      else if (GTK_TOGGLE_BUTTON (radio4)->active)
	{
	  if (GTK_TOGGLE_BUTTON (radio5)->active)
	    {
	      strcpy (stuff,
		      "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\">\n");
	    }
	  else if (GTK_TOGGLE_BUTTON (radio8)->active)
	    {
	      strcpy (stuff,
		      "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n");
	    }
	}
    }
  else
    {
      strcpy (stuff, "");
    }
#ifdef DEBUG
  g_print ("dtd_select_ok, about to destroy dialog %p\n", dialog);
#endif
  gtk_widget_destroy (dialog);
  get_title ();
}

void
get_title (void)
{
#ifdef DEBUG
  g_print ("get_title, started\n");
#endif
  create_dialog (450, 80, "Quick Start - Title");
  dialogtable = gtk_table_new (1, 10, 0);
  gtk_container_border_width (GTK_CONTAINER (vbox), 0);
  gtk_box_pack_start (GTK_BOX (vbox), dialogtable, FALSE, FALSE, 0);
  gtk_widget_show (dialogtable);

  label = gtk_label_new ("Title");
  textentry1 = gtk_entry_new_with_max_length (256);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), textentry1, 1, 10,
			     0, 1);
  gtk_widget_show (label);
  gtk_widget_show (textentry1);

  create_buttons ();
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked", GTK_SIGNAL_FUNC
		      (get_title_ok), NULL);
}

void
get_title_ok (GtkWidget * widget, gpointer data)
{
#ifdef DEBUG
  g_print ("get_title_ok, started\n");
#endif
  strncat (stuff, "<html>\n<head>\n\t<title>", 4095);

  if (strlen ((gchar *) gtk_entry_get_text (GTK_ENTRY (textentry1))))
    {
      strncat (stuff, (gchar *)
	       gtk_entry_get_text (GTK_ENTRY (textentry1)), 4095);
    }
  strncat (stuff, "</title>\n</head>\n", 4095);
#ifdef DEBUG
  g_print ("get_title_ok, about to destroy dialog %p\n", dialog);
#endif
  gtk_widget_destroy (dialog);
#ifdef DEBUG
  g_print ("get_title_ok, calling get_body\n");
#endif
  get_body ();
}

void
get_body (void)
{

  GtkWidget *color_but, *file_but;

#ifdef DEBUG
  g_print ("get_body, started\n");
#endif
  create_dialog (500, 190, "Quick Start - Body");
  dialogtable = gtk_table_new (6, 10, 0);
  gtk_box_pack_start (GTK_BOX (vbox), dialogtable, FALSE, FALSE, 0);
  gtk_widget_show (dialogtable);

  label = gtk_label_new ("Background Image");
  textentry1 = gtk_entry_new_with_max_length (256);
  file_but = file_but_new (textentry1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (file_but),
			     9, 10, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), textentry1, 1, 9,
			     0, 1);
  gtk_widget_show (label);
  gtk_widget_show (textentry1);

  label = gtk_label_new ("Background Color");
  combo1 = GTK_COMBO (gtk_combo_new ());
  color_but = color_but_new (combo1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (color_but),
			     9, 10, 1, 2);
  gtk_combo_set_popdown_strings (combo1, colorlist);
  gtk_entry_set_text (GTK_ENTRY (combo1->entry), "");
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (combo1),
			     1, 9, 1, 2);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 1, 2);
  gtk_widget_show (label);
  gtk_widget_show (GTK_WIDGET (combo1));

  label = gtk_label_new ("Text Color");
  combo2 = GTK_COMBO (gtk_combo_new ());
  color_but = color_but_new (combo2);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (color_but),
			     9, 10, 2, 3);
  gtk_combo_set_popdown_strings (combo2, colorlist);
  gtk_entry_set_text (GTK_ENTRY (combo2->entry), "");
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (combo2),
			     1, 9, 2, 3);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 2, 3);
  gtk_widget_show (label);
  gtk_widget_show (GTK_WIDGET (combo2));

  label = gtk_label_new ("Link Color");
  combo3 = GTK_COMBO (gtk_combo_new ());
  color_but = color_but_new (combo3);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (color_but),
			     9, 10, 3, 4);
  gtk_combo_set_popdown_strings (combo3, colorlist);
  gtk_entry_set_text (GTK_ENTRY (combo3->entry), "");
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (combo3),
			     1, 9, 3, 4);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 3, 4);
  gtk_widget_show (label);
  gtk_widget_show (GTK_WIDGET (combo3));

  label = gtk_label_new ("Visited Link Color");
  combo4 = GTK_COMBO (gtk_combo_new ());
  color_but = color_but_new (combo4);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (color_but),
			     9, 10, 4, 5);
  gtk_combo_set_popdown_strings (combo4, colorlist);
  gtk_entry_set_text (GTK_ENTRY (combo4->entry), "");
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (combo4),
			     1, 9, 4, 5);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 4, 5);
  gtk_widget_show (label);
  gtk_widget_show (GTK_WIDGET (combo4));

  label = gtk_label_new ("Active Link Color");
  combo5 = GTK_COMBO (gtk_combo_new ());
  color_but = color_but_new (combo5);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (color_but),
			     9, 10, 5, 6);
  gtk_combo_set_popdown_strings (combo5, colorlist);
  gtk_entry_set_text (GTK_ENTRY (combo5->entry), "");
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (combo5),
			     1, 9, 5, 6);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 5, 6);
  gtk_widget_show (label);
  gtk_widget_show (GTK_WIDGET (combo5));

  create_buttons ();
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked", GTK_SIGNAL_FUNC
		      (get_body_ok), NULL);
#ifdef DEBUG
  g_print ("get_body, finished\n");
#endif
}

void
get_body_ok (GtkWidget * widget, gpointer data)
{
#ifdef DEBUG
  g_print ("get_body_ok, started\n");
#endif
  strncat (stuff, "<body", 4095);

  if (strlen (gtk_entry_get_text (GTK_ENTRY (textentry1))))
    {
      strncat (strncat (strncat (stuff, " background=\"", 4095),
			gtk_entry_get_text (GTK_ENTRY (textentry1)), 4095),
	       "\"", 4095);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (combo1->entry))))
    {
      strncat (strncat (strncat (stuff, " bgcolor=\"", 4095), converttohex
			(gtk_entry_get_text (GTK_ENTRY (combo1->entry))),
			4095), "\"", 4095);
      add_to_list (colorlist, gtk_entry_get_text (GTK_ENTRY (combo1->entry)));
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (combo2->entry))))
    {
      strncat (strncat (strncat (stuff, " text=\"", 4095), converttohex
			(gtk_entry_get_text (GTK_ENTRY (combo2->entry))),
			4095), "\"", 4095);
      add_to_list (colorlist, gtk_entry_get_text (GTK_ENTRY (combo2->entry)));
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (combo3->entry))))
    {
      strncat (strncat (strncat (stuff, " link=\"", 4095), converttohex
			(gtk_entry_get_text (GTK_ENTRY (combo3->entry))),
			4095), "\"", 4095);
      add_to_list (colorlist, gtk_entry_get_text (GTK_ENTRY (combo3->entry)));
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (combo4->entry))))
    {
      strncat (strncat (strncat (stuff, " vlink=\"", 4095), converttohex
			(gtk_entry_get_text (GTK_ENTRY (combo4->entry))),
			4095), "\"", 4095);
      add_to_list (colorlist, gtk_entry_get_text (GTK_ENTRY (combo4->entry)));
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (combo5->entry))))
    {
      strncat (strncat (strncat (stuff, " alink=\"", 4095), converttohex
			(gtk_entry_get_text (GTK_ENTRY (combo5->entry))),
			4095), "\"", 4095);
      add_to_list (colorlist, gtk_entry_get_text (GTK_ENTRY (combo5->entry)));
    }
#ifdef DEBUG
  g_print ("get_body_ok, about to insert text\n");
#endif
  insert_text (stuff, ">\n\n</body>\n</html>");
  destroy_dialog ();
}

/* Table Wizard */

void
tablewizard (void)
{
  create_dialog (300, 100, "Table Wizard");
  dialogtable = gtk_table_new (2, 10, 1);
  gtk_container_border_width (GTK_CONTAINER (vbox), 0);
  gtk_box_pack_start (GTK_BOX (vbox), dialogtable, FALSE, FALSE, 0);
  gtk_widget_show (dialogtable);

  label = gtk_label_new ("Number of rows");
  adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat) 1, 1, 200.0, 1.0,
					      5.0, 1.0);
  spin1 = gtk_spin_button_new (adj, 1, 0);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin1), 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 7, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), spin1, 7, 10, 0, 1);
  gtk_widget_show (label);
  gtk_widget_show (spin1);

  label = gtk_label_new ("Number of Columns per row");
  adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat) 1, 1, 200.0, 1.0,
					      5.0, 1.0);
  spin2 = gtk_spin_button_new (adj, 1, 0);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin2), 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 7, 1, 2);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), spin2, 7, 10, 1, 2);
  gtk_widget_show (label);
  gtk_widget_show (spin2);

  create_buttons ();
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked", GTK_SIGNAL_FUNC
		      (table_wizard_ok), NULL);
}

void
table_wizard_ok (GtkWidget * widget, gpointer data)
{
  gchar *statusbar;
  used_mem = 16;
  stuff = g_malloc (used_mem);

  /* gtk forces the value of one if nothing is entered */
  rows = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin1));
  columns = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin2));

  strcpy (stuff, "<table>\n");

  for (i = 0; i < rows; i++)
    {
      strncat (stuff, "\t<tr>\n", used_mem - 1);
      used_mem = used_mem + 16;
      stuff = g_realloc (stuff, used_mem);

      /* this can definitely be optimized */
      for (z = 0; z < columns; z++)
	{
	  strncat (stuff, "\t\t<td></td>\n", used_mem - 1);
	  used_mem = used_mem + 16;
	  stuff = g_realloc (stuff, used_mem);
	}

      strncat (stuff, "\t</tr>\n", used_mem - 1);

      statusbar = g_malloc (32);
      sprintf (statusbar, "Generating row number %d of %d", i + 1, rows);
      add_to_statusbar (statusbar);
      g_free (statusbar);
    }

  insert_text (stuff, "</table>");
  destroy_dialog ();
}

/* Frame Wizard - yes I know that this isn't too useful now */
/* I'll fix it eventually */

void
framewizard (void)
{
  GSList *group;

  create_dialog (300, 100, "Frame Wizard");
  dialogtable = gtk_table_new (2, 10, 1);
  gtk_container_border_width (GTK_CONTAINER (vbox), 0);
  gtk_box_pack_start (GTK_BOX (vbox), dialogtable, FALSE, FALSE, 0);
  gtk_widget_show (dialogtable);

  label = gtk_label_new ("Number of Frames");
  adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat) 1, 1, 200.0, 1.0,
					      5.0, 1.0);
  spin1 = gtk_spin_button_new (adj, 1, 0);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin1), 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 7, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), spin1, 7, 10, 0, 1);
  gtk_widget_show (label);
  gtk_widget_show (spin1);

  radio1 = gtk_radio_button_new_with_label (NULL, "Horizontal");
  group = gtk_radio_button_group (GTK_RADIO_BUTTON (radio1));
  radio2 = gtk_radio_button_new_with_label (group, "Vertical");
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (radio1), TRUE);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), radio1, 1, 5, 1, 2);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), radio2, 5, 9, 1, 2);
  gtk_widget_show (radio1);
  gtk_widget_show (radio2);

  create_buttons ();
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked", GTK_SIGNAL_FUNC
		      (frame_wizard_ok), NULL);
}

void
frame_wizard_ok (GtkWidget * widget, gpointer data)
{
  gint i, active;
  gchar *tempstr;

  used_mem = 64;
  stuff = g_malloc (used_mem);
  tempstr = g_malloc (64);

  frames = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin1));

  strcpy (stuff, "<frameset ");

  active = GTK_TOGGLE_BUTTON (radio1)->active;

  if (active)
    {
      strncat (stuff, "cols=\"0\" rows=\"", used_mem - 1);
      sprintf (tempstr, "%d", frames);
      strncat (stuff, tempstr, used_mem - 1);
      strncat (stuff, "\">\n", used_mem - 1);
    }
  else
    {
      strncat (stuff, "cols=\"", used_mem - 1);
      sprintf (tempstr, "%d", frames);
      strncat (stuff, tempstr, used_mem - 1);
      strncat (stuff, "\" rows=\"0\">\n", used_mem - 1);
    }

  g_free (tempstr);

  for (i = 0; i < frames; i++)
    {
      strncat (stuff, "\t<frame>\n", used_mem - 1);
      used_mem = used_mem + 16;
      stuff = g_realloc (stuff, used_mem);
    }

  insert_text (stuff, "</frameset>");
  destroy_dialog ();
}
