/* Bluefish HTML Editor
 * menu.h - uhh, duh.
 *
 * Copyright (C) 1998 Olivier Sessink and Chris Mazuc
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* I wish there was a better way to show he names of the different chars */
/* as in actually show them in parenthesis */
static GtkItemFactoryEntry menu_items[] =
{
    {"/_File", NULL, NULL, 0, "<Branch>"},
    {"/File/tearoff1", NULL, NULL, 0, "<Tearoff>"},
    {"/File/_New", "<control>N", file_new, 0, NULL},
    {"/File/_Open", "<control>O", file_open, 0, NULL},
    {"/File/Open from the web", NULL, open_from_web, 0, NULL},
    {"/File/Insert", NULL, file_insert, 0, NULL},
    {"/File/sep1", NULL, NULL, 0, "<Separator>"},
    {"/File/Weblint", NULL, run_weblint, 0, NULL},
    {"/File/sep2", NULL, NULL, 0, "<Separator>"},
    {"/File/_Save", "<control>S", file_save, 0, NULL},
    {"/File/Save _as", NULL, file_save_as, 0, NULL},
    {"/File/Save all", NULL, file_save_all, 0, NULL},
    {"/File/sep3", NULL, NULL, 0, "<Separator>"},
    {"/File/Close", NULL, file_close, 0, NULL},
    {"/File/Close all", NULL, file_close_all, 0, NULL},
    {"/File/sep4", NULL, NULL, 0, "<Separator>"},
    {"/File/Open project", NULL, project_open, 0, NULL},
    {"/File/Edit project", NULL, project_edit, 0, NULL},
    {"/File/Save project", NULL, project_save, 0, NULL},
    {"/File/Save project as", NULL, project_save_as, 0, NULL},
    {"/File/sep5", NULL, NULL, 0, "<Separator>"},
    {"/File/Quit", "<control>Q", cya_later, 0, NULL},
    {"/_Edit", NULL, NULL, 0, "<Branch>"},
    {"/_Edit/Tearoff1", NULL, NULL, 0, "<Tearoff>"},
    {"/Edit/Cut", "<control>x", cut_callback, 0, NULL},
    {"/Edit/Copy", "<control>c", copy_callback, 0, NULL},
    {"/Edit/Paste", "<control>v", paste_callback, 0, NULL},
    {"/Edit/sep1", NULL, NULL, 0, "<Separator>"},
    {"/Edit/Select all", NULL, sel_all_callback, 0, NULL},
    {"/Edit/sep2", NULL, NULL, 0, "<Separator>"},
    {"/Edit/Find", "F6", search_search_cmd_callback, 0, NULL},
    {"/Edit/Find again", "<shift>F6", search_again_cmd_callback, 0, NULL},
    {"/Edit/Replace", "F7", search_replace_cmd_callback, 0, NULL},
    {"/Edit/sep3", NULL, NULL, 0, "<Separator>"},
    {"/Edit/Undo", "<control>z", undo_cb, 0, NULL},
    {"/Edit/Redo", "<control>r", redo_cb, 0, NULL},
    {"/Edit/Undo all", NULL, undo_all_cb, 0, NULL},
    {"/Edit/Redo all", NULL, redo_all_cb, 0, NULL},
    {"/_View", NULL, NULL, 0, "<Branch>"},
    {"/_View/Tearoff1", NULL, NULL, 0, "<Tearoff>"},
    {"/View/View in _Netscape", NULL, view_in_netscape, 0, NULL},
    {"/View/Main toolbar", NULL, toggle_main_toolbar, 0, "<ToggleItem>"},
    {"/View/HTML toolbar", NULL, toggle_html_toolbar, 0, "<ToggleItem>"},
    {"/View/Custom toolbar", NULL, toggle_cust_menubar, 0, "<ToggleItem>"},
    {"/_Tags", NULL, NULL, 0, "<Branch>"},
    {"/Tags/Tearoff1", NULL, NULL, 0, "<Tearoff>"},
    {"/Tags/Headings", NULL, NULL, 0, "<Branch>"},
    {"/Tags/Headings/Tearoff1", NULL, NULL, 0, "<Tearoff>"},
    {"/Tags/Headings/H1", NULL, general_html, 18, NULL},
    {"/Tags/Headings/H2", NULL, general_html, 19, NULL},
    {"/Tags/Headings/H3", NULL, general_html, 20, NULL},
    {"/Tags/Headings/H4", NULL, general_html, 21, NULL},
    {"/Tags/Headings/H5", NULL, general_html, 22, NULL},
    {"/Tags/Headings/H6", NULL, general_html, 23, NULL},
    {"/Tags/Special", NULL, NULL, 0, "<Branch>"},
    {"/Tags/Special/Accent", NULL, NULL, 0, "<Branch>"},
    {"/Tags/Special/Accent/tearoff1", NULL, NULL, 0, "<Tearoff>"},
    {"/Tags/Special/Accent/Uppercase", NULL, NULL, 0, "<Branch>"},
    {"/Tags/Special/Accent/Uppercase/A-I", NULL, NULL, 0, "<Branch>"},
    {"/Tags/Special/Accent/Uppercase/A-I/tearoff1", NULL, NULL, 0, "<Tearoff>"},
    {"/Tags/Special/Accent/Uppercase/A-I/A grave", NULL, insert_char,
    (int) "&Agrave;", NULL},
    {"/Tags/Special/Accent/Uppercase/A-I/A acute", NULL, insert_char,
     (int) "&Aacute;", NULL},
    {"/Tags/Special/Accent/Uppercase/A-I/A circumflex", NULL,
     insert_char, (int) "&Acirc;", NULL},
    {"/Tags/Special/Accent/Uppercase/A-I/A tilde", NULL, insert_char,
     (int) "&Atilde;", NULL},
    {"/Tags/Special/Accent/Uppercase/A-I/AE ligature", NULL,
     insert_char, (int) "&AElig;", NULL},
    {"/Tags/Special/Accent/Uppercase/A-I/A diaeresis", NULL,
     insert_char, (int) "&Auml;", NULL},
    {"/Tags/Special/Accent/Uppercase/A-I/A ring", NULL, insert_char,
     (int) "&Aring;", NULL},
    {"/Tags/Special/Accent/Uppercase/A-I/C cedilla", NULL, insert_char,
     (int) "&Ccedil;", NULL},
    {"/Tags/Special/Accent/Uppercase/A-I/E grave", NULL, insert_char,
     (int) "&Egrave;", NULL},
    {"/Tags/Special/Accent/Uppercase/A-I/E acute", NULL, insert_char,
     (int) "&Eacute;", NULL},
    {"/Tags/Special/Accent/Uppercase/A-I/E circumflex", NULL,
     insert_char, (int) "&Ecirc;", NULL},
    {"/Tags/Special/Accent/Uppercase/A-I/E diaeresis", NULL,
     insert_char, (int) "&Euml;", NULL},
    {"/Tags/Special/Accent/Uppercase/A-I/I grave", NULL, insert_char,
     (int) "&Igrave;", NULL},
    {"/Tags/Special/Accent/Uppercase/A-I/I acute", NULL, insert_char,
     (int) "&Iacute;", NULL},
    {"/Tags/Special/Accent/Uppercase/A-I/I circumflex", NULL,
     insert_char, (int) "&Icirc;", NULL},
    {"/Tags/Special/Accent/Uppercase/A-I/I diaeresis", NULL,
     insert_char, (int) "&Iuml;", NULL},
    {"/Tags/Special/Accent/Uppercase/J-Z", NULL, NULL, 0, "<Branch>"},
    {"/Tags/Special/Accent/Uppercase/J-Z/tearoff1", NULL, NULL, 0, "<Tearoff>"},
    {"/Tags/Special/Accent/Uppercase/J-Z/N tilde", NULL, insert_char,
     (int) "&Ntilde;", NULL},
    {"/Tags/Special/Accent/Uppercase/J-Z/O grave", NULL, insert_char,
     (int) "&Ograve;", NULL},
    {"/Tags/Special/Accent/Uppercase/J-Z/O acute", NULL, insert_char,
     (int) "&Oacute;", NULL},
    {"/Tags/Special/Accent/Uppercase/J-Z/O circumflex", NULL,
     insert_char, (int) "&Ocirc;", NULL},
    {"/Tags/Special/Accent/Uppercase/J-Z/O tilde", NULL, insert_char,
     (int) "&Otilde;", NULL},
    {"/Tags/Special/Accent/Uppercase/J-Z/O diaeresis", NULL,
     insert_char, (int) "&Ouml;", NULL},
    {"/Tags/Special/Accent/Uppercase/J-Z/O slash", NULL, insert_char,
     (int) "&Oslash;", NULL},
    {"/Tags/Special/Accent/Uppercase/J-Z/U grave", NULL, insert_char,
     (int) "&Ugrave;", NULL},
    {"/Tags/Special/Accent/Uppercase/J-Z/U acute", NULL, insert_char,
     (int) "&Uacute;", NULL},
    {"/Tags/Special/Accent/Uppercase/J-Z/U circumflex", NULL,
     insert_char, (int) "&Ucirc;", NULL},
    {"/Tags/Special/Accent/Uppercase/J-Z/U diaeresis", NULL,
     insert_char, (int) "&Uuml;", NULL},
    {"/Tags/Special/Accent/Uppercase/J-Z/Y acute", NULL, insert_char,
     (int) "&Yacute;", NULL},
    {"/Tags/Special/Accent/Lowercase", NULL, NULL, 0, "<Branch>"},
    {"/Tags/Special/Accent/Lowercase/A-I", NULL, NULL, 0, "<Branch>"},
    {"/Tags/Special/Accent/Lowercase/A-I/tearoff1", NULL, NULL, 0, "<Tearoff>"},
    {"/Tags/Special/Accent/Lowercase/A-I/a grave", NULL, insert_char,
     (int) "&agrave;", NULL},
    {"/Tags/Special/Accent/Lowercase/A-I/a acute", NULL, insert_char,
     (int) "&aacute;", NULL},
    {"/Tags/Special/Accent/Lowercase/A-I/a circumflex", NULL,
     insert_char, (int) "&acirc;", NULL},
    {"/Tags/Special/Accent/Lowercase/A-I/a tilde", NULL, insert_char,
     (int) "&atilde;", NULL},
    {"/Tags/Special/Accent/Lowercase/A-I/a ring", NULL, insert_char,
     (int) "&aring;", NULL},
    {"/Tags/Special/Accent/Lowercase/A-I/ae ligature", NULL,
     insert_char, (int) "&aelig;", NULL},
    {"/Tags/Special/Accent/Lowercase/A-I/a diaeresis", NULL,
     insert_char, (int) "&auml;", NULL},
    {"/Tags/Special/Accent/Lowercase/A-I/c cedilla", NULL, insert_char,
     (int) "&ccedil;", NULL},
    {"/Tags/Special/Accent/Lowercase/A-I/e grave", NULL, insert_char,
     (int) "&egrave;", NULL},
    {"/Tags/Special/Accent/Lowercase/A-I/e acute", NULL, insert_char,
     (int) "&eacute;", NULL},
    {"/Tags/Special/Accent/Lowercase/A-I/e circumflex", NULL,
     insert_char, (int) "&ecirc;", NULL},
    {"/Tags/Special/Accent/Lowercase/A-I/e diaeresis", NULL,
     insert_char, (int) "&euml;", NULL},
    {"/Tags/Special/Accent/Lowercase/A-I/i grave", NULL, insert_char,
     (int) "&igrave;", NULL},
    {"/Tags/Special/Accent/Lowercase/A-I/i acute", NULL, insert_char,
     (int) "&iacute;", NULL},
    {"/Tags/Special/Accent/Lowercase/A-I/i circumflex", NULL,
     insert_char, (int) "&icircumflex;", NULL},
    {"/Tags/Special/Accent/Lowercase/A-I/i diaeresis", NULL,
     insert_char, (int) "&iuml;", NULL},
    {"/Tags/Special/Accent/Lowercase/J-Z", NULL, NULL, 0, "<Branch>"},
    {"/Tags/Special/Accent/Lowercase/J-Z/tearoff1", NULL, NULL, 0, "<Tearoff>"},
    {"/Tags/Special/Accent/Lowercase/J-Z/n tilde", NULL, insert_char,
     (int) "&ntilde;", NULL},
    {"/Tags/Special/Accent/Lowercase/J-Z/o grave", NULL, insert_char,
     (int) "&ograve;", NULL},
    {"/Tags/Special/Accent/Lowercase/J-Z/o acute", NULL, insert_char,
     (int) "&oacute;", NULL},
    {"/Tags/Special/Accent/Lowercase/J-Z/o circumflex", NULL,
     insert_char, (int) "&ocirc;", NULL},
    {"/Tags/Special/Accent/Lowercase/J-Z/o tilde", NULL, insert_char,
     (int) "&otilde;", NULL},
    {"/Tags/Special/Accent/Lowercase/J-Z/o diaeresis", NULL,
     insert_char, (int) "&ouml;", NULL},
    {"/Tags/Special/Accent/Lowercase/J-Z/o slash", NULL, insert_char,
     (int) "&oslash;", NULL},
    {"/Tags/Special/Accent/Lowercase/J-Z/u grave", NULL, insert_char,
     (int) "&ugrave;", NULL},
    {"/Tags/Special/Accent/Lowercase/J-Z/u acute", NULL, insert_char,
     (int) "&uacute;", NULL},
    {"/Tags/Special/Accent/Lowercase/J-Z/u circumflex", NULL,
     insert_char, (int) "&ucirc;", NULL},
    {"/Tags/Special/Accent/Lowercase/J-Z/u diaeresis", NULL,
     insert_char, (int) "&uuml;", NULL},
    {"/Tags/Special/Accent/Lowercase/J-Z/y acute", NULL, insert_char,
     (int) "&yacute;", NULL},
    {"/Tags/Special/Accent/Lowercase/J-Z/y diaeresis", NULL,
     insert_char, (int) "&yuml;", NULL},
    {"/Tags/Special/Accent/separator", NULL, NULL, 0, "<Separator>"},
    {"/Tags/Special/Accent/Umlaut", NULL, insert_char, (int) "&uml;", NULL},
    {"/Tags/Special/Accent/Acute", NULL, insert_char, (int) "&acute;", NULL},
    {"/Tags/Special/Accent/Cedilla", NULL, insert_char, (int) "&cedil;", NULL},
    {"/Tags/Special/Currency", NULL, NULL, 0, "<Branch>"},
    {"/Tags/Special/Currency/tearoff1", NULL, NULL, 0, "<Tearoff>"},
    {"/Tags/Special/Currency/Cent sign", NULL, insert_char,
     (int) "&cent;", NULL},
    {"/Tags/Special/Currency/Pound sterling", NULL, insert_char,
     (int) "&pound;", NULL},
    {"/Tags/Special/Currency/Currency sign", NULL, insert_char,
     (int) "&curren;", NULL},
    {"/Tags/Special/Currency/Yen sign", NULL, insert_char, (int) "&yen;", NULL},
    {"/Tags/Special/Math-Science", NULL, NULL, 0, "<Branch>"},
    {"/Tags/Special/Math-Science/tearoff1", NULL, NULL, 0, "<Tearoff>"},
    {"/Tags/Special/Math-Science/Logical not sign", NULL, insert_char,
     (int) "&not;", NULL},
    {"/Tags/Special/Math-Science/Multiplication sign", NULL,
     insert_char, (int) "&mult;", NULL},
    {"/Tags/Special/Math-Science/Division sign", NULL, insert_char,
     (int) "&divide;", NULL},
    {"/Tags/Special/Math-Science/Plus-minus sign", NULL, insert_char,
     (int) "&plusmn;", NULL},
    {"/Tags/Special/Math-Science/Less-than sign", NULL, insert_char,
     (int) "&lt;", NULL},
    {"/Tags/Special/Math-Science/Greater-than sign", NULL, insert_char,
     (int) "&gt;", NULL},
    {"/Tags/Special/Math-Science/Superscript 1", NULL, insert_char,
     (int) "&sup1;", NULL},
    {"/Tags/Special/Math-Science/Superscript 2", NULL, insert_char,
     (int) "&sup2;", NULL},
    {"/Tags/Special/Math-Science/Superscript 3", NULL, insert_char,
     (int) "&sup3;", NULL},
    {"/Tags/Special/Math-Science/One quarter", NULL, insert_char,
     (int) "&frac14;", NULL},
    {"/Tags/Special/Math-Science/One half", NULL, insert_char,
     (int) "&frac12;", NULL},
    {"/Tags/Special/Math-Science/Three quarters", NULL, insert_char,
     (int) "&frac34;", NULL},
    {"/Tags/Special/Math-Science/Degree sign", NULL, insert_char,
     (int) "&deg;", NULL},
    {"/Tags/Special/Non Latin", NULL, NULL, 0, "<Branch>"},
    {"/Tags/Special/Non Latin/tearoff1", NULL, NULL, 0, "<Tearoff>"},
    {"/Tags/Special/Non Latin/ETH (Icelandic)", NULL, insert_char,
     (int) "&ETH;", NULL},
    {"/Tags/Special/Non Latin/THORN (Icelandic)", NULL, insert_char,
     (int) "&THORN;", NULL},
    {"/Tags/Special/Non Latin/eth (Icelandic)", NULL, insert_char,
     (int) "&eth;", NULL},
    {"/Tags/Special/Non Latin/thorn", NULL, insert_char, (int) "&thorn;", NULL},
    {"/Tags/Special/Non Latin/Sharp s", NULL, insert_char,
     (int) "&szlig;", NULL},
    {"/Tags/Special/Non Latin/Micro sign", NULL, insert_char,
     (int) "&micro;", NULL},
    {"/Tags/Special/Other", NULL, NULL, 0, "<Branch>"},
    {"/Tags/Special/Other/tearoff1", NULL, NULL, 0, "<Tearoff>"},
    {"/Tags/Special/Other/Non-breaking space", NULL, insert_char,
     (int) "&nbsp;", NULL},
    {"/Tags/Special/Other/Section sign", NULL, insert_char,
     (int) "&sect;", NULL},
    {"/Tags/Special/Other/Copyright sign", NULL, insert_char,
     (int) "&copy;", NULL},
    {"/Tags/Special/Other/Left angle quotes", NULL, insert_char,
     (int) "&laquo;", NULL},
    {"/Tags/Special/Other/Right angle quotes", NULL, insert_char,
     (int) "&raquo;", NULL},
    {"/Tags/Special/Other/Registered trademark", NULL, insert_char,
     (int) "&reg;", NULL},
    {"/Tags/Special/Other/Inverted exclamation", NULL, insert_char,
     (int) "&iexcl;", NULL},
    {"/Tags/Special/Other/Inverted question mark", NULL, insert_char,
     (int) "&iquest;", NULL},
    {"/Tags/Special/Other/Feminine ordinal", NULL, insert_char,
     (int) "&ordf;", NULL},
    {"/Tags/Special/Other/Masculine ordinal", NULL, insert_char,
     (int) "&ordm;", NULL},
    {"/Tags/Special/Other/Pilcrow (paragraph sign)", NULL, insert_char,
     (int) "&para;", NULL},
    {"/Tags/Special/Other/Broken bar", NULL, insert_char,
     (int) "&brvbar;", NULL},
    {"/Tags/Special/Other/Soft hypen", NULL, insert_char, (int) "&shy;", NULL},
    {"/Tags/Special/Other/Spacing macron", NULL, insert_char,
     (int) "&macr;", NULL},
    {"/Tags/Special/Other/Middle dot", NULL, insert_char,
     (int) "&middot;", NULL},
    {"/Tags/Formatting", NULL, NULL, 0, "<Branch>"},
    {"/Tags/Formatting/tearoff1", NULL, NULL, 0, "<Tearoff>"},
    {"/Tags/Formatting/Bold", NULL, general_html, 1, NULL},
    {"/Tags/Formatting/Italic", NULL, general_html, 2, NULL},
    {"/Tags/Formatting/Underline", NULL, general_html, 3, NULL},
    {"/Tags/Formatting/Strikeout", NULL, general_html, 4, NULL},
    {"/Tags/Formatting/Strong", NULL, general_html, 16, NULL},
    {"/Tags/Formatting/Emphasis", NULL, general_html, 17, NULL},
    {"/Tags/Formatting/<separator>", NULL, NULL, 0, "<Separator>"},
    {"/Tags/Formatting/Paragraph", NULL, general_html, 5, NULL},
    {"/Tags/Formatting/Break", NULL, general_html, 6, NULL},
    {"/Tags/Formatting/Break clear all", NULL, general_html, 41, NULL},
    {"/Tags/Formatting/Non-Breaking Space", NULL, general_html, 7, NULL},
    {"/Tags/Formatting/<separator>", NULL, NULL, 0, "<Separator>"},
    {"/Tags/Formatting/Font Size +1", NULL, general_html, 11, NULL},
    {"/Tags/Formatting/Font Size -1", NULL, general_html, 12, NULL},
    {"/Tags/Formatting/<separator>", NULL, NULL, 0, "<Separator>"},
    {"/Tags/Formatting/Preformatted Text", NULL, general_html, 13, NULL},
    {"/Tags/Formatting/Subscript", NULL, general_html, 14, NULL},
    {"/Tags/Formatting/Superscript", NULL, general_html, 15, NULL},
    {"/Tags/Formatting/<separator>", NULL, NULL, 0, "<Separator>"},
    {"/Tags/Formatting/Center", NULL, general_html, 8, NULL},
    {"/Tags/Formatting/Align right", NULL, general_html, 9, NULL},
    {"/Tags/Formatting/<separator>", NULL, NULL, 0, "<Separator>"},
    {"/Tags/Formatting/Comment", NULL, general_html, 10, NULL},
    {"/Tags/Table", NULL, NULL, 0, "<Branch>"},
    {"/Tags/Table/tearoff1", NULL, NULL, 0, "<Tearoff>"},
    {"/Tags/Table/Table", NULL, general_html, 24, NULL},
    {"/Tags/Table/Tablerow", NULL, general_html, 25, NULL},
    {"/Tags/Table/Tableheader", NULL, general_html, 26, NULL},
    {"/Tags/Table/Tabledata", NULL, general_html, 27, NULL},
    {"/Tags/Table/Tablecaption", NULL, general_html, 28, NULL},
    {"/Tags/List", NULL, NULL, 0, "<Branch>"},
    {"/Tags/List/tearoff1", NULL, NULL, 0, "<Tearoff>"},
    {"/Tags/List/Unordered list", NULL, general_html, 33, NULL},
    {"/Tags/List/Ordered list", NULL, general_html, 34, NULL},
    {"/Tags/List/List item", NULL, general_html, 35, NULL},
    {"/Tags/List/Definition list", NULL, general_html, 36, NULL},
    {"/Tags/List/Definition term", NULL, general_html, 37, NULL},
    {"/Tags/List/Definition", NULL, general_html, 38, NULL},
    {"/Tags/List/menu", NULL, general_html, 39, NULL},
    {"/_Dialogs", NULL, NULL, 0, "<Branch>"},
    {"/Dialogs/tearoff1", NULL, NULL, 0, "<Tearoff>"},
    {"/Dialogs/General", NULL, NULL, 0, "<Branch>"},
    {"/Dialogs/General/tearoff1", NULL, NULL, 0, "<Tearoff>"},
    {"/Dialogs/General/Quickstart", NULL, quickstart, 0, NULL},
    {"/Dialogs/General/Body", NULL, body, 0, NULL},
    {"/Dialogs/General/Anchor", NULL, quickanchor, 0, NULL},
    {"/Dialogs/General/Email", NULL, email, 0, NULL},
    {"/Dialogs/General/Rule", NULL, quickrule, 0, NULL},
    {"/Dialogs/General/Font", NULL, fontdialog, 0, NULL},
    {"/Dialogs/General/Basefont", NULL, basefont, 0, NULL},
    {"/Dialogs/General/Quicklist", NULL, quicklist, 0, NULL},
    {"/Dialogs/General/Meta", NULL, meta, 0, NULL},
    {"/Dialogs/General/Embed", NULL, embed, 0, NULL},
    {"/Dialogs/General/Select colour", NULL, sel_colour, 0, NULL},
    {"/Dialogs/General/Insert time", NULL, insert_time, 0, NULL},
    {"/Dialogs/General/Insert image", NULL, image_insert_dialog, 0, NULL},
    {"/Dialogs/General/Insert thumbnail", NULL, image_thumbnail_dialog, 0, NULL},
    {"/Dialogs/Table", NULL, NULL, 0, "<Branch>"},
    {"/Dialogs/Table/tearoff1", NULL, NULL, 0, "<Tearoff>"},
    {"/Dialogs/Table/Table", NULL, tabledialog, 0, NULL},
    {"/Dialogs/Table/Tablerow", NULL, tablerowdialog, 0, NULL},
    {"/Dialogs/Table/Tableheader", NULL, tableheaderdialog, 0, NULL},
    {"/Dialogs/Table/Tabledata", NULL, tabledatadialog, 0, NULL},
    {"/Dialogs/Frame", NULL, NULL, 0, "<Branch>"},
    {"/Dialogs/Frame/tearoff1", NULL, NULL, 0, "<Tearoff>"},
    {"/Dialogs/Frame/Frameset", NULL, framesetdialog, 0, NULL},
    {"/Dialogs/Frame/Frame", NULL, framedialog, 0, NULL},
    {"/Dialogs/Form", NULL, NULL, 0, "<Branch>"},
    {"/Dialogs/Form/tearoff1", NULL, NULL, 0, "<Tearoff>"},
    {"/Dialogs/Form/Form", NULL, formdialog, 0, NULL},
    {"/Dialogs/Form/Submit", NULL, submitdialog, 0, NULL},
    {"/Dialogs/Form/Reset", NULL, resetdialog, 0, NULL},
    {"/Dialogs/Form/Text", NULL, textdialog, 0, NULL},
    {"/Dialogs/Form/Hidden", NULL, hiddendialog, 0, NULL},
    {"/Dialogs/Form/Textarea", NULL, textareadialog, 0, NULL},
    {"/Dialogs/Form/Radio buttons", NULL, radiodialog, 0, NULL},
    {"/Dialogs/Form/Check buttons", NULL, checkdialog, 0, NULL},
    {"/Dialogs/Form/Select", NULL, selectdialog, 0, NULL}
};
