/* Bluefish HTML Editor
 * interface.c - this file contains the UI code and some init code
 *
 * Copyright (C) 1998 Olivier Sessink and Chris Mazuc
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <unistd.h>
#include <gtk/gtk.h>
#include <string.h>
#include <stdlib.h>
#include "bluefish.h"
#include "interface.h"
#include "init.h"
#include "undo.h"
/* #include "html.h" */
#include "snr.h"
#include "toolbars.h"
#include "callbacks.h"


#include "pixmaps/bluefish_icon.xpm"
#ifndef NOSPLASH
#include "pixmaps/bluefish.xpm"
#endif

/* ---------------------
 * local declarations
 * --------------------- */
void textbox_key_press (void);
void notebook_changed (void);
void add_to_statusbar (gchar *);

void
add_to_statusbar (gchar * text)
{
  gtk_statusbar_pop (GTK_STATUSBAR (statusbar), gtk_statusbar_get_context_id
		     (GTK_STATUSBAR (statusbar), ""));
  gtk_statusbar_push (GTK_STATUSBAR (statusbar),
		      gtk_statusbar_get_context_id (GTK_STATUSBAR
						    (statusbar), ""), text);
  flush_queue ();
}


void
notebook_changed (void)
{
  gint cur;

  /* This one is called when you click on the notebook
     it _should_ be called also when you use the keys to change the page */

  cur = 1 + (gint) gtk_notebook_current_page (GTK_NOTEBOOK (notebook));
#ifdef DEBUG
  g_print ("notebook_changed, cur=%d\n", cur);
#endif
  current_document = NULL;
  current_document = g_list_nth_data (documentlist, cur);
#ifdef DEBUG
  if (current_document == NULL)
    g_print ("notebook_changed, current_document == NULL\n");
#endif
}


    /*
     * this used to be the callback, but I'll put this in doc_insert_text_cb
     * and doc_delete_text_cb 
     */
/* void textbox_key_press(void)
{
   current_document->modified = 1;
}
*/

/* this function destroys the current_document */
void
destroy_current_document (void)
{
  if (current_document != NULL)
    {
#ifdef DEBUG
      g_print ("destroy_current_window, started\n");
#endif
      gtk_notebook_remove_page (GTK_NOTEBOOK (notebook),
				gtk_notebook_current_page (GTK_NOTEBOOK (notebook)));
#ifdef DEBUG
      g_print ("destroy_current_window, g_list_length(documentlist)=%d\n",
	       g_list_length (documentlist));
#endif
      if (g_list_length (documentlist) > 1)
	{
	  g_list_remove (documentlist, current_document);
	}
      else
	{
	  g_list_remove (documentlist, current_document);
#ifdef DEBUG
	  g_print ("destroy_current_window, removed from documentlist\n");
#endif
	  g_list_free (documentlist);
#ifdef DEBUG
	  g_print ("destroy_current_window, freed documentlist\n");
#endif
	  documentlist = NULL;
#ifdef DEBUG
	  g_print ("destroy_current_window, documentlist = NULL\n");
#endif
	}
#ifdef DEBUG
      g_print ("destroy_current_window, g_list_length(documentlist)=%d\n",
	       g_list_length (documentlist));
#endif
      if (current_document->filename != NULL)
	{
	  g_free (current_document->filename);
	}
      g_free (current_document);
      gtk_notebook_set_page (GTK_NOTEBOOK (notebook), ((gint) g_list_length
						       (documentlist) - 1));
      notebook_changed ();
    }
  else
    {
#ifdef DEBUG
      g_print
	("destroy_current_window, cannot close a NULL current_document\n");
#endif
    }
}

struct thefilestruct *
new_document (void)
{
  GtkWidget *tmptable, *tmpscrollbar;
  filestruct *document;

  /* Here we create a new document, and add it to the GList */
#ifdef DEBUG
  g_print ("new_document, started\n");
#endif
  document = g_malloc0 (sizeof (filestruct));

  tmptable = gtk_table_new (1, 100, FALSE);	/* yes this 100 has a purpose */
  gtk_table_set_row_spacings (GTK_TABLE (tmptable), 0);
  gtk_table_set_col_spacings (GTK_TABLE (tmptable), 0);
  document->textbox = gtk_text_new (NULL, NULL);
  GTK_TEXT (document->textbox)->default_tab_width = 8;
  GTK_TEXT (document->textbox)->tab_stops = g_list_remove (GTK_TEXT
							   (document->textbox)->tab_stops,
							   GTK_TEXT
							   (document->textbox)->tab_stops->data);
  GTK_TEXT (document->textbox)->tab_stops = g_list_remove (GTK_TEXT
							   (document->textbox)->tab_stops,
							   GTK_TEXT
							   (document->textbox)->tab_stops->data);
  GTK_TEXT (document->textbox)->tab_stops = NULL;
  GTK_TEXT (document->textbox)->tab_stops = g_list_prepend (GTK_TEXT
							    (document->textbox)->tab_stops,
							    (void *) 8);
  GTK_TEXT (document->textbox)->tab_stops = g_list_prepend (GTK_TEXT
							    (document->textbox)->tab_stops,
							    (void *) 8);
  gtk_text_set_editable (GTK_TEXT (document->textbox), TRUE);
  gtk_text_set_word_wrap (GTK_TEXT (document->textbox), FALSE);
  gtk_widget_show (document->textbox);
  tmpscrollbar = gtk_vscrollbar_new (GTK_TEXT (document->textbox)->vadj);
  gtk_table_attach_defaults (GTK_TABLE (tmptable), document->textbox, 0, 99,
			     0, 1);
  gtk_table_attach_defaults (GTK_TABLE (tmptable), tmpscrollbar, 99, 100,
			     0, 1);
  gtk_widget_show (tmpscrollbar);
  document->tab_label = gtk_label_new ("Untitled");
  GTK_WIDGET_UNSET_FLAGS (document->tab_label, GTK_CAN_FOCUS);

  /* I did the table like this because it is more flexable than */
  /* a hard coded limit with gtk_widget_set_usize(), and I plan */
  /* on making the window size configurable someday */
#ifdef DEBUG
  g_print ("new_document, before notebook_append_page\n");
#endif
  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), tmptable, document->tab_label);
  gtk_widget_show (tmptable);
  gtk_widget_realize (document->textbox);
  GTK_WIDGET_UNSET_FLAGS (tmpscrollbar, GTK_CAN_FOCUS);
  document->modified = FALSE;
  document->filename = NULL;
  documentlist = g_list_append (documentlist, document);
  gtk_widget_grab_focus (document->textbox);

  /*
   * this used to be the signal, but I'll put this in doc_insert_text_cb
   * and doc_delete_text_cb 
   */
  /* gtk_signal_connect(GTK_OBJECT(document->textbox), "key_press_event",
     textbox_key_press, NULL);   */
  /* this part is copied from gnotepad code 
     Copyright (C) 1998 Andy C. Kahn <kahn@zk3.dec.com> */
  document->ins_txt_id = gtk_signal_connect (GTK_OBJECT (document->textbox),
					     "insert_text", GTK_SIGNAL_FUNC
					     (doc_insert_text_cb), document);
  document->del_txt_id = gtk_signal_connect (GTK_OBJECT (document->textbox),
					     "delete_text", GTK_SIGNAL_FUNC
					     (doc_delete_text_cb), document);

  /* set this new document as active notebook page */
  flush_queue ();
#ifdef DEBUG
  g_print ("new_document, before notebook_set_page, after flush_queue\n");
#endif
  gtk_notebook_set_page (GTK_NOTEBOOK (notebook), g_list_length
			 (documentlist) - 2);
  notebook_changed ();
#ifdef DEBUG
  g_print ("new_document, ended\n");
#endif

  return document;
}


void
make_main_window (void)
{

  /* main window */
#ifdef DEBUG
  g_print ("make_main_window, started\n");
#endif
  flush_queue ();
  main_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);

  gtk_signal_connect (GTK_OBJECT (main_window), "delete_event",
		      GTK_SIGNAL_FUNC (cya_later), NULL);
  gtk_signal_connect (GTK_OBJECT (main_window), "destroy", GTK_SIGNAL_FUNC
		      (cya_later), NULL);
  gtk_widget_set_usize (GTK_WIDGET (main_window), 650, 450);
  gtk_window_set_title (GTK_WINDOW (main_window), CURRENT_VERSION_NAME);

  gtk_window_position (GTK_WINDOW (main_window), GTK_WIN_POS_CENTER);
  gtk_window_set_wmclass (GTK_WINDOW (main_window), "Bluefish", "bluefish");
  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (main_window), vbox);
  gtk_widget_show (vbox);

  /* menu bar */
  get_main_menu (main_window, &menubar);
  gtk_box_pack_start (GTK_BOX (vbox), menubar, FALSE, TRUE, 0);
  gtk_widget_show (menubar);

  /* the pixmaps can't be created without a realise on the window, the
     error Gdk-WARNING **: Creating pixmap from xpm with NULL window and 
     colormap is removed by adding this line */
  gtk_widget_realize (main_window);

  /* pack the main toolbar handle box on the right place */
  handle_box = gtk_handle_box_new ();
  gtk_box_pack_start (GTK_BOX (vbox), handle_box, FALSE, FALSE, 0);
  if (v_main_tb)
    show_main_toolbar (NULL, NULL);

  /* pack the HTML toolbar handle box on the right place */
  html_handle_box = gtk_handle_box_new ();
  gtk_box_pack_start (GTK_BOX (vbox), GTK_WIDGET (html_handle_box), FALSE,
		      FALSE, 0);
  if (v_html_tb)
    show_html_toolbar (NULL, NULL);

  /* pack the custom toolbar handle box on the right place */
  cust_handle_box = gtk_handle_box_new ();
  gtk_box_pack_start (GTK_BOX (vbox), cust_handle_box, FALSE, FALSE, 0);
  if (v_custom_tb)
    show_cust_menubar (NULL, NULL);

  /* notebook with the text widget in there */
  notebook = gtk_notebook_new ();
  gtk_notebook_set_tab_pos (GTK_NOTEBOOK (notebook), GTK_POS_BOTTOM);
  gtk_notebook_set_show_tabs (GTK_NOTEBOOK (notebook), TRUE);
  gtk_notebook_set_show_border (GTK_NOTEBOOK (notebook), TRUE);

  /* We have to know when the notebook changes */
    gtk_signal_connect(GTK_OBJECT(notebook), "button_release_event",
		       notebook_changed, NULL);
    gtk_signal_connect_after(GTK_OBJECT(notebook), "key_press_event",
			     notebook_changed, NULL);
/*  gtk_signal_connect_after (GTK_OBJECT (notebook), "switch_page",
			    notebook_changed, NULL); */
  gtk_notebook_set_page (GTK_NOTEBOOK (notebook), 0);
  gtk_box_pack_start (GTK_BOX (vbox), notebook, TRUE, TRUE, 0);
  gtk_notebook_set_scrollable (GTK_NOTEBOOK (notebook), TRUE);
  gtk_widget_show (notebook);

  /* status bar */
  statusbar = gtk_statusbar_new ();
  gtk_box_pack_start (GTK_BOX (vbox), statusbar, FALSE, TRUE, 0);
  gtk_widget_show (statusbar);


#ifdef DEBUG
  g_print ("make_main_window, end\n");
#endif
}

void
startup (void)
{
  GdkPixmap *icon = NULL;
  GtkWidget *vbox, *splash_window;
  GtkWidget *wpixmap;
  GdkPixmap *pixm;

  /* splash screen */
#ifndef NOSPLASH
  splash_window = gtk_window_new (GTK_WINDOW_DIALOG);
/*    gtk_widget_set_usize(GTK_WIDGET(splash_window), 394, 162); */
  gtk_window_set_title (GTK_WINDOW (splash_window), CURRENT_VERSION_NAME);
  gtk_window_position (GTK_WINDOW (splash_window), GTK_WIN_POS_CENTER);
  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (splash_window), vbox);
  gtk_widget_show (vbox);
  gtk_widget_realize (splash_window);
  pixm = gdk_pixmap_create_from_xpm_d (splash_window->window, NULL, NULL, bluefish_xpm);
  wpixmap = gtk_pixmap_new (pixm, NULL);
  gdk_pixmap_unref (pixm);
  gtk_box_pack_start (GTK_BOX (vbox), wpixmap, FALSE, FALSE, 0);
  gtk_widget_show (wpixmap);
  gtk_widget_realize (wpixmap);
  gtk_widget_show (splash_window);
  flush_queue ();
#endif
  check_directories ();
  parse_config_files ();
  documentlist = g_list_alloc ();
  snr_init ();
  make_main_window ();
  gtk_widget_realize (main_window);
  flush_queue();
#ifdef DEBUG
  g_print ("startup, main_window is ready\n");
#endif
  /* add icon to the window when in minimized state */
  icon = gdk_pixmap_create_from_xpm_d (main_window->window, NULL,
				       NULL, (gchar **) bluefish_icon_xpm);
  gdk_window_set_icon (main_window->window, NULL, icon, NULL);
  gdk_window_set_icon_name (main_window->window, CURRENT_VERSION_NAME);
#ifdef DEBUG
  g_print ("startup, icon is there\n");
#endif
#ifndef NOSPLASH
  /* kill the splash window when the main window is going up */
  flush_queue();
  sleep (1);
  gtk_signal_handlers_destroy (GTK_OBJECT (splash_window));
  gtk_widget_destroy (GTK_WIDGET (splash_window));  
#endif
  gtk_widget_show (main_window);
  
  /* you get an error if you start adding documents when the main window 
  is not yet visible */
  current_project.filename = g_malloc (1024);
  strncat (strcpy (current_project.filename, getenv ("HOME")),
	   "/.bluefish/projects/default", 1023);
  project_from_file ();
#ifdef DEBUG
  g_print ("startup, project from file finished\n");
#endif
  if (g_list_length (documentlist) <= 1)
    {
      current_document = new_document ();
      gtk_label_set (GTK_LABEL (current_document->tab_label), "Untitled");
    }
  gtk_window_set_policy( GTK_WINDOW(main_window), TRUE, TRUE, FALSE );
}
