
/* Bluefish HTML Editor
 * html.c - menu/toolbar callbacks, inserting functions, and other cool stuff 
 *
 * Copyright (C) 1998 Olivier Sessink and Chris Mazuc
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <string.h>
#include <time.h>
#include "bluefish.h"
#include "widgets.h"
#include "html.h"
#include "init.h"
#include "coloursel.h"
#include "toolbars.h"
#include "undo.h"
#include "interface.h"

/* time insert struct */
typedef struct TimeInsertstruct {
   GtkWidget *check[6];
   GtkWidget *label[6];
   GtkWidget *dialog;
} TimeInsert;

/* dialog callbacks */
gchar *extract_time_string (char *original_string);
void insert_time_callback (GtkWidget * widget, struct TimeInsertstruct *timeinsert);
void insert_time_cancel(GtkWidget * widget, struct TimeInsertstruct *data);

void bodyok (void);
void quickanchorok (void);
void quickruleok (void);
void emailok (void);
void fontok (void);
void basefontok (void);
void framesetdialogok (void);
void framedialogok (void);
void tabledialogok (void);
void tablerowdialogok (void);
void tableheaderdialogok (void);
void tabledatadialogok (void);
void formok (void);
void submitok (void);
void resetok (void);
void textok (void);
void hiddenok (void);
void textareaok (void);
void selectok (void);
void radiook (void);
void checkok (void);
void quicklistok (void);
void metaok (void);
void embedok (void);

/* other misc functions used throughout the dialogs */
void create_buttons (void);
void create_dialog (int, int, gchar *);
void destroy_dialog (void);

gchar *converttohex (gchar *);

/* color select button function */
void color_but_clicked (GtkWidget * widget, GtkWidget * combo);

/* file select button function */
void file_but_clicked (GtkWidget * widget, GtkWidget * which_entry);
void modal_fs_ok_clicked (GtkWidget * widget, gpointer window);
void close_modal_window (GtkWidget * widget, gpointer window);

/* used by a lot of the callbacks */
gchar *stuff;

/* just for the modal file selection, a glocal gchar pointer */
gchar *filename_to_return;

/* stuff in html.h - used by the menus and toolbars */

void
general_html (GtkWidget * widget, gpointer data)
{
  switch ((int) data)
    {
    case 1:
      insert_text ("<b>", "</b>");
      break;
    case 2:
      insert_text ("<i>", "</i>");
      break;
    case 3:
      insert_text ("<u>", "</u>");
      break;
    case 4:
      insert_text ("<s>", "</s>");
      break;
    case 5:
      insert_text ("<p>", "");
      break;
    case 6:
      insert_text ("<br>", "");
      break;
    case 7:
      insert_text ("&nbsp", "");
      break;
    case 8:
      insert_text ("<center>", "</center>");
      break;
    case 9:
      insert_text ("<p align=\"right\">", "</p>");
      break;
    case 10:
      insert_text ("<!--", "-->");
      break;
    case 11:
      insert_text ("<font size=\"+1\">", "</font>");
      break;
    case 12:
      insert_text ("<font size=\"-1\">", "</font>");
      break;
    case 13:
      insert_text ("<pre>", "</pre>");
      break;
    case 14:
      insert_text ("<sub>", "</sub>");
      break;
    case 15:
      insert_text ("<sup>", "</sup>");
      break;
    case 16:
      insert_text ("<strong>", "</strong>");
      break;
    case 17:
      insert_text ("<em>", "</em>");
      break;
    case 18:
      insert_text ("<h1>", "</h1>");
      break;
    case 19:
      insert_text ("<h2>", "</h2>");
      break;
    case 20:
      insert_text ("<h3>", "</h3>");
      break;
    case 21:
      insert_text ("<h4>", "</h4>");
      break;
    case 22:
      insert_text ("<h5>", "</h5>");
      break;
    case 23:
      insert_text ("<h6>", "</h6>");
      break;
    case 24:
      insert_text ("<table>", "</table>");
      break;
    case 25:
      insert_text ("<tr>", "</tr>");
      break;
    case 26:
      insert_text ("<th>", "</th>");
      break;
    case 27:
      insert_text ("<td>", "</td>");
      break;
    case 28:
      insert_text ("<caption>", "</caption>");
      break;
    case 29:
      insert_text ("<frameset>", "</frameset>");
      break;
    case 30:
      insert_text ("<frame>", "");
      break;
    case 31:
      insert_text ("<noframes>", "</noframes>");
      break;
    case 32:
      insert_text ("<base target=\"", "\">");
      break;
    case 33:
      insert_text ("<ul>", "</ul>");
      break;
    case 34:
      insert_text ("<ol>", "</ol>");
      break;
    case 35:
      insert_text ("<li>", "");
      break;
    case 36:
      insert_text ("<dl>\n\t<dt><dd>\n</dl>", "\n");
      break;
    case 37:
      insert_text ("<dt>", "");
      break;
    case 38:
      insert_text ("<dd>", "");
      break;
    case 39:
      insert_text ("<menu>", "</menu>");
      break;
    case 40:
      insert_text ("<map name=\"",
		   "\">\n\t<area shape=\"\" coords=\"\" href=\"\">\n</map>\n");
      break;
    case 41:
      insert_text ("<br clear=all>", "");
      break;
    default:
      break;
    }
}


void
body (GtkWidget * widget, gpointer data)
{
  GtkWidget *color_but, *file_but;

  create_dialog (500, 190, "Body");
  dialogtable = gtk_table_new (6, 10, 0);
  gtk_box_pack_start (GTK_BOX (vbox), dialogtable, FALSE, FALSE, 0);
  gtk_widget_show (dialogtable);

  label = gtk_label_new ("Background Image");
  textentry1 = gtk_entry_new_with_max_length (256);
  file_but = file_but_new (textentry1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (file_but),
			     9, 10, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), textentry1, 1, 9,
			     0, 1);
  gtk_widget_show (label);
  gtk_widget_show (textentry1);

  label = gtk_label_new ("Background Color");
  combo1 = GTK_COMBO (gtk_combo_new ());
  color_but = color_but_new (combo1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (color_but),
			     9, 10, 1, 2);
  gtk_combo_set_popdown_strings (combo1, colorlist);
  gtk_entry_set_text (GTK_ENTRY (combo1->entry), "");
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (combo1),
			     1, 9, 1, 2);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 1, 2);
  gtk_widget_show (label);
  gtk_widget_show (GTK_WIDGET (combo1));

  label = gtk_label_new ("Text Color");
  combo2 = GTK_COMBO (gtk_combo_new ());
  color_but = color_but_new (combo2);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (color_but),
			     9, 10, 2, 3);
  gtk_combo_set_popdown_strings (combo2, colorlist);
  gtk_entry_set_text (GTK_ENTRY (combo2->entry), "");
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (combo2),
			     1, 9, 2, 3);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 2, 3);
  gtk_widget_show (label);
  gtk_widget_show (GTK_WIDGET (combo2));

  label = gtk_label_new ("Link Color");
  combo3 = GTK_COMBO (gtk_combo_new ());
  color_but = color_but_new (combo3);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (color_but),
			     9, 10, 3, 4);
  gtk_combo_set_popdown_strings (combo3, colorlist);
  gtk_entry_set_text (GTK_ENTRY (combo3->entry), "");
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (combo3),
			     1, 9, 3, 4);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 3, 4);
  gtk_widget_show (label);
  gtk_widget_show (GTK_WIDGET (combo3));

  label = gtk_label_new ("Visited Link Color");
  combo4 = GTK_COMBO (gtk_combo_new ());
  color_but = color_but_new (combo4);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (color_but),
			     9, 10, 4, 5);
  gtk_combo_set_popdown_strings (combo4, colorlist);
  gtk_entry_set_text (GTK_ENTRY (combo4->entry), "");
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (combo4),
			     1, 9, 4, 5);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 4, 5);
  gtk_widget_show (label);
  gtk_widget_show (GTK_WIDGET (combo4));

  label = gtk_label_new ("Active Link Color");
  combo5 = GTK_COMBO (gtk_combo_new ());
  color_but = color_but_new (combo5);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (color_but),
			     9, 10, 5, 6);
  gtk_combo_set_popdown_strings (combo5, colorlist);
  gtk_entry_set_text (GTK_ENTRY (combo5->entry), "");
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (combo5),
			     1, 9, 5, 6);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 5, 6);
  gtk_widget_show (label);
  gtk_widget_show (GTK_WIDGET (combo5));

  create_buttons ();
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked", GTK_SIGNAL_FUNC
		      (bodyok), NULL);
}


void
quickanchor (GtkWidget * widget, gpointer data)
{
  GtkWidget *file_but;

  create_dialog (520, 145, "Quick Anchor");
  dialogtable = gtk_table_new (4, 10, 0);
  gtk_box_pack_start (GTK_BOX (vbox), dialogtable, FALSE, FALSE, 0);
  gtk_widget_show (dialogtable);

  label = gtk_label_new ("HREF");
  combo2 = GTK_COMBO (gtk_combo_new ());
  file_but = file_but_new (GTK_WIDGET (GTK_COMBO (combo2)->entry));
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (file_but),
			     9, 10, 0, 1);
  gtk_combo_set_popdown_strings (combo2, urllist);
  gtk_entry_set_text (GTK_ENTRY (combo2->entry), "");
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (combo2),
			     1, 9,
			     0, 1);
  gtk_widget_show (label);
  gtk_widget_show (GTK_WIDGET (combo2));

  label = gtk_label_new ("Target");
  combo1 = GTK_COMBO (gtk_combo_new ());
  gtk_combo_set_popdown_strings (combo1, targetlist);
  gtk_entry_set_text (GTK_ENTRY (combo1->entry), "");
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 1, 2);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (combo1),
			     1, 10, 1, 2);
  gtk_widget_show (label);
  gtk_widget_show (GTK_WIDGET (combo1));

  label = gtk_label_new ("Name");
  textentry2 = gtk_entry_new_with_max_length (256);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 2, 3);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), textentry2, 1, 10,
			     2, 3);
  gtk_widget_show (label);
  gtk_widget_show (textentry2);

  label = gtk_label_new ("Description");
  textentry3 = gtk_entry_new_with_max_length (256);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 3, 4);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), textentry3, 1, 10,
			     3, 4);
  gtk_widget_show (label);
  gtk_widget_show (textentry3);

  create_buttons ();
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked", GTK_SIGNAL_FUNC
		      (quickanchorok), NULL);
}

void
quickrule (GtkWidget * widget, gpointer data)
{
  GList *popdownlist = NULL;

  create_dialog (520, 152, "Horizontal Rule");
  dialogtable = gtk_table_new (5, 10, 0);
  gtk_box_pack_start (GTK_BOX (vbox), dialogtable, FALSE, FALSE, 0);
  gtk_widget_show (dialogtable);

  label = gtk_label_new ("Align");
  combo1 = GTK_COMBO (gtk_combo_new ());
  popdownlist = g_list_insert (popdownlist, "center", 0);
  popdownlist = g_list_insert (popdownlist, "left", 1);
  popdownlist = g_list_insert (popdownlist, "right", 2);
  gtk_entry_set_text (GTK_ENTRY (combo1->entry), "");
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (combo1),
			     1, 10, 0, 1);
  gtk_combo_set_popdown_strings (combo1, popdownlist);
  g_list_free(popdownlist);
  gtk_widget_show (label);
  gtk_widget_show (GTK_WIDGET (combo1));

  label = gtk_label_new ("Size");
  adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat) 1, 0.0, 200.0, 1.0,
					      5.0, 0.0);
  spin1 = gtk_spin_button_new (adj, 1, 0);
  gtk_entry_set_text (GTK_ENTRY (spin1), "");
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin1), 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), spin1, 1, 2, 1, 2);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 1, 2);
  gtk_widget_show (label);
  gtk_widget_show (spin1);

  label = gtk_label_new ("Width");
  adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat) 50, 0.0, 600.0, 1.0,
					      5.0, 0.0);
  spin2 = gtk_spin_button_new (adj, 1, 0);
  gtk_entry_set_text (GTK_ENTRY (spin2), "");
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin2), 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), spin2, 1, 2, 2, 3);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 2, 3);
  gtk_widget_show (label);
  gtk_widget_show (spin2);

  label = gtk_label_new ("Is percent?");
  checkbox1 = gtk_check_button_new ();
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), checkbox1, 1, 2, 3, 4);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 3, 4);
  gtk_widget_show (label);
  gtk_widget_show (checkbox1);

  label = gtk_label_new ("No shading");
  checkbox2 = gtk_check_button_new ();
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), checkbox2, 1, 2, 4, 5);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 4, 5);
  gtk_widget_show (label);
  gtk_widget_show (checkbox2);

  label = gtk_label_new ("");
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 2, 10, 1, 2);
  gtk_widget_show (label);

  create_buttons ();
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked", GTK_SIGNAL_FUNC
		      (quickruleok), NULL);
}


void
email (GtkWidget * widget, gpointer data)
{
  create_dialog (265, 80, "Email");
  hbox = gtk_hbox_new (FALSE, 5);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  gtk_widget_show (hbox);

  label = gtk_label_new ("Email address:");
  textentry1 = gtk_entry_new_with_max_length (256);
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), textentry1, FALSE, FALSE, 0);
  gtk_widget_show (label);
  gtk_widget_show (textentry1);

  create_buttons ();
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked", GTK_SIGNAL_FUNC
		      (emailok), NULL);
}

void
fontdialog (GtkWidget * widget, gpointer data)
{
  GList *popdownlist = NULL;
  GtkWidget *color_but;

  create_dialog (500, 100, "Font");
  dialogtable = gtk_table_new (2, 10, 1);
  gtk_box_pack_start (GTK_BOX (vbox), dialogtable, FALSE, FALSE, 0);
  gtk_widget_show (dialogtable);

  label = gtk_label_new ("Size");
  combo1 = GTK_COMBO (gtk_combo_new ());
  popdownlist = g_list_insert (popdownlist, "+", 0);
  popdownlist = g_list_insert (popdownlist, "-", 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (combo1),
			     1, 2, 0, 1);
  gtk_combo_set_popdown_strings (combo1, popdownlist);
  g_list_free(popdownlist);
  gtk_entry_set_text (GTK_ENTRY (combo1->entry), "");
  gtk_widget_show (label);
  gtk_widget_show (GTK_WIDGET (combo1));

  adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat) 1, 0.0, 100.0, 1.0,
					      5.0, 0.0);
  spin1 = gtk_spin_button_new (adj, 1, 0);
  gtk_entry_set_text (GTK_ENTRY (spin1), "");
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin1), 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), spin1, 2, 3, 0, 1);
  gtk_widget_show (spin1);

  label = gtk_label_new ("Color");
  combo2 = GTK_COMBO (gtk_combo_new ());
  color_but = color_but_new (combo2);
  gtk_combo_set_popdown_strings (combo2, colorlist);
  gtk_entry_set_text (GTK_ENTRY (combo2->entry), "");
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 6, 7, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (combo2),
			     7, 9, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (color_but),
			     9, 10, 0, 1);
  gtk_widget_show (label);
  gtk_widget_show (GTK_WIDGET (combo2));

  label = gtk_label_new ("Face");
  combo3 = GTK_COMBO (gtk_combo_new ());
  gtk_combo_set_popdown_strings (combo3, fontlist);
  gtk_entry_set_text (GTK_ENTRY (combo3->entry), "");
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 1, 2);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (combo3),
			     1, 10, 1, 2);
  gtk_widget_show (label);
  gtk_widget_show (GTK_WIDGET (combo3));

  create_buttons ();
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked", GTK_SIGNAL_FUNC
		      (fontok), NULL);
}

void
basefont (GtkWidget * widget, gpointer data)
{
  GList *popdownlist = NULL;
  GtkWidget *color_but;

  create_dialog (500, 100, "Base Font");
  dialogtable = gtk_table_new (2, 10, 1);
  gtk_box_pack_start (GTK_BOX (vbox), dialogtable, FALSE, FALSE, 0);
  gtk_widget_show (dialogtable);

  label = gtk_label_new ("Size");
  combo1 = GTK_COMBO (gtk_combo_new ());
  popdownlist = g_list_insert (popdownlist, "+", 0);
  popdownlist = g_list_insert (popdownlist, "-", 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (combo1),
			     1, 2, 0, 1);
  gtk_combo_set_popdown_strings (combo1, popdownlist);
  g_list_free(popdownlist);
  gtk_entry_set_text (GTK_ENTRY (combo1->entry), "");
  gtk_widget_show (label);
  gtk_widget_show (GTK_WIDGET (combo1));

  adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat) 1, 0.0, 100.0, 1.0,
					      5.0, 0.0);
  spin1 = gtk_spin_button_new (adj, 1, 0);
  gtk_entry_set_text (GTK_ENTRY (spin1), "");
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin1), 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), spin1, 2, 3, 0, 1);
  gtk_widget_show (spin1);

  label = gtk_label_new ("Color");
  combo2 = GTK_COMBO (gtk_combo_new ());
  color_but = color_but_new (combo2);
  gtk_combo_set_popdown_strings (combo2, colorlist);
  gtk_entry_set_text (GTK_ENTRY (combo2->entry), "");
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 6, 7, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (combo2),
			     7, 9, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (color_but),
			     9, 10, 0, 1);
  gtk_widget_show (label);
  gtk_widget_show (GTK_WIDGET (combo2));

  label = gtk_label_new ("Face");
  combo3 = GTK_COMBO (gtk_combo_new ());
  gtk_combo_set_popdown_strings (combo3, fontlist);
  gtk_entry_set_text (GTK_ENTRY (combo3->entry), "");
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 1, 2);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (combo3),
			     1, 10, 1, 2);
  gtk_widget_show (label);
  gtk_widget_show (GTK_WIDGET (combo3));

  create_buttons ();
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked", GTK_SIGNAL_FUNC
		      (basefontok), NULL);
}


void
tabledialog (GtkWidget * widget, gpointer data)
{
  GList *alignlist = NULL;
  GtkWidget *color_but;

  create_dialog (500, 125, "Table");
  dialogtable = gtk_table_new (3, 12, 0);
  gtk_box_pack_start (GTK_BOX (vbox), dialogtable, FALSE, FALSE, 0);
  gtk_widget_show (dialogtable);

  label = gtk_label_new ("Cell Padding");
  adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat) 0, 0.0, 100.0, 1.0,
					      5.0, 0.0);
  spin1 = gtk_spin_button_new (adj, 1, 0);
  gtk_entry_set_text (GTK_ENTRY (spin1), "");
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin1), 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), spin1, 1, 4, 0, 1);
  gtk_widget_show (label);
  gtk_widget_show (spin1);

  label = gtk_label_new ("Align");
  combo1 = GTK_COMBO (gtk_combo_new ());
  alignlist = g_list_insert (alignlist, "left", 0);
  alignlist = g_list_insert (alignlist, "right", 1);
  alignlist = g_list_insert (alignlist, "center", 2);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 4, 5, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (combo1),
			     5, 8, 0, 1);
  gtk_combo_set_popdown_strings (combo1, alignlist);
  g_list_free(alignlist);
  gtk_entry_set_text (GTK_ENTRY (combo1->entry), "");
  gtk_widget_show (label);
  gtk_widget_show (GTK_WIDGET (combo1));

  label = gtk_label_new (" Width ");
  adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat) 0, 0.0, 600.0, 1.0,
					      5.0, 0.0);
  spin2 = gtk_spin_button_new (adj, 1, 0);
  gtk_entry_set_text (GTK_ENTRY (spin2), "");
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin2), 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 8, 9, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), spin2, 9, 12, 0, 1);
  gtk_widget_show (label);
  gtk_widget_show (spin2);

  label = gtk_label_new ("Spacing");
  adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat) 0, 0.0, 100.0, 1.0,
					      5.0, 0.0);
  spin3 = gtk_spin_button_new (adj, 1, 0);
  gtk_entry_set_text (GTK_ENTRY (spin3), "");
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin3), 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 1, 2);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), spin3, 1, 4, 1, 2);
  gtk_widget_show (label);
  gtk_widget_show (spin3);

  label = gtk_label_new ("VAlign");
  combo2 = GTK_COMBO (gtk_combo_new ());
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 4, 5, 1, 2);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (combo2),
			     5, 8, 1, 2);
  gtk_combo_set_popdown_strings (combo2, positionlist);
  gtk_entry_set_text (GTK_ENTRY (combo2->entry), "");
  gtk_widget_show (label);
  gtk_widget_show (GTK_WIDGET (combo2));

  label = gtk_label_new (" Border ");
  adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat) 0, 0.0, 100.0, 1.0,
					      5.0, 0.0);
  spin4 = gtk_spin_button_new (adj, 1, 0);
  gtk_entry_set_text (GTK_ENTRY (spin4), "");
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin4), 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 8, 9, 1, 2);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), spin4, 9, 12, 1, 2);
  gtk_widget_show (label);
  gtk_widget_show (spin4);

  label = gtk_label_new ("BG Color");
  combo3 = GTK_COMBO (gtk_combo_new ());
  color_but = color_but_new (combo3);
  gtk_combo_set_popdown_strings (combo3, colorlist);
  gtk_entry_set_text (GTK_ENTRY (combo3->entry), "");
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 2, 3);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (combo3),
			     1, 7, 2, 3);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (color_but),
			     7, 8, 2, 3);
  gtk_widget_show (label);
  gtk_widget_show (GTK_WIDGET (combo3));

  create_buttons ();
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked", GTK_SIGNAL_FUNC
		      (tabledialogok), NULL);
}

void
tablerowdialog (GtkWidget * widget, gpointer data)
{
  GList *alignlist = NULL;
  GtkWidget *color_but;

  create_dialog (300, 123, "Table Row");
  dialogtable = gtk_table_new (3, 10, 0);
  gtk_box_pack_start (GTK_BOX (vbox), dialogtable, FALSE, FALSE, 0);
  gtk_widget_show (dialogtable);

  label = gtk_label_new ("Align");
  combo1 = GTK_COMBO (gtk_combo_new ());
  alignlist = g_list_insert (alignlist, "left", 0);
  alignlist = g_list_insert (alignlist, "right", 1);
  alignlist = g_list_insert (alignlist, "center", 2);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (combo1),
			     1, 10, 0, 1);
  gtk_combo_set_popdown_strings (combo1, alignlist);
  g_list_free(alignlist);
  gtk_entry_set_text (GTK_ENTRY (combo1->entry), "");
  gtk_widget_show (label);
  gtk_widget_show (GTK_WIDGET (combo1));

  label = gtk_label_new ("VAlign");
  combo2 = GTK_COMBO (gtk_combo_new ());
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 1, 2);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (combo2),
			     1, 10, 1, 2);
  gtk_combo_set_popdown_strings (combo2, positionlist);
  gtk_entry_set_text (GTK_ENTRY (combo2->entry), "");
  gtk_widget_show (label);
  gtk_widget_show (GTK_WIDGET (combo2));

  label = gtk_label_new ("BG Color");
  combo3 = GTK_COMBO (gtk_combo_new ());
  color_but = color_but_new (combo3);
  gtk_combo_set_popdown_strings (combo3, colorlist);
  gtk_entry_set_text (GTK_ENTRY (combo3->entry), "");
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 2, 3);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (combo3),
			     1, 9, 2, 3);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (color_but),
			     9, 10, 2, 3);
  gtk_widget_show (label);
  gtk_widget_show (GTK_WIDGET (combo3));

  create_buttons ();
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked", GTK_SIGNAL_FUNC
		      (tablerowdialogok), NULL);
}

void
tableheaderdialog (GtkWidget * widget, gpointer data)
{
  GList *alignlist = NULL;
  GtkWidget *color_but;

  create_dialog (500, 123, "Table Header");
  dialogtable = gtk_table_new (3, 12, 0);
  gtk_box_pack_start (GTK_BOX (vbox), dialogtable, FALSE, FALSE, 0);
  gtk_widget_show (dialogtable);

  label = gtk_label_new ("Width");
  adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat) 0, 0.0, 100.0, 1.0,
					      5.0, 0.0);
  spin1 = gtk_spin_button_new (adj, 1, 0);
  gtk_entry_set_text (GTK_ENTRY (spin1), "");
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin1), 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), spin1, 1, 4, 0, 1);
  gtk_widget_show (label);
  gtk_widget_show (spin1);

  label = gtk_label_new ("Align");
  combo1 = GTK_COMBO (gtk_combo_new ());
  alignlist = g_list_insert (alignlist, "left", 0);
  alignlist = g_list_insert (alignlist, "right", 1);
  alignlist = g_list_insert (alignlist, "center", 2);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 4, 5, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (combo1),
			     5, 8, 0, 1);
  gtk_combo_set_popdown_strings (combo1, alignlist);
  g_list_free(alignlist);
  gtk_entry_set_text (GTK_ENTRY (combo1->entry), "");
  gtk_widget_show (label);
  gtk_widget_show (GTK_WIDGET (combo1));

  label = gtk_label_new ("Col Span");
  adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat) 0, 0.0, 600.0, 1.0,
					      5.0, 0.0);
  spin2 = gtk_spin_button_new (adj, 1, 0);
  gtk_entry_set_text (GTK_ENTRY (spin2), "");
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin2), 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 8, 9, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), spin2, 9, 12, 0, 1);
  gtk_widget_show (label);
  gtk_widget_show (spin2);

  label = gtk_label_new ("Height");
  adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat) 0, 0.0, 100.0, 1.0,
					      5.0, 0.0);
  spin3 = gtk_spin_button_new (adj, 1, 0);
  gtk_entry_set_text (GTK_ENTRY (spin3), "");
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin3), 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 1, 2);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), spin3, 1, 4, 1, 2);
  gtk_widget_show (label);
  gtk_widget_show (spin3);

  label = gtk_label_new ("VAlign");
  combo2 = GTK_COMBO (gtk_combo_new ());
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 4, 5, 1, 2);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (combo2),
			     5, 8, 1, 2);
  gtk_combo_set_popdown_strings (combo2, positionlist);
  gtk_entry_set_text (GTK_ENTRY (combo2->entry), "");
  gtk_widget_show (label);
  gtk_widget_show (GTK_WIDGET (combo2));

  label = gtk_label_new ("Row Span");
  adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat) 0, 0.0, 100.0, 1.0,
					      5.0, 0.0);
  spin4 = gtk_spin_button_new (adj, 1, 0);
  gtk_entry_set_text (GTK_ENTRY (spin4), "");
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin4), 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 8, 9, 1, 2);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), spin4, 9, 12, 1, 2);
  gtk_widget_show (label);
  gtk_widget_show (spin4);

  label = gtk_label_new ("BG Color");
  combo3 = GTK_COMBO (gtk_combo_new ());
  color_but = color_but_new (combo3);
  gtk_combo_set_popdown_strings (combo3, colorlist);
  gtk_entry_set_text (GTK_ENTRY (combo3->entry), "");
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 2, 3);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (combo3),
			     1, 7, 2, 3);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (color_but),
			     7, 8, 2, 3);
  gtk_widget_show (label);
  gtk_widget_show (GTK_WIDGET (combo3));

  label = gtk_label_new ("No Wrap");
  checkbox1 = gtk_check_button_new ();
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 8, 9, 2, 3);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), checkbox1, 9, 10,
			     2, 3);
  gtk_widget_show (label);
  gtk_widget_show (checkbox1);

  create_buttons ();
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked", GTK_SIGNAL_FUNC
		      (tableheaderdialogok), NULL);
}

void
tabledatadialog (GtkWidget * widget, gpointer data)
{
  GList *alignlist = NULL;
  GtkWidget *color_but;

  create_dialog (500, 123, "Table Data");
  dialogtable = gtk_table_new (3, 12, 0);
  gtk_box_pack_start (GTK_BOX (vbox), dialogtable, FALSE, FALSE, 0);
  gtk_widget_show (dialogtable);

  label = gtk_label_new ("Width");
  adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat) 0, 0.0, 100.0, 1.0,
					      5.0, 0.0);
  spin1 = gtk_spin_button_new (adj, 1, 0);
  gtk_entry_set_text (GTK_ENTRY (spin1), "");
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin1), 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), spin1, 1, 4, 0, 1);
  gtk_widget_show (label);
  gtk_widget_show (spin1);

  label = gtk_label_new ("Align");
  combo1 = GTK_COMBO (gtk_combo_new ());
  alignlist = g_list_insert (alignlist, "left", 0);
  alignlist = g_list_insert (alignlist, "right", 1);
  alignlist = g_list_insert (alignlist, "center", 2);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 4, 5, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (combo1),
			     5, 8, 0, 1);
  gtk_combo_set_popdown_strings (combo1, alignlist);
  g_list_free(alignlist);
  gtk_entry_set_text (GTK_ENTRY (combo1->entry), "");
  gtk_widget_show (label);
  gtk_widget_show (GTK_WIDGET (combo1));

  label = gtk_label_new ("Col Span");
  adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat) 0, 0.0, 600.0, 1.0,
					      5.0, 0.0);
  spin2 = gtk_spin_button_new (adj, 1, 0);
  gtk_entry_set_text (GTK_ENTRY (spin2), "");
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin2), 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 8, 9, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), spin2, 9, 12, 0, 1);
  gtk_widget_show (label);
  gtk_widget_show (spin2);

  label = gtk_label_new ("Height");
  adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat) 0, 0.0, 100.0, 1.0,
					      5.0, 0.0);
  spin3 = gtk_spin_button_new (adj, 1, 0);
  gtk_entry_set_text (GTK_ENTRY (spin3), "");
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin3), 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 1, 2);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), spin3, 1, 4, 1, 2);
  gtk_widget_show (label);
  gtk_widget_show (spin3);

  label = gtk_label_new ("VAlign");
  combo2 = GTK_COMBO (gtk_combo_new ());
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 4, 5, 1, 2);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (combo2),
			     5, 8, 1, 2);
  gtk_combo_set_popdown_strings (combo2, positionlist);
  gtk_entry_set_text (GTK_ENTRY (combo2->entry), "");
  gtk_widget_show (label);
  gtk_widget_show (GTK_WIDGET (combo2));

  label = gtk_label_new ("Row Span");
  adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat) 0, 0.0, 100.0, 1.0,
					      5.0, 0.0);
  spin4 = gtk_spin_button_new (adj, 1, 0);
  gtk_entry_set_text (GTK_ENTRY (spin4), "");
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin4), 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 8, 9, 1, 2);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), spin4, 9, 12, 1, 2);
  gtk_widget_show (label);
  gtk_widget_show (spin4);

  label = gtk_label_new ("BG Color");
  combo3 = GTK_COMBO (gtk_combo_new ());
  color_but = color_but_new (combo3);
  gtk_combo_set_popdown_strings (combo3, colorlist);
  gtk_entry_set_text (GTK_ENTRY (combo3->entry), "");
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 2, 3);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (combo3),
			     1, 7, 2, 3);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (color_but),
			     7, 8, 2, 3);
  gtk_widget_show (label);
  gtk_widget_show (GTK_WIDGET (combo3));

  label = gtk_label_new ("No Wrap");
  checkbox1 = gtk_check_button_new ();
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 8, 9, 2, 3);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), checkbox1, 9, 10,
			     2, 3);
  gtk_widget_show (label);
  gtk_widget_show (checkbox1);

  create_buttons ();
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked", GTK_SIGNAL_FUNC
		      (tabledatadialogok), NULL);
}

void
framesetdialog (GtkWidget * widget, gpointer data)
{
  GList *popuplist = NULL;

  create_dialog (500, 147, "Frameset");
  dialogtable = gtk_table_new (4, 10, 1);
  gtk_box_pack_start (GTK_BOX (vbox), dialogtable, FALSE, FALSE, 0);
  gtk_widget_show (dialogtable);

  label = gtk_label_new ("Cols");
  textentry1 = gtk_entry_new_with_max_length (256);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 2, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), textentry1, 2, 10,
			     0, 1);
  gtk_widget_show (label);
  gtk_widget_show (textentry1);

  label = gtk_label_new ("Rows");
  textentry2 = gtk_entry_new_with_max_length (256);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 2, 1, 2);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), textentry2, 2, 10,
			     1, 2);
  gtk_widget_show (label);
  gtk_widget_show (textentry2);

  label = gtk_label_new ("Border");
  combo1 = GTK_COMBO (gtk_combo_new ());
  popuplist = g_list_insert (popuplist, "yes", 1);
  popuplist = g_list_insert (popuplist, "no", 2);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 2, 2, 3);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (combo1),
			     2, 4, 2, 3);
  gtk_combo_set_popdown_strings (combo1, popuplist);
  g_list_free(popuplist);
  gtk_entry_set_text (GTK_ENTRY (combo1->entry), "");
  gtk_widget_show (label);
  gtk_widget_show (GTK_WIDGET (combo1));

  label = gtk_label_new ("Spacing");
  adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat) 1, 0.0, 500.0, 1.0,
					      5.0, 0.0);
  spin1 = gtk_spin_button_new (adj, 1, 0);
  gtk_entry_set_text (GTK_ENTRY (spin1), "");
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin1), 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 2, 3, 4);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), spin1, 2, 4, 3, 4);
  gtk_widget_show (label);
  gtk_widget_show (spin1);

  create_buttons ();
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked", GTK_SIGNAL_FUNC
		      (framesetdialogok), NULL);
}

void
framedialog (GtkWidget * widget, gpointer data)
{
  GList *popuplist = NULL;

  create_dialog (500, 147, "Frame");
  dialogtable = gtk_table_new (4, 12, 0);
  gtk_box_pack_start (GTK_BOX (vbox), dialogtable, FALSE, FALSE, 0);
  gtk_widget_show (dialogtable);

  label = gtk_label_new ("Source");
  textentry1 = gtk_entry_new_with_max_length (256);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), textentry1, 1, 12,
			     0, 1);
  gtk_widget_show (label);
  gtk_widget_show (textentry1);

  label = gtk_label_new ("Name");
  textentry2 = gtk_entry_new_with_max_length (256);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 1, 2);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), textentry2, 1, 12,
			     1, 2);
  gtk_widget_show (label);
  gtk_widget_show (textentry2);

  /* this part is located here because of the list */
  /* I don't want "auto" added to it from the scrolling */
  /* part since they share the list */
  label = gtk_label_new ("Border");
  combo1 = GTK_COMBO (gtk_combo_new ());
  popuplist = g_list_insert (popuplist, "yes", 0);
  popuplist = g_list_insert (popuplist, "no", 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 3, 4);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (combo1),
			     1, 4, 3, 4);
  gtk_combo_set_popdown_strings (combo1, popuplist);
  gtk_entry_set_text (GTK_ENTRY (combo1->entry), "");
  gtk_widget_show (label);
  gtk_widget_show (GTK_WIDGET (combo1));

  label = gtk_label_new ("Scrolling ");
  combo2 = GTK_COMBO (gtk_combo_new ());
  popuplist = g_list_insert (popuplist, "auto", 2);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 2, 3);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (combo2),
			     1, 4, 2, 3);
  gtk_combo_set_popdown_strings (combo2, popuplist);
  g_list_free(popuplist);
  gtk_entry_set_text (GTK_ENTRY (combo2->entry), "");
  gtk_widget_show (label);
  gtk_widget_show (GTK_WIDGET (combo2));

  label = gtk_label_new (" Margin Width ");
  adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat) 1, 0.0, 500.0, 1.0,
					      5.0, 0.0);
  spin1 = gtk_spin_button_new (adj, 1, 0);
  gtk_entry_set_text (GTK_ENTRY (spin1), "");
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin1), 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 4, 5, 2, 3);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), spin1, 5, 8, 2, 3);
  gtk_widget_show (label);
  gtk_widget_show (spin1);

  label = gtk_label_new (" Margin Height ");
  adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat) 1, 0.0, 500.0, 1.0,
					      5.0, 0.0);
  spin2 = gtk_spin_button_new (adj, 1, 0);
  gtk_entry_set_text (GTK_ENTRY (spin2), "");
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin2), 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 8, 9, 2, 3);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), spin2, 9, 12, 2, 3);
  gtk_widget_show (label);
  gtk_widget_show (spin2);

  label = gtk_label_new ("Spacing");
  adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat) 1, 0.0, 500.0, 1.0,
					      5.0, 0.0);
  spin3 = gtk_spin_button_new (adj, 1, 0);
  gtk_entry_set_text (GTK_ENTRY (spin3), "");
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin3), 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 4, 5, 3, 4);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), spin3, 5, 8, 3, 4);
  gtk_widget_show (label);
  gtk_widget_show (spin3);

  label = gtk_label_new ("No Resize");
  checkbox1 = gtk_check_button_new ();
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 8, 9, 3, 4);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), checkbox1, 9, 10,
			     3, 4);
  gtk_widget_show (label);
  gtk_widget_show (checkbox1);

  create_buttons ();
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked", GTK_SIGNAL_FUNC
		      (framedialogok), NULL);
}

void
formdialog (GtkWidget * widget, gpointer data)
{
  GList *methodlist = NULL;
  GList *enctypelist = NULL;

  create_dialog (500, 123, "Form");
  dialogtable = gtk_table_new (3, 10, 1);
  gtk_box_pack_start (GTK_BOX (vbox), dialogtable, FALSE, FALSE, 0);
  gtk_widget_show (dialogtable);

  label = gtk_label_new ("Action");
  textentry1 = gtk_entry_new_with_max_length (256);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), textentry1, 1, 10,
			     0, 1);
  gtk_widget_show (label);
  gtk_widget_show (textentry1);

  label = gtk_label_new ("Method");
  combo1 = GTK_COMBO (gtk_combo_new ());
  methodlist = g_list_insert (methodlist, "get", 0);
  methodlist = g_list_insert (methodlist, "post", 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 1, 2);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (combo1),
			     1, 2, 1, 2);
  gtk_combo_set_popdown_strings (combo1, methodlist);
  g_list_free(methodlist);
  gtk_entry_set_text (GTK_ENTRY (combo1->entry), "");
  gtk_widget_show (label);
  gtk_widget_show (GTK_WIDGET (combo1));

  /* I need to add more types */
  label = gtk_label_new ("Enctype");
  combo2 = GTK_COMBO (gtk_combo_new ());
  enctypelist = g_list_insert (enctypelist,
			       "application/x-www-form-urlencoded", 0);
  enctypelist = g_list_insert (enctypelist, "multipart/form-data", 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 3, 4, 1, 2);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (combo2),
			     4, 10, 1, 2);
  gtk_combo_set_popdown_strings (combo2, enctypelist);
  g_list_free(enctypelist);
  gtk_entry_set_text (GTK_ENTRY (combo2->entry), "");
  gtk_widget_show (label);
  gtk_widget_show (GTK_WIDGET (combo2));

  label = gtk_label_new ("Target");
  combo3 = GTK_COMBO (gtk_combo_new ());
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 2, 3);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (combo3),
			     1, 10, 2, 3);
  gtk_combo_set_popdown_strings (combo3, targetlist);
  gtk_entry_set_text (GTK_ENTRY (combo3->entry), "");
  gtk_widget_show (label);
  gtk_widget_show (GTK_WIDGET (combo3));

  create_buttons ();
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked", GTK_SIGNAL_FUNC
		      (formok), NULL);
}

void
submitdialog (GtkWidget * widget, gpointer data)
{
  create_dialog (300, 100, "Submit");
  dialogtable = gtk_table_new (1, 10, 0);
  gtk_box_pack_start (GTK_BOX (vbox), dialogtable, FALSE, FALSE, 0);
  gtk_widget_show (dialogtable);

  label = gtk_label_new ("Name");
  textentry1 = gtk_entry_new_with_max_length (256);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), textentry1, 1, 10,
			     0, 1);
  gtk_widget_show (label);
  gtk_widget_show (textentry1);

  label = gtk_label_new ("Value");
  textentry2 = gtk_entry_new_with_max_length (256);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 1, 2);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), textentry2, 1, 10,
			     1, 2);
  gtk_widget_show (label);
  gtk_widget_show (textentry2);

  create_buttons ();
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked", GTK_SIGNAL_FUNC
		      (submitok), NULL);
}

void
resetdialog (GtkWidget * widget, gpointer data)
{
  create_dialog (300, 100, "Reset");
  dialogtable = gtk_table_new (1, 10, 0);
  gtk_box_pack_start (GTK_BOX (vbox), dialogtable, FALSE, FALSE, 0);
  gtk_widget_show (dialogtable);

  label = gtk_label_new ("Name");
  textentry1 = gtk_entry_new_with_max_length (256);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), textentry1, 1, 10,
			     0, 1);
  gtk_widget_show (label);
  gtk_widget_show (textentry1);

  label = gtk_label_new ("Value");
  textentry2 = gtk_entry_new_with_max_length (256);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 1, 2);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), textentry2, 1, 10,
			     1, 2);
  gtk_widget_show (label);
  gtk_widget_show (textentry2);

  create_buttons ();
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked", GTK_SIGNAL_FUNC
		      (resetok), NULL);
}

void
textdialog (GtkWidget * widget, gpointer data)
{
  create_dialog (300, 145, "Text");
  dialogtable = gtk_table_new (4, 10, 0);
  gtk_box_pack_start (GTK_BOX (vbox), dialogtable, FALSE, FALSE, 0);
  gtk_widget_show (dialogtable);

  label = gtk_label_new ("Name");
  textentry1 = gtk_entry_new_with_max_length (256);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), textentry1, 1, 10,
			     0, 1);
  gtk_widget_show (label);
  gtk_widget_show (textentry1);

  label = gtk_label_new ("Value");
  textentry2 = gtk_entry_new_with_max_length (256);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 1, 2);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), textentry2, 1, 10,
			     1, 2);
  gtk_widget_show (label);
  gtk_widget_show (textentry2);

  label = gtk_label_new ("Rows");
  adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat) 1, 0.0, 500.0, 1.0,
					      5.0, 0.0);
  spin1 = gtk_spin_button_new (adj, 1, 0);
  gtk_entry_set_text (GTK_ENTRY (spin1), "");
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin1), 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), spin1, 1, 2, 2, 3);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 2, 3);
  gtk_widget_show (label);
  gtk_widget_show (spin1);

  label = gtk_label_new ("Cols");
  adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat) 1, 0.0, 500.0, 1.0,
					      5.0, 0.0);
  spin2 = gtk_spin_button_new (adj, 1, 0);
  gtk_entry_set_text (GTK_ENTRY (spin2), "");
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin2), 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), spin2, 1, 2, 3, 4);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 3, 4);
  gtk_widget_show (label);
  gtk_widget_show (spin2);

  create_buttons ();
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked", GTK_SIGNAL_FUNC
		      (textok), NULL);
}

void
hiddendialog (GtkWidget * widget, gpointer data)
{
  create_dialog (300, 100, "Hidden");
  dialogtable = gtk_table_new (1, 10, 0);
  gtk_box_pack_start (GTK_BOX (vbox), dialogtable, FALSE, FALSE, 0);
  gtk_widget_show (dialogtable);

  label = gtk_label_new ("Name");
  textentry1 = gtk_entry_new_with_max_length (256);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), textentry1, 1, 10,
			     0, 1);
  gtk_widget_show (label);
  gtk_widget_show (textentry1);

  label = gtk_label_new ("Value");
  textentry2 = gtk_entry_new_with_max_length (256);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 1, 2);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), textentry2, 1, 10,
			     1, 2);
  gtk_widget_show (label);
  gtk_widget_show (textentry2);

  create_buttons ();
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked", GTK_SIGNAL_FUNC
		      (hiddenok), NULL);
}

void
textareadialog (GtkWidget * widget, gpointer data)
{
  create_dialog (300, 145, "Text Area");
  dialogtable = gtk_table_new (4, 10, 0);
  gtk_box_pack_start (GTK_BOX (vbox), dialogtable, FALSE, FALSE, 0);
  gtk_widget_show (dialogtable);

  label = gtk_label_new ("Name");
  textentry1 = gtk_entry_new_with_max_length (256);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), textentry1, 1, 10,
			     0, 1);
  gtk_widget_show (label);
  gtk_widget_show (textentry1);

  label = gtk_label_new ("Value");
  textentry2 = gtk_entry_new_with_max_length (256);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 1, 2);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), textentry2, 1, 10,
			     1, 2);
  gtk_widget_show (label);
  gtk_widget_show (textentry2);

  label = gtk_label_new ("Size");
  adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat) 1, 0.0, 500.0, 1.0,
					      5.0, 0.0);
  spin1 = gtk_spin_button_new (adj, 1, 0);
  gtk_entry_set_text (GTK_ENTRY (spin1), "");
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin1), 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), spin1, 1, 2, 2, 3);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 2, 3);
  gtk_widget_show (label);
  gtk_widget_show (spin1);

  label = gtk_label_new ("Max Length");
  adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat) 1, 0.0, 500.0, 1.0,
					      5.0, 0.0);
  spin2 = gtk_spin_button_new (adj, 1, 0);
  gtk_entry_set_text (GTK_ENTRY (spin2), "");
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin2), 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), spin2, 1, 2, 3, 4);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 3, 4);
  gtk_widget_show (label);
  gtk_widget_show (spin2);

  create_buttons ();
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked", GTK_SIGNAL_FUNC
		      (textareaok), NULL);
}

void
radiodialog (GtkWidget * widget, gpointer data)
{
  create_dialog (300, 117, "Radio Button");
  dialogtable = gtk_table_new (3, 10, 0);
  gtk_box_pack_start (GTK_BOX (vbox), dialogtable, FALSE, FALSE, 0);
  gtk_widget_show (dialogtable);

  label = gtk_label_new ("Name");
  textentry1 = gtk_entry_new_with_max_length (256);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), textentry1, 1, 10,
			     0, 1);
  gtk_widget_show (label);
  gtk_widget_show (textentry1);

  label = gtk_label_new ("Value");
  textentry2 = gtk_entry_new_with_max_length (256);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 1, 2);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), textentry2, 1, 10,
			     1, 2);
  gtk_widget_show (label);
  gtk_widget_show (textentry2);

  label = gtk_label_new ("Checked");
  checkbox1 = gtk_check_button_new ();
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), checkbox1, 1, 2, 2, 3);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 2, 3);
  gtk_widget_show (label);
  gtk_widget_show (checkbox1);

  create_buttons ();
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked", GTK_SIGNAL_FUNC
		      (radiook), NULL);
}

void
checkdialog (GtkWidget * widget, gpointer data)
{
  create_dialog (300, 117, "Check Box");
  dialogtable = gtk_table_new (1, 10, 0);
  gtk_box_pack_start (GTK_BOX (vbox), dialogtable, FALSE, FALSE, 0);
  gtk_widget_show (dialogtable);

  label = gtk_label_new ("Name");
  textentry1 = gtk_entry_new_with_max_length (256);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), textentry1, 1, 10,
			     0, 1);
  gtk_widget_show (label);
  gtk_widget_show (textentry1);

  label = gtk_label_new ("Value");
  textentry2 = gtk_entry_new_with_max_length (256);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 1, 2);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), textentry2, 1, 10,
			     1, 2);
  gtk_widget_show (label);
  gtk_widget_show (textentry2);

  label = gtk_label_new ("Checked");
  checkbox1 = gtk_check_button_new ();
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), checkbox1, 1, 2, 2, 3);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 2, 3);
  gtk_widget_show (label);
  gtk_widget_show (checkbox1);

  create_buttons ();
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked", GTK_SIGNAL_FUNC
		      (checkok), NULL);
}

void
selectdialog (GtkWidget * widget, gpointer data)
{
  create_dialog (300, 100, "Select");
  dialogtable = gtk_table_new (1, 10, 0);
  gtk_box_pack_start (GTK_BOX (vbox), dialogtable, FALSE, FALSE, 0);
  gtk_widget_show (dialogtable);

  label = gtk_label_new ("Name");
  textentry1 = gtk_entry_new_with_max_length (256);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), textentry1, 1, 10,
			     0, 1);
  gtk_widget_show (label);
  gtk_widget_show (textentry1);

  label = gtk_label_new ("Rows");
  adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat) 1, 0.0, 100.0, 1.0,
					      5.0, 0.0);
  spin1 = gtk_spin_button_new (adj, 1, 0);
  gtk_entry_set_text (GTK_ENTRY (spin1), "");
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin1), 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), spin1, 1, 2, 1, 2);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 1, 2);
  gtk_widget_show (label);
  gtk_widget_show (spin1);

  create_buttons ();
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked", GTK_SIGNAL_FUNC
		      (selectok), NULL);
}

void
quicklist (GtkWidget * widget, gpointer data)
{
  GSList *group;

  create_dialog (300, 102, "Quick List");
  dialogtable = gtk_table_new (2, 10, 0);
  gtk_box_pack_start (GTK_BOX (vbox), dialogtable, FALSE, FALSE, 0);
  gtk_widget_show (dialogtable);

  label = gtk_label_new ("Rows");
  adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat) 1, 0.0, 100.0, 1.0,
					      5.0, 0.0);
  spin1 = gtk_spin_button_new (adj, 1, 0);
  gtk_entry_set_text (GTK_ENTRY (spin1), "");
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin1), 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), spin1, 1, 2, 0, 1);
  gtk_widget_show (label);
  gtk_widget_show (spin1);
  gtk_widget_show (dialogtable);

  label = gtk_label_new ("Style");
  radio1 = gtk_radio_button_new_with_label (NULL, "Ordered");
  group = gtk_radio_button_group (GTK_RADIO_BUTTON (radio1));
  radio2 = gtk_radio_button_new_with_label (group, "Unordered");
  gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (radio1), TRUE);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 1, 1, 2);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), radio1, 1, 5, 1, 2);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), radio2, 5, 10, 1, 2);
  gtk_widget_show (label);
  gtk_widget_show (radio1);
  gtk_widget_show (radio2);

  create_buttons ();
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked", GTK_SIGNAL_FUNC
		      (quicklistok), NULL);
}



void
meta (GtkWidget * widget, gpointer data)
{
  GList *popuplist = NULL;

  create_dialog (520, 168, "Meta");
  dialogtable = gtk_table_new (4, 100, 0);
  gtk_box_pack_start (GTK_BOX (vbox), dialogtable, FALSE, FALSE, 0);
  gtk_widget_show (dialogtable);

  label = gtk_label_new ("URL");
  textentry2 = gtk_entry_new_with_max_length (256);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 10, 3, 4);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), textentry2, 10, 100,
			     3, 4);
  gtk_widget_show (label);
  gtk_widget_show (textentry2);

  /* this is up here because "name" and "HTTP_EQUIV" share a list */
  /* and name doesn't need a refresh in the list */
  label = gtk_label_new ("Name");
  combo2 = GTK_COMBO (gtk_combo_new ());
  popuplist = g_list_insert (popuplist, "description", 0);
  popuplist = g_list_insert (popuplist, "expires", 1);
  popuplist = g_list_insert (popuplist, "reply-to", 2);
  popuplist = g_list_insert (popuplist, "keywords", 3);
  popuplist = g_list_insert (popuplist, "PICS-label", 4);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 10, 1, 2);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (combo2),
			     10, 100, 1, 2);
  gtk_combo_set_popdown_strings (combo2, popuplist);
  gtk_entry_set_text (GTK_ENTRY (combo2->entry), "");
  gtk_widget_show (label);
  gtk_widget_show (GTK_WIDGET (combo2));

  label = gtk_label_new ("HTTP-EQUIV");
  combo1 = GTK_COMBO (gtk_combo_new ());
  popuplist = g_list_insert (popuplist, "refresh", 5);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 10, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (combo1),
			     10, 100, 0, 1);
  gtk_combo_set_popdown_strings (combo1, popuplist);
  g_list_free(popuplist);
  gtk_entry_set_text (GTK_ENTRY (combo1->entry), "");
  gtk_widget_show (label);
  gtk_widget_show (GTK_WIDGET (combo1));

  label = gtk_label_new ("Content");
  textentry1 = gtk_text_new (NULL, NULL);
  scrollbar = gtk_vscrollbar_new (GTK_TEXT (textentry1)->vadj);
  gtk_text_set_editable (GTK_TEXT (textentry1), 1);
  gtk_text_set_word_wrap (GTK_TEXT (textentry1), 1);
  /* the second argument to usize gets expanded to fill the allocated space */
  /* I just needed to define a size for the height */
  gtk_widget_set_usize (textentry1, 1, 45);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 10, 2, 3);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), textentry1, 10, 99,
			     2, 3);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), scrollbar, 99, 100,
			     2, 3);
  gtk_widget_show (label);
  gtk_widget_show (textentry1);
  gtk_widget_show (scrollbar);

  label = gtk_label_new ("URL");
  textentry2 = gtk_entry_new_with_max_length (256);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 10, 3, 4);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), textentry2, 10, 100,
			     3, 4);
  gtk_widget_show (label);
  gtk_widget_show (textentry2);

  create_buttons ();
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked", GTK_SIGNAL_FUNC
		      (metaok), NULL);
}

void
embed (GtkWidget * widget, gpointer data)
{
  GtkWidget *file_but;

  create_dialog (500, 123, "Embed");
  dialogtable = gtk_table_new (3, 12, 0);
  gtk_box_pack_start (GTK_BOX (vbox), dialogtable, FALSE, FALSE, 0);
  gtk_widget_show (dialogtable);

  label = gtk_label_new ("URL");
  textentry1 = gtk_entry_new_with_max_length (256);
  file_but = file_but_new (textentry1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (file_but),
			     10, 12, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 2, 0, 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), textentry1, 2, 10,
			     0, 1);
  gtk_widget_show (label);
  gtk_widget_show (textentry1);

  label = gtk_label_new ("Width");
  adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat) 1, 0.0, 500.0, 1.0,
					      5.0, 0.0);
  spin1 = gtk_spin_button_new (adj, 1, 0);
  gtk_entry_set_text (GTK_ENTRY (spin1), "");
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin1), 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 2, 1, 2);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), spin1, 2, 4, 1, 2);
  gtk_widget_show (label);
  gtk_widget_show (spin1);

  label = gtk_label_new ("Height");
  adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat) 1, 0.0, 500.0, 1.0,
					      5.0, 0.0);
  spin2 = gtk_spin_button_new (adj, 1, 0);
  gtk_entry_set_text (GTK_ENTRY (spin2), "");
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin2), 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 4, 6, 1, 2);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), spin2, 6, 8, 1, 2);
  gtk_widget_show (label);
  gtk_widget_show (spin2);

  label = gtk_label_new ("Border");
  adj = (GtkAdjustment *) gtk_adjustment_new ((gfloat) 0, 0.0, 500.0, 1.0,
					      5.0, 0.0);
  spin3 = gtk_spin_button_new (adj, 1, 0);
  gtk_entry_set_text (GTK_ENTRY (spin3), "");
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin3), 1);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 8, 10, 1, 2);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), spin3, 10, 12, 1, 2);
  gtk_widget_show (label);
  gtk_widget_show (spin3);

  label = gtk_label_new ("Align");
  combo1 = GTK_COMBO (gtk_combo_new ());
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), label, 0, 2, 2, 3);
  gtk_table_attach_defaults (GTK_TABLE (dialogtable), GTK_WIDGET (combo1),
			     2, 12, 2, 3);
  gtk_combo_set_popdown_strings (combo1, positionlist);
  gtk_entry_set_text (GTK_ENTRY (combo1->entry), "");
  gtk_widget_show (label);
  gtk_widget_show (GTK_WIDGET (combo1));

  create_buttons ();
  gtk_signal_connect (GTK_OBJECT (okbutton), "clicked", GTK_SIGNAL_FUNC
		      (embedok), NULL);
}

void
sel_colour (GtkWidget * widget, gpointer data)
{

  GtkWidget *colorseldlg;
  GtkWidget *colorsel;

  colorseldlg = gtk_color_selection_dialog_new ("Select Colour");
  colorsel = GTK_COLOR_SELECTION_DIALOG (colorseldlg)->colorsel;
  gtk_widget_show (colorseldlg);
}


gchar *
extract_time_string (char *original_string)
{
  static gchar *return_string;
  gchar *start_ptr;
  gchar *end_ptr;
  gint string_size;

  return_string = g_malloc0 (32);
  start_ptr = strchr (original_string, '(');
  start_ptr++;
  end_ptr = strchr (original_string, ')');
  string_size = end_ptr - start_ptr;
  strncat (return_string, start_ptr, string_size);
  return return_string;
}

void
insert_time_callback (GtkWidget * widget, struct TimeInsertstruct *timeinsert)
{
  gchar *temp_string;
  gchar *insert_string;
  gchar *final_string;
  gint count;

  insert_string = g_malloc0 (32);
  final_string = g_malloc0 (255);
  for (count = 1; count <6 ; count++) {
     if (GTK_TOGGLE_BUTTON (timeinsert->check[count])->active){
        gtk_label_get (GTK_LABEL (timeinsert->label[count]), &temp_string);
        insert_string = extract_time_string (temp_string);
        strcat (final_string, insert_string);
        strcat (final_string, " ");
     }
  }
  insert_text (final_string, "");
  g_free (insert_string);
  g_free (final_string);
  gtk_widget_destroy (timeinsert->dialog);
  g_free(timeinsert);
}

void insert_time_cancel(GtkWidget * widget, struct TimeInsertstruct *data) {

   gtk_widget_destroy(GTK_WIDGET(data->dialog));
   g_free(data);
}

void
insert_time (GtkWidget * widget, gpointer data)
{

  gint month, year, count;
  time_t time_var;
  gchar *temp;
  struct tm *time_struct;
  struct TimeInsertstruct *timeinsert;
  GtkWidget *ok_b, *cancel_b;
  
  temp = g_malloc0 (64);
  timeinsert = g_malloc(sizeof(TimeInsert));
  time_var = time (NULL);
  time_struct = localtime (&time_var);

  timeinsert->dialog = gtk_dialog_new ();
  gtk_container_border_width (GTK_CONTAINER (timeinsert->dialog), 10);
  gtk_window_position (GTK_WINDOW (timeinsert->dialog), GTK_WIN_POS_MOUSE);
  gtk_window_set_title (GTK_WINDOW (timeinsert->dialog), "Insert Time");

  ok_b = gtk_button_new_with_label ("  OK  ");
  cancel_b = gtk_button_new_with_label ("  Cancel  ");

  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (timeinsert->dialog)->action_area), ok_b,
		      TRUE, TRUE, 0);

  gtk_signal_connect(GTK_OBJECT (ok_b), "clicked",
			     GTK_SIGNAL_FUNC (insert_time_callback), (gpointer) timeinsert);

  gtk_signal_connect(GTK_OBJECT (cancel_b), "clicked",
			     GTK_SIGNAL_FUNC (insert_time_cancel),
			     (gpointer) timeinsert);

  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (timeinsert->dialog)->action_area), cancel_b,
		      TRUE, TRUE, 0);
		      
  for (count = 1; count <6 ; count++) {
    switch (count)
    {
    case 1:
       sprintf (temp, "  Time (%i:%i:%i)", time_struct->tm_hour,
       time_struct->tm_min, time_struct->tm_sec);      
      break;
    case 2:
       switch (time_struct->tm_wday)
       {
       case 0:
          sprintf (temp, "  Day of the week (Sunday)");
          break;
       case 1:
          sprintf (temp, "  Day of the week (Monday)");
          break;
       case 2:
          sprintf (temp, "  Day of the week (Tuesday)");
          break;
       case 3:
          sprintf (temp, "  Day of the week (Wednesday)");
          break;
       case 4:
          sprintf (temp, "  Day of the week (Thursday)");
          break;
       case 5:
          sprintf (temp, "  Day of the week (Friday)");
          break;
       case 6:
          sprintf (temp, "  Day of the week (Saturday)");
          break;
       default:
          printf ("You appear to have a non existant day!\n");
          sprintf (temp, " ** Error ** see stdout");
       } /* end of switch day of week */
      break;
    case 3:
       month = time_struct->tm_mon + 1;
       year = time_struct->tm_year;
       year = 1900 + year;
       sprintf (temp, "  Date (%i/%i/%i)", time_struct->tm_mday, month, year);      
      break;
    case 4:
       sprintf (temp, "  Unix Time (%i)", (int) time_var);      
      break;
    case 5:
       sprintf (temp, "  Unix Date String (%s", ctime (&time_var));
       temp[strlen (temp) - 1] = 0;
       strcat (temp, ")");      
      break;
    default:
    } /* end of switch count */
    timeinsert->check[count] = gtk_check_button_new ();
    timeinsert->label[count] = gtk_label_new (temp);
    gtk_container_add (GTK_CONTAINER (timeinsert->check[count]), GTK_WIDGET(timeinsert->label[count]));
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG (timeinsert->dialog)->vbox), GTK_WIDGET(timeinsert->check[count]), TRUE, TRUE, 0);
    gtk_widget_show (timeinsert->check[count]);
    gtk_widget_show (timeinsert->label[count]);
  } /* end of for loop */

  gtk_widget_show (cancel_b);
  gtk_widget_show (ok_b);
  GTK_WIDGET_SET_FLAGS (okbutton, GTK_CAN_DEFAULT);
  g_free (temp);
  gtk_widget_show (timeinsert->dialog);
}




void
insert_char (GtkWidget * widget, gpointer data)
{
  insert_text (data, "");
}

/* stuff not in html.h, i.e. only used locally */

void
insert_text (gchar * before, gchar * after)
{
  guint startp, endp, currentp, tmp;

  gtk_text_freeze (GTK_TEXT (current_document->textbox));
#ifdef DEBUG
  tmp = GTK_TEXT (current_document->textbox)->gap_position;
  g_print ("insert_text, gap_position tmp=%d\n", tmp);
  tmp = GTK_TEXT (current_document->textbox)->gap_size;
  g_print ("insert_text, gap_size tmp=%d\n", tmp);
  tmp = GTK_TEXT (current_document->textbox)->cursor_mark.index;
  g_print ("insert_text, cursor_mark->index tmp=%d\n", tmp);
  tmp = GTK_TEXT (current_document->textbox)->point.index;
  g_print ("insert_text, point->index tmp=%d\n", tmp);
  tmp = GTK_TEXT (current_document->textbox)->text_end;
  g_print ("insert_text, text_end tmp=%d\n", tmp);
#endif
  currentp = GTK_TEXT (current_document->textbox)->cursor_mark.index;
  startp = GTK_EDITABLE ((GtkText *) current_document->textbox)->selection_start_pos;
  endp = GTK_EDITABLE ((GtkText *) current_document->textbox)->selection_end_pos;
  if (endp < startp)
    {
      tmp = endp;
      endp = startp;
      startp = tmp;
    }
  if (endp == 0)
    {
      startp = currentp;
      endp = currentp;
    }
#ifdef DEBUG
  g_print ("insert_text, currentp = %d, startp=%d, endp=%d\n", currentp,
	   startp, endp);
#endif
  gtk_text_set_point (GTK_TEXT ((GtkText *) current_document->textbox), endp);
  gtk_text_insert ((GtkText *) current_document->textbox, NULL, NULL, NULL,
		   after, -1);

  undo_list_add(current_document, g_strdup(after), endp, endp + strlen(after), UndoInsert);

  gtk_text_set_point (GTK_TEXT ((GtkText *) current_document->textbox), startp);
  gtk_text_insert ((GtkText *) current_document->textbox, NULL, NULL, NULL,
		   before, -1);
  undo_list_add(current_document, g_strdup(before), startp, startp + strlen(before), UndoInsert);
  GTK_EDITABLE ((GtkText *) current_document->textbox)->selection_start_pos
    = startp + strlen (before);
  GTK_EDITABLE ((GtkText *)
		current_document->textbox)->selection_end_pos =
    endp + strlen (before);
#ifdef DEBUG
  g_print ("insert_text, currentp = %d, startp=%d, endp=%d\n", currentp,
	   startp, endp);
#endif
  gtk_text_set_point (GTK_TEXT ((GtkText *) current_document->textbox),
		      (currentp + strlen (before)));
  gtk_widget_grab_focus (GTK_WIDGET ((GtkText *) current_document->textbox));
  current_document->modified = 1;
  gtk_text_thaw (GTK_TEXT (current_document->textbox));
}

void
create_buttons (void)
{
  hbox = gtk_hbutton_box_new ();
  gtk_hbutton_box_set_layout_default (4);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbox), 5);
  gtk_widget_show (hbox);

  okbutton = gtk_button_new_with_label ((gchar *) "OK");
  gtk_widget_set_usize (GTK_WIDGET (okbutton), 82, 33);
  GTK_WIDGET_SET_FLAGS (okbutton, GTK_CAN_DEFAULT);
  
  cancelbutton = gtk_button_new_with_label ((gchar *) "Cancel");
  gtk_widget_set_usize (GTK_WIDGET (cancelbutton), 82, 33);
  GTK_WIDGET_SET_FLAGS (cancelbutton, GTK_CAN_DEFAULT);

  /* next one could give a problem with GTK 1.2 
     if so -> use gtk_signal_connect()
   */

  gtk_signal_connect_object (GTK_OBJECT (cancelbutton), "clicked",
			     GTK_SIGNAL_FUNC (gtk_object_destroy),
			     (GtkObject *) dialog);
  
  gtk_box_pack_start (GTK_BOX (hbox), okbutton, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), cancelbutton, FALSE, FALSE, 0);
  gtk_widget_show (cancelbutton);
  gtk_widget_show (okbutton);
  
  gtk_widget_realize (dialog);
  gtk_window_set_default (GTK_WINDOW(dialog), okbutton);
/* causes some random crashes??? */
/*  gtk_window_set_transient_for(GTK_WINDOW(main_window), GTK_WINDOW(dialog)); */
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
}

void
create_dialog (int width, int height, gchar * title)
{
  dialog = gtk_window_new (GTK_WINDOW_DIALOG);
#ifdef DEBUG
  g_print ("create_dialog, dialog pointer = %p\n", dialog);
#endif
  gtk_grab_add (dialog);
  gtk_container_border_width (GTK_CONTAINER (dialog), 10);
  gtk_signal_connect (GTK_OBJECT (dialog), "delete_event", GTK_SIGNAL_FUNC
		      (window_close), dialog);
  gtk_signal_connect (GTK_OBJECT (dialog), "destroy", GTK_SIGNAL_FUNC
		      (window_close), dialog);
  gtk_widget_set_usize (GTK_WIDGET (dialog), width, height);
  gtk_window_set_title (GTK_WINDOW (dialog), title);
  gtk_window_position (GTK_WINDOW (dialog), GTK_WIN_POS_CENTER);
  gtk_widget_show (dialog);
  vbox = gtk_vbox_new (FALSE, 5);
  gtk_container_add (GTK_CONTAINER (dialog), vbox);
  gtk_widget_show (vbox);
#ifdef DEBUG
  g_print ("create_dialog, finished\n");
#endif
}

void
destroy_dialog (void)
{
  /* this makes sure that there is no memory leak with dialogs */
#ifdef DEBUG
  g_print ("destroy_dialog, dialog pointer = %p\n", dialog);
#endif
  if (stuff != NULL)
    g_free (stuff);

  window_close (NULL, dialog);
#ifdef DEBUG
  g_print ("destroy_dialog, dialog destroyed\n");
#endif
}


gchar *
converttohex (gchar * color)
{
  if (!strncasecmp (color, "black", 32))
    {
      return "#000000";
    }
  if (!strncasecmp (color, "maroon", 32))
    {
      return "#800000";
    }
  if (!strncasecmp (color, "green", 32))
    {
      return "#008000";
    }
  if (!strncasecmp (color, "olive", 32))
    {
      return "#808000";
    }
  if (!strncasecmp (color, "navy", 32))
    {
      return "#000080";
    }
  if (!strncasecmp (color, "purple", 32))
    {
      return "#800080";
    }
  if (!strncasecmp (color, "fushsia", 32))
    {
      return "#FF00FF";
    }
  if (!strncasecmp (color, "teal", 32))
    {
      return "#008080";
    }
  if (!strncasecmp (color, "gray", 32))
    {
      return "#808080";
    }
  if (!strncasecmp (color, "silver", 32))
    {
      return "#C0C0C0";
    }
  if (!strncasecmp (color, "red", 32))
    {
      return "#FF0000";
    }
  if (!strncasecmp (color, "lime", 32))
    {
      return "#00FF00";
    }
  if (!strncasecmp (color, "yellow", 32))
    {
      return "#FFFF00";
    }
  if (!strncasecmp (color, "blue", 32))
    {
      return "#0000FF";
    }
  if (!strncasecmp (color, "aqua", 32))
    {
      return "#00FFFF";
    }
  if (!strncasecmp (color, "white", 32))
    {
      return "#FFFFFF";
    }
  return color;
}

void
quickanchorok (void)
{
  stuff = g_malloc (1024);

  strcpy (stuff, "<a ");
  if (strlen ((gchar *) gtk_entry_get_text (GTK_ENTRY (combo2->entry))))
    {
      strncat (strncat (strcat (stuff, "href=\""), (gchar *)
			gtk_entry_get_text (GTK_ENTRY (combo2->entry)), 1023),
	       "\"", 1023);
      add_to_list (urllist, gtk_entry_get_text (GTK_ENTRY (combo2->entry)));
    }
  if (strlen ((gchar *) gtk_entry_get_text (GTK_ENTRY (combo1->entry))))
    {
      strncat (strncat (strncat (stuff, " target=\"", 1023), (gchar *)
			gtk_entry_get_text (GTK_ENTRY (combo1->entry)),
			1023), "\"", 1023);
      add_to_list (targetlist, gtk_entry_get_text (GTK_ENTRY (combo1->entry)));
    }
  if (strlen ((gchar *) gtk_entry_get_text (GTK_ENTRY (textentry2))))
    {
      strncat (strncat (strncat (stuff, " name=\"", 1023), (gchar *)
			gtk_entry_get_text (GTK_ENTRY (textentry2)), 1023),
	       "\"", 1023);
      add_to_list (targetlist, gtk_entry_get_text (GTK_ENTRY (textentry2)));
    }
  strncat (stuff, ">", 1023);
  if (strlen ((gchar *) gtk_entry_get_text (GTK_ENTRY (textentry3))))
    {
      strncat (stuff, (gchar *)
	       gtk_entry_get_text (GTK_ENTRY (textentry3)), 1023);
    }
  insert_text (stuff, "</a>");

  destroy_dialog ();
}

void
quickruleok (void)
{
  gchar *tempstr;
  gint temp;

  stuff = g_malloc (1024);
  tempstr = g_malloc (1024);

  strcpy (stuff, "<hr");

  if (strlen (gtk_entry_get_text (GTK_ENTRY (combo1->entry))))
    {
      strncat (strncat (strncat (stuff, " align=\"", 1023),
			gtk_entry_get_text (GTK_ENTRY (combo1->entry)),
			1023), "\"", 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (spin1))))
    {
      temp = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin1));
      sprintf (tempstr, "%d", temp);
      strncat (strncat (strncat (stuff, " size=\"", 1023), tempstr, 1023),
	       "\"", 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (spin2))))
    {
      temp = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin2));
      sprintf (tempstr, "%d", temp);
      strncat (strncat (stuff, " width=\"", 1023), tempstr, 1023);
      if (GTK_TOGGLE_BUTTON (checkbox1)->active)
	{
	  strncat (stuff, "%", 1023);
	}
      strncat (stuff, "\"", 1023);
    }
  /* noshade */
  if (GTK_TOGGLE_BUTTON (checkbox2)->active)
    {
      /* If control reaches here, the toggle button is down */
      strncat (stuff, " noshade", 1023);
    }
  strncat (stuff, ">", 1023);
  insert_text (stuff, "");

  destroy_dialog ();
  g_free (tempstr);
}

void
bodyok (void)
{
  stuff = g_malloc (1024);

  strcpy (stuff, "<body");

  if (strlen (gtk_entry_get_text (GTK_ENTRY (textentry1))))
    {
      strncat (strncat (strncat (stuff, " background=\"", 1023),
			gtk_entry_get_text (GTK_ENTRY (textentry1)), 1023),
	       "\"", 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (combo1->entry))))
    {
      strncat (strncat (strncat (stuff, " bgcolor=\"", 1023), converttohex
			(gtk_entry_get_text (GTK_ENTRY (combo1->entry))),
			1023), "\"", 1023);
      add_to_list (colorlist, gtk_entry_get_text (GTK_ENTRY (combo1->entry)));
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (combo2->entry))))
    {
      strncat (strncat (strncat (stuff, " text=\"", 1023), converttohex
			(gtk_entry_get_text (GTK_ENTRY (combo2->entry))),
			1023), "\"", 1023);
      add_to_list (colorlist, gtk_entry_get_text (GTK_ENTRY (combo2->entry)));
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (combo3->entry))))
    {
      strncat (strncat (strncat (stuff, " link=\"", 1023), converttohex
			(gtk_entry_get_text (GTK_ENTRY (combo3->entry))),
			1023), "\"", 1023);
      add_to_list (colorlist, gtk_entry_get_text (GTK_ENTRY (combo3->entry)));
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (combo4->entry))))
    {
      strncat (strncat (strncat (stuff, " vlink=\"", 1023), converttohex
			(gtk_entry_get_text (GTK_ENTRY (combo4->entry))),
			1023), "\"", 1023);
      add_to_list (colorlist, gtk_entry_get_text (GTK_ENTRY (combo4->entry)));
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (combo5->entry))))
    {
      strncat (strncat (strncat (stuff, " alink=\"", 1023), converttohex
			(gtk_entry_get_text (GTK_ENTRY (combo5->entry))),
			1023), "\"", 1023);
      add_to_list (colorlist, gtk_entry_get_text (GTK_ENTRY (combo5->entry)));
    }
  strncat (stuff, ">", 1023);
  insert_text (stuff, "\n\n</body>");

  destroy_dialog ();
}

void
emailok (void)
{
  gchar *address;
  address = g_malloc (256);

  strncat (strncat (strcpy (address, "<a href=\"mailto:"), (gchar *)
		    gtk_entry_get_text (GTK_ENTRY (textentry1)), 255),
	   "\">", 255);
  insert_text (address, "</a>");
  destroy_dialog ();
  g_free (address);
}

void
fontok (void)
{
  gchar *tempstr;
  gint temp, doh;

  stuff = g_malloc (1024);
  tempstr = g_malloc (1024);

  strcpy (stuff, "<font");

  doh = 0;
  if (strlen (gtk_entry_get_text (GTK_ENTRY (combo1->entry))))
    {
      strncat (strncat (stuff, " size=\"", 1023), gtk_entry_get_text
	       (GTK_ENTRY (combo1->entry)), 1023);
      temp = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin1));
      sprintf (tempstr, "%d", temp);
      strncat (strncat (stuff, tempstr, 1023), "\"", 1023);
      doh = 1;
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (spin1))) && doh != 1)
    {
      strncat (stuff, " size=\"", 1023);
      temp = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin1));
      sprintf (tempstr, "%d", temp);
      strncat (strncat (stuff, tempstr, 1023), "\"", 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (combo2->entry))))
    {
      strncat (strncat (strncat (stuff, " color=\"", 1023), converttohex
			(gtk_entry_get_text (GTK_ENTRY (combo2->entry))),
			1023), "\"", 1023);
      add_to_list (colorlist, gtk_entry_get_text (GTK_ENTRY (combo2->entry)));
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (combo3->entry))))
    {
      strncat (
		strncat (strncat (stuff, " face=\"", 1023),
			 gtk_entry_get_text (GTK_ENTRY (combo3->entry))
			 ,1023), "\"", 1023);
      add_to_list (fontlist, gtk_entry_get_text (GTK_ENTRY (combo3->entry)));
    }
  strncat (stuff, ">", 1023);
  insert_text (stuff, "</font>");
  destroy_dialog ();
  g_free (tempstr);
}

void
basefontok (void)
{
  gchar *tempstr;
  gint temp, doh;
  stuff = g_malloc (1024);
  tempstr = g_malloc (1024);

  strcpy (stuff, "<basefont");

  doh = 0;
  if (strlen (gtk_entry_get_text (GTK_ENTRY (combo1->entry))))
    {
      strncat (strncat (stuff, " size=\"", 1023), gtk_entry_get_text
	       (GTK_ENTRY (combo1->entry)), 1023);
      temp = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin1));
      sprintf (tempstr, "%d", temp);
      strncat (strncat (stuff, tempstr, 1023), "\"", 1023);
      doh = 1;
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (spin1))) && doh != 1)
    {
      strncat (stuff, " size=\"", 1023);
      temp = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin1));
      sprintf (tempstr, "%d", temp);
      strncat (strncat (stuff, tempstr, 1023), "\"", 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (combo2->entry))))
    {
      strncat (strncat (strncat (stuff, " color=\"", 1023), converttohex
			(gtk_entry_get_text (GTK_ENTRY (combo2->entry))),
			1023), "\"", 1023);
      add_to_list (colorlist, gtk_entry_get_text (GTK_ENTRY (combo2->entry)));
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (combo3->entry))))
    {
      strncat (strncat (strncat (stuff, " face=\"", 1023),
			gtk_entry_get_text (GTK_ENTRY (combo3->entry)),
			1023), "\"", 1023);
      add_to_list (fontlist, gtk_entry_get_text (GTK_ENTRY (combo3->entry)));
    }
  strncat (stuff, ">", 1023);
  insert_text (stuff, "");

  destroy_dialog ();
  g_free (tempstr);
}

void
formok (void)
{
  stuff = g_malloc (1024);

  strcpy (stuff, "<form");

  if (strlen (gtk_entry_get_text (GTK_ENTRY (textentry1))))
    {
      strncat (strncat (strncat (stuff, " action=\"", 1023),
			gtk_entry_get_text (GTK_ENTRY (textentry1)), 1023),
	       "\"", 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (combo1->entry))))
    {
      strncat (strncat (strncat (stuff, " method=\"", 1023),
			gtk_entry_get_text (GTK_ENTRY (combo1->entry)),
			1023), "\"", 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (combo2->entry))))
    {
      strncat (strncat (strncat (stuff, " enctype=\"", 1023),
			gtk_entry_get_text (GTK_ENTRY (combo2->entry)),
			1023), "\"", 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (combo3->entry))))
    {
      strncat (strncat (strncat (stuff, " target=\"", 1023),
			gtk_entry_get_text (GTK_ENTRY (combo3->entry)),
			1023), "\"", 1023);
      add_to_list (targetlist, gtk_entry_get_text (GTK_ENTRY (combo3->entry)));
    }
  strncat (stuff, ">", 1023);
  insert_text (stuff, "</form>");

  destroy_dialog ();
}

void
submitok (void)
{
  stuff = g_malloc (1024);

  strcpy (stuff, "<input type=\"submit\"");

  if (strlen (gtk_entry_get_text (GTK_ENTRY (textentry1))))
    {
      strncat (strncat (strncat (stuff, " name=\"", 1023),
			gtk_entry_get_text (GTK_ENTRY (textentry1)), 1023),
	       "\"", 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (textentry2))))
    {
      strncat (strncat (strncat (stuff, " value=\"", 1023),
			gtk_entry_get_text (GTK_ENTRY (textentry2)), 1023),
	       "\"", 1023);
    }
  strncat (stuff, ">", 1023);
  insert_text (stuff, "");

  destroy_dialog ();
}

void
resetok (void)
{
  stuff = g_malloc (1024);

  strcpy (stuff, "<input type=\"reset\"");

  if (strlen (gtk_entry_get_text (GTK_ENTRY (textentry1))))
    {
      strncat (strncat (strncat (stuff, " name=\"", 1023),
			gtk_entry_get_text (GTK_ENTRY (textentry1)), 1023),
	       "\"", 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (textentry2))))
    {
      strncat (strncat (strncat (stuff, " value=\"", 1023),
			gtk_entry_get_text (GTK_ENTRY (textentry2)), 1023),
	       "\"", 1023);
    }
  strncat (stuff, ">", 1023);
  insert_text (stuff, "");

  destroy_dialog ();
}

void
textok (void)
{
  gchar *tempstr;
  gint temp;
  stuff = g_malloc (1024);
  tempstr = g_malloc (1024);

  strcpy (stuff, "<input type=\"text\"");

  if (strlen (gtk_entry_get_text (GTK_ENTRY (textentry1))))
    {
      strncat (strncat (strncat (stuff, " name=\"", 1023),
			gtk_entry_get_text (GTK_ENTRY (textentry1)), 1023),
	       "\"", 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (spin1))))
    {
      temp = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin1));
      sprintf (tempstr, " rows=\"%d\"", temp);
      strncat (stuff, tempstr, 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (spin2))))
    {
      temp = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin2));
      sprintf (tempstr, " cols=\"%d\"", temp);
      strncat (stuff, tempstr, 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (textentry2))))
    {
      strncat (strncat (strncat (stuff, " value=\"", 1023),
			gtk_entry_get_text (GTK_ENTRY (textentry2)), 1023),
	       "\"", 1023);
    }
  strncat (stuff, ">", 1023);
  insert_text (stuff, "");

  g_free (tempstr);
  destroy_dialog ();
}

void
hiddenok (void)
{
  stuff = g_malloc (1024);

  strcpy (stuff, "<input type=\"hidden\"");

  if (strlen (gtk_entry_get_text (GTK_ENTRY (textentry1))))
    {
      strncat (strncat (strncat (stuff, " name=\"", 1023),
			gtk_entry_get_text (GTK_ENTRY (textentry1)), 1023),
	       "\"", 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (textentry2))))
    {
      strncat (strncat (strncat (stuff, " value=\"", 1023),
			gtk_entry_get_text (GTK_ENTRY (textentry2)), 1023),
	       "\"", 1023);
    }
  strncat (stuff, ">", 1023);
  insert_text (stuff, "");

  destroy_dialog ();
}

void
textareaok (void)
{
  gchar *tempstr;
  gint temp;
  stuff = g_malloc (1024);
  tempstr = g_malloc (1024);

  strcpy (stuff, "<textarea");

  if (strlen (gtk_entry_get_text (GTK_ENTRY (textentry1))))
    {
      strncat (strncat (strncat (stuff, " name=\"", 1023),
			gtk_entry_get_text (GTK_ENTRY (textentry1)), 1023),
	       "\"", 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (spin1))))
    {
      temp = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin1));
      sprintf (tempstr, " size=\"%d\"", temp);
      strncat (stuff, tempstr, 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (spin2))))
    {
      temp = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin2));
      sprintf (tempstr, " maxlen=\"%d\"", temp);
      strncat (stuff, tempstr, 1023);
    }
  strncat (stuff, ">", 1023);

  if (strlen (gtk_entry_get_text (GTK_ENTRY (textentry2))))
    {
      strncat (stuff, gtk_entry_get_text (GTK_ENTRY (textentry2)), 1023);
    }
  insert_text (stuff, "</textarea>");

  g_free (tempstr);
  destroy_dialog ();
}

void
selectok (void)
{
  gint i, temp;
  stuff = g_malloc (1024);

  strcpy (stuff, "<select");

  if (strlen (gtk_entry_get_text (GTK_ENTRY (textentry1))))
    {
      strncat (strncat (strncat (stuff, " name=\"", 1023),
			gtk_entry_get_text (GTK_ENTRY (textentry1)), 1023),
	       "\"", 1023);
    }
  strncat (stuff, ">", 1023);

  if (strlen (gtk_entry_get_text (GTK_ENTRY (spin1))))
    {
      temp = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin1));
      for (i = temp; i != 0; i--)
	{
	  strncat (stuff, "\n\t<option>", 1023);
	}
    }
  insert_text (stuff, "\n</select>");

  destroy_dialog ();
}

void
radiook (void)
{
  stuff = g_malloc (1024);

  strcpy (stuff, "<input type=\"radio\"");

  if (strlen (gtk_entry_get_text (GTK_ENTRY (textentry1))))
    {
      strncat (strncat (strncat (stuff, " name=\"", 1023),
			gtk_entry_get_text (GTK_ENTRY (textentry1)), 1023),
	       "\"", 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (textentry2))))
    {
      strncat (strncat (strncat (stuff, " value=\"", 1023),
			gtk_entry_get_text (GTK_ENTRY (textentry2)), 1023),
	       "\"", 1023);
    }
  if (GTK_TOGGLE_BUTTON (checkbox1)->active)
    {
      strncat (stuff, " checked", 1023);
    }
  strncat (stuff, ">", 1023);
  insert_text (stuff, "");

  destroy_dialog ();
}

void
checkok (void)
{
  stuff = g_malloc (1024);

  strcpy (stuff, "<input type=\"check\"");

  if (strlen (gtk_entry_get_text (GTK_ENTRY (textentry1))))
    {
      strncat (strncat (strncat (stuff, " name=\"", 1023),
			gtk_entry_get_text (GTK_ENTRY (textentry1)), 1023),
	       "\"", 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (textentry2))))
    {
      strncat (strncat (strncat (stuff, " value=\"", 1023),
			gtk_entry_get_text (GTK_ENTRY (textentry2)), 1023),
	       "\"", 1023);
    }
  if (GTK_TOGGLE_BUTTON (checkbox1)->active)
    {
      strncat (stuff, " checked", 1023);
    }
  strncat (stuff, ">", 1023);
  insert_text (stuff, "");

  destroy_dialog ();
}

void
quicklistok (void)
{
  gint active, temp, i;
  stuff = g_malloc (1024);

  /* speed optimization, only tests once */
  active = GTK_TOGGLE_BUTTON (radio1)->active;

  if (active)
    {
      strcpy (stuff, "<ol>");
    }
  else
    {
      strcpy (stuff, "<ul>");
    }

  if (strlen (gtk_entry_get_text (GTK_ENTRY (spin1))))
    {
      temp = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin1));
      for (i = 0; i < temp; i++)
	{
	  strncat (stuff, "\n\t<li>", 1023);
	}
    }
  strncat (stuff, "\n", 1023);

  if (active)
    {
      insert_text (stuff, "</ol>");
    }
  else
    {
      insert_text (stuff, "</ul>");
    }

  destroy_dialog ();
}

void
metaok (void)
{
  gchar *tmpchar, *tmpchar2;

  stuff = g_malloc (1024);

  strcpy (stuff, "<meta");

  if (strlen (gtk_entry_get_text (GTK_ENTRY (combo1->entry))))
    {
      strncat (strncat (strncat (stuff, " http-equiv=\"", 1023),
			gtk_entry_get_text (GTK_ENTRY (combo1->entry)),
			1023), "\"", 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (combo2->entry))))
    {
      strncat (strncat (strncat (stuff, " name=\"", 1023),
			gtk_entry_get_text (GTK_ENTRY (combo2->entry)),
			1023), "\"", 1023);
    }
  /* gtk_editable_get_chars allocates memory --> we should free it afterwards */
  tmpchar = gtk_editable_get_chars (GTK_EDITABLE (textentry1), 0, -1);
  if (strlen (tmpchar))
    {
      tmpchar2 = gtk_editable_get_chars (GTK_EDITABLE (textentry1), 0, -1);
      strncat (strncat (strncat (stuff, " content=\"", 1023),
			tmpchar2, 1023), "\"", 1023);
      g_free (tmpchar2);
    }
  g_free (tmpchar);
  if (strlen (gtk_entry_get_text (GTK_ENTRY (textentry2))))
    {
      strncat (strncat (strncat (stuff, " url=\"", 1023), gtk_entry_get_text
			(GTK_ENTRY (textentry2)), 1023), "\"", 1023);
    }
  strncat (stuff, ">", 1023);
  insert_text (stuff, "");

  destroy_dialog ();
}

void
embedok (void)
{
  gchar *tempstr;
  gint temp;
  stuff = g_malloc (1024);
  tempstr = g_malloc (1024);

  strcpy (stuff, "<embed");

  if (strlen (gtk_entry_get_text (GTK_ENTRY (textentry1))))
    {
      strncat (strncat (strncat (stuff, " src=\"", 1023), gtk_entry_get_text
			(GTK_ENTRY (textentry1)), 1023), "\"", 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (spin1))))
    {
      temp = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin1));
      sprintf (tempstr, " width=\"%d\"", temp);
      strncat (stuff, tempstr, 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (spin2))))
    {
      temp = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin2));
      sprintf (tempstr, " height=\"%d\"", temp);
      strncat (stuff, tempstr, 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (spin3))))
    {
      temp = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin3));
      sprintf (tempstr, " border=\"%d\"", temp);
      strncat (stuff, tempstr, 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (combo1->entry))))
    {
      strncat (strncat (strncat (stuff, " align=\"", 1023),
			gtk_entry_get_text (GTK_ENTRY (combo1->entry)),
			1023), "\"", 1023);
    }
  strncat (stuff, ">", 1023);
  insert_text (stuff, "");

  g_free (tempstr);
  destroy_dialog ();
}

void
tabledialogok (void)
{
  gchar *tempstr;
  gint temp;
  stuff = g_malloc (1024);
  tempstr = g_malloc (1024);

  strcpy (stuff, "<table");

  if (strlen (gtk_entry_get_text (GTK_ENTRY (spin1))))
    {
      temp = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin1));
      sprintf (tempstr, " cellpadding=\"%d\"", temp);
      strncat (stuff, tempstr, 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (spin3))))
    {
      temp = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin3));
      sprintf (tempstr, " cellspacing=\"%d\"", temp);
      strncat (stuff, tempstr, 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (spin4))))
    {
      temp = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin4));
      sprintf (tempstr, " border=\"%d\"", temp);
      strncat (stuff, tempstr, 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (combo1->entry))))
    {
      strncat (strncat (strncat (stuff, " align=\"", 1023),
			gtk_entry_get_text (GTK_ENTRY (combo1->entry)),
			1023), "\"", 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (combo2->entry))))
    {
      strncat (strncat (strncat (stuff, " valign=\"", 1023),
			gtk_entry_get_text (GTK_ENTRY (combo2->entry)),
			1023), "\"", 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (combo3->entry))))
    {
      strncat (strncat (strncat (stuff, " bgcolor=\"", 1023), converttohex
			(gtk_entry_get_text (GTK_ENTRY (combo3->entry))),
			1023), "\"", 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (spin2))))
    {
      temp = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin2));
      sprintf (tempstr, " width=\"%d\"", temp);
      strncat (stuff, tempstr, 1023);
    }
  strncat (stuff, ">", 1023);
  insert_text (stuff, "</table>");

  g_free (tempstr);
  destroy_dialog ();
}

void
tablerowdialogok (void)
{
  stuff = g_malloc (1024);

  strcpy (stuff, "<tr");

  if (strlen (gtk_entry_get_text (GTK_ENTRY (combo1->entry))))
    {
      strncat (strncat (strncat (stuff, " align=\"", 1023),
			gtk_entry_get_text (GTK_ENTRY (combo1->entry)),
			1023), "\"", 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (combo2->entry))))
    {
      strncat (strncat (strncat (stuff, " valign=\"", 1023),
			gtk_entry_get_text (GTK_ENTRY (combo2->entry)),
			1023), "\"", 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (combo3->entry))))
    {
      strncat (strncat (strncat (stuff, " bgcolor=\"", 1023), converttohex
			(gtk_entry_get_text (GTK_ENTRY (combo3->entry))),
			1023), "\"", 1023);
    }
  strncat (stuff, ">", 1023);
  insert_text (stuff, "</tr>");

  destroy_dialog ();
}

void
tableheaderdialogok (void)
{
  gchar *tempstr;
  gint temp;
  stuff = g_malloc (1024);
  tempstr = g_malloc (1024);

  strcpy (stuff, "<th");

  if (strlen (gtk_entry_get_text (GTK_ENTRY (spin1))))
    {
      temp = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin1));
      sprintf (tempstr, " width=\"%d\"", temp);
      strncat (stuff, tempstr, 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (spin3))))
    {
      temp = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin3));
      sprintf (tempstr, " height=\"%d\"", temp);
      strncat (stuff, tempstr, 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (spin2))))
    {
      temp = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin2));
      sprintf (tempstr, " colspan=\"%d\"", temp);
      strncat (stuff, tempstr, 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (spin4))))
    {
      temp = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin4));
      sprintf (tempstr, " rowspan=\"%d\"", temp);
      strncat (stuff, tempstr, 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (combo1->entry))))
    {
      strncat (strncat (strncat (stuff, " align=\"", 1023),
			gtk_entry_get_text (GTK_ENTRY (combo1->entry)),
			1023), "\"", 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (combo2->entry))))
    {
      strncat (strncat (strncat (stuff, " valign=\"", 1023),
			gtk_entry_get_text (GTK_ENTRY (combo2->entry)),
			1023), "\"", 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (combo3->entry))))
    {
      strncat (strncat (strncat (stuff, " bgcolor=\"", 1023), converttohex
			(gtk_entry_get_text (GTK_ENTRY (combo3->entry))),
			1023), "\"", 1023);
    }
  if (GTK_TOGGLE_BUTTON (checkbox1)->active)
    {
      strncat (stuff, " nowrap", 1023);
    }
  strncat (stuff, ">", 1023);
  insert_text (stuff, "</th>");

  g_free (tempstr);
  destroy_dialog ();
}

void
tabledatadialogok (void)
{
  gchar *tempstr;
  gint temp;
  stuff = g_malloc (1024);
  tempstr = g_malloc (1024);

  strcpy (stuff, "<td");

  if (strlen (gtk_entry_get_text (GTK_ENTRY (spin1))))
    {
      temp = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin1));
      sprintf (tempstr, " width=\"%d\"", temp);
      strncat (stuff, tempstr, 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (spin3))))
    {
      temp = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin3));
      sprintf (tempstr, " height=\"%d\"", temp);
      strncat (stuff, tempstr, 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (spin2))))
    {
      temp = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin2));
      sprintf (tempstr, " colspan=\"%d\"", temp);
      strncat (stuff, tempstr, 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (spin4))))
    {
      temp = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin4));
      sprintf (tempstr, " rowspan=\"%d\"", temp);
      strncat (stuff, tempstr, 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (combo1->entry))))
    {
      strncat (strncat (strncat (stuff, " align=\"", 1023),
			gtk_entry_get_text (GTK_ENTRY (combo1->entry)),
			1023), "\"", 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (combo2->entry))))
    {
      strncat (strncat (strncat (stuff, " valign=\"", 1023),
			gtk_entry_get_text (GTK_ENTRY (combo2->entry)),
			1023), "\"", 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (combo3->entry))))
    {
      strncat (strncat (strncat (stuff, " bgcolor=\"", 1023), converttohex
			(gtk_entry_get_text (GTK_ENTRY (combo3->entry))),
			1023), "\"", 1023);
    }
  if (GTK_TOGGLE_BUTTON (checkbox1)->active)
    {
      strncat (stuff, " nowrap", 1023);
    }
  strncat (stuff, ">", 1023);
  insert_text (stuff, "</td>");

  g_free (tempstr);
  destroy_dialog ();
}

void
framesetdialogok (void)
{
  gchar *tempstr;
  gint temp;
  stuff = g_malloc (1024);
  tempstr = g_malloc (1024);

  strcpy (stuff, "<frameset");

  if (strlen (gtk_entry_get_text (GTK_ENTRY (textentry1))))
    {
      strncat (strncat (strncat (stuff, " cols=\"", 1023),
			gtk_entry_get_text (GTK_ENTRY (textentry1)), 1023),
	       "\"", 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (textentry2))))
    {
      strncat (strncat (strncat (stuff, " rows=\"", 1023),
			gtk_entry_get_text (GTK_ENTRY (textentry2)), 1023),
	       "\"", 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (combo1->entry))))
    {
      if (!strncasecmp (gtk_entry_get_text (GTK_ENTRY (combo1->entry)),
			"yes", 32))
	{
	  strncat (stuff, " frameborder=\"1\"", 1023);
	}
      else if (!strncasecmp (gtk_entry_get_text (GTK_ENTRY (combo1->entry)),
			     "no", 32))
	{
	  strncat (stuff, " frameborder=\"0\"", 1023);
	}
      else
	{
	  strncat (strncat (strncat (stuff, " frameborder=\"", 1023),
			    gtk_entry_get_text (GTK_ENTRY (combo1->entry)),
			    1023), "\"", 1023);
	}
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (spin1))))
    {
      temp = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin1));
      sprintf (tempstr, " framespacing=\"%d\"", temp);
      strncat (stuff, tempstr, 1023);
    }
  strncat (stuff, ">", 1023);
  insert_text (stuff, "\n\n</frameset>");

  g_free (tempstr);
  destroy_dialog ();
}

void
framedialogok (void)
{
  gchar *tempstr;
  gint temp;
  stuff = g_malloc (1024);
  tempstr = g_malloc (1024);

  strcpy (stuff, "<frame");

  if (strlen (gtk_entry_get_text (GTK_ENTRY (textentry1))))
    {
      strncat (strncat (strncat (stuff, " src=\"", 1023), gtk_entry_get_text
			(GTK_ENTRY (textentry1)), 1023), "\"", 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (textentry2))))
    {
      strncat (strncat (strncat (stuff, " name=\"", 1023),
			gtk_entry_get_text (GTK_ENTRY (textentry2)), 1023),
	       "\"", 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (combo1->entry))))
    {
      if (!strncasecmp (gtk_entry_get_text (GTK_ENTRY (combo1->entry)),
			"yes", 32))
	{
	  strncat (stuff, " frameborder=\"1\"", 1023);
	}
      else if (!strncasecmp (gtk_entry_get_text (GTK_ENTRY (combo1->entry)),
			     "no", 32))
	{
	  strncat (stuff, " frameborder=\"0\"", 1023);
	}
      else
	{
	  strncat (strncat (strncat (stuff, " frameborder=\"", 1023),
			    gtk_entry_get_text (GTK_ENTRY (combo1->entry)),
			    1023), "\"", 1023);
	}
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (combo2->entry))))
    {
      strncat (strncat (strncat (stuff, " scrolling=\"", 1023),
			gtk_entry_get_text (GTK_ENTRY (combo2->entry)),
			1023), "\"", 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (spin1))))
    {
      temp = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin1));
      sprintf (tempstr, " marginwidth=\"%d\"", temp);
      strncat (stuff, tempstr, 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (spin2))))
    {
      temp = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin2));
      sprintf (tempstr, " marginheight=\"%d\"", temp);
      strncat (stuff, tempstr, 1023);
    }
  if (strlen (gtk_entry_get_text (GTK_ENTRY (spin3))))
    {
      temp = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin3));
      sprintf (tempstr, " framespacing=\"%d\"", temp);
      strncat (stuff, tempstr, 1023);
    }
  if (GTK_TOGGLE_BUTTON (checkbox1)->active)
    {
      strncat (stuff, " noresize", 1023);
    }
  strncat (stuff, ">", 1023);
  insert_text (stuff, "");

  g_free (tempstr);
  destroy_dialog ();
}

GtkWidget *
color_but_new (GtkCombo * which_combo)
{

  GtkWidget *pixmap, *color_but;

  color_but = gtk_button_new ();
  pixmap = new_pixmap (176, dialog->window, NULL);
  gtk_widget_show (pixmap);
  gtk_container_add (GTK_CONTAINER (color_but), pixmap);
  gtk_signal_connect (GTK_OBJECT (color_but), "clicked",
		      color_but_clicked, which_combo);
  gtk_widget_show (color_but);
  return color_but;
}

void
color_but_clicked (GtkWidget * widget, GtkWidget * combo)
{

  gchar *tmpstring;

#ifdef DEBUG
  g_print ("color_but_clicked, before return_color\n");
#endif
  tmpstring = return_color ();
#ifdef DEBUG
  g_print ("color_but_clicked, return_color=%s\n", tmpstring);
#endif
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (combo)->entry), tmpstring);
  g_free (tmpstring);

}

GtkWidget *
file_but_new (GtkWidget * which_entry)
{

  GtkWidget *pixmap, *file_but;

  file_but = gtk_button_new ();
  pixmap = new_pixmap (177, dialog->window, NULL);
  gtk_widget_show (pixmap);
  gtk_container_add (GTK_CONTAINER (file_but), pixmap);
  gtk_signal_connect (GTK_OBJECT (file_but), "clicked",
		      file_but_clicked, which_entry);
  gtk_widget_show (file_but);
  return file_but;
}

void
file_but_clicked (GtkWidget * widget, GtkWidget * which_entry)
{
  gchar *tmpstring, *tmp2string;;

  tmpstring = return_file ();
  if (tmpstring != NULL)
    {
      if (current_document->filename != NULL)
	{
	  tmp2string = strip_common_path (tmpstring, current_document->filename);
	  g_free (tmpstring);
	  tmpstring = tmp2string;
	}
      gtk_entry_set_text (GTK_ENTRY (which_entry), tmpstring);
      g_free (tmpstring);
    }
}

gchar *
return_file ()
{

  GtkWidget *fs;
  gchar *tmp;

  fs = gtk_file_selection_new ("Select file");

  gtk_signal_connect (GTK_OBJECT (fs), "destroy", close_modal_window, fs);
  /* Connect the ok_button to file_ok_sel function */
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (fs)->ok_button),
		      "clicked", (GtkSignalFunc) modal_fs_ok_clicked, fs);
  /* Connect the cancel_button to destroy the widget */
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (fs)->cancel_button),
		      "clicked", (GtkSignalFunc) close_modal_window,
		      GTK_OBJECT (fs));
  gtk_widget_show (fs);
  gtk_grab_add (GTK_WIDGET (fs));
  gtk_main ();
  tmp = filename_to_return;
  filename_to_return = NULL;
  return tmp;
}

void
modal_fs_ok_clicked (GtkWidget * widget, gpointer window)
{
  filename_to_return = g_malloc (strlen (gtk_file_selection_get_filename
					 (GTK_FILE_SELECTION (window))) + 1);
  strcpy (filename_to_return, gtk_file_selection_get_filename
	  (GTK_FILE_SELECTION (window)));
  gtk_main_quit ();
  gtk_grab_remove (GTK_WIDGET (window));
  gtk_signal_handlers_destroy (window);
  gtk_widget_destroy (GTK_WIDGET (window));
}

void
close_modal_window (GtkWidget * widget, gpointer window)
{
  if (filename_to_return != NULL)
    {
      g_free (filename_to_return);
      filename_to_return = NULL;
    }
  gtk_main_quit ();
  gtk_grab_remove (GTK_WIDGET (window));
  gtk_signal_handlers_destroy (window);
  gtk_widget_destroy (GTK_WIDGET (window));
}
