;XC1701 v1.3 - Happy Birthday edition!
;(C) 1996 by Andreas Ess
;
;Hello world,
;Finally, the source code to my first game.
;
;Why did I do this now? Because:
; a) it's ZShell birthday
; b) there are less programmers for ZShell than ever(I think), and I want
;    YOU to program fantastic games, and this may be a good start or help you.
; c) Please encourage the others, too, to program for ZShell
;
;A few notes:
; * The source isn't that good commented
; * Some passages aren't optimized very well
; * This code uses INTEL.H & FASTCALL.H & GCP.H by me.
; * Thanks to Rob Taylor for Gray4Lib
; * GrFlag is from the 3-grayscale version; now it's used as a kind of random
;   number - replace it by register R
;Hope you can use it - it's for teaching purposes only.
;If you modify the code and want to re-release it, then contact me first.
;If you use a major portion of it, please give me a credit.
;Questions -> ess.andreas@computerhaus.at
;
; Andreas

#INCLUDE "TI-85.H"
#INCLUDE "INTEL.H"

#DEFINE PROM_CALL(index)  ld ($8A40),a \ ld a,index \ call $8C0F \ .dw ROMC

;
;Variables needed by GreyLib (C) by Rob Taylor:
;
Count = $8980
CurrPage = $8981

Page1 = $8982
Page2 = $8983
PageA = $8984
PageB = $8985
PageC = $8986
PageD = $8987

Page1Addr = $8988
Page2Addr = $898A
PageAAddr = $898C
PageBAddr = $898E
PageCAddr = $8990
PageDAddr = $8992

LEVELSIZE = 148

;Variables in Textmemory:
BkY    = 	TEXT_MEM    ;X Position of background
BkX    = 	TEXT_MEM+1  ;Y Position of background
Level  = 	TEXT_MEM+2  ;Level number
LvlPt  = 	TEXT_MEM+3  ;Pointer to level
ESPt1  = 	TEXT_MEM+5  ;Pointer to 1st enem ship
ESPt2  = 	TEXT_MEM+7  ;Pointer to 2nd enem ship
ESPt3  = 	TEXT_MEM+9  ;Pointer to 3rd enem ship
BkPt   = 	TEXT_MEM+11 ;Pointer to background
GrFlag = 	TEXT_MEM+13 ;Grey flag: 0 = draw first bitmap of all fig's else second one
InfoCount = 	TEXT_MEM+14 ;Counter how long the info shows ('LEVEL 1')
EnemX  = 	TEXT_MEM+16 ;An array(length 10) containing X pos. of Enem's
EnemY  = 	TEXT_MEM+26 ;An array containing Y pos. of Enem's
NumEnem = 	TEXT_MEM+36 ;Number of enems on screen
LvlY = 		TEXT_MEM+37 ;Y Position in Level
Count1 = 	TEXT_MEM+38 ;Counter
Life = 		TEXT_MEM+39 ;Lifes
Score = 	TEXT_MEM+40 ;Score - needs 2 Bytes
EnemStat = 	TEXT_MEM+42 ;Status of each enem
EnemType = 	TEXT_MEM+52 ;Type of each enem
TempByte = 	TEXT_MEM+62 ;Temporary Byte for Drawsprite
ShootX = 	TEXT_MEM+63 ;X position of ship's shoots(10)
ShootY = 	TEXT_MEM+73 ;Y   - " -
StringPlace = 	TEXT_MEM+83 ;Used when writing decimal numbers
ZeroByte = 	TEXT_MEM+88 ;This byte must contain zero(->ASCIIZ-Str StringPlace)
EnemSX = 	TEXT_MEM+89 ;Shoot-X of enemy
EnemSY = 	TEXT_MEM+92 ;Shoot-Y of enemy
ShipY = 	TEXT_MEM+95 ;Player's x position
ShipX = 	TEXT_MEM+96 ;Player's y position
ExplX =         TEXT_MEM+97 ;Explosion X(3 max. at once)
ExplY = 	TEXT_MEM+100 ;Explosion Y
ExplS = 	TEXT_MEM+103 ;Explosion status
StarX = 	TEXT_MEM+106 ;11 Stars flying around...
StarY = 	TEXT_MEM+117 ;Y Position of these stars...
BossLvl = 	TEXT_MEM+128 ;Is this a boss level? (0/1,2,3,4)
InfoPt = 	TEXT_MEM+129 ;This points either to "STAGE" or "BOSS"
BossLvlS = 	TEXT_MEM+131 ;This saves the boss level
BossPt = 	TEXT_MEM+132 ;Pointer to Bosspicture
BossLife = 	TEXT_MEM+134 ;Power of the boss
Width = 	TEXT_MEM+135 ;Width of enemy; needed for collision detection
LogPt = 	TEXT_MEM+136 ;Pointer to Boss-Logic
CONT = 		TEXT_MEM+138 ;Contrast
DelayTime =     TEXT_MEM+139 ;How long to delay
AsterC =        TEXT_MEM+141 ;How long asteroids are in the field
NewBonus =      TEXT_MEM+143 ;Counts down until 0 -> new bonus
BonusType =     TEXT_MEM+144 ;1 = SHOOT, 2 = LIFE, 3 = MEGA BOMB, 4 = INVICIBILITY
BonusY =        TEXT_MEM+145
GotShootBonus = TEXT_MEM+146
DoEnemNo =      TEXT_MEM+147 ;-> level saved until here
Temp = 		TEXT_MEM+150
HiScoreTemp = 	TEXT_MEM+152
FlickerCount = 	TEXT_MEM+154 ;Counter of flickering(=invicible)
;And a few bytes & words for version 1.1:
AsteroidHit =   TEXT_MEM+155
DelayTimeB =    TEXT_MEM+156

;
;VARIABLES IN TEXTMEM2 - USED FOR FUNCTIONS ONLY:
;
HelpAddr = TEXT_MEM2   ;needed for GSprite; position in page
TempByte = TEXT_MEM2+2 ;needed for GSprite; line counter
Column   = TEXT_MEM2+3 ;needed for DrawBSprite
Color    = TEXT_MEM2+4
Data     = TEXT_MEM2+5
KEYPRESS = TEXT_MEM2+6

.org 0
.db "XC-1701 V1.3h BY AE",0

Start:
 CALL_(PrepFastCall)

 xor  a
 mov  (DoEnemNo), a

 ld   a, (CONTRAST)
 ld   (CONT), a
 ld   a, 4          ;set memory page 4 (graphic routines are here)
 out  (5), a        ;needed if FIND_PIXEL is going to be used
 ld   hl, ZS_BITS
 set  0, (hl)       ;Tell ZShell to update me....
 res  1, (IY+$0D)   ;don't affect text-memory!
 CALL_(GrayScaleOn)
 jr   nc, ProgStart
 ld   hl, (PROGRAM_ADDR)
 ld   de, GreyError
 add  hl, de
 ROM_CALL(D_ZT_STR)
WaitErrExit:
 ld   a, (KEY_1)
 cp   K_EXIT
 jr   nz, WaitErrExit
 ret

ProgStart:
 CALL_(Swap_Screens)
 CALL_(ClrScr)
 mov  hl, $0600
 mov  (DelayTime), hl
 lea(TitlePic)
 mov  bc, 0
 CALL_(DeGCP)
P1_ShowAct: call ShowAct
 ;Show hi-score
 set  3, (IY+05)    ;XOR character with current screen
 ld   hl, $3240
 ld   ($8333), hl
 ld   hl, (PROGRAM_ADDR)
 ld   de, ByStr
 add  hl, de
 PROM_CALL(D_ZM_STR)
 ld   hl, (PROGRAM_ADDR)
 ld   de, HiScore
 add  hl, de
 call LD_HL_MHL
 CALL_(HL_DECIMAL_MENU)

NoKeyLoop:
 ld   a, (KEY_1)
 and  a
 jr   nz, NoKeyLoop

KeyLoop:
 ld   a, (KEY_1)
 and  a
 jr   z, KeyLoop

 res  3,(IY+05)   ;print character over current screen

;-- So, now to the options screen; scroll title up first:

 ld   b, 64
ScrollUpL:
 push bc
 ld   hl, VIDEO_MEM+16
 ld   de, VIDEO_MEM
 ld   bc, 1008
 ldir
 CALL_(Delay)
 ;Clear line
 ld   hl, VIDEO_MEM+1008
 xor  a
 ld   b, 16
ClearLineL:
 ld   (hl), a
 inc  hl
 djnz ClearLineL
 pop  bc
 djnz ScrollUpL

;-- Now display options:
 ld   hl, $011C
 ld   de, TheOption
 CALL_(DisplayText)
 ld   hl, $1020
 ld   de, Option1
 CALL_(DisplayText)
 ld   hl, $1720
 ld   de, Option2
 CALL_(DisplayText)
 ld   hl, $1E20
 ld   de, Option3
 CALL_(DisplayText)
 CALL_(DisplayText)
 ld   hl, $2420
 ld   de, Option4
 CALL_(DisplayText)

WaitForNoKey:
 ld   a, (KEY_1)
 and  a
 jr   nz, WaitForNoKey

OptionKey:
 ld   a, (KEY_1)
 cp   $35              ;F1 key pressed?
 jr   z, NormalGame
 cp   $34	       ;F2 full speed mode!
 jr   z, NormalGameS
 cp   $33              ;F3 key -> load game
 jr   z, LoadGame
 cp   $37	       ;What? You want to exit?
 JUMP_Z(ExitGame)
 jr   OptionKey

LoadGame:
 ;Is there a saved game?
 ld   hl, (PROGRAM_ADDR)
 ld   de, GameSaved
 add  hl, de
 ld   a, (hl)
 and  a
 jr   z, NormalGame
 inc  hl
 ld   bc, LEVELSIZE
 ld   de, TEXT_MEM
;DE contains destination, HL source and BC bytes to transfer
 ldir
 CALL_(ClrScr)
 ld   bc, (ShipY)        ;Very important... loads word
 ld   a, 10              ;Make ship invicible for 10 game loops
 ld   (FlickerCount), a
 ;So, jump to game loop
J1_GameLoop: jp   GameLoop
NormalGameS:
 ld   hl, 0
 ld   (DelayTime), hl
NormalGame:           ;start game as usual

WaitForNoKey1:
 ld   a, (KEY_1)
 and  a
 jr   nz, WaitForNoKey1

 ;General initialisation:
 ;Load random number into StarX & StarY
 ld   bc, 22
 ld   hl, (PROGRAM_ADDR)
 ld   de, RStarX
 add  hl, de
 ld   de, StarX
 ldir
 ;Set levels...
 xor  a
 ld   (Level), a
 ld   a, 10
 ld   (NewBonus), a
 ld   a, 6
 ld   (Life), a
 ld   hl, (PROGRAM_ADDR)
 ld   de, Level1-1
 add  hl, de
 ld   (LvlPt), hl
 ld   hl, (PROGRAM_ADDR)
 ld   de, Planet1-16           ;First bk-pic
 add  hl, de
 ld   (BkPt), hl
 ;first enemies:
 ld   hl, (PROGRAM_ADDR)
 ld   de, GShip1-48
 add  hl, de
 ld   (ESPt1), hl
 ld   hl, (PROGRAM_ADDR)
 ld   de, DShip1-48
 add  hl, de
 ld   (ESPt2), hl
 ld   hl, (PROGRAM_ADDR)
 ld   de, Glider1-48
 add  hl, de
 ld   (ESPt3), hl

StartLevel:
 CALL_(ClrScr)

 mov  hl, EnemX
 mov  d, h
 mov  e, l
 inc  de
 mov  (hl), 0
 mov  bc, 19
 ldir

 mov  hl, EnemStat
 mov  d, h
 mov  e, l
 inc  de
 mov  (hl), 0
 mov  bc, 19
 ldir

 mov  hl, ShootX
 mov  d, h
 mov  e, l
 inc  de
 mov  (hl), 0
 mov  bc, 19
 ldir

 mov  hl, EnemSX
 mov  d, h
 mov  e, l
 inc  de
 mov  (hl), 0
 mov  bc, 17
 ldir

 xor  a
 ld   (Count1), a
 ld   (NumEnem), a
 ld   (InfoCount), a
 ld   (LvlY), a
 ld   (BossLvl), a
 ld   b, 60
 ld   c, 40
 ld   hl, $0B03
 ld   (BkY), hl

 ld   hl, (BkPt)
 ld   de, $0010          ;next bk-picture
 add  hl, de
 ld   (BkPt), hl

 ld   de, 48
 ld   hl, (ESPt1)
 add  hl, de
 ld   (ESPt1), hl
 ld   hl, (ESPt2)
 add  hl, de
 ld   (ESPt2), hl
 ld   hl, (ESPt3)
 add  hl, de
 ld   (ESPt3), hl

 ld   a, (Level)
 inc  a
 ld   (Level), a

 ld   a, 9
 ld   (Width), a

 ld   hl, (PROGRAM_ADDR)
 ld   de, Stage
 add  hl, de
 ld   (InfoPt), hl
 ld   hl, 65535     	;this is the flag if there's no asteroid
 ld   (AsterC), hl

;-----------------------------------------------------------------------------
;Here's the game loop:
;-----------------------------------------------------------------------------
GameLoop:
 CALL_(ClrScr)
L1_You: mov  ix, You1          ;standard
 mov  a, $3E
 out  (1), a
 in   a, (1)
 and  a
 JUMP_Z(Redraw)
 ld  (KEYPRESS), a
 and 1                   ;only the 0th bit
 jr  nz, NextK1
 ld  a, c         ;move ship down
 cp  50           ;at the bottom already
 jr  z, NextK1
 inc c
NextK1:           ;test left key
 ld  a, (KEYPRESS)
 and 2
 jr  nz, NextK2
 ld  a, b
 cp  1
 jr  z, NextK2
 dec b
L1_YouLeft: ld ix, YouLeft
NextK2:           ;test right key
 ld  a, (KEYPRESS)
 and 4
 jr  nz, NextK3
 ld  a, b
 cp  119
 jr  z, NextK3
 inc b
L1_YouRight: ld ix, YouLeft
NextK3:            ;test up key
 ld  a, (KEYPRESS)
 and 8
 jr  nz, NextK4
 ld  a, c
 cp  16
 jr  z, NextK4
 dec c
NextK4:       ;test 2nd key
 ld  a, (KEYPRESS)
 and 32
 jr  nz, NextK5
 ;Start shoot
 push bc
 ld  b, 10
 ld  hl, ShootX-1
ShootLoop:
 inc hl
 ld  a, (hl)
 and a
 jr  z, SetShoot
 djnz ShootLoop
 pop bc
 JUMP_(NextK5)

SetShoot:
 pop  bc
 mov  a, (GotShootBonus)
 and  a
 jz   NormalShootStart
 ld  a, b       ;x-pos of shoot in middle of ship
 add a, 1
 ld  (hl), a    ;save x-pos
 ld  d, 0       ;add 10 bytes to x-pos -> ypos
 ld  e, 10
 add hl, de
 ld  a, 64
 sub c
 ld  (hl), a    ;save y-pos
 ;This was the first shoot, now the second:
 push bc
 ld  b, 10
 ld  hl, ShootX-1
ShootLoop1:
 inc hl
 ld  a, (hl)
 and a
 jr  z, SetShoot1
 djnz ShootLoop1
 pop bc
 jr  NextK5

SetShoot1:
 pop  bc
 ld   a, b
 add  a, 7
 jr   SaveNormalX
NormalShootStart:
 ld  a, b       ;x-pos of shoot in middle of ship
 add a, 3
SaveNormalX:
 ld  (hl), a    ;save x-pos
 ld  d, 0       ;add 10 bytes to x-pos -> ypos
 ld  e, 10
 add hl, de
 ld  a, 64
 sub c
 ld  (hl), a    ;save y-pos

NextK5:         ;test EXIT key
 ld  a, (KEYPRESS)
 and 64
 JUMP_Z(ExitGame)
NextK6:         ;test MORE key
 ld  a, $3E
 out (1), a
 in   a, (1)
 and 128
 JUMP_Z(Pause)
NextK7:         ;and now a very important key: the teacher-key!
 ld   a, $3F
 out  (1), a
 in   a, (1)
 and  16
 JUMP_Z(LSaveGame)


Redraw:                ;Redraws your ship
 mov  a, (BossLvl)      ;Boss no. 1 can affect the position of the ship...
 cmp  1
 jnz  Redraw1
 mov  a, (GrFlag)
 and  a
 jz   Redraw1
 mov  a, (EnemY)
 add  a, 20
 cmp  c
 jnc  Redraw1
 dec  c                ;move ship towards boss...
MoveLR:
 ld  a, (EnemX)
 cp  b
 jr  c, MoveLeft
 inc b
 jr  DidPHit
MoveLeft:
 dec b
DidPHit:
 ld  h, b
 ld  l, c
 ld  a, (EnemX)
 ld  d, a
 ld  a, (EnemY)
 ld  e, a
 CALL_(ShootCollision)
 jr  nc, Redraw1
 push bc
 push de
 push hl
 ld   b, 1
 JUMP_(RemovePlayer)
Redraw1:
 mov  a, (FlickerCount)
 and  a
 jz   ReallyRedraw
 dec  a
 mov  (FlickerCount), a
 and  1
 jz   HandleShoot
ReallyRedraw:
 mov  (ShipY), bc
P1_Bitmap: call Bitmap

 ;Handle shoots only if there are no asteroids:
HandleShoot:
 mov  de, (AsterC)
 mov  hl, 65535
 and  a
 sbc  hl, de
 JUMP_NZ(HandleAster)

 push bc               ;Draw shoot
 mov  b, 10
 mov  hl, ShootX-1
 mov  de, ShootY-1
ShootDrLoop:
 inc  hl
 inc  de
 mov  a, (hl)       ;load x position of current shoot into a
 and  a
 JUMP_Z(EndDrLoop)

 mov  a, (de)
 mov  c, a
 inc  c
 inc  c
 inc  c
 ex   de, hl        ;}save y=c
 ld   (hl), c       ;}into de
 ex   de, hl        ;}
 mov  a, c          ;load y=c into a
 cmp  60            ;}if y>=60
 JUMP_NC(SetShoot0) ;} erase shoot
 mov  a, (hl)       ;load x position again into a
P1_PointOn: call PointOn  ;and switch point on
 inc  c
 mov  a, (hl)
P2_PointOn: call PointOn
;So, before the loop ends, the COLLISION DETECTION!
 push de
 push hl           ;save hl & de
 mov  a, (hl)       ;x position into h,
 mov  h, a          ;y position into l
 mov  l, c
 mov  a, 64
 sub  l
 mov  l, a
 mov  c, 0       ;loop 10 times
CollDectLoop:
 push hl        ;save hl on stack
 ld  d, 0
 ld  e, c       ;number of enem
 ld  hl, EnemType
 add hl, de
 ld  a, (hl)
 and a
 JUMP_Z(CollDectLoopAg)
 ld  hl, EnemX  ;get EnemX -> a
 add hl, de
 ld  a, (hl)
 ld  hl, EnemY  ;get EnemY
 add hl, de
 ld  d, a       ;and store them into de
 ld  e, (hl)
 pop hl         ;get hl from stack
 ;Now: H - xpos of shoot
 ;     L - ypos of shoot
 ;     D - xpos of enem(c)
 ;     E - ypos of enem(c)
 CALL_(ShootCollision)
 jr  c, RemoveSAS ;so RemoveSAS
 inc c            ;increment loop counter
 ld  a, c
 cp  10               ;already 10?
 JUMP_Z(GotoEndDrLoop);yes, EndDrLoop
 jr  CollDectLoop
RemoveSAS: ;"Remove Shoot and Ship"
 ld  a, (BossLvl)
 and a
 jr  nz, HitBoss
 push hl
 ld  hl, (Score)    ;increase score
 ld  de, $0090
 add hl, de
 ld  (Score), hl
P1_Status: call StatusLine
 mov  a, (NewBonus)
 dec  a
 mov  (NewBonus), a
 jnz  RemoveSAS1
 mov  a, 20
 mov  (NewBonus), a
 mov  a, (Count1)
 and  03h
 inc  a
 mov  (BonusType), a
 mov  a, 1
 mov  (BonusY), a
RemoveSAS1:
 ld  hl, EnemType
 ld  d, 0
 ld  e, c
 add hl, de
 ld  (hl), 0       ;Ship removed
 ld  a, (NumEnem)
 dec a
 ld  (NumEnem), a
 push bc
 ld  hl, EnemX
 add hl, de
 ld  a, (hl)
 ld  b, a
 ld  hl, EnemY
 add hl, de
 ld  a, (hl)
 ld  c, a
 CALL_(SetExplosion)
 pop bc
 pop hl
 jr  AfterHitBoss
HitBoss:
 push bc
 ld  a, (EnemX)
 add a, 12
 ld  b, a
 ld  a, (EnemY)
 add a, 12
 ld  c, a
 CALL_(SetExplosion)
 pop bc
 ld  a, (BossLife)
 dec a
 ld  (BossLife), a
 jr  nz, AfterHitBoss
 pop hl
 pop de
 ld  hl, (Score)
 ld  de, $00C0
 add hl, de
 ld  (Score), hl
 ld  a, (Life)
 inc a
 ld  (Life), a
 JUMP_(NextLevel)
AfterHitBoss:
 pop hl
 pop de
 push de
 push hl
 push bc
 ;Erase shoot:
 xor a
 ld  (hl), a
 pop bc
 inc c
 ld  a, c
 cp  10
 JUMP_NZ(CollDectLoop)
 pop hl
 pop de
 jr  EndDrLoop
GotoEndDrLoop:
 pop hl
 pop de
 jr  EndDrLoop
CollDectLoopAg:
 pop hl
 inc c            ;increment loop counter
 ld  a, c
 cp  10               ;already 10?
 jr  z, GotoEndDrLoop ;yes, EndDrLoop
 JUMP_(CollDectLoop)
SetShoot0:
 xor a             ;place 0 into
 ld  (hl), a       ;shoot's x position
EndDrLoop:
 dec b
 JUMP_NZ(ShootDrLoop)  ;loop

;Now handle background...
 ld   bc, (BkY)
 inc  c
 ld   a, c
 cp   57
 jr   nc, NewBkPos
 ld   (BkY), a
 jr   DrawBk
NewBkPos:
 ld   c, 1
 ld   a, r
 and  00111111b
 add  a, 20
 ld   b, a
 ld   (BkY), bc
DrawBk:
 ld   ix, (BkPt)
P2_Bitmap: call Bitmap

 ld   a, (BossLvl)
 and  a
 JUMP_NZ(LblDoBoss)

;Handle enemies/asteroids(v1.1):
 ld   a, (Count1)
 and  a
 jr   nz, IncCount
 ld   a, (LvlY)     ;load Y position in Level
 inc  a             ;increment it and
 ld   (LvlY), a     ;save it
 cp   32            ;A level contains 32 Lines
 jr   nz, ChangeLvlPt
 ld   hl, (DelayTime)
 ld   a, h
 or   l
 jr   z, StartAsteroid
 JUMP_(NextLevel)   ;new level!
StartAsteroid:
 ld   hl, 512
 ld   (AsterC), hl  ;about 8 screens of asteroids!
 CALL_(ClrScr)
 CALL_(InitAster)
 pop  bc
 JUMP_(HandleAster)
ChangeLvlPt:
 ld   hl, (LvlPt)   ;Load Levelpointer
 inc  hl            ;next line
 ld   (LvlPt), hl   ;save Levelpointer
 ld   a, (hl)       ;now init enemies(00-no enem 01-glider 02-defender 03-offend)
 and  192           ;load 7th & 6th bit
 rlc  a
 rlc  a
 ld   b, 1         ;set pos. 1
 CALL_(InitEnem)  ;now init this enem: a contains num, b contains pos / 32
 ld   a, (hl)      ;second enemy
 and  48           ;load 5th & 4th bit
 srl  a
 srl  a
 srl  a
 srl  a
 ld   b, 2         ;set pos. 32
 CALL_(InitEnem)
 ld   a, (hl)     ;third enemy
 and  12          ;load... right! 3rd & 2nd bit
 srl  a           ;two shifts are not enough to call Shiftright
 srl  a
 ld   b, 3        ;set pos. 64
 CALL_(InitEnem)
 ld   a, (hl)     ;last enemy
 and  3           ;load... 1st and ... 0th bit
 ld   b, 4        ;set pos. 96
 CALL_(InitEnem)
 ld   a, (Count1)
 ;hey, that was hard work!?

IncCount:
 inc a
 cp  31
 jr  nz, UpdateCount
 xor a
UpdateCount:
 mov (Count1), a

;Do enemies:
 mov  b, 10
EnemDoLoop:
 mov  d, 0
 mov  e, b            ;} save enemtype
 mov  hl, EnemType-1  ;} into h
 add  hl, de          ;}
 mov  a, (hl)
 and  a
 jz   LoopEnemDo
 mov  h, a
 dec  e
 mov  l, e
 mov  a, (FlickerCount)
 and  a
 jnz  NoCollTest
 push bc
 push hl
 mov  bc, (ShipY)
 mov  hl, EnemX-1
 add  hl, de
 mov  a, (hl)
 mov  de, 10
 add  hl, de
 mov  e, (hl)
 mov  h, a
 mov  l, e
 CALL_(BitmapInter)
 pop  hl
 pop  bc
 jc   CollisionShip
NoCollTest:
 mov  a, (DoEnemNo)
 and  a
 jnz  EnemDoLoop_2
 CALL_(DoEnem1)
LoopEnemDo:
 loop EnemDoLoop
 jmp  MissileLabel
EnemDoLoop_2:
 CALL_(DoEnem2)
 loop EnemDoLoop
 jmp  MissileLabel

CollisionShip:
 mov  a, (Life)
 dec  a
 mov  (Life), a
P2_Status: call StatusLine
 mov  a, (Life)
 and  a
 jz   Collision_GameOver
 mov  a, 30
 mov  (FlickerCount), a
 mov  bc, $3C28
 mov  (ShipY), bc
 jmp  EnemDoLoop
Collision_GameOver:
 pop  bc
 JUMP_(GameOver)

LblDoBoss:
 CALL_(DoBoss)
 ld   a, (Count1)
 inc  a
 ld   (Count1), a
 cp   15
 jr   nz, MissileLabel
 xor  a
 ld   (Count1), a

;So, now handle missiles of enemies...
MissileLabel:
 ld   b, 3
 ld   hl, EnemSX-1
 ld   de, EnemSY-1
DoMiss:
 inc  hl       ;Next missile
 inc  de
 ld   a, (hl)  ;Missile active?
 and  a
 JUMP_Z(EndMissLoop)

 mov  a, (de)
 mov  c, a
 dec  c
 dec  c

 ld   a, c          ;load y=c into a
 ex   de, hl        ;}save y=c=a
 ld   (hl), a       ;}into de
 ex   de, hl        ;}
 cmp  8             ;}if y<=8
 JUMP_C(SetMiss0)   ;} erase shoot

 ld  a, (hl)       ;load x position again into a
P3_PointOn: call PointOn    ;set point 1
 inc c
 ld  a, (hl)       ;ld x position again into a
 dec a
P4_PointOn: call PointOn    ;set point 2
 ld  a, (hl)       ;ld x position again into a
 inc a
P5_PointOn: call PointOn    ;set point 3
 ld  a, (hl)       ;ld x position again into a
 inc c
P6_PointOn: call PointOn    ;set point 3
;So, before the loop ends, the COLLISION DETECTION!
 push de
 push hl           ;save hl & de
 ld  a, (hl)       ;x position into h,
 ld  h, a          ;y position into l
 ld  a, c
 ld  l, a
 inc l
 inc l
 ld  a, 64
 sub l
 ld  l, a
 ld  c, 0       ;loop 3 times
MissDectLoop:
 ld  de, (ShipY)
 ;Now: H - xpos of missile
 ;     L - ypos of missile
 ;     D - xpos of player
 ;     E - ypos of player
 CALL_(MissCollision)
 jr  c, RemovePlayer ;so remove the player
 inc c               ;increment loop counter
 ld  a, c
 cp  3               ;already 3?
 jr  nz, MissDectLoop
 jr  GotoEndMissLoop ;yes, EndDrLoop
RemovePlayer:
 ld  a, (FlickerCount)
 and a
 jr  nz, GotoEndMissLoop
 ld  a, (Life)
 dec a
 ld  (Life), a
P3_Status: call StatusLine
 jr  nz, RemovePlayer1
 pop hl
 pop de
 pop bc
 JUMP_(GameOver) ;Game over man!
RemovePlayer1:
 ld  a, 30
 ld  (FlickerCount), a
 ex  de, hl
 pop hl
 push hl
 ld  (hl), 0
 ex  de, hl
 push bc
 ld   de, (ShipY)
 CALL_(SetExplosion)
 ld   bc, $3C28
 ld   (ShipY), bc
 pop  bc
 inc c            ;increment loop counter
 ld  a, c
 cp  3            ;already 3?
 jr  nz, MissDectLoop;no, loop again
GotoEndMissLoop:
 pop hl
 pop de
 jr  EndMissLoop
SetMiss0:
 xor a
 ld  (hl), a
EndMissLoop:
 dec b
 JUMP_NZ(DoMiss)  ;loop
 JUMP_(DoTheOtherStuff)

;-- Handle the asteroid field:

HandleAster:
 push bc
 CALL_(DoAster)
;Did an Asteroid hit the Player?
 and  a
 jr   z,  DecAsterC        ;no
 ld   a, (FlickerCount)
 and  a
 jr   nz, DecAsterC         ;yes, but ship is invicible
 ld   a, (Life)
 dec  a
 ld   (Life), a
P4_Status: call StatusLine
 jr   nz, RemovePlayerA
 pop  bc
 JUMP_(GameOver) ;Game over man!
RemovePlayerA:
 mov  a, 30
 mov  (FlickerCount), a
 ld   bc, (ShipY)
 CALL_(SetExplosion)
 ld   bc, $3C28
 ld   (ShipY), bc

DecAsterC:
 mov  hl, (AsterC)
 dec  hl
 mov  (AsterC), hl
 mov  a, (AsterC)
 and  a
 JUMP_Z(NextLevel)

;-- Do explosions:
DoTheOtherStuff:
 CALL_(DoExplosion)
;-- Bonusboxes:
 mov  a, (BonusY)
 and  a
 JUMP_Z(DoStars)
 mov  de, (PROGRAM_ADDR)
 mov  b, 64
 mov  c, a
 mov  a, (BonusY)
 inc  a
 mov  (BonusY), a
 mov  c, a
 cmp  56
 jnz  DoBonus1
 xor  a
 mov  (BonusY), a
 mov  (BonusType), a
 jmp  DoStars
DoBonus1:
 mov  a, (BonusType)
 cmp  2
 jz   BonusType2
 cmp  3
 jz   BonusType3
 cmp  4
 jz   BonusType4
 mov  ix, Bonus10
 jmp  DrawBonus
BonusType2:
 mov  ix, Bonus20
 jmp  DrawBonus
BonusType3:
 mov  ix, Bonus30
 jmp  DrawBonus
BonusType4:
 mov  ix, Bonus40
DrawBonus:
 add  ix, de
P3_Bitmap: call Bitmap
 ld   hl, (ShipY)
 CALL_(BitmapInter)
 jnc  DoStars
 xor  a
 mov  (GotShootBonus), a
 xor  a
 mov  (BonusY), a
 mov  a, (BonusType)
 cmp  1
 jz   SwitchShoot
 cmp  3
 jz   MegaBomb
 cmp  4
 jz   Invicibility
 mov  a, (Life)
 inc  a
 mov  (Life), a
P5_Status: call StatusLine
 jmp  DoStars
SwitchShoot:
 mov  a, 1
 mov  (GotShootBonus), a
 jmp  DoStars
MegaBomb:
 CALL_(DoMegaBomb)
 jmp  DoStars
Invicibility:
 mov  a, 255
 mov  (FlickerCount), a
;-- Flying stars:
DoStars:
 mov  de, StarX-1
 mov  hl, StarY-1
 mov  b, 11
FStarLoop:
 inc  de
 inc  hl
 mov  c, (hl)
 dec  c
 mov  a, c
 cmp  7
 jnz  DrawStar
 mov  c, 63
DrawStar:
 mov  (hl), c
 mov  a, (de)
P7_PointOn: call PointOn
 loop FStarLoop

P1_ShowActG: call ShowActG

;Levelinfo(if necessary); this is done before statusline because
;the Lvlinfo should disappear under the statusline
 ld  a, (InfoCount)
 cp  59
 jr  z, PrepareNLoop
 ld  b, a
 inc a
 ld  h, a
 ld  l, $2F
 ld  ($8333),hl
 ld  hl, (InfoPt)
 ROM_CALL(D_ZM_STR)
 ld  h, a
 ld  l, $4F
 ld  ($8333),hl
 ld  a, (Level)
 add a, '0'
 ROM_CALL(M_CHARPUT)
 ld  a, (InfoCount)
 inc a
 ld  (InfoCount), a

PrepareNLoop:
 pop bc
 ld  bc, (ShipY)
;And now change greyflag, some other things and then start from the beginning...
;Greyflag:
 ld  a, (GrFlag)
 inc a
 cp  2
 jr  nz, ChangeGrFlag
 xor a
ChangeGrFlag:
 ld (GrFlag), a
BBegin:
J2_GameLoop: jp GameLoop


Pause:
PKeyLoop:
 call GET_KEY
 push af
 cmp  1
 jz   ContD
 cmp  4
 jnz  GoOnP
 ;change contrast
 ld   a, (CONT)
 cp   $1F
 jr   z, GoOnP
 inc  a
 ld   (CONT), a
 out  (2), a
 jr   GoOnP
ContD:
 ld   a, (CONT)
 and  a
 jr   z, GoOnP
 dec  a
 ld   (CONT), a
 out  (2), a
GoOnP:
 pop  af
 cmp  $09
 jnz  PKeyLoop
 JUMP_(Redraw)

GameOver:
 mov  hl, $FD80-64
 mov  d, h
 mov  e, l
 inc  de
 mov  (hl), 0
 mov  bc, 255
 ldir

 ld  hl, $0603
 ld  ($800C), hl
 ld  hl, (PROGRAM_ADDR)
 ld  de, GameOvr
 add hl, de
 ROM_CALL(D_ZT_STR) ;write out "GAME OVER!"

 mov  hl, $FE40-64
 mov  d, h
 mov  e, l
 inc  de
 mov  (hl), 255
 mov  bc, 63
 ldir

 mov  hl, $FD80-80
 mov  d, h
 mov  e, l
 inc  de
 mov  (hl), 255
 mov  bc, 63
 ldir

GameOvrLoop:
 ld   a, (KEY_1)
 cp   $09
 jr   nz, GameOvrLoop
 JUMP_(ExitGame)

NextLevel:
 pop  bc
 ld   hl, $0604
 ld   ($800C), hl
 ld   hl, (PROGRAM_ADDR)
 ld   de, NextStageStr
 add  hl, de
 res  3, (IY+05)      ;display black on white
 PROM_CALL(D_ZT_STR)
NxtLvlLoop:
 mov  a, (KEY_1)
 cp   $09
 jnz  NxtLvlLoop

 mov  de, (PROGRAM_ADDR)
 mov  a, (Level)
 and  01h
 mov  (DoEnemNo), a
 mov  a, (BossLvl)
 and  a
 jnz  OtherNxtIF
 ld   a, (Level)
 cp   3
 jr   nz, NextIFBoss1
 CALL_(StartBoss)
J3_GameLoop: jp GameLoop
NextIFBoss1:
 cp   6
 jr   nz, NextIFBoss2
 CALL_(StartBoss)
 JUMP_(GameLoop)
NextIFBoss2:
 cp   9
 jr   nz, NextIFBoss3
 CALL_(StartBoss)
 JUMP_(GameLoop)
NextIFBoss3:
 cp   10
 jr   nz, OtherNxtIF
 CALL_(StartBoss)
 JUMP_(GameLoop)
OtherNxtIF:
 cp   11
 jr   z, EndGame
 cp   4
 jr   z, FirstShips
 cp   8
 jr   nz, TestNxtBMP
 ;Use first ships again:
FirstShips:
 ld   hl, (PROGRAM_ADDR)
 ld   de, GShip1-48
 add  hl, de
 ld   (ESPt1), hl
 ld   hl, (PROGRAM_ADDR)
 ld   de, DShip1-48
 add  hl, de
 ld   (ESPt2), hl
 ld   hl, (PROGRAM_ADDR)
 ld   de, Glider1-48
 add  hl, de
 ld   (ESPt3), hl
TestNxtBMP:
 cp   5
 jr   nz, ReallyNext
 ;Use first background:
 ld   hl, (PROGRAM_ADDR)
 ld   de, Planet1-16           ;First bk-pic
 add  hl, de
 ld   (BkPt), hl
ReallyNext:
 res  3,(IY+05)      ;display black on white
 JUMP_(StartLevel)

LSaveGame:
 CALL_(GrayScaleOff)
 ld  a, (CONTRAST)
 out (2), a
 ld   de, (PROGRAM_ADDR)
 ld   hl, GameSaved
 add  hl, de
 ld   a, 1
 ld   (hl), a
 ld   hl, SaveGame
 add  hl, de
 ld   de, TEXT_MEM
 ex   de, hl
 ld   bc, LEVELSIZE
 ldir
 ld   hl, ZS_BITS
 set  1, (hl)              ;Tell ZShell to warp out...
 ret

EndGame:
 CALL_(Ending)

ExitGame:
 CALL_(ClrScr)
 lea(TitlePic)
 mov  bc, 0
 CALL_(DeGCP)
 ROM_CALL(CLEARLCD)
 CALL_(HiScoreHand)
 CALL_(GrayScaleOff)
 mov  a, (CONTRAST)
 out  (2), a
 xor  a
 out  (1), a
 ret

;
;ShowAct
;
ShowAct:
 push bc
 mov  hl, (Page1Addr)
 mov  de, (PageAAddr)
 mov  bc, 1024
 ldir
 mov  hl, (Page2Addr)
 mov  de, (PageBAddr)
 mov  bc, 1024
 ldir
 pop  bc
 ret

;-----------------------------------------------------------------------------
;Statusline: Shows status
;-----------------------------------------------------------------------------
StatusLine:
 push af
 push hl
 push de
 push bc
 ;First, erase ground
 mov hl, $FFA0
 mov d, h
 mov e, l
 inc de
 mov (hl), 0
 mov bc, 95
 ldir
; mov hl, (PageBAddrG)
; mov d, h
; mov e, l
; inc de
; mov (hl), 0
; mov bc, 95
; ldir
 ;Write "SCORE:"
 ld  hl, $3A02
 ld  ($8333), hl
 ld  hl, (PROGRAM_ADDR)
 ld  de, InfoScr
 add hl, de
 ROM_CALL(D_ZM_STR)
 ld  hl, $3A1F
 ld  ($8333), hl
 ld  hl, (Score)
 CALL_(HL_DECIMAL_MENU)
 ;Write "SHIPS:"
 ld  hl, $3A52
 ld  ($8333), hl
 ld  hl, (PROGRAM_ADDR)
 ld  de, InfoShp
 add hl, de
 ROM_CALL(D_ZM_STR)
 ld  hl, $3A6F
 ld  ($8333), hl
 ld  a, (Life)
 add a, '0'
 ROM_CALL(M_CHARPUT)
 pop bc
 pop de
 pop hl
 pop af
 ret

;-----------------------------------------------------------------------------
;DoMegaBomb: A special bonus(v1.1)
;-----------------------------------------------------------------------------
DoMegaBomb:
 ld   hl, (DelayTime)
 ld   (DelayTimeB), hl
 ld   hl, $1000
 ld   (DelayTime), hl
 ld   b, 10
FlashLoop:
 xor  a
 out  (2), a
 CALL_(Delay)
 ld   a, (CONT)
 out  (2), a
 CALL_(Delay)
 djnz FlashLoop
 ld   hl, (DelayTimeB)
 ld   (DelayTime), hl
 ld   b, 10
 ld   hl, EnemStat
 ld   de, EnemType
 xor  a
MegaBombLoop:
 ld   (hl), a
 ld   (de), a
 inc  hl
 inc  de
 djnz MegaBombLoop
 CALL_(ClrScr)
 ret

;-----------------------------------------------------------------------------
;InitAster: inits the asteroids in the difficult mode(v1.1)
;-----------------------------------------------------------------------------
InitAster:
 ;Use random numbers of stars:
 ld    bc, 10             ;BC bytes to move
 ld    hl, (PROGRAM_ADDR)
 ld    de, RStarX
 add   hl, de             ;HL contains source
 ld    de, EnemX          ;DE destination
 ldir
 ld    bc, 10
 ld    hl, (PROGRAM_ADDR)
 ld    de, RStarY
 add   hl, de             ;HL contains source
 ld    de, EnemY          ;DE destination
 ldir
 ;fill EnemStat with 0 and EnemType with 1 & 2
 ld    b, 10
 ld    c, 1
 ld    de, EnemStat
 ld    hl, EnemType
FillAster:
 xor   a
 ld    (de), a
 inc   c
 ld    a, c
 cp    3
 jr    nz, SetEnemType
 ld    c, 1
SetEnemType:
 ld    (hl), c
 inc   hl
 inc   de
 djnz  FillAster
 ret

;-----------------------------------------------------------------------------
;DoAster: Handles the asteroids(v1.1)
;-----------------------------------------------------------------------------
DoAster:
 xor   a
 ld    (AsteroidHit), a
 ld    b, 5
DoAsterL:
 ld    d, 0
 ld    e, b
 dec   e
 push  bc
 ld    hl, EnemX
 add   hl, de
 ld    b, (hl)
 ld    hl, EnemY
 add   hl, de
 ld    c, (hl)

 ld    hl, EnemType    ;Type 1: fly with speed 1, else with speed 2
 add   hl, de
 ld    a,  (hl)
 cp    1
 jr    nz, GoOnSpeed2
 inc   c
 ld    a, c
 cp    56
 jr    c, DoAsterX
 ld    c, 1
 jr    DoAsterX
GoOnSpeed2:
 inc   c
 inc   c
 ld    a, c
 cp    56
 jr    c, DoAsterX
 ld    c, 1
DoAsterX:
 dec   b
 jr    nz, SetAsterPos
 ld    b, 119
SetAsterPos:
 ld    hl,  EnemY
 add   hl,  de
 ld    a,   c
 ld    (hl), a
 ld    hl,  EnemX
 add   hl,  de
 ld    a,   b
 ld    (hl), a
GoOnAster:
 ld    hl, EnemStat
 add   hl, de
 ld    a, (GrFlag)
 and   a
 jr    nz, DisplayAster
 ld    a, (hl)
 inc   a
 cp    4
 jr    nz, SaveAAster
 xor   a
SaveAAster:
 ld    (hl), a
DisplayAster:
 ld    a, (hl)
 ld    de, (PROGRAM_ADDR)
 and   a
 jr    z, AsterB1
 cp    1
 jr    z, AsterB2
 cp    2
 jr    z, AsterB3
 ld    ix, Aster40
 jr    DisplayAster1
AsterB1:
 ld    ix, Aster10
 jr    DisplayAster1
AsterB2:
 ld    ix, Aster20
 jr    DisplayAster1
AsterB3:
 ld    ix, Aster30
DisplayAster1:
 add   ix, de
P4_Bitmap: call Bitmap
;And now collision detection:
 ld    hl, (ShipY)
 CALL_(BitmapInter)
 jr    nc, GoOnAsterLoop
 ld    a, 1
 ld    (AsteroidHit), a
GoOnAsterLoop:
 pop   bc
 dec   b
 JUMP_NZ(DoAsterL)
 ld    a, (AsteroidHit)
 ret

;-----------------------------------------------------------------------------
;BitmapInter: Collision between to 8x8 bitmaps? yes -> Carryflag = 1 (v1.1)
; (H,L) contains position of 1st, (B,C) of second bitmap
;-----------------------------------------------------------------------------
BitmapInter:
 ld    a, b     ;compute absolute amount of overlap
 sub   h
 bit   7, a
 jr    z, GoOnTesting
 neg
GoOnTesting:
 cp    9   		;test X-Overlap
 jr    nc, NoColl1
 ;X-Test succeeded, but what about Y?
 ld    a, c
 sub   l
 bit   7, a
 jr    z, GoOnTesting1
 neg
GoOnTesting1:
 cp    9
 jr    nc, NoColl1
 scf            ;set carry flag -> collision occured
 ret
NoColl1:
 or    a 	;clear carry flag
 ret

;-----------------------------------------------------------------------------
;Handles the enems 1: h = enemtype, l = enemnum
;-----------------------------------------------------------------------------
DoEnem1:
 push af
 push bc
 push de
 push hl
 ;load enemnumber(need it for array index)
 ld d, 0
 ld e, l
 ;first use it for enemx
 mov hl, EnemX
 add hl, de
 mov b, (hl)
 ;next use it for enemy
 mov hl, EnemY
 add hl, de
 mov c, (hl)
 pop hl

 push hl
 ld a, h
 cp 1
 jr z, Enem1
 cp 2
 jr z, Enem2
 cp 3
 JUMP_Z(Enem3)

;Handle enemy 1(glider logic)
Enem1:
 ;Load status of enemtype 1 : 0 - dead
 ;                            1 - fly straight
 ;                            2 - fly left
 ;                            3 - fly right
 ld   d, 0
 ld   e, l
 ld   hl, EnemStat
 add  hl, de
 ld   a, (hl)
 inc  c                  ;this can be done all the time
 cp   2
 jr   z, EnemLeft1
 cp   3
 jr   z, EnemRight1
 ;if Count1 equals 7 then: if GrFlag 0-> fly left else fly right
 ld   a, (Count1)
 cp   7
 jr   nz, Show1
 ld   a, (GrFlag)
 and  a
 jr   z, SetLeft1
 ;Default: right
 ld   a, 3
 CALL_(SetEnemStat)
 jr   Show1
SetLeft1:
 ld   a, 2
 CALL_(SetEnemStat)
 jr   Show1
EnemLeft1:
 dec  b
 ld   a, b
 cp   2
 jr   c, OverflowL1
 jr   z, OverflowL1
 jr   Show1
OverflowL1:
 ld   b, 1
 ld   a, 1     ;don't fly left anymore
 CALL_(SetEnemStat)
 jr   Show1
EnemRight1:
 inc  b
 ld   a, b
 cp   118
 jr   nc, OverflowR1
 jr   Show1
OverflowR1:
 ld   b, 118
 ld   a, 1
 CALL_(SetEnemStat)

Show1:
 ld ix, (ESPt1)
P5_Bitmap: call Bitmap
 JUMP_(FinishWithPos)


;Handle enemy 2 (defender ship)
Enem2:
 ;Load status of enem type 2: 0 - dead
 ;                            1 - fly left
 ;                            2 - fly right
 ;                            3 - fly left-down
 ;                            4 - fly right-down
 ld  d, 0
 ld  e, l
 ld  hl, EnemStat
 add hl, de
 ld  a, (hl)
 cp  1
 jr  z, Left2
 cp  2
 jr  z, Right2
 cp  3
 jr  z, LeftDown2
 ;Default: Rightdown
 inc b
 inc c
 ld  a, b
 cp  119
 jr  nc, SetSRight2
 jr  Show2
SetSRight2:
 ld  a, 1
 CALL_(SetEnemStat)
 jr Show2

Left2:
 dec b
 ld  a, b
 cp  19
 jr  c, SetStatLeft2
 jr  z, SetStatLeft2
 jr  Show2

SetStatLeft2:
 ld  a, 3
 CALL_(SetEnemStat)
 jr Show2

Right2:
 inc b
 ld  a, b
 cp  101
 jr  nc, SetRight2
 jr  Show2
SetRight2:
 ld  a, 4
 CALL_(SetEnemStat)
 jr Show2

LeftDown2:
 dec b
 inc c
 ld  a, b
 cp  2
 jr  c, SetLeftD2
 jr  z, SetLeftD2
 jr  Show2
SetLeftD2:
 ld  a, 2
 CALL_(SetEnemStat)

Show2:
 ld ix, (ESPt2)
P6_Bitmap: call Bitmap
 JUMP_(FinishWithPos)

;Handles enem3 - offender ship
Enem3:
;Load status of enemy type 3 : 0 - dead
;                              1 - fly left
;                              2 - fly right
;                              3 - fly back
;                              4 - fly forward
;                              5 - fly left-back
;                              6 - fly right-back
;                              7 - fly left-forward
;                              8 - fly right-forward
 ld  d, 0
 ld  e, l
 ld  hl, EnemStat
 add hl, de
 ld  a, (hl)
 cp  1
 JUMP_Z(Enem3Left)
 cp  2
 JUMP_Z(Enem3Right)
 cp  3
 JUMP_Z(Enem3Up)
 cp  4
 JUMP_Z(Enem3Down)
 cp  5
 JUMP_Z(Enem3LB)
 cp  6
 JUMP_Z(Enem3RB)
 cp  7
 JUMP_Z(Enem3LF)
 ;Default: Rightforward
 inc b
 inc c
 ld  a, b
 cp  119
 JUMP_C(Show3)
 ld  a, 4
 CALL_(SetEnemStat)
 JUMP_(Show3)

Enem3Left:
 dec b
 ld  a, b
 cp  19
 JUMP_NC(Show3)
 ld  a, (GrFlag)
 and a
 jr  z, SetDown3
 ld  a, 7
 CALL_(SetEnemStat)
 JUMP_(Show3)
SetDown3:
 ld  a, 5
 CALL_(SetEnemStat)
 JUMP_(Show3)

Enem3Right:
 inc b
 ld  a, b
 cp  110
 JUMP_C(Show3)
 ld  a, (GrFlag)
 and a
 jr  z, SetDownR3
 ld  a, 6
 CALL_(SetEnemStat)
 JUMP_(Show3)
SetDownR3:
 ld  a, 8
 CALL_(SetEnemStat)
 JUMP_(Show3)

Enem3Up:
 dec  c
 ld   a, c
 cp   6
 JUMP_NC(Show3)
 ld   a, (GrFlag)
 and  a
 jr   z, SetUpDown
 ld   a, 2
 CALL_(SetEnemStat)
 JUMP_(Show3)
SetUpDown:
 ld   a, 4
 CALL_(SetEnemStat)
 jr   Show3

Enem3Down:
 inc c
 ld  a, c
 cp  51
 jr  c, Show3
 ld  a, (GrFlag)
 and a
 jr  z, EnemDownLeft
 ld  a, 6
 CALL_(SetEnemStat)
 jr  Show3
EnemDownLeft:
 ld  a, 5
 CALL_(SetEnemStat)
 jr  Show3

Enem3LB:
 dec b
 dec c
 ld  a, b
 cp  2
 jr  c, Enem3LB1
 ld  a, c
 cp  2
 jr  nc, Show3
 ld  c, 2
 ld  a, 4
 CALL_(SetEnemStat)
 jr  Show3
Enem3LB1:
 ld  b, 2
 ld  a, 6
 CALL_(SetEnemStat)
 jr  Show3

Enem3RB:
 inc b
 dec c
 ld  a, b
 cp  110
 jr  nc, Enem3RB1
 ld  a, c
 cp  2
 jr  nc, Show3
Enem3RB1:
 ld  a, (GrFlag)
 and a
 jr  z, SetEnem3RB
 ld  a, 3
 CALL_(SetEnemStat)
 jr  Show3
SetEnem3RB:
 ld  a, 1
 CALL_(SetEnemStat)
 jr  Show3

Enem3LF:
 dec b
 inc c
 ld  a, b
 cp  2
 jr  c, Enem3LF1
 ld  a, c
 cp  50
 jr  nc, Show3
Enem3LF1:
 ld  a, 3
 CALL_(SetEnemStat)

Show3:
 ld ix, (ESPt3)
P7_Bitmap: call Bitmap

FinishWithPos:
 ;first, save position of enemy:
 pop hl
 mov d, 0
 mov e, l
 mov hl, EnemX
 add hl, de
 mov (hl), b
 mov hl, EnemY
 add hl, de
 mov (hl), c
 ;is ship-y greater than 58?
 mov  a, c
 cmp  58
 jae  SetShipGone
 ;wanna shoot on player?!
 mov  a, (ShipX) ;compare EnemX with ShipX
 cmp  b
 jnz  Finished
StartMissile:
 mov  a, c
 cmp  52
 jae  Finished
 push bc
 mov  b, 3
 mov  hl, EnemSX
FindMissile:
 mov  a, (hl)        ;EnemSX = 0 -> Shoot free
 and  a
 jz   SetMissile
 inc  hl
 loop FindMissile
 pop  bc
 jmp  Finished
SetMissile:
 pop  bc
 mov  a, b
 add  a, 3
 mov  (hl), a
 mov  d, 0
 mov  e, 3
 add  hl, de
 mov  a, 64
 sub  c
 sub  8
 mov  (hl), a         ;Missile started... heading towards Player
 jmp  Finished
SetShipGone:
 xor  a
 mov  hl, EnemType
 add  hl, de
 mov  (hl), a
 mov  a, (NumEnem)
 dec  a
 mov  (NumEnem), a
Finished:
 pop  de
 pop  bc
 pop  af
 ret

;-----------------------------------------------------------------------------
;Handles the enems 2: h = enemtype, l = enemnum
;-----------------------------------------------------------------------------
DoEnem2:
 push af
 push bc
 push de
 push hl
 ;load enemnumber(need it for array index)
 mov  d, 0
 mov  e, l
 ;first use it for enemx
 mov  hl, EnemX
 add  hl, de
 mov  b, (hl)
 ;next use it for enemy
 mov  hl, EnemY
 add  hl, de
 mov  c, (hl)
 pop  hl

 push hl
 mov  a, h
 cmp  2
 jz   Enem2_2
 cmp  3
 JUMP_Z(Enem3_2)

;Handle enemy 1(glider logic)
Enem1_2:
 ;Load status of enemtype 1 : 0 - dead
 ;                            1 - fly
 inc  c                  ;this can be done all the time
 mov  a, (ShipX)
 cmp  b
 jb   Enem1_DecB
 inc  b
 jmp  Show1_2
Enem1_DecB:
 dec  b
Show1_2:
 mov  ix, (ESPt1)
P8_Bitmap:  call Bitmap
 JUMP_(FinishWithPos_2)

;Handle enemy 2 (defender ship)
Enem2_2:
 ;Load status of enem type 2: 0 - dead
 ;                            1 - fly left
 ;                            2 - fly right
 ;                            3 - fly forward fast
 ;                            4 - fly backward
 mov  d, 0
 mov  e, l
 mov  hl, EnemStat
 add  hl, de
 mov  a, (hl)
 cmp  1
 jz   Left2_2
 cmp  2
 jz   Right2_2
 cmp  3
 jz   Forward2_2
 ;Default: backward
 dec  c
 mov  a, c
 cmp  4
 jae  Show2_2
 mov  a, 1
 CALL_(SetEnemStat)
 jmp  Show2_2

Left2_2:
 dec  b
 mov  a, b
 cmp  4
 jae  Show2_2
 mov  a, 2
 CALL_(SetEnemStat)
 jmp  Show2_2

Right2_2:
 inc  b
 mov  a, b
 cmp  119
 jb   Show2_2
 mov  a, 1
 CALL_(SetEnemStat)
 jmp  Show2_2

Forward2_2:
 inc  c
 inc  c
 mov  a, (ShipY)
 cmp  c
 jae  Show2_2
 mov  a, 4
 CALL_(SetEnemStat)

Show2_2:
 mov  a, (ShipX)
 cmp  b
 jnz  R_Show2_2
 mov  a, (hl)
 cmp  3
 jae  R_Show2_2
 mov  a, 3
 CALL_(SetEnemStat)
R_Show2_2:
 mov  ix, (ESPt2)
P9_Bitmap: call Bitmap
 JUMP_(FinishWithPos_2)

;Handles enem3 - offender ship
Enem3_2:
 mov  d, 0
 mov  e, l
 mov  hl, EnemStat
 add  hl, de
 mov  a, (hl)
 cmp  1
 jz   Enem3Left_2
 cmp  2
 jz   Enem3Right_2
 cmp  3
 jz   Enem3Up_2
 ;Default: down
 inc  c
 mov  a, c
 cmp  54
 jb   Show3_2
 mov  a, 3
 CALL_(SetEnemStat)
 jmp  Show3_2

Enem3Left_2:
 dec  b
 dec  b
 mov  a, b
 cmp  2
 jae  Show3_2
 mov  a, 4
 CALL_(SetEnemStat)
 jmp  Show3_2

Enem3Right_2:
 inc  b
 inc  b
 mov  a, b
 cmp  119
 jb   Show3_2
 mov  a, 3
 CALL_(SetEnemStat)
 jmp  Show3_2

Enem3Up_2:
 dec  c
 mov  a, c
 cmp  4
 jae  Show3_2
 mov  a, 4
 CALL_(SetEnemStat)

Show3_2:
 mov  a, (ShipY)
 cmp  c
 jnz  RShow3_2
 mov  a, (hl)
 cmp  3
 jb   RShow3_2
 mov  a, b
 cmp  64
 jb   FlyRight3_2
 mov  a, 1
 CALL_(SetEnemStat)
 jmp  RShow3_2
FlyRight3_2:
 mov  a, 2
 CALL_(SetEnemStat)
RShow3_2:
 mov  ix, (ESPt3)
P10_Bitmap: call Bitmap

FinishWithPos_2:
 ;save position of enemy:
 pop  hl
 mov  d, 0
 mov  e, l
 mov  hl, EnemX
 add  hl, de
 mov  (hl), b
 mov  hl, EnemY
 add  hl, de
 mov  (hl), c
 ;is ship-y greater than 58?
 mov  a, c
 cmp  58
 jae  SetShipGone_2
 ;wanna shoot on player?!
 mov  a, (ShipX) ;compare EnemX with ShipX
 cmp  b
 jnz  Finished_2
StartMissile_2:
 mov  a, c
 cmp  52
 jnc  Finished_2
 push bc
 mov  b, 3
 mov  hl, EnemSX
FindMissile_2:
 mov  a, (hl)        ;EnemSX = 0 -> Shoot free
 and  a
 jz   SetMissile_2
 inc  hl
 loop FindMissile_2
 pop bc
 jmp  Finished_2
SetMissile_2:
 pop  bc
 mov  a, b
 add  a, 3
 mov  (hl), a
 mov  d, 0
 mov  e, 3
 add  hl, de
 mov  a, 64
 sub  c
 sub  8
 mov  (hl), a         ;Missile started... heading towards Player
 jmp  Finished_2
SetShipGone_2:
 xor  a
 mov  hl, EnemType
 add  hl, de
 mov  (hl), a
 mov  a, (NumEnem)
 dec  a
 mov  (NumEnem), a
Finished_2:
 pop  de
 pop  bc
 pop  af
 ret

;-----------------------------------------------------------------------------
;Inits enem %a at position %b * 32
;-----------------------------------------------------------------------------
InitEnem:
 push hl
 and  a
 jr   z, EndInit
 push af
 push bc
 ld   a, (NumEnem)      ;number of enems already 10 -> back
 cp   10
 jr   nc, EndEnemLoop
 ld   hl, EnemType-1   ;enemtype
 ld   b, 10
 ld   c, 0
EnemFreeLoop:
 inc  hl
 ld   a, (hl)
 and  a
 jr   z, SetEnemVars
 inc  c
 djnz EnemFreeLoop
EndEnemLoop:
 pop  bc
 pop  af
 jr   EndInit
SetEnemVars:
 ;Set enemtype & position
 ld   d, 0
 ld   e, c            ;c contains number of enem
 ld   hl, EnemType
 add  hl, de
 pop  bc
 pop  af
 ld   (hl), a
 ;status:
 ld   hl, EnemStat
 add  hl, de
 ld   a, 1
 ld   (hl), a         ;set enemstatus to 1
 ;x pos:
 ld   hl, EnemX
 add  hl, de
 ;this multiplies with 32:(weird!)
 ld   a, b
 add  a, a
 add  a, a
 add  a, a
 add  a, a
 add  a, a
 sub  8
 ld   (hl), a
 ;y position:
 ld   hl, EnemY
 add  hl, de
 ld   a, 1
 ld   (hl), a
 ;now inc NumEnem
 ld   a, (NumEnem)
 inc  a
 ld   (NumEnem), a
EndInit:
 pop  hl
 ret

;-----------------------------------------------------------------------------
;Sets status %a of enem %e
;-----------------------------------------------------------------------------
SetEnemStat:
 push hl
 mov  d, 0
 mov  hl, EnemStat
 add  hl, de
 mov  (hl), a
 pop hl
 ret

;
;Bitmap: draws image %IX at (B,C)
;
Bitmap:
 push bc
 push hl
 push de
 mov  a, 8
 mov  (TempByte), a
 mov  a, b
 mov  h, 0
 mov  l, c
 add  hl, hl
 add  hl, hl
 add  hl, hl
 add  hl, hl
 shr  b
 shr  b
 shr  b
 mov  d, 0
 mov  e, b
 add  hl, de
 mov  b, h
 mov  c, l
 mov  hl, (Page2Addr)
 add  hl, bc
 ex   de, hl
 mov  hl, (Page1Addr)
 add  hl, bc
 mov  b, 128
 mov  c, b
 and  7
 jz   BMP_B
 mov  b, a
BMP_S:
 shr  c
 loop BMP_S
 mov  b, 128
BMP_B:
 mov  a, (ix)
 and  b
 jz   BMP_Point0
 mov  a, (hl)
 or   c
 mov  (hl), a
 jmp  BMP_Check2
BMP_Point0:
 mov  a, c
 xor  255
 and  (hl)
 mov  (hl), a
BMP_Check2:
 mov  a, (ix+8)
 and  b
 jz   BMP_Point01
 mov  a, (de)
 or   c
 mov  (de), a
 jmp  BMP_Loop
BMP_Point01:
 ex   de, hl
 mov  a, c
 xor  255
 and  (hl)
 mov  (hl), a
 ex   de, hl
BMP_Loop:
 ror  c
 jnc  BMP_RorB
 inc  hl
 inc  de
BMP_RorB:
 ror  b
 jnc  BMP_B
 inc  ix
 mov  a, (TempByte)
 dec  a
 mov  (TempByte), a
 jz   BMP_End
 push bc
 mov  bc, 15
 add  hl, bc
 ex   de, hl
 add  hl, bc
 ex   de, hl
 pop  bc
 jmp  BMP_B
BMP_End:
 pop  de
 pop  hl
 pop  bc
 ret


;-----------------------------------------------------------------------------
;DrawBSprite: draws sprite of a 24x24 image at %de at(b,c)
;-----------------------------------------------------------------------------
DrawBSprite:
 push hl                   ;save regs
 push de
 push bc
 xor  a
 ld   (TempByte), a
 ld   (Column), a
 ld   h, a                 ;store y-position into hl and
 ld   l, c                 ;multiplicate it by 16
 add  hl, hl ;*2
 add  hl, hl ;*4
 add  hl, hl ;*8
 add  hl, hl ;*16
 push de                   ;save de & bc temporary
 push bc
 srl  b                    ;divide b by 8
 srl  b
 srl  b
 ld   d,  0                ;load edited x-position into de
 ld   e,  b                ;add it to y-position
 add  hl, de               ;and finally
 ld   (HelpAddr), hl
 ld   de, (Page1Addr)      ;let it point to the vid-ram
 add  hl, de
 pop  bc                   ;pop de & bc
 pop  de
 ld   a, b                 ;load real x-position
 and  7                    ;into and make
 and  a                    ;something like mod(a,7)
 ld   c, 128               ;c is the video-mask,
 ld   b, c                 ;b the bitmap-mask
 jr   z, BLoop             ;if modulo = 0, jump directly to drawloop
 ld   b, a                 ;else shift right mod(a,7) times
BShift:
 srl  c
 djnz BShift
 ld   b, 128               ;b is 128 = bit 7 of bitmap
BLoop:
 ld   a, (de)              ;load bitmap-data into a
 and  b                    ;test only one bit
 jr   z, BSet0             ;if bit = zero; erase point
 ld   a, (hl)              ;otherwise, draw point
 or   c
 jr   BLoop1
BSet0:
 ld   a, c                 ;erase point
 xor  255
 and  (hl)
BLoop1:
 ld   (hl), a              ;now save this into video-ram
 rrc  c                    ;and shift the video-mask -> next pixel
 jr   nc, BLoop2          ;if mask is zero -> fill 128 into c
 inc  hl
BLoop2:
 rrc  b                    ;now shift the bitmap-mask
 jr   nc, BLoop            ;if <> zero, loop again
BNextLine:
 inc  de
 ld   a, (Column)
 inc  a
 ld   (Column), a
 cp   3
 jr   nz, BLoop
 xor  a
 ld   (Column), a
 push de                   ;save de
 ld   de, 13
 add  hl, de               ;add 15 bytes to hl
 pop  de
 ld   a, (TempByte)        ;TempByte holds line
 inc  a
 ld   (TempByte), a
 cp   24
 jr   c, BLoop             ;if line<8, loop again
 cp   48
 jr   z, BEndBMP
 cp   24
 jr   nz, BLoop
 push de
 ld   hl, (HelpAddr)
 ld   de, (Page2Addr)
 add  hl, de
 pop  de
 jr   BLoop
BEndBMP:
 pop  bc
 pop  de
 pop  hl
 ret

;
; Protected ROM_CALL
;
ROMC:
	push bc
	push de
	push hl

	ld hl, (PROGRAM_ADDR)
	ld de, romcc
	add hl, de
	ld (HL), a

	pop hl
	pop de
	push de
	push hl

	call $8C09
romcc: .db 0

	xor a
	ld hl, (PROGRAM_ADDR)
	ld de, romcc
	add hl, de
	ld (HL), a

	pop hl
	pop de
	pop bc
	ld a, ($8A40)
	ret

;-----------------------------------------------------------------------------
;Delay: waits
;-----------------------------------------------------------------------------
Delay:
 push af
 push bc
 ld   bc, (DelayTime)
DelayLoop:
 dec bc
 ld a, b
 or c
 jr nz, DelayLoop
 pop bc
 pop af
 ret

;-----------------------------------------------------------------------------
;PointOn: draws point at a=x, c=y
;-----------------------------------------------------------------------------
PointOn:
 push hl
 push bc
 push de
 mov  b, a
 ROM_CALL(FIND_PIXEL)
 mov  de, (Page1Addr)
 add  hl,de
 or   (hl)
 mov  (hl), a
 pop de
 pop bc
 pop hl
 ret

;-----------------------------------------------------------------------------
;HL_DECIMAL_MENU(Magnus Hagander):Writes the in HL stored word in menu font
;-----------------------------------------------------------------------------

HL_DECIMAL_MENU:
 push bc
 push af
 push de
 ld   de,StringPlace+4
 ld   b, 5
ConvLoop:
 call UNPACK_HL
 add  a,'0'
 ld   (de),a
 dec  de
 djnz ConvLoop
 ld   hl,StringPlace
 ROM_CALL(D_ZM_STR)
 pop de
 pop af
 pop bc
 ret

;-----------------------------------------------------------------------------
;ShootCollision: is there a collision between a shoot with position hl and
;                an enemy ship with position de? if yes -> a = 1
;-----------------------------------------------------------------------------
ShootCollision:
 push bc
 push de
 push hl
 ld  a, h               ;load x-pos into a
 cp  d                  ;is x-pos greater than d and smaller than d+8?
 jr  c, EndCollDet      ;no

 ld  a, (Width)
 ld  b, a
 ld  a, d               ;add width to d
 add a, b
 ld  d, a
 ld  a, h               ;save x-pos again into a
 cp  d                  ;compare it with the incremented d
 jr  nc, EndCollDet

 ;Ok, x is within ship, but what about y?
 ld  a, l               ;load y-pos into a
 cp  e                  ;is y-pos greater then e?
 jr  c, EndCollDet

 ld  a, (Width)
 ld  b, a
 ld  a, e               ;add width to e
 add a, b
 ld  e, a
 ld  a, l               ;save y-pos again into a
 cp  e
 jr  nc, EndCollDet
 ;Collision!
 scf
 jr  EndCollDet1
EndCollDet:
 or   a
EndCollDet1:
 pop  hl
 pop  de
 pop  bc
 ret

;-----------------------------------------------------------------------------
;MissCollision: is there a collision between a shoot with position hl and
;               the player ship with position de? if yes -> a = 1
;-----------------------------------------------------------------------------
MissCollision:
 push bc
 push de
 push hl
 ld  a, h               ;load x-pos into a
 cp  d                  ;is x-pos greater than d and smaller than d+8?
 jr  c, MEndCollDet      ;no

 ld  a, d               ;add width to d
 add a, 9
 ld  d, a
 ld  a, h               ;save x-pos again into a
 cp  d                  ;compare it with the incremented d
 jr  nc, MEndCollDet

 ;Ok, x is within ship, but what about y?
 ld  a, l               ;load y-pos into a
 cp  e                  ;is y-pos greater then e?
 jr  c, MEndCollDet

 ld  a, e               ;add width to e
 add a, 9
 ld  e, a
 ld  a, l               ;save y-pos again into a
 cp  e
 jr  nc, MEndCollDet
 ;Collision!
 scf
 jr  MEndCollDet1
MEndCollDet:
 or   a
MEndCollDet1:
 pop  hl
 pop  de
 pop  bc
 ret

;-----------------------------------------------------------------------------
;DoExplosion: handles max. 3 explosions
;-----------------------------------------------------------------------------
DoExplosion:
 push bc
 mov  hl, ExplX-1
 mov  de, ExplY-1
 mov  b, 3
ExplLoop:
 inc  hl
 inc  de
 mov  a, (hl)
 and  a
 jz   DoExplLoop
 push bc
 push de
 push hl
 mov  b, a
 mov  a, (de)
 mov  c, a
 mov  d, 0
 mov  e, 6
 add  hl, de
 mov  a, (hl)  ;hl points to ExplStatus
 inc  a
 mov  (hl), a
 shr  a
 and  a
 jr   z, EFrm1
 cp   1
 jr   z, EFrm2
 cp   2
 jr   z, EFrm3
 cp   3
 jr   z, EFrm4
 pop  hl
 ld   (hl), 0
 push hl
 ld   ix, Expl5
 jr   DrawEx
EFrm1:
 ld   ix, Expl1
 jr   DrawEx
EFrm2:
 ld   ix, Expl2
 jr   DrawEx
EFrm3:
 ld   ix, Expl3
 jr   DrawEx
EFrm4:
 ld   ix, Expl4
 jr   DrawEx
EFrm5:
DrawEx:
 ld   de, (PROGRAM_ADDR)
 add  ix, de
P11_Bitmap: call Bitmap
 pop  hl
 pop  de
 pop  bc
DoExplLoop:
 djnz ExplLoop
 pop  bc
 ret

;-----------------------------------------------------------------------------
;SetExplosion: Inits an explosion at (b,c)
;-----------------------------------------------------------------------------
SetExplosion:
 push bc
 ld  b, 3
 ld  hl, ExplX-1
FindExpl:
 inc hl
 ld  a, (hl)
 and a
 jr  z, ExplFound
 djnz FindExpl
 ;No free explosion, so return:
 pop bc
 ret
ExplFound:
 pop bc
 ld  a, b
 ld  (hl), a
 ld  d, 0
 ld  e, 3
 add hl, de
 ld  a, c
 ld  (hl), a
 add hl, de
 ld  (hl), 0
EndFindExpl:
 ret


;-----------------------------------------------------------------------------
;Ending: A little text with a 4-greyshape picture...
;-----------------------------------------------------------------------------
Ending:
 mov  a, (KEY_1)
 and  a
 jnz  Ending
 CALL_(ClrScr)
 ;Write text...
 mov  hl, $0004
 mov  ($800C), hl
 mov  de, (PROGRAM_ADDR)
 mov  hl, Congratul
 add  hl, de
 ROM_CALL(D_ZT_STR)
 mov  hl, $2A01
 mov  de, EndingTxt
 CALL_(DisplayText)
 mov  hl, $3001
 mov  de, EndingTx1
 CALL_(DisplayText)
 mov  hl, $3601
 mov  de, EndingTx2
 CALL_(DisplayText)
 ;Now loop:
 lea(EndingPic)
 mov  bc, 0
 CALL_(DeGCP)
P5_ShowAct: call ShowAct
EndingLoop:
 mov  a, (KEY_1)
 cmp  $09
 jnz  EndingLoop
 ret

;-----------------------------------------------------------------------------
;StartBoss: starts a boss
;-----------------------------------------------------------------------------
StartBoss:
 ld  a, (BossLvlS)
 inc a
 ld  (BossLvl), a
 ld  (BossLvlS), a
 ld  de, (PROGRAM_ADDR)
 cp  1
 jr  z, InitBoss1
 cp  2
 jr  z, InitBoss2
 cp  3
 jr  z, InitBoss3
 ;Init big boss:
 ld  hl, Boss41
 add hl, de
 ld  (BossPt), hl
 ld  a, 255
 ld  (BossLife), a
 ld  hl, BossLog4
 add hl, de
 ld  (LogPt), hl
 jr  EndStartBoss
InitBoss1:
 ld  hl, Boss11
 add hl, de
 ld  (BossPt), hl
 ld  a, 46
 ld  (BossLife), a
 ld  hl, BossLog1
 add hl, de
 ld  (LogPt), hl
 jr  EndStartBoss
InitBoss2:
 ld  hl, Boss21
 add hl, de
 ld  (BossPt), hl
 ld  a, 70
 ld  (BossLife), a
 ld  hl, BossLog2
 add hl, de
 ld  (LogPt), hl
 jr  EndStartBoss
InitBoss3:
 ld  hl, Boss31
 add hl, de
 ld  (BossPt), hl
 ld  a, 100
 ld  (BossLife), a
 ld  hl, BossLog3
 add hl, de
 ld  (LogPt), hl
EndStartBoss:
 ld  hl, 65535     	;this is the flag if there's no asteroid
 ld  (AsterC), hl
 ld  a, 56
 ld  (EnemX), a
 ld  a, 1
 ld  (EnemY), a
 push bc
 ld   b, 9
 xor  a
 ld   hl, EnemType+1
SetEnemType0:
 ld   (hl), 0
 inc  hl
 djnz SetEnemType0
 CALL_(ClrScr)
 pop  bc
 ld   a, 4
 ld   (EnemType), a
 xor  a
 ld   (EnemStat), a
 ld   hl, (PROGRAM_ADDR)
 ld   de, BossInf
 add  hl, de
 ld   (InfoPt), hl
 ld   a, 25
 ld   (Width), a
 xor  a
 ld   (InfoCount), a
 ret

;-----------------------------------------------------------------------------
;DoBoss: handles the boss
;-----------------------------------------------------------------------------
DoBoss:
 push bc
;Load position of boss
 ld   a, (EnemX)
 ld   b, a
 ld   a, (EnemY)
 ld   c, a
;Move boss according to his logic stored in (LogPt)
 ld   hl, (LogPt)
 ld   d,  0
 ld   a,  (EnemStat)   ;Enemstat contains position in Logic
 ld   e,  a
 add  hl, de
 ld   a, (hl)
 and  a
 jr   z, StartBegin
 inc  hl              ;the next byte contains the limit
;Otherwise, move boss
 cp   1    ;fly left?
 jr   z, Boss1L
 cp   2    ;fly left-down?
 jr   z, Boss1LD
 cp   3    ;fly right-down?
 jr   z, Boss1RD
 cp   4    ;fly right?
 jr   z, Boss1R
 cp   5    ;fly right-up?
 jr   z, Boss1RU
 ;Standard:left-up
 dec  c
 inc  b
 ld   a, b
 cp   (hl)
 jr   c, DoSpBoss
 jr   NextInstr
Boss1L:
 inc  b
 ld   a, b
 cp   (hl)
 jr   c, DoSpBoss
 jr   NextInstr
Boss1LD:
 inc  b
 inc  c
 ld   a, b
 cp   (hl)
 jr   c, DoSpBoss
 jr   NextInstr
Boss1RD:
 dec  b
 inc  c
 ld   a, b
 cp   (hl)
 jr   nc, DoSpBoss
 jr   NextInstr
Boss1R:
 dec  b
 ld   a, b
 cp   (hl)
 jr   nc, DoSpBoss
 jr   NextInstr
Boss1RU:
 dec  b
 dec  c
 ld   a, b
 cp   (hl)
 jr   nc, DoSpBoss
 jr   NextInstr

StartBegin:
 xor  a
 ld   (EnemStat), a
 jr   DoSpBoss

NextInstr:
 ld   a, (EnemStat)   ;yes, next log-instruction
 inc  a               ;skip limitbyte
 inc  a
 ld   (EnemStat), a

;Now, handle the "specials" of each boss!
DoSpBoss:
 ld   a, (BossLvl)
 cp   1
 jr   z, DoBoss1
 cp   2
 jr   z, DoBoss2
 cp   3
 jr   z, DoBoss3
 ;Do big boss:
 ld   a, (Count1)
 cp   3
 jr   nc, ShipBeyondBoss
 add  a, 2
 add  a, a
 ld   d, a
 jr   StartBMissile
ShipBeyondBoss:
 ld   a, (ShipX)
 cp   b
 jr   c, DrawBoss
 sub  32
 cp   b
 jr   nc, DrawBoss
 ld   a, (ShipX)
 add  a, 3
 ld   d, a
 jr   StartBMissile
DoBoss1:
 ld   a, (ShipX)
 sub  5
 cp   b
 jr   nz, DoBoss11
 ld   d, 8
 jr   StartBMissile
DoBoss11:
 ld   a, (ShipX)
 sub  18
 cp   b
 jr   nz, DrawBoss
 ld   d, 21
 jr   StartBMissile

DoBoss2:
 ld   a, (Count1)
 cp   2
 jr   nc, DrawBoss
 ld   a, (GrFlag)
 and  a
 jr   z, DoBossSR2
 ld   d, 8
 jr   StartBMissile
DoBossSR2:
 ld   d, 14
 jr   StartBMissile

DoBoss3:
 ld   a, (Count1)
 cp   3
 jr   nc, DrawBoss
 ld   a, (GrFlag)
 and  a
 jr   z, DoBossSR3
 ld   a, (Count1)
 inc  a
 add  a, a
 inc  a
 ld   d, a
 jr   StartBMissile
DoBossSR3:
 ld   a, (Count1)
 inc  a
 add  a, a
 add  a, 16
 ld   d, a
 jr   StartBMissile

StartBMissile:
 push bc
 ld   b, 3
 ld   hl, EnemSX
FindBMissile:
 ld   a, (hl)        ;EnemSX = 0 -> Shoot free
 and  a
 jr   z, SetBMissile
 inc  hl
 djnz FindBMissile
 pop  bc
 jr   DrawBoss
SetBMissile:
 pop bc
 ld  a, b
 add a, d
 ld  (hl), a
 ld  d, 0
 ld  e, 3
 add hl, de
 ld  a, 64
 sub c
 sub 24
 ld  (hl), a         ;Missile started... heading towards Player

DrawBoss:
 ld   a, b
 ld   (EnemX), a
 ld   a, c
 ld   (EnemY), a
 ld   de, (BossPt)
 CALL_(DrawBSprite)
 pop  bc
 ret

;-----------------------------------------------------------------------------
;Handle Hi-score
;-----------------------------------------------------------------------------
HiScoreHand:
 ld  de, (PROGRAM_ADDR)
 ld  hl, HiScore
 add hl, de
 call LD_HL_MHL
 ld  de, (Score)
 ld  (HiScoreTemp), de
;DE contains hiscore, HL actual score
 call CP_HL_DE
 ret  nc
 ld   hl, (PROGRAM_ADDR)
 ld   de, HiScore
 add  hl, de
 ex   de, hl
 ld   hl, HiScoreTemp
 ld   b, 2
 ldi
 ldi
 ld   hl, $0300
 ld   ($800C), hl
 ld   de, (PROGRAM_ADDR)
 ld   hl, HiScr
 add  hl, de
 PROM_CALL(D_ZT_STR)
 ld  hl, $0A1F
 ld  ($8333), hl
 ld  hl, EnterInit
 add hl, de
 ROM_CALL(D_ZM_STR)
 ld  hl, $0803
 ld  ($800C), hl
 ld  hl, (PROGRAM_ADDR)
 ld  de, HiScrName
 add hl, de   		;hl points to hi-score name
 ld  b, 3
InitLoop:
 CALL_(GetLetter)
 ld  (hl), a
 inc hl
 djnz InitLoop
 ret

;-----------------------------------------------------------------------------
;GetLetter: gets a letter(magnus hagander)
;-----------------------------------------------------------------------------
GetLetter:
  push hl
  push bc
  ld   hl,(PROGRAM_ADDR)
  ld   de,ASCII_Table-1   ;Point to one before, since we always inc once
  add  hl,de              ;HL now points right
ConvertLoop:
  push hl
  CALL GET_KEY                 ;ACC holds key
  pop  hl
  and  a
  jr   z,ConvertLoop
  push hl                      ;save away...
  ld   b,a
  ld   c,0
ConversionLoop:
  inc  hl
  djnz ConversionLoop          ;After this, we have the correct offset...
  ld   a,(HL)
  pop  hl
  and  a
  jr   z,ConvertLoop           ;Invalid key
  ROM_CALL(TX_CHARPUT)         ;Show the char
  pop  bc
  pop  hl
  ret                          ;Value is in acc

;------------------------------------------------------------------------------
;DisplayText: displays the text in DE at position(H,L) in menustyle
;------------------------------------------------------------------------------
DisplayText:
 ld   ($8333), hl
 ld   hl, (PROGRAM_ADDR)
 add  hl, de
 ROM_CALL(D_ZM_STR)
 ret

;Ŀ
;GREYLIB (C) by Robert Taylor: VBL interrupt routine -> 4 grayscales         
;;
GrayScaleOn:

 ld   hl,($8BE5)   ;get end of VAT
 dec  hl
 dec  hl          ;make sure we're clear it..

 ; now we need to get the position of
 ; the nearest screen boundary

 ld   a,h
 sub  $c  ;(4*1024)
 ld   h,a
 ld   l,0
 push hl

 ;Tests if there is a space for the 1K
 ;needed for the 2nd screen

 ld  de, ($8BE1)
 or  a
 sbc hl, de
 pop hl
 jr  c, GrayError

 ; test if our block of memory
 ; is within the range addressable
 ; by the LCD hardware

 and %11000000
 cp %11000000
 jr nz,GrayError

 ;Save out the address of our 2nd Screen
 ld de,1024
 ld (PageBAddr),hl
 ld (Page2Addr),hl
 add hl,de
 ld (PageCAddr),hl
 add hl,de
 ld (PageDAddr),hl

 ; It is, so save out the byte to send to port 0
 ; to switch to our 2nd screen

 ld a,h
 and %00111111
 ld (PageD),a
 ld (Page2),a
 sub 4
 ld (PageC),a
 ld (Page1),a

 sub 4
 ld (PageB),a

 ld hl,$fc00
 ld (PageAAddr),hl
 ld (Page1Addr),hl
 ld a,$3c
 ld (PageA),a

 xor a
 ld (CurrPage),a

 CALL_(InstallInterrupt)
 or a            ;clear carry flag = alls OK
 ret

GrayError:
 scf            ;set carry flag = Error occured
 ret


GrayScaleOff
 im 1

 ld a,$3c
 out (0),a    ;Set screen back to normal

 ;This is just to clear the
 ;Graph screen, so people don't
 ;Complain about rubbish appearing
 ;On it..

 ld hl,GRAPH_MEM
 ld d,h
 ld e,l
 inc de
 ld (hl),0
 ld bc,1023
 ldir
 ret

InstallInterrupt:
 ld      a,$088
 ld     hl,$8700
 ld     (hl),a
 inc    hl
 ld     b,0
CopyLoop:
 ld     (hl),a
 inc    hl
 djnz   CopyLoop


 ld     hl,(PROGRAM_ADDR)
 ld     de,Int_Rout
 add    hl,de           ; get the rout we want to be called
 ld      de,$8888        ;where it gets called from
 ld      bc,Int_RoutEnd+1-Int_Rout
 ldir                   ; copy it there

 ld a,0
 ld  (Count),a

 ld a,$87
 ld i,a

 im 2
 ret

       
Int_Rout:

 ex     af,af'
 exx

 in a,(3)
 bit 1,a           ; check that it is a vbl interrupt
 jr z,EndInt

 ld a,(Count)
 cp 2
 jr z,Disp_2

Disp_1
 inc a
 ld (Count),a
 ld a,(Page1)
 out (0),a
 jr EndInt
Disp_2
 ld a,(Page2)
 out (0),a
 sub a
 ld (Count),a
EndInt
 exx
 ex     af,af'
 jp     $38
Int_RoutEnd

;
;ClrScr: Clears the screen
;
ClrScr:
 push bc
 ld  hl, (Page1Addr)
 ld  d,h
 ld  e,l
 inc de
 ld  (hl), 0
 ld  bc, 1023
 ldir
 ld  hl, (Page2Addr)
 ld  d,h
 ld  e,l
 inc de
 ld  (hl), 0
 ld  bc, 1023
 ldir
 pop bc
 ret

;
;ShowActG: shows upper part of screen
;
ShowActG:
 push bc
 ld  hl, (Page1Addr)
 ld  de, (PageAAddr)
 ld  bc, 928
 ldir
 ld  hl, (Page2Addr)
 ld  de, (PageBAddr)
 ld  bc, 928
 ldir
 pop bc
 ret

Swap_Screens
	ld a,(CurrPage)
	or a
	jr z,SwapIn1
SwapIn0
	ld hl,(PageAAddr)
	ld (Page1Addr),hl
	ld hl,(PageBAddr)
	ld (Page2Addr),hl
	ld a,(PageC)
	ld (Page1),a
        ld a,(PageD)
        ld (Page2),a
        ld a,0
        ld (CurrPage),a
        ret

SwapIn1
        ld hl,(PageCAddr)
	ld (Page1Addr),hl
        ld hl,(PageDAddr)
        ld (Page2Addr),hl
        ld a,(PageA)
        ld (Page1),a
        ld a,(PageB)
        ld (Page2),a
        ld a,1
        ld (CurrPage),a
        ret


;-----------------------------------------------------------------------------
;Datastrings
;-----------------------------------------------------------------------------
GreyError: .db "MEM ERR! NEED 4K!",0
Stage:    .db "STAGE",0
BossInf:  .db "BOSS",0
InfoScr:  .db "SCORE:",0
InfoShp:  .db "SHIPS:",0
GameOvr:  .db "GAME OVER!",0
NextStageStr: .db "NEXT STAGE!",0
HiScr:    .db "NEW HIGH SCORE!",0
EnterInit: .db "ENTER YOUR INITIALS:",0
HiScore:   .dw 11    ;This is standard hi-score
ByStr:     .db "HI: "
HiScrName: .db "AND"
NullByte:  .db " ",0
TheOption: .db "XC-1701 Select an option:",0
Option1:   .db "[F1] Please don",39,"t!",0
Option2:   .db "[F2] Come here!",0
Option3:   .db "[F3] Restore old game",0
Option4:   .db "[EXIT] You don",39,"t want to exit!",0
ASCII_Table:                   ;Thanks to Magnus H. for this Table!!!
  .db 0,0,0,0,0,0,0,0,0       ;00-09 - not valid
  .db 'X,'T','O','J','E'      ;0A-0E - valid
  .db 0,0                     ;0F-10 - not valid
  .db ' ','W','S','N','I'     ;11-15 - valid
  .db 'D'                     ;16    - valid
  .db 0,0                     ;17-18 - not valid
  .db 'Z','V','R','M','H','C' ;19-1E- valid
  .db 0,0                     ;1F-20 - not valid
  .db 'Y','U','Q','L','G','B' ;21-26 - valid
  .db 0,0,0,0                 ;27-2A - not valid
  .db 'P','K','F','A'         ;2B-2E - valid
  .db 0,0,0,0,0,0,0,0,0,0,0   ;Rest  - not valid
Congratul: .db "CONGRATULATIONS!",0
EndingTxt: .db "YOU'VE SURVIVED AND WON AGAINST"
	   .db " THE",0
EndingTx1: .db "ENEMY! THIS IS THE FIRST STEP T"
	   .db "O A FREE", 0
EndingTx2: .db "FUTURE OF THE HUMANS!",0

;'Cause of the lack of a random number function, I wrote some for the stars
;in the background:
RStarX:   .db 12,46,85,111,63,32,74,53,96,120,20
RStarY:   .db 12,43,36,51,6,21,46,19,3,55,0

;Levels:
Level1:   .db $00,$00,$AA,$AA,0,$01,$41,$41,$41,$40,0,$CC,$33,0,0,$55,0,0,$A9,$6A,0,$40,$50,$55,$15,$05,0,$D9,$76,0,$44
Level2:   .db $00,$55,$BB,$EE,$29,$2D,$ED,$6D,$19,$85,$E2,$3B,$0C,0,$11,$44,$22,$88,$33,$CC,0,$67,$67,$67,0,0,$AA,$55,0,$FF,$FF
Level3:   .db $00,$28,$02,$28,$81,$AA,$3D,$1D,$C5,$FF,$C3,$FC,$C0,$3F,$A8,$82,$28,$B7,$45,$40,$54,$45,$54,$FF,$FF,$82,$AA,$AA,$55,$55,$41
Level4:   .db $00,$55,$AA,$55,$AA,$FF,$FF,$55,$AA,$66,$EE,$DD,$41,$41,$82,$82,$C3,$C3,$96,$96,$96,$D7,$D7,$D7,$56,$95,$14,$14,$88,$88,$88
Level5:   .db $00,$FF,$FF,$FF,$AA,$41,$7D,$69,$7D,$69,$41,$41,$55,$AA,$55,$AA,$55,$FF,$FF,$00,$6C,$1B,$06,$01,$55,$55,$AA,$55,$FF,$FF,$55
Level6:   .db $00,$AA,$55,$AA,$AA,$FF,$FF,$55,$FF,$6D,$DB,$79,$6D,$41,$41,$41,$82,$82,$82,$C3,$C3,$C3,$41,$55,$AA,$FF,$FF,$00,$88,$41,$00
Level7:   .db $00,$55,$55,$55,$55,$AA,$00,$AA,$00,$AA,$FF,$FF,$FF,$41,$82,$A8,$69,$7D,$C3,$96,$CC,$88,$54,$AA,$FF,$AA,$FF,$00,$88,$55,$00
Level8:   .db $AA,$55,$AA,$FF,$AA,$EE,$BB,$2D,$FF,$69,$41,$41,$55,$DD,$EE,$FF,$FF,$FF,$C3,$82,$85,$3B,$CC,$64,$68,$AA,$FF,$FF,$AA,$AA,$00
Level9:   .db $FF,$FF,$FF,$FF,$AA,$AA,$FF,$78,$6C,$9C,$AC,$55,$55,$FF,$FF,$DD,$FF,$AA,$BB,$CC,$DD,$EE,$FF,$00,$11,$22,$33,$44,$55,$66,$77
Level10:  .db $AA,$FF,$AA,$FF,$55,$FF,$55,$81,$81,$81,$FF,$CA,$3E,$5A,$4C,$EE,$DD,$FF,$98,$78,$56,$34,$43,$35,$87,$78,$FF,$AA,$FF,$AA,$FF
;Bitmaps:
You1:     .db $10,$28,$28,$28,$FE,$FE,$7C,$38
	  .db $00,$30,$30,$30,$F0,$E0,$40,$20
YouLeft:  .db $10,$18,$18,$58,$FE,$FE,$7C,$38
	  .db $00,$20,$30,$70,$F0,$E8,$70,$38
YouRight: .db $08,$18,$18,$1A,$7F,$7F,$3E,$1C
	  .db $00,$04,$0C,$0E,$0F,$17,$0E,$1C
Planet1:  .db $00,$00,$04,$1E,$3E,$FE,$7C,$38
	  .db $00,$38,$78,$E0,$C2,$0E,$1C,$38
Star1:    .db $00,$08,$1C,$3E,$1C,$08,$00,$00
	  .db $08,$00,$14,$49,$14,$00,$08,$00
Saturn1:  .db $00,$38,$78,$F2,$E6,$CE,$1C,$38
	  .db $00,$04,$06,$0C,$18,$30,$E0,$40
Whirl1:   .db $00,$00,$38,$7C,$7C,$3C,$00,$00
	  .db $F0,$78,$C4,$92,$9A,$C2,$3C,$00
Aster1:   .db $70,$FE,$FF,$7F,$3F,$3E,$0C,$00
	  .db $00,$00,$01,$01,$03,$06,$0C,$00
GShip1:   .db $28,$7C,$7C,$44,$28,$28,$38,$10
	  .db $20,$70,$60,$78,$30,$30,$20,$00
DShip1:   .db $24,$3C,$7E,$C3,$C3,$66,$3C,$18
	  .db $20,$38,$78,$DC,$DC,$68,$30,$00
Glider1:  .db $42,$E7,$FB,$FB,$F3,$E7,$E7,$42
	  .db $42,$A5,$85,$85,$8D,$BD,$A5,$42
OShip1:   .db $7E,$FF,$FF,$7E,$00,$00,$81,$7E
	  .db $78,$FC,$F0,$60,$42,$42,$42,$00
WShip1:   .db $00,$00,$0E,$06,$0E,$FF,$FF,$7E
	  .db $18,$2C,$50,$78,$70,$1F,$0F,$3E
TShip1:   .db $C3,$E7,$FF,$C3,$E7,$E7,$7E,$3C
	  .db $C0,$E0,$F0,$F8,$F0,$D0,$00,$00
XGlider1: .db $18,$3C,$66,$C3,$C3,$66,$3C,$18
	  .db $18,$24,$5A,$A5,$A5,$5A,$24,$18
UFO1:     .db $08,$89,$5A,$3C,$7E,$7E,$66,$99
	  .db $0C,$08,$18,$00,$66,$42,$3C,$18
StShip1:  .db $80,$C2,$C2,$C0,$7E,$FF,$FF,$7E
	  .db $81,$81,$81,$83,$70,$F0,$E0,$40
GlassS1:  .db $44,$FA,$E2,$44,$44,$64,$38,$10
	  .db $44,$BE,$8E,$44,$44,$4C,$28,$10
XShip1:   .db $44,$10,$C3,$FF,$FF,$81,$C3,$7E
	  .db $00,$00,$C0,$F8,$F0,$FE,$FC,$60
JumpS1:   .db $43,$67,$3F,$3F,$0F,$87,$A5,$81
	  .db $80,$80,$C0,$C0,$F0,$F9,$A5,$81
Expl1:    .db $00,$00,$00,$08,$10,$00,$00,$00
	  .db $00,$00,$00,$08,$10,$00,$00,$00
Expl2:    .db $00,$00,$00,$1C,$14,$0C,$08,$00
	  .db $00,$00,$00,$14,$14,$08,$00,$00
Expl3:    .db $00,$18,$3E,$73,$33,$06,$1C,$00
	  .db $00,$00,$3C,$22,$32,$06,$1C,$00
Expl4:    .db $78,$C6,$C2,$E1,$23,$03,$7E,$3C
	  .db $78,$C4,$50,$E6,$32,$00,$18,$00
Expl5:    .db $3C,$6E,$C7,$A7,$E3,$47,$FF,$7E
	  .db $30,$78,$EC,$FE,$0E,$3E,$7C,$00
Bonus10:  .db $03,$07,$03,$1F,$27,$7B,$C7,$FF
	  .db $0C,$38,$60,$C0,$C1,$83,$07,$1F
Bonus20:  .db $00,$7F,$5F,$5F,$5F,$47,$7F,$FF
	  .db $FF,$FE,$DE,$DE,$DE,$C6,$FE,$00
Bonus30:  .db $00,$80,$78,$7C,$FE,$FE,$7C,$38
	  .db $BF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
Bonus40:  .db $7E,$FE,$C2,$E6,$E6,$C2,$FE,$00
	  .db $FF,$80,$BC,$98,$98,$BC,$80,$81

;-----------------------------------------------------------------------------
;Asteroids occur at the end of the level(>=v1.1)
;-----------------------------------------------------------------------------
Aster10:  .db $1C,$3C,$7E,$FC,$F8,$C0,$80,$00
	  .db $18,$3B,$71,$C3,$07,$3F,$7C,$70
Aster20:  .db $78,$3C,$1E,$1F,$1F,$0F,$04,$00
	  .db $08,$CC,$E6,$E7,$63,$70,$3A,$3E
Aster30:  .db $00,$01,$03,$1F,$3F,$7E,$3C,$38
	  .db $0E,$3E,$FC,$E0,$C3,$8E,$DC,$18
Aster40:  .db $00,$20,$F0,$F8,$F8,$78,$3C,$1E
	  .db $7C,$5C,$0E,$C6,$E7,$67,$33,$10

;-----------------------------------------------------------------------------
;Save game
;-----------------------------------------------------------------------------
GameSaved: .db 0 ;Game saved?
SaveGame:
 .db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
 .db 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

;The first boss:
Boss11:
 .db $03,$F8,$00,$07,$FC,$00,$0F,$FE,$00,$1E,$FF,$00,$3C,$FF,$80,$39
 .db $7F,$C0,$01,$FF,$C0,$03,$FF,$C0,$05,$FF,$E0,$0B,$FF,$F0,$0B,$FF
 .db $F8,$17,$FF,$F8,$17,$FF,$F8,$2B,$FF,$DC,$4B,$EF,$DE,$4B,$CF,$DF
 .db $53,$85,$CF,$53,$81,$CF,$4B,$81,$DE,$27,$00,$FC,$1B,$00,$F8,$07
 .db $FF,$F0,$07,$0F,$E0,$01,$FF,$80,$00,$78,$00,$01,$BC,$00,$00,$BE
 .db $00,$00,$7D,$00,$00,$FD,$80,$00,$FC,$40,$00,$FC,$40,$00,$FE,$40
 .db $02,$FE,$20,$04,$F6,$10,$04,$D2,$48,$08,$C2,$68,$08,$82,$68,$10
 .db $81,$54,$30,$91,$52,$30,$B1,$51,$20,$FB,$49,$20,$FF,$49,$30,$FF
 .db $52,$19,$FF,$E4,$05,$FF,$88,$00,$9F,$90,$00,$73,$A0,$00,$3F,$80
;And his logic:
BossLog1:
 .db 1,87,2,96,3,87,4,11,5,2,6,11,0

;The second boss:
Boss21:
 .db $07,$FF,$C0,$08,$0F,$E0,$33,$3F,$FE,$78,$0F,$FE,$F7,$FF,$CF,$F5
 .db $86,$47,$E8,$00,$27,$F4,$00,$4F,$F3,$FF,$8F,$F1,$01,$0F,$F0,$FE
 .db $1F,$F8,$00,$3F,$FC,$00,$3F,$7E,$00,$7E,$3F,$80,$FC,$1C,$C1,$F8
 .db $0E,$03,$F0,$03,$03,$E0,$00,$06,$C0,$00,$0C,$40,$00,$00,$C0,$00
 .db $00,$00,$00,$00,$00,$00,$00,$00,$07,$FF,$C0,$08,$70,$60,$33,$43
 .db $FE,$78,$F1,$FE,$FF,$FF,$FD,$FC,$41,$7F,$F9,$C7,$3D,$F4,$00,$7F
 .db $F3,$FF,$E9,$F1,$01,$C9,$B0,$FF,$91,$88,$7F,$31,$84,$00,$23,$42
 .db $00,$46,$27,$80,$8C,$1C,$C1,$88,$0E,$03,$10,$03,$03,$E0,$00,$07
 .db $C0,$00,$0F,$C0,$00,$01,$C0,$00,$00,$00,$00,$00,$00,$00,$00,$00
;And his logic:
BossLog2:
 .db 1,87,2,96,4,64,5,56,3,47,4,2,6,11,0

;The third boss:
Boss31:
 .db $10,$6A,$04,$28,$14,$0E,$27,$C1,$FE,$20,$BF,$BE,$18,$BB,$9C,$06
 .db $AB,$B0,$01,$AF,$C0,$00,$EF,$80,$00,$BF,$80,$2A,$8B,$AA,$55,$87
 .db $FF,$55,$8B,$FF,$55,$87,$FF,$55,$9F,$FF,$55,$AB,$FF,$55,$AB,$FF
 .db $55,$AB,$FF,$55,$AB,$FF,$35,$AB,$FE,$15,$AB,$FC,$0D,$9F,$F8,$05
 .db $43,$70,$02,$26,$20,$00,$1C,$00,$10,$00,$04,$28,$00,$0A,$27,$C1
 .db $F2,$2F,$FE,$C2,$1F,$EE,$EC,$07,$FE,$F0,$01,$FA,$C0,$00,$FB,$80
 .db $00,$FE,$80,$2A,$F4,$AA,$57,$F8,$D7,$57,$F4,$D7,$57,$F8,$D7,$57
 .db $FC,$D7,$57,$EA,$D7,$57,$EA,$D7,$57,$EA,$D7,$57,$EA,$D7,$37,$EA
 .db $D6,$17,$EA,$D4,$0F,$FC,$D8,$07,$7D,$50,$02,$3A,$20,$00,$1C,$00
;And his logic:
BossLog3: ;fly an '8'
 .db 2,60,3,52,2,56,6,60,5,52,6,56,0

;The big boss:
Boss41:
 .db $80,$00,$02,$E0,$00,$0E,$DF,$FF,$FE,$C0,$3F,$FE,$E0,$5F,$FE,$E0
 .db $5F,$FE,$E0,$DF,$FE,$F0,$9F,$FE,$EC,$BF,$EE,$63,$DF,$8C,$60,$9E
 .db $0C,$30,$9E,$18,$30,$9E,$18,$38,$9E,$38,$18,$5C,$30,$1C,$5C,$70
 .db $0C,$5C,$70,$16,$38,$F0,$03,$39,$B0,$11,$D7,$30,$00,$7C,$30,$00
 .db $00,$00,$00,$00,$00,$00,$00,$00,$80,$00,$02,$E0,$00,$0E,$DF,$FF
 .db $FE,$C1,$F8,$1E,$EF,$F4,$3E,$E3,$F4,$0E,$E7,$F2,$3E,$FF,$F2,$1E
 .db $EF,$FA,$EE,$63,$F7,$8C,$60,$F2,$0C,$30,$F2,$18,$30,$F2,$18,$38
 .db $F2,$38,$18,$74,$30,$0C,$74,$60,$1C,$74,$70,$0E,$38,$C0,$1B,$39
 .db $90,$09,$D7,$00,$18,$7C,$10,$00,$00,$00,$00,$00,$00,$00,$00,$00
;And his logic:
BossLog4:
 .db 2,82,6,94,5,82,3,56,5,30,3,18,2,30,6,56,0

;-----------------------------------------------------------------------------
;Titlepicture - 1.3K big!
;-----------------------------------------------------------------------------
;**GCP compressed picture data GCP (C)1996 by Andreas Ess
TitlePic:
 .db $67,$AB,$63,$AF,$64,$47,$68,$AB,$69,$AE,$48,$BE,$BE,$AF,$6A,$AB,$BE
 .db $44,$6A,$AF,$72,$AE,$BB,$63,$AF,$65,$AB,$BE,$AF,$65,$A0,$04,$66,$06
 .db $65,$AE,$A0,$03,$98,$AF,$AF,$BB,$64,$8F,$64,$0B,$66,$A0,$8F,$68,$8F
 .db $66,$AF,$AE,$63,$AB,$65,$43,$63,$AF,$67,$A8,$81,$45,$BA,$83,$63,$AB
 .db $A8,$82,$A9,$03,$9F,$BA,$66,$83,$64,$0B,$66,$03,$90,$8F,$65,$83,$67
 .db $AB,$BB,$BE,$AF,$65,$43,$63,$AF,$67,$AE,$03,$AE,$43,$B8,$65,$43,$90
 .db $48,$83,$BE,$AF,$63,$03,$64,$9F,$63,$44,$82,$64,$83,$64,$83,$64,$03
 .db $68,$AB,$64,$43,$67,$43,$63,$AF,$67,$AF,$B0,$8F,$43,$92,$64,$43,$90
 .db $48,$BC,$64,$AB,$64,$83,$69,$44,$8A,$63,$83,$66,$83,$64,$83,$64,$AB
 .db $66,$AF,$68,$43,$6D,$AF,$B0,$8F,$63,$8F,$64,$43,$03,$AB,$44,$64,$9F
 .db $BE,$AF,$BC,$8F,$68,$44,$8B,$63,$83,$66,$83,$64,$83,$6C,$AB,$69,$44
 .db $64,$AF,$BE,$BE,$AF,$B0,$8F,$B8,$AF,$64,$A4,$8A,$AE,$43,$69,$44,$BC
 .db $8F,$69,$A8,$9F,$BC,$8B,$66,$90,$64,$83,$6A,$43,$6B,$44,$64,$43,$BA
 .db $BE,$65,$03,$BC,$68,$A0,$8A,$AE,$43,$69,$AF,$63,$83,$6A,$A8,$AF,$B8
 .db $8F,$64,$AE,$83,$63,$82,$65,$AF,$44,$6B,$46,$63,$45,$63,$AB,$63,$03
 .db $B3,$69,$83,$43,$BA,$AF,$6E,$83,$6A,$A2,$AF,$B8,$8F,$63,$AF,$B0,$64
 .db $83,$67,$43,$63,$44,$66,$46,$63,$AF,$AB,$BE,$43,$BA,$04,$68,$AC,$8E
 .db $AB,$BB,$BB,$6D,$83,$69,$A4,$AF,$BB,$83,$BE,$65,$83,$63,$82,$64,$45
 .db $65,$43,$66,$46,$63,$AF,$AB,$63,$46,$B0,$8F,$BB,$65,$83,$43,$BE,$BE
 .db $6E,$83,$69,$A2,$AF,$AF,$83,$68,$83,$BE,$83,$BE,$BE,$BE,$65,$43,$66
 .db $46,$BE,$AE,$AB,$BA,$43,$BA,$A0,$8B,$68,$82,$43,$BA,$71,$82,$AF,$AF
 .db $AF,$92,$66,$83,$68,$83,$63,$83,$BA,$AE,$BE,$65,$AB,$66,$46,$BE,$BB
 .db $43,$BA,$BE,$43,$90,$87,$68,$82,$44,$73,$82,$AB,$AF,$AF,$8F,$66,$83
 .db $68,$82,$63,$83,$44,$64,$AF,$63,$AB,$67,$45,$BE,$BB,$43,$BE,$AF,$43
 .db $88,$83,$68,$82,$BA,$AF,$BB,$BB,$64,$AF,$64,$82,$69,$8F,$66,$83,$68
 .db $82,$63,$83,$AB,$6A,$AF,$68,$46,$66,$AB,$BA,$BE,$A0,$A8,$83,$67,$82
 .db $BE,$AF,$BB,$6E,$83,$68,$8B,$67,$82,$68,$83,$BB,$82,$AB,$67,$AE,$6B
 .db $47,$BA,$AE,$AB,$AB,$BA,$86,$A0,$8F,$66,$03,$AE,$BB,$71,$83,$BB,$65
 .db $8F,$67,$82,$68,$83,$BA,$82,$67,$AF,$6F,$44,$BB,$BA,$BE,$AF,$AF,$A1
 .db $44,$03,$68,$82,$63,$AF,$AB,$6D,$83,$BE,$64,$8F,$65,$AF,$82,$68,$82
 .db $43,$82,$BE,$63,$AB,$68,$AF,$65,$44,$64,$AB,$BA,$AE,$AC,$8A,$BB,$B0
 .db $8F,$65,$82,$BA,$AF,$BA,$6A,$AF,$82,$66,$A3,$AB,$63,$AF,$A0,$67,$83
 .db $44,$82,$65,$AB,$BE,$AF,$BB,$68,$44,$BE,$AE,$AE,$AB,$63,$86,$43,$B8
 .db $83,$66,$A0,$45,$BE,$AF,$8F,$68,$83,$66,$8F,$BB,$66,$A0,$67,$82,$AB
 .db $A0,$BE,$AF,$AF,$BE,$AF,$AF,$AF,$66,$44,$63,$43,$BA,$AF,$A2,$AB,$AB
 .db $A8,$83,$63,$AF,$A0,$9E,$AF,$A5,$8F,$69,$83,$66,$8F,$AB,$64,$43,$B0
 .db $64,$A0,$44,$B8,$8E,$45,$68,$AE,$69,$45,$63,$43,$BA,$AC,$8E,$AE,$43
 .db $B4,$83,$BB,$63,$A0,$86,$A9,$82,$BB,$66,$A0,$83,$BB,$A2,$43,$65,$43
 .db $63,$03,$B0,$86,$AB,$A0,$82,$AE,$AB,$67,$AE,$69,$45,$BB,$43,$B9,$05
 .db $AB,$BA,$AC,$05,$AF,$63,$A4,$05,$96,$BB,$66,$06,$63,$A2,$AF,$AB,$BA
 .db $AF,$64,$03,$BA,$63,$A0,$04,$AF,$AB,$69,$AB,$67,$45,$BE,$BA,$43,$BE
 .db $44,$BE,$AF,$B6,$44,$66,$45,$96,$AB,$AF,$68,$AF,$BE,$AB,$63,$44,$6D
 .db $AF,$64,$AB,$BA,$44,$65,$AF,$BA,$6A,$45,$BB,$BA,$43,$BA,$46,$BB,$BA
 .db $AB,$64,$AF,$BA,$44,$BA,$64,$AF,$44,$BB,$BA,$4A,$BE,$69,$AB,$65,$AB
 .db $43,$BA,$AF,$BA,$AB,$AE,$6B,$45,$BB,$63,$A9,$82,$90,$82,$B0,$63,$AB
 .db $B8,$87,$BE,$43,$BB,$BA,$83,$AF,$44,$BB,$BE,$AE,$AE,$63,$AB,$AF,$BC
 .db $05,$AF,$64,$46,$BE,$AF,$BA,$AF,$AF,$BB,$69,$45,$63,$43,$90,$B8,$8E
 .db $83,$A0,$63,$AF,$04,$AF,$46,$BA,$90,$BE,$BE,$AB,$43,$BE,$BE,$65,$44
 .db $64,$83,$BE,$64,$AE,$AE,$43,$BE,$AB,$BA,$AB,$BE,$6C,$46,$BA,$A8,$8F
 .db $B0,$63,$AF,$A0,$64,$83,$A0,$A0,$03,$AE,$05,$90,$B0,$94,$03,$43,$04
 .db $63,$05,$64,$83,$65,$05,$BC,$04,$44,$BA,$43,$BE,$AB,$6B,$4A,$83,$BC
 .db $8F,$BA,$BC,$8F,$BC,$8E,$81,$82,$A0,$A0,$98,$84,$83,$B8,$85,$82,$AF
 .db $A0,$A0,$8B,$65,$05,$BC,$82,$63,$03,$45,$BA,$44,$BE,$43,$6C,$48,$BC
 .db $8B,$B0,$63,$44,$83,$BE,$06,$90,$AC,$84,$8A,$81,$82,$AE,$06,$A8,$04
 .db $BC,$03,$65,$83,$65,$04,$BD,$04,$43,$BA,$44,$BE,$43,$6D,$47,$BE,$83
 .db $B0,$BC,$89,$83,$64,$83,$B0,$90,$AC,$84,$89,$81,$82,$AE,$81,$AE,$A0
 .db $A8,$8F,$BC,$83,$63,$83,$67,$03,$BA,$A0,$8A,$AE,$43,$BA,$BA,$6F,$44
 .db $BB,$BE,$83,$A0,$82,$A0,$9F,$63,$83,$B0,$90,$A8,$89,$05,$90,$AE,$A8
 .db $03,$AE,$05,$A0,$03,$65,$06,$B0,$03,$BC,$04,$AF,$63,$AB,$BA,$BA,$6F
 .db $45,$65,$AF,$AB,$AB,$BB,$AB,$63,$AF,$BA,$47,$BA,$A9,$44,$BE,$BA,$AE
 .db $AF,$AF,$77,$AF,$A6,$44,$BE,$BE,$48,$70,$45,$BE,$63,$AB,$AF,$64,$AB
 .db $63,$AF,$AE,$BA,$4E,$64,$AF,$BA,$73,$AF,$66,$AF,$46,$64,$AE,$47,$71
 .db $45,$BE,$BA,$AB,$AB,$63,$44,$63,$AF,$BA,$BA,$BA,$43,$BA,$43,$BA,$AF
 .db $AB,$BB,$66,$AF,$6A,$AF,$65,$AF,$BA,$AE,$AF,$BE,$BE,$46,$72,$45,$63
 .db $44,$8A,$B3,$B8,$AB,$04,$B8,$03,$AC,$43,$8F,$BC,$03,$A8,$82,$04,$BC
 .db $04,$B3,$BC,$B0,$83,$63,$8F,$B2,$BC,$AB,$AF,$BA,$BB,$46,$75,$AE,$AF
 .db $45,$8A,$B3,$B2,$8B,$8F,$B2,$8A,$A2,$A2,$8B,$AB,$8A,$A2,$B3,$A3,$A8
 .db $63,$8F,$B3,$BC,$B3,$BC,$BC,$B3,$B8,$B3,$44,$63,$AE,$AF,$44,$BA,$74
 .db $44,$BE,$AE,$05,$B3,$A8,$B0,$83,$A0,$82,$AB,$8A,$44,$04,$AB,$8F,$04
 .db $64,$8F,$B0,$03,$B3,$BC,$B3,$BC,$BE,$8F,$AB,$BB,$BA,$64,$47,$BA,$71
 .db $45,$BA,$B8,$43,$8C,$04,$B3,$64,$8A,$AE,$AC,$46,$8A,$A2,$B3,$B3,$8F
 .db $63,$8F,$B3,$BC,$B3,$BC,$B0,$03,$BE,$8F,$A8,$AB,$BE,$BE,$46,$BB,$AF
 .db $71,$44,$BE,$B8,$BE,$8C,$63,$88,$BB,$BC,$43,$BB,$A2,$AB,$A8,$03,$A8
 .db $83,$8F,$8F,$B8,$63,$8F,$B3,$04,$BC,$63,$8F,$A3,$B8,$44,$BE,$BE,$44
 .db $BA,$77,$AE,$70,$AB,$65,$43,$63,$AB,$4A,$7F,$64,$AB,$BB,$BA,$AB,$64
 .db $45,$BA,$78,$43,$6F,$AB,$66,$47,$BA,$AE,$AE,$AB,$63,$AF,$72,$AF,$69
 .db $AF,$BE,$44,$63,$45,$63,$AF,$77,$44,$6E,$AF,$65,$43,$05,$A8,$03,$B3
 .db $B8,$B0,$03,$B3,$64,$8A,$AE,$8A,$AE,$AF,$67,$AE,$45,$63,$47,$7E,$44
 .db $6E,$AB,$63,$AB,$AE,$A2,$A3,$43,$B3,$B8,$B3,$64,$8A,$AF,$8A,$43,$8A
 .db $AF,$AB,$66,$AB,$44,$64,$47,$BE,$7D,$44,$6E,$AB,$BA,$BA,$A8,$44,$03
 .db $A8,$04,$B0,$82,$A3,$43,$B3,$BA,$A2,$45,$66,$48,$63,$46,$7F,$65,$44
 .db $6D,$AB,$BB,$AE,$A2,$47,$88,$63,$8C,$BA,$A8,$45,$8F,$BA,$46,$65,$46
 .db $BE,$63,$44,$65,$AF,$7F,$BA,$AF,$69,$AE,$AF,$AF,$BC,$04,$A0,$82,$A3
 .db $BC,$A0,$03,$A0,$03,$A0,$03,$A2,$43,$65,$47,$64,$AF,$43,$64,$AB,$7F
 .db $63,$44,$6B,$AB,$AF,$64,$AB,$BE,$43,$67,$AF,$BE,$AB,$AE,$AB,$AB,$BA
 .db $BE,$65,$47,$67,$AB,$64,$AF,$7F,$64,$43,$BE,$6A,$45,$BE,$63,$43,$BA
 .db $AE,$64,$AB,$63,$4B,$66,$AF,$44,$BE,$69,$43,$BA,$AF,$7F,$68,$46,$BB
 .db $65,$45,$BB,$BA,$BA,$BE,$43,$BE,$44,$BE,$45,$64,$AF,$65,$AE,$AB,$66
 .db $AB,$64,$46,$7F,$6C,$45,$6A,$AB,$BB,$AB,$BA,$BE,$45,$BA,$AF,$BA,$43
 .db $6C,$AF,$AB,$6D,$46,$7F,$6F,$47,$64,$AF,$AE,$43,$BE,$BA,$47,$BE,$AF
 .db $AE,$BE,$6C,$45,$67,$AE,$63,$44,$7F,$73,$46,$64,$49,$BA,$4C,$6C,$AF
 .db $63,$AF,$63,$45,$BB,$BA,$BA,$BA,$AB,$7F,$75,$43,$BB,$BE,$48,$BA,$48
 .db $BA,$AF,$6B,$AF,$BE,$66,$50,$7F,$79,$45,$64,$52,$BE,$43,$66,$AF,$6A
 .db $53,$7F,$7C,$46,$BA,$51,$BA,$45,$6E,$52,$7F,$7F,$BE,$5D,$BB,$BB,$64
 .db $AB,$63,$50,$7F,$7F,$66,$4F,$BA,$AB,$BA,$BA,$63,$AF,$65,$44,$BE,$4D
 .db $7F,$7F,$6B,$4D,$BA,$AB,$6A,$44,$64,$48,$BA,$44,$7F,$7F,$70,$50,$65
 .db $AF,$BA,$4C,$BE,$45,$7F,$7F,$76,$50,$BE,$56,$77,$8F,$BC,$83,$B3,$7F
 .db $79,$5F,$AB,$79,$83,$66,$8C,$7F,$7F,$BA,$53,$7F,$BC,$65,$83,$B0,$8F
 .db $7F,$7F,$7F,$74,$8F,$65,$8C,$BC,$7F,$7F,$7F,$74,$03,$B3,$03,$BC,$BC
 .db $00

;Ending picture:
EndingPic:
 .db $71,$9A,$82,$AF,$7F,$7F,$7F,$7A,$9B,$90,$8B,$7F,$7F,$7F,$79,$A2,$B4
 .db $03,$AF,$7F,$7F,$7F,$77,$A2,$B4,$05,$7F,$7F,$7F,$73,$46,$9B,$90,$05
 .db $A7,$7F,$7F,$7F,$70,$85,$96,$43,$85,$A0,$04,$7F,$7F,$7F,$71,$81,$82
 .db $90,$85,$90,$05,$7F,$7F,$7F,$6F,$03,$A5,$99,$1F,$83,$7F,$7F,$78,$91
 .db $91,$96,$90,$19,$A0,$03,$7F,$7F,$78,$43,$23,$43,$1B,$A0,$90,$87,$7F
 .db $7F,$72,$43,$B8,$06,$90,$19,$92,$03,$A7,$7F,$7F,$71,$91,$98,$1F,$85
 .db $9F,$04,$97,$7F,$7F,$70,$44,$B9,$90,$81,$28,$85,$94,$85,$2D,$81,$9F
 .db $7F,$7F,$71,$45,$25,$81,$27,$59,$7F,$7F,$75,$43,$2F,$A9,$54,$7F,$7F
 .db $79,$AF,$A5,$2F,$A6,$9A,$48,$7F,$7F,$7F,$BB,$BB,$63,$A5,$2A,$49,$7F
 .db $7F,$77,$4A,$67,$97,$B9,$99,$26,$AB,$63,$A9,$94,$81,$96,$94,$08,$96
 .db $A5,$27,$81,$23,$04,$9A,$AB,$63,$49,$23,$AF,$BE,$48,$23,$A5,$96,$BA
 .db $A5,$24,$04,$9A,$A6,$B8,$85,$90,$03,$45,$05,$9A,$AB,$A9,$05,$23,$03
 .db $23,$85,$23,$85,$9A,$45,$90,$2A,$44,$91,$2A,$44,$91,$23,$81,$23,$63
 .db $43,$94,$81,$44,$BC,$AF,$09,$43,$94,$9A,$A9,$90,$91,$81,$81,$9A,$A5
 .db $85,$23,$43,$23,$43,$BA,$48,$BA,$44,$63,$A9,$23,$48,$63,$A9,$23,$44
 .db $99,$9A,$24,$03,$45,$64,$86,$B0,$06,$A0,$03,$9A,$A9,$07,$96,$44,$69
 .db $43,$BE,$43,$65,$43,$24,$A5,$43,$67,$46,$9A,$AF,$65,$4D,$90,$03,$9A
 .db $A4,$81,$04,$AC,$06,$A4,$96,$AF,$64,$4A,$7E,$48,$6E,$43,$6E,$45,$BE
 .db $96,$9A,$94,$04,$24,$A6,$B0,$04,$47,$75,$AF,$64,$43,$BA,$AB,$6E,$AB
 .db $67,$47,$6A,$47,$68,$90,$96,$44,$23,$44,$BC,$9C,$04,$45,$64,$44,$BA
 .db $48,$64,$44,$64,$AF,$77,$4F,$BE,$4E,$65,$A8,$85,$47,$BA,$AB,$B8,$9C
 .db $81,$43,$BB,$69,$A9,$84,$0A,$90,$06,$9A,$44,$72,$AB,$63,$AF,$68,$AB
 .db $63,$AF,$6B,$8A,$50,$83,$91,$69,$47,$25,$A5,$03,$9A,$44,$2D,$AB,$66
 .db $43,$7F,$6D,$04,$9A,$BE,$48,$66,$AB,$45,$90,$05,$43,$BA,$44,$9A,$65
 .db $57,$24,$44,$70,$AF,$73,$A1,$9A,$48,$9A,$43,$BE,$44,$24,$81,$9A,$9A
 .db $AB,$BA,$43,$99,$49,$24,$A9,$A5,$44,$27,$47,$70,$AF,$6E,$44,$63,$A6
 .db $43,$24,$A9,$91,$91,$86,$53,$90,$03,$23,$4A,$9A,$45,$23,$5F,$57,$63
 .db $49,$94,$08,$96,$AE,$43,$9A,$A6,$44,$25,$A4,$9B,$45,$69,$44,$94,$9A
 .db $4A,$BA,$4F,$BE,$4E,$BE,$63,$AB,$47,$9A,$44,$05,$23,$85,$A0,$84,$07
 .db $24,$47,$BE,$43,$69,$A4,$05,$9A,$4A,$BE,$AB,$BA,$47,$63,$43,$BE,$48
 .db $63,$4A,$BA,$45,$94,$03,$9A,$A9,$43,$23,$04,$23,$43,$23,$A6,$54,$27
 .db $43,$65,$45,$65,$4A,$63,$AB,$BA,$48,$63,$44,$BE,$A0
 .db $00

TotalAddr = 9

AddrTable:
 .db 2
 .dw ShowAct
 .dw P1_ShowAct,P5_ShowAct
 .db 1
 .dw ShowActG
 .dw P1_ShowActG
 .db 5
 .dw StatusLine
 .dw P1_Status,P2_Status,P3_Status,P4_Status,P5_Status
 .db 11
 .dw Bitmap
 .dw P1_Bitmap,P2_Bitmap,P3_Bitmap,P4_Bitmap,P5_Bitmap,P6_Bitmap,P7_Bitmap,P8_Bitmap,P9_Bitmap,P10_Bitmap,P11_Bitmap
 .db 7
 .dw PointOn
 .dw P1_PointOn,P2_PointOn,P3_PointOn,P4_PointOn,P5_PointOn,P6_PointOn,P7_PointOn
 .db 3
 .dw GameLoop
 .dw J1_GameLoop, J2_GameLoop, J3_GameLoop
 .db 1
 .dw You1
 .dw L1_You+1
 .db 1
 .dw YouLeft
 .dw L1_YouLeft+1
 .db 1
 .dw YouRight
 .dw L1_YouRight+1

#include fastcall.h
#include gcp.asm

.end
