;GRAF-WRITE
;(C) 1996 by Andreas Ess
; 	     Tufers 156
;	     A-6811 Goefis
;	     Austria/Europe
;This program can be used to add remarks to a graph
;You may use parts of this source code in your own program,
;but please give me an appropriate credit if you do so.
;If you modify it, you aren't allowed to re-distribute it.
;
;This program isn't optimized, so send me a letter if you find something to
;make faster or if you've got a suggestion what can be added;
;GRAFWR is also nothing special, I just needed it, and
;G-TEXT was to slow...

#INCLUDE "TI-85.H"

;Variables in text-mem:
TablePt = TEXT_MEM   ;pointer to ASCII-table
TableNm = TEXT_MEM+2 ;number of table
CursorL = TEXT_MEM+3 ;cursor look
TheText = TEXT_MEM+4 ;The text is stored here

 .org 0
TitleStr:
 .db  "Grafwrite 0.1 by AE", 0

Start:
 ROM_CALL(CLEARLCD)
 ld   a, 0
 ld   (TableNm), a
 ld   hl, (PROGRAM_ADDR)
 ld   de, ASCIITab3
 add  hl, de
 ld   (TablePt), hl
 ld   a, $DD
 ld   (CursorL), a
 ld   hl, $0101
 ld   de, TitleStr
 CALL_(DisplayText)
 ld   hl, $0801
 ld   de, Cpright
 CALL_(DisplayText)
 ld   hl, $0F01
 ld   de, InfoStr
 CALL_(DisplayText)
 ld   hl, $1601
 ld   de, InfoStr1
 CALL_(DisplayText)
 CALL_(WaitEnter)
BeginProgram:
 CALL_(CopyGraf2LCD)   ;show graf
 ld   hl, $0101
 ld   de, KeyStr
 CALL_(DisplayText)
 CALL_(WaitEnter)
 CALL_(WaitNotEnter)
 CALL_(EnterText)
 cp   0
 jr   z, EndProg
 CALL_(WaitNotEnter)
 CALL_(CopyGraf2LCD)   ;show graf
 CALL_(CursorInput)
 cp   0
 jr   z, EndProg
 CALL_(CopyLCD2Graf)
 jr   BeginProgram
EndProg:
 ret

;------------------------------------------------------------------------------
;DisplayText: displays the text in DE at position(H,L) in menustyle
;------------------------------------------------------------------------------
DisplayText:
 ld   ($8333), hl
 ld   hl, (PROGRAM_ADDR)
 add  hl, de
 ROM_CALL(D_ZM_STR)
 ret

;------------------------------------------------------------------------------
;WaitNotEnter: waits until enter is released
;------------------------------------------------------------------------------
WaitNotEnter:
 call GET_KEY
 cp   $09
 jr   z, WaitEnter
 ret

;------------------------------------------------------------------------------
;WaitEnter: waits for enter pressed
;------------------------------------------------------------------------------
WaitEnter:
 call GET_KEY
 cp   $09
 jr   nz, WaitEnter
 ret

;------------------------------------------------------------------------------
;CopyGraf2LCD: copies graf-mem to lcd-mem
;------------------------------------------------------------------------------
CopyGraf2LCD:
 push hl
 push bc
 ld  hl, GRAPH_MEM ;hl contains source
 ld  de, VIDEO_MEM ;de contains destination
 ld  bc, 1024      ;bc bytes to move
 ldir              ;that's it
 pop  bc
 pop  hl
 ret

;------------------------------------------------------------------------------
;CopyLCD2Graf: the other way round...
;------------------------------------------------------------------------------
CopyLCD2Graf:
 ld  hl, VIDEO_MEM ;hl contains source
 ld  de, GRAPH_MEM ;de contains destination
 ld  bc, 1024      ;bc bytes to move
 ldir              ;that's it
 ret

;------------------------------------------------------------------------------
;Enter text: prompts for the remark
;------------------------------------------------------------------------------
EnterText:
 ROM_CALL(CLEARLCD)
 ld  hl, $0101
 ld  de, EnterStr
 CALL_(DisplayText)
 ld  hl, $0001      ;set text-cursor
 ld  ($800C), hl
 ld  a, (CursorL)
 ROM_CALL(TX_CHARPUT)
 ld  hl, (TablePt)
 dec hl
 ld  de, TheText
WaitKey:
; push  de
WaitKey1:
 push  hl
 call  GET_KEY
 pop   hl
 cp    0
 jr    z, WaitKey1
 cp    $09         ;Enter pressed?
 jr    z, EndText
 cp    $37         ;Exit pressed
 jr    z, ExitEnd
 cp    $36         ;2nd to change table
 jr    z, ChangeCursor
 push  hl
 ld    b, a
 ld    c, 0
ConversionLoop:
 inc   hl
 djnz  ConversionLoop          ;After this, we have the correct offset...
 ld    a, (hl)
 pop   hl
 cp    0         ;invalid key?
 jr    z, WaitKey
 push  hl
 ld    hl, ($800C)
 dec   h           ;dec x-pos
 ld    ($800C), hl
 ROM_CALL(TX_CHARPUT) ;write letter
 pop   hl
; pop   de
 ld    (de), a        ;save letter
 inc   de
 ld    a, (CursorL)
 ROM_CALL(TX_CHARPUT) ;show cursor
 jr    WaitKey        ;next letter

ChangeCursor:
 push de
; pop   de
 ld    a, (TableNm)
 inc   a
 cp    3
 jr    nz, SaveCursorL
 ld    a, 0
SaveCursorL:
 ld    (TableNm), a
 ld    b, $DD   ;modify cursor
 add   a, b
 ld    (CursorL), a
 push  hl
 ld    hl, ($800C)
 dec   h           ;dec x-pos
 ld    ($800C), hl
 pop   hl
 ld    a, (CursorL)
 ROM_CALL(TX_CHARPUT) ;show cursor

 ld    a, (TableNm)
 cp    0
 jr    z, SetNumTable
 cp    1
 jr    z, SetABCTable
 cp    2
 jr    nz, PerformSet
 ld    de, ASCIITab2
 jr    PerformSet
SetNumTable:
 ld    de, ASCIITab3
 jr    PerformSet
SetABCTable:
 ld    de, ASCIITab1
PerformSet:
 ld    hl, (PROGRAM_ADDR)
 add   hl, de
 ld    (TablePt), hl
 dec   hl
 pop de
 JUMP_(WaitKey)

EndText:
; pop   de
 ld    a, 0           ;zero-terminated string
 ld    (de), a
 ld    a, 1           ;ACC=1 succesful exit
 ret
ExitEnd:
 ;pop   de
 ld    a, 0           ;ACC=0 exit to ZShell
 ret

;------------------------------------------------------------------------------
;Cursorinput
;------------------------------------------------------------------------------
CursorInput:
 ld  b, 10
 ld  c, 10
KeyLoop:
 CALL_(CopyGraf2LCD)  ;draw graf-screen
 ld   ($8333), bc
 ld   hl, TheText
 ROM_CALL(D_ZM_STR)
KeyLoop1:
 push hl
 call GET_KEY
 pop  hl
 cp   0
 jr   z, KeyLoop1
 CALL_(CopyGraf2LCD)
 cp   $09
 jr   z, CursorDone
 cp   $37
 jr   z, ExitDone
 cp   1
 jr   z, CurDown
 cp   2
 jr   z, CurLeft
 cp   3
 JUMP_Z(CurRight)
 cp   4
 jr   nz, KeyLoop
 ;default: move up
 ld   a, b
 cp   0
 jr   z, KeyLoop
 dec  b
 jr   KeyLoop
CurDown:
 ld   a, b
 cp   63
 jr   z, KeyLoop
 inc  b
 jr   KeyLoop
CurLeft:
 ld   a, c
 cp   0
 jr   z, KeyLoop
 dec  c
 jr   KeyLoop
CurRight:
 ld   a, c
 cp   127
 jr   z, KeyLoop
 inc  c
 jr   KeyLoop
CursorDone:
 ld   ($8333), bc
 ld   hl, TheText
 ROM_CALL(D_ZM_STR)
 ret
ExitDone:
 ret

;------------------------------------------------------------------------------
;Textstrings:
;------------------------------------------------------------------------------
InfoStr: .db "This program can be used to ",0
InfoStr1: .db "add remarks to the graf-screen",0
Cpright:  .db "(C) 1996 by Andreas Ess",0
KeyStr: .db "PRESS ANY KEY",0
EnterStr: .db "ENTER TEXT, EXIT TO QUIT",0

;------------------------------------------------------------------------------
;ASCII-Tables:
;------------------------------------------------------------------------------
ASCIITab3:
 .db $07,$CF,$D7,$06,0,0,0,0,0       ;00-09 - (not) valid
 .db $2B,$2D,$2A,$2F,$5E     	     ;0A-0E - valid
 .db 0,0,$1A,'3','6','9',')'
 .db 0,0,0,'.','2','5','8','('
 .db 0,0,0,'0','1','4','7',$1B
 .db 0,0,0,0,0,$2C,$12,0,0,0,0
 .db 0,0,0,0,0,0,0,0

ASCIITab1:
 .db $07,$CF,$D7,$06,0,0,0,0,0       ;00-09 - (not) valid
 .db 'X,'T','O','J','E'      ;0A-0E - valid
 .db 0,0                     ;0F-10 - not valid
 .db ' ','W','S','N','I'     ;11-15 - valid
 .db 'D'                     ;16    - valid
 .db 0,0                     ;17-18 - not valid
 .db 'Z','V','R','M','H','C' ;19-1E- valid
 .db 0,0                     ;1F-20 - not valid
 .db 'Y','U','Q','L','G','B' ;21-26 - valid
 .db 0,0,0                   ;27-29 - not valid
 .db '=','P','K','F','A'     ;2A-2E - valid
 .db 0,0,0,0,0,0,0,0,0,0     ;Rest  - not valid

ASCIITab2:
 .db $07,$CF,$D7,$06,0,0,0,0,0       ;00-09 - (not) valid
 .db 'x,'t','o','j','e'      ;0A-0E - valid
 .db 0,0                     ;0F-10 - not valid
 .db ' ','w','s','n','i'     ;11-15 - valid
 .db 'd'                     ;16    - valid
 .db 0,0                     ;17-18 - not valid
 .db 'z','v','r','m','h','c' ;19-1E- valid
 .db 0,0                     ;1F-20 - not valid
 .db 'y','u','q','l','g','b' ;21-26 - valid
 .db 0,0,0                   ;27-29 - not valid
 .db '=','p','k','f','a'     ;2A-2E - valid
 .db 0,0,0,0,0,0,0,0,0,0     ;Rest  - not valid


.end
