#include "TI-85.H"              

.org 0                  
.db "ASCII v1.0 by MSv",0       
charpage = $80DF   ;no tab before var-name!

  ld a, $00
  ld (charpage), a        ;init vars

  ROM_CALL(BUSY_ON)
  CALL_(DrawScreen)

Wait:
  call GET_KEY            
  cp $37
  ret z
  cp $01
  jr z, Increase
  cp $04
  jr z, Decrease
  cp $36
  CALL_Z(COPYSCREEN)
  JUMP_(Wait)
Increase:
  ld a, (charpage)
  cp $60
  JUMP_Z(Wait)
  add a, $10
  ld (charpage), a
  CALL_(DrawScreen)
  JUMP_(Wait)
Decrease:
  ld a, (charpage)
  cp $0
  JUMP_Z(Wait)
  sub $10
  ld (charpage), a
  CALL_(DrawScreen)
  JUMP_(Wait)

DispA:
  ld b, a
  rr a
  rr a
  rr a
  rr a
  cp $a
  JUMP_NC(DispAa)
  add a, $30
DispAa:
  ROM_CALL(TX_CHARPUT)
  ld a, b
  and $f
  cp $9
  JUMP_NC(DispAb)
  add a, $30
DispAb:
  ROM_CALL(TX_CHARPUT)
  ret 

TopLine: .db "  0123456789", $a, $b, $c, $d, $e, $f,"   ",0

DrawScreen:
  ROM_CALL(CLEARLCD)      ; Setting up screen
  set 3,(IY+05)
  ld a, $0
  ld (CURSOR_ROW), a
  ld (CURSOR_COL), a
  ld hl, (PROGRAM_ADDR)
  ld de, TopLine
  add hl, de
  ROM_CALL(D_ZT_STR)
  res 3,(IY+05)
  ld a, $1                ;init values
  ld (CURSOR_ROW), a
col_start:
  set 3,(IY+05)          ;print row-index
  ld a, $0
  ld (CURSOR_COL), a
  ld a, (CURSOR_ROW)
  sub $1
  rl a
  rl a
  rl a
  rl a
  ld b, a
  ld a, (charpage)
  add a, b
  CALL_(DispA)
  res 3,(IY+05)
row_start:
  ld a, (CURSOR_ROW)
  dec a
  rl a
  rl a
  rl a
  rl a
  ld b, a
  ld a, (CURSOR_COL)
  add a, b
  sub $2
  ld b, a
  ld a, (charpage)
  add a, b
  ROM_CALL(TX_CHARPUT)
  ld a, (CURSOR_COL) 
  cp $12
  JUMP_NZ(row_start)
  ld a, (CURSOR_ROW)
  inc a
  ld (CURSOR_ROW), a
  cp $8
  JUMP_NZ(col_start)
  ret

COPYSCREEN:     ;Routine by Ed Plese, Jr. (shadow37@interserv.com)
        ld      hl,$FC00
        ld      de,GRAPH_MEM
        ld      bc,1024
        ldir
        ret

.end    


