 PIC2GRAY.ASMg           @@/          `   @@@TEXTMACA  <      >  L??,                         ;Pic2Gray.asm by Thayne Miller
;NOTE: this program was made by Rob Taylor and originally used a string to store the ;pictures, it was then modified a bit by me.  Thanks Rob!

#INCLUDE "TI-85.h"
.org 0

	.db	"Pic->Gray by Thayne Miller",0

TempContrast = 80dfh

Start:


	ld	a,(CONTRAST)
	ld	(TempContrast),a

	CALL_(GrayScaleOn)
	JUMP_C(MemoryError)

	ld	hl,(PROGRAM_ADDR)
	ld	de,PicName3
	add	hl,de
	RST	20h
	RST	10h
	JUMP_C(NotFound)
	ld	hl,(PROGRAM_ADDR)
	ld	de,PicName2
	add	hl,de
	RST	20h
	RST	10h
	JUMP_C(NotFound)
	ld	hl,(PROGRAM_ADDR)
	ld	de,PicName1
	add	hl,de
	RST	20h
	RST	10h
	JUMP_C(NotFound)
	cp	11H
	JUMP_NZ(NotPic)
	ex	de,hl
	ld	a,(hl)
	or	a
	cp	F0H
	JUMP_NZ(NotPic)
	inc	hl
	ld	a,(hl)
	cp	3
	JUMP_NZ(NotPic)
	inc	hl
	ld	de,FC00h
	ld	bc,1008
	ldir
	ld	hl,(PROGRAM_ADDR)
	ld	de,PicName2
	add	hl,de
	RST	20h
	RST	10h
	cp	11H
	JUMP_NZ(NotPic)
	ex	de,hl
	ld	a,(hl)
	or	a
	cp	F0H
	JUMP_NZ(NotPic)
	inc	hl
	ld	a,(hl)
	cp	3
	JUMP_NZ(NotPic)
	inc	hl
	ld	de,(Page2Addr)
	ld	bc,1008
	ldir
	ld	hl,(PROGRAM_ADDR)
	ld	de,PicName3
	add	hl,de
	RST	20h
	RST	10h
	cp	11H
	JUMP_NZ(NotPic)
	ex	de,hl
	ld	a,(hl)
	or	a
	cp	F0H
	JUMP_NZ(NotPic)
	inc	hl
	ld	a,(hl)
	cp	3
	JUMP_NZ(NotPic)
	inc	hl
	ld	de,(Page3Addr)
	ld	bc,1008
	ldir


MainLoop:
	call	GET_KEY
	cp	37h
	jr	z,ExitMain

TestUp:
	cp	K_UP
	jr	nz, TestDown

	ld	hl,TempContrast
	inc	(hl)            
	ld	a,(TempContrast)       
	out 	(2),a           
	                     

TestDown:
	cp	K_DOWN 
	jr	nz,MainLoop   

	ld	hl,TempContrast
	dec	(hl)            
	ld	a,(TempContrast)       
	out	(2),a           

	jr	MainLoop

ExitMain:

	call	CALL_
	defw	GrayScaleOff
	ret


MemoryError:
	ROM_CALL(CLEARLCD)
	ld	hl,(PROGRAM_ADDR)
	ld	de,MemErrorString
	add	hl,de
	ROM_CALL(D_ZT_STR)
	CALL_(WaitKey)
	ret

NotFound:
	CALL_(GrayScaleOff)
	ROM_CALL(CLEARLCD)
	ld	hl,(PROGRAM_ADDR)
	ld	de,NotFoundString
	add	hl,de
	ROM_CALL(D_ZT_STR)
	CALL_(WaitKey)
	ret


NotPic:
	CALL_(GrayScaleOff)
	ROM_CALL(CLEARLCD)
	ld	hl,(PROGRAM_ADDR)
	ld	de,NotPicString
	add	hl,de
	ROM_CALL(D_ZT_STR)
	CALL_(WaitKey)
	ret


WaitKey:
	call	GET_KEY
	or	a
	jr	nz,WaitKey

WaitKey_2:
	call	GET_KEY
	cp	K_EXIT
	jr	nz,WaitKey_2
	ret


MemErrorString:
	.db "Not enough memory",0

NotPicString:
	.db "GrayPic1/2/3 is not apicture",0


NotFoundString:
	.db "Couldn't find        GrayPic1/2/3",0

PicName1:
	.db 11h,8
	.db	"GrayPic1",0


PicName2:
	.db	11h,8
	.db	"GrayPic2"
	.db	0
PicName3:
	.db	11h,8
	.db	"GrayPic3"
	.db	0

Page2 = 8981H
Page3 = 8982H
Count = 8980H
Page2Addr = 8983H
Page3Addr = 8985H

GrayScaleOn:
	ld	hl,(8be5h)	;get end of VAT
	dec	hl
	dec	hl	;make sure we're clear it..

			; now we need to get the position of
			; the nearest screen boundary

	ld	a,h
	sub	8	;2*1k (1k=1024=$0400)
	ld	h,a
	ld	l,0
	push	hl

			;Tests if there is a space for the 3K
			;needed for the 2nd+3rd screens 

	ld	de,(8be1h)
	or	a
	sbc	hl,de
	pop	hl
	jr	c,GrayError        

			;Save out the address of our 2nd Screen

	ld	(Page2Addr),hl

			; test if our block of memory
			; is within the range addressable
			; by the LCD hardware

	and	%11000000
	cp	%11000000
	jr	nz,GrayError      

			; It is, so save out the byte to send to port 0
			; to switch to our 2nd screen

	ld	a,h
	and	%00111111
	ld	(Page2),a

	ld	a,h
	add	a,4
	ld	h,a
	ld	(Page3Addr),hl

	and	%00111111
	ld	(Page3),a


	CALL_(InstallInterrupt)
	or	a	;clear carry flag - alls OK
	ret

GrayError:
	scf		;set carry flag - Error occured
	ret


GrayScaleOff:
	im	1

	ld	a,3ch
	out	(0),a	;Set screen back to normal

			;This is just to clear the
			;Graph screen, so people don't
			;Complain about rubbish appearing
			;On it..

	ld	hl,GRAPH_MEM           
	ld	d,h                    
	ld	e,l                   
	inc	de                    
	ld	(hl),0
	ld	bc,1024
	ldir
	ret

Wait_GrayVBL:	; Wait for the VBl routine to finish drawing the screen

	ld	a,(Count)
	or	a
	ret	z
	jr	Wait_GrayVBL

InstallInterrupt:

	ld	a,88h          
	ld	hl,8700h	 
	ld	(hl),a		 
	inc	hl		 
	ld	b,0		 
CopyLoop:
	ld	(hl),a		 
	inc	hl		 
	djnz	CopyLoop
	       

	ld	hl,(PROGRAM_ADDR)	 
	ld	de,Int_Rout 
	add	hl,de	; get the rout we want to be called
	ld	de,8888h	;where it gets called from
	ld	bc,Int_RoutEnd+1-Int_Rout         
	ldir		; copy it there

	ld	a,0
	ld	(Count),a

	ld	a,87h
	ld	i,a

	im	2
	ret

       
Int_Rout:

	ex	af,af'
	exx		 

	in	a,(3)
	bit	1,a	; check that it is a vbl interrupt
	jr	z,EndInt

	ld	a,(Count)
	cp	6
	jr	z,Disp_3
	cp	4
	jr	c,Disp_1
	jr	Disp_2

Disp_1:
	inc	a
	ld	(Count),a
	ld	a,3ch
	out	(0),a
	jr	EndInt
Disp_2:
	inc	a
	ld	(Count),a
	ld	a,(Page2)
	out	(0),a
	jr	EndInt

Disp_3:
	ld	a,(Page3)
	out	(0),a
	sub	a
	ld	(Count),a
EndInt:
	exx	
	ex	af,af'
	jp	38h	

Int_RoutEnd:

END
                                                                             2              Ml*Clean Sweeppic->grey tempt   TEXTttxt   TEXTttxt                 ?    LileList+ 1.0b20.sea                 MmCustom Icon Pack II.sea              MmMega Desktop Texture Pac.sea         Mn-                               2 TX    2  styl   
      T                                                    