/* This file is part of RHIDE, Copyright (C) 1996 Robert Hhne */
#define Uses_ifpstream
#define Uses_ofpstream
#define Uses_MsgBox
#define Uses_TDialog
#define Uses_TListBox
#define Uses_TDeskTop
#define Uses_TProgram
#define Uses_TScrollBar
#define Uses_TFileDialog
#define Uses_TFileInputLine
#define Uses_TKeys
#define Uses_TProject
#define Uses_TDepCollection
#define Uses_TSCollection
#define Uses_TWindowList
#define Uses_TOptions
#define Uses_TProjectWindow
#define Uses_TProjectListBox
#define Uses_TDirList
#define Uses_TParamList
#define Uses_IDEConst
#define Uses_TEditWindow
#define Uses_TFileEditor
#define Uses_TIDEFileEditor
#define Uses_TStringCollection
#define Uses_LangTexte

#include <IDEClass.h>
#include "IDE.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <limits.h>
#include <libc/dosio.h>
#include <unistd.h>

TProject *project;
TProjectWindow *project_window;
char * project_name;

static void writeView(TView *p, void *strm)
{
   TEvent event;
   event.what = evCommand;
   event.message.command = cmEditorAnswer;
   p->handleEvent(event);
   if (event.what == evNothing) *((ofpstream *)strm) << p;
}

void SaveDesktop(ofpstream & os)
{
  int n,i,m,w;
  TEvent event;
  uchar len = TProgram::application->getPalette()[0];
  os << len;
  os.writeBytes(&(TProgram::application->getPalette()[1]),len);
  if (project_window) m = 1; else m = -1;
  os << m;
  if (windows) n=windows->getCount();
  else n=0;
  w = n;
  for (i=0;i<n;i++)
  {
    event.what = evCommand;
    event.message.command = cmEditorAnswer;
    DESKTOPWINDOW(i)->handleEvent(event);
    if (event.what != evNothing) w--;
  }
  os << w;
  TProgram::deskTop->forEach(::writeView,&os);
}

void LoadDesktop(ifpstream & is)
{
  int i,p,n;
  TView *view;
  uchar len;
  char *pal;
  is >> len;
  pal = new char[len+1];
  is.readBytes(pal,len);
  if (len < TProgram::application->getPalette()[0])
  {
    uchar _len = TProgram::application->getPalette()[0];
    char *_pal = new char[_len+1];
    memcpy(_pal,pal,len);
    memcpy(_pal+len,&(TProgram::application->getPalette()[len+1]),_len-len);
    delete pal;
    len = _len;
    pal = _pal;
  }
  TPalette pa(pal,len);
  TProgram::application->getPalette() = pa;
  delete pal;
  is >> p;
  if (p>=0) ShowProject();
  is >> n;
  for (i=0;i<n;i++)
  {
    is >> view;
    AddWindow((TWindow *)view);
  }
  if (n>0) view->select();
  Repaint();
}

static void ClearDeskTop(Boolean remove_msg = True)
{
  if (windows)
  {
    int delta = 0;
    while (windows->getCount()>delta)
    {
      TWindow *window = DESKTOPWINDOW(delta);
      if (window != msg_window || remove_msg == True)
      {
        RemoveWindow(window);
        window->close();
      }
      else
      {
        delta++;
      }
    }
    if (windows->getCount() == 0)
    {
      delete windows;
      windows = NULL;
    }
  }
  project_window = NULL;
  if (msg_window && remove_msg == True) msg_window = NULL;
}

static Boolean OpenStandardProject(const char *prjname)
{
  ifpstream *ifile,*idfile;
  char *dir,*tmp;
  char * magic = NULL;
  string_dup(tmp,RHIDE_DIR);
  string_cat(tmp,RHIDE_NAME);
  string_cat(tmp,DESKTOP_EXT);
  string_dup(dir,RHIDE_DIR);
  string_cat(dir,RHIDE_NAME);
  string_cat(dir,PROJECT_EXT);
  ifile = new ifpstream(dir);
  string_free(dir);
  if (ifile->good())
  {
    char *ext;
    magic = ifile->readString();
    if (!ifile->good() || strcmp(magic,PROJECT_IDENT))
    {
      if (magic) delete magic;
      delete ifile;
      string_free(tmp);
      return False;
    }
    *ifile >> project;
    delete ifile;
    TEditor::tabSize = project->tabsize;
    TProgram::application->setScreenMode(project->screen_mode);
    TProgram::deskTop->redraw();
    TProgram::application->redraw();
    idfile = new ifpstream(tmp);
    if (idfile->good()) LoadDesktop(*idfile);
    else ShowProject();
    string_free(tmp);
    delete idfile;
    string_free(Project.dest_name);
    split_fname(prjname,dir,Project.dest_name,ext);
    string_free(dir);
    string_free(ext);
    return True;
  }
  string_free(tmp);
  return False;
}

static char *dskname;

Boolean ReadProject(const char *prjname)
{
  ifpstream *ifile;
  char *magic;
  ifile = new ifpstream(prjname);
  if (ifile->good())
  {
    magic = ifile->readString();
    if (!ifile->good() || strcmp(magic,PROJECT_IDENT))
    {
      messageBox(mfError | mfOKButton,GT(MsgInvalidProject),prjname,magic);
      delete(ifile);
      return False;
    }
    delete magic;
    *ifile >> project;
    if (!ReservedWords) DefaultReservedWords();
    delete ifile;
    return True;
  }
  delete ifile;
  return False;
}

static void LoadDesktop()
{
  char *dir,*ext;
  ifpstream *idfile;
  if (dskname) string_free(dskname);
  split_fname(project_name,dir,dskname,ext);
  string_cat(dskname,DESKTOP_EXT);
  string_free(dir);
  string_free(ext);
  idfile = new ifpstream(dskname);
  if (idfile->good()) LoadDesktop(*idfile);
  else ShowProject();
  delete idfile;
}

Boolean OpenProject(const char * prjname)
{
  ifpstream *idfile;
  ofpstream *ofile;
  int i;
  if (project != NULL) CloseProject();
  ClearFindCache();
  ClearFileHash();
  project = NULL;
  project_name = NULL;
  if (!prjname)
  {
    project = new TProject();
    Project.source_file_type = FILE_UNKNOWN;
    Project.dest_file_type = FILE_UNKNOWN;
    Project.compile_id = COMPILE_UNKNOWN;
    Project.source_name = NULL;
    Project.dest_name = NULL;
    InitOptions();
    return True;
  }
  {
    char *name,*ext;
    split_fname(prjname,project_name,name,ext);
    string_dup(dskname,project_name);
    string_cat(project_name,name);
    string_cat(dskname,name);
    string_cat(dskname,DESKTOP_EXT);
    if (!*ext) string_cat(project_name,PROJECT_EXT);
    else string_cat(project_name,ext);
    string_free(name);
    string_free(ext);
  }
  if (ReadProject(prjname) == True)
  {
    ClearDeskTop();
    TEditor::tabSize = project->tabsize;
    TProgram::application->setScreenMode(project->screen_mode);
    TProgram::deskTop->redraw();
    TProgram::application->redraw();
    idfile = new ifpstream(dskname);
    if (idfile->good()) LoadDesktop(*idfile);
    else ShowProject();
    delete idfile;
  }
  if (!project) OpenStandardProject(project_name);
  if (project)
  {
    if (!ReservedWords)
    {
      DefaultReservedWords();
      TProgram::deskTop->redraw();
    }
    if (windows != NULL)
    {
      int count = windows->getCount();
      for (i=0;i<count;i++)
      {
        TEditWindow * ew = (TEditWindow *)DESKTOPWINDOW(i);
        TEvent event;
        event.what = evCommand;
        event.message.command = cmEditorAnswer;
        ew->handleEvent(event);
        if (event.what == evNothing)
        {
          if (AutoIndent) ew->editor->autoIndent = True;
          else ew->editor->autoIndent = False;
          if (OverWrite) ew->editor->overwrite = True;
          else ew->editor->overwrite = False;
        }
      }
    }
    if (CreateBackupFiles)
      TEditor::editorFlags |= efBackupFiles;
    else
      TEditor::editorFlags &= ~efBackupFiles;
    return True;
  }
  ofile = new ofpstream(project_name);
  if (ofile->good())
  {
    delete ofile;
    char *dir,*ext;
    remove(project_name);
    project = new TProject();
    Project.source_file_type = FILE_UNKNOWN;
    Project.dest_file_type = FILE_COFF;
    Project.compile_id = COMPILE_LINK;
    Project.source_name = NULL;
    split_fname(project_name,dir,Project.dest_name,ext);
    string_free(dir);
    string_free(ext);
    InitOptions();
    ShowProject();
    return True;
  }
  delete ofile;
  messageBox(mfError | mfOKButton,GT(MsgCantOpen),project_name);
  return False;
}

typedef struct {
  TProject *project;
  char *pname;
  char *dname;
} project_stack;

static project_stack *PROJECT_STACK = NULL;
static stack_count = 0;

Boolean PushProject(char *directory,char *prjname)
{
  stack_count++;
  PROJECT_STACK = (project_stack *)realloc(PROJECT_STACK,
                                           stack_count*sizeof(project_stack));
  project_stack * ps = PROJECT_STACK + (stack_count-1);
  ps->pname = project_name;
  ps->dname = getcwd(NULL,512);
  ps->project = project;
  if (stack_count == 1) // The desktop is only for the first one valid
    SaveProject();
  chdir(directory);
  if (debug_commands)
  {
    fprintf(stderr,"changing cwd to %s\n",directory);
  }
  project = NULL;
  project_name = NULL;
  if (ReadProject(prjname) == True)
  {
    string_dup(project_name,prjname);
    ClearFileHash();
    ClearFindCache();
    if (debug_commands)
    {
      fprintf(stderr,"temporary opening project %s\n",prjname);
    }
    return True;
  }
  stack_count--;
  project_name = ps->pname;
  project = ps->project;
  chdir(ps->dname);
  string_free(ps->dname);
  PROJECT_STACK = (project_stack *)realloc(PROJECT_STACK,
                                           stack_count*sizeof(project_stack));
  if (stack_count == 0)
    PROJECT_STACK = NULL;
  return False;
}

void PopProject()
{
  if (stack_count == 0) return;
  stack_count--;
  project_stack * ps = PROJECT_STACK + stack_count;
  delete project;
  chdir(ps->dname);
  if (debug_commands)
  {
    fprintf(stderr,"changing cwd to %s\n",ps->dname);
    fprintf(stderr,"closing temporary opened project project %s\n",project_name);
  }
  string_free(project_name);
  project_name = ps->pname;
  string_free(ps->dname);
  project = ps->project;
  PROJECT_STACK = (project_stack *)realloc(PROJECT_STACK,
                                           stack_count*sizeof(project_stack));
  if (stack_count == 0)
    PROJECT_STACK = NULL;
}

void ResetProjectStack()
{
  project_stack *ps;
  int i;
  while (stack_count > 0)
  {
    ps = PROJECT_STACK + (stack_count-1);
    string_free(ps->dname);
    stack_count--;
  }
  free(PROJECT_STACK);
  PROJECT_STACK = NULL;
  ClearDeskTop(False);
  TEditor::tabSize = project->tabsize;
  TProgram::application->setScreenMode(project->screen_mode);
  TProgram::deskTop->redraw();
  TProgram::application->redraw();
  LoadDesktop();
  if (windows != NULL)
  {
    int count = windows->getCount();
    for (i=0;i<count;i++)
    {
      TEditWindow * ew = (TEditWindow *)DESKTOPWINDOW(i);
      TEvent event;
      event.what = evCommand;
      event.message.command = cmEditorAnswer;
      ew->handleEvent(event);
      if (event.what == evNothing)
      {
        if (AutoIndent) ew->editor->autoIndent = True;
        else ew->editor->autoIndent = False;
        if (OverWrite) ew->editor->overwrite = True;
        else ew->editor->overwrite = False;
      }
    }
  }
  if (debug_commands)
  {
    fprintf(stderr,"finaly opening project %s\n",project_name);
  }
  if (msg_window) msg_window->select();
}

void SaveProject()
{
  ofpstream *file,*dfile;
  if (!project_name) return;
  file = new ofpstream(project_name);
  dfile = new ofpstream(dskname);
  file->writeString(PROJECT_IDENT);
  *file << project;
  SaveDesktop(*dfile);
  delete file;
  delete dfile;
}

void CloseProject()
{
  SaveProject();
  delete project;
  project = NULL;
  if (project_name)
  {
    string_free(project_name);
    project_name = NULL;
    string_free(dskname);
    ClearDeskTop();
  }
}

void ShowProject(void)
{
  if (!project_window)
  {
    TRect r = TProgram::deskTop->getExtent();
    r.a.y = r.b.y - 7;
    project_window = new TProjectWindow(r,Project.dependencies,GT(TitlePrjWindow));
    AddWindow(project_window);
  }
  project_window->select();
}

void HideProjectWindow()
{
}

void AddProjectItem(void)
{
  TFileDialog *dialog;
  int result;
  TDependency *dep;
  dialog = new TFileDialog(Project.defaultprojectmask,
                           GT(TitleAddItem),GT(LabelName),fdOKButton,0);
  TProgram::deskTop->insert(dialog);
  do
  {
    dialog->setState(sfModal,True);
    result = dialog->execute();
    if (result == cmFileOpen)
    {
      char *dir,*fname,*ext;
      ccIndex index;
      string_free(Project.defaultprojectmask);
      string_dup(Project.defaultprojectmask,dialog->wildCard);
      string_dup(fname,dialog->fileName->data);
      if (!_USE_LFN) string_down(fname);
      if (Project.dependencies->search(fname,index) == True)
      {
        messageBox(mfError | mfOKButton,GT(MsgDupItem),fname);
        string_free(fname);
      }
      if (fname)
      {
        dep = new TDependency();
        string_dup(dep->source_name,fname);
        string_free(fname);
        split_fname(dep->source_name,dir,fname,ext);
        if (get_file_type(ext) == FILE_LIBRARY)
        {
          string_dup(dep->dest_name,dep->source_name);
          dep->dest_file_type = FILE_LIBRARY;
          dep->source_file_type = FILE_LIBRARY;
          dep->compile_id = COMPILE_NONE;
        }
        else if (get_file_type(ext) == FILE_PROJECT)
        {
          dep->dest_file_type = FILE_LIBRARY;
          dep->source_file_type = FILE_PROJECT;
          dep->compile_id = COMPILE_PROJECT;
          string_dup(dep->dest_name,dialog->directory);
          if (!_USE_LFN) string_down(dep->dest_name);
          string_cat(dep->dest_name,fname);
          string_cat(dep->dest_name,".a");
        }
        else
        {
          string_dup(dep->dest_name,fname);
          string_cat(dep->dest_name,".o");
          dep->compile_id = how_to_compile(ext,".o");
          dep->dest_file_type = FILE_OBJECT;
          dep->source_file_type = get_file_type(ext);
        }
        string_free(dir);
        string_free(fname);
        string_free(ext);
        Project.dependencies->atInsert(index,dep);
        if (project_window)
        {
          project_window->liste->setRange(Project.dependencies->getCount());
          project_window->liste->focusItem(index);
          project_window->liste->drawView();
        }
      }
    }
  } while (result != cmCancel);
  TProgram::deskTop->remove(dialog);
  delete dialog;
}

void DelProjectItem(void)
{
  if (!project_window) return;
  if (Project.dependencies->getCount()>0)
  {
    int i = project_window->liste->focused;
    TDependency *dep = (TDependency *)Project.dependencies->at(i);
    if (messageBox(mfYesNoCancel,GT(MsgRemoveItem),
                   dep->source_name) == cmYes)
    {
      Project.dependencies->atRemove(i);
      delete dep;
      project_window->liste->setRange(Project.dependencies->getCount());
      project_window->liste->drawView();
    }
  }
}

void WriteVariables(FILE *f)
{
  int i;
  TSCollection *args;
  fprintf(f,"CC=gcc\n");
  fprintf(f,"AS=gcc\n");
  fprintf(f,"LD=gcc\n");
  fprintf(f,"AR=ar\n");
  fprintf(f,"ARFLAGS=rcs\n");
  fprintf(f,"ALL_CFLAGS=$(INCLUDE_DIRS) $(C_DEBUG_FLAGS) $(C_OPT_FLAGS) \\\n");
  fprintf(f,"\t$(C_WARN_FLAGS) $(C_EXTRA_FLAGS) $(CPPFLAGS) \\\n");
  fprintf(f,"\t$(C_C_LANG_FLAGS) $(CFLAGS)\n");
  fprintf(f,"ALL_CXXFLAGS=$(INCLUDE_DIRS) $(C_DEBUG_FLAGS) $(C_OPT_FLAGS) \\\n");
  fprintf(f,"\t$(C_WARN_FLAGS) $(CXX_EXTRA_FLAGS) $(CPPFLAGS) $(CXXFLAGS) \\\n");
  fprintf(f,"\t$(C_CXX_LANG_FLAGS)\n");
  fprintf(f,"ALL_LD_FLAGS=$(LD_EXTRA_FLAGS) $(LD_FLAGS)\n");
  fprintf(f,"ALL_AS_FLAGS=$(AS_EXTRA_FLAGS) $(AS_FLAGS)\n");
  fprintf(f,"INCLUDE_DIRS=");
  for (i=0;i<Options.include_path->getCount();i++)
  {
    fprintf(f," \\\n\t");
    fprintf(f,"-I%s",(char *)Options.include_path->at(i));
  }
  fprintf(f,"\n");
  fprintf(f,"LIB_DIRS=");
  for (i=0;i<Options.library_path->getCount();i++)
  {
    fprintf(f," \\\n\t");
    fprintf(f,"-L%s",(char *)Options.library_path->at(i));
  }
  fprintf(f,"\n");
  fprintf(f,"C_DEBUG_FLAGS=");
  args = new TSCollection();
  AddDebugFlags(*args);
  for (i=0;i<args->getCount();i++)
  {
    fprintf(f," \\\n\t");
    fprintf(f,"%s",(char *)args->at(i));
  }
  fprintf(f,"\n");
  delete args;
  fprintf(f,"C_OPT_FLAGS=");
  args = new TSCollection();
  AddOptimizationFlags(*args);
  for (i=0;i<args->getCount();i++)
  {
    fprintf(f," \\\n\t");
    fprintf(f,"%s",(char *)args->at(i));
  }
  fprintf(f,"\n");
  delete args;
  fprintf(f,"C_WARN_FLAGS=");
  args = new TSCollection();
  AddWarningFlags(*args);
  for (i=0;i<args->getCount();i++)
  {
    fprintf(f," \\\n\t");
    fprintf(f,"%s",(char *)args->at(i));
  }
  fprintf(f,"\n");
  delete args;
  fprintf(f,"C_C_LANG_FLAGS=");
  args = new TSCollection();
  AddCFlags(*args);
  for (i=0;i<args->getCount();i++)
  {
    fprintf(f," \\\n\t");
    fprintf(f,"%s",(char *)args->at(i));
  }
  fprintf(f,"\n");
  delete args;
  fprintf(f,"C_CXX_LANG_FLAGS=");
  args = new TSCollection();
  AddCXXFlags(*args);
  for (i=0;i<args->getCount();i++)
  {
    fprintf(f," \\\n\t");
    fprintf(f,"%s",(char *)args->at(i));
  }
  fprintf(f,"\n");
  delete args;
  fprintf(f,"LIBS=");
  args = new TSCollection();
  AddLibraries(*args);
  for (i=0;i<args->getCount();i++)
  {
    fprintf(f," \\\n\t");
    fprintf(f,"%s",(char *)args->at(i));
  }
  fprintf(f,"\n");
  delete args;
  fprintf(f,"LD_EXTRA_FLAGS=");
  args = new TSCollection();
  AddLinkerOptions(*args);
  for (i=0;i<args->getCount();i++)
  {
    fprintf(f," \\\n\t");
    fprintf(f,"%s",(char *)args->at(i));
  }
  fprintf(f,"\n");
  delete args;
  fprintf(f,"C_EXTRA_FLAGS=");
  args = new TSCollection();
  AddCompilerOptions(*args);
  for (i=0;i<args->getCount();i++)
  {
    fprintf(f," \\\n\t");
    fprintf(f,"%s",(char *)args->at(i));
  }
  fprintf(f,"\n");
  delete args;
  fprintf(f,"CXX_EXTRA_FLAGS=");
  args = new TSCollection();
  AddCompilerOptions(*args);
  for (i=0;i<args->getCount();i++)
  {
    fprintf(f," \\\n\t");
    fprintf(f,"%s",(char *)args->at(i));
  }
  fprintf(f,"\n");
  delete args;
  fprintf(f,"AS_EXTRA_FLAGS=");
  fprintf(f,"\n");
  fprintf(f,"OBJ_DIR=");
  if (Options.ObjDirs->getCount() > 0)
  {
    fprintf(f,"%s\n",(char *)Options.ObjDirs->at(0));
  }
  else fprintf(f,".\n");
  fprintf(f,"OUTFILE=$(addprefix $(OBJ_DIR)/,$@)\n");
  fprintf(f,"LOCAL_OPT=$(subst ___~~~___, ,$(subst $@___,,$(filter $@___%c,$(LOCAL_OPTIONS))))\n",'%');
  fprintf(f,"\n%c.o: %c.cpp\n\t",'%','%');
  fprintf(f,"$(CC) $(ALL_CXXFLAGS) -c $< $(LOCAL_OPT) -o $(OUTFILE)\n\n");
  fprintf(f,"\n%c.s: %c.cpp\n\t",'%','%');
  fprintf(f,"$(CC) $(ALL_CXXFLAGS) -S $< $(LOCAL_OPT) -o $(OUTFILE)\n\n");
  fprintf(f,"\n%c.o: %c.cc\n\t",'%','%');
  fprintf(f,"$(CC) $(ALL_CXXFLAGS) -c $< $(LOCAL_OPT) -o $(OUTFILE)\n\n");
  fprintf(f,"\n%c.s: %c.cc\n\t",'%','%');
  fprintf(f,"$(CC) $(ALL_CXXFLAGS) -S $< $(LOCAL_OPT) -o $(OUTFILE)\n\n");
  fprintf(f,"\n%c.o: %c.c\n\t",'%','%');
  fprintf(f,"$(CC) $(ALL_CFLAGS) -c $< $(LOCAL_OPT) -o $(OUTFILE)\n\n");
  fprintf(f,"\n%c.s: %c.c\n\t",'%','%');
  fprintf(f,"$(CC) $(ALL_CFLAGS) -S $< $(LOCAL_OPT) -o $(OUTFILE)\n\n");
  fprintf(f,"%c.o: %c.s\n\t",'%','%');
  fprintf(f,"$(AS) $(ALL_AS_FLAGS) -c $< $(LOCAL_OPT) -o $(OUTFILE) $<\n\n");
}

static TSCollection *targets;
static int depcount;

static Boolean AddTarget(const char * name)
{
  int i;
  char * tmp;
  for (i=0;i<targets->getCount();i++)
  {
    if (!strcmp(name,(char *)targets->at(i))) return False;
  }
  string_dup(tmp,name);
  targets->insert(tmp);
  return True;
}

static void WriteTarget(FILE *f,TDependency *dep)
{
  int i;
  if (AddTarget(dep->dest_name) == False) return;
  if (!dep->dest_name)
  {
    if (!dep->dependencies || dep->dependencies->getCount() == 0) return;
  }
  fprintf(f,"DEPS_%d=",depcount);
  depcount++;
  if (dep->source_name)
  {
    if (dep->compile_id != COMPILE_PROJECT)
    {
      fprintf(f,"%s",dep->source_name);
    }
  }
  if (dep->dependencies && dep->dependencies->getCount()>0)
  {
    for (i=0;i<dep->dependencies->getCount();i++)
    {
      TDependency *_dep = (TDependency *)dep->dependencies->at(i);
      if (_dep->compile_id == COMPILE_PROJECT)
      {
        char *dir,*name,*ext;
        split_fname(_dep->dest_name,dir,name,ext);
        dir[strlen(dir)-1] = 0;
        fprintf(f,"\\\n\t\t$(%s%s.dir)/%s%s",name,ext,name,ext);
        string_free(dir);
        string_free(name);
        string_free(ext);
      }
      else
      {
        fprintf(f,"\\\n\t\t%s",_dep->dest_name);
      }
    }
  }
  fprintf(f,"\n");
  if (dep->compile_id == COMPILE_PROJECT)
  {
    char *dir,*name,*ext;
    split_fname(dep->dest_name,dir,name,ext);
    dir[strlen(dir)-1] = 0;
    fprintf(f,"$(%s%s.dir)/%s%s: $(DEPS_%d) force\n",name,ext,name,ext,depcount-1);
    string_free(dir);
    string_free(name);
    string_free(ext);
  }
  else
  {
    fprintf(f,"%s: $(DEPS_%d)\n",dep->dest_name,depcount-1);
  }
  if (dep->local_options->getCount()>0)
  {
    fprintf(f,"LOCAL_%d=",(depcount-1));
    for (i=0;i<dep->local_options->getCount();i++)
    {
      char buffer[1000],*_buffer=(char *)(dep->local_options->at(i));
      char *tmp = buffer;
      int has_spaces = 0;
      if (strchr(_buffer,' ') != NULL) has_spaces = 1;
      strcpy(tmp,dep->dest_name);
      strcat(tmp,"___");
      while (*tmp) tmp++;
      if (has_spaces)
      {
        *tmp = '\'';
        tmp++;
      }
      while (*_buffer)
      {
        if (*_buffer == ' ')
        {
          *tmp = 0;
          strcat(tmp,"___~~~___");
          while (*tmp) tmp++;
        }
        else
        {
          *tmp = *_buffer;
          tmp++;
        }
        _buffer++;
      }
      if (has_spaces)
      {
        *tmp = '\'';
        tmp++;
      }
      *tmp = 0;
      fprintf(f,"\\\n\t%s",buffer);
    }
    fprintf(f,"\nLOCAL_OPTIONS += $(LOCAL_%d)\n",(depcount-1));
  }
  if (dep->dependencies && dep->dependencies->getCount()>0)
  {
    switch (dep->compile_id)
    {
      case COMPILE_LINK:
	fprintf(f,"\t$(LD) $(ALL_LD_FLAGS) -o $@ ");
	fprintf(f," $(addprefix $(OBJ_DIR)/,$(filter %c.o,$(DEPS_%d))) $(filter-out %c.o,$(DEPS_%d))",'%',depcount-1,'%',depcount-1);
	fprintf(f,"\\\n\t$(LIB_DIRS) $(LIBS)\n");
	break;
      case COMPILE_ARCHIVE:
        fprintf(f,"\trm -f $@\n");
	fprintf(f,"\t$(AR) $(ARFLAGS) $@");
	fprintf(f," $(addprefix $(OBJ_DIR)/,$(filter %c.o,$(DEPS_%d))) $(filter-out %c.o,$(DEPS_%d))",'%',depcount-1,'%',depcount-1);
	fprintf(f,"\n");
	break;
      default:
	break;
    }
    for (i=0;i<dep->dependencies->getCount();i++)
    {
      WriteTarget(f,(TDependency *)dep->dependencies->at(i));
    }
  }
  if (dep->compile_id == COMPILE_PROJECT)
  {
    char drive[256],dir[256],name[256];
    fnsplit(dep->dest_name,drive,dir,NULL,NULL);
    dir[strlen(dir)-1] = 0;
    strcat(drive,dir);
    fnsplit(dep->source_name,NULL,NULL,name,NULL);
    fprintf(f,"\t$(MAKE) -C %s -f %s.mak\n",drive,name);
    if (PushProject(drive,dep->source_name) == True)
    {
      int _depcount = depcount;
      TSCollection *_targets = targets;
      WriteMake();
      PopProject();
      depcount = _depcount;
      targets = _targets;
    }
  }
}

static void WriteTargets(FILE *f)
{
  depcount = 0;
  targets = new TSCollection();
  WriteTarget(f,project);
  delete targets;
}

static void check_vars(TStringCollection *vars,TDirList *dirs)
{
  int i;
  ccIndex index;
  char *tmp,*temp,*temp_end,c;
  for (i=0;i<dirs->getCount();i++)
  {
    tmp = (char *)dirs->at(i);
    while ((temp = strchr(tmp,'$')) != NULL)
    {
      temp+=2;
      tmp = temp;
      temp_end = strchr(temp,')');
      if (!temp_end) continue;
      c = *temp_end;
      *temp_end = 0;
      if (vars->search(temp,index) == False)
      {
        vars->insert(strdup(temp));
      }
      *temp_end = c;
      tmp = temp_end+1;
    }
  }
}

void WriteMake(void)
{
  char *dir,*fname,*ext,*name;
  FILE *f;
  TStringCollection *vars = new TStringCollection(10,10);
  int i;
  split_fname(project_name,dir,fname,ext);
  string_dup(name,dir);
  string_cat(name,fname);
  string_cat(name,".mak");
  f = fopen(name,"wt");
  fprintf(f,"# This file is automaticly generated by RHIDE\n");
  check_vars(vars,Options.SrcDirs);
  check_vars(vars,Options.ObjDirs);
  check_vars(vars,Options.include_path);
  check_vars(vars,Options.library_path);
  for (i=0;i<vars->getCount();i++)
  {
    char *var,*env;
    var = (char *)vars->at(i);
    env = getenv(var);
    fprintf(f,"%s=",var);
    if (env) fprintf(f,"%s",env);
    fprintf(f,"\n");
  }
  delete vars;
  if (Project.dependencies)
  {
    for (i=0;i<Project.dependencies->getCount();i++)
    {
      TDependency *_dep = (TDependency *)Project.dependencies->at(i);
      if (_dep->compile_id == COMPILE_PROJECT)
      {
        char *dir,*name,*ext;
        split_fname(_dep->dest_name,dir,name,ext);
        dir[strlen(dir)-1] = 0;
        fprintf(f,"%s%s.dir=%s\n",name,ext,dir);
        string_free(dir);
        string_free(name);
        string_free(ext);
      }
    }
  }
  if (Options.SrcDirs->getCount() > 0)
  {
    fprintf(f,"vpath_src=");
    for (i=0;i<Options.SrcDirs->getCount();i++)
    {
      if (i>0) fprintf(f,";");
      fprintf(f,"%s",((char *)Options.SrcDirs->at(i)));
    }
    fprintf(f,"\n");
    fprintf(f,"vpath %c.c $(vpath_src)\n",'%');
    fprintf(f,"vpath %c.cc $(vpath_src)\n",'%');
    fprintf(f,"vpath %c.cpp $(vpath_src)\n",'%');
    fprintf(f,"vpath %c.s $(vpath_src)\n",'%');
    fprintf(f,"vpath %c.S $(vpath_src)\n",'%');
  }
  if (Options.ObjDirs->getCount() > 0)
  {
    fprintf(f,"vpath_obj=");
    for (i=0;i<Options.ObjDirs->getCount();i++)
    {
      if (i>0) fprintf(f,";");
      fprintf(f,"%s",((char *)Options.ObjDirs->at(i)));
    }
    fprintf(f,"\n");
    fprintf(f,"vpath %c.o $(vpath_obj)\n",'%');
  }
  WriteVariables(f);
  fprintf(f,"all: %s\n",Project.dest_name);
  WriteTargets(f);
  fprintf(f,"\n");
  fprintf(f,"force:\n\n");
  fclose(f);
  string_free(dir);
  string_free(fname);
  string_free(ext);
  string_free(name);
}

void LocalOptions()
{
  TDependency *dep;
  char *tmp;
  if (!project_window) return;
  if (project->dependencies->getCount() == 0) return;
  dep = (TDependency *)(project->dependencies->at(project_window->liste->focused));
  string_dup(tmp,GT(TextLocalOpt));
  string_cat(tmp,dep->source_name);
  EditParamList(dep->local_options,tmp);
  string_free(tmp);
}

class TIncListBox : public TSortedListBox
{
public:
  TIncListBox(const TRect &r,int cols,TScrollBar *bar) :
    TSortedListBox(r,cols,bar) {}
  virtual void handleEvent(TEvent &);
  virtual void selectItem(ccIndex);
};

void TIncListBox::selectItem(ccIndex item)
{
  TSortedListBox::selectItem(item);
  endModal(cmOK);
}

void TIncListBox::handleEvent(TEvent &event)
{
  TSortedListBox::handleEvent(event);
  switch (event.what)
  {
    case evKeyDown:
      switch (event.keyDown.keyCode)
      {
        case kbEnter:
          if (range > 0) selectItem(focused);
          clearEvent(event);
          break;
        default:
          break;
      }
    default:
      break;
  }
}

class TIncCollection : public TStringCollection
{
public:
  TIncCollection() : TStringCollection(16,16)
  {
    duplicates = True;
  }
  virtual int compare(void *,void *);
};

int TIncCollection::compare(void *key1,void *key2)
{
  return stricmp((char *)key1,(char *)key2);
}

void ShowIncludes()
{
  TDependency *dep;
  char *tmp;
  TIncCollection *list;
  TIncListBox *box;
  TRect r;
  TDialog *dialog;
  int i;
  if (!project_window) return;
  if (project->dependencies->getCount() == 0) return;
  dep = (TDependency *)(project->dependencies->at(project_window->liste->focused));
  list = new TIncCollection();
  r = TProgram::deskTop->getExtent();
  r.b.y -= 7;
  string_dup(tmp,GT(TextIncFiles));
  string_cat(tmp,dep->dest_name);
  dialog = new TDialog(r,tmp);
  r = dialog->getExtent();
  r.grow(-1,-1);
  box = new TIncListBox(r,1,dialog->standardScrollBar(sbVertical));
  if (dep->dependencies)
  {
    for (i=0;i<dep->dependencies->getCount();i++)
    {
      TDependency *d = (TDependency *)(dep->dependencies->at(i));
      if (d->dest_name)
      {
        char *dir,*name,*ext;
        char buffer[100];
        split_fname(d->dest_name,dir,name,ext);
        string_cat(name,ext);
        sprintf(buffer,"%-20s",name);
        string_free(name);
        string_free(ext);
        string_dup(name,buffer);
        string_cat(name,"(");
        string_cat(name,dir);
        string_cat(name,")");
        string_free(dir);
        list->insert(name);
      }
    }
  }
  box->newList(list);
  dialog->insert(box);
  if (TProgram::deskTop->execView(dialog) == cmOK)
  {
    char *name,*dir,_tmp[256],*tmp=_tmp,fname[256];
    strcpy(tmp,(char *)list->at(box->focused));
    name = tmp;
    while (*tmp != ' ') tmp++;
    *tmp = 0;
    tmp++;
    while (*tmp != '(') tmp++;
    tmp++;
    dir = tmp;
    while (*tmp != ')') tmp++;
    *tmp = 0;
    strcpy(fname,dir);
    strcat(fname,name);
    OpenEditor(fname,False);
  }
  delete dialog;
  delete list;
}

static void clear_deps(TDependency *dep,Boolean remove_files = False)
{
  if (debug_dependencies)
  {
    fprintf(stderr,"clearing dependencies for %s\n",dep->dest_name);
  }
  if (remove_files == True &&
      dep->dest_name && 
      dep->compile_id != COMPILE_NONE &&
      dep->compile_id != COMPILE_UNKNOWN)
  {
    char *dname;
    FindFile(dep->dest_name,dname);
    if (debug_dependencies)
    {
      fprintf(stderr,"removing %s\n",dname);
    }
    remove(dname);
  }
  if (dep->dependencies)
  {
    int i = 0;
    while (i < dep->dependencies->getCount())
    {
      TDependency * _dep = (TDependency *)dep->dependencies->at(i);
      clear_deps(_dep,remove_files);
      if (!_dep->source_name && !_dep->dependencies) dep->dependencies->atFree(i);
      else i++;
    }
    if (dep->dependencies->getCount() == 0)
    {
      delete dep->dependencies;
      dep->dependencies = NULL;
    }
  }
}

void ClearDependencies()
{
  if (Project.dependencies)
  {
    int i,count=Project.dependencies->getCount();
    for (i=0;i<count;i++)
      clear_deps((TDependency *)Project.dependencies->at(i));
  }
}

void MakeClear()
{
  clear_deps(&Project,True);
}
