/* This file is part of RHIDE, Copyright (C) 1996 Robert Hhne */
#define Uses_TDialog
#define Uses_TScrollBar
#define Uses_TEditWindow
#define Uses_TMsgCollection
#define Uses_TMsgListBox
#define Uses_TSCollection
#define Uses_TProgram
#define Uses_TDeskTop
#define Uses_LangTexte
#define Uses_TWindowList
#include <IDEClass.h>
#include "IDE.h"
#include <string.h>
#include <stdio.h>

TDialog *msg_window = NULL;
TListBox *msg_list = NULL;

void ActivateMsg(int nr,TEvent &event)
{
  nr = event.what;
}

TEditWindow *is_on_desktop(const char * fname,Boolean is_full_name)
{
  int i,count;
  char *name1;
  if (!windows) return NULL;
  count = windows->getCount();
  if (is_full_name == True)
  {
    for (i=0;i<count;i++)
    {
      DeskTopWindow *w = (DeskTopWindow *)windows->at(i);
      if (!w->full_name) continue;
      if (strcmp(fname,w->full_name) == 0) return (TEditWindow *)w->window;
    }
    return NULL;
  }
  string_dup(name1,fname);
  FExpand(name1);
  for (i=0;i<count;i++)
  {
    DeskTopWindow *w = (DeskTopWindow *)windows->at(i);
    if (!w->full_name) continue;
    if (strcmp(name1,w->full_name) == 0)
    {
      string_free(name1);
      return (TEditWindow *)w->window;
    }
  }
  string_free(name1);
  return NULL;
}

void ShowMessages(TMsgCollection *msgs,Boolean remove_old)
{
  TRect r;
  r = TProgram::deskTop->getExtent();
  r.a.y = r.b.y - 7;
  TScrollBar *scrollbar;
  TProgram::deskTop->lock();
  if (!msg_window)
  {
    msg_window = new TDialog(r,GT(TitleMsgWindow));
    msg_window->flags = wfMove | wfGrow | wfZoom | wfClose;
    msg_window->growMode = gfGrowLoY | gfGrowHiX | gfGrowHiY;
    r = msg_window->getExtent();
    r.grow(-1,-1);
    scrollbar = msg_window->standardScrollBar(sbVertical | sbHandleKeyboard);
    msg_list = new TMsgListBox(r,1,scrollbar);
    msg_list->growMode = gfGrowHiX | gfGrowHiY;
    scrollbar = msg_window->standardScrollBar(sbHorizontal | sbHandleKeyboard);
    scrollbar->setParams(0,0,255-(r.b.x-r.a.x),40,1);
    msg_list->hScrollBar = scrollbar;
    msg_window->insert(msg_list);
    msg_window->insert(scrollbar);
    AddWindow(msg_window);
  }
  msg_window->hide();
  if (remove_old==True || msg_list->list() == NULL) msg_list->newList(msgs);
  else
  {
    int i,old=msg_list->list()->getCount();
    if (msgs->getCount() == 0) old--;
    for (i=0;i<msgs->getCount();i++)
    {
      msg_list->list()->insert(msgs->at(i));
    }
    msgs->removeAll();
    delete msgs;
    msg_list->setRange(msg_list->list()->getCount());
    msg_list->focusItem(old);
    msg_list->drawView();
  }
  if (msg_list->list() != NULL && msg_list->list()->getCount()>0)
  {
    if (msg_list->hScrollBar) msg_list->hScrollBar->setValue(0);
    msg_window->show();
    msg_window->select();
  }
  TProgram::deskTop->unlock();
}

