/* This file is part of RHIDE, Copyright (C) 1996 Robert Hhne */
#define Uses_TDependency
#define Uses_TProject
#define Uses_TDepCollection
#define Uses_TDependency
#define Uses_TSCollection
#define Uses_TProjectWindow
#define Uses_TOptions
#define Uses_TDirList
#define Uses_TParamList
#define Uses_TMsgCollection
#define Uses_TProjectListBox
#define Uses_TProgram
#define Uses_TDeskTop
#define Uses_TScreen
#define Uses_TEvent
#define Uses_IDEConst
#define Uses_TNSSortedCollection
#define Uses_TEditWindow
#define Uses_TStaticText
#define Uses_TIDEFileEditor
#define Uses_TFileViewer
#define Uses_LangTexte
#define Uses_TWindowList

#include <IDEClass.h>
#include "IDE.h"
#include <string.h>
#include <stdlib.h>
#include <dir.h>
#include <stdio.h>
#include <process.h>
#include <unistd.h>
#include <sys/stat.h>
#include <setjmp.h>
#include "IDE21.h"

#define MAX_TRUE_NAME 128  // defined in src/libc/posix/stat/xstat.h

static char DEPFILE_NAME[256];
static char DEP_ENV[256];
#define SET_DEP \
do {\
  strcpy(DEP_ENV,"SUNPRO_DEPENDENCIES=");\
  strcat(DEP_ENV,DEPFILE_NAME);\
  putenv(DEP_ENV);\
} while (0)
#define DEL_DEP \
do {\
  strcpy(DEP_ENV,"SUNPRO_DEPENDENCIES=");\
  putenv(DEP_ENV);\
} while (0)
#define SET_DEPFILE_NAME tmpnam(DEPFILE_NAME)

int project_index(const char * name)
{
  int i;
  char *sname,*_sname;
  FindFile(name,sname);
  for (i=0;i<Project.dependencies->getCount();i++)
  {
    FindFile(((TDependency *)Project.dependencies->at(i))->source_name,_sname);
    if (!strcmp(sname,_sname))
    {
      string_free(sname);
      string_free(_sname);
      return i;
    }
    string_free(_sname);
  }
  string_free(sname);
  return -1;
}

#if 0

typedef struct {
  char *pname;
  char *dname;
} project_stack;

static project_stack *PROJECT_STACK = NULL;
static stack_count = 0;

static void push_project(TDependency *dep)
{
  char dir[512];
  char drive[3];
  char *tmp;
  stack_count++;
  PROJECT_STACK = (project_stack *)realloc(PROJECT_STACK,
                                           stack_count*sizeof(project_stack));
  project_stack * ps = PROJECT_STACK + (stack_count-1);
  string_dup(ps->pname,project_name);
  ps->dname = getcwd(NULL,512);
  CloseProject();
  fnsplit(dep->dest_name,drive,dir,NULL,NULL);
  dir[strlen(dir)-1] = 0; // remove the last slash
  string_dup(tmp,drive);
  string_cat(tmp,dir);
  chdir(tmp);
  string_free(tmp);
  OpenProject(dep->source_name);
  string_free(dep->dest_name);
  string_dup(dep->dest_name,Project.dest_name);
}

static void pop_project()
{
  project_stack *ps;
  if (stack_count == 0) return;
  CloseProject();
  stack_count--;
  ps = PROJECT_STACK + stack_count;
  chdir(ps->dname);
  OpenProject(ps->pname);
  string_free(ps->dname);
  string_free(ps->pname);
  PROJECT_STACK = (project_stack *)realloc(PROJECT_STACK,
                                           stack_count*sizeof(project_stack));
  if (stack_count == 0)
    PROJECT_STACK = NULL;
}

Boolean compile_project(TDependency *dep)
{
  Boolean retval;
  push_project(dep);
  retval = Make();
  pop_project();
  return retval;
}

#endif

Boolean compile_dep(TDependency *dep)
{
  Boolean retval;
  char *sname,*dname;
  if (dep->compile_id == COMPILE_NONE) return True;
#if 0
  if (dep->compile_id == COMPILE_PROJECT) return compile_project(dep);
#endif
  FindFile(dep->source_name,sname);
  FindFile(dep->dest_name,dname);
  switch (dep->compile_id)
  {
    case COMPILE_ASM:
      retval = compile_s_to_obj(sname,dname);
      break;
    case COMPILE_C:
    case COMPILE_CC:
    case COMPILE_OBJC:
      retval = compile_c_to_obj(sname,dname);
      break;
    case COMPILE_LINK:
      retval = Link(dep);
      break;
    case COMPILE_ARCHIVE:
      retval = Archive(dep);
      break;
    default:
      retval = False;
      break;
  }
  if (retval == True)
  {
    TMsgCollection *errs = new TMsgCollection();;
    errs->insert((new msg_rec(NULL,GT(TextNoErrors))));
    ShowMessages(errs,False);
  }
  else
  {
    remove(dname);
  }
  string_free(sname);
  string_free(dname);
  SaveProject();
  return retval;
}

Boolean Compile()
{
  TDependency *dep;
  const char * name = NULL;
  ShowMessages(NULL,True);
  Boolean retval = False;
  if (project_window && ((project_window->liste->state & sfFocused) != 0))
  {
    dep = (TDependency *)Project.dependencies->at(project_window->liste->focused);
  }
  else
  {
    int i;
    name = ((TWindow *)TProgram::deskTop->current)->getTitle(100);
    i = project_index(name);
    if (i>=0) dep = (TDependency *)Project.dependencies->at(i);
    else dep = NULL;
  }
  if (!dep) 
  {
    char *dir,*file,*ext;
    FILE_TYPE ftype;
    split_fname(name,dir,file,ext);
    ftype = get_file_type(ext);
    string_free(dir);
    string_free(file);
    string_free(ext);
    switch (ftype)
    {
      case FILE_C_SOURCE:
      case FILE_CC_SOURCE:
      case FILE_OBJC_SOURCE:
        retval = compile_c_to_obj(name,"");
        break;
      case FILE_ASM_SOURCE:
        retval = compile_s_to_obj(name,"");
        break;
      default:
        break;
    }
    if (retval == True)
    {
      TMsgCollection *errs = new TMsgCollection();;
      errs->insert((new msg_rec(NULL,GT(TextNoErrors))));
      ShowMessages(errs,False);
    }
  }
  else
  {
    retval = compile_dep(dep);
  }
  return retval;
}

void AddIncludes(TSCollection & args)
{
  int i;
  char *tmp;
  if (NoStdInc)
  {
    string_dup(tmp,"-nostdinc");
    args.insert(tmp);
  }
  for (i=0;i<Options.include_path->getCount();i++)
  {
    string_dup(tmp,"-I");
    string_cat(tmp,(char *)(Options.include_path->at(i)));
    expand_variables(&tmp);
    args.insert(tmp);
  }
}

void AddLibDirs(TSCollection & args)
{
  int i;
  char *tmp;
  for (i=0;i<Options.library_path->getCount();i++)
  {
    string_dup(tmp,"-L");
    string_cat(tmp,(char *)(Options.library_path->at(i)));
    expand_variables(&tmp);
    args.insert(tmp);
  }
}

static void set_compile_c_to_obj_options(TSCollection & args)
{
  AddIncludes(args);
  AddDebugFlags(args);
  AddOptimizationFlags(args);
  AddWarningFlags(args);
  AddCFlags(args);
}

static void set_compile_objc_to_obj_options(TSCollection & args)
{
  AddIncludes(args);
  AddDebugFlags(args);
  AddOptimizationFlags(args);
  AddWarningFlags(args);
  AddCFlags(args);
}

static void set_compile_cc_to_obj_options(TSCollection & args)
{
  set_compile_c_to_obj_options(args);
  AddCXXFlags(args);
}

Boolean check_compile_c_errors(TMsgCollection &errs)
{
  Boolean retval = True;
  char buffer[1000];
  struct stat s;
  char *tmp,*fname,*temp,*msg;
  int lineno;
  msgType error;
  FILE *errfile = fopen(cpp_errname,"r");
  if (!errfile) return False;
  while (fgets(buffer,999,errfile))
  {
    temp = buffer;
    fname = NULL;
    if (strncmp(temp,"Control-Break Pressed",21) == 0)
    {
      errs.insert(new msg_rec(NULL,GT(TextControlBreak),msgError));
      retval = False;
      continue;
    }
    while ((tmp = strchr(temp,':')) != NULL)
    {
      *tmp = 0;
      if (strlen(buffer) >= MAX_TRUE_NAME) continue; // Bug in stat()
      if (stat(buffer,&s) == 0)
      {
        fname = buffer;
        temp = tmp+1;
        break;
      }
      *tmp = ':';
      temp = tmp+1;
    }
    if (!fname)
    {
      buffer[strlen(buffer)-1] = 0;
      errs.insert(new msg_rec(NULL,buffer,msgError));
      retval = False;
      continue;
    }
    tmp = strchr(temp,':');
    if (!tmp)
    {
      buffer[strlen(buffer)-1] = 0;
      errs.insert(new msg_rec(NULL,buffer,msgError));
      retval = False;
      continue;
    }
    *tmp = 0;
    if (sscanf(temp,"%d",&lineno) != 1) continue;
    tmp++;
    temp = tmp;
    while (*tmp++ == ' ');
    tmp--;
    error = msgError;
    if (strncmp(tmp,"warning:",8) == 0)
    {
      error = msgWarning;
      temp = tmp + 8;
      while (*temp++ == ' ');
      temp--;
    }
    msg = temp;
    msg[strlen(msg)-1] = 0;
    errs.insert(new msg_rec(fname,msg,error,lineno));
    if (error == msgError) retval = False;
  }
  fclose(errfile);
  return retval;
}

void check_in_project(char * & fname)
{
  int i;
  char *dir,*file,*ext;
  for (i=0;i<Project.dependencies->getCount();i++)
  {
    TDependency *dep = (TDependency *)Project.dependencies->at(i);
    if (dep->source_name)
    {
      split_fname(dep->source_name,dir,file,ext);
      string_free(dir);
      string_dup(dir,file);
      string_dup(dir,ext);
      string_free(file);
      string_free(ext);
      if (!strcmp(dir,fname))
      {
        string_free(fname);
        string_dup(fname,dep->source_name);
      }
      else
      {
        string_free(dir);
      }
    }
  }
}

Boolean check_link_errors(TMsgCollection &errs)
{
  Boolean retval = True;
  char buffer[1000];
  FILE *errfile = fopen(cpp_errname,"r");
  if (!errfile) return False;
  while (fgets(buffer,999,errfile))
  {
    buffer[strlen(buffer)-1] = 0;
    errs.insert(new msg_rec(NULL,buffer,msgError));
    retval = False;
  }
  fclose(errfile);
  return retval;
}

class MyStaticText : public TStaticText
{
public:
  MyStaticText(const TRect &r,const char *t) :
    TStaticText(r,t) {}
  void update(const char *);
  virtual void draw();
};

void MyStaticText::draw()
{
    uchar color;
    Boolean center;
    int i, j, l, p, y;
    TDrawBuffer b;
    const char *s = text;

    color = getColor(1);
    l = strlen(s);
    p = 0;
    y = 0;
    center = False;
    while (y < size.y)
        {
        b.moveChar(0, ' ', color, size.x);
        if (p < l)
            {
            if (s[p] == 3)
                {
                center = True;
                ++p;
                }
            i = p;
            do {
               j = p;
               while ((p < l) && (s[p] == ' ')) 
                   ++p;
               while ((p < l) && (s[p] != ' ') && (s[p] != '\n'))
                   ++p;
               } while ((p < l) && (p < i + size.x) && (s[p] != '\n'));
            if (p > i + size.x)
                if (j > i)
                    p = j; 
                else 
                    p = i + size.x;
            if (center == True)
               j = (size.x - p + i) / 2 ;
            else 
               j = 0;
            b.moveBuf(j, &s[i], color, (p - i));
            while ((p < l) && (s[p] == ' '))
                p++;
            if ((p < l) && (s[p] == '\n'))
                {
                center = False;
                p++;
                if ((p < l) && (s[p] == 10))
                    p++;
                }
            }
        writeLine(0, y++, size.x, 1, b);
        }
}

void MyStaticText::update(const char *fname)
{
  delete text;
  text = newStr(fname);
}

class TCheckDialog : public TDialog
{
public:
  TCheckDialog(const TRect &,const char *);
  void update(const char *);
private:
  MyStaticText *text;
};

TCheckDialog::TCheckDialog(const TRect & r,const char *what) : TDialog(r,NULL),
  TWindowInit(&TCheckDialog::initFrame)
{
  TRect rr(1,2,size.x-1,size.y-1);
  text = new MyStaticText(rr,"");
  insert(text);
  rr.a.y--;
  rr.b.y = rr.a.y+1;
  rr.b.x = rr.a.x + 25;
  insert(new TStaticText(rr,what));
}

void TCheckDialog::update(const char *fname)
{
  text->update(fname);
  text->drawView();
  drawView();
}

static TCheckDialog *CheckDialog = NULL;
static TCheckDialog *ExecDialog = NULL;
void RestoreScreen();
void SaveScreen();

int RunProgram(const char *ProgramName,TSCollection & args,
                   Boolean redir_stderr,Boolean redir_stdout,
		   Boolean hook21,Boolean SwitchToUser)
{
  char **argv;
  char *tmp;
  int argc,i,retval;
  ushort oldmode = 3;
  string_dup(tmp,ProgramName);
  argc = args.getCount();
  argv = (char **) new char[(argc+2)*sizeof(char *)];
  argv[argc+1] = NULL;
  for (i=0;i<args.getCount();i++)
  {
    argv[i+1] = (char *)(args.at(i));
  }
  argv[0] = tmp;
  if (ExecDialog)
  {
    char *cmd;
//    int len;
    string_dup(cmd,argv[0]);
//    len = strlen(cmd);
    for (i=1;i<=argc;i++)
    {
//      len += strlen(argv[i])+1;
//      if (len > 255) break; // TStaticText has a buffer of char[256]
      string_cat(cmd," ");
      string_cat(cmd,argv[i]);
    }
    ExecDialog->update(cmd);
    string_free(cmd);
  }
  if (debug_commands)
  {
    fprintf(stderr,GT(TextExecuting));
    fprintf(stderr,"%s",tmp);
    for (i=1;i<=argc;i++) fprintf(stderr," %s",argv[i]);
    fprintf(stderr,"\n");
  }
  if (redir_stdout == True) cpp_outname = open_stdout();
  if (redir_stderr == True) cpp_errname = open_stderr();
  if (SaveBeforeCompiling)
  {
    TEvent event;
    event.what = evCommand;
    event.message.command = cmSaveAll;
    TProgram::application->handleEvent(event);
    SaveProject();
  }
  if (SwitchToUser == True)
  {
    oldmode = TScreen::getCrtMode();
    TProgram::deskTop->setState(sfVisible,False);
    TProgram::application->suspend();
    RestoreScreen();
  }
  if (hook21 == True && UseHook21) InitHook21();
  retval = spawnvp(P_WAIT,tmp,argv);
  if (hook21 == True && UseHook21) DoneHook21();
  string_free(tmp);
  if (redir_stdout == True) close_stdout();
  if (redir_stderr == True) close_stderr();
  delete argv;
  if (SwitchToUser == True)
  {
    SaveScreen();
    TProgram::application->resume();
    TProgram::deskTop->setState(sfVisible,True);
    TProgram::application->setScreenMode(oldmode);
    Repaint();
  }
  return retval;
}

Boolean compile_s_to_obj(const char * source_name,const char * dest_name)
{
  Boolean retval = True;
  TSCollection args;
  char *tmp,*dname,*dir,*file,*ext;
  int run_ret,pi;
  TMsgCollection *errs = new TMsgCollection();
  split_fname(source_name,dir,file,ext);
  if (!dest_name || !*dest_name)
  {
    string_dup(dname,dir);
    string_cat(dname,file);
    string_cat(dname,".o");
  }
  else
  {
    string_dup(dname,dest_name);
  }
  string_free(dir);
  string_free(file);
  string_dup(tmp,GT(TextCompiling));
  string_cat(tmp,source_name);
  errs->insert((new msg_rec(source_name,tmp)));
  string_free(tmp);
  ShowMessages(errs,False);
  errs = new TMsgCollection();
  AINSERT("-c");
  AINSERT(source_name);
  pi = project_index(source_name);
  if (pi>=0)
  {
    AddLocalOptions(args,(TDependency *)Project.dependencies->at(pi));
  }
  AINSERT("-o");
  AINSERT(dname);
  run_ret = RunProgram("gcc",args,True,True,True);
  retval = check_compile_c_errors(*errs);
  ShowMessages(errs,False);
  if (!debug_tempfiles)
  {
    remove(cpp_errname);
    remove(cpp_outname);
  }
  if (run_ret != 0) retval = False;
  if (retval == False) remove(dname);
  TimeOfFile(dname,True); // update the file-time-table
  string_free(dname);
  return retval;
}

Boolean compile_c_to_obj(const char * source_name,const char * dest_name)
{
  TMsgCollection *errs = new TMsgCollection();;
  char * sname,* dname;
  Boolean retval = True;
  TSCollection args;
  int pi,run_ret;
  char *tmp;
  char *dir,*file,*ext;
  string_dup(sname,source_name);
  string_dup(tmp,GT(TextCompiling));
  string_cat(tmp,sname);
  errs->insert(new msg_rec(sname,tmp));
  string_free(tmp);
  ShowMessages(errs,False);
  errs = new TMsgCollection();
  split_fname(sname,dir,file,ext);
  if (!dest_name || !*dest_name)
  {
    string_dup(dname,dir);
    string_cat(dname,file);
    string_cat(dname,".o");
  }
  else
  {
    string_dup(dname,dest_name);
  }
  string_free(dir);
  string_free(file);
  switch (get_file_type(ext))
  {
    case FILE_CC_SOURCE:
      set_compile_cc_to_obj_options(args);
      break;
    case FILE_C_SOURCE:
      set_compile_c_to_obj_options(args);
      break;
    case FILE_OBJC_SOURCE:
      set_compile_objc_to_obj_options(args);
      break;
    default:
      break;
  }
  string_free(ext);
  AddCompilerOptions(args);
  AINSERT("-c");
  AINSERT(sname);
  pi = project_index(sname);
  if (pi>=0)
  {
    AddLocalOptions(args,(TDependency *)Project.dependencies->at(pi));
  }
  AINSERT("-o");
  AINSERT(dname);
  SET_DEPFILE_NAME;
  SET_DEP;
  run_ret = RunProgram("gcc",args,True,True,True);
  DEL_DEP;
  if (pi>=0)
  {
    FILE *f;
    char x[256],depfile[256],*temp;
    TDependency *dep = (TDependency *)Project.dependencies->at(pi);
    if (dep->dependencies) delete dep->dependencies;
    dep->dependencies = NULL;
    f = fopen(DEPFILE_NAME,"r");
    if (f)
    {
      fgets(x,255,f);
      temp = strchr(x,':');
      if (temp)
      {
	temp++;
	while (*temp == ' ') temp++;
	temp = strchr(temp,' ');
	do
	{
	  while (temp)
	  {
	    while (*temp == ' ') temp++;
	    tmp = temp;
	    if (*temp=='\n' || *temp == '\\' && temp[1] == '\n') temp = NULL;
	    else
	    {
	      char c;
	      TDependency *tmp_dep;
	      while (*temp != ' ' && *temp != '\n') temp++;
	      c = *temp;
	      *temp = 0;
	      strcpy(depfile,tmp);
	      *temp = c;
	      tmp_dep = new TDependency();
              string_dup(tmp_dep->dest_name,depfile);
	      tmp_dep->source_name = NULL;
	      tmp_dep->source_file_type = FILE_UNKNOWN;
	      tmp_dep->dest_file_type = FILE_HEADER;
	      tmp_dep->compile_id = COMPILE_NONE;
	      if (!dep->dependencies) dep->dependencies = new TDepCollection(5,5);
	      dep->dependencies->insert(tmp_dep);
	    }
	  }
	} while ((temp = fgets(x,255,f)));
      }
      fclose(f);
    }
  }
  retval = check_compile_c_errors(*errs);
  ShowMessages(errs,False);
  if (!debug_tempfiles)
  {
    remove(DEPFILE_NAME);
    remove(cpp_errname);
    remove(cpp_outname);
  }
  string_free(sname);
  if (run_ret != 0) retval = False;
  if (retval == False) remove(dname);
  TimeOfFile(dname,True); // update the file-time-table
  string_free(dname);
  return retval;
}

Boolean Archive(TDependency *dep)
{
  Boolean retval = True;
  TSCollection args;
  int i;
  TMsgCollection *errs;
  errs = new TMsgCollection();
  errs->insert(new msg_rec(NULL,GT(TextRunLib)));
  ShowMessages(errs,False);
  AINSERT("r");
  AINSERT(dep->dest_name);
  for (i=0;i<dep->dependencies->getCount();i++)
  {
    char *tmp;
    FindFile(((TDependency *)dep->dependencies->at(i))->dest_name,tmp);
    args.insert(tmp);
  }
  remove(dep->dest_name);
  i = RunProgram("ar",args,True,True,True);
  if (!debug_tempfiles)
  {
    remove(cpp_errname);
    remove(cpp_outname);
  }
  if (i != 0) return retval = False;
  if (retval == False) remove(dep->dest_name);
  TimeOfFile(dep->dest_name,True); // update the file-time-table
  return retval;
}

Boolean Link(TDependency *dep)
{
  Boolean retval = True;
  TSCollection args;
  int i,run_ret;
  TMsgCollection *errs;
  errs = new TMsgCollection();
  errs->insert(new msg_rec(NULL,GT(TextLinking)));
  ShowMessages(errs,False);
  AddLinkerOptions(args);
  AddLibDirs(args);
  AINSERT("-o");
  AINSERT(dep->dest_name);
  for (i=0;i<dep->dependencies->getCount();i++)
  {
    char *tmp;
    FindFile(((TDependency *)dep->dependencies->at(i))->dest_name,tmp);
    args.insert(tmp);
  }
  AddLibraries(args);
  run_ret = RunProgram("gcc",args,True,True,True);
  errs = new TMsgCollection();
  retval = check_link_errors(*errs);
  if (!debug_tempfiles)
  {
    remove(cpp_errname);
    remove(cpp_outname);
  }
  ShowMessages(errs,False);
  if (run_ret != 0) retval = False;
  if (retval == False) remove(dep->dest_name);
  TimeOfFile(dep->dest_name,True); // update the file-time-table
  return retval;
}

static Boolean up_to_date;

class FileTimeCollection : public TNSSortedCollection
{
public:
  FileTimeCollection(ccIndex alimit,ccIndex adelta) :
    TNSSortedCollection(alimit,adelta) {}
private:
  virtual int compare(void *,void *);
  virtual void freeItem(void *);
};

struct FileTime {
  FileTime(const char *aname,long atime);
  ~FileTime();
  char *name;
  long time;
};

FileTime::FileTime(const char *aname,long atime)
{
  string_dup(name,aname);
  time = atime;
}

FileTime::~FileTime()
{
  string_free(name);
}

void FileTimeCollection::freeItem(void *item)
{
  delete (FileTime *)item;
}
  
int FileTimeCollection::compare(void *key1,void *key2)
{
  return strcmp(((FileTime *)key1)->name,((FileTime *)key2)->name);
}

static FileTimeCollection *file_times = NULL;

long TimeOfFile(const char *name,Boolean update,Boolean is_full_name)
{
  FileTime *ft;
  ccIndex index;
  long retval;
  char *full_name;
  TEditWindow *e;
  if (is_full_name == True) full_name = (char *)name;
  else
  {
    string_dup(full_name,name);
    FExpand(full_name);
  }
  e = is_on_desktop(full_name,True);
  if (e) 
  {
    if (file_times != NULL)
    {
      ft = new FileTime(full_name,0);
      if (file_times->search(ft,index) == True)
      {
        file_times->atRemove(index);
      }
      delete ft;
    }
    if (is_full_name == False) string_free(full_name);
    return ((TIDEFileEditor *)(e->editor))->edittime;
  }
  if (file_times == NULL) file_times = new FileTimeCollection(100,100);
  ft = new FileTime(full_name,0);
  if (file_times->search(ft,index) == True)
  {
    if (update == True)
    {
      ((FileTime *)file_times->at(index))->time = retval = time_of_file(full_name);
    }
    else
    {
      retval = ((FileTime *)file_times->at(index))->time;
    }
    delete ft;
  }
  else
  {
    retval = time_of_file(full_name);
    ft->time = retval;
    file_times->insert(ft);
  }
  if (is_full_name == False) string_free(full_name);
  return retval;
}

static void indent(int depth)
{
  int i;
  for (i=0;i<depth*2;i++) fputc(' ',stderr);
}

static jmp_buf cancel_make;

static void InitExecDialog()
{
  TRect r = TProgram::deskTop->getExtent();
  r.b.y -= 7;
  ExecDialog = new TCheckDialog(r,GT(TextExecuting));
  TProgram::deskTop->lock();
  TProgram::deskTop->insert(ExecDialog);
  ExecDialog->hide();
  TProgram::deskTop->unlock();
  r.a.y = 5;
  r.b.y = r.a.y + 4;
  r.a.x += 2;
  r.b.x -= 2;
  CheckDialog = new TCheckDialog(r,GT(TextChecking));
  TProgram::deskTop->insert(CheckDialog);
}

static void DeleteExecDialog()
{
  TProgram::deskTop->remove(CheckDialog);
  TProgram::deskTop->remove(ExecDialog);
  delete CheckDialog;
  delete ExecDialog;
  CheckDialog = NULL;
  ExecDialog = NULL;
}

Boolean time_of_dep(TDependency *dep,long &target_time,Boolean build,
  int depth,int recur_depth)
{
  long source_time = 0;
  char *dest_name;
  Boolean retval=True;
  if (dep->compile_id == COMPILE_PROJECT)
  {
    char *pname,*dname,*name,*ext;
    split_fname(dep->dest_name,dname,name,ext);
    dname[strlen(dname)-1] = 0;
    string_dup(pname,dep->source_name);
    string_free(ext);
    string_free(name);
    if (PushProject(dname,pname) == False)
    {
      string_free(dname);
      string_free(pname);
      ResetProjectStack();
      longjmp(cancel_make,-1);
    }
    string_free(dname);
    string_free(pname);
    retval = time_of_dep(project,target_time,build,depth+1,depth+1);
    if (retval == False)
    {
      ResetProjectStack();
      longjmp(cancel_make,-1);
    }
    string_free(dep->dest_name);
    string_dup(dep->dest_name,project->dest_name);
    FExpand(dep->dest_name);
    PopProject();
    return retval;
  }
  FindFile(dep->dest_name,dest_name);
  if (CheckDialog && depth < recur_depth+2) CheckDialog->update(dest_name);
  target_time = TimeOfFile(dest_name,False);
  {
    if (debug_dependencies)
    {
      indent(depth);
      fprintf(stderr,"%s: %s\n",GT(TextChecking),dest_name);
    }
    if (dep->source_name == NULL) source_time = target_time;
    else
    {
      char *sname;
      FindFile(dep->source_name,sname);
      source_time = TimeOfFile(sname,False);
      if (debug_dependencies)
      {
        indent(depth+1);
        fprintf(stderr,"%s %s\n",GT(TextChecking),dep->source_name);
        indent(depth+1);
        fprintf(stderr,"%s %s\n",dep->source_name,GT(TextUpToDate));
        indent(depth);
        fprintf(stderr,"%s %s %s %s %s\n",
            dep->source_name,
            GT(TextIs),
            (source_time > target_time ? GT(TextNewer) : GT(TextOlder) ),
            GT(TextThan),
            dest_name);
      }
      string_free(sname);
    }
    if ((build == True || source_time<=target_time) && 
         dep->dependencies != NULL)
    {
      int i;
      long akt_time;
      for (i=0;i<dep->dependencies->getCount();i++)
      {
        retval = time_of_dep((TDependency *)dep->dependencies->at(i),akt_time,build,depth+1,recur_depth);
        if (retval == False) return retval;
        if (akt_time>source_time) source_time = akt_time;
        if (debug_dependencies)
        {
          char *dname;
          indent(depth);
          FindFile(((TDependency *)(dep->dependencies->at(i)))->dest_name,dname);
          fprintf(stderr,"%s %s %s %s %s\n",
            dname,
            GT(TextIs),
            (akt_time > target_time ? GT(TextNewer) : GT(TextOlder) ),
            GT(TextThan),
            dest_name);
          string_free(dname);
        }
      }
    }
  }
  if (build == False && source_time<=target_time)
  {
    string_free(dest_name);
    return retval;
  }
  if (debug_dependencies)
  {
    indent(depth);
    fprintf(stderr,"%s %s\n",GT(TextMustRebuild),dest_name);
  }
  if (CheckDialog) CheckDialog->hide();
  if (ExecDialog) ExecDialog->show();
  retval = compile_dep(dep);
  if (ExecDialog) ExecDialog->hide();
  if (CheckDialog) CheckDialog->show();
  if (debug_dependencies)
  {
    indent(depth);
    fprintf(stderr,"%s %s  ===>  %s\n",
            GT(TextRebuildingOf),
            dest_name,
            (retval == True ? GT(TextSuccess) : GT(TextError) ));
  }
  up_to_date = False;
  if (retval == True) target_time = TimeOfFile(dest_name,True);
  string_free(dest_name);
  return retval;
}

void ClearFileHash()
{
  if (file_times != NULL) delete file_times;
  file_times = NULL;
}

Boolean Make(Boolean force_messages)
{
  Boolean retval;
  long akttime;
  if (ShowWhatDoing)
  {
    InitExecDialog();
  }
  if (force_messages == True) ShowMessages(NULL,True);
  up_to_date = True;
  if (setjmp(cancel_make) == 0)
  { 
    retval = time_of_dep(project,akttime,False,0,0);
  }
  else
  {
    retval = False;
    up_to_date = False;
  }
  if (up_to_date == True && force_messages == True)
  {
    TMsgCollection *errs;
    char *tmp;
    string_dup(tmp,project->dest_name);
    string_cat(tmp," ");
    string_cat(tmp,GT(TextUpToDate));
    errs = new TMsgCollection();
    errs->insert(new msg_rec(NULL,tmp));
    string_free(tmp);
    ShowMessages(errs,True);
  }
  if (ExecDialog)
  {
    DeleteExecDialog();
  }
  return retval;
}

Boolean Build()
{
  Boolean retval = True;
  long akttime;
  if (ShowWhatDoing)
  {
    InitExecDialog();
  }
  ShowMessages(NULL,True);
  ClearFileHash();
  ClearFindCache();
  MakeClear();
  if (setjmp(cancel_make) == 0)
  {
    retval = time_of_dep(project,akttime,True,0,0);
  }
  else
  {
    retval = False;
  }
  if (ExecDialog)
  {
    DeleteExecDialog();
  }
  return retval;
}

void AddProgArgs(TSCollection &args)
{
  int i;
  for (i=0;i<Options.ProgArgs->getCount();i++)
  {
    AINSERT((char *)(Options.ProgArgs->at(i)));
  }
}

Boolean RunMainTarget()
{
  TSCollection args;
  int i;
  char *tmp;
  Boolean redir_stdout = False,redir_stderr = False;
  if (Project.dest_file_type != FILE_COFF &&
      Project.dest_file_type != FILE_EXE) return False;
  AddProgArgs(args);
  if (ShowStderr) redir_stderr = True;
  if (ShowStdout) redir_stdout = True;
  RunProgram(project->dest_name,args,redir_stderr,redir_stdout,False,True);
  if (ShowStderr)
  {
    TFileWindow *window;
    TRect rect = TProgram::deskTop->getExtent();
    rect.a.y = rect.b.y-7;
    string_dup(tmp,GT(TextContStderr));
    string_cat(tmp,project->dest_name);
    if (windows != NULL)
    {
      int count = windows->getCount();
      for (i=0;i<count;i++)
      {
        window = (TFileWindow *)DESKTOPWINDOW(i);
        if (strcmp(tmp,window->getTitle(100)) == 0)
        {
          RemoveWindow(window);
	  window->close();
          break;
        }
      }
    }
    window = new TFileWindow(cpp_errname);
    delete (char *)(window->title);
    (char *)window->title = tmp;
    window->palette = wpGrayWindow;
    window->locate(rect);
    AddWindow(window);
  }
  if (ShowStdout)
  {
    TFileWindow *window;
    TRect rect = TProgram::deskTop->getExtent();
    rect.b.y -= 7;
    string_dup(tmp,GT(TextContStdout));
    string_cat(tmp,project->dest_name);
    if (windows != NULL)
    {
      int count = windows->getCount();
      for (i=0;i<count;i++)
      {
        window = (TFileWindow *)DESKTOPWINDOW(i);
        if (strcmp(tmp,window->getTitle(100)) == 0)
        {
          RemoveWindow(window);
	  window->close();
          break;
        }
      }
    }
    window = new TFileWindow(cpp_outname);
    delete (char *)(window->title);
    (char *)window->title = tmp;
    window->palette = wpGrayWindow;
    window->locate(rect);
    AddWindow(window);
  }
  if (ShowStderr && !debug_tempfiles) remove(cpp_errname);
  if (ShowStdout && !debug_tempfiles) remove(cpp_outname);
  return True;
}

