/* This file is part of RHIDE, Copyright (C) 1996 Robert Hhne */
#define Uses_TEditor
#define Uses_TProject
#define Uses_TOptions
#define Uses_TStringCollection
#define Uses_TSCollection
#define Uses_TWindowList
#include <IDEClass.h>
#include "IDE.h"
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>

#define cNormal   1
#define cMarked   2
#define cComment  3
#define cReserved 4
#define cIdent    5
#define cSymbol   6
#define cString   7
#define cInteger  8
#define cFloat    9
#define cOctal    10
#define cHex      11
#define cChar     12
#define cPre      13
#define cIllegal  14
#define cUser     15

static char *BUFFER;
static uint32 CURPTR;
static uint32 GAPLEN;
static TEditor *EDITOR;
static uint32 lineptr;

inline static char BUFCHAR(uint32 p)
{
  return p >= CURPTR ? BUFFER[p+GAPLEN] : BUFFER[p];
}

static int is_reserved(const char *name)
{
  ccIndex index;
  if (!ReservedWords) return 0;
  if (ReservedWords->search((void *)name,index) == True) return 1;
  return 0;
}

static int is_user_word(const char *name)
{
  ccIndex index;
  if (!UserWords) return 0;
  if (UserWords->search((void *)name,index) == True) return 1;
  return 0;
}

static int is_integer(const char *name)
{
  int i=0;
  if (!isdigit(name[0])) return 0;
  while (name[i])
  {
    if (!isdigit(name[i]))
    {
      if (name[i] == 'U')
      {
        i++;
        if (!name[i]) return 1;
      }
      if (name[i] != 'L') return 0;
      i++;
      if (!name[i]) return 1;
      return 0;
    }
    i++;
  }
  return 1;
}

static int is_hex(const char *name)
{
  int i=2;
  if (name[0] != '0') return 0;
  if (name[1] != 'x') return 0;
  while (name[i])
  {
    if (!isxdigit(name[i])) return 0;
    i++;
  }
  return 1;
}

static int is_octal(const char *name)
{
  int i=1;
  if (name[0] != '0') return 0;
  while (name[i] == '0') i++;
  if (!name[i]) return 0;
  while (name[i])
  {
    if (name[i] < '0' || name[i] > '7') return 0;
    i++;
  }
  return 1;
}

static int is_symbol(const char *name)
{
  int i=0;
  while (name[i])
  {
    switch (name[i])
    {
      case '(': case ')': case ',': case ';': case '+': case '-':
      case '*': case '/': case '^': case '!': case '%': case '&':
      case '|': case '{': case '}': case '[': case ']': case '?':
      case ':': case '<': case '>': case '=':
        i++;
        break;
      default:
        return 0;
    }
  }
  return 1;
}

#define DRAWBUF ((ushort *)DrawBuf)

#define SetChar(c)\
do {\
  DRAWBUF[bufptr] = (DRAWBUF[bufptr] & 0x00FF) | (c);\
} while (0)

#define normalColor (Colors & 0xff)
#define selectColor (Colors >> 8)
#define RETURN goto lab_end

static int isWordChar(char c)
{
  return isalnum(c) || c == '_';
}

static int in_range(uint32 start,uint32 end,uint32 pos)
{
  if (start >= end) return 0;
  if (pos >= start && pos < end) return 1;
  return 0;
}

static int check_pre()
{
  uint32 temp=lineptr;
  uint32 temp1;
  do
  {
    int in_string = 0,in_char = 0,in_comment = 0;
    char c;
    temp1 = EDITOR->prevChar(EDITOR->prevChar(temp));
    if (temp1 >= temp) return 0;
    if (BUFCHAR(temp1) != '\\') return 0;
    temp = EDITOR->lineStart(temp1);
    temp1--;
    while (temp1 >= temp)
    {
      c = BUFCHAR(temp1--);
      if (c=='\\') continue;
      if (in_string)
      {
        if (c == '\"') in_string = 0;
        continue;
      }
      if (in_char)
      {
        if (c == '\'') in_char = 0;
        continue;
      }
      if (in_comment)
      {
        if (c == '/')
        {
          if (temp1 >= temp && BUFCHAR(temp1) == '*')
          {
            temp1--;
            in_comment = 0;
          }
        }
        continue;
      }
      if (c == '\"')
      {
        in_string = 1;
        continue;
      }
      if (c == '\'')
      {
        in_char = 1;
        continue;
      }
      if (c == '*')
      {
        if (temp1 >= temp && BUFCHAR(temp1) == '/')
        {
          temp1--;
          in_comment = 1;
        }
        continue;
      }
      if (c == '#') return 1;
    }
    temp = EDITOR->lineStart(temp1);
  } while(temp > 1);
  return 0;
}

typedef struct {
  TWindow * window;
  uint32 last_start;
  uint32 last_end;
  uint32 last_pos;
} comment_hash;

static comment_hash *chash = NULL;
static comment_hash_count = 0;
static comment_index = 0;

#define illegal_pos 0xFFFFFFFF

static void setup_comment_hash()
{
  int index,not_found = 0,count = windows->getCount();
  TWindow *window = (TWindow *)(EDITOR->owner);
  if (comment_hash_count > 0 && chash[comment_index].window == window) return;
  for (index=0;index<count;index++)
  {
    if (window == DESKTOPWINDOW(index)) break;
  }
  if (index >= comment_hash_count)
  {
    chash = (comment_hash *)realloc(chash,sizeof(comment_hash)*(index+1));
    comment_hash_count = index+1;
    not_found = 1;
  }
  else if (window != chash[index].window) not_found = 1;
  if (not_found)
  {
    chash[index].window = window;
    chash[index].last_start =
    chash[index].last_end = illegal_pos;
    chash[index].last_pos = 0;
  }
  comment_index = index;
}

#define LAST_START chash[comment_index].last_start
#define LAST_END   chash[comment_index].last_end
#define LAST_POS   chash[comment_index].last_pos

static int check_c_comment()
{
  int in_string=0,in_char=0;
  uint32 Lineptr=lineptr;
  setup_comment_hash();
  if (lineptr >= LAST_END)
  {
    if (LAST_START < LAST_END && lineptr == LAST_POS+1) return 0;
    if (LAST_START == illegal_pos) return 0;
  }
  if (lineptr >= LAST_START)
  {
    if (lineptr == LAST_POS+1) return 1;
  }
  if (lineptr == LAST_POS+1) return 0;
  LAST_START = LAST_END = illegal_pos;
  while (Lineptr > 0)
  {
    char c = BUFCHAR(Lineptr--);
    if (c == '\\') continue;
    if (c == 10 || c == 13)
    {
      in_string = in_char = 0;
      continue;
    }
    if (in_string)
    {
      if (c == '\"')
      {
        in_string = 0;
      }
      continue;
    }
    if (in_char)
    {
      if (c == '\'')
      {
        in_char = 0;
      }
      continue;
    }
    if (c == '/')
    {
      if (BUFCHAR(Lineptr) == '*')
      {
        LAST_END = Lineptr+2;
        return 0;
      }
    }
    if (c == '*')
    {
      if (BUFCHAR(Lineptr) == '/')
      {
        if (Lineptr == 0 || (Lineptr>0 && BUFCHAR(Lineptr-1) != '/'))
        {
          LAST_START = Lineptr;
          return 1;
        }
      }
    }
    if (c == '\'')
    {
      in_char = 1;
      continue;
    }
    if (c == '\"')
    {
      in_string = 1;
      continue;
    }
  }
  return 0;
}

void SyntaxFormatLine( TEditor * editor,
                       void *DrawBuf,
		       uint32 LinePtr,
		       int Width,
		       ushort Colors
		     )
{
  uint32 bufptr;
  uint32 offset;
  ushort color;
  EDITOR = editor;
  GAPLEN = editor->gapLen;
  CURPTR = editor->curPtr;
  BUFFER = editor->buffer;
  lineptr = LinePtr;
  bufptr = 0;
  offset = 0;
  if (!ShowSyntax)
  {
    if (chash != NULL)
    {
      free(chash);
      comment_index = comment_hash_count = 0;
    }
    return;
  }
  {
    int in_char=0,in_string=0,in_pre=check_pre();
    int in_c_comment=check_c_comment();
    int in_cplus_comment = 0;
    uint32 word_end,lineend = EDITOR->lineEnd(lineptr);
    bufptr = 0;
    for (offset=0;lineptr+offset<=lineend;)
    {
      char c2=0;
      int c2_valid = 0;
      word_end = offset-1;
      do
      {
        word_end++;
      } while (word_end <= lineend-lineptr && 
               isWordChar(BUFCHAR(lineptr+word_end)));
      if (word_end > lineend-lineptr || 
          (word_end > offset && 
           !isWordChar(BUFCHAR(lineptr+word_end)))) 
        word_end--;
      {
        char name[256];
        char & c1 = name[0];
        uint32 i;
        for (i=0;i<word_end-offset+1;i++)
        {
          name[i] = BUFCHAR(lineptr+offset+i);
        }
        name[word_end-offset+1] = 0;
        if (word_end+1 <= lineend-lineptr)
        {
          c2_valid = 1;
          c2 = BUFCHAR(lineptr+offset+1);
        }
        color = EDITOR->getColor(cNormal);
        if (in_cplus_comment)
        {
          color = EDITOR->getColor(cComment);
        }
        else if (in_c_comment)
        {
          color = EDITOR->getColor(cComment);
          if (c1 == '*' && c2_valid && c2 == '/')
          {
            word_end++;
            name[1] = '/';
            name[2] = 0;
            in_c_comment = 0;
            LAST_END = lineptr+offset+2;
          }
        }
        else if (in_pre)
        {
          if (c1 == '/' && c2_valid && (c2 == '/' || c2 == '*'))
          {
            color = EDITOR->getColor(cComment);
            word_end++;
            name[1] = c2;
            name[2] = 0;
            if (c2 == '/')
              in_cplus_comment = 1;
            else
            {
              in_c_comment = 1;
              LAST_START = lineptr+offset;
            }
          }
          else color = EDITOR->getColor(cPre);
        }
        else if (in_string)
        {
          color = EDITOR->getColor(cString);
          if (c1 == '\\')
          {
            if (c2_valid)
            {
              word_end++;
              name[1] = c2;
              name[2] = 0;
            }
            else
            {
              in_string = 0;
            }
          }
          else if (c1 == '\"') in_string = 0;
        }
        else if (in_char)
        {
          color = EDITOR->getColor(cChar);
          if (c1 == '\\')
          {
            if (c2_valid)
            {
              word_end++;
              name[1] = c2;
              name[2] = 0;
            }
            else
            {
              in_char = 0;
            }
          }
          else if (c1 == '\'') in_char = 0;
        }
        else if (c1 == '\"')
        {
          in_string = 1;
          color = EDITOR->getColor(cString);
        }
        else if (c1 == '\\')
        {
          color = EDITOR->getColor(cIllegal);
        }
        else if (c1 == '#')
        {
          in_pre = 1;
          color = EDITOR->getColor(cPre);
        }
        else if (c1 == '\'')
        {
          in_char = 1;
          color = EDITOR->getColor(cChar);
        }
        else if (c1 == '/' && c2_valid && (c2 == '/' || c2 == '*'))
        {
          color = EDITOR->getColor(cComment);
          word_end++;
          name[1] = c2;
          name[2] = 0;
          if (name[1] == '/')
            in_cplus_comment = 1;
          else
          {
            in_c_comment = 1;
            LAST_START = lineptr+offset;
          }
        }
        else if (is_reserved(name)) color = EDITOR->getColor(cReserved);
        else if (is_user_word(name)) color = EDITOR->getColor(cUser);
        else if (is_octal(name)) color = EDITOR->getColor(cOctal);
        else if (is_integer(name))
        {
          color = EDITOR->getColor(cInteger);
          if (isdigit(name[strlen(name)-1]) &&
              word_end < lineend-lineptr)
          {
            char c = BUFCHAR(lineptr+word_end+1);
            if (isdigit(c) || c == '.' || c == 'e' || c == 'E')
            {
              int i;
              long double d;
              i = strlen(name);
              while (word_end < lineend-lineptr)
              {
                name[i] = BUFCHAR(lineptr+word_end+1);
                word_end++;
                if (!isdigit(name[i]) && name[i] != '.' && name[i] != 'e' && name[i] != 'E')
                {
                  word_end--;
                  break;
                }
                i++;
              }
              name[i] = 0;
              if (!isdigit(name[i-1])) color = EDITOR->getColor(cIllegal);
              else if (sscanf(name,"%Le",&d) != 1)
                color = EDITOR->getColor(cIllegal);
              else color = EDITOR->getColor(cFloat);
            }
          }
        }
        else if (is_symbol(name)) color = EDITOR->getColor(cSymbol);
        else if (is_hex(name)) color = EDITOR->getColor(cHex);
        else if (isdigit(name[0])) color = EDITOR->getColor(cIllegal);
        while (offset <= word_end)
        {
          if (offset < (uint32)Width)
            if (!in_range(EDITOR->selStart,EDITOR->selEnd,lineptr+offset))
          {
            SetChar(color << 8);
            if (c1 == '\t')
            {
              int tabcount = TEditor::tabSize-(bufptr % TEditor::tabSize)-1;
              while (tabcount--)
              {
                bufptr++;
                SetChar(color << 8);
              }
            }
          }
          else
          {
            if (c1 == '\t')
            {
              int tabcount = TEditor::tabSize-(bufptr % TEditor::tabSize)-1;
              while (tabcount--) bufptr++;
            }
          }
          bufptr++;
          offset++;
        }
      }
    }
  }
  LAST_POS = lineptr+offset;
}

