/* This file is part of RHIDE, Copyright (C) 1996 Robert Hhne */
#if (__GNUC_MINOR__ < 7)
#pragma interface
#endif
#if defined( Uses_TSCollection ) && !defined( __TSCollection__ )
#define __TSCollection__

class TSCollection : public TCollection
{
public:
    TSCollection(void) : TCollection(10,10) {}
    static const char * const near name;
    static TStreamable *build();
protected:
    TSCollection(StreamableInit);
private:
    virtual const char *streamableName() const
	{ return name; }
    virtual void *readItem( ipstream& s);
    virtual void writeItem( void *d, opstream& o);
};

inline ipstream& operator >> ( ipstream& is, TSCollection& cl )
    { return is >> (TStreamable&)cl; }
inline ipstream& operator >> ( ipstream& is, TSCollection*& cl )
    { return is >> (void *&)cl; }

inline opstream& operator << ( opstream& os, TSCollection& cl )
    { return os << (TStreamable&)cl; }
inline opstream& operator << ( opstream& os, TSCollection* cl )
    { return os << (TStreamable *)cl; }

#endif

