/* This file is part of RHIDE, Copyright (C) 1996 Robert Hhne */
#define Uses_TDirList
#define Uses_TStreamable

#include "IDEClass.h"
#include <string.h>

TStreamable *TDirList::build()
{
  return new TDirList( streamableInit );
}

void TDirList::FromString(const char * liste)
{
  char *tmp,*temp,*_tmp,*__tmp;
  freeAll();
  if (!liste || !*liste) return;
  string_dup(temp,liste);
  tmp = temp;
  _tmp = strchr(temp,';');
  if (!_tmp)
  {
    insert(temp);
    return;
  }
  do
  {
    __tmp = _tmp;
    *_tmp = 0;
    string_dup(_tmp,tmp);
    insert(_tmp);
    tmp = __tmp+1;
    _tmp = strchr(tmp,';');
  } while (_tmp);
  if (*tmp)
  {
    string_dup(_tmp,tmp);
    insert(_tmp);
  }
  string_free(temp);
}

TDirList::TDirList(const char * liste) : TCollection(10,1)
{
  FromString(liste);
}

void TDirList::ToString(char * & result)
{
  int i;
  string_dup(result,"");
  for (i=0;i<count;i++)
  {
    if (i != 0) string_cat(result,";");
    string_cat(result,(char *)at(i));
  }
}

void *TDirList::readItem(ipstream & is)
{
  return is.readString();
}

void TDirList::writeItem(void *data,opstream & os)
{
  os.writeString((const char *)data);
}

