/* This file is part of RHIDE, Copyright (C) 1996 Robert Hhne */
/*
  These strings are used for showing any outputs to the user from
  RHIDE.
  The syntax is very simple. Each group of strings begins with
  'T(...' where the three dots stand for unique symbolic name,
  under which this string will be called from RHIDE.
  Sometimes the strings contain some format strings, like "%s" or
  "%d". The number and the order of these format strings must be
  the same in each languagestring, but not the position in the
  string.
  After the 'T(...' there is for each language the corresponding
  string preceded by a comma on a seperate line. At this time the
  following languages are supported:

    1. line   : English  (maintened by Robert Hhne)
         email: robert.hoehne@mathematik.tu-chemnitz.de
         
    2. line   : German   (maintened by Robert Hhne)
         email: robert.hoehne@mathematik.tu-chemnitz.de
         
    3. Line   : Spanish  (maintened by Salvador Eduardo Tropea (SET))
         email: ice@inti.edu.ar
         
    4. Line   : Frensh   (maintened by Eric Nicolas)
         email: nicolas@dsys.ceng.cea.fr
         
    5. Line   : Swedish  (maintened by Christian Axbrink)
         email: sa9471@ida.utb.hb.se
         
    6. Line   : Italian  (maintened by Normando Marcolongo)
         email: i094968@spv.ing.uniroma1.it
      
    7. Line   : Portuguese  (maintened by Goncalo Farias)
         email: mad@telepac.pt

    8. Line   : Dutch  (maintened by Martijn Laan)
         email: mlaan@cs.vu.nl

*/

T(ButtonCancel
/*eng*/,"~C~ancel"
/*ger*/,"~A~bbruch"
/*spa*/,"~C~ancela"
/*fre*/,"~A~nnuler"
/*swe*/,"~A~vbryt"
/*ita*/,"~A~nnulla"
/*por*/,"???"
/*dut*/,"~A~nnuleren"
)
T(ButtonOK
/*eng*/,"~O~k"
/*ger*/,"~O~k"
/*spa*/,"~O~k"
/*fre*/,"~O~k"
/*swe*/,"~O~K"
/*ita*/,"~O~k"
/*por*/,"???"
/*dut*/,"~O~k"
)
T(ButtonEdit
/*eng*/,"~E~dit"
/*ger*/,"nd~e~rn"
/*spa*/,"~E~ditar"
/*fre*/,"~E~dit"
/*swe*/,"R~e~digera"
/*ita*/,"~E~dit"
/*por*/,"???"
/*dut*/,"~B~ewerken"
)
T(TextNoErrors
/*eng*/,"no errors"
/*ger*/,"keine Fehler"
/*spa*/,"sin errores"
/*fre*/,"Pas d'erreur"
/*swe*/,"inga fel"
/*ita*/,"Nessun errore."
/*por*/,"???"
/*dut*/,"geen fouten"
)
T(TextControlBreak
/*eng*/,"Control-Break Pressed"
/*ger*/,"Control-Pause wurde gedrckt"
/*spa*/,"Presion Control-Break"
/*fre*/,"Control-Break Press"
/*swe*/,"Control-Break har tryckts"
/*ita*/,"Premuto Ctrl+Break"
/*por*/,"???"
/*dut*/,"Control-Break gedetecteerd"
)
T(TextExecuting
/*eng*/,"executing: "
/*ger*/,"fhre aus: "
/*spa*/,"ejecutando: "
/*fre*/,"excution: "
/*swe*/,"exekverar: "
/*ita*/,"Eseguo: "
/*por*/,"???"
/*dut*/,"uitvoeren: "
)
T(TextCompiling
/*eng*/,"Compiling: "
/*ger*/,"bersetze: "
/*spa*/,"Compilando: "
/*fre*/,"compilation: "
/*swe*/,"Kompilerar: "
/*ita*/,"Compilazione: "
/*por*/,"???"
/*dut*/,"compileren: "
)
T(TextRunLib
/*eng*/,"Running 'ar':"
/*ger*/,"'ar' wird ausgefhrt:"
/*spa*/,"Corriendo 'ar':"
/*fre*/,"excution de 'ar':"
/*swe*/,"Kr 'ar':"
/*ita*/,"Eseguo 'ar':"
/*por*/,"???"
/*dut*/,"Uitvoeren 'ar':"
)
T(TextLinking
/*eng*/,"Linking:"
/*ger*/,"Linken:"
/*spa*/,"Enlazando:"
/*fre*/,"Linking:"
/*swe*/,"Lnkar:"
/*ita*/,"Link:"
/*por*/,"???"
/*dut*/,"Linken:"
)
T(TextChecking
/*eng*/,"checking"
/*ger*/,"berprfe"
/*spa*/,"chequeando"
/*fre*/,"checking"
/*swe*/,"kontrollerar"
/*ita*/,"Controllo"
/*por*/,"???"
/*dut*/,"controleren"
)
T(TextUpToDate
/*eng*/,"is up to date"
/*ger*/,"ist aktuell"
/*spa*/,"est al da"
/*fre*/,"est  jour"
/*swe*/,"r aktuell"
/*ita*/," aggiornato"
/*por*/,"???"
/*dut*/,"is up to date"
)
T(TextIs
/*eng*/,"is"
/*ger*/,"ist"
/*spa*/,"es"
/*fre*/,"est"
/*swe*/,"r"
/*ita*/,""
/*por*/,"???"
/*dut*/,"is"
)
T(TextThan
/*eng*/,"than"
/*ger*/,"als"
/*spa*/,"que"
/*fre*/,"que"
/*swe*/,"n"
/*ita*/,"di"
/*por*/,"???"
/*dut*/,"dan"
)
T(TextNewer
/*eng*/,"newer"
/*ger*/,"neuer"
/*spa*/,"ms nuevo"
/*fre*/,"jamais"
/*swe*/,"nyare"
/*ita*/,"pi nuovo"
/*por*/,"???"
/*dut*/,"nieuwer"
)
T(TextOlder
/*eng*/,"older"
/*ger*/,"lter"
/*spa*/,"ms viejo"
/*fre*/,"plus vieux"
/*swe*/,"ldre"
/*ita*/,"pi vecchio"
/*por*/,"???"
/*dut*/,"ouder"
)
T(TextMustRebuild
/*eng*/,"must rebuild"
/*ger*/,"mu erzeugen"
/*spa*/,"debe rehacerse"
/*fre*/,"doit reconstruire"
/*swe*/,"mste bygga om"
/*ita*/,"devo ricostruire"
/*por*/,"???"
/*dut*/,"moet opnieuw compileren"
)
T(TextRebuildingOf
/*eng*/,"rebuilding of"
/*ger*/,"Erzeugung von"
/*spa*/,"rehaciendo "
/*fre*/,"reconstruction de"
/*swe*/,"ombyggnad av"
/*ita*/,"Ricostruzione di"
/*por*/,"???"
/*dut*/,"compilatie van"
)
T(TextSuccess
/*eng*/,"success"
/*ger*/,"Erfolg"
/*spa*/,"xito"
/*fre*/,"succs"
/*swe*/,"framgng"
/*ita*/,"successo"
/*por*/,"???"
/*dut*/,"succes"
)
T(TextError
/*eng*/,"error"
/*ger*/,"Fehler"
/*spa*/,"error"
/*fre*/,"erreur"
/*swe*/,"fel"
/*ita*/,"Errore"
/*por*/,"???"
/*dut*/,"fout"
)
T(TextContStderr
/*eng*/,"contents of stderr from "
/*ger*/,"Ausgaben zu 'stderr' von "
/*spa*/,"contenido de stderr desde "
/*fre*/,"contenu de stderr depuis "
/*swe*/,"innehll av 'stderr' frn "
/*ita*/,"Contenuto di 'stderr' da "
/*por*/,"???"
/*dut*/,"inhoud stderr van "
)
T(TextContStdout
/*eng*/,"contents of stdout from "
/*ger*/,"Ausgaben zu 'stdout' von "
/*spa*/,"contenido de stdout desde "
/*fre*/,"contenu de stdout depuis "
/*swe*/,"innehll av 'stdout' frn "
/*ita*/,"Contenuto di 'stdout' da"
/*por*/,"???"
/*dut*/,"inhoud stdout van "
)
T(TextMainTarget
/*eng*/,"Name of the main target"
/*ger*/,"Name des zu erzeugenden Programms"
/*spa*/,"Nombre del programa"
/*fre*/,"Nom de la cible principale"
/*swe*/,"Namn p mlfilen"
/*ita*/,"Nome del risultato"
/*por*/,"???"
/*dut*/,"naam van het projectprogramma"
)
T(LabelName
/*eng*/,"~N~ame"
/*ger*/,"~N~ame"
/*spa*/,"~N~ombre"
/*fre*/,"~N~om"
/*swe*/,"~N~amn"
/*ita*/,"~N~ome"
/*por*/,"???"
/*dut*/,"~N~aam"
)
T(TitleIncDir
/*eng*/,"Include Directories"
/*ger*/,"Verzeichnisse der Header-Dateien"
/*spa*/,"Directorios de Include"
/*fre*/,"Rpertoires des Includes"
/*swe*/,"Kataloger fr inkluderade filer"
/*ita*/,"Directory inclusioni"
/*por*/,"???"
/*dut*/,"~I~nclude directory's"
)
T(TitleLibDir
/*eng*/,"Library Directories"
/*ger*/,"Verzeichnisse der Bibliotheken"
/*spa*/,"Directorios de Libreras"
/*fre*/,"Rpertoires des librairies"
/*swe*/,"Kataloger fr bibliotek"
/*ita*/,"Directory librerie"
/*por*/,"???"
/*dut*/,"~B~ibliotheek directory's"
)
T(TitleObjDir
/*eng*/,"Object Directories"
/*ger*/,"Verzeichnisse der Objektdateien"
/*spa*/,"Directorios de Objetos (.o)"
/*fre*/,"Rpertoires des objets (.o)"
/*swe*/,"Kataloger fr objektkod"
/*ita*/,"Directory oggetti (.o)"
/*por*/,"???"
/*dut*/,"~O~bject directory's"
)
T(TitleSrcDir
/*eng*/,"Source Directories"
/*ger*/,"Verzeichnisse der Quelldateieen"
/*spa*/,"Directorios de Fuentes (.cc)"
/*fre*/,"Rpertoires des sources"
/*swe*/,"Kataloger fr kllkod"
/*ita*/,"Directory sorgenti"
/*por*/,"???"
/*dut*/,"~B~ron directory's"
)
T(TitleProgArgs
/*eng*/,"Program arguments"
/*ger*/,"Programmargumente"
/*spa*/,"Parmetros del programa"
/*fre*/,"Arguments du programme"
/*swe*/,"Programargument"
/*ita*/,"Parametri programma"
/*por*/,"???"
/*dut*/,"Programma parameters"
)
T(TextUsage1
/*eng*/,"usage: %s [options] [project-file]\n"
/*ger*/,"Aufruf: %s [Optionen] [Projektdatei]\n"
/*spa*/,"uso: %s [opciones] [proyecto]\n"
/*fre*/,"usge: %s [Options] [fichier-projet]\n"
/*swe*/,"Anvndning: %s [vxlar] [projektfil]\n"
/*ita*/,"Utilizzo: %s [opzioni] [file-progetto]\n"
/*por*/,"???"
/*dut*/,"gebruik: %s [opties] [projectbestand]\n"
)
T(TextUsage2
/*eng*/,"  project-file without extension\n"
/*ger*/,"  Projektdatei ohne Endung\n"
/*spa*/,"  colocar el proyecto sin extensin\n"
/*fre*/,"  Fichier-projet sans extension"
/*swe*/,"  projektfil utan ndelse\n"
/*ita*/,"  file progetto senza estensione"
/*por*/,"???"
/*dut*/,"  projectbestand zonder extensie"
)
T(TextUsage3
/*eng*/,"options:\n    -L <eng|ger|spa|fre|swe|ita>\n    -d[actd]\n"
/*ger*/,"Optionen:\n    -L <eng|ger|spa|fre|swe|ita>\n    -d[actd]\n"
/*spa*/,"Opciones:\n    -L <eng|ger|spa|fre|swe|ita>\n    -d[actd]\n"
/*fre*/,"Options:\n    -L <eng|ger|spa|fre|swe|ita>\n    -d[actd]\n"
/*swe*/,"vxlar:\n    -L <eng|ger|spa\n    -d[actd]\n"
/*ita*/,"Opzioni:\n    -L <eng|ger|spa|fre|swe|ita>\n    -d[actd]\n"
/*por*/,"???"
/*dut*/,"opties:\n    -L <eng|ger|spa|fre|swe|ita|por|dut>\n    -d[actd]\n"
)
T(TitleFileOpen
/*eng*/,"Open a file"
/*ger*/,"Eine Datei ffnen"
/*spa*/,"Abrir archivo"
/*fre*/,"Ouvrir un fichier"
/*swe*/,"ppna en fil"
/*ita*/,"Apertura file"
/*por*/,"???"
/*dut*/,"Open een bestand"
)
T(TitleMsgWindow
/*eng*/,"Messages Window"
/*ger*/,"Meldungsfenster"
/*spa*/,"Ventana de Mensajes"
/*fre*/,"Messages"
/*swe*/,"Meddelandefnster"
/*ita*/,"Finestra messaggi"
/*por*/,"???"
/*dut*/,"Mededelingenvenster"
)
T(TitlePrjWindow
/*eng*/,"Project Window"
/*ger*/,"Projekt Fenster"
/*spa*/,"Ventana del Proyecto"
/*fre*/,"Projet"
/*swe*/,"Projektfnster"
/*ita*/,"Finestra progetto"
/*por*/,"???"
/*dut*/,"Projectvenster"
)
T(LabelParameter
/*eng*/,"~P~arameter"
/*ger*/,"~P~arameter"
/*spa*/,"~P~armetros"
/*fre*/,"~P~aramtres"
/*swe*/,"~P~arameter"
/*ita*/,"~P~arametro"
/*por*/,"???"
/*dut*/,"~A~rgument"
)
T(TextUnmatchedQuote
/*eng*/,"There is an unmatched quote in your arguments"
/*ger*/,"Die Anzahl der Appostrophe ist nicht korrekt"
/*spa*/,"Hay una comilla sin cerra en sus parmetros"
/*fre*/,"Guillement non ferm dans un argument"
/*swe*/,"Det r ett ojmt antal citattecken i argumenten"
/*ita*/,"Numero virgolette nei parametri non corretto"
/*por*/,"???"
/*dut*/,"Ongesloten apostrophe gevonden in parameters"
)
T(LabelPathlist
/*eng*/,"~P~athlist"
/*ger*/,"~P~fadliste"
/*spa*/,"~C~aminos"
/*fre*/,"~C~hemins"
/*swe*/,"~S~kvg"
/*ita*/,"~P~ercorso"
/*por*/,"???"
/*dut*/,"~P~adlijst"
)
T(TitleOptFlags
/*eng*/,"Optimization Flags"
/*ger*/,"Optimierungs Optionen"
/*spa*/,"Opciones de Optimizacin"
/*fre*/,"Optimization Flags"
/*swe*/,"Optimeringsvxlar"
/*ita*/,"Opzioni Ottimizzazione"
/*por*/,"???"
/*dut*/,"Optimalisatieopties"
)
T(TitleWarnFlags
/*eng*/,"Warning Flags"
/*ger*/,"Warnungs Optionen"
/*spa*/,"Opciones de Warning"
/*fre*/,"Warning Flags"
/*swe*/,"Varningsvxlar"
/*ita*/,"Opzioni Warning"
/*por*/,"???"
/*dut*/,"Waarschuwingsopties"
)
T(TitleDebFlags
/*eng*/,"Debugging Flags"
/*ger*/,"Debugging Optionen"
/*spa*/,"Opciones de Depuracin"
/*fre*/,"Debugging Flags"
/*swe*/,"Avlusningsvxlar"
/*ita*/,"Opzioni Debugging"
/*por*/,"???"
/*dut*/,"Debugopties"
)
T(TitleCFlags
/*eng*/,"C Flags"
/*ger*/,"C-spezifische Optionen"
/*spa*/,"Opciones Especficas de C"
/*fre*/,"C Flags"
/*swe*/,"C-vxlar"
/*ita*/,"Opzioni del C"
/*por*/,"???"
/*dut*/,"C-specifieke opties"
)
T(TitleCXXFlags
/*eng*/,"C++ Flags"
/*ger*/,"C++-spezifische Optionen"
/*spa*/,"Opciones Especficas de C++"
/*fre*/,"C++ Flags"
/*swe*/,"C++ vxlar"
/*ita*/,"Opzioni del C++"
/*por*/,"???"
/*dut*/,"C++-specifieke opties"
)
T(TitleLibraries
/*eng*/,"Libraries"
/*ger*/,"Bibliotheken"
/*spa*/,"Libreras"
/*fre*/,"Librairies"
/*swe*/,"Bibliotek"
/*ita*/,"Librerie"
/*por*/,"???"
/*dut*/,"Bibliotheken"
)
T(TitleExtraLinkOpt
/*eng*/,"Additional linker options"
/*ger*/,"Zustzliche Linkeroptionen"
/*spa*/,"Opciones Adicionales del Linker"
/*fre*/,"Options additionelles de Link"
/*swe*/,"Extra lnkvxlar"
/*ita*/,"Opzioni del linker"
/*por*/,"???"
/*dut*/,"Overige linkeropties"
)
T(TitleExtraCOpt
/*eng*/,"Addition compiler options"
/*ger*/,"Zustzliche Compileroptionen"
/*spa*/,"Opciones Adicionales del Compilador"
/*fre*/,"Options additionelles de compilation"
/*swe*/,"Extra kompilatorvxlar"
/*ita*/,"Opzioni compilatore"
/*por*/,"???"
/*dut*/,"Overige compileropties"
)
T(TitleEnvOpt
/*eng*/,"Environment options"
/*ger*/,"Optionen der IDE"
/*spa*/,"Opciones del Entorno"
/*fre*/,"Environnement"
/*swe*/,"Miljinstllningar"
/*ita*/,"Opzioni della IDE"
/*por*/,"???"
/*dut*/,"Omgevingsopties"
)
T(ItemHook
/*eng*/,"Use Hook~2~1"
/*ger*/,"Benutze Hook~2~1"
/*spa*/,"Usar Hook~2~1"
/*fre*/,"Dtourner l'Int ~2~1"
/*swe*/,"Anvnd Hook~2~1"
/*ita*/,"Usa 'Hook~2~1'"
/*por*/,"???"
/*dut*/,"Gebruik Hook~2~1"
)
T(ItemBackup
/*eng*/,"create ~b~ackupfiles"
/*ger*/,"Erzeuge ~B~ackupdateien"
/*spa*/,"Crear archivos de ~r~espaldo"
/*fre*/,"crer des fichiers .~b~ak"
/*swe*/,"skapa ~b~ackupfiler"
/*ita*/,"Crea file .~B~AK"
/*por*/,"???"
/*dut*/,"genereer ~b~ackupbestanden"
)
T(ItemSyntax
/*eng*/,"syntax ~h~ighlighting"
/*ger*/,"Syntax~h~ervorhebung"
/*spa*/,"Resaltar la sinta~x~is"
/*fre*/,"coloration ~s~yntaxique"
/*swe*/,"s~y~ntaxupplysning"
/*ita*/,"~E~videnzia Sintassi"
/*por*/,"???"
/*dut*/,"syntax ~h~ighlighting"
)
T(ItemSaveBefore
/*eng*/,"~s~ave before compiling"
/*ger*/,"~S~peichern vor dem bersetzen"
/*spa*/,"~g~rabar antes de compilar"
/*fre*/,"~s~auve avant compilation"
/*swe*/,"~s~para innan kompilering"
/*ita*/,"~S~alva prima di compilare"
/*por*/,"???"
/*dut*/,"~o~pslaan voor compilatie"
)
T(ItemAutoIndent
/*eng*/,"~a~utoindent"
/*ger*/,"~a~utomatisches Einrcken"
/*spa*/,"~a~utoindentar"
/*fre*/,"~a~utoindentation"
/*swe*/,"~a~utoindent"
/*ita*/,"~A~utoindentazione"
/*por*/,"???"
/*dut*/,"~a~utoindent"
)
T(ItemOverWrite
/*eng*/,"o~v~erwrite mode"
/*ger*/,"~b~erschreibmodus"
/*spa*/,"modo de so~b~reescritura"
/*fre*/,"mode ~r~ecouvrement"
/*swe*/,"~e~rsttningslge"
/*ita*/,"So~v~rascrittura"
/*por*/,"???"
/*dut*/,"o~v~erschrijf mode"
)
T(ItemStderr
/*eng*/,"redirect 'stde~r~r'"
/*ger*/,"Umlenken von 'stde~r~r'"
/*spa*/,"redireccionar 'st~d~err'"
/*fre*/,"redirection 'stde~r~r'"
/*swe*/,"omrikta 'stde~r~r'"
/*ita*/,"Ridireziona 'stde~r~r'"
/*por*/,"???"
/*dut*/,"afvangen 'stde~r~r'"
)
T(ItemStdout
/*eng*/,"redirect 'stdou~t~'"
/*ger*/,"Umlenken von 'stdou~t~'"
/*spa*/,"redireccionar 'stdou~t~'"
/*fre*/,"redirection 'stdou~t~'"
/*swe*/,"omrikta 'stdou~t~'"
/*ita*/,"Ridireziona 'stdou~t~'"
/*por*/,"???"
/*dut*/,"afvangen 'stdou~t~'"
)
T(Item80x25
/*eng*/,"80x25 Color"
/*ger*/,"80x25 Farbe"
/*spa*/,"80x25 Color"
/*fre*/,"80x25 Couleur"
/*swe*/,"80x25 Frg"
/*ita*/,"80x25 Colore"
/*por*/,"???"
/*dut*/,"80x25 Kleur"
)
T(Item80x28
/*eng*/,"80x28 Color"
/*ger*/,"80x28 Farbe"
/*spa*/,"80x28 Color"
/*fre*/,"80x28 Couleur"
/*swe*/,"80x28 Frg"
/*ita*/,"80x28 Colore"
/*por*/,"???"
/*dut*/,"80x28 Kleur"
)
T(Item80x35
/*eng*/,"80x35 Color"
/*ger*/,"80x35 Farbe"
/*spa*/,"80x35 Color"
/*fre*/,"80x35 Couleur"
/*swe*/,"80x35 Frg"
/*ita*/,"80x35 Colore"
/*por*/,"???"
/*dut*/,"80x35 Kleur"
)
T(Item80x40
/*eng*/,"80x40 Color"
/*ger*/,"80x40 Farbe"
/*spa*/,"80x40 Color"
/*fre*/,"80x40 Couleur"
/*swe*/,"80x40 Frg"
/*ita*/,"80x40 Colore"
/*por*/,"???"
/*dut*/,"80x40 Kleur"
)
T(Item80x43
/*eng*/,"80x43 Color"
/*ger*/,"80x43 Farbe"
/*spa*/,"80x43 Color"
/*fre*/,"80x43 Couleur"
/*swe*/,"80x43 Frg"
/*ita*/,"80x43 Colore"
/*por*/,"???"
/*dut*/,"80x43 Kleur"
)
T(Item80x50
/*eng*/,"80x50 Color"
/*ger*/,"80x50 Farbe"
/*spa*/,"80x50 Color"
/*fre*/,"80x50 Couleur"
/*swe*/,"80x50 Frg"
/*ita*/,"80x50 Colore"
/*por*/,"???"
/*dut*/,"80x50 Kleur"
)
T(ItemUserMode
/*eng*/,"other"
/*ger*/,"anderer"
/*spa*/,"otro"
/*fre*/,"autre"
/*swe*/,"annan"
/*ita*/,"Altro"
/*por*/,"???"
/*dut*/,"overige"
)
T(LabelOptions
/*eng*/,"O~p~tions"
/*ger*/,"O~p~tionen"
/*spa*/,"O~p~ciones"
/*fre*/,"O~p~tions"
/*swe*/,"~I~nstllningar"
/*ita*/,"O~p~zioni"
/*por*/,"???"
/*dut*/,"O~p~ties"
)
T(LabelScreenMode
/*eng*/,"~S~creen mode"
/*ger*/,"B~i~ldschirmmodus"
/*spa*/,"Modo~s~ de pantalla"
/*fre*/,"Mode ~e~cran"
/*swe*/,"~S~krmlge"
/*ita*/,"Modo ~s~chermo"
/*por*/,"???"
/*dut*/,"~S~chermmode"
)
T(LabelTabSize
/*eng*/,"~T~absize"
/*ger*/,"~T~abgre"
/*spa*/,"Tamao del ~T~ab"
/*fre*/,"Taille ~T~abulation"
/*swe*/,"~T~ablngd"
/*ita*/,"Dim.~T~ab"
/*por*/,"???"
/*dut*/,"~T~abstops"
)
T(ButtonAdd
/*eng*/,"~A~dd"
/*ger*/,"~H~inzu"
/*spa*/,"~A~gregar"
/*fre*/,"~A~jouter"
/*swe*/,"~L~gg till"
/*ita*/,"~A~ggiungi"
/*por*/,"???"
/*dut*/,"~T~oevoegen"
)
T(ButtonDel
/*eng*/,"~D~elete"
/*ger*/,"~E~ntfernen"
/*spa*/,"~B~orrar"
/*fre*/,"~S~upprimer"
/*swe*/,"~T~a bort"
/*ita*/,"~C~ancella"
/*por*/,"???"
/*dut*/,"~V~erwijderen"
)
T(ButtonDefault
/*eng*/,"De~f~ault"
/*ger*/,"~S~tandard"
/*spa*/,"De~f~ecto"
/*fre*/,"Dfaut"
/*swe*/,"~S~tandard"
/*ita*/,"De~f~ault"
/*por*/,"???"
/*dut*/,"~S~tandaard"
)
T(TitleNewValue
/*eng*/,"New value"
/*ger*/,"Neuer Wert"
/*spa*/,"Nuevo valor"
/*fre*/,"Nouvelle valeur"
/*swe*/,"Nytt vrde"
/*ita*/,"Nuovo valore"
/*por*/,"???"
/*dut*/,"Nieuwe waarde"
)
T(LabelNewValue
/*eng*/,"~V~alue"
/*ger*/,"~W~ert"
/*spa*/,"~V~alor"
/*fre*/,"~V~aleur"
/*swe*/,"~V~rde"
/*ita*/,"~V~alore"
/*por*/,"???"
/*dut*/,"~W~aarde"
)
T(TitleReservedWords
/*eng*/,"Reserved words"
/*ger*/,"Reservierte Wrter"
/*spa*/,"Palabras reservadas"
/*fre*/,"Mots rservs"
/*swe*/,"Reserverade ord"
/*ita*/,"Parole riservate"
/*por*/,"???"
/*dut*/,"Gereserveerde woorden"
)
T(MsgInvalidProject
/*eng*/,"Invalid project-file %s(%s)"
/*ger*/,"Ungltige Projektdatei %s(%s)"
/*spa*/,"Archivo de Proyecto invlido %s(%s)"
/*fre*/,"Fichier-projet erron %s(%s)"
/*swe*/,"Ogiltig projektfil %s(%s)"
/*ita*/,"File-progetto invalido %s(%s)"
/*por*/,"???"
/*dut*/,"Ongeldig projectbestand %s(%s)"
)
T(MsgCantOpen
/*eng*/,"Could'nt open %s"
/*ger*/,"Kann %s nicht ffnen"
/*spa*/,"No puedo abrir %s"
/*fre*/,"Impossible d'ouvrir %s"
/*swe*/,"Kunde inte ppna %s"
/*ita*/,"Impossibile aprire %s"
/*por*/,"???"
/*dut*/,"Kan %s niet openen"
)
T(TitleAddItem
/*eng*/,"Add Item"
/*ger*/,"Element hinzufgen"
/*spa*/,"Agregar elemento"
/*fre*/,"Ajouter l'lment"
/*swe*/,"Lgg till fil"
/*ita*/,"Aggiungi elemento"
/*por*/,"???"
/*dut*/,"Item toevoegen"
)
T(MsgDupItem
/*eng*/,"The item '%s' is already in your project"
/*ger*/,"Das Element '%s' ist schon im Projekt"
/*spa*/,"El elemento '%s' ya est en el proyecto"
/*fre*/,"L'lment %s est dj dans votre projet"
/*swe*/,"Filen '%s' finns redan i projektet"
/*ita*/,"L'elemento '%s'  gi nel tuo progetto"
/*por*/,"???"
/*dut*/,"Het project bevat reeds het item '%s'"
)
T(MsgRemoveItem
/*eng*/,"Remove '%s' from the project"
/*ger*/,"'%s' aus dem Projekt entfernen"
/*spa*/,"Quito '%s' del proyecto"
/*fre*/,"Enlve '%s' du projet"
/*swe*/,"Ta bort '%s' frn projektet"
/*ita*/,"Rimuovi '%s' dal progetto"
/*por*/,"???"
/*dut*/,"'%s' uit huidig project verwijderen"
)
T(TextLocalOpt
/*eng*/,"local commandline options for "
/*ger*/,"lokale Kommandozeilenargumente "
/*spa*/,"Opciones locales para "
/*fre*/,"Options locales de ligne de commande pour "
/*swe*/,"Lokala kommandoradsvxlar fr "
/*ita*/,"Opzioni locali di riga di comando per "
/*por*/,"???"
/*dut*/,"Lokale compilatieopties voor "
)
T(TextIncFiles
/*eng*/,"Include files for "
/*ger*/,"Include-Dateien fr "
/*spa*/,"Includes de "
/*fre*/,"Fichiers inclus pour "
/*swe*/,"Inkluderade filer i "
/*ita*/,"File di inclusione per "
/*por*/,"???"
/*dut*/,"Include-bestanden voor "
)
T(TitleWindowList
/*eng*/,"WindowList"
/*ger*/,"Fensterliste"
/*spa*/,"Lista de Ventanas"
/*fre*/,"Liste des fentres"
/*swe*/,"Fnsterlista"
/*ita*/,"Lista Finestre"
/*por*/,"???"
/*dut*/,"Vensterlijst"
)
T(TextUseStdLibs
/*eng*/,"Use ~s~tandard libraries"
/*ger*/,"Benutze ~s~tandard Bibliotheken"
/*spa*/,"Usar librera ~s~tandard"
/*fre*/,"Utilise les librairies ~s~tandard"
/*swe*/,"Anvnd ~s~tandardbibliotek"
/*ita*/,"Usa librerie ~s~tandard"
/*por*/,"???"
/*dut*/,"Gebruik ~s~tandaardbibliotheken"
)
T(TitleProjectOpen
/*eng*/,"Select a project"
/*ger*/,"Ein Projekt auswhlen"
/*spa*/,"Seleccionar un proyecto"
/*fre*/,"Slectionne un projet"
/*swe*/,"Vlj ett projekt"
/*ita*/,"Seleziona un progetto"
/*por*/,"???"
/*dut*/,"Selecteer een project"
)
T(TitleGotoLine
/*eng*/,"Goto the line"
/*ger*/,"Gehe zur Zeile"
/*spa*/,"Ir a la lnea"
/*fre*/,"Aller  la ligne"
/*swe*/,"G till raden"
/*ita*/,"Vai alla linea"
/*por*/,"???"
/*dut*/,"Ga naar de regel"
)
T(LabelGotoLine
/*eng*/,"line ~n~umber"
/*ger*/,"Zeilen~n~ummer"
/*spa*/,"lnea ~n~ro."
/*fre*/,"Ligne ~n~umro"
/*swe*/,"rad ~n~ummer"
/*ita*/,"Linea ~n~umero"
/*por*/,"???"
/*dut*/,"Regel ~n~ummer"
)
T(TitleGrep
/*eng*/,"arguments for GREP"
/*ger*/,"Argumente fr GREP"
/*spa*/,"Parmetros para GREP"
/*fre*/,"Arguments pour GREP"
/*swe*/,"argument fr GREP"
/*ita*/,"Argomenti per GREP"
/*por*/,"???"
/*dut*/,"parameters voor GREP"
)
T(TitleAbout
/*eng*/,"About RHIDE"
/*ger*/,"ber RHIDE"
/*spa*/,"Acerca de RHIDE"
/*fre*/,"A propos de RHIDE"
/*swe*/,"Om RHIDE"
/*ita*/,"Informazioni su RHIDE"
/*por*/,"???"
/*dut*/,"Over RHIDE"
)
T(TextAbout1
/*eng*/,"RHIDE is an Integrated Development Environment"
/*ger*/,"RHIDE ist eine Integrierte Entwicklungsumgebung"
/*spa*/,"RHIDE es un Entorno de Desarrollo Integrado"
/*fre*/,"RHIDE est un environnement de dveloppement intgr (IDE)"
/*swe*/,"RHIDE r en integrerad programmeringsmilj"
/*ita*/,"RHIDE  un Ambiente Integrato di Sviluppo (IDE)"
/*por*/,"???"
/*dut*/,"RHIDE is een gentegreerde programmeringsomgeving (IDE)"
)
T(TextAbout2
/*eng*/,"for developing DJGPP apps"
/*ger*/,"zur Entwicklung von DJGPP Applicationen"
/*spa*/,"para realizar aplicaciones con DJGPP"
/*fre*/,"pour le dveloppement d'applications avec DJGPP"
/*swe*/,"fr utveckling av applikationer med DJGPP"
/*ita*/,"per sviluppare applicazioni con DJGPP."
/*por*/,"???"
/*dut*/,"voor het ontwikkelen van DJGPP applicaties"
)
T(TextAbout3
/*eng*/,"Copyright (C) by Robert Hhne, 1996"
/*ger*/,"Alle Rechte bei Robert Hhne, 1996"
/*spa*/,"Copyright (C) por Robert Hhne, 1996"
/*fre*/,"Copyright (C) par Robert Hhne, 1996"
/*swe*/,"Copyright (C) Robert Hhne, 1996"
/*ita*/,"Tutti i diritti riservati (C) Robert Hhne, 1996"
/*por*/,"???"
/*dut*/,"Copyright (C) Robert Hhne, MCMXCVI"
)
T(UsingTempDir
/*eng*/,"using %s as temp directory\n"
/*ger*/,"benutze %s als temporres Verzeichnis\n"
/*spa*/,"usando %s como directorio temporal\n"
/*fre*/,"utilisation de %s comme rpertoire temporaire\n"
/*swe*/,"Anvnder %s som tillfllig katalog\n"
/*ita*/,"Utilizzer %s come directory temporanea"
/*por*/,"???"
/*dut*/,"gebruik %s als tijdelijke directory"
)
T(TextForProfile
/*eng*/,"link for ~p~rofiling"
/*ger*/,"Linken zum ~p~rofeilen"
/*spa*/,"enlazar para ~p~rofiling"
/*fre*/,"Link pour ~p~rofiling"
/*swe*/,"Lnka fr ~p~rofilering"
/*ita*/,"Link per ~p~rofiling"
/*por*/,"???"
/*dut*/,"linken voor ~p~rofilen"
)
T(TextRedirecting
/*eng*/,"redirecting %s to %s\n"
/*ger*/,"%s wird nach %s umgeleitet\n"
/*spa*/,"redireccionando %s a %s\n"
/*fre*/,"redirige %s vers %s\n"
/*swe*/,"omriktar %s till %s\n"
/*ita*/,"Ridireziono %s verso %s\n"
/*por*/,"???"
/*dut*/,"%s wordt afgevangen in %s\n"
)
T(ItemShowDoing /* max 24 chars */
/*eng*/,"sho~w~ process information"
/*ger*/,"~z~eigt Prozessinformation"
/*spa*/,"~m~uestra inf. del proceso"
/*fre*/,"montre infos sur le process"
/*swe*/,"~v~isa processinformation"
/*ita*/,"Mostra info sul processo"
/*por*/,"???"
/*dut*/,"~t~oont procesinformatie"
)
T(ItemShowMem /* max 24 chars */
/*eng*/,"show free ~m~emory"
/*ger*/,"zeigt freien ~S~peicher"
/*spa*/,"muestra memoria ~l~ibre"
/*fre*/,"montre la memoire libre"
/*swe*/,"visa fritt ~m~inne"
/*ita*/,"Mostra memoria libera"
/*por*/,"???"
/*dut*/,"~t~oont vrij geheugen"
)
