/* This file is part of RHIDE, Copyright (C) 1996 Robert Hhne */
#if ( __GNUC_MINOR__ < 7 )
#pragma implementation "IDEApp.h"
#endif

#define Uses_TMenu
#define Uses_TSubMenu
#define Uses_TMenuBar
#define Uses_TMenuItem
#define Uses_TStatusLine
#define Uses_TStatusItem
#define Uses_TStatusDef
#define Uses_TStaticText
#define Uses_TKeys
#define Uses_TEditor
#define Uses_TDeskTop
#define Uses_TIDEEditWindow
#define Uses_TIDEFileEditor
#define Uses_TView
#define Uses_fpstream
#define Uses_TDialog
#define Uses_TProject
#define Uses_TOptions
#define Uses_TDepCollection
#define Uses_MsgBox
#define Uses_TScreen
#define Uses_TMouse
#define Uses_TMemInfo
#define Uses_IDEConst
#define Uses_TPalette
#define Uses_TSCollection
#define Uses_RawKeys
#define Uses_THintStatusLine
#define Uses_TEditWindow
#define Uses_TFileDialog
#define Uses_TFileInputLine
#define Uses_TEditorApp
#define Uses_TScreen
#define Uses_TDisplay
#define Uses_LangTexte
#define Uses_TValidator
#define Uses_TDirList
#define Uses_TButton
#define Uses_TWindowList

#include <IDEClass.h>
#include "IDE.h"
#include "IDEApp.h"
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <go32.h>
#include <signal.h>
#include <sys/exceptn.h>
#include <libc/dosio.h>
#include <sys/stat.h>
#include <unistd.h>

#include <inf.h>

#if 0
/*0x01-0x0F*/"\x71\x70\x78\x74\x20\x28\x24\x17\x1F\x1A\x31\x31\x1E\x71\x00"\
/*0x10-0x1F*/"\x37\x3F\x3A\x13\x13\x3E\x21\x00\x07\x0F\x0F\x07\x0F\x07\x70\x00"\
/*0x20-0x2F*/"\x70\x7F\x7A\x13\x13\x70\x70\x7F\x7E\x20\x2B\x2F\x78\x2E\x70\x30"\
/*0x30-0x3F*/"\x3F\x3E\x1F\x2F\x1A\x20\x72\x31\x31\x30\x2F\x3E\x31\x13\x1F\x00"\
/*0x40-0x4D*/"\x1E\x71\x17\x1F\x1E\x1F\x1B\x1D\x1D\x1D\x1D\x1B\x1A\x40"\
/*0x4E-0x5B*/"\x3E\x23\x1E\x1E\x1E\x1E\x1E\x1E\x1E\x1E\x1E\x1E\x1E\x1E"\
/*0x5C-0x69*/"\x70\x7F\x1E\x1E\x1E\x1E\x1E\x1E\x1E\x1E\x1E\x1E\x1E\x1E"\
/*0x6A-0x73*/"\x37\x3F\x3A\x13\x13\x30\x3E\x1E\x4E\x2E"\
/*0x74-0x7D*/"\x07\x0F\x07\x70\x70\x07\x0F\x70\x0F\x70"\
/*0x7E-0x87*/"\x07\x0F\x07\x70\x70\x07\x0F\x70\x0F\x70"
#endif

#define cpIDEColor\
	"\x71\x70\x78\x74\x20\x28\x24\x17\x1F\x1A\x31\x31\x1E\x71\x00"\
	"\x37\x3F\x3A\x13\x13\x3E\x21\x00\x07\x0F\x0F\x07\x0F\x07\x70\x00"\
	"\x70\x7F\x7A\x13\x13\x70\x70\x7F\x7E\x20\x2B\x2F\x78\x2E\x70\x30"\
	"\x3F\x3E\x1F\x2F\x1A\x20\x72\x31\x31\x30\x2F\x3E\x31\x13\x1F\x00"\
	"\x1E\x71\x17\x1F\x1E\x1F\x1B\x1D\x1D\x1D\x1D\x1B\x1A\x40"\
	"\x3E\x23\x1E\x1E\x1E\x1E\x1E\x1E\x1E\x1E\x1E\x1E\x1E\x1E"\
	"\x70\x7F\x1E\x1E\x1E\x1E\x1E\x1E\x1E\x1E\x1E\x1E\x1E\x1E"\
	"\x37\x3F\x3A\x13\x13\x30\x3E\x1E\x4E\x2E"\
	"\x07\x0F\x07\x70\x70\x07\x0F\x70\x0F\x70"\
	"\x07\x0F\x07\x70\x70\x07\x0F\x70\x0F\x70"

TPalette & IDE::getPalette() const
{
  static TPalette palette(cpIDEColor,sizeof(cpIDEColor)-1);
  return palette;
}

#define DELTA(x) (*((long *)(x)))

int global_argc = 0;
char **global_argv = NULL;
int debug_dependencies = 0;
int debug_commands = 0;
int debug_tempfiles = 0;

TIDEMemInfo *mem_info = NULL;

void update_mem()
{
  if (!ShowMem && mem_info)
  {
    TProgram::application->remove(mem_info);
    delete mem_info;
    mem_info = NULL;
  }
  if (ShowMem)
  {
    if (!mem_info)
    {
      TRect r = TProgram::menuBar->getExtent();
      r.a.x = r.b.x - 8;
      mem_info = new TIDEMemInfo(r);
      mem_info->growMode = gfGrowLoX;
      TProgram::application->insert(mem_info);
    }
    mem_info->update();
  }
}

TEditWindow *IDE::openEditor( const char *fileName, Boolean visible )
{
    TRect r = deskTop->getExtent();
    TView *p;
    r.b.y -= 7;
    p = validView( new TIDEEditWindow( r, fileName, wnNoNumber ) );
    if( !visible )
	p->hide();
    AddWindow((TWindow *)p);
    if (AutoIndent) ((TEditWindow *)p)->editor->autoIndent = True;
    if (OverWrite) ((TEditWindow *)p)->editor->overwrite = True;
    TimeOfFile(((TEditWindow *)p)->getTitle(100),True); // this removes the file from the hashtable
    p->growMode = gfGrowHiX | gfGrowHiY;
    return (TEditWindow *)p;
}

#define D(x) disableCommand(x)
#define E(x) enableCommand(x)

void IDE::update()
{
  int count,i;
  TEvent event;
  update_mem();
  if (!windows || windows->getCount() == 0)
  {
    D(cmShowWindowList);
    count = -1;
  }
  else
  {
    E(cmShowWindowList);
    count = windows->getCount();
  }
  {
    if (msg_window == NULL)
    {
      D(cmNextMessage);
      D(cmPrevMessage);
    }
    else
    {
      E(cmNextMessage);
      E(cmPrevMessage);
    }
    for (i=0;i<count;i++)
    {
      if (DESKTOPWINDOW(i)->options & ofTileable)
      {
        E(cmTile);
        E(cmCascade);
        break;
      }
    }
    if (count == -1 || i == count)
    {
      D(cmTile);
      D(cmCascade);
    }
    for (i=0;i<count;i++)
    {
      event.what = evCommand;
      event.message.command = cmEditorAnswer;
      DESKTOPWINDOW(i)->handleEvent(event);
      if (event.what == evNothing)
      {
        E(cmGotoLine);
        E(cmFind);
        E(cmReplace);
        E(cmSearchAgain);
        E(cmSave);
        E(cmSaveAll);
        E(cmCompile);
        break;
      }
    }
    if (count == -1 || i == count)
    {
      D(cmGotoLine);
      D(cmFind);
      D(cmReplace);
      D(cmSearchAgain);
      D(cmSave);
      D(cmSaveAll);
      if (!project_name || Project.dependencies->getCount() == 0)
        D(cmCompile);
    }
  }
  if (project_name)
  {
    E(cmProgArgs);
    E(cmAddProjectItem);
    E(cmTargetName);
    E(cmShowProject);
    E(cmCloseProject);
    if (Project.dependencies->getCount() == 0)
    {
      D(cmDelProjectItem);
      D(cmLocalOptions);
      D(cmShowIncludes);
      D(cmMake);
      D(cmBuild);
      D(cmWriteMake);
      D(cmLink);
      D(cmRun);
      D(cmFSDB);
      D(cmGDB);
      D(cmGPROF);
      D(cmClearDependencies);
      D(cmMakeClear);
    }
    else
    {
      E(cmDelProjectItem);
      E(cmLocalOptions);
      E(cmShowIncludes);
      E(cmMake);
      E(cmBuild);
      E(cmWriteMake);
      E(cmLink);
      E(cmRun);
      E(cmCompile);
      E(cmClearDependencies);
      E(cmMakeClear);
      if (Project.dest_file_type == FILE_EXE ||
          Project.dest_file_type == FILE_COFF)
      {
        E(cmFSDB);
        if (Project.dest_file_type == FILE_COFF)
        {
          E(cmGDB);
          E(cmGPROF);
        }
        else
        {
          D(cmGDB);
          D(cmGPROF);
        }
      }
    }
  }
  else
  {
    D(cmMake);
    D(cmBuild);
    D(cmWriteMake);
    D(cmLink);
    D(cmRun);
    D(cmProgArgs);
    D(cmAddProjectItem);
    D(cmDelProjectItem);
    D(cmLocalOptions);
    D(cmShowIncludes);
    D(cmTargetName);
    D(cmShowProject);
    D(cmCloseProject);
    D(cmFSDB);
    D(cmGDB);
    D(cmGPROF);
    D(cmClearDependencies);
    D(cmMakeClear);
  }
}

#undef D
#undef E

void IDE::idle()
{
  TEditorApp::idle();
  update();
}

void TargetName()
{
  char buffer[256];
  strcpy(buffer,Project.dest_name);
  if (inputBox(GT(TextMainTarget),GT(LabelName),buffer,255) == cmOK)
  {
    char *dir,*fname,*ext;
    string_free(Project.dest_name);
    string_dup(Project.dest_name,buffer);
    split_fname(buffer,dir,fname,ext);
    Project.dest_file_type = get_file_type(ext);
    Project.source_file_type = FILE_UNKNOWN;
    Project.compile_id = how_to_compile(NULL,ext);
    string_free(dir);
    string_free(fname);
    string_free(ext);
  }
}

void SaveScreen();
void RestoreScreen();

ushort MyinputBox(const char*,const char *,char *,int,TValidator *);

static void GotoLine(TFileEditor *editor)
{
  int line=editor->curPos.y+1;
  char temp[10];
  sprintf(temp,"%d",line);
  if (MyinputBox(GT(TitleGotoLine),GT(LabelGotoLine),
                 temp,10
                 ,new TRangeValidator(1,editor->limit.y)) == cmOK)
  {
    sscanf(temp,"%d",&line);
    goto_line(editor,line);
  }
}

void Repaint()
{
  TProgram::deskTop->redraw();
  TProgram::application->redraw();
  message(TProgram::application,evBroadcast,cmRedraw,NULL);
}

void IDE::dosShell()
{
  char *comspec,*directory;
  TEvent event;
  ushort oldmode = TScreen::getCrtMode();
  event.what = evCommand;
  event.message.command = cmSaveAll;
  App->handleEvent(event);
  SaveProject();
  App->deskTop->setState(sfVisible,False);
  App->suspend();
  RestoreScreen();
  comspec = getenv("COMSPEC");
  if (!comspec) comspec = "command.com";
  directory = getcwd(NULL,MAXLFNPATH);
  if (debug_commands)
  {
    fprintf(stderr,"%s: %s\n",GT(TextExecuting),comspec);
  }
  system(comspec);
  chdir(directory);
  free(directory);
  SaveScreen();
  App->resume();
  App->deskTop->setState(sfVisible,True);
  App->setScreenMode(oldmode);
  Repaint();
}

extern char IDEVersion[];

static void About()
{
  TDialog *dialog;
  TStaticText *text;
  char buffer[1000];
  dialog = new TDialog(TRect(0,0,60,15),GT(TitleAbout));
  dialog->options |= ofCentered;
  sprintf(buffer,"\003%s\n"
  		 "\003\n"
  		 "\003%s\n"
  		 "\003%s\n\003\n"
  		 "\003%s\n",
  		 IDEVersion,
  		 GT(TextAbout1),
  		 GT(TextAbout2),
  		 GT(TextAbout3));
  text = new TStaticText(TRect(0,0,50,9),buffer);
  text->options |= ofCentered;
  dialog->insert(text);
  dialog->insert(new TButton(TRect(25,11,35,13),GT(ButtonOK),cmOK,bfDefault));
  TProgram::deskTop->execView(dialog);
  delete dialog;
}

char *WordUnderCursor(TEditor *editor);

static int help_request = 0;
extern int help_in_use;
static ushort help_ctx;

void IDE::getEvent(TEvent & event)
{
  TEditorApp::getEvent(event);
  if (help_request && event.what == evNothing)
  {
    event.what = evCommand;
    event.message.command = cmHelp;
  }
  switch (event.what)
  {
    case evCommand:
      switch (event.message.command)
      {
        case cmHelp:
          if (help_in_use) break;
          if (help_request)
          {
            Help(help_ctx);
            help_request = 0;
          }
          else
          {
            help_request = 1;
            help_ctx = getHelpCtx();
            event.message.command = 0xFFFF;
            break;
          }
          clearEvent(event);
          break;
        default:
          break;
      }
    default:
      break;
  }
}

#define SC(command)\
	case cm##command:\
	  command();\
	  clearEvent(event);\
	  break

     
void IDE::handleEvent(TEvent & event)
{
  TWindow *window = NULL;
  int closecmd = 0;
  switch (event.what)
  {
    case evCommand:
      switch (event.message.command)
      {
        case cmClose:
          window = (TWindow *)deskTop->current;
          closecmd=1;
          break;
        case cmEnter:
          event.what = evKeyDown;
          event.keyDown.keyCode = RawkbSpace;
          break;
        case cmFind:
        case cmReplace:
        {
          char *word;
          TEvent ev;
          ev.what = evCommand;
          ev.message.command = cmEditorAnswer;
          deskTop->current->handleEvent(ev);
          if (ev.what == evNothing)
          {
            word = WordUnderCursor(
                        ((TEditWindow *)TProgram::deskTop->current)->editor);
            if (word)
            {
              strcpy(TEditor::findStr,word);
              string_free(word);
            }
          }
          break;
        }
        default:
          break;
      }
    default:
      break;
  }
  TEditorApp::handleEvent(event);
  switch (event.what)
  {
    case evCommand:
      switch (event.message.command)
      {
        SC(FSDB);
        SC(GDB);
        SC(EditReserved);
        SC(About);
        SC(EditCFlags);
        SC(EditCXXFlags);
        SC(EditOptFlags);
        SC(EditWarnFlags);
        SC(EditDebugFlags);
        SC(Preferences);
        SC(GREP);
        SC(Repaint);
        SC(Colors);
        SC(WriteMake);
        SC(Libraries);
        SC(WarningFlags);
        SC(OptimizationFlags);
        SC(DebugFlags);
        SC(CFlags);
        SC(CXXFlags);
        SC(AddProjectItem);
        SC(DelProjectItem);
        SC(ShowWindowList);
        SC(ShowProject);
        SC(TargetName);
        SC(ShowIncludes);
        SC(LocalOptions);
        SC(LinkerOptions);
        SC(CompilerOptions);
        SC(Make);
        SC(Build);
        SC(Compile);
        SC(EditUserWords);
        SC(ClearDependencies);
        SC(MakeClear);
        SC(HelpIndex);
#ifdef INTERNAL_DEBUGGER
        SC(Trace);
        SC(Step);
        SC(Goto);
        SC(Reset);
#endif
        case cmSelectProject:
        {
          char *dir,*name,*ext;
          TDependency *dep = (TDependency *)event.message.infoPtr;
          split_fname(dep->dest_name,dir,name,ext);
          dir[strlen(dir)-1] = 0;
          chdir(dir);
          string_free(dir);
          string_free(name);
          string_free(ext);
          OpenProject(dep->source_name);
          clearEvent(event);
          break;
        }
        case cmSyntaxHelp:
        {
          char *word = WordUnderCursor(
                         ((TEditWindow *)TProgram::deskTop->current)->editor);
          if (word) SyntaxHelp(word);
          else SyntaxHelp("");
          if (word) string_free(word);
          clearEvent(event);
          break;
        }
        case cmGotoLine:
        {
          TView *ew = TProgram::deskTop->current;
          event.what = evCommand;
          event.message.command = cmEditorAnswer;
          if (ew != NULL)
          {
            ew->handleEvent(event);
            if (event.what == evNothing)
              GotoLine(((TEditWindow *)ew)->editor);
          }
          clearEvent(event);
          break;
        }
        case cmNextMessage:
          event.message.command = cmNextMsg;
          if (msg_window) msg_window->handleEvent(event);
          break;
        case cmPrevMessage:
          event.message.command = cmPrevMsg;
          if (msg_window) msg_window->handleEvent(event);
          break;
	case cmSaveAll:
	  {
	    int i;
	    if (windows) 
	    {
	      int count = windows->getCount();
	      for (i=0;i<count;i++)
	      {
	        window = DESKTOPWINDOW(i);
	        if (window != clipWindow && 
		    window != (TWindow *)project_window &&
		    window != msg_window)
	        {
		  event.what = evCommand;
		  event.message.command = cmSave;
	  	  window->handleEvent(event);
	        }
	      }
	    }
	  }
	  clearEvent(event);
	  break;
	case cmRun:
	if (debugger_started)
	{
	  Continue();
	}
	else
	{
	  TView *lasteditor = NULL;
	  event.what = evCommand;
	  event.message.command = cmEditorAnswer;
	  TProgram::deskTop->current->handleEvent(event);
	  if (event.what == evNothing)
	  {
	    if (TProgram::deskTop->current->state & sfSelected)
	    {
	      lasteditor = TProgram::deskTop->current;
	    }
	  }
	  ShowMessages(NULL,True);
	  if (Make(False) == True)
	  {
	    event.what = evCommand;
	    event.message.command = cmSaveAll;
	    handleEvent(event);
 	    RunMainTarget();
            if (lasteditor != NULL && !ShowStderr && !ShowStdout)
              lasteditor->select();
	  }
	  clearEvent(event);
	  break;
	}
	case cmLink:
	  ShowMessages(NULL,True);
	  compile_dep(project);
	  clearEvent(event);
	  break;
	case cmIncludeDir:
	  EditDirList(Options.include_path,GT(TitleIncDir));
	  clearEvent(event);
	  break;
	case cmLibDir:
	  EditDirList(Options.library_path,GT(TitleLibDir));
	  clearEvent(event);
	  break;
	case cmObjDir:
	  EditDirList(Options.ObjDirs,GT(TitleObjDir));
	  clearEvent(event);
	  break;
	case cmSrcDir:
	  EditDirList(Options.SrcDirs,GT(TitleSrcDir));
	  clearEvent(event);
	  break;
	case cmProgArgs:
	  EditParamList(Options.ProgArgs,GT(TitleProgArgs));
	  clearEvent(event);
	  break;
	case cmOpenProject:
	{
          ushort result;
          TFileDialog *dialog;
          char *fileName = NULL,*dir;
          dialog = new TFileDialog("*"PROJECT_EXT,GT(TitleProjectOpen),
                                GT(LabelName),fdOpenButton,0);
          TProgram::deskTop->insert(dialog);
          dialog->setState(sfModal,True);
          result = dialog->execute();
          if( result != cmCancel )
          {
            string_dup(fileName,dialog->fileName->data);
            string_dup(dir,dialog->directory);
            if (!_USE_LFN) string_down(fileName);
          }
          TProgram::deskTop->remove(dialog);
          delete dialog;
          if (result != cmCancel )
          {
            CloseProject();
            chdir(dir);
            string_free(dir);
            OpenProject(fileName);
            string_free(fileName);
          }
	  clearEvent(event);
	  break;
	}
	case cmCloseProject:
	  CloseProject();
	  OpenProject(NULL);
	  clearEvent(event);
	  break;
	case cmUserScreen:
	{
	  ushort oldmode = TScreen::getCrtMode();
	  TMouse::hide();
	  RestoreScreen();
	  clearEvent(event);
	  do
	  {
	    getEvent(event);
	  } while (event.what == evNothing);
	  clearEvent(event);
	  App->setScreenMode(oldmode);
	  TMouse::show();
	  Repaint();
	  break;
	}
      }
      break;
  }
  if (closecmd && event.what == evNothing)
  {
    if (window != clipWindow) RemoveWindow(window);
    if (window == (TWindow *)project_window) project_window = NULL;
    if (window == (TWindow *)msg_window) msg_window = NULL;
    if (window == (TWindow *)InfWindow)
    {
      InfWindow = NULL;
      help_in_use = 0;
    }
  }
}

TMenuBar *IDE::initMenuBar( TRect r )
{
  return GetMenuBar(r);
}

TStatusLine *IDE::initStatusLine( TRect r )
{
  return GetStatusLine(r);
}

IDE *App;
extern TEditWindow * clipWindow;

void InitPipe();

static char * PRJNAME = NULL;
static char * EDITNAME = NULL;

static void usage() __attribute__((noreturn));
static void usage()
{
  fprintf(stderr,GT(TextUsage1),RHIDE_NAME);
  fprintf(stderr,GT(TextUsage2));
  fprintf(stderr,GT(TextUsage3));
  fflush(stderr);
  SaveScreen();
  exit(-1);
}

extern char *lang_ext;

void parse_commandline(int argc,char *argv[])
{
  int i;
  char *tmp,*a="a";
  for (i=1;i<argc;i++)
  {
    if (argv[i][0] == '-')
    {
      switch (argv[i][1])
      {
        case 'L':
          i++;
          if (i == argc) usage();
          break;
        case 'h':
          usage();
        case 'd':
          if (!argv[i][2]) tmp = a;
          else tmp = &argv[i][2];
          while (*tmp)
          {
            switch (*tmp)
            {
              case 'd':
                debug_dependencies = 1;
                break;
              case 'a':
                debug_dependencies = 1;
                debug_commands = 1;
                debug_tempfiles = 1;
                break;
              case 'c':
                debug_commands = 1;
                break;
              case 't':
                debug_tempfiles = 1;
                break;
              default:
                usage();
            }
            tmp++;
          }
          break;
        default:
          usage();
      }
    }
    else
    {
      char *dir,*file,*ext;
      string_dup(PRJNAME,argv[i]);
      split_fname(PRJNAME,dir,file,ext);
      string_free(PRJNAME);
      if (*ext != 0)
      {
        string_dup(EDITNAME,argv[i]);
      }
      else
      {
        string_dup(PRJNAME,file);
        string_cat(PRJNAME,PROJECT_EXT);
      }
      string_free(dir);
      string_free(file);
      string_free(ext);
    }
  }
}

extern "C" char *ffname(struct ffblk *);

static void find_project()
{
  struct ffblk ff;
  int result;
  result = findfirst("*"PROJECT_EXT,&ff,FA_RDONLY | FA_ARCH);
  if (result != 0) return;
  string_dup(PRJNAME,ffname(&ff));
  if (findnext(&ff) != 0) return;
  string_free(PRJNAME);
  PRJNAME = NULL;
}

static char *tempdir;

static void set_tmpdir()
{
  char *tmpdir = getenv("TMPDIR");
  char temp_mask[9] = "RHXXXXXX";
  if (!tmpdir) tmpdir = getenv("TEMP");
  if (!tmpdir) tmpdir = getenv("TMP");
  if (!tmpdir) string_dup(tempdir,"./");
  else
  {
    string_dup(tempdir,tmpdir);
    BackslashToSlash(tempdir);
    if (tempdir[strlen(tempdir)-1] != '/') string_cat(tempdir,"/");
  }
  string_cat(tempdir,temp_mask);
  mktemp(tempdir);
  if (mkdir(tempdir,0666) != 0)
  {
    string_free(tempdir);
    string_dup(tempdir,temp_mask);
    mktemp(tempdir);
    mkdir(tempdir,0666);
  }
  string_dup(tmpdir,"TMPDIR=");
  string_cat(tmpdir,tempdir);
  putenv(tmpdir);
  if (debug_tempfiles)
  {
    fprintf(stderr,GT(UsingTempDir),tempdir);
  }
}

static void remove_tmpdir()
{
  if (!debug_tempfiles) rmdir(tempdir);
}

static void check_language()
{
  int i;
  for (i=1;i<global_argc;i++)
  {
    if (!strcmp(global_argv[i],"-L"))
    {
      i++;
      if (i<global_argc) string_dup(lang_ext,global_argv[i]);
      break;
    }
  }
}

char *RHIDE_DIR;
char *RHIDE_NAME;
char *RHIDE_EXT;

static void setup_argv0()
{
  char *tmp;
  string_dup(tmp,global_argv[0]);
  FExpand(tmp);
  split_fname(tmp,RHIDE_DIR,RHIDE_NAME,RHIDE_EXT);
}

static char startup_directory[256];

int main(int argc,char *argv[])
{
  fprintf(stdout,"This is %s. Copyright (c) 1996 by Robert Hhne\n",IDEVersion);
  fflush(stdout);
  fflush(stderr);
  SaveScreen();
  global_argc = argc;
  global_argv = argv;
  setup_argv0();
  check_language();
  if (InitResource() == False)
  {
    fprintf(stderr,"could not open resource file\n");
    SaveScreen();
    exit(-1);
  }
  parse_commandline(argc,argv);
  getcwd(startup_directory,sizeof(startup_directory-1));
  set_tmpdir();
  App = new IDE();
#ifndef INTERNAL_DEBUGGER
  TView::disableCommand(cmStep);
  TView::disableCommand(cmTrace);
  TView::disableCommand(cmReset);
  TView::disableCommand(cmGoto);
#endif
  TIDEFileEditor::formatline = SyntaxFormatLine;
#ifdef NO_BREAK
  _go32_want_ctrl_break(1);
  __djgpp_set_ctrl_c(0);
#endif
  if (!PRJNAME) find_project();
  if (OpenProject(PRJNAME) == True)
  {
    InitPipe();
    if (!PRJNAME)
    {
      if (!EDITNAME) About();
      if (EDITNAME) App->openEditor(EDITNAME,True);
    }
    App->run();
    CloseProject();
  }
  CloseResource();
  delete App;
  remove_tmpdir();
  chdir(startup_directory);
  return 0;
}

void IDE::fileOpen()
{
  ushort result;
  TFileDialog *dialog;
  dialog = new TFileDialog(Project.defaultprojectmask,GT(TitleFileOpen),
                           GT(LabelName),fdOpenButton,0);
  TProgram::deskTop->insert(dialog);
  dialog->setState(sfModal,True);
  result = dialog->execute();
  if( result != cmCancel )
  {
    char *fileName;
    string_free(Project.defaultprojectmask);
    string_dup(Project.defaultprojectmask,dialog->wildCard);
    string_dup(fileName,dialog->directory);
    string_cat(fileName,dialog->fileName->data);
    if (!_USE_LFN) string_down(fileName);
    TEditWindow *win = is_on_desktop(fileName);
    if (win != NULL) win->select();
    else openEditor(fileName,True);
    string_free(fileName);
  }
  TProgram::deskTop->remove(dialog);
  delete dialog;
}
