/* This file is part of RHIDE, Copyright (C) 1996 Robert Hhne */
#define Uses_TDepCollection
#define Uses_TDependency
#define Uses_TParamList
#define Uses_TStreamable

#include "IDEClass.h"
#include <string.h>

static ushort TDependency_Version = 2;
static ushort TDependency_Version_Read;

TStreamable *TDepCollection::build()
{
  return new TDepCollection( streamableInit );
}

void *TDepCollection::readItem(ipstream & is)
{
  TDependency *dep;
  is >> dep;
  return dep;
}

void TDepCollection::writeItem(void *data,opstream & os)
{
  os << (TDependency *)data;
}

void * TDepCollection::keyOf(void * item)
{
  return ((TDependency *)item)->source_name ?
    ((TDependency *)item)->source_name :
    ((TDependency *)item)->dest_name;
}

int TDepCollection::compare(void *key1,void *key2)
{
  int result;
  if (!key1) result = -1;
  else if (!key2) result = 1;
  else result = stricmp((char *)key1,(char *)key2);
  return result;
}

void TDepCollection::write(opstream & os)
{
  TCollection::write(os);
}

void *TDepCollection::read(ipstream & is)
{
  TCollection::read(is);
  duplicates = False;
  if (count > 0 && TDependency_Version_Read < 2)
  {
    void **olditems;
    int i,_count;
    olditems = new void *[count];
    memcpy(olditems,items,count*sizeof(void *)); 
    _count = count;
    removeAll();
    for (i=0;i<_count;i++) insert(olditems[i]);
    delete olditems;
  }
  return this;
}

TStreamable *TDependency::build()
{
  return new TDependency( streamableInit );
}

TDependency::TDependency()
{
  source_name = NULL;
  dest_name = NULL;
  dependencies = NULL;
  local_options = new TParamList(NULL);
  source_file_type = FILE_UNKNOWN;
  dest_file_type = FILE_UNKNOWN;
  compile_id = COMPILE_UNKNOWN;
}

void * TDependency::read(ipstream & is)
{
  ushort temp;
  char *localoptions;
  is >> TDependency_Version_Read;
  source_name = is.readString();
  dest_name = is.readString();
  is >> temp;
  source_file_type = (FILE_TYPE)temp;
  is >> temp;
  dest_file_type = (FILE_TYPE)temp;
  is >> temp;
  compile_id = (COMPILE_ID)temp;
  is >> dependencies;
  localoptions = is.readString();
  local_options = new TParamList(localoptions);
  if (localoptions != NULL) delete localoptions;
  return this;
}

void TDependency::write(opstream & os)
{
  ushort temp;
  char *localoptions;
  os << TDependency_Version;
  os.writeString(source_name);
  os.writeString(dest_name);
  temp = (ushort)source_file_type;
  os << temp;
  temp = (ushort)dest_file_type;
  os << temp;
  temp = (ushort)compile_id;
  os << temp;
  os << dependencies;
  local_options->ToString(localoptions);
  if (strlen(localoptions) == 0) os.writeString(NULL);
  else os.writeString(localoptions);
  delete localoptions;
}

