/* This file is part of RHIDE, Copyright (C) 1996 Robert Hhne */
#include <io.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <go32.h>

#define BUFSIZE _go32_info_block.size_of_transfer_buffer

static char *buffer;

int cp_files(char *name1,char *name2)
{
  int f1,f2;
  long r;
  f1 = open(name1, O_RDONLY|O_BINARY);
  if (f1<0) return (-2);
  f2 = open(name2, O_WRONLY|O_CREAT|O_TRUNC|O_BINARY, 0666);
  if (f2<0) return (-3);
  while ((r=read(f1,buffer,BUFSIZE)) > 0)
  {
    write(f2,buffer,r);
  }
  close(f1);
  close(f2);
  return 0;
}

int cp_to_dir(int argc,char *argv[])
{
  char *dist;
  char *sname;
  int i;
  for (i=1;i<argc-1;i++)
  {
    sname = strrchr(argv[i],'/');
    if (!sname) sname = strrchr(argv[i],'\\');
    if (!sname) sname = argv[i];
    else sname++;
    dist = (char *)malloc(strlen(argv[argc-1])+strlen(sname)+2);
    strcpy(dist,argv[argc-1]);
    strcat(dist,"/");
    strcat(dist,sname);
    cp_files(argv[i],dist);
    free(dist);
  }
  return 0;
}

int main(int argc,char *argv[])
{
  struct stat statbuf;
  buffer = (char *)malloc(BUFSIZE);
  if (argc<3) return (-1);
  if (argc>3) return cp_to_dir(argc,argv);
  if (stat(argv[2],&statbuf) != 0) return cp_files(argv[1],argv[2]);
  if (statbuf.st_mode & S_IFDIR) return cp_to_dir(argc,argv);
  return cp_files(argv[1],argv[2]);
}
