/* This file is part of RHIDE, Copyright (C) 1996 Robert Hhne */
#include <stdio.h>
#include <stdlib.h>
#include <dpmi.h>
#include <go32.h>
#include <dos.h>
#include <fcntl.h>
#include "IDE21.h"
#include <sys/farptr.h>
#include <sys/stat.h>

#ifdef DEBUG_PIPE
extern char BUFFER[];
extern int BUFPTR;
#endif

handle_func
	*handle_open=DummyHook,
	*handle_close=DummyHook,
	*handle_read=DummyHook,
	*handle_write=DummyHook,
	*handle_seek=DummyHook,
	*handle_ioctl=DummyHook;

__dpmi_raddr oldint21,newint21;
__dpmi_regs regs;
int is_set = 0;
int in_my_handler = 0;

#define stack_length 1024*16
char *stack;

extern "C" void _new_int21();

int ___new_int21()
{
  int retval = 0;
  if (in_my_handler > 0) return 0;
  in_my_handler = 1;
  switch (regs.h.ah)
  {
    case 0x44:
      retval = handle_ioctl(&regs);
      break;
    case 0x3d:
      retval = handle_open(&regs);
      break;
    case 0x3e:
      retval = handle_close(&regs);
      break;
    case 0x3f:
      retval = handle_read(&regs);
      break;
    case 0x40:
      retval = handle_write(&regs);
      break;
    case 0x41:
      retval = handle_seek(&regs);
      break;
    default:
      retval = 0;
      break;
  }
  in_my_handler = 0;
  return retval;
}

int DummyHook(__dpmi_regs *r)
{
#if 0
  return 0;
#else /* to suppres warning about unused r */
  return ((int)r - (int)r);
#endif
}

void __new_int21()
{
  asm("				
	.globl __new_int21
  __new_int21:
	pushw	%%ds
	pushw	%%es
	pushl	%%edi
	pushl	%%esi
	.word	0xb866
  __new_int21_ds:
	.word	0
	movw	%%ax,%%ds
	movw	%%ss,%%dx
	movl	%%esp,%%ecx
	movw	%%ax,%%ss
	movl	%0,%%esp
	addl	%1,%%esp
	pushl	%%edx
	pushl	%%ecx
      "
      :
      :
	"o" (stack) ,
	"i" (stack_length-4)
  );
  if (___new_int21() == 0)
  {
    asm("
	popl	%%ecx
	popl	%%edx
	movw	%%dx,%%ss
	movl	%%ecx,%%esp
	movw	%0,%%ax
	movw	%%ax,%1
	movw	%2,%%ax
	movw	%%ax,%3
	popl	%%esi
	popl	%%edi
	popw	%%es
	popw	%%ds
	iret
      "
      :
      :
	"m" (oldint21.segment) ,
	"m" (regs.x.cs) ,
	"m" (oldint21.offset16) ,
	"m" (regs.x.ip)
    );
  }
  else
  {
    asm("
	popl	%%ecx
	popl	%%edx
	movw	%%dx,%%ss
	movl	%%ecx,%%esp
	popl	%%esi
	popl	%%edi
	popw	%%es
	popw	%%ds
	cld
	lodsw
	.byte	0x26
	movw	%%ax,%0
	lodsw
	.byte	0x26
	movw	%%ax,%1
	lodsw
	.byte	0x26
	movw	%%ax,%2
	.byte	0x26
	addw	$6,%3
	iret
      "
      :
      :
	"m" (regs.x.ip) ,
	"m" (regs.x.cs) ,
	"m" (regs.x.flags) ,
	"m" (regs.x.sp)
    );
  }
}

void exit_func(void)
{
  if (!is_set) return;
  __dpmi_set_real_mode_interrupt_vector(0x21,&oldint21);
  __dpmi_free_real_mode_callback(&newint21);
  free(stack);
  is_set = 0;
}

void InitHook21()
{
  unsigned short ds;
  extern unsigned short _new_int21_ds;
  _go32_dpmi_lock_code(__new_int21,
                    (unsigned long)exit_func - (unsigned long)__new_int21);
  _go32_dpmi_lock_data(&oldint21,sizeof(oldint21));
  _go32_dpmi_lock_data(&regs,sizeof(regs));
  _go32_dpmi_lock_data(&in_my_handler,sizeof(in_my_handler));
  stack = (char *)malloc(stack_length);
  _go32_dpmi_lock_data(stack,stack_length);
  ds = _my_ds();
  asm("movw	%0,%1
      "
      :
      :
	"r" (ds) ,
	"m" (_new_int21_ds)
  );
  __dpmi_get_real_mode_interrupt_vector(0x21,&oldint21);
  __dpmi_allocate_real_mode_callback(_new_int21,&regs,&newint21);
  atexit(exit_func);
  in_my_handler = 0;
#ifdef DEBUG_PIPE
  BUFPTR = 0;
#endif
  __dpmi_set_real_mode_interrupt_vector(0x21,&newint21);
  is_set = 1;
}

void DoneHook21()
{
  exit_func();
#ifdef DEBUG_PIPE
  {
    FILE *f;
    char *name = tmpnam(NULL);
    fprintf(stdout,"%s\n",name);
    f = fopen(name,"wb");
    fwrite(BUFFER,1,BUFPTR,f);
    fclose(f);
  }
#endif
}

