/* This file is part of RHIDE, Copyright (C) 1996 Robert Hhne */
#define Uses_TOptions
#define Uses_TDirList
#define Uses_TParamList
#define Uses_TFlagCollection
#define Uses_TStreamable
#define Uses_TStringCollection

#include "IDEClass.h"

static ushort TOptions_Version = 3;

void * TOptions::read(ipstream & is)
{
  ushort version;
  is >> version;
  is >> include_path;
  is >> library_path;
  is >> libs;
  is >> user_libs;
  is >> debug_level;
  is >> link_opt;
  is >> comp_opt;
  is >> ObjDirs;
  is >> SrcDirs;
  is >> opt_flags;
  is >> warn_flags;
  is >> debug_flags;
  is >> cxx_flags;
  is >> c_flags;
  is >> ProgArgs;
  if (version < 2) reserved = NULL;
  else is >> reserved;
  if (version < 3) user_words = new TStringCollection(4,4);
  else is >> user_words;
  return this;
}

void TOptions::write(opstream & os)
{
  os << TOptions_Version;
  os << include_path;
  os << library_path;
  os << libs;
  os << user_libs;
  os << debug_level;
  os << link_opt;
  os << comp_opt;
  os << ObjDirs;
  os << SrcDirs;
  os << opt_flags;
  os << warn_flags;
  os << debug_flags;
  os << cxx_flags;
  os << c_flags;
  os << ProgArgs;
  os << reserved;
  os << user_words;
}

TOptions::TOptions()
{
  include_path = new TDirList();
  library_path = new TDirList();
  user_libs = new TDirList();
  libs = 0;
  debug_level = 0;
  link_opt = new TParamList();
  comp_opt = new TParamList();
  ObjDirs = new TDirList();
  SrcDirs = new TDirList();
  opt_flags = new TFlagCollection();
  warn_flags = new TFlagCollection();
  debug_flags = new TFlagCollection();
  cxx_flags = new TFlagCollection();
  c_flags = new TFlagCollection();
  ProgArgs = new TParamList();
  reserved = new TStringCollection(4,4);
  user_words = new TStringCollection(4,4);
}

TStreamable *TOptions::build()
{
  return new TOptions( streamableInit );
}

TOptions::~TOptions()
{
  if (include_path) delete include_path;
  if (library_path) delete library_path;
  if (user_libs) delete user_libs;
  if (link_opt) delete link_opt;
  if (comp_opt) delete comp_opt;
  if (ObjDirs) delete ObjDirs;
  if (SrcDirs) delete SrcDirs;
  if (opt_flags) delete opt_flags;
  if (warn_flags) delete warn_flags;
  if (debug_flags) delete warn_flags;
  if (cxx_flags) delete cxx_flags;
  if (c_flags) delete c_flags;
  if (ProgArgs) delete ProgArgs;
  if (reserved) delete reserved;
  if (user_words) delete user_words;
}

