/******************************************************************* CONFIG.H
 *                                                                          *
 *                     Configure Dialog definitions                         *
 *                                                                          *
 ****************************************************************************/

#ifndef CONFIG_H
#define CONFIG_H

#include "Profile.h"

enum {
   CORNER_BL,
   CORNER_BR,
   CORNER_TL,
   CORNER_TR
} ;

enum { 
   SHOWK_NEVER, 
   SHOWK_ABOVE512, 
   SHOWK_ALWAYS 
} ;

typedef struct {

  BOOL   HideControls ;
  BOOL   Float ;
  BOOL   Animate ;
  BOOL   ShowFileSystemNames ;
  BOOL   ShowDiskLabels ;
  BOOL   ShowSeconds ;
  USHORT ShowK ;
  ULONG  MonitorPriority ;
  ULONG  TimerInterval ;
  USHORT AnchorCorner ;

  USHORT ItemCount ;
  BOOL   ItemFlags [ ITEM_BASE_COUNT + MAX_DRIVES ] ;
  char   DefaultLabels [ ITEM_BASE_COUNT + MAX_DRIVES ] [ 80 ] ;
  char   CurrentLabels [ ITEM_BASE_COUNT + MAX_DRIVES ] [ 80 ] ;

  // State information.
  int    Ready ;
  int    MostRecentSelection ;

} CONFIG_PARMS, *PCONFIG_PARMS ;

extern FNWP ConfigureProcessor ;

#endif
