/* LiveWire/WPS Host Mode */
/**
 **
 ** LiveWire 2.1 Host Mode
 ** REXX procedures language version
 **
 ** You may modify this script file to meed your needs
 **
 **/

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/* Return to this point if carrier lost */
LostCarrier:
SetLW(TimeOut,60);
/*Trace I; */        /* Uncomment for debug tracing */

/** Current User Information **/
Name=""
Password=""
Address1=""
Address2=""
PhoneNumber=""

/** Host Mode Configuration Information **/
MessageDir=".\HSTMSGS"
FileDir=".\HSTFILES"
SysopPassword="PASSWORD"
MaxTime=60
LockPort=GetLW(LockedPort);
OldSpeed=GetLW(Speed);


/** Global Variables **/
LogonName=""
LogonPassword=""

   /* Check for LOCAL flag */
   if (Translate(Arg(1))=='LOCAL') then
      SetLW(LocalOnly, On);
   else
      SetLW(LocalOnly,Off);

   /* Main Host Loop */
   do forever
       LogLW("Host Mode Initiated");
       SetLW(FGColor,15);
       SetLW(BGColor,1);
       ClrScrLW();
       SetLW(Speed,OldSpeed);
       HangUpLW();
       SendLW("AT^M");

       DispLW("LiveWire Host / CTRL-BREAK to halt");
 
       if (stream("HOST.CFG",C,"query exists")="") then
           MakeConfig();
   
       if (stream("HOST.USR",C,"query exists")="") then
           MakeUserList();
 
       ReadConfigFile();
       SysMkDir(MessageDir);
       SysMkDir(FileDir);

       if (GetLW(LocalOnly)) then
         Logon();
       else do
          LogLW("Awaiting a caller");
          WaitForRing();
          if (DoConnect()) then
               Logon();
       end
    end
exit

WaitForRing:
     OldTimeOut=GetLW(TimeOut);
     SetLW(TimeOut,0);
     x=FindLW("RING");
     SetLW(TimeOut,OldTimeOut);
     return "";

DoConnect:
   /* Send ATA to answer modem */
   SendLW("ATA^M");

   /* First, see if we have a locked port */
   if LockPort then
   do
      /* LOCKED PORT, DO NOT CHANGE BPS RATE ON CONNECT */

      q=FindLW("CONNECT", "NO CARRIER");
      if (q=="CONNECT") then
         return 1;
      else
         return 0;
   end
   else
   do
      /* Non-Locked port, attempt to parse bps rate */
      q=FindLW("CONNECT^M", "CONNECT 1200", "CONNECT 2400",
                  ,"CONNECT 4800", "CONNECT 9600", "CONNECT 19200",
                  ,"CONNECT 38400", "CONNECT 14400", "NO CARRIER");

      if (q="CONNECT"||D2C(13)) then
         SetLW(Speed, 300);
      else
      if (q="CONNECT 1200") then
         SetLW(Speed, 1200);
      else
      if (q="CONNECT 2400") then
         SetLW(Speed, 2400);
      else
      if (q="CONNECT 4800") then
         SetLW(Speed, 4800);
      else
      if (q="CONNECT 9600") then
         SetLW(Speed, 19200);
      else
      if (q="CONNECT 38400") then
         SetLW(Speed, 38400);
      else
      if (q="CONNECT 14400") then
         SetLW(Speed, 14400);
      else
         return 0;

      return 1;
   end

Logon:
   /* First, make sure modem is clear before logon */
   DelayLW(500);
   FlushBufferLW();

   SetLW(EchoBack,On);
   DiseFile("WELCOME");

   LogonName="";

   /* Get users' name */
   Done=0;
   do until (Done)
      DiseLW("^M^JEnter your full name > ");
      LogonName=Translate(HostReadString("",40));
      if (LogonName = "") then Done=0;
          else Done=1;
   end /* do */

   /* Get user record from host user file */
   q=stream("HOST.USR",C,"open");
   Done=0;
   Name="";
   do until (Name=LogonName | Lines("HOST.USR")=0)
      Name=LineIn("HOST.USR");
      Password=LineIn("HOST.USR");
      Address1=LineIn("HOST.USR");
      Address2=LineIn("HOST.USR");
      PhoneNumber=LineIn("HOST.USR");
   end /* do */

   if (Name=LogonName) then do

      LogLW("User Called " Name);
      LogonPassword="";

      /* Verify caller's password */
      do until (LogonPassword=Password)
         DiseLW("^M^JEnter your password >");
         SetLW(EchoBack, 0);
         LogonPassword=Translate(HostReadString("", 40));
         SetLW(EchoBack, 1);
      end /* do */
   end  /* Do */
    else
   do
        /* If we could not find username, this must be a new user! */

        LogLW("New User Validated");
        Name=LogonName;
        DiseFile("NEWUSER");
        PhoneNumber="";
        Address1="";
        Address2="";
        DiseLW("^M^JPlease fill out the following information for our records^M^J");
        DiseLW("Phone Number      : ");
        PhoneNumber=HostReadString("",40);
        DiseLW("^M^JStreet Address    : ");
        Address1=HostReadString("",70);
        DiseLW("^M^JCity, State & ZIP : ");
        Address2=HostReadString("",70);
        DiseLW("^M^J^M^JYou must now enter a password for your account on this system.^M^J");
        DiseLW("If you do not wish to have a password, just press ENTER.^M^J");

        Retry="1";
        Password="2";
        do until (Retry=Password)
            DiseLW("^M^JPassword        : ");
            Password=Translate(HostReadString("",30));
            DiseLW("^M^JRe-enter your password for verification : ");
            Retry=Translate(HostReadString("",30));
        end /* do */

        DiseLW("^M^J^M^JThank you...");

        /* Write new user information to disk */
        q=LineOut("HOST.USR",Name);
        q=LineOut("HOST.USR",Password);
        q=LineOut("HOST.USR",Address1);
        q=LineOut("HOST.USR",Address2);
        q=LineOut("HOST.USR",PhoneNumber);
   end /* Do */

   /* Close user file */
   q=stream("HOST.USR","c","close");

   MainMenu:
   DoHangup=0;
   do until (DoHangup)
      Option=""
      DiseFile("MAINMENU");
      DiseLW("Select a function: ");
      Option=Translate(HostReadChar());
      DiseLW("^M^J");
      if Option="H" then DoHangup=1;
      if Option="F" then ShowFiles();
      if Option="U" then UploadFile();
      if Option="D" then DownloadFile();
      if Option="P" then PageSysop();
      if Option="R" then ReadMessages();
      if Option="S" then SendMessage();
      if Option="O" then OperatorFuncs();
   end;

   EndLogon:
   LogLW("User Hung Up Normally");
   DiseLW("^M^J^M^JThank you for calling... (click)^M^J^M^J");
   SetLW(EchoBack,Off);
   DelayLW(250);
   HangUpLW();
   SleepLW(1);
   FlushBufferLW();
   return "";

OperatorFuncs:
   OpPswd=""
   OpOption=""

   DiseLW("^M^J^M^JEnter system operator password: ");
   SetLW(EchoBack,Off);
   OpPswd=Translate(HostReadString("",40));
   SetLW(EchoBack,On);
   if OpPswd=SysopPassword then do
      LogLW("User Entered Sysop Operations");
      QuitSysop=0;
      do until (QuitSysop)
           DiseLW("^M^J^M^JSystem Operator Functions^M^J^M^J");
           DiseLW("^M^J1. Change Message Directory : " MessageDir);
           DiseLW("^M^J2. Change File Directory    : " FileDir);
           DiseLW("^M^J3. Locked Baud Rate (0=No)  : " LockPort);
           DiseLW("^M^J4. Change Sysop Password    : " SysopPassword);
           DiseLW("^M^JS  Save these options");
           DiseLW("^M^JQ  Quit without saving^M^J^M^J");
           DiseLW("Select option: ");
           OpOption=Translate(HostReadChar());
           DiseLW("^M^J");
           if OpOption="1" then OpGetMsgDir();
           if OpOption="2" then OpGetFileDir();
           if OpOption="3" then OpGetLockPort();
           if OpOption="4" then OpGetPassword();
           if OpOption="S" then OpSaveConfig();
           if OpOption="Q" then OPQuitConfig();
      end
   end
   return "";

   OpGetMsgDir:
   DiseLW("Edit message directory (DO NOT END WITH A BACKSLASH)^M^J");
   DiseLW("> ");
   MessageDir=HostReadString(MessageDir,70);
   return "";

   OpGetFileDir:
   DiseLW("Edit files directory (DO NOT END WITH A BACKSLASH)^M^J");
   DiseLW("> ");
   FileDir=HostReadString(FileDir,70);
   return "";

   OpGetLockPort:
   DiseLW("Edit locked baud rate (1=on 0=off)^M^J");
   DiseLW("> ");
   LockPort=GetLW(LockedPort);
   LockPort=HostReadString(LockPort,3);
   SetLW(LockedPort, LockPort);
   return "";

   OpGetPassword:
   DiseLW("Edit sysop password^M^J");
   DiseLW("> ");
   SysopPassword=Translate(HostReadString(SysopPassword,70));
   return "";

   OpSaveConfig:
   DiseLW("Saving...");
   MakeConfig();
   DiseLW("^M^J^M^J");
   QuitSysop=1;
   return "";

   OpQuitConfig:
   ReadConfigFile();
   DiseLW("^M^J^M^J");
   QuitSysop=1;
   return "";

SendMessage:
   MaxMessage=0
   ThisMessage=0
   MsgFileName=""
   MsgLine=""
   MsgOption=""

   LogLW("User began a message");

   if (stream(MessageDir||"\HOST.MSG",C,"query exists")\="") then do
      q=stream(MessageDir||"\HOST.MSG",C,"open");
      MaxMessage=LineIn(MessageDir||"\HOST.MSG");
      q=stream(MessageDir||"\HOST.MSG",C,"close");
   end  /* Do */

   MaxMessage=MaxMessage + 1;
   ThisMessage=MaxMessage;

   MsgFileName=MessageDir||"\MESSAGE."||ThisMessage;
   q=stream(MsgFileName, C, "open");
   DiseLW("^M^J^M^JEnter your message");
   DiseLW("^M^JEnd your message by placing a period (.) alone on the last line^M^J");
   DiseLW("----------------------------------------------------------------------------^M^J");
   q=LineOut(MsgFileName, "------------------------------");
   q=LineOut(MsgFileName, " Message #"||ThisMessage);
   q=LineOut(MsgFileName, " From    :"||Name);
   q=LineOut(MsgFileName, "------------------------------");
   q=LineOut(MsgFileName, "^M^J");

   FinishedMessage=0;
   LineNo=1;
   do until(FinishedMessage)
      DiseLW(LineNo||"> ");
      MsgLine=HostReadString("",75);
      DiseLW("^M^J");
      if (MsgLine=".") then FinishedMessage=1;
      q=LineOut(MsgFileName, MsgLine);
      LineNo=LineNo+1;
   end

   FinishedMessage=0;
   do until (FinishedMessage)
        DiseLW("^M^JMessage Ended^M^J");
        DiseLW("[S]ave Message  [A]bort Message : ");
        MsgOption=Translate(HostReadChar());
        DiseLW("^M^J");
        if MsgOption="S" then SaveMessage();
        if MsgOption="A" then AbortMessage();
   end /* do */

   return "";

   SaveMessage:
        FinishedMessage=1;
        q=LineOut(MsgFileName,"------------------------------");
        q=stream(MsgFileName,C,"close");
        "erase "||MessageDir||"\HOST.MSG"
        q=stream(MessageDir||"\HOST.MSG",C,"open write");
        q=LineOut(MessageDir||"\HOST.MSG", ThisMessage);
        q=stream(MessageDir||"\HOST.MSG",C,"close");
        return "";
        Goto RetSendMessage

    AbortMessage:
        FinishedMessage=1;
        "erase "||MsgFileName
        return "";

ReadMessages:
   MaxMessage=1
   ThisMessage=1
   MsgFileName=""
   MsgOption=""

   LogLW("User Read Messages");
   if (stream(MessageDir||"\HOST.MSG",C,"query exists")="") then do
      DiseLW("^M^JSorry, there are no messages.^M^J");
      SleepLW(2);
      return "";
   end  /* Do */

   q=stream(MessageDir||"\HOST.MSG",C,"open read");
   MaxMessage=LineIn(MessageDir||"\HOST.MSG");
   q=stream(MessageDIR||"\HOST.MSG",C,"close");

   DiseLW("^M^JMessages range from 1 to "||MaxMessage||"^M^J");
   DiseLW("Enter message to start reading at : ");
   ThisMessage=HostReadString(ThisMessage,3);
   DiseLW("^M^J");

   DoneReading=0;
   do until (DoneReading)
        MsgFileName=MessageDir||"\MESSAGE."||ThisMessage
        if (stream(MsgFileName,C,"query exists")\="") then do
           DiseFile(MsgFileName);
           DiseLW("^M^J[ENTER] for next message or [Q] to quit : ");
           MsgOption=HostReadChar();
           DiseLW("^M^J");
           if MsgOption="Q" then DoneReading=1;
        end  /* Do */

        ThisMessage=ThisMessage+1;
        if (ThisMessage>MaxMessage) then DoneReading=1;
    end;

    DiseLW("^M^JEnd of messages.^M^J");
    SleepLW(2);
    return "";

PageSysop:
    LogLW("User Attempted To Page Sysop");
    DiseLW("^M^JPaging operator, press Q to abort...^M^J");
    DispLW("SYSOP: Press 'C' to chat^M^J");

    StopPage=0;
    OldTimeOut=GetLW(TimeOut);
    SetLW(TimeOut,5);
    do until (StopPage)
        DispLW("");
        
        Key=Translate(HostReadChar());
        if Key="Q" then do
            SetLW(TimeOut,OldTimeOut);
            return "";
        end  /* Do */
        if Key="C" then StopPage=1;
    end

    SetLW(TimeOut,0);

    DiseLW("^M^J^M^J You are now in chat mode^M^J");
    DispLW(" SYSOP: Type ~ (tilde character) on a blank line to end chat mode");
    DispLW("^M^J^M^J");
    LogLW("Sysop Answered Chat Request");

    Key=""
    do until Key="~"
        Key=""
        DiseLW(" ");
        Key=HostReadString("",77);
        DiseLW("^M^J");
    end


    SetLW(TimeOut,OldTimeOut);
    return "";

UploadFile:
    ULProtocol=""
    ULFile=""
    ULFile2=""

    DiseFile("PROT");

    DiseLW("Select protocol: ");
    ULProtocol=Translate(HostReadChar());

    /* Check if this is a batch upload... */
    BatchUpload=0;
    if ULProtocol="Y" then BatchUpload=1;
    if ULProtocol="Z" then BatchUpload=1;

   /* Set download directory if this a a batch upload */
    if (BatchUpload) then do
       OldDLDir=GetLW(DLDir);
       SetLW(DLDir, FileDir);
    end
      else
    do
        DiseLW("^M^J^M^JName of file you are uploading: ");
        ULFile=HostReadString(ULFile,77);
        if ULFile="" then return "";
        ULFile2=FileDir||"\"||ULFile;
    end

    DiseLW("^M^JStart your upload now...^M^J");

    if (BatchUpload) then
        ReceiveFilesLW(ULProtocol, "");
    else
        ReceiveFilesLW(ULProtocol,ULFile2);

   /* Restore old download directory */
    if (BatchUpload) then
         SetLW(DLDir, OldDLDir);

    SleepLW(1);
    FlushBufferLW();

    return "";

DownloadFile:
   DLProtocol=""
   DLFile=""
   DLFile2=""

   DiseFile("PROT");
   DiseLW("Select protocol: ");
   DLProtocol=HostReadChar();
   DiseLW("^M^JName of file you are downloading: ");
   DLFile=HostReadString("",77);
   if DLFile\="" then do
      DiseLW("^M^J");
      DLFile2=FileDir||"\"||DLFile;
      if (stream(DLFile2,C,"query exists")="") then do
         DiseLW("^M^J^M^JThat file does not exist!^M^J");
         SleepLW(2);
      end  /* Do */
       else
      do
         DiseLW("Start download now...^M^J");
         SendFilesLW(DLProtocol,DLFile2);
         SleepLW(1);
         FlushBufferLW();
         LogLW("User downloaded file "||DLFile2);
      end
   end
   return "";

ShowFiles:
  "DIR "||FileDir||" >host.out"
  DiseLW("^M^J^M^J");
  DiseFile("HOST.OUT");
  DiseLW("^M^JPress [ENTER]");
  q=HostReadChar();
  return "";

DiseFile:
arg DispFile

    q=stream(DispFile,C,"open read");

    do until lines(DispFile) = 0
         DiseLW(linein(DispFile));
         DiseLW("^M^J");
    end /* do */

    q=stream(DispFile,C,"close");
    return "";

ReadConfigFile:
    LogLW("Read Configuration File");
    DispLW(" Reading configuration file...");
    q=stream("HOST.CFG",C,"open read");
    MessageDir=LineIn("HOST.CFG");
    FileDir=LineIn("HOST.CFG");
    SysopPassword=LineIn("HOST.CFG");
    MaxTime=LineIn("HOST.CFG");
    LockPort=LineIn("HOST.CFG");
    q=stream("HOST.CFG",C,"close");
    DispLW("OK^M^J");
    return "";

MakeConfig:
    LogLW("Created Configuration File");
    DispLW(" Creating configuration file...");
    "erase HOST.CFG"
    q=stream("HOST.CFG",C,"open write");
    q=LineOut("HOST.CFG", MessageDir);
    q=LineOut("HOST.CFG", FileDir);
    q=LineOut("HOST.CFG", SysopPassword);
    q=LineOut("HOST.CFG", MaxTime);
    q=LineOut("HOST.CFG", LockPort);
    q=stream("HOST.CFG",C,"close");
    DispLW("OK^M^J");
    Return "";

MakeUserList:
    LogLW("Created User File");
    DispLW(" Creating user list file...");
    q=stream("HOST.USR",C,"open write");
    q=stream("HOST.USR",C,"close");
    DispLW("OK^M^J");
    Return "";


HostReadChar:
   ReturnString=GetKeyLW();

   if (ReturnString="TIMEOUT") | ((GetLW(Online)==0) & (\GetLW(LocalOnly))) then
      Signal LostCarrier;

   return ReturnString;


HostReadString:
arg StartString, MaxStrLen

   ReturnString=GetStrLW(StartString, MaxStrLen);
   if (ReturnString="TIMEOUT") | ((GetLW(Online)=0) & (\GetLW(LocalOnly))) then
      Signal LostCarrier;

   return ReturnString;

