
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <string.h>
#include <dir.h>
#include <dos.h>

#include "allegro.h"
#include "midifile.h"
#include "ldat.h"
#include "help.h"


#define RND ((float)rand())/RAND_MAX
#define RANDOM(x) ((int)(RND*x))

#define TWOPI 2*PI
#define PROGRAMNAME "LMUSE"

#define DIVISION 96

#define CONNECTBG 125
#define BG1 13
#define DRAWBG 15
#define PLAYBG 5
#define TRACKBG 15
#define MUTATEDBG 2
#define HELPBG 8
/* views */
#define XY  0
#define ZY  1
#define ZX  2

DECLARE_COLOR_DEPTH_LIST(
            COLOR_DEPTH_8
        )


#define SCREENDUMPS
/*#define EXITONARITHERROR*/
char editor[120]="";


BITMAP *waitmouset,*waitmouseb,*waitmouseu,*waitmousep,*pointup;
BITMAP * lmtitle;
float dmultiplier=4.0;
#define PSPREADMAX 4.0
#define DSPREADMAX 8.0
#define VSPREADMAX 8.0
float pspread=1.0;
float dspread=1.0;
float vspread=1.0;

float deg2rad (float deg);
float getfloat ();
int interpret (int mode);
int getsetlimits();
void init_trackplay();
int savemidi();
char * changefileext(char * origfilename,char * newfilename, char * newext);
int popup_file_select(char *message, char *path, char *ext);

FILE *savemf_fp;
myputc(c) {return(putc(c,savemf_fp));}
char savemfname[120] = "";
char mutatefilename[120]="mutation.lm";
extern char productionmessage[];


extern char *production;
extern long maxstringlength;
extern char *rules[];
extern FILE *rulefilefp;
extern char axiom[];

int readconfigfile();
int writeconfigfile();

char *rulesstring=NULL;
char fileinfo[12][80];
char numrecursestring[8]="";
char deltaanglestring[80]="10.0";
int numrules;
int rstart,seed;
float deflscale;
int maxlevel;
float thick=10.0;
float deltaangledeg=10.0;
float deltaanglerad=10.0*PI/180.0;

float curdrawlength;

int maxcolor=255;
int numobjects;

int curchar;
float wtlx,wtly,wbrx,wbry;
float virxmult,virymult;

#define DRAWINGTOP 16
#define DRAWBORDERWIDE 5
int showproductions=0;
int originalmutated=0;
int unsavedrulechanges=0;
int dontdraw=0;
int factstacks=0;
int transposestack_p=0;

char productionfilename[120]="prod.out";
char productionname[80];

char rulefile[120]="";
char rulefilename[20]="";
char playrulefilename[20]="";

int division=DIVISION;
long mtempo;
long tempo=120;
int baset;

#if defined(SCREENDUMPS)
int dump_screen(){

       int dumpnumber=0;
          BITMAP *bmp;
          PALETTE pal;
          char filename[80];

          sprintf(filename,"scrdmp%d.pcx",dumpnumber);
          while (exists(filename)){
                dumpnumber++;
                sprintf(filename,"scrdmp%d.pcx",dumpnumber);
          }
          get_palette(pal);
          show_mouse(NULL);
          bmp = create_sub_bitmap(screen, 0, 0, SCREEN_W-1, SCREEN_H-1);

          save_bitmap(filename, bmp, pal);
          show_mouse(screen);
          destroy_bitmap(bmp);

          alert("Screen saved to",filename,"","OK",NULL,13,0);

          return D_O_K;
}
#endif

int makeseed(){
     struct time t;
     gettime(&t);
     return (t.ti_hund*t.ti_sec);
}
int lastseed;
void randomize (){

     lastseed=makeseed();
     srand (lastseed);

}
volatile long int_t1;
void t_int1(){
     int_t1++;

}
END_OF_FUNCTION (t_int1);

void timertempo(long tempo){
        mtempo=60000000/tempo;
        baset=division*tempo;
        if(install_int_ex(t_int1,BPM_TO_TIMER(baset))<0){
                printf("Error initializing timer (too many timers?)");
                exit(1);
        }
}

float dirmax=1.0;
float dirmin=-1.0;

float maxx=0,maxy=0,maxz=0,minx=0,miny=0,minz=0;
float fmaxx=0,fmaxy=0,fmaxz=0,fminx=0,fminy=0,fminz=0;
float umaxx=0,umaxy=0,umaxz=0,uminx=0,uminy=0,uminz=0;
float lmaxx=0,lmaxy=0,lmaxz=0,lminx=0,lminy=0,lminz=0;
float maxlength;
float minlength;
float maxdrawlength;
float mindrawlength;

float maxthickness;
float minthickness;


void debugnothing(){

        char * n="floooooooo";
}
typedef struct vector{
        float x;
        float y;
        float z;
} VECTOR;

VECTOR sky={0.0,1.0,0.0};

void cross (VECTOR *v , VECTOR *w, VECTOR *r);
void xrot (VECTOR *v , VECTOR *vn , float theta);
void yrot (VECTOR *v , VECTOR *vn , float theta);
void zrot (VECTOR *v , VECTOR *vn , float theta);
void rotate (VECTOR *t, VECTOR *v, VECTOR *r, float a);

typedef struct state{
        float deltaangle;
        float x,y,z;
        VECTOR fdirection;
        VECTOR udirection;
        VECTOR ldirection;
        float length;
        float thickness;
        int clr;
        int transpose;
        float dfact;
        float vfact;

        long cumtime;
        long prevcumtime;
        int track;
        int inpoly;
}STATE;


#define STACKDEPTH  2*1024
long timestack[STACKDEPTH];
int timestacktop=0;
void pushtime(long t){
     timestack[timestacktop]=t;

     timestacktop++;
}
long poptime(){

     if (timestacktop<1){


        return timestack[0];
     }
     return timestack[--timestacktop];

}

STATE statestack[STACKDEPTH];
int stacktop=0;

void pushstate(STATE s){


     statestack[stacktop]=s;

     stacktop++;
}
STATE popstate(){

     if (stacktop<1){


        return statestack[0];
     }
     return statestack[--stacktop];

}

STATE curstate;


#define NOTEOFF       0x80
#define NOTEON        0x90
#define KAFTERTOUCH   0xa0
#define CNTRL_CHG     0xb0
#define PRG_CHG       0xc0
#define CHAFTERTOUCH  0xd0
#define PITCHBEND     0xe0
#define SYSTEM        0xf0


#define NUM_CHANNELS 16
#define MAXTRACKS 16

void set_patch(int channel, int prog)
{
   unsigned char msg[2] = { PRG_CHG+channel, prog };
   midi_out(msg, 2);
}

void set_pan(int channel, int pan)
{
   unsigned char msg[3] = { CNTRL_CHG+channel, 10, pan };
   midi_out(msg, 3);
}

void send_note_on(int channel, int pitch, int vel)
{
   unsigned char msg[3] = { NOTEON+channel, pitch, vel };
   midi_out(msg, 3);
}

void send_note_off(int channel, int pitch)
{
   unsigned char msg[3] = { NOTEOFF+channel, pitch, 0 };
   midi_out(msg, 3);
}

void all_notes_off(int channel){
   unsigned char msg[3]={0xB0+channel,123,0};
   midi_out(msg,3);
}


typedef struct scale{
	int *s;
	int num;
}SCALE;
/* new scales need to be added here ...*/
int Twelvetone[13] = {0,1,2,3,4,5,6,7,8,9,10,11,12};
int Major[8] = {0,2,4,5,7,9,11,12};
int Penta1[6] = {0,4,7,9,10,12};
int minor[8]={0,2,3,5,7,8,11,12};
int blue1[9]={0,2,3,4,7,8,9,10,12};
int whole[7]={0,2,4,6,8,10,12};
int diminished[9]={0,1,3,4,6,7,9,10,12};

/*...here... */
SCALE scales[7]={
      {Twelvetone,12},{ Major ,7},{ Penta1 ,5},
      {minor,7},{blue1,8},{whole,6},{diminished,8}};
int numpredefinedscales=7;

/*... here ... */
char * scalenames[9]
={"twelve tone","Major","Penta 1","minor","blue 1","whole","diminshed","user's"};

/* ... here ... and to the list in lists.h*/
MENU scale_menu[] =
{
   { "&twelve tone",            NULL,           NULL },
   { "&Major",             NULL,            NULL },
   { "&Penta 1",              NULL,      NULL },
   { "m&inor",              NULL,          NULL },
   { "&blue 1",              NULL,          NULL },
   { "&whole",              NULL,          NULL },
   { "&diminished",              NULL,          NULL },
   { "&user's",              NULL,          NULL },
   { NULL,                          NULL,             NULL }
};

SCALE * cur_scale=&(scales[1]);
SCALE * def_scale=NULL;
SCALE * user_defined_scale=NULL;
int do_userscaledialog();
char scalenamestring[40];
char scalefnnamestring[40];

int do_scalemenu()
{
   int ret,menuret;


   menuret=do_menu (scale_menu,150,20);

   if(menuret>=0&&menuret<numpredefinedscales){
         cur_scale=&(scales[menuret]);
         strcpy(scalenamestring,scalenames[menuret]);
   }
   else if( menuret==numpredefinedscales){
        do_userscaledialog();
        if(user_defined_scale!=NULL){
           cur_scale=user_defined_scale;
           strcpy(scalenamestring,scalenames[menuret]);
        }
   }

   return D_O_K;
}
int scalemenu_proc(int msg, DIALOG*d, int c)
{
   int ret,menuret;
   ret=d_button_proc(msg,d,c);

   if(msg==MSG_CLICK){
       menuret=do_menu (scale_menu,d->x+30,d->y);

       if(menuret>=0&&menuret<numpredefinedscales){
           cur_scale=&(scales[menuret]);
           strcpy(scalenamestring,scalenames[menuret]);
       }

       else if( menuret==numpredefinedscales){
           do_userscaledialog();
           if(user_defined_scale!=NULL){
              cur_scale=user_defined_scale;
              strcpy(scalenamestring,scalenames[menuret]);
           }
       }


       d->flags &= ~D_SELECTED;
   }

   return ret;
}

int ignscale(), scalesteps(), slidetoscale(),constantscale();
int (*scalefunctions[4])(int,SCALE *)={slidetoscale,scalesteps,constantscale};
int (*scalefn)(int, SCALE*)=slidetoscale;
int (*defscalefn)(int, SCALE *)=slidetoscale;

char * scalefnnames[5]={"slide to","steps","constant"};


MENU scalefn_menu[] =
{
   { "&slide to",   NULL,  NULL },
   { "s&teps",      NULL,  NULL },
   {"&constant",    NULL,  NULL},
   { NULL,          NULL,  NULL }
};
int do_scalefnmenu()
{
   int ret,menuret;
   menuret=do_menu (scalefn_menu,150,20);

   if(menuret>=0){
         scalefn=scalefunctions[menuret];
         strcpy(scalefnnamestring,scalefnnames[menuret]);
   }
   return D_O_K;
}

int scalefnmenu_proc(int msg, DIALOG*d, int c)
{
   int ret,menuret;


   ret=d_button_proc(msg,d,c);
   if(msg==MSG_CLICK){
        menuret=do_menu (scalefn_menu,d->x+30,d->y);

        if(menuret>=0){
          scalefn=scalefunctions[menuret];
          strcpy(scalefnnamestring,scalefnnames[menuret]);
        }
        d->flags&=~D_SELECTED;
   }
   return ret;
}

int ignscale(int pitch,SCALE *S)
{
	return (pitch&0x7f);
}

int constantscale(int pitch,SCALE *S)
{
        return 0;
}

int scalesteps(int pitch,SCALE *S)
/*finds the pth member of the scale*/
{
	int oct,deg,degm,n=S->num;
        int cnt=0;
	int *sc = S->s;
        int per=sc[n];
        while(pitch<0){
             cnt++;
             pitch+=n;
        }
	oct = (pitch)/(n);
	deg = (pitch)%(n);
	/*degm= deg/(n);
	deg = deg%(n);*/
        return ( (sc[deg]+(oct-cnt)*(per)) & 0x7f);
}

int slidetoscale(int pitch,SCALE *S)
/*returns first scale note higher or equal to given pitch*/
{
        int i=0,per,oct,origdeg;
        int cnt=0;
	int * sc = S->s;
	per     = sc[S->num];
        while (pitch<0){
              cnt++;
              pitch+=per;
        }
        oct     = pitch/per;
        origdeg = pitch%per;
	while(sc[i]<origdeg) i++;
	return((sc[i]+(oct-cnt)*per)&0x7f);

}
char scalestring[60]="";

void scale2scalestring(SCALE* scale){
        int i;
        char *c=scalestring;
        int *scalenotes;
        int numnotes;
        char buf[5];

        scalenotes=scale->s;
        numnotes=scale->num;
        *c='\0';
        for(i=0;i<numnotes;i++){
              itoa(scalenotes[i]+1,buf,10);
              strcat(scalestring,buf);
              strcat(scalestring, " ");
        }

}
SCALE * string2scale(char * str){

  int numsteps=0,i;
  int tempscale[50];
  int *scalenotes;
  int step=0;
  SCALE * newscale;
  char buf[60];
  char *tok;

  if(*str=='\0') return NULL;
  newscale= (SCALE *)malloc(sizeof(SCALE));
  if(newscale==NULL) return NULL;
  strcpy(buf,str);
  tok=strtok(buf," ,");
  if(tok!=NULL)
        step=atoi(tok);
  if (step>0){
     tempscale[numsteps]=step-1;
     numsteps++;
  }

  while (tok!=NULL){
            tok=strtok(NULL, " ,");
            if(tok!=NULL){
               step=atoi(tok);
               if (step>0){
                  tempscale[numsteps]=step-1;
                  numsteps++;
               }
            }
  }

  if (numsteps <=0) {
     if(newscale!=NULL)
          free(newscale);
     return NULL;
  }
  else{
     scalenotes=(int*)malloc(sizeof(int)*numsteps+1);
     if(scalenotes==NULL){
        if (newscale!=NULL)
            free(newscale);

        free(scalenotes);
        return NULL;
     }
     for(i=0;i<numsteps;i++)
           scalenotes[i]=tempscale[i];
     scalenotes[numsteps]=scalenotes[0]+12*(1+ (int)(tempscale[numsteps-1]/12));
     newscale->s=scalenotes;
     newscale->num=numsteps;
  }
  return newscale;
}


DIALOG userscale_dialog[]={

   {d_box_proc,      0,   0,    500,  55,   255,  0,       0,   0,      0,   0,   NULL},


   {d_text_proc,     10,  5,    0,    0,    255,  0,       0,   0,      0,   0,   "define a scale:"},
   {d_box_proc,      5,   15,   490,  18,   255,  0,       0,   0,      0,   0,   NULL},
   {d_edit_proc,     10,  20,   480,  10,   255,  2,       0 ,  0,      60,  0,   scalestring},

   { d_button_proc,  10,  36,   30,   16,   255,  0,       13,  D_EXIT, 0,   0,    "OK" },
   { NULL,           0,   0,    0,    0,    0,    0,       0,   0,      0,   0,    NULL }
};

int do_userscaledialog(){
     int ret;
     centre_dialog(userscale_dialog);
     ret=popup_dialog(userscale_dialog,2);
     user_defined_scale=string2scale(scalestring);
     if(user_defined_scale !=NULL)
         scale2scalestring(user_defined_scale);
     return D_O_K;
}



typedef struct midi_chan_event{
     unsigned long t;
     unsigned char status;
     unsigned char data1;
     unsigned char data2;
}MIDICHANEVENT;

typedef struct midi_note_list{
     struct midi_chan_event m;
     struct midi_note_list  * next;
     struct midi_note_list  * prev;
}MIDINOTELIST;
MIDINOTELIST * tracklist[MAXTRACKS];
MIDINOTELIST * tracklastnode[MAXTRACKS];
MIDINOTELIST * tracknextnode[MAXTRACKS];
MIDINOTELIST *next_node;
int maxactivetracks=0;
int next_track;
long trackcumtime[MAXTRACKS]={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
long trackprevcumtime[MAXTRACKS]={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
unsigned char trackflags[MAXTRACKS]={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
#define ACTIVE 1
unsigned char trackchannel[MAXTRACKS]={0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15};
long next_event_time;
long maxcumtime;

MIDINOTELIST *
makenewnode()
{
     MIDINOTELIST * mlist= (MIDINOTELIST *)malloc(sizeof(MIDINOTELIST));
     if (mlist==NULL){
        printf("midinotelist allocation error");
        exit(1);
     }
     mlist->next=NULL;
     mlist->prev=NULL;

     return mlist;
}

MIDINOTELIST *
findlast(L) MIDINOTELIST * L;
{
	MIDINOTELIST * this_node;
	this_node=L;
        if(this_node==NULL) return (this_node);
	while(this_node->next != NULL)
		this_node=this_node->next;
	
	return (this_node);
}

MIDINOTELIST *
findtime(L, tm) MIDINOTELIST * L; long tm;
{
/*supposed to return the last node whose time is less than or equal to tm*/
	MIDINOTELIST * this_node;
	long accumtime=0L;

	this_node=L;
	while(this_node != NULL){
		accumtime += this_node->m.t;
		if(this_node->next != NULL){

			if(accumtime+(this_node->next->m.t)>tm)
				return (this_node);
			this_node=this_node->next;
		}
		else return (this_node);
	}
        return NULL;
}

MIDINOTELIST * 
appendnewnode(last_node) MIDINOTELIST * last_node;
{  
        MIDINOTELIST * this_node;
        this_node = makenewnode();

        this_node->prev  = last_node;

	if(last_node != NULL)
        	(last_node)->next  = this_node;

        return (this_node);
}

void insertnode(afterme, newL)  MIDINOTELIST * afterme, * newL;
{
	MIDINOTELIST * oldnxt;
	if(afterme !=NULL){
		oldnxt = afterme->next;
		afterme->next = newL;
	}
	else	oldnxt=NULL;
	newL->next = oldnxt;
	newL->prev = afterme;
	if(oldnxt !=NULL)
		oldnxt->prev = newL;
}

MIDINOTELIST *insertattime(MIDINOTELIST * *L,MIDINOTELIST *newL,long attime, int priority){

        MIDINOTELIST * afterme;
        MIDINOTELIST * beforeme;
        MIDINOTELIST * this_node;
	long accumtime=0L;

	this_node=*L;
        if(this_node->m.t<attime || this_node->m.t==attime && priority <1){
	    while(this_node != NULL){
		accumtime += this_node->m.t;
                if(accumtime==attime && priority==1){
                          newL->next=this_node;
                          newL->prev=this_node->prev;
                          if(this_node->prev)
                               (this_node->prev)->next=newL;
                          this_node->prev=newL;
                          newL->m.t=this_node->m.t;
                          this_node->m.t=0;
                          return newL;
                }
		if(this_node->next != NULL){


			if(accumtime+(this_node->next->m.t)>attime)
				break;
			this_node=this_node->next;
		}
		else break;
	     }
        }
        else{  /* attime goes at beginning of list */
             *L=newL;
             newL->next=this_node;
             newL->prev=NULL;
             newL->m.t=attime;
             this_node->m.t -= attime;
             this_node->prev=newL;
             return newL;
        }
        afterme=this_node;
        beforeme=this_node->next;
        newL->m.t = attime-accumtime;
        if(beforeme!=NULL){ /*attime is before the end of the list*/
             beforeme->m.t -= newL->m.t;
             beforeme->prev=newL;
        }
        newL->prev=afterme;
        newL->next=beforeme;
        afterme->next=newL;


        return(newL);
}

MIDINOTELIST *insertlistattime(MIDINOTELIST * *L,MIDINOTELIST *newL,long attime){

        MIDINOTELIST * afterme;
        MIDINOTELIST * beforeme;
        MIDINOTELIST * this_node;
        MIDINOTELIST * end_node;
	long accumtime=0L;
        /*first find the end node of the list to be added*/
        this_node=newL;
        end_node=newL;
        while(this_node->next !=NULL){
             end_node=this_node->next;
             this_node=end_node;
        }


	this_node=*L;
        if(this_node->m.t<attime){
	    while(this_node != NULL){
		accumtime += this_node->m.t;
                if(this_node->next != NULL){


			if(accumtime+(this_node->next->m.t)>attime)
				break;
			this_node=this_node->next;
		}
		else break;
	     }
        }
        else{  /* attime goes at beginning of list */
             *L=newL;
             end_node->next=this_node;
             newL->prev=NULL;
             newL->m.t=attime;
             this_node->m.t -= attime;
             this_node->prev=end_node;
             return newL;
        }
        afterme=this_node;
        beforeme=this_node->next;
        newL->m.t = attime-accumtime;
        if(beforeme!=NULL){ /*attime is before the end of the list*/
             beforeme->m.t -= newL->m.t;
             beforeme->prev=end_node;
        }
        newL->prev=afterme;
        end_node->next=beforeme;
        afterme->next=newL;


        return(newL);
}

/*this only works if the list has an end!*/
void free_midi_note_list( M ) MIDINOTELIST  * M;
{
     MIDINOTELIST * current_element = M;
     MIDINOTELIST * next_element;
     if(M != NULL && M->prev != NULL) (M->prev)->next=NULL;     
     while(current_element != NULL){
          next_element = current_element->next;
          free(current_element);
          current_element = next_element;
     }
     
}
/*use this for looping list*/
void freelooptracklist( MIDINOTELIST * T )
{
     MIDINOTELIST * current_element=T;
     MIDINOTELIST * first_element=T;
     MIDINOTELIST * next_element;
     if (T==NULL) return;
     if(T->prev != NULL) (T->prev)->next=NULL;
     next_element=current_element->next;
     free(current_element);
     current_element=next_element;

     while(current_element!=first_element && current_element != NULL){
          next_element = current_element->next;
          free(current_element);
          current_element = next_element;
     }
     
}


float zerolength=0.0;

#define COORDINATE 1
#define DIRECTION 2
#define LENGTH 3
typedef struct variable{
  float *v;
  int variabletype;
  float *mymin,*mymax;
}VARIABLE;

#define NUMSTATEVARS 15
VARIABLE statevariablearray[NUMSTATEVARS]= {
         {&(curstate.x),COORDINATE,&minx,&maxx},
         {&(curstate.y),COORDINATE,&miny,&maxy},
         {&(curstate.z),COORDINATE,&minz,&maxz},
         {&(curstate.fdirection.x),DIRECTION,&fminx,&fmaxx},
         {&(curstate.fdirection.y),DIRECTION,&fminy,&fmaxy},
         {&(curstate.fdirection.z),DIRECTION,&fminz,&fmaxz},
         {&(curstate.udirection.x),DIRECTION,&uminx,&umaxx},
         {&(curstate.udirection.y),DIRECTION,&uminy,&umaxy},
         {&(curstate.udirection.z),DIRECTION,&uminz,&umaxz},
         {&(curstate.ldirection.x),DIRECTION,&lminx,&lmaxx},
         {&(curstate.ldirection.y),DIRECTION,&lminy,&lmaxy},
         {&(curstate.ldirection.z),DIRECTION,&lminz,&lmaxz},
         {&(curstate.length),LENGTH,&minlength,&maxlength},
         {&(curdrawlength),LENGTH,&mindrawlength,&maxdrawlength},
         {&(curstate.thickness),LENGTH,&minthickness,&maxthickness}

};

float fzero=0.0;
VARIABLE constantvar={&fzero,0,0,0};

VARIABLE pitchvariable;
VARIABLE durationvariable;
VARIABLE velocityvariable;
int vw; /* view */
int d_connect_l_proc(int msg,DIALOG *d, int c);
int d_connect_r_proc(int msg,DIALOG *d, int c);
int d_connect_box_proc(int msg,DIALOG *d,int c);
int dumblit_proc(int msg,DIALOG *d,int c);
int connect_helpbutton_proc(int msg,DIALOG *d, int c);

#define CONNECT_W 320
#define CONNECT_H 260

#define PCOLOR 1
#define DCOLOR 12
#define VCOLOR 10
char dmultbuf[10];
char pspreadbuf[10];
char dspreadbuf[10];
char vspreadbuf[10];
int setdmult(void *dp3, int d2);
int setpspread(void *dp3, int d2);
int setdspread(void *dp3, int d2);
int setvspread(void *dp3, int d2);
int seelimits_proc(int msg, DIALOG *d, int c);
/*   (dialog proc)           (x)   (y)   (w)   (h)       (fg)  (bg)    (key) (flags)  (d1) (d2)   (dp) */
DIALOG connect_dialog[] =
{
   { d_box_proc,              0,0,CONNECT_W,CONNECT_H+140,255,  0,       0,    0,      0,   0,    NULL},
   { d_connect_box_proc,      0,0,CONNECT_W,CONNECT_H,    255,CONNECTBG, 0,    0,      0,   0,    NULL},

   { d_connect_l_proc,        20,   20,   70,    10,      255,  0,       0,    0,      -1,PCOLOR, "pitch"},
   { d_connect_l_proc,        20,   100,   70,    10,      255,  0,       0,    0,      -1,DCOLOR, "duration"},
   { d_connect_l_proc,        20,   180,  70,    10,      255,  0,       0,    0,      -1,VCOLOR, "volume"},

   { d_connect_r_proc,        200,  20,   100,   10,      255,  0,       0,    0,      0,   0,    "x"},
   { d_connect_r_proc,        200,  35,   100,   10,      255,  0,       0,    0,      0,   0,    "y"},
   { d_connect_r_proc,        200,  50,   100,   10,      255,  0,       0,    0,      0,   0,    "z"},
   { d_connect_r_proc,        200,  65,   100,   10,      255,  0,       0,    0,      0,   0,    "forward x"},
   { d_connect_r_proc,        200,  80,   100,   10,      255,  0,       0,    0,      0,   0,    "forward y"},
   { d_connect_r_proc,        200,  95,   100,   10,      255,  0,       0,    0,      0,   0,    "forward z"},
   { d_connect_r_proc,        200,  110,  100,   10,      255,  0,       0,    0,      0,   0,    "up x"},
   { d_connect_r_proc,        200,  125,  100,   10,      255,  0,       0,    0,      0,   0,    "up y"},
   { d_connect_r_proc,        200,  140,  100,   10,      255,  0,       0,    0,      0,   0,    "up z"},

   { d_connect_r_proc,        200,  155,  100,   10,      255,  0,       0,    0,      0,   0,    "left x"},
   { d_connect_r_proc,        200,  170,  100,   10,      255,  0,       0,    0,      0,   0,    "left y"},
   { d_connect_r_proc,        200,  185,  100,   10,      255,  0,       0,    0,      0,   0,    "left z"},
   
   { d_connect_r_proc,        200,  200,  100,   10,      255,  0,       0,    0,      0,   0,    "state length"},
   { d_connect_r_proc,        200,  215,  100,   10,      255,  0,       0,    0,      0,   0,    "draw length"},
   { d_connect_r_proc,        200,  230,  100,   10,      255,  0,       0,    0,      0,   0,    "thickness"},

   { d_text_proc,             10,CONNECT_H+10,0, 0,       255,  0,       0,    0,      0,   0,    "view:"},
   { d_radio_proc,            20,CONNECT_H+20,80,10,      255,  0,       0,    0,      0,   0,    "XY plane"},
   { d_radio_proc,            20,CONNECT_H+30,80,10,      255,  0,       0,    0,      0,   0,    "ZY plane"},
   { d_radio_proc,            20,CONNECT_H+40,80,10,      255,  0,       0,    0,      0,   0,    "ZX plane"},

   { d_text_proc,             160,CONNECT_H+10,0,0,       255,  0,       0,    0,      0,   0,    "Scale:" },
   { scalemenu_proc,          210,CONNECT_H+10,100,10,    255,  0,       0,    0,      0,   0,    scalenamestring},
   { scalefnmenu_proc,        210,CONNECT_H+24,100,10,    255,  0,       0,    0,      0,   0,    scalefnnamestring},

   { d_text_proc,             150,5,           0,  0,     255, CONNECTBG,0,    0,      0,   0,    "Map"},
   { dumblit_proc,            10, 10,          0,  0,CONNECTBG,CONNECTBG,0,    0,      0,   0,    NULL },

   { d_check_proc,            10, CONNECT_H+60,60,10,     255,  0,      'd',D_SELECTED,0,   0,    "Draw?"},

   { d_text_proc,             160,CONNECT_H+44, 0,0,      255,  0,       0,    0,      0,   0,    "multiply durations:" },
   { d_slider_proc,           210,CONNECT_H+54,100,10,    255,  0,       0,    0,      400, 0,    NULL,     setdmult},
   { d_text_proc,             280,CONNECT_H+66,20, 10,    255,  0,       0,    0,      0,   0,    dmultbuf },

   /*spreads*/
   { d_text_proc,             20,37, 0,0,                 255,  CONNECTBG,       0,    0,      0,   0,    "spread:" },
   { d_slider_proc,           20,50,80,10,                255,  CONNECTBG,       0,    0,      70, 0,    NULL,     setpspread},
   { d_text_proc,             50,62,40, 10,               255,  CONNECTBG,       0,    0,      0,   0,    pspreadbuf },

   { d_text_proc,             20,117, 0,0,                255,  CONNECTBG,       0,    0,      0,   0,    "spread:" },
   { d_slider_proc,           20,130,80,10,               255,  CONNECTBG,       0,    0,      70, 0,    NULL,     setdspread},
   { d_text_proc,             50,142,40, 10,              255,  CONNECTBG,       0,    0,      0,   0,    dspreadbuf },

   { d_text_proc,             20,197, 0,0,                255,  CONNECTBG,       0,    0,      0,   0,    "spread:" },
   { d_slider_proc,           20,210,80,10,               255,  CONNECTBG,       0,    0,      70, 0,    NULL,     setvspread},
   { d_text_proc,             50,222,40, 10,              255,  CONNECTBG,       0,    0,      0,   0,    vspreadbuf },

   { seelimits_proc, CONNECT_W/2-45,CONNECT_H-12,90,12,    255,  0,       0, D_EXIT,  0,   0,    "see limits" },

   { d_text_proc,             10,CONNECT_H+80, 0,  0,     255,  0,       0,    0,      0,   0,    "angle:"},
   { d_edit_proc,             60,CONNECT_H+80, 60, 16,    255,  8,       0 ,   0,      6,   0,    deltaanglestring},

   { d_check_proc,            128,CONNECT_H+84,180,10,     255,  0,       't',    0,      0,   0,    "Use &Transpose stack?"},
   { d_check_proc,            160,CONNECT_H+96,130,10,     255,  0,       'f',    0,      0,   0,    "&Factor stacks?"},

   { d_button_proc,           100,CONNECT_H+120,30,16,    255,  0,       13,D_EXIT,    0,   0,    "OK" },
   { d_button_proc,           150,CONNECT_H+120,60,16,    255,  0,       27,D_EXIT,    0,   0,    "CANCEL" },
   { connect_helpbutton_proc, 270,CONNECT_H+120,40,16,    255,  0,      'h',D_EXIT,    0,   0,    "&Help" },
#if defined (SCREENDUMPS)
   /*{d_keyboard_proc,          0,    0,          0, 0,     0,    0,   'd'-'a'+1,   0,       0,   0,    dump_screen},*/
#endif

   { NULL,                    0,   0,           0, 0,     0,    0,       0,    0,      0,   0,    NULL }
};
#define CONNECTBOX 1
#define NUMLCONNECT 3
#define LCONNECT1 2
#define RCONNECT1 LCONNECT1+NUMLCONNECT
#define NUMRCONNECT 15
#define CONNECTVIEWRADIO1 21
#define SCALEBUTTON 25
#define SCALEFNBUTTON 26
#define CONNECTDRAWCHECK 29
#define DMULTSLIDER 31
#define DMULTTEXT 32
#define TRANSPOSESTACKCHECK 45
#define FACTORSTACKSCHECK 46

#define CONNECTCANCEL 48

#define PSPREADSLIDER 34
#define PSPREADTEXT   35
#define DSPREADSLIDER 37
#define DSPREADTEXT   38
#define VSPREADSLIDER 40
#define VSPREADTEXT   41

int connect_helpbutton_proc(int msg,DIALOG *d, int c){

        int ret=d_button_proc(msg, d, c);

        if(ret==D_CLOSE){
           ret=maphelp();

           return ret;
        }
        return(ret);
}
int draw_p=1;
BITMAP *connect_bmp;
int d_connect_box_proc(int msg,DIALOG *d, int c){
    int ret;
    int i;
    ret=d_box_proc(msg,d,c);
    if(msg==MSG_START){
         connect_bmp= create_bitmap(d->w,d->h);
         clear(connect_bmp);
    }
    else if(msg==MSG_END){
         destroy_bitmap(connect_bmp);
    }

    return ret;
}
int dumblit_proc(int msg,DIALOG *d,int c){
 int ret;
 if(msg==MSG_DRAW){
              /*show_mouse(NULL);*/
              blit(screen,connect_bmp,0,0,0,0,CONNECT_W,CONNECT_H);
              /*show_mouse(screen);*/
 }
 ret=d_box_proc(msg,d,c);
 return(ret);
}

void circlelineproc(BITMAP * bmp,int x, int y,int c){
             circlefill(bmp,x,y,1,c);
}
int d_connect_l_proc(int msg,DIALOG *d, int c){
    int ret;
    int i;
    int mx=mouse_x,my=mouse_y;
    int omx=mx,omy=my;
    int tlx=connect_dialog[0].x;
    int tly=connect_dialog[0].y;
    DIALOG * endb;

    if(msg==MSG_CLICK){

              broadcast_dialog_message(MSG_DRAW,0);
              show_mouse(NULL);
              blit(screen,connect_bmp,tlx,tly,0,0,CONNECT_W,CONNECT_H);
              show_mouse(screen);
              while(mouse_b&1){
                  mx=mouse_x;my=mouse_y;
                  if((omx!=mx || omy!=my) ){
                       show_mouse(NULL);
                       blit(connect_bmp,screen,0,0,tlx,tly,CONNECT_W,CONNECT_H);
                       if(mx<tlx+CONNECT_W-1 && my<tly+CONNECT_H-1 && mx>d->x+d->w && my>tly){
                          /*line(screen,d->x+d->w,d->y,mx,my,d->d2);*/
                          do_line(screen,d->x+d->w,d->y+1,mx,my+1,d->d2,circlelineproc);
                       }
                       show_mouse(screen);
                  }
                  omx=mx;omy=my;

              }

              for(i=0;i<NUMRCONNECT;i++){
                       endb=&connect_dialog[RCONNECT1+i];
                       if(mx>endb->x && mx<endb->x+endb->w && my>endb->y&&my<endb->y+endb->h)
                            break;
              }

              if(i<NUMRCONNECT){
                     d->d1=i;

              }
              else {
                 d->d1=-1;
              }
              d->flags &= ~D_SELECTED;
              broadcast_dialog_message(MSG_DRAW,0);
 
    }
    else if(msg==MSG_DRAW&& d->d1>=0){
          /*line(screen,d->x+d->w,d->y,connect_dialog[RCONNECT1+d->d1].x,connect_dialog[RCONNECT1+d->d1].y,d->d2);*/
          do_line(screen,d->x+d->w,d->y+1,connect_dialog[RCONNECT1+d->d1].x,connect_dialog[RCONNECT1+d->d1].y+1,d->d2,circlelineproc);
    }

    ret=d_button_proc(msg,d,c);
    return ret;
}

int d_connect_r_proc(int msg,DIALOG *d, int c){

    int ret2=d_button_proc(msg,d,c);
    d->flags&=~D_SELECTED;
    return ret2;
}
#define PITCH    0
#define DURATION 1
#define VOLUME 2

char mapbuf[NUMLCONNECT][80];
int  do_connect_dialog(){
   int i,j;

   DIALOG *d;
   int ret=0;

   if(draw_p)
        connect_dialog[CONNECTDRAWCHECK].flags |= D_SELECTED;
   else
        connect_dialog[CONNECTDRAWCHECK].flags &= ~D_SELECTED;
   connect_dialog[CONNECTVIEWRADIO1+vw].flags |= D_SELECTED;
   for(i=0;i<NUMSTATEVARS;i++){
            if(pitchvariable.v==statevariablearray[i].v)
                       connect_dialog[LCONNECT1+PITCH].d1=i;
            if(durationvariable.v==statevariablearray[i].v)
                       connect_dialog[LCONNECT1+DURATION].d1=i;
            if(velocityvariable.v==statevariablearray[i].v)
                       connect_dialog[LCONNECT1+VOLUME].d1=i;

   }
   connect_dialog[DMULTSLIDER].d2=(int)(dmultiplier/4.0*100);
   sprintf(connect_dialog[DMULTTEXT].dp,"%1.2f",dmultiplier/4.0);
   /*connect_dialog[PSPREADSLIDER].d2=(int)(pspread/PSPREADMAX*70);*/
   connect_dialog[PSPREADSLIDER].d2=(int)((pspread+PSPREADMAX)/(2*PSPREADMAX)*70);
   sprintf(connect_dialog[PSPREADTEXT].dp,"%1.2f",pspread);
   /*connect_dialog[DSPREADSLIDER].d2=(int)(dspread/DSPREADMAX*70); */
   connect_dialog[DSPREADSLIDER].d2=(int)((dspread+DSPREADMAX)/(2*DSPREADMAX)*70);
   sprintf(connect_dialog[DSPREADTEXT].dp,"%1.2f",dspread);
   /*connect_dialog[VSPREADSLIDER].d2=(int)(vspread/VSPREADMAX*70);*/
   connect_dialog[VSPREADSLIDER].d2=(int)((vspread+VSPREADMAX)/(2*VSPREADMAX)*70);
   sprintf(connect_dialog[VSPREADTEXT].dp,"%1.2f",vspread);
   

   sprintf(deltaanglestring,"%3.2f",deltaangledeg);

   centre_dialog(connect_dialog);
   ret=popup_dialog(connect_dialog,0);

   if(ret==CONNECTCANCEL||ret==-1){
           for(i=0;i<3;i++){
               connect_dialog[CONNECTVIEWRADIO1+i].flags &= ~D_SELECTED;
           }

           return ret;
   }
   if(connect_dialog[CONNECTDRAWCHECK].flags&D_SELECTED)
         draw_p=1;
   else draw_p=0;
   if(connect_dialog[TRANSPOSESTACKCHECK].flags&D_SELECTED)
         transposestack_p=1;
   else transposestack_p=0;

   if(connect_dialog[FACTORSTACKSCHECK].flags&D_SELECTED)
         factstacks=1;
   else factstacks=0;

   deltaangledeg=atof(deltaanglestring);
   dmultiplier=4.0*atof(dmultbuf);
   pspread=atof(pspreadbuf);
   dspread=atof(dspreadbuf);
   vspread=atof(vspreadbuf);

   for(i=0;i<3;i++){
            if(connect_dialog[CONNECTVIEWRADIO1+i].flags&D_SELECTED)
                 vw=i;
            connect_dialog[CONNECTVIEWRADIO1+i].flags &= ~D_SELECTED;
   }

   for (i=0;i<NUMLCONNECT;i++){
            d=&connect_dialog[LCONNECT1+i];
            if (d->d1 >=0)
            {
               switch(i){
                    case PITCH:
                         pitchvariable=statevariablearray[d->d1];
                         break;
                    case DURATION:
                         durationvariable=statevariablearray[d->d1];
                         break;
                    case VOLUME:
                         velocityvariable=statevariablearray[d->d1];
                         break;

               }

               sprintf(mapbuf[i],"%s <- %s",d->dp,connect_dialog[RCONNECT1+d->d1].dp);

            }
            else{
               sprintf(mapbuf[i],"%s <- nothing",d->dp);
               switch(i){
                    case PITCH:
                         pitchvariable=constantvar;
                         break;
                    case DURATION:
                         durationvariable=constantvar;
                         break;
                    case VOLUME:
                         velocityvariable=constantvar;
                         break;

               }
            }
   }

   return ret;
}
#define LBG 8
char limitstring[16][120];
DIALOG seelimits_dialog[]={

   {d_box_proc,      0,   0,    260,  310,   255,  LBG,       0,   0,      0,   0,   NULL},

   {d_text_proc,     10,  30,    0,    0,    255,  3,       0,   0,      0,   0,   limitstring[0]},
   {d_text_proc,     10,  46,    0,    0,    255,  LBG,       0,   0,      0,   0,   limitstring[1]},
   {d_text_proc,     10,  62,    0,    0,    255,  LBG,       0,   0,      0,   0,   limitstring[2]},
   {d_text_proc,     10,  78,    0,    0,    255,  LBG,       0,   0,      0,   0,   limitstring[3]},
   {d_text_proc,     10,  94,    0,    0,    255,  LBG,       0,   0,      0,   0,   limitstring[4]},
   {d_text_proc,     10,  110,   0,    0,    255,  LBG,       0,   0,      0,   0,   limitstring[5]},
   {d_text_proc,     10,  126,   0,    0,    255,  LBG,       0,   0,      0,   0,   limitstring[6]},
   {d_text_proc,     10,  142,   0,    0,    255,  LBG,       0,   0,      0,   0,   limitstring[7]},
   {d_text_proc,     10,  158,   0,    0,    255,  LBG,       0,   0,      0,   0,   limitstring[8]},
   {d_text_proc,     10,  174,   0,    0,    255,  LBG,       0,   0,      0,   0,   limitstring[9]},
   {d_text_proc,     10,  190,   0,    0,    255,  LBG,       0,   0,      0,   0,   limitstring[10]},
   {d_text_proc,     10,  206,   0,    0,    255,  LBG,       0,   0,      0,   0,   limitstring[11]},
   {d_text_proc,     10,  222,   0,    0,    255,  LBG,       0,   0,      0,   0,   limitstring[12]},
   {d_text_proc,     10,  238,   0,    0,    255,  LBG,       0,   0,      0,   0,   limitstring[13]},
   {d_text_proc,     10,  254,   0,    0,    255,  LBG,       0,   0,      0,   0,   limitstring[14]},
   {d_text_proc,     10,  270,   0,    0,    255,  LBG,       0,   0,      0,   0,   limitstring[15]},

   { d_button_proc,  5,   5,    16,   16,    255,  0,         13,  D_EXIT, 0,   0,    "X" },
   { d_button_proc,  114, 290,  32,   16,    255,  0,         13,  D_EXIT, 0,   0,    "OK" },
   { NULL,           0,   0,    0,    0,    0,    0,       0,   0,      0,   0,    NULL }
};

int seelimits_proc(int msg, DIALOG *d, int c){
    int ret=d_button_proc(msg,d,c);
    if(ret==D_CLOSE){
          sprintf(limitstring[0], "variable        min      max ");
          sprintf(limitstring[1], "x            %7.2f  %7.2f",minx,maxx);
          sprintf(limitstring[2], "y            %7.2f  %7.2f",miny,maxy);
          sprintf(limitstring[3], "z            %7.2f  %7.2f",minz,maxz);
          sprintf(limitstring[4], "forward x    %7.2f  %7.2f",fminx,fmaxx);
          sprintf(limitstring[5], "forward y    %7.2f  %7.2f",fminy,fmaxy);
          sprintf(limitstring[6], "forward z    %7.2f  %7.2f",fminz,fmaxz);
          sprintf(limitstring[7], "up x         %7.2f  %7.2f",uminx,umaxx);
          sprintf(limitstring[8], "up y         %7.2f  %7.2f",uminy,umaxy);
          sprintf(limitstring[9], "up z         %7.2f  %7.2f",uminz,umaxz);
          sprintf(limitstring[10],"left x       %7.2f  %7.2f",lminx,lmaxx);
          sprintf(limitstring[11],"left y       %7.2f  %7.2f",lminy,lmaxy);
          sprintf(limitstring[12],"left z       %7.2f  %7.2f",lminz,lmaxz);
          sprintf(limitstring[13],"state length %7.2f  %7.2f",minlength,maxlength);
          sprintf(limitstring[14],"draw length  %7.2f  %7.2f",mindrawlength,maxdrawlength);
          sprintf(limitstring[15],"thickness    %7.2f  %7.2f",minthickness,maxthickness);
          centre_dialog(seelimits_dialog);
          popup_dialog(seelimits_dialog,-1);
          return D_O_K;
    }
    return ret;
}
do_remap(){
        do_connect_dialog();
        return D_O_K;
}

float holddmultiplier;
int setdmult(void *dp3, int d2)
{
        DIALOG *dtext=&connect_dialog[DMULTTEXT];
        holddmultiplier=4.0*(float)(d2)/100;

        sprintf(connect_dialog[DMULTTEXT].dp,"%1.2f",holddmultiplier/4.0);
        rectfill(screen,dtext->x,dtext->y, dtext->x + dtext->w,dtext->y + dtext->h,dtext->bg);
        show_mouse(NULL);
        d_text_proc(MSG_DRAW,dtext,0);
        show_mouse(screen);
        return(0);
}
float holdpspread;
int setpspread(void *dp3, int d2)
{
        DIALOG *dtext=&connect_dialog[PSPREADTEXT];
        /*pspread=PSPREADMAX*(float)(d2)/70;*/
        holdpspread=-PSPREADMAX+2*PSPREADMAX*(float)(d2)/70;
        sprintf(connect_dialog[PSPREADTEXT].dp,"%1.2f",holdpspread);
        rectfill(screen,dtext->x,dtext->y, dtext->x + dtext->w,dtext->y + dtext->h,dtext->bg);
        show_mouse(NULL);
        d_text_proc(MSG_DRAW,dtext,0);
        show_mouse(screen);
        return(0);
}
float holddspread;
int setdspread(void *dp3, int d2)
{
        DIALOG *dtext=&connect_dialog[DSPREADTEXT];
        /*dspread=DSPREADMAX*(float)(d2)/70;*/
        holddspread=-DSPREADMAX+2*DSPREADMAX*(float)(d2)/70;

        sprintf(connect_dialog[DSPREADTEXT].dp,"%1.2f",holddspread);
        rectfill(screen,dtext->x,dtext->y, dtext->x + dtext->w,dtext->y + dtext->h,dtext->bg);
        show_mouse(NULL);
        d_text_proc(MSG_DRAW,dtext,0);
        show_mouse(screen);
        return(0);
}

float holdvspread;
int setvspread(void *dp3, int d2)
{
        DIALOG *dtext=&connect_dialog[VSPREADTEXT];
        /*vspread=VSPREADMAX*(float)(d2)/70;*/
        holdvspread=-VSPREADMAX+2*VSPREADMAX*(float)(d2)/70;

        sprintf(connect_dialog[VSPREADTEXT].dp,"%1.2f",holdvspread);
        rectfill(screen,dtext->x,dtext->y, dtext->x + dtext->w,dtext->y + dtext->h,dtext->bg);
        show_mouse(NULL);
        d_text_proc(MSG_DRAW,dtext,0);
        show_mouse(screen);
        return(0);
}

int do_openrulefiledialog(){
     int ret,fsret=1,alertret;
     char buf[100];
     while (fsret){
          fsret=popup_file_select("Load Rule File:", rulefile, "l;ls;lm");
          if(fsret==0) return 0;
          if(!exists(rulefile)){
               sprintf(buf, "Can't find %s", rulefile);
               alertret=alert3(buf, NULL, NULL, "OK", "Try again","Cancel", 13,'t', 27) ;
               if(alertret==1) return 0;
               else if (alertret == 3)
                  return 0;
               else if(alertret==2){
                  fsret=1;
               }
          }
          else fsret=0;
     }

     return(1);
}


/*   (dialog proc)           (x)    (y)    (w)   (h)   (fg)  (bg)   (key) (flags)  (d1)  (d2)  (dp) */
DIALOG numrecurse_dialog[] =
{
   {d_box_proc,               100,  100,   500,  270,   255,   0,       0,   0,      0,   0,   NULL},
   {d_text_proc,              110,  110,   0,    0,     255,   0,       0,   0,      0,   0,   rulefile},

   {d_text_proc,              110,  130,   0,    0,     255,   0,       0,   0,      0,   0,   "recursion depth:"},
   {d_edit_proc,              250,  130,   30,   16,    255,   8,       0 ,  0,      2,   0,   numrecursestring},

   {d_text_proc,              110,  150,   0,    0,     255,   0,       0,   0,      0,   0,   "basic angle:"},
   {d_edit_proc,              250,  150,   60,   16,    255,   8,       0 ,  0,      6,   0,   deltaanglestring},

   {d_text_proc,              110,  170,   0,    0,     255,   0,       0,   0,      0,   0,   "axiom:" },
   {d_textbox_proc,           110,  190,   480,  30,    255,   0,       0,   0,      0,   0,   NULL},

   {d_text_proc,              110,  230,   0,    0,     255,   0,       0,   0,      0,   0,   fileinfo[4]},
   {d_text_proc,              500,  230,   0,    0,     255, MUTATEDBG,       0,   D_HIDDEN,      0,   0,   "Mutated"},
   {d_textbox_proc,           110,  250,   480,  80,    255,   0,       0,   0,      0,   0,   NULL},

   {d_button_proc,            250,  350,   30,   16,    255,   0,       13,  D_EXIT, 0,   0,    "OK" },


   {d_button_proc,            340,  350,   50,   16,    255,   0,       27,  D_EXIT, 0,   0,    "Stop" },

   { NULL,                    0,    0,     0,    0,     0,     0,       0,   0,      0,   0,    NULL }
};
#define AXIOMBOX 7
#define MUTATEDTEXT 9
#define RULESBOX 10
#define NUMRECURSECANCEL 12
/*   (dialog proc)           (x)   (y)   (w)   (h)   (fg)  (bg)   (key) (flags)  (d1)  (d2)  (dp) */
DIALOG rulesinfo_dialog[] =
{
   {d_box_proc,               80,  150,   500,  300, 255,   0,       0,   0,      0,   0,   NULL},
   {d_text_proc,              90,  160,   0,    0,   255,   0,       0,   0,      0,   0,   rulefile},

   {d_text_proc,              90,  180,   0,    0,   255,   0,       0,   0,      0,   0,   "recursion depth:"},
   {d_text_proc,              230, 180,   30,   16,  255,   0,       0 ,  0,      2,   0,   numrecursestring},

   {d_text_proc,              90,  200,   0,    0,   255,   0,       0,   0,      0,   0,   "basic angle:"},
   {d_text_proc,              230, 200,   50,   16,  255,   0,       0 ,  0,      5,   0,   deltaanglestring},

   {d_text_proc,              90,  220,   0,    0,   255,   0,       0,   0,      0,   0,   "axiom:"},
   {d_textbox_proc,           90,  240,   480,  30,  255,   0,       0,   0,      0,   0,   NULL},

   {d_text_proc,              90,  280,   0,    0,   255,   0,       0,   0,      0,   0,   fileinfo[4]},
   {d_text_proc,              500, 230,   0,    0,   255,   2,       0,   D_HIDDEN,      0,   0,   "Mutated"},
   {d_textbox_proc,           90,  300,   480,  80,  255,   0,       0,   0,      0,   0,   NULL},

   { d_button_proc,           230, 400,   30,   16,  255,   0,       13,  D_EXIT, 0,   0,    "OK" },


   { NULL,                    0,   0,     0,    0,   0,     0,       0,   0,      0,   0,    NULL }
};

int getrules( char * rulefile){
   int i,j,k;
   int maxlevel;
   int ret;
   char *rptr;


   formatline(rulefile);
   if(*rulefile =='\0')
                return -1;

   initrules();
   rulefilefp=fopen(rulefile,"r");
   if(rulefilefp==NULL){
          printf("%s not found",rulefile);
          return -1;
   }

   maxlevel=readrulefile(rulefilefp);
   originalmutated=0;
   unsavedrulechanges=0;
   sprintf(numrecursestring,"%d",maxlevel);
   sprintf(deltaanglestring,"%3.2f",deltaangledeg);
   fclose(rulefilefp);
   strcpy(rulefilename,get_filename(rulefile));
   changefileext(rulefile,productionfilename,"out");
   changefileext(rulefile,savemfname,"mid");
   changefileext(rulefile,mutatefilename,"lm");
   changefileext(get_filename(rulefile),productionname,"");
   sprintf(fileinfo[0],"File:            %s\n", rulefile);
   sprintf(fileinfo[1],"recursion depth: %d\n", maxlevel);
   sprintf(fileinfo[2],"basic angle:     %3.2f\n", deltaangledeg);
   sprintf(fileinfo[3],"axiom:           %s",axiom);
   sprintf(fileinfo[4],"transformation rules (%d)\n", numrules);

   return 0;
}


char * makerulesstring(){
     int i;
     int stringlength=0;

     for (i=0;i<numrules;i++)
          stringlength+=(strlen(rules[i])+2);
     if(rulesstring!=NULL)
         free(rulesstring);
     rulesstring=(char *)malloc(sizeof(char)*stringlength+1);

     if(rulesstring!=NULL){
         *rulesstring='\0';
         for (i=0;i<numrules;i++){
           strcat(rulesstring,rules[i]);
           strcat(rulesstring,"\n");
         }
     }

     return rulesstring;
}
int do_numrecursedialog(int recurse){
   int i;
   int dret;
   if(recurse<0){
       numrecurse_dialog[RULESBOX].dp=makerulesstring();
       numrecurse_dialog[AXIOMBOX].dp=axiom;
       originalmutated ? (numrecurse_dialog[MUTATEDTEXT].flags &= ~D_HIDDEN):(numrecurse_dialog[MUTATEDTEXT].flags |= D_HIDDEN);
       centre_dialog(numrecurse_dialog);
       dret=popup_dialog(numrecurse_dialog,-1);

       if(dret==NUMRECURSECANCEL || dret==-1){
              return -1;
       }
       recurse=atoi(numrecursestring);
       deltaangledeg=atof(deltaanglestring);

   }

   return recurse;
}
int rulesinfo_proc(int msg, DIALOG *d, int c);
int saveproduction_proc(int msg, DIALOG *d, int c);
/*   (dialog proc)           (x)   (y)   (w)   (h)   (fg)  (bg)   (key) (flags)  (d1)  (d2)  (dp) */
DIALOG viewprod_dialog[] =
{
   {d_box_proc,               0,  0,   480,  300,   255,   4,       0,   0,      0,   0,   NULL},
   {d_text_proc,              200,2,   0,    0,     255,   4,       0,   0,      0,   0,  productionname},
   {d_textbox_proc,           0,  15,  480,  255,   255,   0,       0,   D_SELECTED,      0,   0,   NULL},

   {rulesinfo_proc,           5,  280, 100,   16,    255,   0,       'r',  D_EXIT,  0,   0,    "&Rules info" },
   {saveproduction_proc,      120,280, 130,   16,    255,   0,       's',  D_EXIT,  0,   0,    "&Save Production" },
   {d_button_proc,            5,  2,   10,    10,    255,   0,       13,  D_EXIT,  0,   0,    "X" },


   { NULL,              0,    0,   0,    0,    0,    0,       0,    0,      0,   0,    NULL }
};
#define PRODUCTIONTEXT 2

char *emptyproduction="(empty)";
int do_viewproduction(){
        long prodlen=strlen(production);
        if(prodlen>0)
          viewprod_dialog[PRODUCTIONTEXT].dp=production;
        else
          viewprod_dialog[PRODUCTIONTEXT].dp=emptyproduction;
        centre_dialog(viewprod_dialog);
        popup_dialog(viewprod_dialog,1);
        return D_O_K;
}


int rulesinfo_proc(int msg, DIALOG *d, int c){
      int ret=d_button_proc(msg,d,c);
      if(ret==D_CLOSE){
        rulesinfo_dialog[AXIOMBOX].dp=axiom;
        rulesinfo_dialog[RULESBOX].dp=rulesstring;
        originalmutated ? (rulesinfo_dialog[MUTATEDTEXT].flags &= ~D_HIDDEN):(rulesinfo_dialog[MUTATEDTEXT].flags |= D_HIDDEN);
        centre_dialog(rulesinfo_dialog);
        popup_dialog(rulesinfo_dialog,-1);
        return D_O_K;
      }
      return ret;
}

int do_makeandinterpret();
int do_remakeandinterpret();
int do_makeproduction();
int do_remakeproduction();
int do_interpret();
int do_interpretremap();
int do_getproduction();
int do_testplay();
int quitter();
int do_dosshell();
int editrulefile();
int editrules();
int help_about();
int geteditor();
int mutaterules();
int mutateandremake();
int savemutation();
int saverulesas();
int do_playmidifile();
int do_stopmidifile();
MENU production_menu[] =
{
   { "&Make && Interpret Production",do_makeandinterpret,   NULL },
   { "   Ma&ke Production",          do_makeproduction,     NULL },
   { "   &Interpret Production",     do_interpret,          NULL, D_DISABLED},
   { "R&eMake && Interpret",         do_remakeandinterpret, NULL,D_DISABLED },
   { "&Re-Interpret (Remap)",        do_interpretremap,     NULL, D_DISABLED},
   { ".....",                             NULL,                  NULL,D_DISABLED },
   { "&Play",                        do_testplay,           NULL, D_DISABLED},
   { "",                             NULL,                  NULL },
   { "Save Rule File &As ...",       saverulesas,           NULL, D_DISABLED},
   { "",                             NULL,                  NULL },
   { "&View/Save Production",        do_viewproduction,     NULL},
   { "&Get Production",              do_getproduction,      NULL },
   { "",                             NULL,                  NULL },
   { "&Save interpretation as MIDI", savemidi,              NULL, D_DISABLED},

   { "",                             NULL,                  NULL },
   { "P&lay MIDI file",              do_playmidifile,       NULL},
   { "St&op Playing MIDI file\tCTRL-s",do_stopmidifile,     NULL,D_DISABLED},
   { "",                             NULL,                  NULL },
   { "&DOS shell",                    do_dosshell,           NULL},
   { "",                             NULL,                  NULL },
   { "&Quit\tCTRL-q",                quitter,               NULL },
   { NULL,                           NULL,                  NULL }
};

#define PRODINTERP 2
#define PRODREMAKE 3
#define PRODINTERPREMAP 4
#define PRODPLAY 6
#define PRODSAVERULES 8
#define PRODVIEW 10
#define PRODSAVE 13
#define PRODSTOPPLAY 16
MENU setup_menu[] =
{
   { "&Map",               do_remap,           NULL },
   { NULL,                 NULL,                   NULL }
};
MENU edit_menu[] =
{
   { "&Edit rule file",    editrulefile,           NULL},
   { "Edit &Rules in memory\tCTRL-e",editrules,NULL},
   { "&Pick editor",            geteditor,              NULL},
   { NULL,                 NULL,                   NULL }
};
#define EDITEDIT 0


MENU mutate_menu[] =
{
   { "&Mutate rules\tCTRL-m",          mutaterules,           NULL,D_DISABLED},
   { "Mutate && &Remake/Interpret",    mutateandremake,       NULL,D_DISABLED},
   { "&Save Mutated rules",            savemutation,          NULL,D_DISABLED},

   { NULL,                 NULL,                   NULL }
};
#define MUTATEMUTATE 0
#define MUTATEREMAKE 1
#define MUTATESAVE 2

int symbolshelp();
int lsystemshelp();
int menushelp();
int scaleshelp();
int playhelp();
int credithelp();
int fileshelp();
int overview();
int troublehelp();
int rulefilehelp();
int maphelp();
int instrumentshelp();
MENU help_menu[] =
{
   { "&L-Systems",                  lsystemshelp,           NULL },
   { "Process &Overview",           overview,               NULL },
   { "&Menus, etc",                 menushelp,              NULL },
   { "&Symbols",                    symbolshelp,            NULL },
   { "M&ap",                        maphelp,                NULL },
   { "&Rule File Format",           rulefilehelp,           NULL },
   { "s&Cales",                     scaleshelp,             NULL },
   { "&Instrument/Timbre Numbers",  instrumentshelp,        NULL },
   { "&Play",                       playhelp,               NULL },
   { "&Files/Compatibility",        fileshelp,              NULL },

   { "&Trouble",                    troublehelp,            NULL },
   { "&About",                      credithelp,             NULL },
   { NULL,                          NULL,                   NULL }
};

MENU topmenu[] =
{ 
   { "&Production",                       NULL,             production_menu },
   { "&Map",                       NULL,           setup_menu},
   { "&Edit",                       NULL,            edit_menu},
   { "M&utate",                       NULL,            mutate_menu},
   { "&Help",                       NULL,             help_menu },

   { NULL,                          NULL,             NULL }
};
#define TOPMUTATE 3


/**/
int d_quit_icon_proc(int msg,DIALOG *d, int c);
int d_remap_icon_proc(int msg,DIALOG *d, int c);
int d_interpret_icon_proc(int msg,DIALOG *d, int c);
int d_play_icon_proc(int msg,DIALOG *d, int c);
int d_savemidi_icon_proc(int msg,DIALOG *d, int c);
int d_makeandinterpret_icon_proc(int msg,DIALOG *d, int c);
int d_remake_icon_proc(int msg,DIALOG *d, int c);
int d_make_icon_proc(int msg,DIALOG *d, int c);
int d_edit_icon_proc(int msg,DIALOG *d, int c);
int d_editrules_icon_proc(int msg,DIALOG *d, int c);
int d_mutate_icon_proc(int msg,DIALOG *d, int c);
int d_mutateandinterpret_icon_proc(int msg,DIALOG *d, int c);
int d_saverules_icon_proc(int msg,DIALOG *d, int c);

#define PMBG 212
#define PMBL 5
#define PMBD 21
#define BUTTONWIDTH 52
#define BUTTONHEIGHT 50
/**/
#define C(x)      (x - 'a' + 1)

/*   (dialog proc)     (x)   (y)   (w)   (h)   (fg)  (bg)   (key) (flags)  (d1)  (d2)  (dp) */
DIALOG dialog1[] =
{

   { d_box_proc,        0,    0,   639,  479,  255,  BG1,   0,      0,     0,   0,    NULL},
   { d_box_proc,        DRAWBORDERWIDE,DRAWBORDERWIDE+DRAWINGTOP,639-2*DRAWBORDERWIDE,480-2*DRAWBORDERWIDE-DRAWINGTOP,255,  DRAWBG,   0,      0,     0,   0,    NULL},
   { d_menu_proc,       0,    0,   0,    0,    0,    0,     0,      0,     0,   0,   topmenu },

/**/ /* buttons */
   { d_shadow_box_proc,              PMBL,   PMBD, 2*BUTTONWIDTH, 9*BUTTONHEIGHT,                    255,PMBG,0,    0,                0,   0,    NULL},

   { rulesinfo_proc,                 PMBL+1,  PMBD+9*BUTTONHEIGHT-18,  2*BUTTONWIDTH-2,     16,      15,  0, 'r',  D_EXIT,  0,   0,   rulefilename },
   { d_make_icon_proc,               PMBL+0, PMBD+0,BUTTONWIDTH,BUTTONHEIGHT,                        255,PMBG,0,  D_EXIT,             2,   2,    NULL,NULL,NULL},
   { d_makeandinterpret_icon_proc,   PMBL+BUTTONWIDTH,PMBD+0,BUTTONWIDTH,BUTTONHEIGHT,               255,PMBG,0,  D_EXIT,             2,   2,    NULL,NULL,NULL},

   { d_interpret_icon_proc,          PMBL+0,PMBD+BUTTONHEIGHT,BUTTONWIDTH,BUTTONHEIGHT,              255,PMBG,0,  D_EXIT|D_DISABLED,  2,   2,    NULL,NULL,NULL},
   { d_remake_icon_proc,             PMBL+BUTTONWIDTH,PMBD+BUTTONHEIGHT,BUTTONWIDTH,BUTTONHEIGHT,    255,PMBG,0,  D_EXIT|D_DISABLED,  2,   2,    NULL,NULL,NULL},

   { d_remap_icon_proc,              PMBL+0,PMBD+2*BUTTONHEIGHT,BUTTONWIDTH,BUTTONHEIGHT,            255,PMBG,0,  D_EXIT|D_DISABLED,  2,   2,    NULL,NULL,NULL},
   { d_play_icon_proc,               PMBL+BUTTONWIDTH,PMBD+2*BUTTONHEIGHT,BUTTONWIDTH,BUTTONHEIGHT,  255,PMBG,0,  D_EXIT|D_DISABLED,  2,   2,    NULL,NULL,NULL},

   { d_mutate_icon_proc,             PMBL+0,PMBD+3*BUTTONHEIGHT, BUTTONWIDTH,BUTTONHEIGHT,           255,PMBG,0,  D_EXIT|D_DISABLED,  2,   2,    NULL,NULL,NULL},
   { d_mutateandinterpret_icon_proc, PMBL+BUTTONWIDTH, PMBD+3*BUTTONHEIGHT, BUTTONWIDTH,BUTTONHEIGHT,255,PMBG,0,  D_EXIT|D_DISABLED,  2,   2,    NULL,NULL,NULL},

   { d_edit_icon_proc,               PMBL+0,PMBD+4*BUTTONHEIGHT,BUTTONWIDTH,BUTTONHEIGHT,            255,PMBG,0,  D_EXIT,             2,   2,    NULL,NULL,NULL},
   { d_saverules_icon_proc,          PMBL+BUTTONWIDTH,PMBD+4*BUTTONHEIGHT, BUTTONWIDTH,BUTTONHEIGHT, 255,PMBG,0,  D_EXIT|D_DISABLED, 2,   2,    NULL,NULL,NULL},

   { d_editrules_icon_proc,          PMBL+0,PMBD+5*BUTTONHEIGHT,BUTTONWIDTH,BUTTONHEIGHT,            255,PMBG,0,  D_EXIT,             2,   2,    NULL,NULL,NULL},
   { d_savemidi_icon_proc,           PMBL+BUTTONWIDTH, PMBD+5*BUTTONHEIGHT, BUTTONWIDTH,BUTTONHEIGHT,255,PMBG,0,  D_EXIT|D_DISABLED,  2,   2,    NULL,NULL,NULL},

   { d_quit_icon_proc,               PMBL+BUTTONWIDTH, PMBD+6*BUTTONHEIGHT, BUTTONWIDTH,BUTTONHEIGHT,255,PMBG,0,  D_EXIT,  2,   2,    NULL,NULL,NULL},
/**/
   { d_keyboard_proc,   0,    0,   0,    0,    0,    0,     0,      0, KEY_ESC, 0,   quitter },
   { d_keyboard_proc,   0,    0,   0,    0,    0,    0,     C('q'), 0,     0,   0,   quitter },

   { d_keyboard_proc,   0,    0,   0,    0,    0,    0,     C('m'), 0,     0,   0,    mutaterules },
   { d_keyboard_proc,   0,    0,   0,    0,    0,    0,     C('s'), 0,     0,   0,    do_stopmidifile },
   { d_keyboard_proc,   0,    0,   0,    0,    0,    0,     C('e'), 0,     0,   0,    editrules },
#if defined (SCREENDUMPS)
   {d_keyboard_proc,    0,    0,   0,    0,    0,    0,     'd'-'a'+1,   0,       0,   0,    dump_screen},
#endif

   { NULL,              0,    0,   0,    0,    0,    0,      0,    0,      0,    0,   NULL }
};

#define DRAWBOX 1
#define TOPMENU 2
#define DIALOG1RULES 4
/**/
#define PROCMAKEBUT 5
#define PROCMAKEANDBUT 6
#define PROCINTERPBUT  7
#define PROCREMAKEBUT 8
#define PROCREMAPBUT 9
#define PROCPLAYBUT  10
#define PROCMUTATEBUT 11
#define PROCMUTANDBUT  12
#define PROCEDITBUT  13
#define PROCSAVERULESBUT 14
#define PROCEDITRULESBUT 15
#define PROCSAVEMIDIBUT  16
#define PROCQUITBUT  17
void redrawbuttons(){
     int i;
     show_mouse(NULL);
     for (i=PROCMAKEBUT;i<=PROCQUITBUT;i++){
          d_icon_proc(MSG_DRAW,&(dialog1[i]),0);
     }
     show_mouse(screen);
}

int makeaborted;
int makefailed;
int do_makeproduction(){
   int recurse=-1;
   int makeret=0;
   int alertret=0;
   int obj;
   if(unsavedrulechanges){
          alertret=alert3("Unsaved rule changes","Do you want to save?","","Save","Don't save","Cancel",13,0,0);
          if(alertret==1)
                         saverulesas();
          else if(alertret==3)
                         return D_O_K;
   }

   makeaborted=0;
   makefailed=0;
   if(do_openrulefiledialog()==0){
                makeaborted=1;
                return D_O_K;
   }

   production_menu[PRODINTERPREMAP].flags |= D_DISABLED;
   production_menu[PRODINTERP].flags |= D_DISABLED;
   dialog1[PROCINTERPBUT].flags |= D_DISABLED;
   dialog1[PROCREMAPBUT].flags |= D_DISABLED;

   getrules(rulefile);
   dialog1[DIALOG1RULES].bg=0;
   edit_menu[EDITEDIT].flags &= ~D_DISABLED;
   dialog1[PROCEDITBUT].flags &= ~D_DISABLED;
   topmenu[TOPMUTATE].flags &= ~D_DISABLED;
   mutate_menu[MUTATEMUTATE].flags &= ~D_DISABLED;
   mutate_menu[MUTATEREMAKE].flags &= ~D_DISABLED;
   dialog1[PROCMUTATEBUT].flags &= ~D_DISABLED;
   dialog1[PROCMUTANDBUT].flags &= ~D_DISABLED;
   mutate_menu[MUTATESAVE].flags |= D_DISABLED;

   production_menu[PRODREMAKE].flags &= ~D_DISABLED;
   production_menu[PRODSAVERULES].flags &= ~D_DISABLED;
   dialog1[PROCREMAKEBUT].flags &= ~D_DISABLED;
   dialog1[PROCSAVERULESBUT].flags &= ~D_DISABLED;

   dialog_message(&dialog1[DIALOG1RULES], MSG_DRAW, 0,&obj);
   recurse=do_numrecursedialog(recurse);
   set_mouse_sprite(waitmouseb);

   makeret=makeproduction(recurse);

   if(makeret<0){
           set_mouse_sprite(NULL);
           alert("production failed",productionmessage,NULL,"OK",NULL,13,0);
           makefailed=1;
   }
   else if(makeret==1 || recurse<0) {
           set_mouse_sprite(NULL);
           alert("production aborted",NULL,NULL,"OK",NULL,13,0);
           makeaborted=1;
           production_menu[PRODINTERP].flags &= ~D_DISABLED;
           dialog1[PROCINTERPBUT].flags &= ~D_DISABLED;

   }
   else {
       production_menu[PRODINTERP].flags &= ~D_DISABLED;
       dialog1[PROCINTERPBUT].flags &= ~D_DISABLED;

   }
   set_mouse_sprite(NULL);
   redrawbuttons();

   return D_O_K;
}
int do_remakeproduction(){
   int recurse=-1;
   int makeret=0;
   makeaborted=0;
   makefailed=0;

   recurse=do_numrecursedialog(recurse);

   show_mouse(screen);
   set_mouse_sprite(waitmouseb);

   makeret=makeproduction(recurse);

   if(makeret<0){
           set_mouse_sprite(NULL);
           alert("production failed",productionmessage,NULL,"OK",NULL,13,0);
           makefailed=1;
   }
   else if(makeret==1 || recurse<0) {
           set_mouse_sprite(NULL);
           alert("production aborted",NULL,NULL,"OK",NULL,13,0);
           production_menu[PRODREMAKE].flags &= ~D_DISABLED;
           production_menu[PRODSAVERULES].flags &= ~D_DISABLED;       
           production_menu[PRODINTERP].flags &= ~D_DISABLED;
           dialog1[PROCREMAKEBUT].flags &= ~D_DISABLED;
           dialog1[PROCSAVERULESBUT].flags &= ~D_DISABLED;
           dialog1[PROCINTERPBUT].flags &= ~D_DISABLED;

           makeaborted=1;
   }
   else {
       production_menu[PRODREMAKE].flags &= ~D_DISABLED;
       production_menu[PRODSAVERULES].flags &= ~D_DISABLED;
       production_menu[PRODINTERP].flags &= ~D_DISABLED;
       /*production_menu[PRODVIEW].flags &= ~D_DISABLED;*/
       dialog1[PROCREMAKEBUT].flags &= ~D_DISABLED;
       dialog1[PROCSAVERULESBUT].flags &= ~D_DISABLED;
       dialog1[PROCINTERPBUT].flags &= ~D_DISABLED;

   }
   set_mouse_sprite(NULL);
   redrawbuttons();

   return D_O_K;
}
FILE *readprod_fp;
int do_productionfiledialog(){
     int ret,fsret=1,alertret;
     char buf[100];
     while (fsret){
          fsret=popup_file_select("Get Production File:", productionfilename, "out");
          if(fsret==0) return 0;
          if(!exists(productionfilename)){
               sprintf(buf, "Can't find %s", productionfilename);
               alertret=alert3(buf, NULL, NULL, "OK", "Try again","Cancel", 13,'t', 27) ;
               if(alertret==1) return 0;
               else if (alertret == 3)
                  return 0;
               else if(alertret==2){
                  fsret=1;
               }
          }
          else fsret=0;
     }

     return(1);
}


int do_getproduction(){
   long plength=0L;
   char *ptr;

   long maxlen=maxstringlength-10L;
   int c;

   if(production==NULL){

      production=(char *)malloc(maxstringlength);
      if(production==NULL){
                     allegro_exit();
                     printf("\nMemory allocation error\n");
                     exit(0);
      }
      
   }
   ptr=production;
   if(do_productionfiledialog()==0){

       return D_O_K;
   }
   else{
       readprod_fp=fopen(productionfilename,"r");
       if(readprod_fp==NULL){
              return D_O_K;
       }
       while( (c=fgetc(readprod_fp))!=EOF){
              *ptr=c;
               ptr++;
               plength++;
               if(plength>maxlen){
                     alert("Out of string space","","","OK",NULL,13,0);
                     return D_O_K;
               }
       }
       fclose(readprod_fp);
       *ptr='\0';

   }
   changefileext(productionfilename,savemfname,"mid");
   changefileext(get_filename(productionfilename),productionname,"");

   production_menu[PRODINTERP].flags &= ~D_DISABLED;
   dialog1[PROCINTERPBUT].flags &= ~D_DISABLED;


   return D_O_K;
}


#define INTERPRETFILEERROR 1
#define INTERPRETARITHERROR -1
#define INTERPRETOK 0
#define INTERPRETABORT 2
#define INTERPRETSTACKOVERFLOW 3
#define INTERPRETSTACKUNDERFLOW 4
int do_makeandinterpret(){
    int mret=do_makeproduction();
    if (mret!=D_O_K) return mret;
    if(makeaborted==0 && makefailed==0){

          do_interpret();

    }
    return D_O_K;


}
int do_remakeandinterpret(){
    int mret=do_remakeproduction();
    if (mret!=D_O_K) return mret;
    if(makeaborted==0 && makefailed==0){

          do_interpret();

    }
    return D_O_K;


}
#ifdef EXITONARITHERROR
#define ARITHERRORHELP "The program \
tried to do an illegal arithmetic procedure. Most likely this was \
caused by a quantity (like a drawing coordinate) which grew too large to handle. If this is the case, often trying \
a lower recursion level helps. In any case, when you close this box, the program \
will quit."

#else

#define ARITHERRORHELP "The program \
tried to do an illegal arithmetic procedure. Most likely this was \
caused by a quantity (like a drawing coordinate) which grew too large to handle. If this is the case, often trying \
a lower recursion level helps."
#endif
char * aritherrorhelp=ARITHERRORHELP;
DIALOG aritherrorhelp_dialog[] =
{
   {d_box_proc,               190,  240,   270,   130,   255,   0,       0,   0,      0,   0,   NULL},
   {d_textbox_proc,           200,  242,   250,   100,   255,   0,       0,   0,       0,   0,  NULL},

   { d_button_proc,           200,  350,   30,   16,   255,  0,       13,  D_EXIT,  0,   0,    "OK" },
   { NULL,              0,    0,   0,    0,    0,    0,       0,    0,      0,   0,    NULL }
};
#define ARITHTEXTBOX 1

int do_aritherrorhelp(){
         aritherrorhelp_dialog[ARITHTEXTBOX].dp=aritherrorhelp;
         popup_dialog(aritherrorhelp_dialog,-1);
#ifdef EXITONARITHERROR
         allegro_exit();

         exit(0);
#else
         return 0;
#endif
}
int do_interpret(){
   int i;
   int interpretret;
   int playonabort;
   int alertret;
   int connectret;
   deltaanglerad = deg2rad(deltaangledeg);
   maxx=0;maxy=0;maxz=0;minx=0;miny=0;minz=0;
   fmaxx=0;fmaxy=0;fmaxz=0;fminx=0;fminy=0;fminz=0;
   umaxx=0;umaxy=0;umaxz=0;uminx=0;uminy=0;uminz=0;
   lmaxx=0;lmaxy=0;lmaxz=0;lminx=0;lminy=0;lminz=0;

   maxlength=0;
   minlength=0;
   maxdrawlength=0;
   mindrawlength=0;

   maxthickness=curstate.thickness;
   minthickness=curstate.thickness;
   numobjects=0;

   production_menu[PRODPLAY].flags |= D_DISABLED;
   production_menu[PRODSAVE].flags |= D_DISABLED;
   production_menu[PRODINTERPREMAP].flags |= D_DISABLED;
   dialog1[PROCPLAYBUT].flags |= D_DISABLED;
   dialog1[PROCSAVEMIDIBUT].flags |= D_DISABLED;
   dialog1[PROCREMAPBUT].flags |= D_DISABLED;
   redrawbuttons();
   for(i=0;i<MAXTRACKS;i++){
    trackcumtime[i]=0L;
    trackprevcumtime[i]=0L;
   }
   rstart = makeseed();
   srand(rstart);
   set_mouse_sprite(waitmouseu);

   interpretret=interpret(0);

   set_mouse_sprite(NULL);
   if( interpretret == INTERPRETARITHERROR){

        alertret=alert3("Arithmetic error","while interpreting.","Have to quit","OK","Rats!","Help",13,0,'h');
        if(alertret==3)
                       do_aritherrorhelp();
#ifdef EXITONARITHERROR
        exit(0);
#else
        return D_O_K;
#endif
   }
   else if(interpretret==INTERPRETFILEERROR){
        production_menu[PRODINTERP].flags |= D_DISABLED;
        production_menu[PRODREMAKE].flags |= D_DISABLED;
        dialog1[PROCINTERPBUT].flags |= D_DISABLED;
        dialog1[PROCREMAKEBUT].flags |= D_DISABLED;
        alert("Production file error","","... Quitting","OK",NULL,13,0);
        return D_O_K;
   }
   else if(interpretret==INTERPRETABORT){
        alert("Interpret aborted","(too soon to have anything to play)","","OK",NULL,13,0);
        return D_O_K;
   }
   else if(interpretret==INTERPRETSTACKOVERFLOW){
        alert("Interpret failed","Stack full!","","OK","What the hell?",13,0);
        return D_O_K;
   }
   else if(interpretret==INTERPRETSTACKUNDERFLOW){
        alert("Interpret failed","Pop from empty stack","","OK","What the hell?",13,0);
        return D_O_K;
   }

   if( numobjects == 0){
        alert("No objects. Done.",NULL,NULL,"OK",NULL,13,0);
        return D_O_K;
   }

   production_menu[PRODINTERPREMAP].flags &= ~D_DISABLED;
   dialog1[PROCREMAPBUT].flags &= ~D_DISABLED;
   redrawbuttons();
   return do_interpretremap();
}


int do_interpretremap(){
   int i;
   int obj;
   int playonabort;
   int interpretret;
   int alertret;
   int connectret;

   connectret=do_connect_dialog();
   if(connectret==-1||connectret==CONNECTCANCEL)
         return D_O_K;

   if(getsetlimits()<0){
        alert("Drawing has 0 size",NULL,NULL,"OK",NULL,13,0);
        return D_O_K;
   }
   production_menu[PRODPLAY].flags |=  D_DISABLED;
   production_menu[PRODSAVE].flags |=  D_DISABLED;
   dialog1[PROCPLAYBUT].flags |= D_DISABLED;
   dialog1[PROCSAVEMIDIBUT].flags |= D_DISABLED;
   redrawbuttons();

   for(i=0;i<MAXTRACKS;i++){
                  free_midi_note_list( tracklist[i] );
                  tracklist[i]=NULL;
   }
   if(draw_p){
     show_mouse(NULL);

     dialog_message(&dialog1[DRAWBOX],MSG_DRAW,0,&obj);
     dialog_message(&dialog1[DIALOG1RULES], MSG_DRAW, 0,&obj);
     show_mouse(screen);
   }
   deltaanglerad = deg2rad(deltaangledeg);
   srand(rstart);
   set_mouse_sprite(waitmousep);

   interpretret=interpret(1);

   set_mouse_sprite(NULL);
   if(interpretret==INTERPRETARITHERROR){

      alertret=alert3("Arithmetic error","while interpreting.","Have to quit","OK","Rats!","Help",13,0,'h');
      if(alertret==3)
                       do_aritherrorhelp();
#ifdef EXITONARITHERROR
      exit(0);
#else
      return D_O_K;
#endif
   }
   else if(interpretret==INTERPRETFILEERROR){

        alert("Production file error","","... Quitting","OK",NULL,13,0);
        return D_O_K;
   }
   else if(interpretret==INTERPRETABORT){
        playonabort=alert("Interpret aborted","Play anyway?","","Yes","No",'y','n');

        production_menu[PRODPLAY].flags &= ~D_DISABLED;
        production_menu[PRODSAVE].flags &= ~D_DISABLED;
        production_menu[PRODINTERP].flags &= ~D_DISABLED;
        production_menu[PRODREMAKE].flags &= ~D_DISABLED;

        dialog1[PROCPLAYBUT].flags &= ~D_DISABLED;
        dialog1[PROCSAVEMIDIBUT].flags &= ~D_DISABLED;
        dialog1[PROCINTERPBUT].flags &= ~D_DISABLED;
        dialog1[PROCREMAKEBUT].flags &= ~D_DISABLED;

        strcpy(playrulefilename,rulefilename);
        redrawbuttons();

        if(playonabort==2) return D_O_K;
   }
   production_menu[PRODPLAY].flags &= ~D_DISABLED;
   production_menu[PRODSAVE].flags &= ~D_DISABLED;
   production_menu[PRODINTERPREMAP].flags &= ~D_DISABLED;
   production_menu[PRODINTERP].flags &= ~D_DISABLED;
   production_menu[PRODREMAKE].flags &= ~D_DISABLED;

   dialog1[PROCPLAYBUT].flags &= ~D_DISABLED;
   dialog1[PROCSAVEMIDIBUT].flags &= ~D_DISABLED;
   dialog1[PROCREMAPBUT].flags &= ~D_DISABLED;
   dialog1[PROCINTERPBUT].flags &= ~D_DISABLED;
   dialog1[PROCREMAKEBUT].flags &= ~D_DISABLED;


   strcpy(playrulefilename,rulefilename);
   if( maxcumtime == 0){
        alert("Total time of piece is 0. Done.",NULL,NULL,"OK",NULL,13,0);
        return D_O_K;
   }
   redrawbuttons();

   return (do_testplay());

}

DIALOG play_dialog[];
int do_testplay(){

   timertempo(tempo);
   popup_dialog(play_dialog,-1);
   return D_O_K;
}

DATAFILE * Data1;
DIALOG intro_dialog[];
void setup_processbuttons();
int main(int argc,char *argv[]){

   int numargs=argc-1;
   char argvbuf[80];
   char *aptr;
   int interpretreturn;
   int recurse;
   int ret;
   int i,k,n;


   for(n = 1; n<=numargs;n++) {
        strcpy(argvbuf,argv[n]);
        strupr(argvbuf);
        aptr=argvbuf;
        if (*aptr == '-'){
             aptr++;
             if(*aptr=='S'){
                aptr++;
                maxstringlength = 1024*atoi(aptr);
             }
        }
   
   }
   readconfigfile();
   allegro_init();
   install_keyboard();
   install_mouse();
   install_timer();

   LOCK_VARIABLE(int_t1);
   LOCK_FUNCTION(t_int1);

   randomize();
   rstart = makeseed();
   initrules();
   deflscale = .9;   /* default scaling for '*/

   vw = XY;

   recurse = -1;

   set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0);
   Data1=load_datafile("lmus.dat");
   if(Data1 !=NULL){
            set_palette(Data1[PAL1].dat);
            maxcolor=255;
            waitmouseb=Data1[WAITMOUSEB].dat;
            waitmousep=Data1[WAITMOUSEP].dat;
            waitmouset=Data1[WAITMOUSET].dat;
            waitmouseu=Data1[WAITMOUSEU].dat;
            pointup=Data1[POINTUP].dat;
            lmtitle=Data1[LMTITLE].dat;
            font=Data1[THEFONT].dat;
            setup_processbuttons();
   }
   else {
       waitmouset=NULL;
       waitmousep=NULL;
       waitmouseu=NULL;
       waitmouseb=NULL;
       pointup=NULL;
       set_palette(desktop_palette);
   }
   clear(screen);

   /* install a MIDI sound driver */
   if (install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, argv[0]) != 0) {
      printf("Error initializing sound system\n%s\n", allegro_error);
      exit(1);
   }

   load_midi_patches();

   strcpy(scalenamestring,scalenames[1]);
   strcpy(scalefnnamestring,scalefnnames[0]);
   pitchvariable=statevariablearray[0];
   durationvariable=statevariablearray[13];
   velocityvariable=statevariablearray[3];

   set_mouse_speed(1, 1);
   intro_dialog[1].dp=lmtitle;
   centre_dialog(intro_dialog);
   ret=do_dialog(intro_dialog,-1);
   setup_processbuttons();
   ret=do_dialog(dialog1,-1);


   for(i=0;i<MAXTRACKS;i++)
           free_midi_note_list( tracklist[i] );
   set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
   exit(0);
}



int getsetlimits(){

        /* drawing limits */
        float h,v,l,r,b,t,wsize;

        float aspect=(float)(SCREEN_W-4*DRAWBORDERWIDE-2*BUTTONWIDTH)/(float)(SCREEN_H-DRAWINGTOP-4*DRAWBORDERWIDE);


        if( vw == XY){
                h = fabs(maxx - minx);
                v = fabs(maxy - miny);
                l = minx; r = maxx; b = miny; t = maxy;
        }
        else if (vw == ZY){
                h = fabs(maxz - minz);
                v = fabs(maxy - miny);
                l = minz; r = maxz; b = miny; t = maxy;
        }
        else if( vw == ZX){
                h = fabs(maxz - minz);
                v = fabs(maxx - minx);
                l = minz; r = maxz; b = minx; t = maxx;
        }
        if (h == 0 && v == 0){
                return -1;
        }
        if( h > v * aspect){
                wsize = h;
                wtlx=l;
                wtly=b+v/2-wsize/2;
                wbrx=l+wsize;

                wbry=b+v/2+wsize/2/aspect;
        }
        else{
                wsize = v;
                wtlx=l+h/2-wsize*aspect/2;
                wtly=b;
                wbrx=l+h/2+wsize*aspect/2;
                wbry=b+wsize;
        }

        virxmult= (float)(SCREEN_W-4*DRAWBORDERWIDE-2*BUTTONWIDTH)/(wbrx-wtlx);
        virymult= (float)(SCREEN_H-DRAWINGTOP-4*DRAWBORDERWIDE)/(wbry-wtly);

        return 0;
}
void cross (VECTOR *v, VECTOR *w, VECTOR *r){
/* r = v X w;  'r' for 'result'*/
  r->x = v->y * w->z - v->z * w->y;
  r->y = v->z * w->x - v->x * w->z;
  r->z = v->x * w->y - v->y * w->x;
}


float deg2rad (float deg){
        return (PI * deg / 180.0);
}



void rotate (VECTOR *t , VECTOR *v , VECTOR *r, float a){
/*rotate v around t by angle a. result stored in r*/
    float tx=t->x,ty=t->y,tz=t->z,vx=v->x,vy=v->y,vz=v->z;
    float ac,bc,cc,cosa,sina,gz;
    float R11,R12,R13,R21,R22,R23,R31,R32,R33;
    float tlen = sqrt(tx*tx + ty*ty + tz*tz);
    ac = tx/tlen;
    bc = ty/tlen;
    cc = tz/tlen;
    cosa = cos(a); sina = sin(a);
    gz = 1 - cosa;

    R11 = ac*ac*gz + cosa;    R12 = ac*bc*gz - cc*sina; R13 = ac*cc*gz + bc*sina;
    R21 = ac*bc*gz + cc*sina; R22 = bc*bc*gz + cosa;    R23 = bc*cc*gz - ac * sina;
    R31 = ac*cc*gz - bc*sina; R32 = bc*cc*gz + ac*sina; R33 = cc*cc*gz + cosa;

    r->x = R11*vx + R12*vy + R13*vz;
    r->y = R21*vx + R22*vy + R23*vz;
    r->z = R31*vx + R32*vy + R33*vz;
}


void xrot (VECTOR *v, VECTOR *vn, float theta){
        vn->x = v->x;
        vn->y = (v->y) * cos(theta) - (v->z) * sin(theta);
        vn->z = (v->z) * cos(theta) + (v->y) * sin(theta);
}

void yrot (VECTOR *v, VECTOR * vnew, float theta){

        vnew->x = (v->x) * cos(theta) + (v->z) * sin(theta);
        vnew->y = v->y;
        vnew->z = (v->z) * cos(theta) - (v->x) * sin(theta);
}

void zrot (VECTOR *v, VECTOR *vnew, float theta){
        vnew->x = (v->x) * cos(theta) + (v->y) * sin(theta);
        vnew->y = (v->y) * cos(theta) - (v->x) * sin(theta);
        vnew->z = v->z;
}


virline(BITMAP * bmp,float x1,float y1, float x2, float y2, int clr){
      int rx1=(int)(2*DRAWBORDERWIDE+2*BUTTONWIDTH+virxmult*(x1-wtlx));
      int ry1=SCREEN_H-2*DRAWBORDERWIDE-(int)(virymult*(y1-wtly));
      int rx2=(int)(2*DRAWBORDERWIDE+2*BUTTONWIDTH+virxmult*(x2-wtlx));
      int ry2=SCREEN_H-2*DRAWBORDERWIDE-(int)(virymult*(y2-wtly));
      if(clr>=DRAWBG){
            clr=clr+1;
      }
      line(bmp,rx1,ry1,rx2,ry2,clr%maxcolor);

}

int transposestack[STACKDEPTH]={0};
int transposestacktop=0;
void pushtranspose(int t){


     transposestack[transposestacktop]=t;

     transposestacktop++;
}
int poptranspose(){
     if (transposestacktop<1){

                return transposestack[0];
     }
     return transposestack[--transposestacktop];

}

float dfactstack[STACKDEPTH]={1.0};
int dfactstacktop=0;
float vfactstack[STACKDEPTH]={1.0};
int vfactstacktop=0;

void pushdfact(float fact){


     dfactstack[dfactstacktop]=fact;

     dfactstacktop++;
}
float popdfact(){
     if (dfactstacktop<1){


        return dfactstack[0];
     }
     return dfactstack[--dfactstacktop];

}

void pushvfact(float fact){


     vfactstack[vfactstacktop]=fact;

     vfactstacktop++;
}
float popvfact(){
     if (vfactstacktop<1){


        return vfactstack[0];
     }
     return vfactstack[--vfactstacktop];

}


int getapitch();
int getavelocity();
long getaduration();
int count_notes=0;

long inserttracknote(int tracknumber, int on_off){
      int pitch;
      long dur =getaduration();
      int vel;
      int channel=trackchannel[tracknumber];
      long cum_time=curstate.cumtime;
      long prev_cum_time=curstate.prevcumtime;
      MIDINOTELIST * last_node;
      prev_cum_time=trackprevcumtime[tracknumber];

      if(on_off){
           pitch = getapitch()&0x7F;
           vel=getavelocity()&0x7F;
      }
      else {
           pitch=0;
           cum_time=cum_time+dur;
      }
      if(pitch>0){

           count_notes++;
           /*make the note_on node*/
           last_node=makenewnode();
           if(tracklist[tracknumber]==NULL){
                tracklist[tracknumber]=last_node;
                last_node->m.t=cum_time-prev_cum_time;
           }
           else
                insertattime(&tracklist[tracknumber],last_node,cum_time,0);
           last_node->m.status=NOTEON|channel;
           last_node->m.data1=pitch;
           last_node->m.data2=vel;

           /*make the note_off*/
           last_node=makenewnode();

           insertattime(&tracklist[tracknumber],last_node,cum_time+dur,0);

           last_node->m.status=NOTEOFF|channel;
           last_node->m.data1=pitch;
           last_node->m.data2=0;


           trackprevcumtime[tracknumber]=cum_time+dur;
           curstate.prevcumtime=cum_time+dur;

           tracklastnode[tracknumber]=last_node;

           trackflags[tracknumber]|=ACTIVE;
      }
      curstate.cumtime+=dur;

      return dur;
}
long insertpatchandnote(int tracknumber){

      int program =curstate.clr%127;

      int pitch;
      long dur =getaduration();
      int vel;
      int channel=trackchannel[tracknumber];
      long cum_time=curstate.cumtime;
      long prev_cum_time=curstate.prevcumtime;
      MIDINOTELIST * patch_node,*note_node;
      prev_cum_time=trackprevcumtime[tracknumber];

      pitch = getapitch()&0x7F;
      vel=getavelocity()&0x7F;


      if(pitch>0){

           count_notes++;
           /*make the note_on node*/
           patch_node=makenewnode();
           note_node=makenewnode();
           patch_node->next=note_node;
           note_node->prev=patch_node;
           note_node->m.t=0L;

           if(tracklist[tracknumber]==NULL){
                tracklist[tracknumber]=patch_node;
                patch_node->m.t=cum_time-prev_cum_time;
           }
           else
                insertlistattime(&tracklist[tracknumber],patch_node,cum_time);
           patch_node->m.status=PRG_CHG|channel;
           patch_node->m.data1=program;
           patch_node->m.data2=0;
           note_node->m.status=NOTEON|channel;
           note_node->m.data1=pitch;
           note_node->m.data2=vel;

           /*make the note_off*/
           note_node=makenewnode();

           insertattime(&tracklist[tracknumber],note_node,cum_time+dur,0);

           note_node->m.status=NOTEOFF|channel;
           note_node->m.data1=pitch;
           note_node->m.data2=0;


           trackprevcumtime[tracknumber]=cum_time+dur;
           curstate.prevcumtime=cum_time+dur;

           tracklastnode[tracknumber]=note_node;

           trackflags[tracknumber]|=ACTIVE;
      }
      curstate.cumtime+=dur;

      return dur;
}

void inserttrackpatch(int tracknumber){

      long program =curstate.clr%127;

      int channel=trackchannel[tracknumber];
      long cum_time=curstate.cumtime;
      long prev_cum_time=curstate.prevcumtime;
      MIDINOTELIST * last_node;



      count_notes++;
      /*make the note_on node*/
      last_node=makenewnode();
      if(tracklist[tracknumber]==NULL){
                tracklist[tracknumber]=last_node;
                last_node->m.t=cum_time-prev_cum_time;
      }
      else
           insertattime(&tracklist[tracknumber],last_node,cum_time,1);
      last_node->m.status=PRG_CHG|channel;
      last_node->m.data1=program;


      tracklastnode[tracknumber]=last_node;

      trackflags[tracknumber]|=ACTIVE;



}



int basenote=60;
#define FPZERODIF 1e-5
int getapitch(){
      int pitch;
      VARIABLE p=pitchvariable;
      float pwide=*p.mymax-*p.mymin;
      float midp=(*p.mymax+*p.mymin)/2;
      if(pwide>FPZERODIF){

                 pitch=basenote+curstate.transpose+scalefn( pspread*(*p.v-midp)*30/pwide ,cur_scale);
      }
      else
                 pitch=basenote+curstate.transpose+scalefn( 0,cur_scale);
      return pitch;
}


long getaduration(){
      long dur;
      VARIABLE d=durationvariable;
      float dwide=*d.mymax-*d.mymin;
      float midd=(*d.mymax+*d.mymin)/2;
      if(dwide>FPZERODIF){

                 dur=curstate.dfact*dmultiplier*division/8*pow(2,dspread*(*d.v-midd)/dwide);
      }
      else
                 dur=curstate.dfact*dmultiplier*division/8*pow(2,0);

      return dur;
}


int getavelocity(){
      int vel;
      VARIABLE v=velocityvariable;
      float vwide=*v.mymax-*v.mymin;
      float midv=(*v.mymax+*v.mymin)/2;
      if(vwide>FPZERODIF){

                 vel=64+ vspread*(*v.v-midv)*30/vwide;
      }
      else   vel=64;
      vel=(int)(curstate.vfact*vel);
      if (vel>0x7F) vel=0x7F;
      return (vel);
}



void play_chan_event(MIDICHANEVENT e){

     unsigned char stat=e.status&0xF0;
     unsigned char channel=e.status&0x0F;
     unsigned char data1=e.data1;
     unsigned char data2=e.data2;

     if (stat==NOTEON){
                 send_note_on(channel, data1, data2);

     }
     else if (stat==NOTEOFF)
                 send_note_off(channel, data1);
     else if(stat==PRG_CHG)
                   set_patch(channel,data1);

}
long lasttimertime;
long timertime;
long pausetime;

void init_trackplay(){
        int tracknumber;
        long testtime;

        for(tracknumber=0;tracknumber<MAXTRACKS;tracknumber++)
            all_notes_off(trackchannel[tracknumber]);

        for(tracknumber=0;tracknumber<MAXTRACKS;tracknumber++){
            if(trackflags[tracknumber]&ACTIVE){
               if(tracklist[tracknumber]==NULL)
                    trackflags[tracknumber]&=~ACTIVE;
               else
                    tracknextnode[tracknumber]=tracklist[tracknumber];
               trackcumtime[tracknumber]=0L;
               trackprevcumtime[tracknumber]=0L;

               set_pan(trackchannel[tracknumber],67);
            }
        }

        /*find the first event to play*/
        for(tracknumber=0;tracknumber<MAXTRACKS;tracknumber++){
          if(trackflags[tracknumber]&ACTIVE){
        
               next_event_time=tracklist[tracknumber]->m.t;/*just say track 0, event 1 comes first*/
               next_track=tracknumber;
               break;
           }
        }

        next_node=tracknextnode[next_track];
        /*then look at each track to find an event even earlier*/
        for(tracknumber=0;tracknumber<MAXTRACKS;tracknumber++){
          if(trackflags[tracknumber]&ACTIVE){
              testtime=tracknextnode[tracknumber]->m.t;
              if (testtime < next_event_time){
                 next_event_time=testtime;
                 next_track=tracknumber;
                 next_node=tracknextnode[next_track];
              }
          }
        }

        int_t1=0L;


        next_event_time=next_node->m.t;
}


char tbuf[32];
int track_proc(int msg,DIALOG *d, int c);
int savemidi_proc(int msg, DIALOG *d, int c);
int playbutton_proc(int msg,DIALOG *d, int c);
int pausebutton_proc(int msg,DIALOG *d, int c);
int helpbutton_proc(int msg, DIALOG *d, int c);
int playdialogsettempo(void *dp3, int d2);

int metro_proc(int msg,DIALOG *d, int c);
int dummy_proc(int msg,DIALOG *d, int c);
#define TRACKTLX 20
#define TRACKTLY 100
#define TRACKBRX 640-TRACKTLX
#define TRACKBRY TRACKTLY+256


/*   (dialog proc)     (x)   (y)   (w)   (h)   (fg)  (bg)   (key) (flags)  (d1)  (d2)  (dp) */
DIALOG play_dialog[] =
{

   { d_shadow_box_proc, 0,    0,   639,  479,  255,  PLAYBG,  0,    0,      0,   0,    NULL},


   /* tempo */
   { d_text_proc,       400,  40,   30,   10,   255,  PLAYBG, 0,    0,      0,   0,    tbuf },
   { d_slider_proc,     220,  20,   200,  15,   255,  PLAYBG,'t',  0,      400,  0,   NULL, playdialogsettempo},
   { d_text_proc,       290,  5,   20,   30,   255,  PLAYBG, 0,    0,      0,   0,    "&Tempo" },
   /* track box */
   { track_proc,TRACKTLX,TRACKTLY,TRACKBRX-TRACKTLX,TRACKBRY-TRACKTLY,0, TRACKBG, 0,    0,0,    0,    NULL },
   { metro_proc,TRACKTLX,TRACKBRY,TRACKBRX-TRACKTLX,8,0, 255, 0,    0,0,    0,    NULL },
   /* buttons */
   { savemidi_proc,     20,    430,  80,  18,  255,  0,    's',     D_EXIT, 0,    0,    "&Save Midi" },
   { playbutton_proc,   180,   430,  50,   18,  255,  0,    'p',     D_EXIT, 0,    0,    "&Play" },
   { pausebutton_proc,  240,   430,  50,   18,  255,  0,    'u',     0,      0,    0,    "Pa&use" },
   { helpbutton_proc,   550,   430,  50,   18,  255,  0,    'h',     D_EXIT, 0,    0,    "&Help"},
   { d_button_proc,     300,   430,  50,   18,  255,  0,    'n',     D_EXIT, 0,    0,    "&New" },
   { d_button_proc,     420,   430,  50,   18,  255,  0,    'x',     D_EXIT, 0,    0,    "E&xit" },
#if defined (SCREENDUMPS)
   {d_keyboard_proc,    0,     0,    0,    0,    0,   0,   'd'-'a'+1,0,      0,    0,    dump_screen},
#endif
   { d_text_proc,       540,    5,    100,  10,  255,  PLAYBG,0,      0,      0,    0,    playrulefilename },
   { NULL,               0,     0,    0,    0,   0,    0,    0,      0,      0,    0,    NULL }
};

#define PLAYMETRO 5
#define PLAYDGTEMPOSLIDER  2
#define PLAYDGTEMPOTEXT  1
#define PLAYPAUSEBUTTON 8

int newtime;
int metro_proc(int msg,DIALOG *d, int c){
    int mx,my,omx,omy;
    int timerx;
    int tracknumber;
    int cur_track;
    MIDINOTELIST *cur_node;
    long testtime;
    MIDICHANEVENT m;
    int status;
    switch(msg){
         case MSG_DRAW:
              rectfill(screen, d->x, d->y, d->x+d->w, d->y+d->h, d->bg);


             break;
         case MSG_GOTMOUSE:
              set_mouse_sprite(pointup);
              break;
         case MSG_LOSTMOUSE:
              set_mouse_sprite(NULL);
              break;

         case MSG_IDLE:
             if(newtime){
               show_mouse(NULL);
               if(next_node==NULL){
                   line(screen,timetox(lasttimertime),d->y,timetox(lasttimertime),d->y+d->h,d->bg);
                   line(screen,timetox(maxcumtime),d->y,timetox(maxcumtime),d->y+d->h,d->fg);
               
               }
               else{
                   line(screen,timetox(lasttimertime),d->y,timetox(lasttimertime),d->y+d->h,d->bg);
                   line(screen,timetox(timertime),d->y,timetox(timertime),d->y+d->h,d->fg);
               }
               show_mouse(screen);
               lasttimertime=timertime;
               newtime=0;
             }
             break;
         case MSG_CLICK:
              mx=mouse_x;my=mouse_y;
              omx=mx;omy=my;
              timerx=timetox(lasttimertime);

              show_mouse(NULL);
              line(screen,timerx,d->y,timerx,d->y+d->h,d->bg);
              show_mouse(screen);

              for (tracknumber=0;tracknumber<MAXTRACKS;tracknumber++){
                      all_notes_off(trackchannel[tracknumber]);
              }
              while(mouse_b&1){
                      mx=mouse_x;my=mouse_y;
                      if((omx!=mx || omy!=my)&&(mx<=TRACKBRX&&mx>=TRACKTLX) ){
                          show_mouse(NULL);
                          if(omx<=TRACKBRX&&omx>=TRACKTLX)
                                line(screen,omx,d->y,omx,d->y+d->h,d->bg);
                          line(screen,mx,d->y,mx,d->y+d->h,d->fg);
               
                          show_mouse(screen);
                      }
                      omx=mx;omy=my;

               }
               if(my>TRACKTLY&&my<TRACKBRY+40){
                         timertime=(mx-TRACKTLX)*maxcumtime/(TRACKBRX-TRACKTLX);
                         if(timertime<=0){
                                init_trackplay();
                                timertime=0;
                                lasttimertime=timertime;
                                return D_O_K;
                         }
                         if(timertime<next_event_time){
                             init_trackplay();
                         }
                         while(timertime>=next_event_time&&next_node!=NULL){
                               cur_track=next_track;
                               cur_node=next_node;

                               m=cur_node->m;

                               m.status=(m.status& 0xF0)|trackchannel[cur_track];
                               if(status==PRG_CHG)
                                     play_chan_event(m);

                               trackcumtime[cur_track]+=m.t;
                               tracknextnode[cur_track]=cur_node->next;

                               /* just say next event is next one on the current track...*/
                               next_node=cur_node->next;
                               next_event_time=trackcumtime[cur_track]+next_node->m.t;
                               next_track=cur_track;
                               /*... then look for one that should come earlier*/
                               for(tracknumber=0;tracknumber<MAXTRACKS;tracknumber++){
                                   if(trackflags[tracknumber]&ACTIVE && tracknextnode[tracknumber]!=NULL){
                                       if(tracknumber!=cur_track){
                                          testtime=tracknextnode[tracknumber]->m.t+trackcumtime[tracknumber] ;
                                          if (testtime<next_event_time || next_node==NULL){
                                             next_event_time=testtime;
                                             next_track=tracknumber;
                                             next_node=tracknextnode[tracknumber];
                                          }
                                       }
                                   }
                               }

                         }

               }

               lasttimertime=timertime;
               pausetime=timertime;
               newtime=1;
               show_mouse(NULL);
               rectfill(screen, d->x, d->y, d->x+d->w, d->y+d->h, d->bg);
               show_mouse(screen);
               int_t1=timertime;

               break;

    }
    return D_O_K;
}
int dummy_proc(int msg,DIALOG *d, int c){
        if(msg==MSG_DRAW){

             return D_O_K;
        }
        return(d_box_proc(msg,d,c));


}


int playpaused=0;


int playbutton_proc(int msg,DIALOG *d, int c){
    int ret;
    ret=d_button_proc(msg,d,c);
    if(ret==D_CLOSE){
            init_trackplay();
            playpaused=0;
            newtime=1;
            play_dialog[PLAYPAUSEBUTTON].flags&=~D_SELECTED;
            pausebutton_proc(MSG_DRAW,&play_dialog[PLAYPAUSEBUTTON],0);

            return D_O_K;
    }

    return ret;

}
int pausebutton_proc(int msg,DIALOG *d, int c){
    int ret,tracknumber;

    if(msg==MSG_CLICK||msg==MSG_KEY){
            if(playpaused){
                  playpaused=0;
                  int_t1=pausetime;
            }
            else{
                 pausetime=int_t1;
                 playpaused=1;
                 for(tracknumber=0;tracknumber<MAXTRACKS;tracknumber++){
                    all_notes_off(trackchannel[tracknumber]);
                 }
            }
    }
    if(msg==MSG_START)
         d->flags &= ~D_SELECTED;
    ret=d_button_proc(msg,d,c);
    return ret;

}

int quitter()
{
   if (alert("Really want to quit?", NULL, NULL, "Yes", "Cancel", 'y', 27) == 1)
      return D_CLOSE;
   else
      return D_O_K;
}


MIDINOTELIST * findmynoteoff(MIDINOTELIST * me,long * dur){
         long accumtime=0L;
         MIDINOTELIST * cur_node=me->next;
         MIDICHANEVENT m=me->m;
         int stat;
         int mychannel=m.status&0x0F,channel;
         int mypitch=m.data1,pitch;
         while(cur_node!=NULL){
                stat=cur_node->m.status&0xF0;
                channel=cur_node->m.status&0x0F;
                accumtime+=cur_node->m.t;
                if(stat==NOTEOFF && channel==mychannel){
                    if(cur_node->m.data1==mypitch){
                              *dur=accumtime;
                              return cur_node;
                    }
                }
                cur_node=cur_node->next;
         }
         return cur_node;
}
int timerx;
int timetox(long t){
    return (TRACKTLX+(TRACKBRX-TRACKTLX)*t/maxcumtime);

}
int track_proc(int msg,DIALOG *d, int c){
   int tracknumber,i;
   long testtime,tracktimezero;
   long cumtime;
   long mydur;
   int cur_track;
   int cur_color;
   DIALOG *dmetro=&play_dialog[PLAYMETRO];
   MIDINOTELIST *cur_node,*mynoteoff;
   MIDICHANEVENT m;


   switch (msg) {
      case MSG_START:
           do_stopmidifile();
           init_trackplay();
           lasttimertime=0L;
           newtime=1;
           playpaused=0;

           play_dialog[PLAYDGTEMPOSLIDER].d2=tempo-10;
           itoa(tempo,tbuf,10);
           for(tracknumber=0;tracknumber<MAXTRACKS;tracknumber++)
                    set_patch(trackchannel[tracknumber],0);
           set_mouse_sprite(NULL);
           break;
      case MSG_END:
           for(tracknumber=0;tracknumber<MAXTRACKS;tracknumber++){
                all_notes_off(trackchannel[tracknumber]);
           }
           set_mouse_sprite(NULL);
           break;
      case MSG_IDLE:
           {
                if(next_node==NULL){

                          return D_O_K;
                }
                if(playpaused) return D_O_K;
                timertime=int_t1;
                if(timertime>=next_event_time){
                  cur_track=next_track;
                  cur_node=next_node;

                  m=cur_node->m;

                  m.status=(m.status& 0xF0)|trackchannel[cur_track];


                  play_chan_event(m);

                  trackcumtime[cur_track]+=m.t;
                  tracknextnode[cur_track]=cur_node->next;

                  /* just say next event is next one on the current track...*/
                  next_node=cur_node->next;
                  if(next_node!=NULL)
                      next_event_time=trackcumtime[cur_track]+next_node->m.t;
                  else next_event_time=maxcumtime;
                  next_track=cur_track;
                  /*... then look for one that should come earlier*/
                  for(tracknumber=0;tracknumber<MAXTRACKS;tracknumber++){
                    if(trackflags[tracknumber]&ACTIVE && tracknextnode[tracknumber]!=NULL){
                       if(tracknumber!=cur_track){
                           testtime=tracknextnode[tracknumber]->m.t+trackcumtime[tracknumber] ;
                           if (testtime<next_event_time || next_node==NULL){
                             next_event_time=testtime;
                             next_track=tracknumber;
                             next_node=tracknextnode[tracknumber];
                           }
                       }
                    }
                  }
                  newtime=1;
                }

           }

           break;
      case MSG_DRAW:
           rect(screen,TRACKTLX-2,TRACKTLY-2,TRACKBRX+2,TRACKBRY+dmetro->h+2,2);
           rectfill(screen,TRACKTLX,TRACKTLY,TRACKBRX,TRACKBRY,d->bg);
           for(tracknumber=0;tracknumber<MAXTRACKS;tracknumber++){
                cur_node=tracklist[tracknumber];
                cumtime=0L;
                while(cur_node!=NULL){
                     m=cur_node->m;
                     cumtime += m.t;
                     if( (m.status&0xF0)==NOTEON){
                        mynoteoff=findmynoteoff(cur_node,&mydur);
                        if(mynoteoff==NULL)
                           putpixel(screen,TRACKTLX+(TRACKBRX-TRACKTLX)*cumtime/maxcumtime,TRACKBRY-2*m.data1,cur_color);
                        else
                           line(screen,TRACKTLX+(TRACKBRX-TRACKTLX)*cumtime/maxcumtime,TRACKBRY-2*m.data1,TRACKTLX+(TRACKBRX-TRACKTLX)*(cumtime+mydur)/maxcumtime,TRACKBRY-2*m.data1,cur_color);
                     }
                     else if( (m.status&0xF0)==PRG_CHG){
                         cur_color=m.data1;
                         if(cur_color>=d->bg)
                            cur_color++;

                     }
                     cur_node=cur_node->next;
                }
           }
           break;
      case MSG_CLICK:

           break;
   }

   return D_O_K;
}



int playdialogsettempo(void *dp3, int d2){
        long holdtimer=int_t1;
        DIALOG * dtext=&play_dialog[PLAYDGTEMPOTEXT];
        play_dialog[PLAYDGTEMPOSLIDER].d2=tempo-10;
        tempo=(long)d2+10;
        itoa(tempo,tbuf,10);


        timertempo(tempo);
        show_mouse(NULL);
        rectfill(screen,dtext->x,dtext->y, dtext->x + dtext->w,dtext->y + dtext->h,dtext->bg);

        d_text_proc(MSG_DRAW,dtext,0);
        show_mouse(screen);
        int_t1=holdtimer;

        return D_O_K;
}

void getvariablelimits(){
   if( curstate.x > maxx ) maxx = curstate.x;
   if( curstate.x < minx ) minx = curstate.x;
   if( curstate.y > maxy ) maxy = curstate.y;
   if( curstate.y < miny ) miny = curstate.y;
   if( curstate.z > maxz ) maxz = curstate.z;
   if( curstate.z < minz ) minz = curstate.z;
   if( curstate.fdirection.x > fmaxx ) fmaxx = curstate.fdirection.x;
   if( curstate.fdirection.x < fminx ) fminx = curstate.fdirection.x;
   if( curstate.fdirection.y > fmaxy ) fmaxy = curstate.fdirection.y;
   if( curstate.fdirection.y < fminy ) fminy = curstate.fdirection.y;
   if( curstate.fdirection.z > fmaxz ) fmaxz = curstate.fdirection.z;
   if( curstate.fdirection.z < fminz ) fminz = curstate.fdirection.z;
   if( curstate.udirection.x > umaxx ) umaxx = curstate.udirection.x;
   if( curstate.udirection.x < uminx ) uminx = curstate.udirection.x;
   if( curstate.udirection.y > umaxy ) umaxy = curstate.udirection.y;
   if( curstate.udirection.y < uminy ) uminy = curstate.udirection.y;
   if( curstate.udirection.z > umaxz ) umaxz = curstate.udirection.z;
   if( curstate.udirection.z < uminz ) uminz = curstate.udirection.z;
   if( curstate.ldirection.x > lmaxx ) lmaxx = curstate.ldirection.x;
   if( curstate.ldirection.x < lminx ) lminx = curstate.ldirection.x;
   if( curstate.ldirection.y > lmaxy ) lmaxy = curstate.ldirection.y;
   if( curstate.ldirection.y < lminy ) lminy = curstate.ldirection.y;
   if( curstate.ldirection.z > lmaxz ) lmaxz = curstate.ldirection.z;
   if( curstate.ldirection.z < lminz ) lminz = curstate.ldirection.z;

   if(curstate.length>maxlength)maxlength=curstate.length;
   if(curstate.length<minlength)minlength=curstate.length;
   if(curdrawlength>maxdrawlength)maxdrawlength=curdrawlength;
   if(curdrawlength<mindrawlength)mindrawlength=curdrawlength;
   if(curstate.thickness>maxthickness)maxthickness=curstate.thickness;
   if(curstate.thickness<minthickness)minthickness=curstate.thickness;
}

#include <signal.h>
volatile int aritherror=0;
void arithmeticerrorhandler(){
    aritherror++;
}
END_OF_FUNCTION(arithmeticerrorhandler);

#define noBUG

char *inptr;
int interpret (int mode){
/*
call interpret(mode) twice:
mode==0 -> just go through and find limits, number of objects, etc.
mode==1 -> actually draw and make midi lists
*/
     int mx,my;
     VECTOR u,v,w;
     VECTOR df,du,dl;
     float x,y,z;
     float dang;
     float length;
     int transpose;
     float dfact,vfact;
     float lscale;
     int clr;
     float maxrandomturn;
     float xturn,yturn,zturn;
     char thischar;
     int inpoly=0;
     int track;
     long holdtime;
     int interpretret=INTERPRETOK;
     LOCK_VARIABLE(aritherror);
     LOCK_FUNCTION(arithmeticerrorhandler);

     signal(SIGFPE, arithmeticerrorhandler);


     df.x = 0; df.y = 1; df.z = 0;
     du.x = 1; du.y = 0; du.z = 0;
     dl.x = 0; dl.y = 0; dl.z = 1;

     curstate.deltaangle=deltaanglerad;
     curstate.x = 0; curstate.y = 0; curstate.z = 0;
     curstate.fdirection = df;curstate.udirection = du; curstate.ldirection = dl;
     curstate.length = 10; curstate.clr = 0; curstate.thickness = thick;
     curstate.track=0;curstate.cumtime=0L;curstate.prevcumtime=0L;
     curstate.transpose=0;   curstate.dfact=1.0; curstate.vfact=1.0;
     curstate.inpoly=0;
     curdrawlength=10;
     maxcumtime=0L;
     stacktop = 0;

     inptr=production;

     curchar = *inptr++;



     while( curchar != '\0'){
        x = curstate.x; y = curstate.y; z = curstate.z;
        switch(curchar){
                 case 'F':
                 case 'f':
                 case 'g':
                        thischar = curchar;
                        length = getfloat();
                        if(length <= 0)
                            length = curstate.length;

                        curstate.x = curstate.x + length * (curstate.fdirection.x);
                        curstate.y = curstate.y + length * (curstate.fdirection.y);
                        curstate.z = curstate.z + length * (curstate.fdirection.z);
                        curdrawlength=length;
                        if(mode == 0){
                                if(thischar == 'F'|| (curstate.inpoly == 1 && thischar != 'g'))  numobjects++;
                        }

                        else if( mode == 1){
                                if(thischar == 'F' || (curstate.inpoly == 1 && thischar != 'g')){
                                     insertpatchandnote(curstate.track);

                                     if(draw_p){
                                        show_mouse(NULL);
                                        if( vw == XY){
                                                virline(screen, x, y,x + length * curstate.fdirection.x, y + length * curstate.fdirection.y, curstate.clr);
                                        }
                                        else if ( vw == ZY){
                                                virline(screen, z, y,z + length * curstate.fdirection.z, y + length * curstate.fdirection.y, curstate.clr);
                                        }
                                        else if ( vw == ZX ){
                                                virline(screen, z, x,z + length * curstate.fdirection.z, x + length * curstate.fdirection.x, curstate.clr);
                                        }
                                        show_mouse(screen);
                                     }

                                }
                                else {
                                    inserttracknote(curstate.track,0);
                                }
                        }
                        break;
                 case 'Z':
                 case 'z':
                        thischar = curchar;
                        length = getfloat();
                        if( length <= 0)
                                length = curstate.length;
                        else length = 2 * length;
                        curdrawlength=length/2;
                        curstate.x = curstate.x + length / 2 * (curstate.fdirection.x);
                        curstate.y = curstate.y + length / 2 * (curstate.fdirection.y);
                        curstate.z = curstate.z + length / 2 * (curstate.fdirection.z);

                        if( mode == 0){
                                if(thischar == 'Z'|| (curstate.inpoly == 1 && thischar != 'g'))  numobjects++;

                        }
                        else if( mode == 1){
                               if(thischar == 'Z' || curstate.inpoly == 1){
                                      insertpatchandnote(curstate.track);

                                      if(draw_p){
                                        show_mouse(NULL);
                                        if( vw == XY){
                                                virline(screen, x, y,x + length/2 * curstate.fdirection.x, y + length/2 * curstate.fdirection.y, curstate.clr);
                                        }
                                        else if ( vw == ZY){
                                                virline(screen,z, y,z + length/2 * curstate.fdirection.z, y + length/2 * curstate.fdirection.y, curstate.clr);
                                        }
                                        else if ( vw == ZX ){
                                                virline(screen,z, x,z + length/2 * curstate.fdirection.z, x + length/2 * curstate.fdirection.x, curstate.clr);
                                        }
                                        show_mouse(screen);
                                      }

                                }
                                else{
                                   inserttracknote(curstate.track,0);
                                }
                        }
                        break;
                 case '$':
                        curchar = *inptr++;
                        if( curstate.fdirection.x != 0 && curstate.fdirection.z != 0){
                                cross(&(curstate.fdirection), &sky, &(curstate.ldirection));
                                cross(&(curstate.fdirection), &(curstate.ldirection),&(curstate.udirection));
                        }
                        break;
                 case '|':
                        curchar = *inptr++;
                        curstate.fdirection.x = -curstate.fdirection.x;
                        curstate.fdirection.y = -curstate.fdirection.y;
                        curstate.fdirection.z = -curstate.fdirection.z;
                        curstate.ldirection.x = -curstate.ldirection.x;
                        curstate.ldirection.y = -curstate.ldirection.y;
                        curstate.ldirection.z = -curstate.ldirection.z;
                        break;
                case '%':
                        curchar = *inptr++;
                        curstate.udirection.x = -curstate.udirection.x;
                        curstate.udirection.y = -curstate.udirection.y;
                        curstate.udirection.z = -curstate.udirection.z;
                        curstate.ldirection.x = -curstate.ldirection.x;
                        curstate.ldirection.y = -curstate.ldirection.y;
                        curstate.ldirection.z = -curstate.ldirection.z;
                        break;
                 case '+':
                        dang = getfloat();
                        if (dang != 0 ){
                                dang = deg2rad(dang);
                                rotate(&(curstate.ldirection), &(curstate.fdirection), &v, dang);
                                curstate.fdirection = v;
                                rotate(&(curstate.ldirection), &(curstate.udirection), &v, dang);
                                curstate.udirection = v;

                        }
                        else{
                                rotate(&(curstate.ldirection), &(curstate.fdirection), &v, curstate.deltaangle);
                                curstate.fdirection = v;
                                rotate(&(curstate.ldirection), &(curstate.udirection), &v, curstate.deltaangle);
                                curstate.udirection = v;
                        }
                        break;
                        
                 case '-':
                        dang = getfloat();
                        if(dang != 0 ){
                                dang = deg2rad(dang);
                                rotate(&(curstate.ldirection), &(curstate.fdirection), &v, -dang);
                                curstate.fdirection = v;
                                rotate(&(curstate.ldirection), &(curstate.udirection), &v, -dang);
                                curstate.udirection = v;
                        }
                        else{
                                rotate(&(curstate.ldirection), &(curstate.fdirection), &v, -curstate.deltaangle);
                                curstate.fdirection = v;
                                rotate(&(curstate.ldirection), &(curstate.udirection), &v, -curstate.deltaangle);
                                curstate.udirection = v;
                        }
                        break;

                 case '&':
                        dang = getfloat();
                        if(dang != 0){
                                dang = deg2rad(dang);
                                rotate(&(curstate.udirection), &(curstate.fdirection), &v, dang);
                                curstate.fdirection = v;
                                rotate(&(curstate.udirection), &(curstate.ldirection), &v, dang);
                                curstate.ldirection = v;
                        }                                
                        else {
                                rotate(&(curstate.udirection), &(curstate.fdirection), &v, curstate.deltaangle);
                                curstate.fdirection = v;
                                rotate(&(curstate.udirection), &(curstate.ldirection), &v, curstate.deltaangle);
                                curstate.ldirection = v;
                        }
                        break;
                 case '^':
                        dang = getfloat();
                        if( dang != 0){
                                dang = deg2rad(dang);
                                rotate(&(curstate.udirection), &(curstate.fdirection), &v, -dang);
                                curstate.fdirection = v;
                                rotate(&(curstate.udirection), &(curstate.ldirection), &v, -dang);
                                curstate.ldirection = v;                                
                        }
                        else{
                                rotate(&(curstate.udirection), &(curstate.fdirection), &v, -curstate.deltaangle);
                                curstate.fdirection = v;
                                rotate(&(curstate.udirection), &(curstate.ldirection), &v, -curstate.deltaangle);
                                curstate.ldirection = v;
                        }
                        break;
                 case '<':
                        dang = getfloat();
                        if(dang != 0 ){
                                dang = deg2rad(dang);
                                rotate(&(curstate.fdirection), &(curstate.ldirection), &v, dang);
                                curstate.ldirection = v;
                                rotate(&(curstate.fdirection), &(curstate.udirection), &v, dang);
                                curstate.udirection = v;

                        }
                        else{
                                rotate(&(curstate.fdirection), &(curstate.ldirection), &v, curstate.deltaangle);
                                curstate.ldirection = v;
                                rotate(&(curstate.fdirection), &(curstate.udirection), &v, curstate.deltaangle);
                                curstate.udirection = v;
                        }
                        break;
                 case '>':
                        dang = getfloat();
                        if(dang != 0 ){
                                dang = deg2rad(dang);
                                rotate(&(curstate.fdirection), &(curstate.ldirection), &v, -dang);
                                curstate.ldirection = v;
                                rotate(&(curstate.fdirection), &(curstate.udirection), &v, -dang);
                                curstate.udirection = v;

                        }
                        else{
                                rotate(&(curstate.fdirection), &(curstate.ldirection), &v, -curstate.deltaangle);
                                curstate.ldirection = v;
                                rotate(&(curstate.fdirection), &(curstate.udirection), &v, -curstate.deltaangle);
                                curstate.udirection = v;
                        }
                        break;
                 case ';':
                        dang = getfloat();
                        if(dang == 0 ) dang = 1 / deflscale;
                        curstate.deltaangle = curstate.deltaangle * dang;
                        /*if(deltaanglerad>TWOPI)deltaanglerad -= TWOPI;*/
                        break;
                 case ':':
                        dang = getfloat();
                        if (dang == 0) dang = deflscale;
                        curstate.deltaangle = curstate.deltaangle * dang;
                        /*if(curstate.deltaangle>TWOPI)curstate.deltaangle -= TWOPI;*/
                        /*if(curstate.deltaangle<FPZERODIF) curstate.deltaangle=TWOPI;*/
                        break;
                 case '[':
                 case '{':

                        if( stacktop >= STACKDEPTH-1){

                                return (INTERPRETSTACKOVERFLOW);
                        }
                        pushstate(curstate);

                        if (curchar == '{'){

                                track=getfloat();
                                if(track>0)
                                    curstate.track=track-1;
                                else{

                                    curstate.track=(curstate.track+1)%MAXTRACKS;
                                }
                                curstate.inpoly = 1;
                        }
                        else {
                          curchar = *inptr++;
                        }


                        break;
                case ']':
                case '}':
                        if(curchar==']')holdtime=curstate.cumtime;
#ifdef STACKUNDERFLOWABORT
                        if(stacktop<0) return(INTERPRETSTACKUNDERFLOW);
#endif

                        curstate = popstate();
                        if(curchar == '}')  /*curstate.inpoly = 0*/;
                        else{
                            curstate.cumtime=holdtime;
                        }
                        curchar = *inptr++;
                        break;
                case '\\':
                        if(timestacktop<STACKDEPTH-1)
                                  pushtime(curstate.cumtime);

                        track=(int)getfloat();

                        if(track>0)
                            curstate.track=track-1;


                        break;

                case '/':
                        curstate.cumtime=poptime();
                        curchar = *inptr++;
                        break;
                case 'c':
                        clr = (int)(getfloat());
                        if( clr > 0)
                                curstate.clr = clr;
                        else curstate.clr = (curstate.clr + 1) % (maxcolor) + 1;
                        break;

                case '*':
                        track=(int)getfloat();

                        if(track>0)
                            curstate.track=track-1;


                        break;
        
                case '\'':
                        lscale = getfloat();
                        if(lscale > 0 )
                                curstate.length = lscale * curstate.length;
                        else
                                curstate.length = deflscale * curstate.length;
                        break;
                case '!':
                        lscale = getfloat();
                        if(lscale > 0)
                                curstate.thickness = lscale * curstate.thickness;
                        else
                                curstate.thickness = .7 * curstate.thickness;
                        break;
                case '?':
                        lscale = getfloat();
                        if(lscale > 0 )
                                curstate.thickness = lscale * curstate.thickness;
                        else
                                curstate.thickness = 1.0 / .7 * curstate.thickness;
                        break;

                case '"':
                        lscale = getfloat();
                        if(lscale > 0 )
                                curstate.length = lscale * curstate.length;
                        else
                                curstate.length = 1.0 / deflscale * curstate.length;
                        break;

                case '~':
                        maxrandomturn = getfloat();
                        maxrandomturn = PI * maxrandomturn / 180.0;
                        if( maxrandomturn > 0){
                                xturn = maxrandomturn - 2 * RND * maxrandomturn;

                                xrot(&(curstate.fdirection), &u, xturn);
                                curstate.fdirection = u;
                                xrot(&(curstate.udirection), &u, xturn);
                                curstate.udirection = u;
                                xrot(&(curstate.ldirection), &u, xturn);
                                curstate.ldirection = u;
                               
                                yturn = maxrandomturn - 2 * RND * maxrandomturn;

                                yrot(&(curstate.fdirection), &u, yturn);
                                curstate.fdirection = u;
                                yrot(&(curstate.udirection), &u, yturn);
                                curstate.udirection = u;
                                yrot(&(curstate.ldirection), &u, yturn);
                                curstate.ldirection = u;

                                zturn = maxrandomturn - 2 * RND * maxrandomturn;

                                zrot(&(curstate.fdirection), &u, zturn);
                                curstate.fdirection = u;
                                zrot(&(curstate.udirection), &u, zturn);
                                curstate.udirection = u;
                                zrot(&(curstate.ldirection), &u, zturn);
                                curstate.ldirection = u;
                        }
                        else{                               

                                xturn = 2 * RND * PI;

                                xrot(&(curstate.fdirection), &u, xturn);
                                curstate.fdirection = u;
                                xrot(&(curstate.udirection), &u, xturn);
                                curstate.udirection = u;
                                xrot(&(curstate.ldirection), &u, xturn);
                                curstate.ldirection = u;
                                yturn = 2 * RND * PI;

                                yrot(&(curstate.fdirection), &u, yturn);
                                curstate.fdirection = u;
                                yrot(&(curstate.udirection), &u, yturn);
                                curstate.udirection = u;
                                yrot(&(curstate.ldirection), &u, yturn);
                                curstate.ldirection = u;
                                zturn = 2 * RND * PI;

                                zrot(&(curstate.fdirection), &u, zturn);
                                curstate.fdirection = u;
                                zrot(&(curstate.udirection), &u, zturn);
                                curstate.udirection = u;
                                zrot(&(curstate.ldirection), &u, zturn);
                                curstate.ldirection = u;
                        }
                        break;
                case 't':
                        transpose=getfloat();
                        curstate.transpose=transpose;
                        break;
                case 'd':
                        dfact=getfloat();
                        if(dfact<=0.0)
                            curstate.dfact=1.0;
                        else{
                            curstate.dfact=dfact;
                        }
                        break;
                case 'v':
                        vfact=getfloat();
                        if(vfact<=0.0)
                            curstate.vfact=1.0;
                        else{
                            curstate.vfact=vfact;
                        }
                        break;

                case 'T':
                        transpose=getfloat();
                        if(transposestack_p){

                            if(transpose==0) curstate.transpose=poptranspose();
                            else{
                              if(transposestacktop<STACKDEPTH-1)
                                  pushtranspose(curstate.transpose);
                              curstate.transpose+=transpose;
                            }
                        }
                        break;
                
                case 'D':
                        dfact=getfloat();
                        if(factstacks){

                            if(dfact<=0.0) curstate.dfact=popdfact();
                            else{
                              if(dfactstacktop<STACKDEPTH-1)
                                  pushdfact(curstate.dfact);
                              curstate.dfact*=dfact;
                            }
                        }
                        break;
                case 'V':
                        vfact=getfloat();
                        if(factstacks){

                            if(vfact<=0.0) curstate.vfact=popvfact();
                            else{
                               if(vfactstacktop<STACKDEPTH-1)
                                  pushvfact(curstate.vfact);
                               curstate.vfact*=vfact;
                            }
                        }
                        break;
                default:
                        curchar = *inptr++;
        }/*end switch*/
        if(mode==0)
               getvariablelimits();
        if(curstate.cumtime>maxcumtime)
               maxcumtime=curstate.cumtime;
        if(aritherror){

                       interpretret=INTERPRETARITHERROR;

                       aritherror=0;

                       signal(SIGFPE, SIG_DFL);
                       return (interpretret);


        }

        if( (keypressed()&&((readkey() >> 8) == KEY_ESC))||(mouse_b&2)){

              interpretret=INTERPRETABORT;
              break;

        }

     }


     signal(SIGFPE, SIG_DFL);

     return (interpretret);
}

float  getfloat(){
        int inparen=0;
        char buf[80]="";
        char *bptr=buf;
        float ret;
        curchar = *inptr++;

        if(curchar == '(' ){
                curchar = *inptr++;
                if( curchar == '-' ||  curchar == '+'){
                /* + and - only allowed if the number is in parentheses
                   since + and - are special lsystem characters*/

                        *bptr=curchar;
                        bptr++;
                        curchar = *inptr++;
                }
                inparen = 1;
        }
        while( (curchar>='0' && curchar<='9') || curchar=='.' || curchar== ')'){

                *bptr = curchar; bptr++;
                curchar = *inptr++;
        }
        ret=atof(buf);
        return ret;

}


char * changefileext(char * origfilename,char * newfilename, char * newext){

        char * extptr;
        if(*origfilename&& origfilename !=NULL){
           strcpy (newfilename,origfilename);
           extptr=get_extension(newfilename);
           *extptr='\0'; /*chop off the extension*/
           strcat(newfilename,newext);
           return (newfilename);
        }
        else return (NULL);
}

int writeparameters2miditext(){
        char textbuf1[612];
        char textbuf2[128];
        long sz;
        int i;

        sprintf (textbuf1,"LMUSe: %s %s: ",get_filename(rulefile), originalmutated?"(mutated)":"");

        sprintf(textbuf2,"recursions=%s, angle=%3.2f, pitch spread=%1.2f, duration spread=%1.2f, velocity spread=%1.2f, ",numrecursestring,deltaangledeg, pspread,dspread,vspread);

        strcat(textbuf1,textbuf2);
        for(i=0;i<3;i++){
           strcat(textbuf1,mapbuf[i]);
           strcat(textbuf1,", ");
        }
        sprintf(textbuf2,"Scale: %s, Scale fn: %s",scalenamestring,scalefnnamestring);
        strcat(textbuf1,textbuf2);
        if(transposestack_p){
              strcat(textbuf1, ", Transpose stack enabled");
        }
        if(factstacks){
              strcat(textbuf1, ", Factor stacks enabled");
        }
        sz=strlen(textbuf1);
        mf_write_meta_event(0L, text_event, textbuf1, sz);

        return 0;
}
int writetracklist (int whichtrack)
{
        static int calls=0;

        MIDINOTELIST * L,* next_node,* first_node;
        MIDICHANEVENT m;
        int n,i,tracknumber;
        unsigned char stat;
        unsigned char channel;
	unsigned char data1[2],data2[2];
	long t,cum_time,holdt=0;
	unsigned char notenumber;
	unsigned char lastprog=-1;

	if(whichtrack==0){
                writeparameters2miditext();
		mf_write_tempo((long)mtempo);
		return(1);
	}

        whichtrack=whichtrack-1;
        n=0;
        for(tracknumber=0;tracknumber<MAXTRACKS;tracknumber++){
             if(trackflags[tracknumber]&ACTIVE){
                  if(n==whichtrack){
                        whichtrack=tracknumber;
                        break;
                  }
                  else n++;
             }

        }
        channel=trackchannel[whichtrack];



        L=tracklist[whichtrack];
        first_node=L;
        next_node=L->next;
        n=0;
        cum_time=0L;
        holdt=0L;
	while( L!=NULL){

               m=L->m;
               t=m.t;
               stat=m.status&0xF0;

               data1[0]=m.data1;
               data1[1]=m.data2;
               if(stat==PRG_CHG){ /*we made lots of extra prg_chg events*/
                     if(lastprog!=data1[0]){
                         mf_write_midi_event(t+holdt,stat,channel,data1 ,1L);
                         lastprog=data1[0];
                         holdt=0L;
                     }
                     else holdt+=t;
               }
               else if(stat==NOTEON||stat==NOTEOFF){
                  mf_write_midi_event(t+holdt, stat, channel, data1, 2L);
                  holdt=0L;
               }
               else holdt+=t; /*some event we are not saving */

               L=L->next;
               n++;


	}
	return n;
}/*end writetracklist()*/
int do_savefiledialog(char * message,char * filenamebuf, char * ext){
/* returns 0 for cancel, returns 1 for continue saving process*/
     int ret,fsret=1,alertret;
     char buf[100];

     while (fsret){
          fsret=popup_file_select(message, filenamebuf, ext);
          if(fsret==0) return 0;
          if(exists(filenamebuf)){
               sprintf(buf, "%s already exists, overwrite?", filenamebuf);
               alertret=alert3(buf, NULL, NULL, "Yes", "No","Cancel", 'y','n', 27) ;
               if(alertret==1) break;
               else if (alertret == 3)
                  return 0;
               else if(alertret==2){
                  fsret=1;
               }
          }
          else fsret=0;
     }
     return(1);
}

int saveproduction_proc(int msg, DIALOG *d, int c){
    int sret;
    int ret=d_button_proc(msg, d, c);
    if(ret==D_CLOSE){
           sret=saveproduction();
           return D_O_K;
    }
    return(ret);
}
int saveproduction(){
        int dret=do_savefiledialog("Save production as:",productionfilename,"out");
        FILE *prod_fp;
        if(dret>0){
              if((prod_fp = fopen(productionfilename,"w")) == 0L)
                  alert("Unable to open file for writing.",NULL,NULL,"OK",NULL,13,0);
              else{
                   fputs(production,prod_fp);
                   fclose(prod_fp);
              }

        }
        return D_O_K;
}
int savemidi_proc(int msg, DIALOG *d, int c){
        int tracknumber;
        long holdt1;
        int sret;
        int ret=d_button_proc(msg, d, c);

        if(ret==D_CLOSE){
           holdt1=int_t1;
           for(tracknumber=0;tracknumber<MAXTRACKS;tracknumber++){

               all_notes_off(trackchannel[tracknumber]);
           }
           sret=savemidi();
           int_t1=holdt1;
           return sret;
        }
        return(ret);
}

int savemidi(){

        int tracknumber;
        int dret;
        int numtracks=0;
        for(tracknumber=0;tracknumber<MAXTRACKS;tracknumber++){
               if(trackflags[tracknumber]&ACTIVE)
                      numtracks++;
               all_notes_off(trackchannel[tracknumber]);
        }
        dret=do_savefiledialog("Save as MIDI file as:", savemfname,"mid");
        if(dret>0){
              if((savemf_fp = fopen(savemfname,"wb")) == 0L)
                  alert("Unable to open file for writing.",NULL,NULL,"OK",NULL,13,0);
              else{
                   Mf_putc = myputc;
                   Mf_writetrack=writetracklist;

                   mfwrite(1,numtracks+1,division,savemf_fp);
                   fclose(savemf_fp);
              }

        }


        return(D_O_K);
}

int do_dosshell(char *filename){

   BITMAP * holdscreen;

   holdscreen=create_bitmap(SCREEN_W,SCREEN_H);
   if(holdscreen!=NULL){
          show_mouse(NULL);
          clear(holdscreen);
          blit(screen,holdscreen,0,0,0,0,SCREEN_W-1,SCREEN_H-1);
          show_mouse(screen);
   }
   allegro_exit();

   system("command");
   allegro_init();
   install_keyboard();
   install_mouse();
   install_timer();

   set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0);

   if(Data1 !=NULL){
      set_palette(Data1[PAL1].dat);
   }
   else
      set_palette(desktop_palette);

   if(holdscreen!=NULL){
       blit(holdscreen,screen,0,0,0,0,SCREEN_W-1,SCREEN_H-1);
       destroy_bitmap(holdscreen);
   }
   else{
       clear(screen);

       rectfill(screen,0,0,SCREEN_W,SCREEN_H,BG1);
   }

   /* install a MIDI sound driver */
   if (install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL)) {
      allegro_exit();
      printf("Error initializing sound system\n%s\n", allegro_error);
      exit(1);
   }
   load_midi_patches();
   set_mouse_speed(1, 1);
   return D_O_K;
}

int do_edit(char *filename){
   BITMAP * holdscreen;
   char commandbuf[200];
   if(!exists(editor)){
        geteditor();
        if(!exists(editor))
            return -1;
   }
   sprintf(commandbuf,"%s ",editor);
   if( *(get_filename(filename)) != '\0' ){
       strcat(commandbuf,filename);
   }

   holdscreen=create_bitmap(SCREEN_W,SCREEN_H);
   if(holdscreen!=NULL){
          show_mouse(NULL);
          clear(holdscreen);
          blit(screen,holdscreen,0,0,0,0,SCREEN_W-1,SCREEN_H-1);
          show_mouse(screen);
   }
   
   allegro_exit();

   system(commandbuf);
   allegro_init();
   install_keyboard();
   install_mouse();
   install_timer();
   /*initrules();*/
   set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0);

   if(Data1 !=NULL){
      set_palette(Data1[PAL1].dat);
   }
   else
      set_palette(desktop_palette);

   if(holdscreen!=NULL){
       blit(holdscreen,screen,0,0,0,0,SCREEN_W-1,SCREEN_H-1);
       destroy_bitmap(holdscreen);
   }
   else{
       clear(screen);

       rectfill(screen,0,0,SCREEN_W,SCREEN_H,BG1);
   }

   /* install a MIDI sound driver */
   if (install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL)) {
      allegro_exit();
      printf("Error initializing sound system\n%s\n", allegro_error);
      exit(1);
   }
   load_midi_patches();
   set_mouse_speed(1, 1);
}
int editrulefile(){
     int ret,makeret;
     int obj;
     char buf1[120];

     if(do_edit(rulefile)==-1) return D_O_K;
     if(*(get_filename(rulefile))!='\0'){
         sprintf(buf1,"Reload %s",get_filename(rulefile));
         ret=alert3("","","",buf1,"Cancel","New Rule File",13,0,'n');
     }
     else{
        ret=alert("","","","Load Rule File","Cancel",13,0);
        if (ret==1) ret=3;
     }
     if(ret==2) return D_O_K;

     production_menu[PRODPLAY].flags |= D_DISABLED;
     production_menu[PRODSAVE].flags |= D_DISABLED;
     production_menu[PRODINTERPREMAP].flags |= D_DISABLED;
     production_menu[PRODINTERP].flags |= D_DISABLED;
     production_menu[PRODREMAKE].flags |= D_DISABLED;
     production_menu[PRODSAVERULES].flags |= D_DISABLED;

     dialog1[PROCPLAYBUT].flags |= D_DISABLED;
     dialog1[PROCSAVEMIDIBUT].flags |= D_DISABLED;
     dialog1[PROCREMAPBUT].flags |= D_DISABLED;
     dialog1[PROCINTERPBUT].flags |= D_DISABLED;
     dialog1[PROCREMAKEBUT].flags |= D_DISABLED;
     dialog1[PROCSAVERULESBUT].flags |= D_DISABLED;

     if(ret==1 && *rulefile!='\0' && rulefile!=NULL){
        getrules(rulefile);
        dialog1[DIALOG1RULES].bg=0;
        dialog_message(&dialog1[DIALOG1RULES], MSG_DRAW, 0,&obj);
        makeret=do_remakeandinterpret();
     }
     else makeret=do_makeandinterpret();
     return makeret;
}

char temprulesname[120]="LMUSEDIT.TMP";
int editrules(){
     int ret,saveret,makeret;
     int obj;
     int i,j,k;
     int maxlevel;
     char *rptr;
     char buf1[120];
     saveret=savetemprulefile();
     if(saveret==-1) return D_O_K;

     if(do_edit(temprulesname)==-1) return D_O_K;



     ret=alert("","","","Use Edited Rules","Cancel",13,0);


     if(ret==2) return D_O_K;

     production_menu[PRODPLAY].flags |= D_DISABLED;
     production_menu[PRODSAVE].flags |= D_DISABLED;
     production_menu[PRODINTERPREMAP].flags |= D_DISABLED;
     production_menu[PRODINTERP].flags |= D_DISABLED;
     /*production_menu[PRODREMAKE].flags |= D_DISABLED;*/


     dialog1[PROCPLAYBUT].flags |= D_DISABLED;
     dialog1[PROCSAVEMIDIBUT].flags |= D_DISABLED;
     dialog1[PROCREMAPBUT].flags |= D_DISABLED;
     dialog1[PROCINTERPBUT].flags |= D_DISABLED;
     /*dialog1[PROCREMAKEBUT].flags |= D_DISABLED;*/

     initrules();
     rulefilefp=fopen(temprulesname,"r");
     if(rulefilefp==NULL){
          alert("file error","","","OK",NULL,13,0);
          return D_O_K;
     }

     maxlevel=readrulefile(rulefilefp);
     unsavedrulechanges=1;
     sprintf(numrecursestring,"%d",maxlevel);
     sprintf(deltaanglestring,"%3.2f",deltaangledeg);
     fclose(rulefilefp);

     sprintf(fileinfo[1],"recursion depth: %d\n", maxlevel);
     sprintf(fileinfo[2],"basic angle:     %3.2f\n", deltaangledeg);
     sprintf(fileinfo[3],"axiom:           %s",axiom);
     sprintf(fileinfo[4],"transformation rules (%d)\n", numrules);

     dialog1[DIALOG1RULES].bg=3;
     dialog_message(&dialog1[DIALOG1RULES], MSG_DRAW, 0,&obj);
        

     makeret=do_remakeandinterpret();
     return makeret;
}




int geteditor(){
     int ret,fsret=1,alertret;
     char buf[100];
     char editorbuf[120];
     strcpy(editorbuf,editor);
     while (fsret){
          fsret=popup_file_select("Use DOS editor:", editorbuf, "exe;com;bat");
          if(fsret==0) return 0;
          if(!exists(editorbuf)){
               sprintf(buf, "Can't find %s", editorbuf);
               alertret=alert3(buf, NULL, NULL, "OK", "Try again","Cancel", 13,'t', 27) ;
               if(alertret==1) return 0;
               else if (alertret == 3)
                  return D_O_K;
               else if(alertret==2){
                  fsret=1;
               }
          }
          else fsret=0;
     }
     strcpy (editor,editorbuf);
     writeconfigfile();
     return D_O_K;
}



char * configfile="lmuse.cfg";
int readconfigfile(){
    FILE *fp;
    fp=fopen(configfile,"r");
    if(fp==NULL) return -1;
    fgets(editor,119,fp);
    fclose(fp);
    return 0;
}
int writeconfigfile(){
    FILE *fp;
    fp=fopen(configfile,"w");
    if(fp==NULL) return -1;
    fputs(editor,fp);
    fclose(fp);
    return 0;

}
int help_about(){

        alert("LMUSe v0, 1998, david sharp","DJGPP, DJ Delorie","Allegro v3.0, Shawn Hargreaves","OK",NULL,13,0);
        return D_O_K;

}
#define FSH 164
#define FSW 308
int popup_file_select(char *message, char *path, char *ext){
          int ret;
          BITMAP *b=create_bitmap(FSW,FSH);
          int xc = (SCREEN_W - FSW) / 2;
          int yc = (SCREEN_H - FSH) / 2;
          if(b!=NULL){
              clear(b);
              show_mouse(NULL);
              blit(screen,b,xc,yc,0,0,FSW-1,FSH-1);
              show_mouse(screen);
          }
          ret=file_select(message,path,ext);
          if(b!=NULL){
              show_mouse(NULL);
              blit(b,screen,0,0,xc,yc,FSW-1,FSH-1);
              show_mouse(screen);
              destroy_bitmap(b);
          }
          return ret;
}

char *help_text=NULL;
DIALOG  help_dialog[] =
{
   { d_box_proc,         30,   30,    430,  360,   255, HELPBG,  0,   0,      0,    0, NULL},
   { d_textbox_proc,     32,   55,    426,  333,   255,  0,      0,   0,      0,    0, NULL},
   { d_button_proc,      35,   35,   20,   16,    255,  0,      27,  D_EXIT, 0,    0,    "X" },

   { NULL,               0,     0,    0,    0,   0,    0,    0,     0,      0,    0,    NULL }
};
#define HELPTEXTBOX 1


int helper(int whichhelp){
   char errbuf[80];
   DATAFILE *helpdata;
   long sz;
   char *hd;
    helpdata=load_datafile("help.dat");
    if (helpdata== 0) {

             alert("Error reading help.dat", NULL, NULL, "Oh well","Curses!", 13, 13);
             return D_O_K;
    }
    hd=helpdata[whichhelp].dat;
    sz=helpdata[whichhelp].size;
    hd[sz-1]='\0';

    help_dialog[HELPTEXTBOX].dp=helpdata[whichhelp].dat;
    help_dialog[HELPTEXTBOX].d2=0;
    centre_dialog(help_dialog);
    popup_dialog(help_dialog,0);
    unload_datafile(helpdata);

    return D_O_K;
}

int symbolshelp(){
   int ret;

   ret=helper(SYMBOLSHELP);
   return ret;
}

int playhelp(){
   int ret;

   ret=helper(PLAYHELP);
   return ret;
}

int lsystemshelp(){
   int ret;

   ret=helper(LSYSHELP);
   return ret;
}

int menushelp(){
   int ret;

   ret=helper(MENUHELP);
   return ret;
}
int scaleshelp(){
   int ret;

   ret=helper(SCALESHELP);
   return ret;
}

int credithelp(){
   int ret;

   ret=helper(CREDITHELP);
   return ret;
}

int fileshelp(){
   int ret;

   ret=helper(FILESHELP);
   return ret;
}
int troublehelp(){
    int ret;

    ret=helper(TROUBLEHELP);
    return ret;
}
int rulefilehelp(){
    int ret;

    ret=helper(RULEFILEHELP);
    return ret;
}
int maphelp(){
    int ret;

    ret=helper(MAPHELP);
    return ret;
}

int instrumentshelp(){
    int ret;

    ret=helper(INSTRUMENTHELP);
    return ret;
}

int helpbutton_proc(int msg, DIALOG *d, int c){
        long holdt1;
        int sret;
        int ret=d_button_proc(msg, d, c);

        if(ret==D_CLOSE){
           holdt1=int_t1;

           sret=playhelp();
           int_t1=holdt1;
           return sret;
        }
        return(ret);
}

DIALOG overview_dialog[]={

   {d_box_proc,      0,   0,   474,  268,   255,  8,       0,   0,      0,   0,   NULL},


   {d_bitmap_proc,   1,   25,  472,  242,  255,  0,       0,   0,      0,   0,   NULL},
   { d_button_proc,  5,   5,   30,   16,   255,  0,       13,  D_EXIT, 0,   0,    "OK" },
   { NULL,           0,   0,    0,    0,    0,    0,       0,   0,      0,   0,    NULL }
};
#define OVERVIEWPIC 1
int overview(){
    DATAFILE *helpdata;
    BITMAP * overviewpic;
    helpdata=load_datafile("help.dat");
    if (helpdata== 0) {

             alert("Error reading help.dat", NULL, NULL, "Oh well","Curses!", 13, 13);
             return D_O_K;
    }

    overviewpic=helpdata[OVERVIEWBMP].dat;
    if(overviewpic){
           overview_dialog[OVERVIEWPIC].dp=overviewpic;
           centre_dialog(overview_dialog);
           popup_dialog(overview_dialog,2);
           destroy_bitmap(overviewpic);
    }
    unload_datafile(helpdata);
    return D_O_K;

}
#define MUTATESUCCESS 1
#define MUTATEFAILED -1
#define NOMUTATION 0
#define MAXMUTATEATTEMPTS 100
int mutaterules(){
        int mutateret,obj;
        int numattempts=0;
        while( (mutateret=L_mutate())==NOMUTATION && numattempts<MAXMUTATEATTEMPTS){
              numattempts++;
        }
        if(mutateret!=MUTATEFAILED)
            mutate_menu[MUTATESAVE].flags &= ~D_DISABLED;
        if(mutateret>0){
             originalmutated=1;
             unsavedrulechanges=1;
             dialog1[DIALOG1RULES].bg=MUTATEDBG;
             dialog_message(&dialog1[DIALOG1RULES], MSG_DRAW, 0,&obj);
        }
        return D_O_K;
}
int mutateandremake(){
        mutaterules();
        return do_remakeandinterpret();

}

FILE * mutatedfp;
#define MAXRULES 100
int savemutation(){
        int i;
        int dret=do_savefiledialog("Save mutated rules as:",mutatefilename,"l;ls;lm");

        if(dret>0){
              if((mutatedfp = fopen(mutatefilename,"w")) == 0L)
                  alert("Unable to open file for writing.",NULL,NULL,"OK",NULL,13,0);
              else{
                   fprintf(mutatedfp,"%s\n",numrecursestring);
                   fprintf(mutatedfp,"%f\n",deltaangledeg);
                   fprintf(mutatedfp,"%f\n",thick);
                   fprintf(mutatedfp,"%s\n",axiom);

                   for (i = 0; i < MAXRULES; i++) {
                       if (rules[i] == NULL)
                       break;
                       fprintf(mutatedfp,"%s\n",rules[i]);
                   }
                   fprintf(mutatedfp,"%c",'@');
                   fclose(mutatedfp);
    
              }

        }
        return D_O_K;
}
int saverulesas(){
        FILE *fp;
        char saverulesname[120];
        int i,obj;
        int dret;
        strcpy(saverulesname,rulefile);
        dret=do_savefiledialog("Save rules as:",saverulesname,"l;ls;lm");

        if(dret>0){
              if((fp = fopen(saverulesname,"w")) == 0L)
                  alert("Unable to open file for writing.",NULL,NULL,"OK",NULL,13,0);
              else{
                   fprintf(fp,"%s\n",numrecursestring);
                   fprintf(fp,"%f\n",deltaangledeg);
                   fprintf(fp,"%f\n",thick);
                   fprintf(fp,"%s\n",axiom);

                   for (i = 0; i < MAXRULES; i++) {
                       if (rules[i] == NULL)
                       break;
                       fprintf(fp,"%s\n",rules[i]);
                   }
                   fprintf(fp,"%c",'@');
                   fclose(fp);

                   strcpy(rulefile,saverulesname);
                   strcpy(rulefilename,get_filename(rulefile));
                   changefileext(rulefile,productionfilename,"out");
                   changefileext(rulefile,savemfname,"mid");
                   changefileext(rulefile,mutatefilename,"lm");
                   changefileext(get_filename(rulefile),productionname,"");
                   dialog1[DIALOG1RULES].bg=0;
                   dialog_message(&dialog1[DIALOG1RULES], MSG_DRAW, 0,&obj);
              }

   
        }
        return D_O_K;
}


int savetemprulefile(){
        FILE *fp;

        int i,obj;



        if((fp = fopen(temprulesname,"w")) == 0L){
                  alert("Unable to open temporary file for writing.",NULL,NULL,"OK",NULL,13,0);
                  return -1;
        }
        else{
                   fprintf(fp,"%s\n",numrecursestring);
                   fprintf(fp,"%f\n",deltaangledeg);
                   fprintf(fp,"%f\n",thick);
                   fprintf(fp,"%s\n",axiom);

                   for (i = 0; i < MAXRULES; i++) {
                       if (rules[i] == NULL)
                       break;
                       fprintf(fp,"%s\n",rules[i]);
                   }
                   fprintf(fp,"%c",'@');
                   fclose(fp);

        }

   

        return 0;
}


DIALOG intro_dialog[]={
/*   (dialog proc)           (x)   (y)   (w)   (h)   (fg)  (bg)   (key) (flags)  (d1)  (d2)  (dp) */

   { d_shadow_box_proc,      0,    0,    149,  139,  255,13,    0,    0,      0,   0,    NULL},
   { d_bitmap_proc,          5,    5,    139,  109,  255,13,    0,    0,      0,   0,    NULL},

   { d_button_proc,          60,   118,  30,   16,   255, 0,     13,  D_EXIT,  0,   0,    "OK" },

   { NULL,              0,    0,   0,    0,    0,    0,       0,    0,      0,   0,    NULL }
};



FILE *playmidifile_fp;
char playmidifilename[120];
MIDI * midifilemidi=NULL;
int do_getmidifiledialog(){
     int ret,fsret=1,alertret;
     char buf[100];
     while (fsret){
          fsret=popup_file_select("MIDI File to play:", playmidifilename, "mid");
          if(fsret==0) return 0;
          if(!exists(playmidifilename)){
               sprintf(buf, "Can't find %s", playmidifilename);
               alertret=alert3(buf, NULL, NULL, "OK", "Try again","Cancel", 13,'t', 27) ;
               if(alertret==1) return 0;
               else if (alertret == 3)
                  return 0;
               else if(alertret==2){
                  fsret=1;
               }
          }
          else fsret=0;
     }

     return(1);
}

int do_playmidifile(){
   if(do_getmidifiledialog()==0){

       return D_O_K;
   }
   midifilemidi=load_midi(playmidifilename);
   if(midifilemidi!=NULL){
      play_midi(midifilemidi,0);
      production_menu[PRODSTOPPLAY].flags&=~D_DISABLED;
   }
   return D_O_K;
}
int do_stopmidifile(){
   if(midifilemidi){
      stop_midi(NULL,0);
      production_menu[PRODSTOPPLAY].flags|=D_DISABLED;
   }
   destroy_midi(midifilemidi);
   midifilemidi=NULL;
   return D_O_K;
}
/*
int writetoproject(FILE *fp,char *rulefname){

        char textbuf[128];
        long sz;
        int i;

        fputs(rulefname,fp);

        fprintf(fp,textbuf,"\n%s\n%f\n%f\n%f\n%f\n",numrecursestring,deltaangledeg, pspread,dspread,vspread);


        for(i=0;i<3;i++){
           fprintf(fp,"%s\n",mapbuf[i]);

        }
        fprintf(fp,"%s\n%s\n",scalenamestring,scalefnnamestring);
        fprintf(fp,"%d\n%d\n",transposestack_p,factstacks);

        return 0;
}
*/

void setup_processbuttons(){


      dialog1[PROCEDITBUT].dp=Data1[EDITBUT].dat;
      dialog1[PROCEDITBUT].dp2=Data1[EDITSEL].dat;
      dialog1[PROCEDITBUT].dp3=Data1[EDITDIS].dat;
      dialog1[PROCEDITRULESBUT].dp=Data1[RULEEDITBUT].dat;
      dialog1[PROCEDITRULESBUT].dp2=Data1[RULEEDITSEL].dat;
      dialog1[PROCEDITRULESBUT].dp3=Data1[RULEEDITDIS].dat;

      dialog1[PROCMAKEBUT].dp=Data1[MAKEBUT].dat;
      dialog1[PROCMAKEBUT].dp2=Data1[MAKESEL].dat;
      dialog1[PROCMAKEBUT].dp3=Data1[MAKEDIS].dat;
      dialog1[PROCMAKEANDBUT].dp=Data1[MAKEANDBUT].dat;
      dialog1[PROCMAKEANDBUT].dp2=Data1[MAKEANDSEL].dat;
      dialog1[PROCMAKEANDBUT].dp3=Data1[MAKEANDDIS].dat;
      dialog1[PROCMUTATEBUT].dp=Data1[MUTATEBUT].dat;
      dialog1[PROCMUTATEBUT].dp2=Data1[MUTATESEL].dat;
      dialog1[PROCMUTATEBUT].dp3=Data1[MUTATEDIS].dat;
      dialog1[PROCMUTANDBUT].dp=Data1[MUTANDBUT].dat;
      dialog1[PROCMUTANDBUT].dp2=Data1[MUTANDSEL].dat;
      dialog1[PROCMUTANDBUT].dp3=Data1[MUTANDDIS].dat;
      dialog1[PROCINTERPBUT].dp=Data1[INTERPBUT].dat;
      dialog1[PROCINTERPBUT].dp2=Data1[INTERPSEL].dat;
      dialog1[PROCINTERPBUT].dp3=Data1[INTERPDIS].dat;
      dialog1[PROCPLAYBUT].dp=Data1[PLAYBUT].dat;
      dialog1[PROCPLAYBUT].dp2=Data1[PLAYSEL].dat;
      dialog1[PROCPLAYBUT].dp3=Data1[PLAYDIS].dat;
      dialog1[PROCQUITBUT].dp=Data1[QUITBUT].dat;
      dialog1[PROCQUITBUT].dp2=Data1[QUITSEL].dat;
      dialog1[PROCQUITBUT].dp3=Data1[QUITDIS].dat;
      dialog1[PROCREMAKEBUT].dp=Data1[REMAKEBUT].dat;
      dialog1[PROCREMAKEBUT].dp2=Data1[REMAKESEL].dat;
      dialog1[PROCREMAKEBUT].dp3=Data1[REMAKEDIS].dat;
      dialog1[PROCREMAPBUT].dp=Data1[REMAPBUT].dat;
      dialog1[PROCREMAPBUT].dp2=Data1[REMAPSEL].dat;
      dialog1[PROCREMAPBUT].dp3=Data1[REMAPDIS].dat;
      dialog1[PROCSAVEMIDIBUT].dp=Data1[SAVEMIDIBUT].dat;
      dialog1[PROCSAVEMIDIBUT].dp2=Data1[SAVEMIDISEL].dat;
      dialog1[PROCSAVEMIDIBUT].dp3=Data1[SAVEMIDIDIS].dat;
      dialog1[PROCSAVERULESBUT].dp=Data1[SAVERULESBUT].dat;
      dialog1[PROCSAVERULESBUT].dp2=Data1[SAVERULESSEL].dat;
      dialog1[PROCSAVERULESBUT].dp3=Data1[SAVERULESDIS].dat;

}
/*
int buttonflags[PROCQUITBUT+1-PROCMAKEBUT];
void disablebuttons(){
     int i;

     for (i=PROCMAKEBUT;i<=PROCQUITBUT;i++){

          buttonflags[i-PROCMAKEBUT]=dialog1[i].flags;
          dialog1[i].flags|=D_DISABLED;
     }
     redrawbuttons();
}
void reenablebuttons(){
     int i;

     for (i=PROCMAKEBUT;i<=PROCQUITBUT;i++){

          dialog1[i].flags=buttonflags[i-PROCMAKEBUT];
     }

     redrawbuttons();
}
*/
/*
int tile_proc(int msg, DIALOG *d, int c){
   BITMAP *tile;
   int nw,nh;
   int tw;
   int th;
   int i,j;
   if(msg==MSG_DRAW){
      tw=d->d1; th=d->d2;
      tile=(BITMAP *)d->dp;
      nw=1+(d->w)/tw;
      nh=1+(d->h)/th;
      for(i=0;i<nw;i++){
        for(j=0;j<nh;j++){
           blit(tile,screen,0,0,d->x+i*tw,d->y+j*th,tw,th);

        }
        blit(tile,screen,0,0,d->x+i*tw,d->y+nh*th,tw,d->h-nh*th);
      }
      for(j=0;j<nh;j++){
        blit(tile,screen,0,0,d->x+nw*tw,d->y+j*th,d->w-nw*tw,th);

      }

   }

   return D_O_K;

}
*/

