/* This file may have been modified by DJ Delorie (Jan 1991).  If so,
** these modifications are Coyright (C) 1991 DJ Delorie, 24 Kirsten Ave,
** Rochester NH, 03867-2954, USA.
*/
   
#ifndef _ctype_h
#define _ctype_h
   
#define _U 01
#define _L 02
#define _N 04
#define _S 010
#define _P 020
#define _C 040
#define _X 0100
#define _B 0200

#ifdef __cplusplus
extern "C" {
#endif
  
extern  char      _ctype_[];

extern int (isalnum) (int);
extern int (isalpha) (int);
extern int (iscntrl) (int);
extern int (isdigit) (int);
extern int (isgraph) (int);
extern int (islower) (int);
extern int (ispunct) (int);
extern int (isspace) (int);
extern int (isupper) (int);
extern int (isxdigit) (int);
extern int (tolower) (int);
extern int (toupper) (int);
   
#define isalpha(c)  ((_ctype_+1)[c]&(_U|_L))
#define isupper(c)  ((_ctype_+1)[c]&_U)
#define islower(c)  ((_ctype_+1)[c]&_L)
#define isdigit(c)  ((_ctype_+1)[c]&_N)
#define isxdigit(c) ((_ctype_+1)[c]&(_X|_N))
#define isspace(c)  ((_ctype_+1)[c]&_S)
#define ispunct(c)  ((_ctype_+1)[c]&_P)
#define isalnum(c)  ((_ctype_+1)[c]&(_U|_L|_N))
#define isprint(c)  ((_ctype_+1)[c]&(_P|_U|_L|_N|_B))
#define isgraph(c)  ((_ctype_+1)[c]&(_P|_U|_L|_N))
#define iscntrl(c)  ((_ctype_+1)[c]&_C)
#define isascii(c)  ((unsigned)(c)<=0177)

#if defined(__cplusplus) && defined(__STRICT_ANSI__)
/* When compiling as C++ and -ansi, use inline functions to avoid
   "ANSI C++ forbids braced-groups within expressions" warnings. */
inline int toupper(int _c) { return(islower(_c) ? (_c-'a'+'A') : _c); }
inline int tolower(int _c) { return(isupper(_c) ? (_c-'A'+'a') : _c); }
#else
#define toupper(c)  ({int _c=(c); islower(_c) ? (_c-'a'+'A') : _c; })
#define tolower(c)  ({int _c=(c); isupper(_c) ? (_c-'A'+'a') : _c; })
#endif

#define toascii(c)  ((c)&0177)

#ifdef __cplusplus
}
#endif

#endif /* _ctype_h */
